/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.ExternalizableGraphElement;
import org.jetbrains.jps.dependency.FactoredExternalizableGraphElement;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.impl.RW;

public class GraphDataOutputImpl
implements GraphDataOutput {
    private final DataOutput myDelegate;

    public GraphDataOutputImpl(DataOutput delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void write(int b) throws IOException {
        this.myDelegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.myDelegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myDelegate.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.myDelegate.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.myDelegate.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.myDelegate.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.myDelegate.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (0 > v || v >= 192) {
            this.myDelegate.writeByte(192 + (v & 0x3F));
            v >>>= 6;
            while (v >= 128) {
                this.myDelegate.writeByte(v & 0x7F | 0x80);
                v >>>= 7;
            }
        }
        this.myDelegate.writeByte(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (0L > v || v >= 192L) {
            this.myDelegate.writeByte(192 + (int)(v & 0x3FL));
            v >>>= 6;
            while (v >= 128L) {
                this.myDelegate.writeByte((int)(v & 0x7FL) | 0x80);
                v >>>= 7;
            }
        }
        this.myDelegate.writeByte((int)v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.myDelegate.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.myDelegate.writeDouble(v);
    }

    @Override
    public void writeBytes(@NotNull String s) throws IOException {
        if (s == null) {
            GraphDataOutputImpl.$$$reportNull$$$0(0);
        }
        this.myDelegate.writeBytes(s);
    }

    @Override
    public void writeChars(@NotNull String s) throws IOException {
        if (s == null) {
            GraphDataOutputImpl.$$$reportNull$$$0(1);
        }
        this.myDelegate.writeChars(s);
    }

    @Override
    public void writeUTF(@NotNull String s) throws IOException {
        if (s == null) {
            GraphDataOutputImpl.$$$reportNull$$$0(2);
        }
        RW.writeUTF(this.myDelegate, s);
    }

    @Override
    public <T extends ExternalizableGraphElement> void writeGraphElement(@NotNull T elem) throws IOException {
        if (elem == null) {
            GraphDataOutputImpl.$$$reportNull$$$0(3);
        }
        this.writeUTF(elem.getClass().getName());
        if (elem instanceof FactoredExternalizableGraphElement) {
            this.writeGraphElement((T)((FactoredExternalizableGraphElement)elem).getFactorData());
        }
        elem.write(this);
    }

    @Override
    public <T extends ExternalizableGraphElement> void writeGraphElementCollection(Class<? extends T> elemType, @NotNull Iterable<T> col) throws IOException {
        if (col == null) {
            GraphDataOutputImpl.$$$reportNull$$$0(4);
        }
        this.writeUTF(elemType.getName());
        if (FactoredExternalizableGraphElement.class.isAssignableFrom(elemType)) {
            HashMap<ExternalizableGraphElement, List> elemGroups = new HashMap<ExternalizableGraphElement, List>();
            for (ExternalizableGraphElement externalizableGraphElement : col) {
                FactoredExternalizableGraphElement fe = (FactoredExternalizableGraphElement)externalizableGraphElement;
                elemGroups.computeIfAbsent((ExternalizableGraphElement)fe.getFactorData(), k -> new ArrayList()).add(fe);
            }
            this.writeInt(elemGroups.size());
            for (final Map.Entry entry : elemGroups.entrySet()) {
                RW.writeCollection(this, (Iterable)entry.getValue(), new RW.Writer<FactoredExternalizableGraphElement<?>>(){
                    private boolean commonPartWritten;

                    @Override
                    public void write(FactoredExternalizableGraphElement<?> elem) throws IOException {
                        if (!this.commonPartWritten) {
                            this.commonPartWritten = true;
                            GraphDataOutputImpl.this.writeGraphElement((ExternalizableGraphElement)entry.getKey());
                        }
                        elem.write(GraphDataOutputImpl.this);
                    }
                });
            }
        } else {
            RW.writeCollection(this, col, elem -> elem.write(this));
        }
    }

    public static GraphDataOutput wrap(DataOutput out) {
        return out instanceof GraphDataOutput ? (GraphDataOutput)out : new GraphDataOutputImpl(out);
    }

    public static GraphDataOutput wrap(DataOutput out, final @Nullable StringEnumerator enumerator) {
        return enumerator == null ? GraphDataOutputImpl.wrap(out) : new GraphDataOutputImpl(out){

            @Override
            public void writeUTF(@NotNull String s) throws IOException {
                if (s == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.writeInt(enumerator.toNumber(s));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/jps/dependency/impl/GraphDataOutputImpl$2", "writeUTF"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/dependency/impl/GraphDataOutputImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBytes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeChars";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeUTF";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeGraphElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeGraphElementCollection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface StringEnumerator {
        public int toNumber(String var1) throws IOException;
    }
}

