/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.ui.component.AbstractProjectBrowseFileField;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.gui.ChangeLogField;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.jgoodies.binding.beans.Model;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001<B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00106\u001a\u00020\u0003H\u0016J\u0010\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020\u00032\u0006\u00109\u001a\u00020:R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\u0005R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u0005R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\u0005R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006="}, d2={"Lcom/intellij/liquibase/common/gui/ChangeLogModel;", "Lcom/jgoodies/binding/beans/Model;", "fileName", "", "<init>", "(Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "setFileName", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "setModule", "(Lcom/intellij/openapi/module/Module;)V", "directory", "getDirectory", "setDirectory", "includeChangeLogPath", "getIncludeChangeLogPath", "setIncludeChangeLogPath", "includeContext", "getIncludeContext", "setIncludeContext", "includeAsFolder", "", "getIncludeAsFolder", "()Z", "setIncludeAsFolder", "(Z)V", "fileType", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "getFileType", "()Lcom/intellij/liquibase/common/LiquibaseFileType;", "setFileType", "(Lcom/intellij/liquibase/common/LiquibaseFileType;)V", "saveType", "Lcom/intellij/liquibase/common/gui/ChangeLogModel$SaveType;", "getSaveType", "()Lcom/intellij/liquibase/common/gui/ChangeLogModel$SaveType;", "setSaveType", "(Lcom/intellij/liquibase/common/gui/ChangeLogModel$SaveType;)V", "dbConnection", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "getDbConnection", "()Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "setDbConnection", "(Lcom/intellij/jpa/jpb/model/core/model/DataStore;)V", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "getDbType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "setDbType", "(Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;)V", "toString", "getIncludeChangeLogFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getDirectoryAbsolutePath", "SaveType", "intellij.liquibase.common"})
public final class ChangeLogModel
extends Model {
    @NotNull
    private String fileName;
    @Nullable
    private Module module;
    @NotNull
    private String directory;
    @Nullable
    private String includeChangeLogPath;
    @Nullable
    private String includeContext;
    private boolean includeAsFolder;
    @Nullable
    private LiquibaseFileType fileType;
    @NotNull
    private SaveType saveType;
    @Nullable
    private DataStore dbConnection;
    @Nullable
    private DbType dbType;

    public ChangeLogModel(@NlsSafe @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.directory = "";
        this.saveType = SaveType.File;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileName = string;
    }

    @Nullable
    public final Module getModule() {
        return this.module;
    }

    public final void setModule(@Nullable Module module) {
        this.module = module;
    }

    @NotNull
    public final String getDirectory() {
        return this.directory;
    }

    public final void setDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.directory = string;
    }

    @Nullable
    public final String getIncludeChangeLogPath() {
        return this.includeChangeLogPath;
    }

    public final void setIncludeChangeLogPath(@Nullable String string) {
        this.includeChangeLogPath = string;
    }

    @Nullable
    public final String getIncludeContext() {
        return this.includeContext;
    }

    public final void setIncludeContext(@Nullable String string) {
        this.includeContext = string;
    }

    public final boolean getIncludeAsFolder() {
        return this.includeAsFolder;
    }

    public final void setIncludeAsFolder(boolean bl) {
        this.includeAsFolder = bl;
    }

    @Nullable
    public final LiquibaseFileType getFileType() {
        return this.fileType;
    }

    public final void setFileType(@Nullable LiquibaseFileType liquibaseFileType) {
        this.fileType = liquibaseFileType;
    }

    @NotNull
    public final SaveType getSaveType() {
        return this.saveType;
    }

    public final void setSaveType(@NotNull SaveType saveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)saveType), (String)"<set-?>");
        this.saveType = saveType;
    }

    @Nullable
    public final DataStore getDbConnection() {
        return this.dbConnection;
    }

    public final void setDbConnection(@Nullable DataStore dataStore) {
        this.dbConnection = dataStore;
    }

    @Nullable
    public final DbType getDbType() {
        return this.dbType;
    }

    public final void setDbType(@Nullable DbType dbType) {
        this.dbType = dbType;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getSimpleName() + "(" + this.fileName + ")";
    }

    @Nullable
    public final PsiFile getIncludeChangeLogFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CharSequence charSequence = this.includeChangeLogPath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String string = this.includeChangeLogPath;
        Intrinsics.checkNotNull((Object)string);
        return ChangeLogField.Companion.getChangeLogFile$default(ChangeLogField.Companion, project, string, null, 4, null);
    }

    @NotNull
    public final String getDirectoryAbsolutePath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.saveType == SaveType.Scratch) {
            ScratchFileService scratchFileService = ScratchFileService.getInstance();
            ScratchRootType scratchRootType = ScratchRootType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)scratchRootType, (String)"getInstance(...)");
            ScratchRootType scratchRootType2 = scratchRootType;
            String string = scratchFileService.getRootPath((RootType)scratchRootType2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootPath(...)");
            return string;
        }
        return AbstractProjectBrowseFileField.Companion.getAbsolutePath(project, this.module, this.directory);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/common/gui/ChangeLogModel$SaveType;", "", "<init>", "(Ljava/lang/String;I)V", "File", "Scratch", "Clipboard", "DatabaseConsole", "toString", "", "intellij.liquibase.common"})
    public static final class SaveType
    extends Enum<SaveType> {
        public static final /* enum */ SaveType File = new SaveType();
        public static final /* enum */ SaveType Scratch = new SaveType();
        public static final /* enum */ SaveType Clipboard = new SaveType();
        public static final /* enum */ SaveType DatabaseConsole = new SaveType();
        private static final /* synthetic */ SaveType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String toString() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> "Scratch File";
                case 2 -> "Database Console";
                default -> this.name();
            };
        }

        public static SaveType[] values() {
            return (SaveType[])$VALUES.clone();
        }

        public static SaveType valueOf(String value) {
            return Enum.valueOf(SaveType.class, value);
        }

        @NotNull
        public static EnumEntries<SaveType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = saveTypeArray = new SaveType[]{SaveType.File, SaveType.Scratch, SaveType.Clipboard, SaveType.DatabaseConsole};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SaveType.values().length];
                try {
                    nArray[SaveType.Scratch.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SaveType.DatabaseConsole.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

