/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.httpServices;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiPackage;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScanArchetype;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeMapping;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ImportHttpServices
extends SpringJamComponentScanArchetype {
    private static final JamClassAttributeMeta.Collection TYPES_ATTR_META = new JamClassAttributeMeta.Collection("types");
    private static final JamClassAttributeMeta.Collection VALUE_ATTR_META = new JamClassAttributeMeta.Collection("value");
    public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.web.service.registry.ImportHttpServices", ARCHETYPE, META_KEY).addAttribute((JamAttributeMeta)TYPES_ATTR_META).addAttribute((JamAttributeMeta)VALUE_ATTR_META);
    public static final SemKey<ImportHttpServices> JAM_KEY = COMPONENT_SCAN_JAM_KEY.subKey("ImportHttpServices", new SemKey[0]);
    public static final SemKey<ImportHttpServices> REPEATABLE_JAM_KEY = REPEATABLE_ANNO_JAM_KEY.subKey("ImportHttpServices", new SemKey[0]);
    public static final JamClassMeta<ImportHttpServices> META = new JamClassMeta(null, ImportHttpServices::new, JAM_KEY).addAnnotation(ANNOTATION_META);

    public ImportHttpServices(@NotNull PsiElementRef<?> psiRef) {
        if (psiRef == null) {
            ImportHttpServices.$$$reportNull$$$0(0);
        }
        super(psiRef);
    }

    public ImportHttpServices(PsiAnnotation annotation) {
        super(annotation);
    }

    @NotNull
    protected JamAnnotationMeta getAnnotationMeta() {
        JamAnnotationMeta jamAnnotationMeta = ANNOTATION_META;
        if (jamAnnotationMeta == null) {
            ImportHttpServices.$$$reportNull$$$0(1);
        }
        return jamAnnotationMeta;
    }

    @NotNull
    protected Set<CommonSpringBean> getScannedBeans(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            ImportHttpServices.$$$reportNull$$$0(2);
        }
        return this.getHttpServices(module, includeTests);
    }

    @NotNull
    private Set<CommonSpringBean> getHttpServices(@NotNull Module module, boolean tests) {
        if (module == null) {
            ImportHttpServices.$$$reportNull$$$0(3);
        }
        HashSet<PsiClass> services = new HashSet<PsiClass>();
        for (PsiPackage psiPackage : this.getPsiPackages()) {
            PsiClass[] classes = psiPackage.getClasses(SpringGlobalSearchScopes.runtime((Module)module, (boolean)tests));
            services.addAll(Arrays.stream(classes).filter(aClass -> this.isHttpServiceInterface((PsiClass)aClass)).toList());
        }
        services.addAll(this.getExplicitTypes());
        Set set = ContainerUtil.map2Set(services, aClass -> new SpringImplicitBean("ImportHttpServices", aClass, ImportHttpServices.getBeanName(aClass)));
        if (set == null) {
            ImportHttpServices.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static String getBeanName(@NotNull PsiClass aClass) {
        String name;
        if (aClass == null) {
            ImportHttpServices.$$$reportNull$$$0(5);
        }
        String string = StringUtil.isEmptyOrSpaces((String)(name = aClass.getName())) ? "httpService" : StringUtil.decapitalize((String)name);
        if (string == null) {
            ImportHttpServices.$$$reportNull$$$0(6);
        }
        return string;
    }

    private boolean isHttpServiceInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ImportHttpServices.$$$reportNull$$$0(7);
        }
        return aClass.isInterface() && this.hasExchangeMethods(aClass);
    }

    private boolean hasExchangeMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ImportHttpServices.$$$reportNull$$$0(8);
        }
        return !JamService.getJamService((Project)aClass.getProject()).getAnnotatedMembersList(aClass, SpringExchangeMapping.MAPPING_JAM_KEY, 2).isEmpty();
    }

    @NotNull
    public List<PsiClass> getExplicitTypes() {
        SmartList imported = new SmartList();
        for (JamClassAttributeElement jamClassAttributeElement : TYPES_ATTR_META.getJam(this.getAnnotationRef())) {
            ContainerUtil.addIfNotNull((Collection)imported, (Object)jamClassAttributeElement.getValue());
        }
        for (JamClassAttributeElement jamClassAttributeElement : VALUE_ATTR_META.getJam(this.getAnnotationRef())) {
            ContainerUtil.addIfNotNull((Collection)imported, (Object)jamClassAttributeElement.getValue());
        }
        SmartList smartList = imported;
        if (smartList == null) {
            ImportHttpServices.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRef";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/webClient/httpServices/ImportHttpServices";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/webClient/httpServices/ImportHttpServices";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationMeta";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpServices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScannedBeans";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHttpServices";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBeanName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHttpServiceInterface";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasExchangeMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 9 -> new IllegalStateException(string);
        };
    }
}

