/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restOperations;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.mvc.webClient.restOperations.RestOperation;
import com.intellij.spring.mvc.webClient.restOperations.RestOperationsConstants;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\u001cH\u0002JG\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000b\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b#2\u0006\u0010\u0019\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\u001cH\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/spring/mvc/webClient/restOperations/RestOperationsUtils;", "", "<init>", "()V", "isRestOperationsAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "isTestRestTemplateAvailable", "module", "Lcom/intellij/openapi/module/Module;", "getRestOperationsMethods", "", "Lcom/intellij/psi/PsiMethod;", "getTestRestTemplateMethods", "getRestOperationsApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "getTestRestTemplateApiClasses", "findRestOperationsApiClasses", "restOperationsSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findTestRestTemplateApiClasses", "findRestOperationsUrlMethods", "apiSearchScope", "findTestRestTemplateUrlMethods", "stringReceiver", "Lkotlin/Function1;", "addMethods", "", "javaPsiFacade", "Lcom/intellij/psi/JavaPsiFacade;", "restOperations", "", "Lorg/jetbrains/annotations/NonNls;", "methods", "", "stringReceiverMethod", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nRestOperationsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestOperationsUtils.kt\ncom/intellij/spring/mvc/webClient/restOperations/RestOperationsUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,121:1\n3919#2:122\n4434#2,2:123\n*S KotlinDebug\n*F\n+ 1 RestOperationsUtils.kt\ncom/intellij/spring/mvc/webClient/restOperations/RestOperationsUtils\n*L\n117#1:122\n117#1:123,2\n*E\n"})
public final class RestOperationsUtils {
    @NotNull
    public static final RestOperationsUtils INSTANCE = new RestOperationsUtils();

    private RestOperationsUtils() {
    }

    @JvmStatic
    public static final boolean isRestOperationsAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.web.client.RestOperations") || JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.web.client.AsyncRestOperations");
    }

    @JvmStatic
    public static final boolean isTestRestTemplateAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.boot.test.web.client.TestRestTemplate");
    }

    @JvmStatic
    public static final boolean isTestRestTemplateAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.boot.test.web.client.TestRestTemplate");
    }

    @JvmStatic
    public static final boolean isRestOperationsAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.web.client.RestOperations") || JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.web.client.AsyncRestOperations");
    }

    @NotNull
    public final List<PsiMethod> getRestOperationsMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> RestOperationsUtils.getRestOperationsMethods$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public final List<PsiMethod> getTestRestTemplateMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> RestOperationsUtils.getTestRestTemplateMethods$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public final List<PsiClass> getRestOperationsApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(() -> RestOperationsUtils.getRestOperationsApiClasses$lambda$0(query));
    }

    @NotNull
    public final List<PsiClass> getTestRestTemplateApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(() -> RestOperationsUtils.getTestRestTemplateApiClasses$lambda$0(query));
    }

    private final List<PsiClass> findRestOperationsApiClasses(Project project, GlobalSearchScope restOperationsSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)javaPsiFacade.findClasses("org.springframework.web.client.RestOperations", restOperationsSearchScope));
        spreadBuilder.addSpread((Object)javaPsiFacade.findClasses("org.springframework.web.client.AsyncRestOperations", restOperationsSearchScope));
        return CollectionsKt.mutableListOf((Object[])spreadBuilder.toArray((Object[])new PsiClass[spreadBuilder.size()]));
    }

    private final List<PsiClass> findTestRestTemplateApiClasses(Project project, GlobalSearchScope restOperationsSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses("org.springframework.boot.test.web.client.TestRestTemplate", restOperationsSearchScope);
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length));
    }

    private final List<PsiMethod> findRestOperationsUrlMethods(Project project, GlobalSearchScope apiSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        List methods = new ArrayList();
        Intrinsics.checkNotNull((Object)javaPsiFacade);
        this.addMethods(javaPsiFacade, "org.springframework.web.client.RestOperations", apiSearchScope, methods, this.stringReceiver());
        this.addMethods(javaPsiFacade, "org.springframework.web.client.AsyncRestOperations", apiSearchScope, methods, this.stringReceiver());
        return methods;
    }

    private final List<PsiMethod> findTestRestTemplateUrlMethods(Project project, GlobalSearchScope apiSearchScope) {
        List methods = new ArrayList();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"getInstance(...)");
        this.addMethods(javaPsiFacade, "org.springframework.boot.test.web.client.TestRestTemplate", apiSearchScope, methods, this.stringReceiver());
        return methods;
    }

    private final Function1<PsiMethod, Boolean> stringReceiver() {
        return RestOperationsUtils::stringReceiver$lambda$0;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMethods(JavaPsiFacade javaPsiFacade, String restOperations, GlobalSearchScope apiSearchScope, List<PsiMethod> methods, Function1<? super PsiMethod, Boolean> stringReceiverMethod) {
        PsiClass[] psiClassArray = javaPsiFacade.findClasses(restOperations, apiSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"findClasses(...)");
        for (PsiClass httpUrlClass : psiClassArray) {
            for (RestOperation restOperationsMethod : RestOperationsConstants.INSTANCE.getREST_OPERATIONS_METHODS()) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                PsiMethod[] psiMethodArray = httpUrlClass.findMethodsByName(restOperationsMethod.getMethod(), true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
                Object[] objectArray = psiMethodArray;
                List<PsiMethod> list = methods;
                boolean $i$f$filter = false;
                void var14_14 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)stringReceiverMethod.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list.addAll((List)destination$iv$iv);
            }
        }
    }

    private static final CachedValueProvider.Result getRestOperationsMethods$lambda$0(Project $project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        List<PsiMethod> methods = INSTANCE.findRestOperationsUrlMethods($project, globalSearchScope);
        return CachedValueProvider.Result.createSingleDependency(methods, (Object)JavaLibraryModificationTracker.getInstance((Project)$project));
    }

    private static final CachedValueProvider.Result getTestRestTemplateMethods$lambda$0(Project $project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        List<PsiMethod> methods = INSTANCE.findTestRestTemplateUrlMethods($project, globalSearchScope);
        return CachedValueProvider.Result.createSingleDependency(methods, (Object)JavaLibraryModificationTracker.getInstance((Project)$project));
    }

    private static final CachedValueProvider.Result getRestOperationsApiClasses$lambda$0(ScopedCacheValueHolder $query) {
        List<PsiClass> classes = INSTANCE.findRestOperationsApiClasses($query.getProject(), $query.getApiSearchScope());
        return CachedValueProvider.Result.createSingleDependency(classes, (Object)JavaLibraryModificationTracker.getInstance((Project)$query.getProject()));
    }

    private static final CachedValueProvider.Result getTestRestTemplateApiClasses$lambda$0(ScopedCacheValueHolder $query) {
        List<PsiClass> classes = INSTANCE.findTestRestTemplateApiClasses($query.getProject(), $query.getApiSearchScope());
        return CachedValueProvider.Result.createSingleDependency(classes, (Object)JavaLibraryModificationTracker.getInstance((Project)$query.getProject()));
    }

    private static final boolean stringReceiver$lambda$0(PsiMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.hasParameters() && TypeUtils.isJavaLangString((PsiType)it.getParameterList().getParameters()[0].getType());
    }
}

