/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlReferencesInspection
extends VtlInspectionBase {
    public static final String SHORT_NAME = "VtlReferencesInspection";
    public boolean fieldsExposed = false;

    private static boolean isInsideLiteralDirective(PsiElement element) {
        while (element != null) {
            if (element instanceof VtlDirective && "literal".equals(((VtlDirective)element).getPresentableName())) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        boolean resolvedWithError;
        VtlReferenceExpression ref;
        block9: {
            block8: {
                if (!(element instanceof VtlReferenceExpression)) break block8;
                ref = (VtlReferenceExpression)element;
                if (!VtlReferencesInspection.isInsideLiteralDirective(element)) break block9;
            }
            return;
        }
        if (!ref.isQualifierResolved()) {
            return;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof VtlFile && ((VtlFile)file).isIdeTemplateFile()) {
            return;
        }
        if (!(ref instanceof PsiPolyVariantReference)) {
            return;
        }
        PsiPolyVariantReference psiReference = (PsiPolyVariantReference)ref;
        ResolveResult[] results = psiReference.multiResolve(false);
        boolean bl = resolvedWithError = results.length > 0 && !results[0].isValidResult();
        if (resolvedWithError || ref.resolve() == null) {
            String message = ref.getUnresolvedMessage(resolvedWithError);
            if (message == null) {
                return;
            }
            holder.registerProblem((PsiReference)psiReference, message, resolvedWithError ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"fieldsExposed", (String)VelocityBundle.message("reference.inspection.cb.public.fields.are.exposed", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            VtlReferencesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/VtlReferencesInspection", "getOptionsPane"));
    }
}

