/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.java.VtlJavaUtil;
import com.intellij.velocity.java.reference.VtlPsiType;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlLoopVariable;
import com.intellij.velocity.psi.VtlOperatorExpression;
import com.intellij.velocity.psi.VtlRangeExpression;
import org.jetbrains.annotations.Nullable;

public final class VtlTypesInspection
extends VtlInspectionBase {
    private static void checkRangeBound(PsiElement element, ProblemsHolder holder, @Nullable VtlExpression bound) {
        if (bound == null) {
            return;
        }
        PsiType type = VtlPsiType.extract(bound.getPsiType());
        if (type == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiType)VtlJavaUtil.getBoxedType(type, element), (String)"java.lang.Integer")) {
            holder.registerProblem((PsiElement)bound, VelocityBundle.message("type.inspection.range.bound.should.be.integer", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        if (element instanceof VtlOperatorExpression) {
            VtlOperatorExpression expression = (VtlOperatorExpression)element;
            if (expression.getPsiType() != null) {
                return;
            }
            String message = expression.getIndefiniteTypeMessage();
            if (message != null) {
                holder.registerProblem((PsiElement)expression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        } else if (element instanceof VtlLoopVariable) {
            VtlLoopVariable loopVariable = (VtlLoopVariable)element;
            if (loopVariable.getPsiType() != null) {
                return;
            }
            VtlExpression expression = loopVariable.getIterableExpression();
            if (expression == null) {
                return;
            }
            PsiType type = VtlPsiType.extract(expression.getPsiType());
            if (type == null) {
                return;
            }
            String typeName = VtlJavaUtil.getPresentableText(type);
            holder.registerProblem((PsiElement)expression, VelocityBundle.message("illegal.iterable.expression.type", typeName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (element instanceof VtlRangeExpression) {
            VtlTypesInspection.checkRangeBound(element, holder, ((VtlRangeExpression)element).getLowerBound());
            VtlTypesInspection.checkRangeBound(element, holder, ((VtlRangeExpression)element).getUpperBound());
        }
    }
}

