/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlReferenceContributor;
import com.intellij.velocity.java.reference.JavaVtlReferenceContributor;
import com.intellij.velocity.java.reference.VtlPsiType;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlVariableType;
import com.intellij.velocity.psi.files.VtlFile;
import org.jetbrains.annotations.NotNull;

class VtlVariableTypeAnnotator
implements Annotator {
    VtlVariableTypeAnnotator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiReference javaRef;
        PsiType varPsiType;
        if (element == null) {
            VtlVariableTypeAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            VtlVariableTypeAnnotator.$$$reportNull$$$0(1);
        }
        if (!VtlReferenceContributor.Holder.VTL_VARIABLE_COMMENT.accepts((Object)element)) {
            return;
        }
        String text = element.getText();
        String[] nameAndType = VtlFile.findVariableNameAndTypeAndScopeFilePath(text);
        if (nameAndType == null) {
            return;
        }
        VtlImplicitVariable variable = ((VtlFile)element.getContainingFile()).findImplicitVariable(nameAndType[0], nameAndType[2]);
        if (variable == null) {
            return;
        }
        VtlVariableType vtlVariableType = variable.getPsiType();
        if (!(vtlVariableType instanceof VtlPsiType)) return;
        VtlPsiType vtlPsiType = (VtlPsiType)vtlVariableType;
        try {
            PsiType psiType;
            varPsiType = psiType = vtlPsiType.psiType();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (varPsiType instanceof PsiPrimitiveType) {
            return;
        }
        String message = JavaHighlightUtil.checkPsiTypeUseInContext((PsiType)varPsiType, (PsiElement)element);
        PsiReference[] references = JavaVtlReferenceContributor.getReferencesToJavaTypes(element);
        if (references.length <= 0 || (javaRef = references[references.length - 1]).resolve() != null) return;
        TextRange range = javaRef.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
        holder.newAnnotation(HighlightSeverity.ERROR, message != null ? message : VelocityBundle.message("invalid.java.type", new Object[0])).range(range).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/velocity/java/inspections/VtlVariableTypeAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

