/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.kernel;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.session.KernelStartupOptions;
import com.intellij.jupyter.execution.kernel.KernelRunnableHandler;
import com.intellij.jupyter.execution.kernel.KernelState;
import com.intellij.jupyter.execution.kernel.KernelStateMachine;
import com.intellij.jupyter.execution.listeners.KernelListener;
import com.intellij.jupyter.execution.listeners.events.KernelInfoReplyReceivedEventImpl;
import com.intellij.jupyter.execution.listeners.events.NotebookKernelEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.EventDispatcher;
import java.nio.file.Path;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u001f\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0016J\u0015\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00103J\u000e\u00104\u001a\u00020)2\u0006\u00102\u001a\u00020\u0002J\u0013\u00105\u001a\u00020)2\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u000209H\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006:"}, d2={"Lcom/intellij/jupyter/execution/kernel/AbstractKernelRunnableHandler;", "ListenerT", "Lcom/intellij/jupyter/execution/listeners/KernelListener;", "Lcom/intellij/jupyter/execution/kernel/KernelRunnableHandler;", "listenerClass", "Lkotlin/reflect/KClass;", "project", "Lcom/intellij/openapi/project/Project;", "kernelId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterKernelId;", "notebookPath", "Ljava/nio/file/Path;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lkotlin/reflect/KClass;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/nio/file/Path;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "startupOptions", "Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;", "(Lkotlin/reflect/KClass;Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getKernelId-qftoVCA", "()Ljava/lang/String;", "Ljava/lang/String;", "getNotebookPath", "()Ljava/nio/file/Path;", "getNotebookVirtualFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "stateMachine", "Lcom/intellij/jupyter/execution/kernel/KernelStateMachine;", "getStateMachine", "()Lcom/intellij/jupyter/execution/kernel/KernelStateMachine;", "kernelState", "Lcom/intellij/jupyter/execution/kernel/KernelState;", "getKernelState", "()Lcom/intellij/jupyter/execution/kernel/KernelState;", "_isVerified", "", "isVerified", "()Z", "markVerified", "", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "getEventDispatcher", "()Lcom/intellij/util/EventDispatcher;", "onKernelInfoReply", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "convertBaseListener", "listener", "(Lcom/intellij/jupyter/execution/listeners/KernelListener;)Lcom/intellij/jupyter/execution/listeners/KernelListener;", "addBaseKernelListener", "addKernelListener", "(Lcom/intellij/jupyter/execution/listeners/KernelListener;)V", "notifyTerminatedAndDispose", "event", "Lcom/intellij/jupyter/execution/listeners/events/NotebookKernelEvent;", "intellij.jupyter.execution"})
public abstract class AbstractKernelRunnableHandler<ListenerT extends KernelListener>
implements KernelRunnableHandler {
    @NotNull
    private final KClass<ListenerT> listenerClass;
    @NotNull
    private final Project project;
    @NotNull
    private final String kernelId;
    @NotNull
    private final Path notebookPath;
    @NotNull
    private final BackedNotebookVirtualFile notebookVirtualFile;
    @NotNull
    private final KernelStateMachine stateMachine;
    private boolean _isVerified;
    @NotNull
    private final EventDispatcher<ListenerT> eventDispatcher;

    private AbstractKernelRunnableHandler(KClass<ListenerT> listenerClass, Project project, String kernelId, Path notebookPath, BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter(listenerClass, (String)"listenerClass");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kernelId, (String)"kernelId");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        this.listenerClass = listenerClass;
        this.project = project;
        this.kernelId = kernelId;
        this.notebookPath = notebookPath;
        this.notebookVirtualFile = notebookVirtualFile;
        this.stateMachine = new KernelStateMachine();
        EventDispatcher eventDispatcher = EventDispatcher.create((Class)JvmClassMappingKt.getJavaClass(this.listenerClass));
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getKernelId-qftoVCA() {
        return this.kernelId;
    }

    @Override
    @NotNull
    public Path getNotebookPath() {
        return this.notebookPath;
    }

    @Override
    @NotNull
    public BackedNotebookVirtualFile getNotebookVirtualFile() {
        return this.notebookVirtualFile;
    }

    public AbstractKernelRunnableHandler(@NotNull KClass<ListenerT> listenerClass, @NotNull KernelStartupOptions startupOptions) {
        Intrinsics.checkNotNullParameter(listenerClass, (String)"listenerClass");
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        this(listenerClass, startupOptions.getProject(), startupOptions.getKernelId-qftoVCA(), startupOptions.getNotebookPath(), startupOptions.getNotebookVirtualFile(), null);
    }

    @NotNull
    public final KernelStateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    @NotNull
    public KernelState getKernelState() {
        return this.stateMachine.getCurrentState();
    }

    @Override
    public boolean isVerified() {
        return this._isVerified;
    }

    @Override
    public void markVerified() {
        this._isVerified = this.stateMachine.verified();
    }

    @NotNull
    public final EventDispatcher<ListenerT> getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public void onKernelInfoReply(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        KernelInfoReplyReceivedEventImpl event = new KernelInfoReplyReceivedEventImpl(this, message);
        ((KernelListener)this.eventDispatcher.getMulticaster()).kernelInfoReplyReceived(event);
    }

    @NotNull
    public ListenerT convertBaseListener(@NotNull KernelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return (ListenerT)((KernelListener)KClasses.cast(this.listenerClass, (Object)listener));
    }

    @Override
    public final void addBaseKernelListener(@NotNull KernelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.addKernelListener(this.convertBaseListener(listener));
    }

    public final void addKernelListener(@NotNull ListenerT listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    protected final void notifyTerminatedAndDispose(@NotNull NotebookKernelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationKt.getApplication().executeOnPooledThread(() -> AbstractKernelRunnableHandler.notifyTerminatedAndDispose$lambda$0(this, event));
    }

    private static final void notifyTerminatedAndDispose$lambda$0(AbstractKernelRunnableHandler this$0, NotebookKernelEvent $event) {
        if (this$0.stateMachine.terminating()) {
            ((KernelListener)this$0.eventDispatcher.getMulticaster()).kernelWillTerminate($event);
        }
        if (this$0.stateMachine.terminated()) {
            ((KernelListener)this$0.eventDispatcher.getMulticaster()).kernelTerminated($event);
        }
        this$0.eventDispatcher.getListeners().clear();
    }

    public /* synthetic */ AbstractKernelRunnableHandler(KClass listenerClass, Project project, String kernelId, Path notebookPath, BackedNotebookVirtualFile notebookVirtualFile, DefaultConstructorMarker $constructor_marker) {
        this(listenerClass, project, kernelId, notebookPath, notebookVirtualFile);
    }
}

