searchData={"items":[{"type":"module","title":"cover","doc":"A Coverage Analysis Tool for Erlang\n\nThe module `cover` provides a set of functions for coverage analysis\nof Erlang programs, counting how many times each _executable line_ of\ncode is executed when a program is run. Executable lines are\nlines in the body of a clause in a function, `case`,\n`receive`, or `try`. Lines in clause heads, blank lines, and lines\ncontaining only comments are not executable.\n\nCoverage analysis can be used to verify that test cases covers all\nrelevant line in the code being test. It can also be helpful when\nlooking for bottlenecks in the code.\n\nBefore any analysis can take place, the involved modules has to be\n_cover-compiled_.  This means that some extra information is added to\nthe module before it is compiled into a binary which then is\nloaded. The source file of the module is not affected and no `.beam`\nfile is created. If the runtime system supports coverage natively,\nCover will automatically use that functionality to lower the execution\noverhead for cover-compiled code.\n\n> #### Change {: .info }\n>\n> Native coverage support was added in Erlang/OTP 27.\n\nEach time a function in a cover-compiled module is called, information about the\ncall is added to an internal database of Cover. The coverage analysis is\nperformed by examining the contents of the Cover database. The output `Answer`\nis determined by two parameters: `Level` and `Analysis`.\n\n- `Level = module`\n\n  `Answer = {Module,Value}`, where `Module` is the module name.\n\n- `Level = function`\n\n  `Answer = [{Function,Value}]`, one tuple for each function in the module. A\n  function is specified by its module name `M`, function name `F` and arity `A`\n  as a tuple `{M,F,A}`.\n\n- `Level = clause`\n\n  `Answer = [{Clause,Value}]`, one tuple for each clause in the module. A clause\n  is specified by its module name `M`, function name `F`, arity `A` and position\n  in the function definition `C` as a tuple `{M,F,A,C}`.\n\n- `Level = line`\n\n  `Answer = [{Line,Value}]`, one tuple for each executable line in the module. A\n  line is specified by its module name `M` and line number in the source file\n  `N` as a tuple `{M,N}`.\n\n- `Analysis = coverage`\n\n  `Value = {Cov,NotCov}` where `Cov` is the number of executable lines in the\n  module, function, clause or line that have been executed at least once and\n  `NotCov` is the number of executable lines that have not been executed.\n\n- `Analysis = calls`\n\n  `Value = Calls` which is the number of times the module, function, or clause\n  has been called. In the case of line level analysis, `Calls` is the number of\n  times the line has been executed.","ref":"cover.html"},{"type":"module","title":"Distribution - cover","doc":"Cover can be used in a distributed Erlang system. One of the nodes in the system\nhas to be selected as the _main node_, and all Cover commands must be\nexecuted from that node. The error reason `not_main_node` is returned if an\ninterface function is called on one of the remote nodes.\n\nUse `cover:start/1` and `cover:stop/1` to add or remove nodes. The\nsame cover-compiled code will be loaded on each node, and analysis\nwill collect and sum up coverage data results from all nodes.\n\nTo only collect data from remote nodes without stopping `cover` on those nodes,\nuse `cover:flush/1`\n\nIf the connection to a remote node goes down, the main node will mark it as\nlost. If the node comes back it will be added again. If the remote node was\nalive during the disconnected period, cover data from before and during this\nperiod will be included in the analysis.","ref":"cover.html#module-distribution"},{"type":"function","title":"cover.analyse/0","doc":"Equivalent to  analyse('_', coverage, function) .","ref":"cover.html#analyse/0"},{"type":"function","title":"cover.analyse/1","doc":"Analyzes one or more modules as specified by `Arg`.\n\nIf `Arg` is one of the values in [`analysis()`](`t:analysis/0`), this\ncall is equivalent to [`analyse('_', Arg, function)`](`analyse/3`).\n\nIf `Arg` is one of the values in [`level()`](`t:level/0`), this\ncall is equivalent to [`analyse('_', coverage, Arg)`](`analyse/3`).\n\nOtherwise `Arg` is assumed to be a module name, and this call is equivalent\nto [`analyse(Arg, coverage, function)`](`analyse/3`).\n\n> #### Note {: .info }\n>\n> To analyze a module whose name overlaps with one the values in\n> [`analysis()`](`t:analysis/0`) or [`level()`](`t:level/0`), the module\n> name has to be in a list. For example, to analyze a module named `calls`:\n>\n> ```\n> cover:analyse([calls]).\n> ```","ref":"cover.html#analyse/1"},{"type":"function","title":"cover.analyse/2","doc":"Analyzes one or more modules as specified by `Arg1` and `Arg2`.\n\nIf `Arg1` is one of the values in [`analysis()`](`t:analysis/0`) and\n`Arg2` is one of the values in [`level()`](`t:level/0`), this\ncall is equivalent to [`analyse('_', Arg1, Arg2)`](`analyse/3`).\n\nIf `Arg2` is one of the values in [`analysis()`](`t:analysis/0`),\n`Arg1` is assumed to be a module and this call is equivalent to\n[`analyse(Arg1, Arg2, function)`](`analyse/3`).\n\nIf `Arg2` is one of the values in [`level()`](`t:level/0`), `Arg1` is\nassumed to be a module and this call is equivalent to [`analyse(Arg1,\ncoverage, Arg2)`](`analyse/3`).\n\n> #### Note {: .info }\n>\n> To analyze a module whose name overlaps with one of the values in\n> [`analysis()`](`t:analysis/0`), the module name needs to be in a\n> list. For example, to analyze a module named `calls`:\n>\n> ```\n> cover:analyse([calls], function).\n> ```","ref":"cover.html#analyse/2"},{"type":"function","title":"cover.analyse/3","doc":"Perform analysis of one or more cover-compiled modules, as specified by\n`Analysis` and `Level`, by examining the contents of the internal\ndatabase.\n\nIf `Modules` is an atom (a single module), the return is `OneResult`,\notherwise the return is `{result, Ok, Fail}`.\n\nIf `Modules` is atom `'_'`, all modules that have data in the cover data table\nare analysed. Note that this includes both cover-compiled modules and imported\nmodules.\n\nIf a given module is not cover-compiled, this is indicated by the error reason\n`{not_cover_compiled, Module}`.","ref":"cover.html#analyse/3"},{"type":"type","title":"cover.analyse_answer/0","doc":"","ref":"cover.html#t:analyse_answer/0"},{"type":"type","title":"cover.analyse_fail/0","doc":"","ref":"cover.html#t:analyse_fail/0"},{"type":"type","title":"cover.analyse_file_fail/0","doc":"","ref":"cover.html#t:analyse_file_fail/0"},{"type":"type","title":"cover.analyse_file_ok/0","doc":"","ref":"cover.html#t:analyse_file_ok/0"},{"type":"type","title":"cover.analyse_item/0","doc":"","ref":"cover.html#t:analyse_item/0"},{"type":"type","title":"cover.analyse_ok/0","doc":"","ref":"cover.html#t:analyse_ok/0"},{"type":"type","title":"cover.analyse_option/0","doc":"","ref":"cover.html#t:analyse_option/0"},{"type":"type","title":"cover.analyse_rsn/0","doc":"","ref":"cover.html#t:analyse_rsn/0"},{"type":"function","title":"cover.analyse_to_file/0","doc":"Equivalent to  analyse_to_file('_', []) .","ref":"cover.html#analyse_to_file/0"},{"type":"function","title":"cover.analyse_to_file/1","doc":"If `Arg` is a list of [`analyse_option()`](`t:analyse_option/0`)\noptions, this call is equivalent to [`analyse_to_file('_',\nArg)`](`analyse_to_file/2`).\n\nOtherwise `Arg` is assumed to be a module, and this call is equivalent to\n[`analyse_to_file(Arg, [])`](`analyse_to_file/2`).\n\n> #### Note {: .info }\n>\n> To analyze a module of the name `html` (which overlaps with an option\n> in [`analyse_option()`](`t:analyse_option/0`)), it is necessary to\n> use `cover:analyse_to_file/2`:\n>\n> ```\n> cover:analyse_to_file([html], []).\n> ```","ref":"cover.html#analyse_to_file/1"},{"type":"function","title":"cover.analyse_to_file/2","doc":"Outputs copies of the source code for the given modules annotated with\nexecution counts for each executable line.\n\nThe output file `OutFile` defaults to `Module.COVER.out`, and to `Module.COVER.html`\nif option `html` is used.\n\nIf `Modules` is an atom (one module), the return will be `Answer`, otherwise the\nreturn will be a list, `{result, Ok, Fail}`.\n\nIf `Modules` is '_', all modules that have data in the Cover data table\nare analysed. Note that this includes both cover-compiled modules and imported\nmodules.\n\nIf a module is not cover-compiled, this is indicated by the error reason\n`{not_cover_compiled, Module}`.\n\nIf the source file and/or the output file cannot be opened using `file:open/2`,\nthe function returns `{error, {file, File, Reason}}`, where `File` is the file\nname and `Reason` is the error reason.\n\nIf a module was cover compiled from the `.beam` file, that is, using\n`compile_beam/1` or\n[`compile_beam_directory/0,1` ](`compile_beam_directory/0`), it is assumed that\nthe source code can be found in one of the following locations:\n\n- the same directory as the `.beam` file\n- `../src` relative to the directory with `.beam` file\n- the source path in `Module:module_info(compile)`, in which case two paths\n  are examined:\n  * first the one constructed by joining `../src` and the tail of the compiled path\n    below a trailing `src` component\n  * the compiled path itself\n\nIf no source code is found, this is indicated by the error reason\n`{no_source_code_found, Module}`.","ref":"cover.html#analyse_to_file/2"},{"type":"type","title":"cover.analyse_value/0","doc":"","ref":"cover.html#t:analyse_value/0"},{"type":"type","title":"cover.analysis/0","doc":"","ref":"cover.html#t:analysis/0"},{"type":"function","title":"cover.async_analyse_to_file/1","doc":"Equivalent to  async_analyse_to_file/3 .","ref":"cover.html#async_analyse_to_file/1"},{"type":"function","title":"cover.async_analyse_to_file/2","doc":"Equivalent to  async_analyse_to_file/3 .","ref":"cover.html#async_analyse_to_file/2"},{"type":"function","title":"cover.async_analyse_to_file/3","doc":"This function works the same way as\n[`analyse_to_file/2`](`analyse_to_file/2`) except that it is asynchronous instead\nof synchronous.\n\nThe spawned process will link with the caller when created. If an\nerror of type [`analyse_rsn()`](`t:analyse_rsn/0`) occurs while doing\nthe cover analysis the process will crash with the same error reason\nas [`analyse_to_file`](`analyse_to_file/1`) would return.","ref":"cover.html#async_analyse_to_file/3"},{"type":"type","title":"cover.beam_mod_file/0","doc":"","ref":"cover.html#t:beam_mod_file/0"},{"type":"type","title":"cover.beam_mod_files/0","doc":"","ref":"cover.html#t:beam_mod_files/0"},{"type":"function","title":"cover.compile/1","doc":"Equivalent to  compile_module(ModFiles, []) .","ref":"cover.html#compile/1"},{"type":"function","title":"cover.compile/2","doc":"Equivalent to  compile_module(ModFile, Options) .","ref":"cover.html#compile/2"},{"type":"function","title":"cover.compile_beam/1","doc":"Cover-compiles one or more modules based `.beam` files containing\nabstract code (option `debug_info`).\n\nCover-compiling from `.beam` files is faster than compiling from\nsource and less hassle, because there is no need to supply options for\ninclude paths or macros. However, the existing `.beam` files must have\nbeen compiled with option\n[`debug_info`](`e:compiler:compile.md#debug_info`) so that they contain\n[*abstract code*](`e:erts:absform`).\n\nIf abstract code is missing, the error reason `{no_abstract_code,\nBeamFile}` is returned. If the abstract code is encrypted, and no key\nis available for decrypting it, the error reason\n`{encrypted_abstract_code, BeamFile}` is returned.\n\nIf only the module name (that is, not the full name of the `.beam`\nfile) is given to this function, the `.beam` file is found by calling\n[`code:which(Module)`](`code:which/1`). If no `.beam` file is found,\nthe error reason `non_existing` is returned. If the module is already\ncover compiled with [`compile_beam/1`](`compile_beam/1`), the `.beam`\nfile will be picked from the same location as the first time it was\ncompiled. If the module is already cover-compiled with\n`compile_module/2`, there is no way to find the correct `.beam` file,\nso the error reason `{already_cover_compiled, no_beam_found, Module}`\nis returned.\n\n`{error, BeamFile}` is returned if the compiled code cannot be loaded on the\nnode.\n\nIf a list of `ModFiles` is given as input, a list of `Result` will be returned.\nThe order of the returned list is undefined.","ref":"cover.html#compile_beam/1"},{"type":"function","title":"cover.compile_beam_directory/0","doc":"Equivalent to  compile_beam_directory(\".\") .","ref":"cover.html#compile_beam_directory/0"},{"type":"function","title":"cover.compile_beam_directory/1","doc":"Cover-compiles all `.beam` files in directory `Dir` in the same way\nas `compile_beam/1`.\n\nThis function returns a list of [`compile_beam_result()`](`t:compile_beam_result/0`)\nif successful. Otherwise, it returns  `{error, eacces}` if the directory is not\nreadable, and `{error, enoent}` if the directory does not exist.","ref":"cover.html#compile_beam_directory/1"},{"type":"type","title":"cover.compile_beam_result/0","doc":"","ref":"cover.html#t:compile_beam_result/0"},{"type":"type","title":"cover.compile_beam_rsn/0","doc":"","ref":"cover.html#t:compile_beam_rsn/0"},{"type":"function","title":"cover.compile_directory/0","doc":"Equivalent to  compile_directory(\".\", []) .","ref":"cover.html#compile_directory/0"},{"type":"function","title":"cover.compile_directory/1","doc":"Equivalent to  compile_directory(Dir, []) .","ref":"cover.html#compile_directory/1"},{"type":"function","title":"cover.compile_directory/2","doc":"Compiles all modules (`.erl` files) in a directory `Dir` for Cover analysis the\nsame way as [`compile_module/1,2`](`compile_module/1`) and returns a list of\n[`Result`](`t:compile_result/0`).\n\nThis function returns `{error, eacces}` if the directory is not readable or\n`{error, enoent}` if the directory does not exist.","ref":"cover.html#compile_directory/2"},{"type":"function","title":"cover.compile_module/1","doc":"Equivalent to  compile_module(ModFile, []) .","ref":"cover.html#compile_module/1"},{"type":"function","title":"cover.compile_module/2","doc":"Cover-compiles one or more modules.\n\nThe module is given by its module name `Module` or by its file name\n`File`.\n\nThe `.erl` extension can be omitted. If the module is not located in\nthe current directory, the full path to it must be specified.\n\n`Options` is a list of compiler options. Only options defining include\nfile directories and macros are passed to `compile:file/2`;\neverything else is ignored.\n\nIf the module is successfully cover-compiled, the function returns\n`{ok, Module}`. Otherwise the function returns `{error, File}`. Errors and\nwarnings are printed as they occur.\n\nIf a list of `ModFiles` is given as input, a list of [`Result`](`t:compile_result/0`)\nwill be returned. The order of the returned results in the list is undefined.\n\nNote that the internal database is initialized during the compilation,\nwhich means that any previously collected coverage data for the module\nis lost.","ref":"cover.html#compile_module/2"},{"type":"type","title":"cover.compile_result/0","doc":"","ref":"cover.html#t:compile_result/0"},{"type":"function","title":"cover.export/1","doc":"Equivalent to  export(File, '_') .","ref":"cover.html#export/1"},{"type":"function","title":"cover.export/2","doc":"Exports the current coverage data for `Module` to the file `ExportFile`.\n\nIt is recommended to name the `ExportFile` with the extension `.coverdata`.\n\nIf `Module` is '_', data for all cover-compiled or earlier imported\nmodules is exported.\n\nThis function is useful if coverage data from different systems is to be merged.\n\nSee also `import/1`.","ref":"cover.html#export/2"},{"type":"type","title":"cover.export_reason/0","doc":"","ref":"cover.html#t:export_reason/0"},{"type":"type","title":"cover.file_error/0","doc":"","ref":"cover.html#t:file_error/0"},{"type":"function","title":"cover.flush/1","doc":"Fetches data from the Cover database on the remote nodes and stores it on the main\nnode.","ref":"cover.html#flush/1"},{"type":"function","title":"cover.import/1","doc":"Imports coverage data from the file `ExportFile` created with\n[`export/1,2`](`export/2`).\n\nAny analysis performed after this call will include the imported data.\n\nNote that when compiling a module _all existing coverage data is removed_,\nincluding imported data. If a module is already compiled when data is imported,\nthe imported data is _added_ to the existing coverage data.\n\nCoverage data from several export files can be imported into one system. The\ncoverage data is then added up when analysing.\n\nCoverage data for a module cannot be imported from the same file twice unless\nthe module is first reset or compiled. The check is based on the filename, so\nyou can easily fool the system by renaming your export file.","ref":"cover.html#import/1"},{"type":"function","title":"cover.imported/0","doc":"Returns a list of all imported files.","ref":"cover.html#imported/0"},{"type":"function","title":"cover.imported_modules/0","doc":"Returns a list of all modules for which there are imported data.","ref":"cover.html#imported_modules/0"},{"type":"function","title":"cover.is_compiled/1","doc":"Returns `{file, File}` if the module `Module` is cover-compiled, or `false`\notherwise.\n\n`File` is the `.erl` file used by [`compile_module/1,2`](`compile_module/2`)\nor the `.beam` file used by `compile_beam/1`.","ref":"cover.html#is_compiled/1"},{"type":"type","title":"cover.level/0","doc":"","ref":"cover.html#t:level/0"},{"type":"function","title":"cover.local_only/0","doc":"Only support running Cover on the local node.\n\nThis function has to be called before any modules have been compiled or\nany nodes added. When running in this mode, modules will be\ncover-compiled in a more efficient way, but the resulting code will\nonly work on the same node they were compiled on.","ref":"cover.html#local_only/0"},{"type":"type","title":"cover.mod_file/0","doc":"","ref":"cover.html#t:mod_file/0"},{"type":"type","title":"cover.mod_files/0","doc":"","ref":"cover.html#t:mod_files/0"},{"type":"type","title":"cover.modules/0","doc":"","ref":"cover.html#t:modules/0"},{"type":"function","title":"cover.modules/0","doc":"Returns a list with all modules that are currently cover-compiled.","ref":"cover.html#modules/0"},{"type":"type","title":"cover.one_result/0","doc":"","ref":"cover.html#t:one_result/0"},{"type":"type","title":"cover.option/0","doc":"","ref":"cover.html#t:option/0"},{"type":"function","title":"cover.reset/0","doc":"Resets all coverage data for all cover-compiled modules in the Cover\ndatabase on all nodes.","ref":"cover.html#reset/0"},{"type":"function","title":"cover.reset/1","doc":"Resets all coverage data for the cover-compiled module `Module` in the Cover\ndatabase on all nodes.\n\nIf `Module` is not cover-compiled, the function returns\n`{error, {not_cover_compiled, Module}}`.","ref":"cover.html#reset/1"},{"type":"function","title":"cover.start/0","doc":"Starts the Cover server which owns the Cover internal database. This function is\ncalled automatically by the other functions in the module.","ref":"cover.html#start/0"},{"type":"function","title":"cover.start/1","doc":"Starts a Cover server on the each of given nodes, and loads all cover compiled\nmodules.\n\nThis call will fail if `cover:local_only/0` has been called.","ref":"cover.html#start/1"},{"type":"function","title":"cover.stop/0","doc":"Stops the Cover server and unloads all cover-compiled code.","ref":"cover.html#stop/0"},{"type":"function","title":"cover.stop/1","doc":"Stops the Cover server and unloads all cover-compiled code on the given nodes.\n\nData stored in the Cover database on the remote nodes is fetched and stored on\nthe main node.","ref":"cover.html#stop/1"},{"type":"function","title":"cover.which_nodes/0","doc":"Returns a list with all nodes that are part of the coverage analysis.\n\nNote that the current node is not included, because it is always part\nof the analysis.","ref":"cover.html#which_nodes/0"},{"type":"module","title":"cprof","doc":"A simple Call Count Profiling Tool using breakpoints for minimal runtime\nperformance impact.\n\nThe `cprof` module is used to profile a program to find out how many times\ndifferent functions are called. To minimize runtime performance impact,\nbreakpoints containing counters are used.\n\nSince breakpoints are used there is no need for special compilation of the\nmodules to be profiled. These breakpoints can only be set on BEAM code, so\nBIFs cannot be call-count traced.\n\nThe size of the call counters is the host machine word size. One bit is used\nwhen pausing the counter, so the maximum counter value for a 32-bit host\nis 2,147,483,647.\n\nThe profiling result is delivered as a term containing a sorted list of entries,\none per module. Each module entry contains a sorted list of functions. The\nsorting order in both cases is of decreasing call count.\n\nCall count tracing is lightweight compared to other forms of tracing,\nsuch as `m:eprof` or `m:fprof`, since no trace messages have to be\ngenerated. Some measurements indicates that the performance degradation is\nabout 10 percent.\n\nFor more information and some examples, see the\n[User's Guide for `cprof`](cprof_chapter.md).","ref":"cprof.html"},{"type":"function","title":"cprof.analyse/0","doc":"Equivalent to  analyse(1) .","ref":"cprof.html#analyse/0"},{"type":"function","title":"cprof.analyse/1","doc":"Collect call counters for one or more modules.\n\nIf `ModLimit` is a module name (an atom), this call is equivalent to\n[`analyse(ModLimit, 1)`](`analyse/2`).\n\nIf `ModLimit` is an integer, this function calls\n[`analyse(Module, ModLimit)`](`analyse/2`) for each `Module` that is\ncurrently loaded (except the `cprof` module itself).\nThe result from those calls are returned in a list.","ref":"cprof.html#analyse/1"},{"type":"function","title":"cprof.analyse/2","doc":"Collects and analyses all call counters for module `Module`.\n\nThis function returns:\n\n```\n{Module, ModuleCount, FuncAnalysisList}\n```\n\nwhere `FuncAnalysisList` is a list of tuples, one for each function:\n\n```\n{{Module, FunctionName, Arity}, FuncCallCount}\n```\n\nIf call counters are still running while `analyse/0,1,2` is executing, the result\ncould be inconsistent. This happens if the process executing `analyse/0,1,2`\nis scheduled out so some other process can increment the counters that are\nbeing analysed. Calling [`pause()`](`pause/0`) before analysing takes care of\nthat problem.\n\nAll functions with a `FuncCallCount` lower than `Limit` are excluded from\n`FuncAnalysisList`. They are still included in `ModCallCount`, though.","ref":"cprof.html#analyse/2"},{"type":"type","title":"cprof.func_analysis_list/0","doc":"","ref":"cprof.html#t:func_analysis_list/0"},{"type":"type","title":"cprof.mod_analysis/0","doc":"","ref":"cprof.html#t:mod_analysis/0"},{"type":"type","title":"cprof.mod_analysis_list/0","doc":"","ref":"cprof.html#t:mod_analysis_list/0"},{"type":"function","title":"cprof.pause/0","doc":"Pause call count tracing for all functions in all modules and stop it for all\nfunctions in modules to be loaded.\n\nThis call is equivalent to\n[`pause('_', '_', '_') + stop({on_load})`](`pause/3`).","ref":"cprof.html#pause/0"},{"type":"function","title":"cprof.pause/1","doc":"If `FuncSpec` is an atom, it is assumed to be a module name, and\nthis call is equivalent to [`pause(FuncSpec, '_', '_')`](`pause/3`).\n\nIf `FuncSpec` is an MFA tuple, `{Module, Name, Arity`}, this call\nis equivalent to [`pause(Module, Name, Arity)`](`pause/3`).\n\nIf `FuncSpec` is tuple `{FS}`, `FS` is the first argument to\n`erlang:trace_pattern/3`. For example, if `FuncSpec` is `{on_load}`,\ncall counters will be paused for all functions in modules to be loaded.","ref":"cprof.html#pause/1"},{"type":"function","title":"cprof.pause/2","doc":"Equivalent to  pause(Mod, Func, '_') .","ref":"cprof.html#pause/2"},{"type":"function","title":"cprof.pause/3","doc":"Pause call counters for matching functions in matching modules.\n\nThe call counters for all matching functions that have call count breakpoints\nare paused at their current count.\n\nReturn the number of matching functions that can have call count breakpoints,\nthe same as [`start/*`](`start/3`) with the same arguments would have\nreturned.","ref":"cprof.html#pause/3"},{"type":"function","title":"cprof.restart/0","doc":"Equivalent to  restart('_', '_', '_') .","ref":"cprof.html#restart/0"},{"type":"function","title":"cprof.restart/1","doc":"If `FuncSpec` is an atom, it is assumed to be a module name, and\nthis call is equivalent to [`restart(FuncSpec, '_', '_')`](`restart/3`).\n\nIf `FuncSpec` is an MFA tuple, `{Module, Name, Arity`}, this call\nis equivalent to [`restart(Module, Name, Arity)`](`restart/3`).\n\nIf `FuncSpec` is tuple `{FS}`, `FS` is the first argument to\n`erlang:trace_pattern/3`. For example, if `FuncSpec` is `{on_load}`,\ncall counters will be set to zero and running for all functions in\nmodules to be loaded.","ref":"cprof.html#restart/1"},{"type":"function","title":"cprof.restart/2","doc":"Equivalent to  restart(Mod, Func, '_') .","ref":"cprof.html#restart/2"},{"type":"function","title":"cprof.restart/3","doc":"Restart call counters for the matching functions in matching modules that are\ncall-count traced.\n\nThe call counters for all matching functions that has call count breakpoints\nare set to zero and running.\n\nReturn the number of matching functions that can have call count breakpoints,\nthe same as [`start/*`](`start/3`) with the same arguments would have\nreturned.","ref":"cprof.html#restart/3"},{"type":"function","title":"cprof.start/0","doc":"Start call count tracing for all functions in all modules, and also for all\nfunctions in modules to be loaded.\n\nThis is equivalent to\n[`start('_', '_', '_') + start({on_load})`](`start/3`).","ref":"cprof.html#start/0"},{"type":"function","title":"cprof.start/1","doc":"If `FuncSpec` is an atom, it is assumed to be a module name, and\nthis call is equivalent to [`start(FuncSpec, '_', '_')`](`start/3`).\n\nIf `FuncSpec` is an MFA tuple, `{Module, Name, Arity`}, this call\nis equivalent to [`start(Module, Name, Arity)`](`start/3`).\n\nIf `FuncSpec` is tuple `{FS}`, `FS` is the first argument to\n`erlang:trace_pattern/3`. For example, if `FuncSpec` is `{on_load}`,\ncall counters will be set to zero and running for all functions in\nmodules to be loaded.","ref":"cprof.html#start/1"},{"type":"function","title":"cprof.start/2","doc":"Equivalent to  start(Mod, Func, '_') .","ref":"cprof.html#start/2"},{"type":"function","title":"cprof.start/3","doc":"Start call count tracing for matching functions in matching modules.\n\nSet call count breakpoints on the matching functions that has no call count\nbreakpoints. Call counters are set to zero and running for all matching\nfunctions.\n\nReturn the number of matching functions that has call count breakpoints.","ref":"cprof.html#start/3"},{"type":"function","title":"cprof.stop/0","doc":"Stop call count tracing for all functions in all modules, and also for all\nfunctions in modules to be loaded.\n\nThis is equivalent to\n[`stop('_', '_', '_') + stop({on_load})`](`stop/3`).","ref":"cprof.html#stop/0"},{"type":"function","title":"cprof.stop/1","doc":"If `FuncSpec` is an atom, it is assumed to be a module name, and\nthis call is equivalent to [`stop(FuncSpec, '_', '_')`](`stop/3`).\n\nIf `FuncSpec` is an MFA tuple, `{Module, Name, Arity`}, this call\nis equivalent to [`stop(Module, Name, Arity)`](`stop/3`).\n\nIf `FuncSpec` is tuple `{FS}`, `FS` is the first argument to\n`erlang:trace_pattern/3`. For example, if `FuncSpec` is `{on_load}`,\ncall counters be disabled for all functions in modules to be loaded.","ref":"cprof.html#stop/1"},{"type":"function","title":"cprof.stop/2","doc":"Equivalent to  stop(Mod, Func, '_') .","ref":"cprof.html#stop/2"},{"type":"function","title":"cprof.stop/3","doc":"Stop call count tracing for matching functions in matching modules.\n\nRemove call count breakpoints from the matching functions that has call count\nbreakpoints.\n\nReturn the number of matching functions that can have call count breakpoints,\nwhich is the same as [`start/*`](`start/3`) with the same arguments would have\nreturned.","ref":"cprof.html#stop/3"},{"type":"module","title":"eprof","doc":"A Time Profiling Tool for Erlang\n\nThe module `eprof` provides a set of functions for time profiling of Erlang\nprograms to find out how the execution time is used. The profiling is done using\nthe Erlang trace BIFs. Tracing of local function calls for a specified set of\nprocesses is enabled when profiling is begun, and disabled when profiling is\nstopped.\n\nWhen using Eprof, expect a slowdown in program execution.","ref":"eprof.html"},{"type":"function","title":"eprof.analyze/0","doc":"Equivalent to  analyze(procs, []) .","ref":"eprof.html#analyze/0"},{"type":"function","title":"eprof.analyze/1","doc":"If `TypeOpts` is an atom, it is assumed to be a module name, and this\ncall is equivalent to [`analyze(TypeOpts, [])`](`analyze/2`).\n\nOtherwise, if `TypeOpts` is a list, it assumed to be a list of options, and this\ncall is equivalent to [`analyze(procs, TypeOpts)`](`analyze/2`).","ref":"eprof.html#analyze/1"},{"type":"function","title":"eprof.analyze/2","doc":"Call this function when profiling has been stopped to display the results.\n\nIf `Type` is `procs`, the time spent in each function is shown separately\nfor each profiled process.\n\nIf `Type` is `total`, the time spent in each function is shown combined\nfor each profiled process.\n\nTime is shown as percentage of total time and as absolute time in micro seconds.","ref":"eprof.html#analyze/2"},{"type":"type","title":"eprof.analyze_type/0","doc":"","ref":"eprof.html#t:analyze_type/0"},{"type":"function","title":"eprof.log/1","doc":"Call this function to ensure that the results displayed by\n[`analyze/0,1,2`](`analyze/0`) are printed to the file `File` as well as to the\nscreen.","ref":"eprof.html#log/1"},{"type":"function","title":"eprof.profile/1","doc":"If `FunRootset` is a fun, this call is equivalent to\n[`profile([], FunRootset)`](`profile/2`).\n\nIf `FunRootset` is a list, it is assumed to be a `Rootset`, and this\ncall is equivalent to [`start_profiling(Rootset)`](`start_profiling/1`).","ref":"eprof.html#profile/1"},{"type":"function","title":"eprof.profile/2","doc":"If `Arg1` is a fun and `Arg2` is list, this call is equivalent to\n[`profile([], Arg1, {'_','_','_'}, Arg2)`](`profile/4`).\n\nIf `Arg1` is a list and `Arg2` is a fun, this call is equivalent to\n[`profile(Arg1, Arg2, {'_','_','_'}, Arg1)`](`profile/4`).","ref":"eprof.html#profile/2"},{"type":"function","title":"eprof.profile/3","doc":"Equivalent to  profile(Rootset, Fun, Pattern, [{set_on_spawn, true}]) .","ref":"eprof.html#profile/3"},{"type":"function","title":"eprof.profile/4","doc":"This function spawns a process that applies a fun or an an function,\nand then starts profiling for the spawned proceses as well as the\nprocesses in `Rootset` (and any new processes spawned from them).\n\nIf `Arg1` is a fun, `Arg2` is expected to be a trace pattern, and\n`Arg3` a list of options. In that case, this call is equivalent to:\n\n[`profile(Rootset, erlang, apply, [Arg1, []], Arg2, Arg3)`](`profile/6`)\n\nIf `Arg1` is an atom, `Arg1` is assumed to be a module name, `Arg2` the\nname of the function in that module, and `Arg3` a list of arguments to\nbe used when calling that function. In that case, this call is equivalent\nto:\n\n[`profile(Rootset, Arg1, Arg2, Arg3, {'_','_','_'}, [{set_on_spawn, true}])`](`profile/6`)","ref":"eprof.html#profile/4"},{"type":"function","title":"eprof.profile/5","doc":"Equivalent to  profile(Rootset, Module, Function, Args, Pattern, [{set_on_spawn, true}]) .","ref":"eprof.html#profile/5"},{"type":"function","title":"eprof.profile/6","doc":"This function spawns a process `P` that [`apply(Module, Function,\nArgs)`](`apply/3`), and then starts profiling for `P` and the\nprocesses in `Rootset` (and any new processes spawned from them).\n\n`Rootset` is a list of pids and registered names.\n\nInformation about activity in any profiled process is stored in the Eprof\ndatabase.\n\nIf tracing could be enabled for `P` and all processes in `Rootset`, the function\nreturns `{ok,Value}` when `Fun()`/`apply` returns with the value `Value`, or\n`{error,Reason}` if `Fun()`/`apply` fails with exit reason `Reason`. Otherwise\nit returns `{error, Reason}` immediately.\n\nThe `set_on_spawn` option will active call time tracing for all processes\nspawned by processes in the rootset. This is the default behaviour.\n\nThe programmer must ensure that the function given as argument is truly\nsynchronous and that no work continues after the function has returned a value.","ref":"eprof.html#profile/6"},{"type":"function","title":"eprof.start/0","doc":"Starts the Eprof server which holds the internal state of the collected data.","ref":"eprof.html#start/0"},{"type":"function","title":"eprof.start_profiling/1","doc":"Equivalent to  start_profiling(Rootset, {'_', '_', '_'}) .","ref":"eprof.html#start_profiling/1"},{"type":"function","title":"eprof.start_profiling/2","doc":"Equivalent to  start_profiling(Rootset, Pattern, [{set_on_spawn, true}]) .","ref":"eprof.html#start_profiling/2"},{"type":"function","title":"eprof.start_profiling/3","doc":"Starts profiling for the processes in `Rootset` (and any new processes spawned\nfrom them).\n\nInformation about activity in any profiled process is stored in the\nEprof database.\n\n`Rootset` is a list of pids and registered names.\n\nThe function returns `profiling` if tracing could be enabled for all processes\nin `Rootset`, or `error` otherwise.\n\nA pattern can be selected to narrow the profiling. For instance a specific\nmodule can be selected, and only the code executed in that module will be\nprofiled.\n\nThe `set_on_spawn` option will active call time tracing for all processes\nspawned by processes in the rootset. This is the default behaviour.","ref":"eprof.html#start_profiling/3"},{"type":"function","title":"eprof.stop/0","doc":"Stops the Eprof server.","ref":"eprof.html#stop/0"},{"type":"function","title":"eprof.stop_profiling/0","doc":"Stops profiling started with `start_profiling/1` or `profile/1`.","ref":"eprof.html#stop_profiling/0"},{"type":"type","title":"eprof.trace_pattern_mfa/0","doc":"","ref":"eprof.html#t:trace_pattern_mfa/0"},{"type":"module","title":"fprof","doc":"A Time Profiling Tool using trace to file for minimal runtime performance\nimpact.\n\nThis module is used to profile a program to find out how the execution time is\nused. Tracing to file is used to minimize the runtime performance degradation.\n\nThe `fprof` module uses tracing to collect profiling data, hence there is no\nneed for special compilation of any module to be profiled. When it starts\ntracing, `fprof` will erase all previous tracing in the node and set the\nnecessary trace flags on the profiling target processes as well as local call\ntrace on all functions in all loaded modules and all modules to be loaded.\n`fprof` disable all tracing in the node when it stops tracing.\n\n`fprof` presents both _own time_ that is, how much time a function has\nused for its own execution, and _accumulated time_ that is, including\ncalled functions. All presented times are collected using trace\ntimestamps. `fprof` tries to collect CPU time timestamps, if the host\nmachine OS supports it. Therefore, the times can be wallclock times and\nOS scheduling will randomly strike all called functions in a\npresumably fair way.\n\nHowever, if the profiling time is short, and the host machine OS does\nnot support high resolution CPU time measurements, a few OS\nschedulings can show up as ridiculously long execution times for\nfunctions doing practically nothing. As an example, it has been\nobserved that a function that more or less just composing a tuple, was\nrunning 100 times slower than normal. When tracing was repeated, the\nexecution time was normal.\n\nProfiling is essentially done in 3 steps:\n\n- Tracing: to a file. The trace data contains entries for function\n  calls, returns to function, process scheduling, other process\n  related events (for example `spawn`), and garbage collection. All trace\n  entries are timestamped.\n\n- Profiling: the trace file is read, the execution call stack is\n  simulated, and raw profile data is calculated from the simulated call stack\n  and the trace timestamps. The profile data is stored in the `fprof` server\n  state. During this step the trace data may be dumped in text format to file or\n  console.\n\n- Analysing: the raw profile data is sorted, filtered and dumped in\n  text format either to file or console. The text format intended to be both\n  readable for a human reader, as well as parsable with the standard erlang\n  parsing tools.\n\nSince `fprof` sends trace data to afile, the runtime performance\ndegradation is minimized, but still far from negligible, especially\nfor programs that themselves use the filesystem heavily. Where the\ntrace file is placed is also important, for example, on Unix systems\n`/tmp` is usually a good choice since it is essentially a RAM disk,\nwhile any network-mounted disk is a bad idea.\n\n`fprof` can also skip the file step and trace to a tracer process that does the\nprofiling in runtime.\n\n[](){: #analysis }","ref":"fprof.html"},{"type":"module","title":"Analysis format - fprof","doc":"This section describes the output format of the `analyse/1` function.\n\nThe format is parsable with the standard Erlang parsing tools\n`m:erl_scan` and `m:erl_parse`, `file:consult/1`, or `io:read/2`. The\nparse format is not described here — it should be easy enough for the\ninterested reader to try it out. Note that some flags to\n[`analyse/1`](`analyse/1`) will affect the format.\n\nThe following example was run on Erlang/OTP R8 on Solaris 8; all OTP\ninternals in this example are version dependent.\n\nAs an example, we will use the following function, which is a\nslightly modified benchmark function from module `m:file`:\n\n```erlang\n-module(foo).\n-export([create_file_slow/2]).\n\ncreate_file_slow(Name, N) when is_integer(N), N >= 0 ->\n    {ok, FD} =\n        file:open(Name, [raw, write, delayed_write, binary]),\n    if N > 256 ->\n            ok = file:write(FD,\n                            lists:map(fun (X) -> < > end,\n                            lists:seq(0, 255))),\n            ok = create_file_slow(FD, 256, N);\n       true ->\n            ok = create_file_slow(FD, 0, N)\n    end,\n    ok = file:close(FD).\n\ncreate_file_slow(FD, M, M) ->\n    ok;\ncreate_file_slow(FD, M, N) ->\n    ok = file:write(FD, < >),\n    create_file_slow(FD, M+1, N).\n```\n\nLet us have a look at the printout after running:\n\n```erlang\n1> fprof:apply(foo, create_file_slow, [junk, 1024]).\n2> fprof:profile().\n3> fprof:analyse().\n```\n\nThe printout starts with:\n\n```erlang\n%% Analysis results:\n{  analysis_options,\n [{callers, true},\n  {sort, acc},\n  {totals, false},\n  {details, true}]}.\n\n%                                       CNT       ACC       OWN\n[{ totals,                             9627, 1691.119, 1659.074}].  %%%\n```\n\nThe `CNT` column shows the total number of function calls that was found in the\ntrace. In the `ACC` column is the total time of the trace from first timestamp to\nlast. And in the `OWN` column is the sum of the execution time in functions found\nin the trace, not including called functions. In this case it is very close to\nthe `ACC` time since the emulator had practically nothing to do except\nexecuting our test program.\n\nAll time values in the printout are in milliseconds.\n\nThe printout continues:\n\n```erlang\n%                                       CNT       ACC       OWN\n[{ \"<0.28.0>\",                         9627,undefined, 1659.074}].   %%\n```\n\nThis is the printout header of one process. The printout contains only this one\nprocess since we called `fprof:apply/3` that traces only the current process.\nTherefore the `CNT` and `OWN` columns perfectly matches the totals above. The `ACC`\ncolumn is undefined since summing the `ACC` times of all calls in the process\nmakes no sense — one would get something like the `ACC` value from totals above\nmultiplied by the average depth of the call stack.\n\nAll paragraphs up to the next process header only concerns function calls within\nthis process.\n\nNow we come to something more interesting:\n\n```erlang\n{[{undefined,                             0, 1691.076,    0.030}],\n { {fprof,apply_start_stop,4},            0, 1691.076,    0.030},     %\n [{{foo,create_file_slow,2},              1, 1691.046,    0.103},\n  {suspend,                               1,    0.000,    0.000}]}.\n\n{[{{fprof,apply_start_stop,4},            1, 1691.046,    0.103}],\n { {foo,create_file_slow,2},              1, 1691.046,    0.103},     %\n [{{file,close,1},                        1, 1398.873,    0.019},\n  {{foo,create_file_slow,3},              1,  249.678,    0.029},\n  {{file,open,2},                         1,   20.778,    0.055},\n  {{lists,map,2},                         1,   16.590,    0.043},\n  {{lists,seq,2},                         1,    4.708,    0.017},\n  {{file,write,2},                        1,    0.316,    0.021}]}.\n```\n\nThe printout consists of one paragraph per called function. The function\n_marked_ with `%` is the one the paragraph concerns — `foo:create_file_slow/2`.\nAbove the marked function are the _calling_ functions — those that has called\nthe marked, and below are those _called_ by the marked function.\n\nThe paragraphs are per default sorted in descending order of the `ACC` column for\nthe marked function. The calling list and called list within one paragraph are\nalso per default sorted in descending order of their `ACC` column.\n\nThe columns are:\n\n* `CNT` - the number of times the function has been called\n* `ACC` - the time spent in the function including called functions\n* `OWN` - the time spent in the function not including called functions\n\nThe rows for the _calling_ functions contain statistics for the _marked_\nfunction with the constraint that only the occasions when a call was made from\nthe _row's_ function to the _marked_ function are accounted for.\n\nThe row for the _marked_ function simply contains the sum of all _calling_ rows.\n\nThe rows for the _called_ functions contains statistics for the _row's_ function\nwith the constraint that only the occasions when a call was made from the\n_marked_ to the _row's_ function are accounted for.\n\nSo, we see that `foo:create_file_slow/2` used very little time for its own\nexecution. It spent most of its time in `file:close/1`. The function\n`foo:create_file_slow/3` that writes 3/4 of the file contents is the second\nbiggest time thief.\n\nWe also see that the call to `file:write/2` that writes 1/4 of the file contents\ntakes very little time in itself. What takes time is to build the data\n(`lists:seq/2` and `lists:map/2`).\n\nThe function `undefined` that has called `fprof:apply_start_stop/4` is an\nunknown function because that call was not recorded in the trace. It was only\nrecorded that the execution returned from `fprof:apply_start_stop/4` to some\nother function above in the call stack, or that the process exited from there.\n\nLet us continue down the printout to find:\n\n```erlang\n{[{{foo,create_file_slow,2},              1,  249.678,    0.029},\n  {{foo,create_file_slow,3},            768,    0.000,   23.294}],\n { {foo,create_file_slow,3},            769,  249.678,   23.323},     %\n [{{file,write,2},                      768,  220.314,   14.539},\n  {suspend,                              57,    6.041,    0.000},\n  {{foo,create_file_slow,3},            768,    0.000,   23.294}]}.\n```\n\nIf you compare with the code you will see there also that\n`foo:create_file_slow/3` was called only from `foo:create_file_slow/2` and\nitself, and called only `file:write/2`, note the number of calls to\n`file:write/2`. But here we see that `suspend` was called a few times. This is a\npseudo function that indicates that the process was suspended while executing in\n`foo:create_file_slow/3`, and since there is no `receive` or `erlang:yield/0` in\nthe code, it must be Erlang scheduling suspensions, or the trace file driver\ncompensating for large file write operations (these are regarded as a schedule\nout followed by a schedule in to the same process).\n\nLet us find the `suspend` entry:\n\n```erlang\n{[{{file,write,2},                       53,    6.281,    0.000},\n  {{foo,create_file_slow,3},             57,    6.041,    0.000},\n  {{prim_file,drv_command,4},            50,    4.582,    0.000},\n  {{prim_file,drv_get_response,1},       34,    2.986,    0.000},\n  {{lists,map,2},                        10,    2.104,    0.000},\n  {{prim_file,write,2},                  17,    1.852,    0.000},\n  {{erlang,port_command,2},              15,    1.713,    0.000},\n  {{prim_file,drv_command,2},            22,    1.482,    0.000},\n  {{prim_file,translate_response,2},     11,    1.441,    0.000},\n  {{prim_file,'-drv_command/2-fun-0-',1},  15,    1.340,    0.000},\n  {{lists,seq,4},                         3,    0.880,    0.000},\n  {{foo,'-create_file_slow/2-fun-0-',1},   5,    0.523,    0.000},\n  {{erlang,bump_reductions,1},            4,    0.503,    0.000},\n  {{prim_file,open_int_setopts,3},        1,    0.165,    0.000},\n  {{prim_file,i32,4},                     1,    0.109,    0.000},\n  {{fprof,apply_start_stop,4},            1,    0.000,    0.000}],\n { suspend,                             299,   32.002,    0.000},     %\n [ ]}.\n```\n\nWe find no particularly long suspend times, so no function seems to have waited\nin a receive statement. Actually, `prim_file:drv_command/4` contains a receive\nstatement, but in this test program, the message lies in the process receive\nbuffer when the receive statement is entered. We also see that the total suspend\ntime for the test run is small.\n\nThe `suspend` pseudo function has an `OWN` time of zero. This is to prevent\nthe process total `OWN` time from including time in suspension. Whether suspend\ntime is really `ACC` or `OWN` time is more of a philosophical question.\n\nNow we look at another interesting pseudo function, `garbage_collect`:\n\n```erlang\n{[{{prim_file,drv_command,4},            25,    0.873,    0.873},\n  {{prim_file,write,2},                  16,    0.692,    0.692},\n  {{lists,map,2},                         2,    0.195,    0.195}],\n { garbage_collect,                      43,    1.760,    1.760},     %\n [ ]}.\n```\n\nHere we see that no function stands out, which is very normal.\n\nThe `garbage_collect` pseudo function has not an `OWN` time of zero like\n`suspend`, instead it is equal to the `ACC` time.\n\nGarbage collection often occurs while a process is suspended, but `fprof` hides\nthis fact by pretending that the suspended function was first unsuspended and\nthen garbage collected. Otherwise the printout would show `garbage_collect`\nbeing called from `suspend`, but not which function that might have caused the\ngarbage collection.\n\nLet us now get back to the test code:\n\n```erlang\n{[{{foo,create_file_slow,3},            768,  220.314,   14.539},\n  {{foo,create_file_slow,2},              1,    0.316,    0.021}],\n { {file,write,2},                      769,  220.630,   14.560},     %\n [{{prim_file,write,2},                 769,  199.789,   22.573},\n  {suspend,                              53,    6.281,    0.000}]}.\n```\n\nNot unexpectedly, we see that `file:write/2` was called from\n`foo:create_file_slow/3` and `foo:create_file_slow/2`. The number of calls in\neach case as well as the used time are also confirms the previous results.\n\nWe see that `file:write/2` only calls `prim_file:write/2`, but let us refrain\nfrom digging into the internals of the kernel application.\n\nIf we nevertheless _do_ dig down we find the call to the linked-in driver\nthat does the file operations towards the host operating system:\n\n```erlang\n{[{{prim_file,drv_command,4},           772, 1458.356, 1456.643}],\n { {erlang,port_command,2},             772, 1458.356, 1456.643},     %\n [{suspend,                              15,    1.713,    0.000}]}.\n```\n\nThis is 86 % of the total run time, and as we saw before it is the close\noperation the absolutely biggest contributor. We find a comparison ratio a\nlittle bit up in the call stack:\n\n```erlang\n{[{{prim_file,close,1},                   1, 1398.748,    0.024},\n  {{prim_file,write,2},                 769,  174.672,   12.810},\n  {{prim_file,open_int,4},                1,   19.755,    0.017},\n  {{prim_file,open_int_setopts,3},        1,    0.147,    0.016}],\n { {prim_file,drv_command,2},           772, 1593.322,   12.867},     %\n [{{prim_file,drv_command,4},           772, 1578.973,   27.265},\n  {suspend,                              22,    1.482,    0.000}]}.\n```\n\nThe time for file operations in the linked in driver distributes itself as 1 %\nfor open, 11 % for write, and 87 % for close. All data is probably buffered in\nthe operating system until the close.\n\nThe observant reader may notice that the ACC times for\n`prim_file:drv_command/2` and `prim_file:drv_command/4` is not equal between the\nparagraphs above, even though it is easy to believe that\n`prim_file:drv_command/2` is just a passthrough function.\n\nThe missing time can be found in the paragraph for `prim_file:drv_command/4`\nwhere it is evident that not only `prim_file:drv_command/2` is called but also a\nfun:\n\n```erlang\n{[{{prim_file,drv_command,2},           772, 1578.973,   27.265}],\n { {prim_file,drv_command,4},           772, 1578.973,   27.265},     %\n [{{erlang,port_command,2},             772, 1458.356, 1456.643},\n  {{prim_file,'-drv_command/2-fun-0-',1}, 772,   87.897,   12.736},\n  {suspend,                              50,    4.582,    0.000},\n  {garbage_collect,                      25,    0.873,    0.873}]}.\n```\n\nAnd some more missing time can be explained by the fact that\n`prim_file:open_int/4` both calls `prim_file:drv_command/2` directly as well as\nthrough `prim_file:open_int_setopts/3`, which complicates the picture.\n\n```erlang\n{[{{prim_file,open,2},                    1,   20.309,    0.029},\n  {{prim_file,open_int,4},                1,    0.000,    0.057}],\n { {prim_file,open_int,4},                2,   20.309,    0.086},     %\n [{{prim_file,drv_command,2},             1,   19.755,    0.017},\n  {{prim_file,open_int_setopts,3},        1,    0.360,    0.032},\n  {{prim_file,drv_open,2},                1,    0.071,    0.030},\n  {{erlang,list_to_binary,1},             1,    0.020,    0.020},\n  {{prim_file,i32,1},                     1,    0.017,    0.017},\n  {{prim_file,open_int,4},                1,    0.000,    0.057}]}.\n.\n.\n.\n{[{{prim_file,open_int,4},                1,    0.360,    0.032},\n  {{prim_file,open_int_setopts,3},        1,    0.000,    0.016}],\n { {prim_file,open_int_setopts,3},        2,    0.360,    0.048},     %\n [{suspend,                               1,    0.165,    0.000},\n  {{prim_file,drv_command,2},             1,    0.147,    0.016},\n  {{prim_file,open_int_setopts,3},        1,    0.000,    0.016}]}.\n```","ref":"fprof.html#module-analysis-format"},{"type":"module","title":"Notes - fprof","doc":"The actual supervision of execution times is in itself a CPU-intensive activity.\nA message is written on the trace file for every function call that is made by\nthe profiled code.\n\nThe `ACC` time calculation is sometimes difficult to make correct, since it is\ndifficult to define. This happens especially when a function occurs in several\ninstances in the call stack, for example by calling itself perhaps through other\nfunctions and perhaps even non-tail recursively.\n\nTo produce sensible results, `fprof` tries not to charge any function more than\nonce for `ACC` time. The instance highest up (with longest duration) in the call\nstack is chosen.\n\nSometimes a function can unexpectedly waste a lot (some 10 ms or more depending\non host machine OS) of `OWN` (and `ACC`) time, even functions that do practically\nnothing at all. The problem may be that the OS has chosen to schedule out the\nErlang runtime system process for a while, and if the OS does not support high\nresolution CPU time measurements `fprof` will use wallclock time for its\ncalculations, and it will appear as if functions are randomly burning virtual\nmachine time.","ref":"fprof.html#module-notes"},{"type":"module","title":"See Also - fprof","doc":"[fprof - The File Trace Profiler](fprof_chapter.md), `m:dbg`, `m:eprof`","ref":"fprof.html#module-see-also"},{"type":"function","title":"fprof.analyse/0","doc":"Equivalent to  analyse([]) .","ref":"fprof.html#analyse/0"},{"type":"function","title":"fprof.analyse/1","doc":"Analyses raw profile data in the `fprof` server.\n\nIf `Arg` is an atom, this call is equivalent to `analyse([Arg])`.\n\nIf `Arg` is a a tuple `{Option, _}`, this call is equivalent to\n`analyse([Option])`.\n\nOtherwise `Arg` must be a list of valid options.\n\nIf called when no raw profile data is available, `{error, no_profile}`\nis returned.\n\n`Destfile` is used to call `file:open/2`.\n\nOption description:\n\n- **`dest` | `{dest, Dest}`** - Specifies the destination for the analysis. If\n  this option is not given or it is `dest`, the destination will be the caller's\n  group leader, otherwise the destination `Dest` is either the `t:pid/0` of an\n  I/O device or a filename. If the filename is `[]`, `\"fprof.analysis\"` is used\n  instead.\n\n- **`append`** - Causes the analysis to be appended to the destination file.\n  This option is only allowed with the `{dest, Destfile}` option.\n\n- **`{cols, Cols}`** - Specifies the number of columns in the analysis text. If\n  this option is not given the number of columns is set to 80.\n\n- **`callers` | `{callers, true}`** - Prints callers and called information in\n  the analysis. This is the default.\n\n- **`{callers, false}` | `no_callers`** - Suppresses the printing of callers and\n  called information in the analysis.\n\n- **`{sort, SortSpec}`** - Specifies if the analysis should be sorted according\n  to the ACC column, which is the default, or the OWN column. See\n  [Analysis Format](`m:fprof#analysis`) below.\n\n- **`totals` | `{totals, true}`** - Includes a section containing call\n  statistics for all calls regardless of process, in the analysis.\n\n- **`{totals, false}`** - Suppresses the totals section in the analysis, which\n  is the default.\n\n- **`details` | `{details, true}`** - Prints call statistics for each process in\n  the analysis. This is the default.\n\n- **`{details, false}` | `no_details`** - Suppresses the call statistics for\n  each process from the analysis.","ref":"fprof.html#analyse/1"},{"type":"function","title":"fprof.analyse/2","doc":"Equivalent to  analyse([{OptionName, OptionValue}]) .","ref":"fprof.html#analyse/2"},{"type":"type","title":"fprof.analyse_option/0","doc":"","ref":"fprof.html#t:analyse_option/0"},{"type":"function","title":"fprof.apply/2","doc":"Equivalent to  apply(Func, Args, []) .","ref":"fprof.html#apply/2"},{"type":"function","title":"fprof.apply/3","doc":"Calls the given function surrounded by\n[`trace([start, ...])`](`trace/1`) and\n[`trace(stop)`](`trace/1`).\n\nIf the function arguments (`Arg1`, `Arg2`, and `Arg3`) are `Module`\n(an atom), `Function` (an atom), and `Args` (a list), the function\nwill be called using\n[`erlang:apply(Module, Function, Args)`](`erlang:apply/3`).\n\nIf the function arguments are `Func` (a fun), `Args` (a list), and\n`OptionList` (a list of options), the fun will be called using\n[`erlang:apply(Func, Args)`](`erlang:apply/2`).\n\nSome effort is made to keep the trace clean from unnecessary trace messages;\ntracing is started and stopped from a spawned process while `erlang:apply/2`\nis called in the current process only surrounded by `receive` and `send`\nstatements towards the trace starting process. The trace starting process exits\nwhen it is not needed any more.\n\nThe `TraceStartOption` is any option allowed for `trace/1`. The\noptions `[start, {procs, [self() | PidList]} | OptList]` are given to\n[`trace/1`](`trace/1`), where `OptList` is `OptionList` with the\n`continue`, `start` and `{procs, _}` options removed.\n\nThe `continue` option inhibits the call to [`trace(stop)`](`trace/1`) and leaves\nit up to the caller to stop tracing at a suitable time.","ref":"fprof.html#apply/3"},{"type":"function","title":"fprof.apply/4","doc":"Equivalent to  apply({Module, Function}, Args, OptionList) .","ref":"fprof.html#apply/4"},{"type":"type","title":"fprof.apply_option/0","doc":"","ref":"fprof.html#t:apply_option/0"},{"type":"type","title":"fprof.pid_spec/0","doc":"","ref":"fprof.html#t:pid_spec/0"},{"type":"function","title":"fprof.profile/0","doc":"Equivalent to  profile([]) .","ref":"fprof.html#profile/0"},{"type":"function","title":"fprof.profile/1","doc":"Compiles a trace into raw profile data held by the `fprof` server.\n\nIf `Arg` is an atom, this call is equivalent to `profile([Arg])`.\n\nIf `Arg` is a tuple `{OptionName, OptionValue}`,\nthis call is equivalent to `profile([Arg])`.\n\nOtherwise, `Arg` must be a list of options.\n\n`Dumpfile` is used to call `file:open/2`, and `Filename` is used to call\n[`dbg:trace_port(file, Filename)`](`dbg:trace_port/2`).\n\nThe following options are supported:\n\n- **`file` | `{file, Filename}`** - Reads the file `Filename` and creates raw\n  profile data that is stored in RAM by the `fprof` server. If the option `file`\n  is given, or none of these options are given, the file `fprof.trace` is\n  read. The call will return when the whole trace has been read with the return\n  value `ok` if successful. This option is not allowed with the `start` or\n  `stop` options.\n\n- **`dump` | `{dump, Dump}`** - Specifies the destination for the trace text\n  dump. If this option is not given, no dump is generated, if it is `dump` the\n  destination will be the caller's group leader, otherwise the destination\n  `Dump` is either the pid of an I/O device or a filename. If the\n  filename is `[]`, `\"fprof.dump\"` is used instead. This option cannot be\n  combined with the `stop` option.\n\n- **`append`** - Causes the trace text dump to be appended to the destination\n  file. This option is only allowed with the `{dump, Dumpfile}` option.\n\n- **`start`** - Starts a tracer process that profiles trace data in runtime. The\n  call will return immediately with the return value `{ok, Tracer}` if\n  successful. This option is not allowed with the `stop`, `file`, or\n  `{file, Filename}` options.\n\n- **`stop`** - Stops the tracer process that profiles trace data in runtime. The\n  return value will be value `ok` if successful. This option cannot be combined\n  with the `start`, `file`, or `{file, Filename}` options.","ref":"fprof.html#profile/1"},{"type":"function","title":"fprof.profile/2","doc":"Equivalent to  profile([{OptionName, OptionValue}]) .","ref":"fprof.html#profile/2"},{"type":"type","title":"fprof.profile_option/0","doc":"","ref":"fprof.html#t:profile_option/0"},{"type":"function","title":"fprof.start/0","doc":"Starts the `fprof` server.\n\nNote that there is seldom any need to call this function directly, since\nthe server will be automatically started by any function that will need it.","ref":"fprof.html#start/0"},{"type":"function","title":"fprof.stop/0","doc":"Equivalent to  stop(normal) .","ref":"fprof.html#stop/0"},{"type":"function","title":"fprof.stop/1","doc":"Stops the `fprof` server.\n\nThe supplied `Reason` becomes the exit reason for the server process. By default,\nany `Reason` other than `kill` sends a request to the server and waits for it to\nclean up, reply, and exit. If `Reason` is `kill`, the server is bluntly killed.\n\nIf the `fprof` server is not running, this function returns immediately.\n\n> #### Note {: .info }\n>\n> When the `fprof` server is stopped the collected raw profile data is lost.","ref":"fprof.html#stop/1"},{"type":"function","title":"fprof.trace/1","doc":"Starts or stops tracing.\n\nIf `Arg` is atom `verbose`, this call is equivalent to\n`trace([start, verbose])`.\n\nIf `Arg` is an atom, this call is equivalent to\n`trace([Arg])`.\n\nIf `Arg` is a tuple `{OptionName, OptionValue}`, this call is equivalent to\n`trace([Arg])`.\n\nOtherwise, `Arg` has to be a list of [trace options](`t:trace_option/0`).\n\n`PidSpec` and `Tracer` are used in calls to\n[`erlang:trace(PidSpec, true, [{tracer, Tracer} | Flags])`](`erlang:trace/3`),\nand `Filename` is used to call\n[`dbg:trace_port(file, Filename)`](`dbg:trace_port/2`).\n\nOption description:\n\n- **`stop`** - Stops a running `fprof` trace and clears all tracing from the\n  node. Either option `stop` or `start` must be specified, but not both.\n\n- **`start`** - Clears all tracing from the node and starts a new `fprof` trace.\n  Either option `start` or `stop` must be specified, but not both.\n\n- **`verbose` | `{verbose, boolean()}`** - The `verbose` or\n  `{verbose, true}` options add some trace flags that `fprof` does not need, but that\n  can be interesting for general debugging purposes. These options are only allowed\n  with the `start` option.\n\n- **`cpu_time` | `{cpu_time, boolean()}`** - The `cpu_time` or\n  `{cpu_time, true}` options make the timestamps in the trace be in CPU time instead of\n  the default wallclock time. These options are only allowed with the\n  `start` option.\n\n  > #### Note {: .info }\n  >\n  > Getting correct values out of `cpu_time` can be difficult. The best way to get\n  > correct values is to run using a single scheduler and bind that scheduler to\n  > a specific CPU. For example:\n  >\n  > ```bash\n  > erl +S 1 +sbt db`\n  > ```\n\n- **`{procs, PidSpec}` | `{procs, [PidSpec]}`** - Specifies which processes that\n  should be traced. If this option is not given, the calling process is traced.\n  All processes spawned by the traced processes are also traced. This option is\n  only allowed with the `start` option.\n\n- **`file` | `{file, Filename}`** - Specifies the filename of the trace. If the\n  option `file` is given, or none of these options are given, the file\n  `fprof.trace` is used. This option is only allowed with the `start` option,\n  but not with the `{tracer, Tracer}` option.\n\n- **`{tracer, Tracer}`** - Specifies that trace to process or port shall be done\n  instead of trace to file. This option is only allowed with the `start` option,\n  but not with the `{file, Filename}` option.","ref":"fprof.html#trace/1"},{"type":"function","title":"fprof.trace/2","doc":"Starts or stop tracing.\n\nIf `What` is atom `start`, this call is equivalent to\n[`trace([start, {file, Value}])`](`trace/1`).\n\nIf `What` is atom `verbose`, this call is equivalent to\n[`trace([start, verbose, {file, Value}])`](`trace/1`).\n\nIf `What` is a tuple `{OptionName, OptionValue}`,\nthis call is equivalent to\n[`trace([What])`](`trace/1`).","ref":"fprof.html#trace/2"},{"type":"type","title":"fprof.trace_option/0","doc":"","ref":"fprof.html#t:trace_option/0"},{"type":"module","title":"lcnt","doc":"A runtime system Lock Profiling tool.\n\nThe `lcnt` module is used to profile the internal ethread locks in the Erlang\nRuntime System. With `lcnt` enabled, internal counters in the runtime system are\nupdated each time a lock is taken. The counters stores information about the\nnumber of acquisition tries and the number of collisions that has occurred\nduring the acquisition tries. The counters also record the waiting time a lock\nhas caused for a blocked thread when a collision has occurred.\n\nThe data produced by the lock counters will give an estimate on how well the\nruntime system will behave from a parallelizable view point for the scenarios\ntested. This tool was mainly developed to help Erlang runtime developers iron\nout potential and generic bottlenecks.\n\nLocks in the emulator are named after what type of resource they protect and\nwhere in the emulator they are initialized, those are lock 'classes'. Most of\nthose locks are also instantiated several times, and given unique identifiers,\nto increase locking granularity. Typically an instantiated lock protects a\ndisjunct set of the resource, for example ets tables, processes or ports. In\nother cases it protects a specific range of a resource, for example `pix_lock`\nwhich protects index to process mappings, and is given a unique number within\nthe class. A unique lock in `lcnt` is referenced by a name (class) and an\nidentifier: `{Name, Id}`.\n\nSome locks in the system are static and protects global resources, for example\n`bif_timers` and the `run_queue` locks. Other locks are dynamic and not\nnecessarily long lived, for example process locks and ets-table locks. The\nstatistics data from short lived locks can be stored separately when the locks\nare deleted. This behavior is by default turned off to save memory but can be\nturned on via `lcnt:rt_opt({copy_save, true})`. The `lcnt:apply/1,2,3` functions\nenables this behavior during profiling.","ref":"lcnt.html"},{"type":"module","title":"See Also - lcnt","doc":"[LCNT User's Guide](lcnt_chapter.md)","ref":"lcnt.html#module-see-also"},{"type":"function","title":"lcnt.apply/1","doc":"Equivalent to  apply(Fun, []) .","ref":"lcnt.html#apply/1"},{"type":"function","title":"lcnt.apply/2","doc":"Sets up lock counters, applies `Fun` with `Args`, and cleans up.\n\nClears the lock counters and then setups the instrumentation to save all\ndestroyed locks. After setup the function is called, passing the elements in\n`Args` as arguments. When the function returns the statistics are immediately\ncollected to the server. After the collection the instrumentation is returned to\nits previous behavior. The result of the applied function is returned.\n\n> #### Warning {: .warning }\n>\n> This function should only be used for micro-benchmarks; it sets `copy_save` to\n> `true` for the duration of the call, which can quickly lead to running out of\n> memory.","ref":"lcnt.html#apply/2"},{"type":"function","title":"lcnt.apply/3","doc":"Equivalent to  apply(fun() -> apply(Module, Function, Args) end) .","ref":"lcnt.html#apply/3"},{"type":"type","title":"lcnt.category_atom/0","doc":"","ref":"lcnt.html#t:category_atom/0"},{"type":"function","title":"lcnt.clear/0","doc":"Equivalent to  clear(node()) .","ref":"lcnt.html#clear/0"},{"type":"function","title":"lcnt.clear/1","doc":"Clears the internal lock statistics from the runtime system.\n\nThis clears the data in the runtime system but not in server.  All\ncounters for static locks are zeroed, all dynamic locks currently\nalive are zeroed and all saved locks now destroyed are removed. It\nalso resets the duration timer.","ref":"lcnt.html#clear/1"},{"type":"function","title":"lcnt.collect/0","doc":"Equivalent to  collect(node()) .","ref":"lcnt.html#collect/0"},{"type":"function","title":"lcnt.collect/1","doc":"Collects lock statistics from the runtime system.\n\nThe function starts a server if it is not already started. It then\npopulates the server with lock statistics.  If the server held any\nlock statistics data before the collect then that data is lost.","ref":"lcnt.html#collect/1"},{"type":"function","title":"lcnt.conflicts/0","doc":"Equivalent to  conflicts([]) .","ref":"lcnt.html#conflicts/0"},{"type":"function","title":"lcnt.conflicts/1","doc":"Prints a list of internal locks and its statistics.\n\nFor option description, see [`lcnt:inspect/2`](`inspect/2`).","ref":"lcnt.html#conflicts/1"},{"type":"function","title":"lcnt.information/0","doc":"Prints `lcnt` server state and generic information about collected lock\nstatistics.","ref":"lcnt.html#information/0"},{"type":"function","title":"lcnt.inspect/1","doc":"Equivalent to  inspect(Lock, []) .","ref":"lcnt.html#inspect/1"},{"type":"function","title":"lcnt.inspect/2","doc":"Prints a list of internal lock counters for a specific lock.\n\nLock `Name` and `Id` for ports and processes are interchangeable with the use of\n[`lcnt:swap_pid_keys/0`](`swap_pid_keys/0`) and is the reason why `t:pid/0` and\n`t:port/0` options can be used in both `Name` and `Id` space. Both pids and\nports are special identifiers with stripped creation and can be recreated with\n[`lcnt:pid/2,3`](`pid/3`) and [`lcnt:port/1,2`](`port/2`).\n\nOption description:\n\n- **`{combine, boolean()}`** - Combine the statistics from different instances\n  of a lock class.  \n  Default: `true`\n\n- **`{locations, boolean()}`** - Print the statistics by source file and line\n  numbers.  \n  Default: `false`\n\n- **`{max_locks, MaxLocks}`** - Maximum number of locks printed or no limit with\n  `none`.  \n  Default: `20`\n\n- **`{print, PrintOptions}`** - Printing options:\n\n  - **`name`** - Named lock or named set of locks (classes). The same name used\n    for initializing the lock in the VM.\n\n  - **`id`** - Internal id for set of locks, not always unique. This could be\n    table name for ets tables (db_tab), port id for ports, integer identifiers\n    for allocators, etc.\n\n  - **`type`** - Type of lock: `rw_mutex`, `mutex`, `spinlock`, `rw_spinlock` or\n    `proclock`.\n\n  - **`entry`** - In combination with `{locations, true}` this option prints the\n    lock operations source file and line number entry-points along with\n    statistics for each entry.\n\n  - **`tries`** - Number of acquisitions of this lock.\n\n  - **`colls`** - Number of collisions when a thread tried to acquire this lock.\n    This is when a trylock is EBUSY, a write try on read held rw_lock, a try\n    read on write held rw_lock, a thread tries to lock an already locked lock.\n    (Internal states supervises this.)\n\n  - **`ratio`** - The ratio between the number of collisions and the number of\n    tries (acquisitions) in percentage.\n\n  - **`time`** - Accumulated waiting time for this lock. This could be greater\n    than actual wall clock time, it is accumulated for all threads. Trylock\n    conflicts does not accumulate time.\n\n  - **`duration`** - Percentage of accumulated waiting time of wall clock time.\n    This percentage can be higher than 100% since accumulated time is from all\n    threads.\n\n  Default: `[name,id,tries,colls,ratio,time,duration]`\n\n- **`{reverse, boolean()}`** - Reverses the order of sorting.  \n  Default: `false`\n\n- **`{sort, Sort}`** - Column sorting orders.  \n  Default: `time`\n\n- **`{thresholds, Thresholds}`** - Filtering thresholds. Anything values above\n  the threshold value are passed through.  \n  Default: `[{tries, 0}, {colls, 0}, {time, 0}]`","ref":"lcnt.html#inspect/2"},{"type":"function","title":"lcnt.load/1","doc":"Restores previously saved data to the server.","ref":"lcnt.html#load/1"},{"type":"function","title":"lcnt.locations/0","doc":"Equivalent to  locations([]) .","ref":"lcnt.html#locations/0"},{"type":"function","title":"lcnt.locations/1","doc":"Prints a list of internal lock counters by source code locations.\n\nFor option description, see [`lcnt:inspect/2`](`inspect/2`).","ref":"lcnt.html#locations/1"},{"type":"type","title":"lcnt.lock_counter_data/0","doc":"","ref":"lcnt.html#t:lock_counter_data/0"},{"type":"type","title":"lcnt.option/0","doc":"","ref":"lcnt.html#t:option/0"},{"type":"function","title":"lcnt.pid/2","doc":"Equivalent to  pid(node(), Id, Serial) .","ref":"lcnt.html#pid/2"},{"type":"function","title":"lcnt.pid/3","doc":"Creates a process id with creation 0.","ref":"lcnt.html#pid/3"},{"type":"function","title":"lcnt.port/1","doc":"Equivalent to  port(node(), Id) .","ref":"lcnt.html#port/1"},{"type":"function","title":"lcnt.port/2","doc":"Creates a port id with creation 0.","ref":"lcnt.html#port/2"},{"type":"type","title":"lcnt.print/0","doc":"","ref":"lcnt.html#t:print/0"},{"type":"function","title":"lcnt.rt_clear/0","doc":"Equivalent to  rt_clear(node()) .","ref":"lcnt.html#rt_clear/0"},{"type":"function","title":"lcnt.rt_clear/1","doc":"Clear the internal counters.\n\nEquivalent to [`lcnt:clear(Node)`](`clear/1`).","ref":"lcnt.html#rt_clear/1"},{"type":"function","title":"lcnt.rt_collect/0","doc":"Equivalent to  rt_collect(node()) .","ref":"lcnt.html#rt_collect/0"},{"type":"function","title":"lcnt.rt_collect/1","doc":"Returns a list of raw lock counter data.","ref":"lcnt.html#rt_collect/1"},{"type":"function","title":"lcnt.rt_mask/0","doc":"Return the current category mask for the current node.","ref":"lcnt.html#rt_mask/0"},{"type":"function","title":"lcnt.rt_mask/1","doc":"Sets the current lock category mask for the current node or\nretrieves the current mask for a remote node.\n\nIf `Arg` is an atom, it is assumed to be a node, and this\ncall returns the current lock category mask for node `Arg`.\n\nIf `Arg` is a list, this call is equivalent to\n[`rt_mask(node(), Arg)`](`rt_mask/2`).","ref":"lcnt.html#rt_mask/1"},{"type":"function","title":"lcnt.rt_mask/2","doc":"Sets the lock category mask according to `Categories` on node `Node`.\n\nThis call will fail if the `copy_save` option is enabled; see\n[`lcnt:rt_opt/2`](`rt_opt/2`).\n\nValid categories are:\n\n- `allocator`\n- `db` (ETS tables)\n- `debug`\n- `distribution`\n- `generic`\n- `io`\n- `process`\n- `scheduler`\n\nThis list is subject to change at any time, as is the category any given lock\nbelongs to.","ref":"lcnt.html#rt_mask/2"},{"type":"function","title":"lcnt.rt_opt/1","doc":"Equivalent to  rt_opt(node(), {Type, Value}) .","ref":"lcnt.html#rt_opt/1"},{"type":"function","title":"lcnt.rt_opt/2","doc":"Sets a single option on node `Node`.\n\nOption description:\n\n- **`{copy_save, boolean()}`** - Retains the statistics of destroyed locks.  \n  Default: `false`\n\n  > #### Warning {: .warning }\n  >\n  > This option will use a lot of memory when enabled, which must be reclaimed\n  > with [`lcnt:rt_clear/0,1`](`lcnt:rt_clear/1`). Note that it makes no\n  > distinction between locks that  were destroyed and locks for which counting\n  > was disabled, so enabling this option will disable changes to the lock\n  > category mask.\n\n- **`{process_locks, boolean()}`** - Profile process locks, equal to adding\n  `process` to the lock category mask; see `lcnt:rt_mask/2`.  \n  Default: `true`","ref":"lcnt.html#rt_opt/2"},{"type":"function","title":"lcnt.save/1","doc":"Saves the collected data to file.","ref":"lcnt.html#save/1"},{"type":"type","title":"lcnt.sort/0","doc":"","ref":"lcnt.html#t:sort/0"},{"type":"function","title":"lcnt.start/0","doc":"Starts the lock profiler server.\n\nThe server only act as a medium for the user and performs filtering\nand printing of data collected by `lcnt:collect/1`.","ref":"lcnt.html#start/0"},{"type":"function","title":"lcnt.stop/0","doc":"Stops the lock profiler server.","ref":"lcnt.html#stop/0"},{"type":"function","title":"lcnt.swap_pid_keys/0","doc":"Swaps places on `Name` and `Id` space for ports and processes.","ref":"lcnt.html#swap_pid_keys/0"},{"type":"type","title":"lcnt.threshold/0","doc":"","ref":"lcnt.html#t:threshold/0"},{"type":"module","title":"make","doc":"A Make Utility for Erlang\n\nThe module `make` provides a set of functions similar to the UNIX type `Make`\nfunctions.","ref":"make.html"},{"type":"module","title":"Emakefile - make","doc":"[`make:all/0,1`](`all/1`) and [`make:files/1,2`](`files/2`) first looks for\n`{emake, Emake}` in options, then in the current working directory for a file\nnamed `Emakefile`. If present `Emake` should contain elements like this:\n\n```text\nModules.\n{Modules,Options}.\n```\n\n`Modules` is an atom or a list of atoms. It can be\n\n- a module name, for exmaple,  `file1`\n- a module name in another directory, for exmaple, `'../foo/file3'`\n- a set of modules specified with a wildcards, for exmaple, `'file*'`\n- a wildcard indicating all modules in current directory, that is: `'*'`\n- a list of any of the above, for exmaple, `['file*','../foo/file3','File4']`\n\n`Options` is a list of compiler options.\n\n`Emakefile` is read from top to bottom. If a module matches more than one entry,\nthe first match is used. For example, the following `Emakefile` means that\n`file1` should be compiled with the options `[debug_info,{i,\"../foo\"}]`, while\nall other files in the current directory should be compiled with only the\n`debug_info` flag.\n\n```erlang\n{'file1',[debug_info,{i,\"../foo\"}]}.\n{'*',[debug_info]}.\n```","ref":"make.html#module-emakefile"},{"type":"module","title":"See Also - make","doc":"[The Compiler Application](`m:compile`)","ref":"make.html#module-see-also"},{"type":"function","title":"make.all/0","doc":"Equivalent to  all([]) .","ref":"make.html#all/0"},{"type":"function","title":"make.all/1","doc":"This function determines the set of modules to compile and the compile options\nto use, by first looking for the `emake` make option, if not present reads the\nconfiguration from a file named `Emakefile` (see below). If no such file is\nfound, the set of modules to compile defaults to all modules in the current\nworking directory.\n\nTraversing the set of modules, it then recompiles every module for which at\nleast one of the following conditions apply:\n\n- there is no object file, or\n- the source file has been modified since it was last compiled, or,\n- an include file has been modified since the source file was last compiled.\n\nAs a side effect, the function prints the name of each module it tries to\ncompile. If compilation fails for a module, the make procedure stops and `error`\nis returned.\n\n`Options` is a list of options for `make` and the Erlang compiler. The following\n`make` options exist:\n\n- `noexec`\n  No execution mode. Just prints the name of each module that needs to be\n  compiled.\n- `load`\n  Load mode. Loads all recompiled modules.\n- `netload`\n  Net load mode. Loads all recompiled modules on all known nodes.\n- `{emake, Emake}`\n  Rather than reading the `Emakefile` specify configuration explicitly.\n\nAll items in `Options` that are not make options are assumed to be compiler\noptions and are passed as-is to `compile:file/2`.","ref":"make.html#all/1"},{"type":"function","title":"make.files/1","doc":"Equivalent to  files(ModFiles, []) .","ref":"make.html#files/1"},{"type":"function","title":"make.files/2","doc":"This function does exactly the same thing as [`all/0,1`](`all/0`), but for the\nspecified `ModFiles`, which is a list of module or file names.\n\nThe file extension `.erl` can be omitted.\n\nThe `Emakefile` (if it exists) in the current directory is searched for compiler\noptions for each module. If a given module does not exist in `Emakefile` or if\n`Emakefile` does not exist, the module is still compiled.","ref":"make.html#files/2"},{"type":"module","title":"tags","doc":"Generate Emacs TAGS file from Erlang source files\n\nA `TAGS` file is used by Emacs to find function and variable definitions in any\nsource file in large projects. This module can generate a `TAGS` file from\nErlang source files. It recognises functions, records, and macro definitions.","ref":"tags.html"},{"type":"module","title":"Options - tags","doc":"The functions in this module have an optional argument `Options`. It\nis a list which can contain the following elements:\n\n- `{outfile, NameOfTAGSFile}` Create a `TAGS` file named `NameOfTAGSFile`.\n- `{outdir, NameOfDirectory}` Create a file named `TAGS` in the directory\n  `NameOfDirectory`.\n\nThe default behaviour is to create a file named `TAGS` in the current directory.","ref":"tags.html#module-options"},{"type":"module","title":"Examples - tags","doc":"- `tags:root([{outfile, \"root.TAGS\"}]).`\n\n  This command will create a file named `root.TAGS` in the current directory.\n  The file will contain references to all Erlang source files in the Erlang\n  distribution.\n\n- `tags:files([\"foo.erl\", \"bar.erl\", \"baz.erl\"], [{outdir, \"../projectdir\"}]).`\n\n  This command will create a file named `TAGS` placed it in the\n  directory `../projectdir`. The file contains information about the\n  functions, records, and macro definitions of the three files.","ref":"tags.html#module-examples"},{"type":"module","title":"See Also - tags","doc":"- Richard M. Stallman. GNU Emacs Manual, chapter \"Editing Programs\", section\n  \"Tag Tables\". Free Software Foundation, 1995.\n- Anders Lindgren. The Erlang editing mode for Emacs. Ericsson, 1998.","ref":"tags.html#module-see-also"},{"type":"function","title":"tags.dir/1","doc":"Equivalent to  dir(Dir, []) .","ref":"tags.html#dir/1"},{"type":"function","title":"tags.dir/2","doc":"Create a `TAGS` file for all files in directory `Dir`.","ref":"tags.html#dir/2"},{"type":"function","title":"tags.dirs/1","doc":"Equivalent to  dirs(Dirs, []) .","ref":"tags.html#dirs/1"},{"type":"function","title":"tags.dirs/2","doc":"Create a `TAGS` file for all files in any directory in `DirList`.","ref":"tags.html#dirs/2"},{"type":"function","title":"tags.file/1","doc":"Equivalent to  file(Name, []) .","ref":"tags.html#file/1"},{"type":"function","title":"tags.file/2","doc":"Create a `TAGS` file for the file `File`.","ref":"tags.html#file/2"},{"type":"function","title":"tags.files/1","doc":"Equivalent to  files(Files, []) .","ref":"tags.html#files/1"},{"type":"function","title":"tags.files/2","doc":"Create a `TAGS` file for the files in the list `FileList`.","ref":"tags.html#files/2"},{"type":"type","title":"tags.option/0","doc":"","ref":"tags.html#t:option/0"},{"type":"function","title":"tags.root/0","doc":"Equivalent to  root([]) .","ref":"tags.html#root/0"},{"type":"function","title":"tags.root/1","doc":"Create a `TAGS` file covering all files in the Erlang distribution.","ref":"tags.html#root/1"},{"type":"function","title":"tags.subdir/1","doc":"Equivalent to  subdir(Dir, []) .","ref":"tags.html#subdir/1"},{"type":"function","title":"tags.subdir/2","doc":"Descend recursively into the directory `Dir` and create a `TAGS` file based on\nall files found.","ref":"tags.html#subdir/2"},{"type":"function","title":"tags.subdirs/1","doc":"Equivalent to  subdirs(Dirs, []) .","ref":"tags.html#subdirs/1"},{"type":"function","title":"tags.subdirs/2","doc":"Descend recursively into the directories in `DirList` and create a `TAGS`\nfile based on all files found.","ref":"tags.html#subdirs/2"},{"type":"module","title":"tprof","doc":"Process Tracing Profiling Tool\n\n`tprof` provides convenience helpers for Erlang process profiling using\nthe trace BIFs.\n\n> #### Warning {: .warning }\n>\n> This module aims to replace `eprof` and `cprof` into a unified API for\n> measuring call count, time, and allocation. It is experimental in Erlang/OTP\n> 27.0.\n\nIt is possible to analyze the number of calls, the time spent by function, and\nheap allocations by function. Profiling can be done [ad-hoc](#module-ad-hoc-profiling)\n or run in a [server-aided mode](#module-server-aided-profiling) for deeper\nintrospection of the code running in production. The server-aided mode can be\nrun using the default tprof server or an isolated `t:server/0` started through\n[`start(#{ session => atom() })`](`start/1`).\n\nThere are [three kinds of profiling](`t:trace_type/0`) supported by this module:\n\n- `call_count`\n- `call_time`\n- `call_memory`\n\nThe default is `call_count`, which has the smallest performance impact\nand memory footprint, but it does not support per-process\nprofiling. For this reason, all of the examples below uses\n`call_memory`, which measures heap allocation, and provide a more complex\nfeature set to demonstrate.\n\nErlang terms that do not fit in a single machine word are allocated on\nthe process heap. For example, a function returning a tuple of two\nelements needs to allocate the tuple on the process heap. The actual\nconsumption is three words, because the runtime systems also need an\nextra word to store the tuple size.\n\n> #### Note {: .info }\n>\n> Expect a slowdown in the program execution when profiling is enabled.\n>\n> For profiling convenience, measurements are accumulated for functions that are\n> not enabled in some trace pattern. Consider this call stack example:\n>\n> ```text\n> top_traced_function(...)\n> not_traced_function()\n> bottom_traced_function()\n> ```\n>\n> Allocations that happened within `not_traced_function` will be added to\n> the allocations for `top_traced_function`. However, allocations that occurred\n> within `bottom_traced_function` are not included in the `top_traced_function`.\n> To only keep track of each function own allocations, it is necessary to\n> trace all functions.\n\n> #### Warning {: .warning }\n>\n> Avoid hot code reloading for modules participating in the tracing.\n> Reloading a module disables tracing and discards the accumulated statistics.\n> The `tprof` results will probably be incorrect when the profiled code was\n> reloading during a profiling session.","ref":"tprof.html"},{"type":"module","title":"Ad-hoc profiling - tprof","doc":"Ad-hoc profiling is convenient for profiling a single function call.\n\nFor example:\n\n```erlang\n1> tprof:profile(lists, seq, [1, 16], #{type => call_memory}).\n\n****** Process <0.92.0>  --  100.00% of total *** \nFUNCTION          CALLS  WORDS  PER CALL  [     %]\nlists:seq_loop/3      5     32      6.40  [100.00]\n                            32            [ 100.0]\nok\n```\n\nBy default tracing is enabled for all functions in all modules. When funs\nare created in the interactive shell, parts of shell code are also traced:\n\n```erlang\n1> tprof:profile(fun() -> lists:seq(1, 16) end, #{type => call_memory}).\n\n****** Process <0.95.0>  --  100.00% of total *** \nFUNCTION                   CALLS  WORDS  PER CALL  [    %]\nerl_eval:do_apply/7            1      3      3.00  [ 3.61]\nerl_eval:match_list/6          1      3      3.00  [ 3.61]\nlists:reverse/1                1      4      4.00  [ 4.82]\nerl_eval:expr_list/7           3      7      2.33  [ 8.43]\nerl_eval:ret_expr/3            4     16      4.00  [19.28]\nerl_eval:merge_bindings/4      3     18      6.00  [21.69]\nlists:seq_loop/3               5     32      6.40  [38.55]\n                                     83            [100.0]\nok\n```\n\nHowever, it is possible to limit the trace to specific functions or modules:\n\n```erlang\n2> tprof:profile(fun() -> lists:seq(1, 16) end,\n                 #{type => call_memory, pattern => [{lists, seq_loop, '_'}]}).\n****** Process <0.98.0>  --  100.00% of total *** \nFUNCTION          CALLS  WORDS  PER CALL  [     %]\nlists:seq_loop/3      5     32      6.40  [100.00]\n                            32            [ 100.0]\n\nok\n```\n\nAd-hoc profiling results can be printed in a few different ways. The following\nexamples use the `test` module defined like this:\n\n```erlang\n-module(test).\n-export([test_spawn/0]).\ntest_spawn() ->\n    {Pid, MRef} = spawn_monitor(fun () -> lists:seq(1, 32) end),\n    receive\n        {'DOWN', MRef, process, Pid, normal} ->\n            done\n    end.\n```\n\nBy default per-process statistics is shown:\n\n```erlang\n1> tprof:profile(test, test_spawn, [], #{type => call_memory}).\n\n****** Process <0.176.0>    -- 23.66 % of total allocations ***\nFUNCTION                CALLS  WORDS  PER CALL  [    %]\nerlang:spawn_monitor/1      1      2         2  [ 9.09]\nerlang:spawn_opt/4          1      6         6  [27.27]\ntest:test_spawn/0           1     14        14  [63.64]\n                                  22            [100.0]\n\n****** Process <0.177.0>    -- 76.34 % of total allocations ***\nFUNCTION           CALLS  WORDS  PER CALL  [    %]\nerlang:apply/2         1      7         7  [ 9.86]\nlists:seq_loop/3       9     64         7  [90.14]\n                             71            [100.0]\n```\n\nThe following example prints the combined memory allocation of all\nprocesses, sorted by the total number of allocated words in descending\norder:\n\n```erlang\n2> tprof:profile(test, test_spawn, [],\n                 #{type => call_memory, report => {total, {measurement, descending}}}).\n\nFUNCTION                CALLS  WORDS  PER CALL  [    %]\nlists:seq_loop/3            9     64         7  [68.82]\ntest:test_spawn/0           1     14        14  [15.05]\nerlang:apply/2              1      7         7  [ 7.53]\nerlang:spawn_opt/4          1      6         6  [ 6.45]\nerlang:spawn_monitor/1      1      2         2  [ 2.15]\n                                  93            [100.0]\n```\n\nThe profiling data can also be collected for further inspection:\n\n```erlang\n3> {done, ProfileData} = tprof:profile(fun test:test_spawn/0,\n                                       #{type => call_memory, report => return}).\n<...>\n4> tprof:format(tprof:inspect(ProfileData, process, {percent, descending})).\n\n****** Process <0.223.0>    -- 23.66 % of total allocations ***\nFUNCTION                CALLS  WORDS  PER CALL  [    %]\ntest:test_spawn/0           1     14        14  [63.64]\nerlang:spawn_opt/4          1      6         6  [27.27]\nerlang:spawn_monitor/1      1      2         2  [ 9.09]\n                                  22            [100.0]\n\n****** Process <0.224.0>    -- 76.34 % of total allocations ***\nFUNCTION           CALLS  WORDS  PER CALL  [    %]\nlists:seq_loop/3       9     64         7  [90.14]\nerlang:apply/2         1      7         7  [ 9.86]\n                             71            [100.0]\n```\n\nWhich processes that are profiled depends on the profiling type.\n\n* `call_count` (default) counts calls in all processes.\n\n* `call_time` and `call_memory` limits the profiling to the processes\n  spawned from the user-provided function (using the `set_on_spawn`\n  option for `trace:process/4`).\n\n`call_time` and `call_memory` can be restricted to profile a single process:\n\n```erlang\n2> tprof:profile(test, test_spawn, [],\n                 #{type => call_memory, set_on_spawn => false}).\n\n****** Process <0.183.0>    -- 100.00 % of total allocations ***\nFUNCTION                CALLS  WORDS  PER CALL  [    %]\nerlang:spawn_monitor/1      1      2         2  [ 9.09]\nerlang:spawn_opt/4          1      6         6  [27.27]\ntest:test_spawn/0           1     14        14  [63.64]\n```\n\n[](){: #pg_example }\n\nErlang programs can perform expensive operations in other processes\nthan the original one. You can include multiple, new, or even all\nprocesses in the trace when measuring time or memory:\n\n```erlang\n7> pg:start_link().\n{ok,<0.252.0>}\n8> tprof:profile(fun() -> pg:join(group, self()) end,\n                 #{type => call_memory, rootset => [pg]}).\n****** Process <0.252.0>    -- 52.86 % of total allocations ***\nFUNCTION                      CALLS  WORDS  PER CALL  [    %]\npg:leave_local_update_ets/5       1      2         2  [ 1.80]\ngen:reply/2                       1      3         3  [ 2.70]\nerlang:monitor/2                  1      3         3  [ 2.70]\ngen_server:try_handle_call/4      1      3         3  [ 2.70]\ngen_server:try_dispatch/4         1      3         3  [ 2.70]\nmaps:iterator/1                   2      4         2  [ 3.60]\nmaps:take/2                       1      6         6  [ 5.41]\npg:join_local_update_ets/5        1      8         8  [ 7.21]\npg:handle_info/2                  1      8         8  [ 7.21]\npg:handle_call/3                  1      9         9  [ 8.11]\ngen_server:loop/7                 2      9         4  [ 8.11]\nets:lookup/2                      2     10         5  [ 9.01]\npg:join_local/3                   1     11        11  [ 9.91]\npg:notify_group/5                 2     16         8  [14.41]\nerlang:setelement/3               2     16         8  [14.41]\n                                       111            [100.0]\n\n****** Process <0.255.0>    -- 47.14 % of total allocations ***\nFUNCTION                   CALLS  WORDS  PER CALL  [    %]\nerl_eval:match_list/6          1      3         3  [ 3.03]\nerlang:monitor/2               1      3         3  [ 3.03]\nlists:reverse/1                2      4         2  [ 4.04]\npg:join/3                      1      4         4  [ 4.04]\nerl_eval:add_bindings/2        1      5         5  [ 5.05]\nerl_eval:do_apply/7            2      6         3  [ 6.06]\ngen:call/4                     1      8         8  [ 8.08]\nerl_eval:expr_list/7           4     10         2  [10.10]\ngen:do_call/4                  1     16        16  [16.16]\nerl_eval:ret_expr/3            4     16         4  [16.16]\nerl_eval:merge_bindings/4      3     24         8  [24.24]\n                                     99            [100.0]\n```\n\nBy default, there is no limit for the profiling time. For ad-hoc\nprofiling, it is possible to configure a time limit. If the profiled\nfunction does not return before that time expires, the process is\nterminated with reason `kill`. Any unlinked children processes started\nby the user-supplied function are kept; it is the responsibility of\nthe developer to take care of such processes.\n\n```erlang\n9> tprof:profile(timer, sleep, [100000], #{timeout => 1000}).\n```\n\nBy default, only one ad-hoc or server-aided profiling session is\nallowed at any point in time. It is possible to force multiple ad-hoc\nsessions concurrently, but it is the responsibility of the developer\nto ensure that trace patterns do not overlap:\n\n```erlang\n1> tprof:profile(fun() -> lists:seq(1, 32) end,\n    #{registered => false, pattern => [{lists, '_', '_'}]}).\n```","ref":"tprof.html#module-ad-hoc-profiling"},{"type":"module","title":"Server-aided profiling - tprof","doc":"Server-aided profiling can be done on a system that is up and\nrunning. To do that, start the `tprof` server, and then add trace\npatterns and processes to trace while the system handles actual\ntraffic. Data can extracted, inspected, and printed at any time. The\nfollowing example traces activity of all processes supervised by\nthe Kernel supervisor:\n\n```erlang\n1> tprof:start(#{type => call_memory}).\n{ok,<0.200.0>}\n2> tprof:enable_trace({all_children, kernel_sup}).\n34\n3> tprof:set_pattern('_', '_' , '_').\n16728\n4> Sample = tprof:collect().\n{call_memory,\n    [{gen_server,try_dispatch,4,[{<0.154.0>,2,6}]},\n     {erlang,iolist_to_iovec,1,[{<0.161.0>,1,8}]},\n<...>\n5 > tprof:format(tprof:inspect(Sample)).\n\n****** Process <0.154.0>    -- 14.21 % of total allocations ***\nFUNCTION                   CALLS  WORDS  PER CALL  [    %]\nmaps:iterator/1                2      4         2  [15.38]\ngen_server:try_dispatch/4      2      6         3  [23.08]\nnet_kernel:handle_info/2       2     16         8  [61.54]\n                                     26            [100.0]\n\n****** Process <0.161.0>    -- 85.79 % of total allocations ***\nFUNCTION                        CALLS  WORDS  PER CALL  [    %]\ndisk_log:handle/2                   2      2         1  [ 1.27]\ndisk_log_1:maybe_start_timer/1      1      3         3  [ 1.91]\ndisk_log_1:mf_write_cache/1         1      3         3  [ 1.91]\n<...>\n```\n\n[](){: #inspect_example }\n\nIt is possible to profile the entire running system, and then examine individual\nprocesses:\n\n```erlang\n1> tprof:start(#{type => call_memory}).\n2> tprof:enable_trace(all), tprof:set_pattern('_', '_' , '_').\n9041\n3> timer:sleep(10000), tprof:disable_trace(all), Sample = tprof:collect().\n{call_memory,\n    [{user_drv,server,3,[{<0.64.0>,12,136}]},\n     {user_drv,contains_ctrl_g_or_ctrl_c,1,[{<0.64.0>,80,10}]},\n<...>\n4> Inspected = tprof:inspect(Sample, process, measurement), Shell = maps:get(self(), Inspected).\n{call_memory, 2743,\n    [{shell,{enc,0},1,2,2,0.07291286912139992},\n<...>\n5> tprof:format(Shell).\n\nFUNCTION                           CALLS  WORDS  PER CALL  [    %]\n<...>\nerl_lint:start/2                       2    300       150  [10.94]\nshell:used_records/1                 114    342         3  [12.47]\n```","ref":"tprof.html#module-server-aided-profiling"},{"type":"function","title":"tprof.clear_pattern/3","doc":"Disables tracing functions matching the supplied pattern.\n\n```erlang\n1> tprof:set_pattern(lists, seq, '_').\n2\n2> tprof:clear_pattern(lists, seq, 3).\n1\n3> tprof:get_trace_map().\n#{lists => [{seq,2}]}\n```\n\nRequires that the default `tprof` server has been [`started`](`start/1`).","ref":"tprof.html#clear_pattern/3"},{"type":"function","title":"tprof.clear_pattern/4","doc":"Equivalent to [`clear_pattern(Mod, Fun, Arity)`](`clear_pattern/3`) but uses the provided `Server`.","ref":"tprof.html#clear_pattern/4"},{"type":"function","title":"tprof.collect/0","doc":"Returns statistics for current trace map.","ref":"tprof.html#collect/0"},{"type":"function","title":"tprof.collect/1","doc":"Equivalent to `collect/0` but uses the provided `Server`.","ref":"tprof.html#collect/1"},{"type":"type","title":"tprof.column/0","doc":"Column to sort by `inspect/3` or [`profile/4`](`profile/4`).\n\n- **`module`** - Module name.\n\n- **`function`** - Function name.\n\n- **`calls`** - Number of calls to the function.\n\n- **`measurement`** - Total measurement (call count, time, or heap allocation)\n  throughout all calls to the function.\n\n- **`measurement_per_call`** - Measurement (call count, time, or heap\n  allocation) on average per function call.\n\n- **`percent`** - Percentage of measurement to total amount during the entire\n  profile collection.","ref":"tprof.html#t:column/0"},{"type":"function","title":"tprof.continue/0","doc":"Resumes previously paused profiling.","ref":"tprof.html#continue/0"},{"type":"function","title":"tprof.continue/1","doc":"Equivalent to `continue/0` but uses the provided `Server`.","ref":"tprof.html#continue/1"},{"type":"function","title":"tprof.disable_trace/1","doc":"Equivalent to  disable_trace(Spec, #{set_on_spawn => true}) .","ref":"tprof.html#disable_trace/1"},{"type":"function","title":"tprof.disable_trace/2","doc":"Stops accumulating traces for specified processes.\n\nSee `enable_trace/2` for a description of the options.\n\nThe profile data accumulated before the process is removed from the\ntraced list is retained. This makes it possible to enable tracing for\nmany or all processes in the system, sleep for a short period of\ntime, then disable tracing for all processes (to avoid system\noverload), but keeping profile data.","ref":"tprof.html#disable_trace/2"},{"type":"function","title":"tprof.disable_trace/3","doc":"","ref":"tprof.html#disable_trace/3"},{"type":"function","title":"tprof.enable_trace/1","doc":"Equivalent to  enable_trace(Spec, #{set_on_spawn => true}) .","ref":"tprof.html#enable_trace/1"},{"type":"function","title":"tprof.enable_trace/2","doc":"Similar to `trace:process/4`, but supports a few more options for tracing\nconvenience.\n\nTracing per process is not supported by `call_count` profilers.\n\n`Spec` is either a process identifier (pid) for a local process, one of the\nfollowing atoms, or a list of local process identifiers or their registered\nnames:\n\n- **`all`** - All currently existing processes and all that will be\n  created in the future.\n\n- **`existing`** - All currently existing processes.\n\n- **`new`** - All processes that will be created in the future.\n\n- **`children`** - All currently running processes that were directly spawned by\n  the specified process. This mode is helpful for tracing workers of a single\n  supervisor.\n\n- **`all_children`** - All currently running processes that were spawned by the\n  specified process, or any recursive descendant of it. This mode is designed to\n  facilitate tracing of supervision trees.\n\nReturns the number of processes for which tracing was enabled.\n\nWhen a list of pids, `children` or `all_children` is used, the processes that\ntracing failed to be enabled on will also be returned. Tracing can fail to be\nenabled if the process has terminated before tracing could be enabled.\n\n> #### Note {: .info }\n>\n> The profiling server does not keep track of processes that were added to the\n> tracing set. It is permitted to stop the profiling server (wiping out any\n> accumulated data), restart the server, set entirely different tracing pattern\n> keeping the list of traced processes for future use. Use\n> [`disable_trace(Processes)`](`disable_trace/2`) to clear the list of traced\n> processes.\n\nSpecify `Options` to modify tracing behavior:\n\n- **`set_on_spawn`** - Automatically start tracing for processes spawned by the\n  traced process. On by default.","ref":"tprof.html#enable_trace/2"},{"type":"function","title":"tprof.enable_trace/3","doc":"Equivalent to `enable_trace/2` but uses the provided `Server`.","ref":"tprof.html#enable_trace/3"},{"type":"function","title":"tprof.format/1","doc":"Formats profile data transformed with [`inspect/3`](`inspect/3`), outputting to\nthe default output device.","ref":"tprof.html#format/1"},{"type":"function","title":"tprof.format/2","doc":"Formats profile transformed with [`inspect/3`](`inspect/3`),\noutputting to device `IoDevice`.","ref":"tprof.html#format/2"},{"type":"function","title":"tprof.get_trace_map/0","doc":"Returns a map of module names to functions with their arities.","ref":"tprof.html#get_trace_map/0"},{"type":"function","title":"tprof.get_trace_map/1","doc":"Equivalent to `get_trace_map/0` but uses the provided `Server`.","ref":"tprof.html#get_trace_map/1"},{"type":"function","title":"tprof.inspect/1","doc":"Equivalent to [`inspect(Profile, process, percent)`](`inspect/3`).\n\nTransforms raw profile into a map of process identifiers to a tuple containing total count\nof words allocated, and a list of all traced functions sorted in the ascending\norder by the allocation percentage.","ref":"tprof.html#inspect/1"},{"type":"function","title":"tprof.inspect/3","doc":"Transforms raw data returned by tracing BIFs into a form convenient for\nsubsequent analysis and formatting.\n\n* When the `Type` argument is `process`, this function returns a map of process\n  identifiers with corresponding profiling results sorted by the selected column.\n\n* When `Type` argument is `total` or when profiling by `call_count`, this function\n  returns a map with a single `all` key with profiling results from all processes.\n\nThe inspected profile data can be leveraged to\n[print profiling results](`m:tprof#inspect_example`).","ref":"tprof.html#inspect/3"},{"type":"function","title":"tprof.pause/0","doc":"Pauses trace collection for all currently traced functions, retaining existing traces.\n\nUse `continue/0` to resume trace collection.","ref":"tprof.html#pause/0"},{"type":"function","title":"tprof.pause/1","doc":"Equivalent to `pause/0` but uses the provided `Server`.","ref":"tprof.html#pause/1"},{"type":"type","title":"tprof.process/0","doc":"A process identifier (pid) or a registered process name.","ref":"tprof.html#t:process/0"},{"type":"function","title":"tprof.profile/1","doc":"Equivalent to  profile(Fun, #{}) .","ref":"tprof.html#profile/1"},{"type":"function","title":"tprof.profile/2","doc":"Does ad-hoc profiling of the call `Fun()`.\n\nBy default, the result is formatted to the output device; use the `report`\noption to change this behavior.\n\nAd-hoc profiling starts a new instance of `tprof` server, runs the\nprofiling routine, extracts results, and shuts down the server.\n\nSee `profile/4` for a list of the supported options.","ref":"tprof.html#profile/2"},{"type":"function","title":"tprof.profile/3","doc":"Equivalent to  profile(Module, Function, Args, #{}) .","ref":"tprof.html#profile/3"},{"type":"function","title":"tprof.profile/4","doc":"Does ad-hoc profiling for the call `apply(Module, Function, Args)`.\n\nBy default, the result is formatted to the output device; use option `report`\nto change this behavior.\n\nAd-hoc profiling starts a new instance of `tprof` server, runs the\nprofiling routine, extracts results, and shuts down the server.\n\nThe ad-hoc profiler supports the following `Options`:\n\n- **`type`** - The type of profiling to perform.\n\n- **`device`** - Specifies I/O devices to print the profile to. Useful to\n  redirect text output to console or `standard_error`.\n\n- **`pattern`** - Specifies a trace pattern, or a list of trace patterns to\n  enable. By default, all functions (`{'_', '_', '_'}`) are traced.\n\n- **`report`** - Controls output format. The default is `process`; printing\n  per-process profiling data sorted by percentage of the total allocation.\n  Specify `report => return` to suppress printing and get the raw data for\n  further evaluation with `inspect/3` and formatting with `format/2`.\n\n- **`rootset`** - Includes extra processes in the trace list. Useful for\n  profiling allocations for `m:gen_server`, calls, or other allocations caused\n  by inter-process communications. See [this example](`m:tprof#pg_example`).\n\n- **`set_on_spawn`** - Automatically start tracing for processes spawned by the\n  traced process. Enabled by default.\n\n- **`timeout`** - Terminate profiling after the specified amount of time\n  (milliseconds).","ref":"tprof.html#profile/4"},{"type":"type","title":"tprof.profile_line/0","doc":"Inspected data for a single function of the specified `Module`.","ref":"tprof.html#t:profile_line/0"},{"type":"type","title":"tprof.profile_options/0","doc":"Ad-hoc profiler options; see [`profile/4`](`profile/4`).","ref":"tprof.html#t:profile_options/0"},{"type":"type","title":"tprof.profile_result/0","doc":"Profile of a single process, or combined profile of multiple processes, sorted\nby a selected column.","ref":"tprof.html#t:profile_result/0"},{"type":"function","title":"tprof.restart/0","doc":"Clears accumulated profiles and starts profiling if it was paused.","ref":"tprof.html#restart/0"},{"type":"function","title":"tprof.restart/1","doc":"Equivalent to `restart/0` but uses the provided `Server`.","ref":"tprof.html#restart/1"},{"type":"type","title":"tprof.rootset/0","doc":"","ref":"tprof.html#t:rootset/0"},{"type":"type","title":"tprof.server/0","doc":"A tprof server.\n\nEach server uses a separate `t:trace:session/0` in order to\nkeep profiling isolated.","ref":"tprof.html#t:server/0"},{"type":"function","title":"tprof.set_pattern/3","doc":"Enables tracing for all functions matching the supplied pattern.\n\nPatterns are additive, following the same rules as `trace:function/4`.\nReturns the number of functions matching the supplied pattern.\n\n```erlang\n1> tprof:set_pattern(lists, seq, '_').\n2\n2> tprof:set_pattern(lists, keyfind, 3).\n1\n3> tprof:get_trace_map().\n#{lists => [{keyfind,3},{seq,2},{seq,3}]}\n```\n\nIf no functions match the pattern, an `error` tuple is returned:\n\n```erlang\n> tprof:set_pattern(no_module, func, '_').\n{error,{trace_pattern,no_module,func,'_'}}\n```\n\nRequires that the default `tprof` server has been [`started`](`start/1`).","ref":"tprof.html#set_pattern/3"},{"type":"function","title":"tprof.set_pattern/4","doc":"Equivalent to `set_pattern/3` but uses the provided `Server`.","ref":"tprof.html#set_pattern/4"},{"type":"type","title":"tprof.sort_by/0","doc":"","ref":"tprof.html#t:sort_by/0"},{"type":"function","title":"tprof.start/0","doc":"Equivalent to  start(#{}) .","ref":"tprof.html#start/0"},{"type":"function","title":"tprof.start/1","doc":"Starts the server, not supervised.\n\nProfiling server stores current trace patterns and owns the [trace session](`t:trace:session/0`)\nused for profiling.\n\nIf no `session` is provided in `Config`, then a default session called `tprof` is\nused and the profiling server is [registered](`register/2`) as `tprof`.\n\nIf `session` is provided in `Config`, then a session with that name is created\nand all profiling is done within that session. The profiling server is not [registered](`register/2`)\nin this case. When using `m:tprof` like this the `t:pid/0` returned from this\nfunction needs to be provided to the functions in this module.","ref":"tprof.html#start/1"},{"type":"function","title":"tprof.start_link/0","doc":"Equivalent to  start_link(#{}) .","ref":"tprof.html#start_link/0"},{"type":"function","title":"tprof.start_link/1","doc":"Equivalent to `start/1` but also links the profiling server to the caller.","ref":"tprof.html#start_link/1"},{"type":"type","title":"tprof.start_options/0","doc":"","ref":"tprof.html#t:start_options/0"},{"type":"function","title":"tprof.stop/0","doc":"Stops the default `tprof` server and disable tracing enabled by the server.","ref":"tprof.html#stop/0"},{"type":"function","title":"tprof.stop/1","doc":"Equivalent to `stop/0` but uses the provided `Server`.","ref":"tprof.html#stop/1"},{"type":"type","title":"tprof.trace_info/0","doc":"Raw data extracted from tracing BIFs.","ref":"tprof.html#t:trace_info/0"},{"type":"type","title":"tprof.trace_map/0","doc":"Traced functions (with their arities) grouped by module name,\nor `all` if all code is traced.","ref":"tprof.html#t:trace_map/0"},{"type":"type","title":"tprof.trace_options/0","doc":"Options for enabling profiling of the selected processes; see `enable_trace/2`.","ref":"tprof.html#t:trace_options/0"},{"type":"type","title":"tprof.trace_pattern/0","doc":"","ref":"tprof.html#t:trace_pattern/0"},{"type":"type","title":"tprof.trace_type/0","doc":"The type of profiling that the tprof server will do.\n\n- **call_count** - Counts the number of calls made to functions. This\n  is a global profiling event that cannot be limited to specific processes.\n  See [call_count](`trace#call_count`) in `trace:function/4` for more details.\n- **call_time** - Counts the accumulated time spent in functions.\n  See [call_time](`trace#call_time`) in `trace:function/4` for more details.\n- **call_memory** - Counts the accumulated memory allocated in functions.\n  See [call_memory](`trace#call_memory`) in `trace:function/4` for more details.","ref":"tprof.html#t:trace_type/0"},{"type":"module","title":"xref","doc":"A Cross Reference Tool for analyzing dependencies between functions, modules,\napplications, and releases.\n\nCalls between functions are either _local calls_{: #local_call } such as `f()`,\nor _external calls_{: #external_call } such as `mod:f()`.\n\n_Module data_{:#module_data }, which are extracted from BEAM files,\ninclude local functions, exported functions, local calls, and external\ncalls. By default, calls to built-in functions (BIF) are ignored, but\nif the option `builtins`, accepted by some of this module's functions,\nis set to `true`, calls to BIFs are included as well. It is the\nanalyzing OTP version that decides what functions are BIFs.\nFunctional objects are assumed to be called where they are created\n(and nowhere else).\n\n_Unresolved calls_{: #unresolved_call } are calls to `apply` or\n`spawn` with variable module, variable function, or variable\narguments. Examples are `M:F(a)`, [`apply(M, f, [a])`](`apply/3`), and\n[`spawn(m, f(), Args)`](`spawn/3`). Unresolved calls are represented\nby calls where variable modules have been replaced with the atom\n`'$M_EXPR'`, variable functions have been replaced with the atom\n`'$F_EXPR'`, and variable number of arguments have been replaced with\nthe number `-1`. The above mentioned examples are represented by calls\nto `'$M_EXPR':'$F_EXPR'/1`, `'$M_EXPR':f/1`, and `m:'$F_EXPR'/-1`. The\nunresolved calls are a subset of the external calls.\n\n> #### Warning {: .warning }\n>\n> Unresolved calls make module data incomplete, which implies that the results\n> of analyses may be invalid.\n\n_Applications_ are collections of modules. The BEAM files for the\nmodules are located in the `ebin` subdirectory of the application\ndirectory. The name of the application directory determines the name\nand version of the application.\n\n_Releases_ are collections of applications located in the `lib` subdirectory of\nthe release directory. There is more to read about applications and releases in\nthe Design Principles book.\n\n_Xref servers_{: #xref_server } are identified by names, supplied when\ncreating new servers. Each Xref server holds a set of releases, a set\nof applications, and a set of modules with module data. Xref servers\nare independent of each other, and all analyses are evaluated in the\ncontext of one single Xref server (exceptions are the functions\n[`m/1`](`m/1`) and [`d/1`](`d/1`) which do not use servers at\nall).\n\nThe _mode_{: #mode } of an Xref server determines what module data are\nextracted from BEAM files as modules are added to the server. BEAM\nfiles compiled with the option `debug_info` contain [](){: #debug_info\n} \"debug information\", which is an abstract representation of the\ncode.\n\n- In `functions` mode, which is the default mode, function calls\n  and line numbers are extracted from debug information.\n\n- In `modules` mode, debug information is ignored if present, but\n  dependencies between modules are extracted from other parts of the\n  BEAM files. The `modules` mode is significantly less time and space\n  consuming than the `functions` mode, but the analyses that can be\n  done are limited.\n\nAn _analyzed module_{: #analyzed_module } is a module that has been added to an\nXref server together with its module data. A _library module_{: #library_module\n} is a module located in some directory mentioned in the _library path_{:\n#library_path }. A library module is said to be used if some of its exported\nfunctions are used by some analyzed module. An _unknown module_{:\n#unknown_module } is a module that is neither an analyzed module nor a library\nmodule, but whose exported functions are used by some analyzed module.\n\nAn _unknown function_{: #unknown_function } is a used function that is\nneither local or exported by any analyzed module nor exported by any\nlibrary module. An _undefined function_{: #undefined_function } is an\nexternally used function that is not exported by any analyzed module\nor library module. With this notion, a local function can be an\nundefined function, namely if it is externally used from some\nmodule. All unknown functions are also undefined functions; there is a\n[figure](xref_chapter.md#venn2) in the User's Guide that illustrates\nthis relationship.\n\nThe module attribute tag `deprecated` can be used to inform\nXref about _deprecated functions_{: #deprecated_function } and optionally when\nfunctions are planned to be removed. A few examples show the idea:\n\n- `-deprecated({f,1}).` - The exported function `f/1` is deprecated.\n  Nothing is said whether `f/1` will be removed or not.\n\n- `-deprecated({f,1,\"Use g/1 instead\"}).` - As above but with a descriptive\n  string. The string is currently unused by `xref` but other tools can make use\n  of it.\n\n- `-deprecated({f,'_'}).` - All exported functions `f/0`, `f/1`, and so on\n  are deprecated.\n\n- `-deprecated(module).` - All exported functions in the module are\n  deprecated. Equivalent to `-deprecated({'_','_'}).`.\n\n- `-deprecated([{g,1,next_version}]).` - The function `g/1` is deprecated\n  and will be removed in next version.\n\n- `-deprecated([{g,2,next_major_release}]).` - The function `g/2` is\n  deprecated and will be removed in next major release.\n\n- `-deprecated([{g,3,eventually}]).` - The function `g/3` is deprecated\n  and will eventually be removed.\n\n- `-deprecated({'_','_',eventually}).` - All exported functions in the\n  module are deprecated and will eventually be removed.\n\nBefore any analysis can take place, module data must be _set up_. For instance,\nthe cross reference and the unknown functions are computed when all module data\nare known. The functions that need complete data\n([`analyze/2,3`](`analyze/3`), [`q/2,3`](`q/3`), [`variables/1,2`](`variables/2`)\ntake care of setting up data automatically. Module data need to be set up\n(again) after calls to any of the `add`, `replace`, `remove`,\n[`set_library_path/2,3`](`set_library_path/3`), or\n[`update/1,2`](`update/2`) functions.\n\nThe result of setting up module data is the _Call Graph_{: #call_graph }. A\n(directed) graph consists of a set of vertices and a set of (directed) edges.\nThe edges represent _calls_{: #call } (From, To) between functions, modules,\napplications, or releases. From is said to call To, and To is said to be used by\nFrom. The vertices of the Call Graph are the functions of all module data: local\nand exported functions of analyzed modules; used BIFs; used exported functions\nof library modules; and unknown functions. The functions `module_info/0,1` added\nby the compiler are included among the exported functions, but only when called\nfrom some module. The edges are the function calls of all module data. A\nconsequence of the edges being a set is that there is only one edge if a\nfunction is locally or externally used several times on one and the same line of\ncode.\n\nThe Call Graph is [](){: #representation } represented by Erlang terms (the sets\nare lists), which is suitable for many analyses. But for analyses that look at\nchains of calls, a list representation is much too slow. Instead the\nrepresentation offered by the `digraph` module is used. The translation of the\nlist representation of the Call Graph - or a subgraph thereof - to the `digraph`\nrepresentation does not come for free, so the language used for expressing\nqueries to be described below has a special operator for this task and a\npossibility to save the `digraph` representation for subsequent analyses.\n\nIn addition to the Call Graph there is a graph called the _Inter Call Graph_{:\n#inter_call_graph }. This is a graph of calls (From, To) such that there is a\nchain of calls from From to To in the Call Graph, and every From and To is an\nexported function or an unused local function. The vertices are the same as for\nthe Call Graph.\n\nCalls between modules, applications and releases are also directed graphs. The\n_types_{: #type } of the vertices and edges of these graphs are (ranging from\nthe most special to the most general): `Fun` for functions; `Mod` for modules;\n`App` for applications; and `Rel` for releases. The following paragraphs will\ndescribe the different constructs of the language used for selecting and\nanalyzing parts of the graphs, beginning with the _constants_{: #constants }:\n\n- Expression ::= Constants\n- Constants ::= Consts | Consts `:` Type | RegExpr\n- Consts ::= Constant | `[`Constant`,` ...`]` | `{`Constant`,` ...`}`\n- Constant ::= Call | Const\n- Call ::= FunSpec `->` FunSpec | `{`MFA`,` MFA`}` | AtomConst `->` AtomConst |\n  `{`AtomConst`,` AtomConst`}`\n- Const ::= AtomConst | FunSpec | MFA\n- AtomConst ::= Application | Module | Release\n- FunSpec ::= Module `:` Function `/` Arity\n- MFA ::= `{`Module`,` Function`,` Arity`}`\n- RegExpr ::= RegString `:` Type | RegFunc | RegFunc `:` Type\n- RegFunc ::= RegModule `:` RegFunction `/` RegArity\n- RegModule ::= RegAtom\n- RegFunction ::= RegAtom\n- RegArity ::= RegString | Number | `_` | `-1`\n- RegAtom ::= RegString | Atom | `_`\n- RegString ::= - a regular expression, as described in the `re` module,\n  enclosed in double quotes -\n- Type ::= `Fun` | `Mod` | `App` | `Rel`\n- Function ::= Atom\n- Application ::= Atom\n- Module ::= Atom\n- Release ::= Atom\n- Arity ::= Number | `-1`\n- Atom ::= - same as Erlang atoms -\n- Number ::= - same as non-negative Erlang integers -\n\nExamples of constants are: `kernel`, `kernel->stdlib`, `[kernel, sasl]`,\n`[pg -> mnesia, {tv, mnesia}] : Mod`. It is an error if an instance of `Const`\ndoes not match any vertex of any graph. If there are more than one vertex\nmatching an untyped instance of `AtomConst`, then the one of the most general\ntype is chosen. A list of constants is interpreted as a set of constants, all of\nthe same type. A tuple of constants constitute a chain of calls (which may, but\ndoes not have to, correspond to an actual chain of calls of some graph).\nAssigning a type to a list or tuple of `Constant` is equivalent to assigning the\ntype to each `Constant`.\n\n_Regular expressions_{: #regexp } are used as a means to select some of the\nvertices of a graph. A `RegExpr` consisting of a `RegString` and a type - an\nexample is `\"xref_.*\" : Mod` \\- is interpreted as those modules (or applications\nor releases, depending on the type) that match the expression. Similarly, a\n`RegFunc` is interpreted as those vertices of the Call Graph that match the\nexpression. An example is `\"xref_.*\":\"add_.*\"/\"(2|3)\"`, which matches all `add`\nfunctions of arity two or three of any of the xref modules. Another example, one\nthat matches all functions of arity 10 or more: `_:_/\"[1-9].+\"`. Here `_` is an\nabbreviation for `\".*\"`, that is, the regular expression that matches anything.\n\nThe syntax of _variables_{: #variable } is simple:\n\n- Expression ::= Variable\n- Variable ::= - same as Erlang variables -\n\nThere are two kinds of variables:\n\n* **Predefined variables** {: #predefined_variable } - hold module data, and\n  cannot be assigned to but only used in queries.\n\n* **User variables** {: #user_variable } - can be assigned to, and are\n  typically used for temporary results while evaluating a query, and\n  for keeping results of queries for use in subsequent queries.\n\nThe predefined variables are (variables marked with (\\*) are available\nin `functions` mode only):\n\n- **`E`** - Call Graph Edges (\\*).\n\n- **`V`** - Call Graph Vertices (\\*).\n\n- **`M`** - Modules. All modules: analyzed modules, used library modules, and\n  unknown modules.\n\n- **`A`** - Applications.\n\n- **`R`** - Releases.\n\n- **`ME`** - Module Edges. All module calls.\n\n- **`AE`** - Application Edges. All application calls.\n\n- **`RE`** - Release Edges. All release calls.\n\n- **`L`** - Local Functions (\\*). All local functions of analyzed modules.\n\n- **`X`** - Exported Functions. All exported functions of analyzed modules and\n  all used exported functions of library modules.\n\n- **`F`** - Functions (\\*).\n\n- **`B`** - Used BIFs. `B` is empty if `builtins` is `false` for all analyzed\n  modules.\n\n- **`U`** - Unknown Functions.\n\n- **`UU`** - Unused Functions (\\*). All local and exported functions of analyzed\n  modules that have not been used.\n\n- **`XU`** - Externally Used Functions. Functions of all modules - including\n  local functions - that have been used in some external call.\n\n- **`LU`** - Locally Used Functions (\\*). Functions of all modules that have\n  been used in some local call.\n\n- **`OL`** - Functions with an attribute tag `on_load` (\\*).\n\n- **`LC`** - Local Calls (\\*).\n\n- **`XC`** - External Calls (\\*).\n\n- **`AM`** - Analyzed Modules.\n\n- **`UM`** - Unknown Modules.\n\n- **`LM`** - Used Library Modules.\n\n- **`UC`** - Unresolved Calls. Empty in `modules` mode.\n\n- **`EE`** - Inter Call Graph Edges (\\*).\n\n- **`DF`** - Deprecated Functions. All deprecated exported functions and all\n  used deprecated BIFs.\n\n- **`DF_1`** - Deprecated Functions. All deprecated functions to be removed in\n  next version.\n\n- **`DF_2`** - Deprecated Functions. All deprecated functions to be removed in\n  next version or next major release.\n\n- **`DF_3`** - Deprecated Functions. All deprecated functions to be removed in\n  next version, next major release, or later.\n\nThese are a few [](){: #simple_facts } facts about the predefined variables (the\nset operators `+` (union) and `-` (difference) as well as the cast operator\n`(`Type`)` are described below):\n\n- `F` is equal to `L + X`.\n- `V` is equal to `X + L + B + U`, where `X`, `L`, `B` and `U` are pairwise\n  disjoint (that is, have no elements in common).\n- `UU` is equal to `V - (XU + LU)`, where `LU` and `XU` may have elements in\n  common. Put in another way:\n- `V` is equal to `UU + XU + LU`.\n- `OL` is a subset of `F`.\n- `E` is equal to `LC + XC`. Note that `LC` and `XC` may have elements in\n  common, namely if some function is locally and externally used from one and\n  the same function.\n- `U` is a subset of `XU`.\n- `B` is a subset of `XU`.\n- `LU` is equal to `range LC`.\n- `XU` is equal to `range XC`.\n- `LU` is a subset of `F`.\n- `UU` is a subset of `F`.\n- `range UC` is a subset of `U`.\n- `M` is equal to `AM + LM + UM`, where `AM`, `LM` and `UM` are pairwise\n  disjoint.\n- `ME` is equal to `(Mod) E`.\n- `AE` is equal to `(App) E`.\n- `RE` is equal to `(Rel) E`.\n- `(Mod) V` is a subset of `M`. Equality holds if all analyzed modules have some\n  local, exported, or unknown function.\n- `(App) M` is a subset of `A`. Equality holds if all applications have some\n  module.\n- `(Rel) A` is a subset of `R`. Equality holds if all releases have some\n  application.\n- `DF_1` is a subset of `DF_2`.\n- `DF_2` is a subset of `DF_3`.\n- `DF_3` is a subset of `DF`.\n- `DF` is a subset of `X + B`.\n\nAn important notion is that of _conversion_{: #conversion } of expressions. The\nsyntax of a cast expression is:\n\n- Expression ::= `(` Type `)` Expression\n\nThe interpretation of the cast operator depends on the named type `Type`, the\ntype of `Expression`, and the structure of the elements of the interpretation of\n`Expression`. If the named type is equal to the expression type, no conversion\nis done. Otherwise, the conversion is done one step at a time; `(Fun) (App) RE`,\nfor instance, is equivalent to `(Fun) (Mod) (App) RE`. Now assume that the\ninterpretation of `Expression` is a set of constants (functions, modules,\napplications or releases). If the named type is more general than the expression\ntype, say `Mod` and `Fun` respectively, then the interpretation of the cast\nexpression is the set of modules that have at least one of their functions\nmentioned in the interpretation of the expression. If the named type is more\nspecial than the expression type, say `Fun` and `Mod`, then the interpretation\nis the set of all the functions of the modules (in `modules` mode, the\nconversion is partial since the local functions are not known). The conversions\nto and from applications and releases work analogously. For instance,\n`(App) \"xref_.*\" : Mod` returns all applications containing at least one module\nsuch that `xref_` is a prefix of the module name.\n\nNow assume that the interpretation of `Expression` is a set of calls. If the\nnamed type is more general than the expression type, say `Mod` and `Fun`\nrespectively, then the interpretation of the cast expression is the set of calls\n(M1, M2) such that the interpretation of the expression contains a call from\nsome function of M1 to some function of M2. If the named type is more special\nthan the expression type, say `Fun` and `Mod`, then the interpretation is the\nset of all function calls (F1, F2) such that the interpretation of the\nexpression contains a call (M1, M2) and F1 is a function of M1 and F2 is a\nfunction of M2 (in `modules` mode, there are no functions calls, so a cast to\n`Fun` always yields an empty set). Again, the conversions to and from\napplications and releases work analogously.\n\nThe interpretation of constants and variables are sets, and those sets can be\nused as the basis for forming new sets by the application of _set operators_{:\n#set_operator }. The syntax:\n\n- Expression ::= Expression BinarySetOp Expression\n- BinarySetOp ::= `+` | `*` | `-`\n\n`+`, `*` and `-` are interpreted as union, intersection and difference\nrespectively: the union of two sets contains the elements of both sets; the\nintersection of two sets contains the elements common to both sets; and the\ndifference of two sets contains the elements of the first set that are not\nmembers of the second set. The elements of the two sets must be of the same\nstructure; for instance, a function call cannot be combined with a function. But\nif a cast operator can make the elements compatible, then the more general\nelements are converted to the less general element type. For instance, `M + F`\nis equivalent to `(Fun) M + F`, and `E - AE` is equivalent to `E - (Fun) AE`.\nOne more example: `X * xref : Mod` is interpreted as the set of functions\nexported by the module `xref`; `xref : Mod` is converted to the more special\ntype of `X` (`Fun`, that is) yielding all functions of `xref`, and the\nintersection with `X` (all functions exported by analyzed modules and library\nmodules) is interpreted as those functions that are exported by some module\n_and_ functions of `xref`.\n\nThere are also unary set operators:\n\n- Expression ::= UnarySetOp Expression\n- UnarySetOp ::= `domain` | `range` | `strict`\n\nRecall that a call is a pair (From, To). `domain` applied to a set of calls is\ninterpreted as the set of all vertices From, and `range` as the set of all\nvertices To. The interpretation of the `strict` operator is the operand with all\ncalls of the form (A, A) removed.\n\nThe interpretation of the _restriction operators_{: #restriction } is a subset\nof the first operand, a set of calls. The second operand, a set of vertices, is\nconverted to the type of the first operand. The syntax of the restriction\noperators:\n\n- Expression ::= Expression RestrOp Expression\n- RestrOp ::= `|`\n- RestrOp ::= `||`\n- RestrOp ::= `|||`\n\nThe interpretation in some detail for the three operators:\n\n- **`|`** - The subset of calls from any of the vertices.\n\n- **`||`** - The subset of calls to any of the vertices.\n\n- **`|||`** - The subset of calls to and from any of the vertices. For all sets\n  of calls `CS` and all sets of vertices `VS`, `CS ||| VS ` is equivalent to\n  `CS | VS * CS || VS`.\n\n[](){: #graph_analyses } Two functions (modules, applications, releases) belong\nto the same strongly connected component if they call each other (in)directly.\nThe interpretation of the `components` operator is the set of strongly connected\ncomponents of a set of calls. The `condensation` of a set of calls is a new set\nof calls between the strongly connected components such that there is an edge\nbetween two components if there is some constant of the first component that\ncalls some constant of the second component.\n\nThe interpretation of the `of` operator is a chain of calls of the second\noperand (a set of calls) that passes throw all of the vertices of the first\noperand (a tuple of constants), in the given order. The second operand is\nconverted to the type of the first operand. For instance, the `of` operator can\nbe used for finding out whether a function calls another function indirectly,\nand the chain of calls demonstrates how. The syntax of the graph analyzing\noperators:\n\n- Expression ::= Expression BinaryGraphOp Expression\n- Expression ::= UnaryGraphOp Expression\n- UnaryGraphOp ::= `components` | `condensation`\n- BinaryGraphOp ::= `of`\n\nAs was mentioned before, the graph analyses operate on the `digraph`\nrepresentation of graphs. By default, the `digraph` representation is created\nwhen needed (and deleted when no longer used), but it can also be created\nexplicitly by use of the `closure` operator:\n\n- Expression ::= ClosureOp Expression\n- ClosureOp ::= `closure`\n\nThe interpretation of the `closure` operator is the transitive closure of the\noperand.\n\nThe restriction operators are defined for closures as well;\n`closure E | xref : Mod` is interpreted as the direct or indirect function calls\nfrom the `xref` module, while the interpretation of `E | xref : Mod` is the set\nof direct calls from `xref`. If some graph is to be used in several graph\nanalyses, it saves time to assign the `digraph` representation of the graph to a\nuser variable, and then make sure that every graph analysis operates on that\nvariable instead of the list representation of the graph.\n\nThe lines where functions are defined (more precisely: where the first clause\nbegins) and the lines where functions are used are available in `functions`\nmode. The line numbers refer to the files where the functions are defined. This\nholds also for files included with the `-include` and `-include_lib` directives,\nwhich may result in functions defined apparently in the same line. The _line\noperators_ are used for assigning line numbers to functions and for assigning\nsets of line numbers to function calls. The syntax is similar to the one of the\ncast operator:\n\n- Expression ::= `(` LineOp`)` Expression\n- Expression ::= `(` XLineOp`)` Expression\n- LineOp ::= `Lin` | `ELin` | `LLin` | `XLin`\n- XLineOp ::= `XXL`\n\nThe interpretation of the `Lin` operator applied to a set of functions assigns\nto each function the line number where the function is defined. Unknown\nfunctions and functions of library modules are assigned the number 0.\n\nThe interpretation of some LineOp operator applied to a set of function calls\nassigns to each call the set of line numbers where the first function calls the\nsecond function. Not all calls are assigned line numbers by all operators:\n\n- the `Lin` operator is defined for Call Graph Edges;\n- the `LLin` operator is defined for Local Calls.\n- the `XLin` operator is defined for External Calls.\n- the `ELin` operator is defined for Inter Call Graph Edges.\n\nThe `Lin` (`LLin`, `XLin`) operator assigns the lines where calls (local calls,\nexternal calls) are made. The `ELin` operator assigns to each call (From, To),\nfor which it is defined, every line L such that there is a chain of calls from\nFrom to To beginning with a call on line L.\n\nThe `XXL` operator is defined for the interpretation of any of the LineOp\noperators applied to a set of function calls. The result is that of replacing\nthe function call with a line numbered function call, that is, each of the two\nfunctions of the call is replaced by a pair of the function and the line where\nthe function is defined. The effect of the `XXL` operator can be undone by the\nLineOp operators. For instance, `(Lin) (XXL) (Lin) E` is equivalent to\n`(Lin) E`.\n\nThe `+`, `-`, `*`, and `#` operators are defined for line number expressions,\nprovided the operands are compatible. The LineOp operators are also defined for\nmodules, applications, and releases; the operand is implicitly converted to\nfunctions. Similarly, the cast operator is defined for the interpretation of the\nLineOp operators.\n\nThe interpretation of the _counting operator_{: #count } is the number of\nelements of a set. The operator is undefined for closures. The `+`, `-` and `*`\noperators are interpreted as the obvious arithmetical operators when applied to\nnumbers. The syntax of the counting operator:\n\n- Expression ::= CountOp Expression\n- CountOp ::= `#`\n\nAll binary operators are left associative; for instance, `A | B  || C` is\nequivalent to `(A | B) || C`. The following is a list of all operators, in\nincreasing order of _precedence_{: #precedence }:\n\n- `+`, `-`\n- `*`\n- `#`\n- `|`, `||`, `|||`\n- `of`\n- `(`Type`)`\n- `closure`, `components`, `condensation`, `domain`, `range`, `strict`\n\nParentheses are used for grouping, either to make an expression more readable or\nto override the default precedence of operators:\n\n- Expression ::= `(` Expression `)`\n\nA _query_{: #query } is a non-empty sequence of statements. A statement is\neither an assignment of a user variable or an expression. The value of an\nassignment is the value of the right hand side expression. It makes no sense to\nput a plain expression anywhere else but last in queries. The syntax of queries\nis summarized by these productions:\n\n- Query ::= Statement`,` ...\n- Statement ::= Assignment | Expression\n- Assignment ::= Variable `:=` Expression | Variable `=` Expression\n\nA variable cannot be assigned a new value unless first removed. Variables\nassigned to by the `=` operator are removed at the end of the query, while\nvariables assigned to by the `:=` operator can only be removed by calls to\n`forget`. There are no user variables when module data need to be set up again;\nif any of the functions that make it necessary to set up module data again is\ncalled, all user variables are forgotten.","ref":"xref.html"},{"type":"module","title":"See Also - xref","doc":"`m:beam_lib`, `m:digraph`, `m:digraph_utils`, `m:re`,\n[User's Guide for Xref](xref_chapter.md)","ref":"xref.html#module-see-also"},{"type":"function","title":"xref.add_application/2","doc":"Equivalent to  add_application(XrefServer, Directory, []) .","ref":"xref.html#add_application/2"},{"type":"function","title":"xref.add_application/3","doc":"Adds an application, the modules of the application, and\n[module data](`m:xref#module_data`) of the modules to an\n[Xref server](`m:xref#xref_server`).\n\nThe modules will be members of the application. The default is to use\nthe base name of the directory with the version removed as application\nname, but this can be overridden by the `name` option. Returns the\nname of the application.\n\nIf the given directory has a subdirectory named `ebin`, modules (BEAM files) are\nsearched for in that directory, otherwise modules are searched for in the given\ndirectory.\n\nIf the [mode](`m:xref#mode`) of the Xref server is `functions`, BEAM files that\ncontain no [debug information](`m:xref#debug_info`) are ignored.","ref":"xref.html#add_application/3"},{"type":"type","title":"xref.add_dir_rsn/0","doc":"","ref":"xref.html#t:add_dir_rsn/0"},{"type":"function","title":"xref.add_directory/2","doc":"Equivalent to  add_directory(Name, Directory, []) .","ref":"xref.html#add_directory/2"},{"type":"function","title":"xref.add_directory/3","doc":"Adds the modules found in the given directory and the\n[modules' data](`m:xref#module_data`) to an [Xref server](`m:xref#xref_server`).\n\nThe default is not to examine subdirectories, but if the option `recurse` has\nthe value `true`, modules are searched for in subdirectories on all levels as\nwell as in the given directory. Returns a sorted list of the names of the added\nmodules.\n\nThe modules added will not be members of any applications.\n\nIf the [mode](`m:xref#mode`) of the Xref server is `functions`, BEAM files that\ncontain no [debug information](`m:xref#debug_info`) are ignored.","ref":"xref.html#add_directory/3"},{"type":"type","title":"xref.add_mod_rsn/0","doc":"","ref":"xref.html#t:add_mod_rsn/0"},{"type":"function","title":"xref.add_module/2","doc":"Equivalent to  add_module(Name, File, []) .","ref":"xref.html#add_module/2"},{"type":"function","title":"xref.add_module/3","doc":"Adds a module and its [module data](`m:xref#module_data`) to an\n[Xref server](`m:xref#xref_server`).\n\nThe module will not be member of any application. Returns the name of the module.\n\nIf the [mode](`m:xref#mode`) of the Xref server is `functions`, and the BEAM\nfile contains no [debug information](`m:xref#debug_info`), the error message\n`no_debug_info` is returned.","ref":"xref.html#add_module/3"},{"type":"function","title":"xref.add_release/2","doc":"Equivalent to  add_release(Name, Directory, []) .","ref":"xref.html#add_release/2"},{"type":"function","title":"xref.add_release/3","doc":"Adds a release, the applications of the release, the modules of the\napplications, and [module data](`m:xref#module_data`) of the modules to an\n[Xref server](`m:xref#xref_server`).\n\nThe applications will be members of the release, and the modules will\nbe members of the applications. The default is to use the base name of\nthe directory as release name, but this can be overridden by the\n`name` option. Returns the name of the release.\n\nIf the given directory has a subdirectory named `lib`, the directories in that\ndirectory are assumed to be application directories, otherwise all\nsubdirectories of the given directory are assumed to be application directories.\nIf there are several versions of some application, the one with the highest\nversion is chosen.\n\nIf the [mode](`m:xref#mode`) of the Xref server is `functions`, BEAM files that\ncontain no [debug information](`m:xref#debug_info`) are ignored.","ref":"xref.html#add_release/3"},{"type":"type","title":"xref.analysis/0","doc":"","ref":"xref.html#t:analysis/0"},{"type":"function","title":"xref.analyze/2","doc":"Equivalent to  analyze(XrefServer, Analysis, []) .","ref":"xref.html#analyze/2"},{"type":"function","title":"xref.analyze/3","doc":"Evaluates a predefined analysis.\n\nReturns a sorted list without duplicates of `t:call/0` or\n`t:constant/0`, depending on the chosen analysis.  The predefined\nanalyses, which operate on all [analyzed\nmodules](`m:xref#analyzed_module`), are (analyses marked with (\\*) are\navailable only in [mode `functions`](`m:xref#mode`)):\n\n- **`undefined_function_calls`(\\*)** - Returns a list of calls to\n  [undefined functions](`m:xref#undefined_function`).\n\n- **`undefined_functions`** - Returns a list of\n  [undefined functions](`m:xref#undefined_function`).\n\n- **`locals_not_used`(\\*)** - Returns a list of local functions that have not\n  been locally used.\n\n- **`exports_not_used`** - Returns a list of exported functions that have not\n  been externally used. Note that in `modules` mode, `M:behaviour_info/1` is\n  never reported as unused.\n\n- **`deprecated_function_calls`(\\*)** - Returns a list of external calls to\n  [deprecated functions](`m:xref#deprecated_function`).\n\n- **`{deprecated_function_calls, DeprFlag}`(\\*)** - Returns a list of external\n  calls to deprecated functions. If `DeprFlag` is equal to `next_version`, calls\n  to functions to be removed in next version are returned. If `DeprFlag` is\n  equal to `next_major_release`, calls to functions to be removed in next major\n  release are returned as well as calls to functions to be removed in next\n  version. Finally, if `DeprFlag` is equal to `eventually`, all calls to\n  functions to be removed are returned, including calls to functions to be\n  removed in next version or next major release.\n\n- **`deprecated_functions`** - Returns a list of externally used deprecated\n  functions.\n\n- **`{deprecated_functions, DeprFlag}`** - Returns a list of externally used\n  deprecated functions. If `DeprFlag` is equal to `next_version`, functions to\n  be removed in next version are returned. If `DeprFlag` is equal to\n  `next_major_release`, functions to be removed in next major release are\n  returned as well as functions to be removed in next version. Finally, if\n  `DeprFlag` is equal to `eventually`, all functions to be removed are returned,\n  including functions to be removed in next version or next major release.\n\n- **`{call, FuncSpec}`(\\*)** - Returns a list of functions called by some of the\n  given functions.\n\n- **`{use, FuncSpec}`(\\*)** - Returns a list of functions that use some of the\n  given functions.\n\n- **`{module_call, ModSpec}`** - Returns a list of modules called by some of the\n  given modules.\n\n- **`{module_use, ModSpec}`** - Returns a list of modules that use some of the\n  given modules.\n\n- **`{application_call, AppSpec}`** - Returns a list of applications called by\n  some of the given applications.\n\n- **`{application_use, AppSpec}`** - Returns a list of applications that use\n  some of the given applications.\n\n- **`{release_call, RelSpec}`** - Returns a list of releases called by some of\n  the given releases.\n\n- **`{release_use, RelSpec}`** - Returns a list of releases that use some of the\n  given releases.","ref":"xref.html#analyze/3"},{"type":"type","title":"xref.analyze_rsn/0","doc":"","ref":"xref.html#t:analyze_rsn/0"},{"type":"type","title":"xref.answer/0","doc":"","ref":"xref.html#t:answer/0"},{"type":"type","title":"xref.app_spec/0","doc":"","ref":"xref.html#t:app_spec/0"},{"type":"type","title":"xref.application/0","doc":"","ref":"xref.html#t:application/0"},{"type":"type","title":"xref.call/0","doc":"","ref":"xref.html#t:call/0"},{"type":"type","title":"xref.component/0","doc":"","ref":"xref.html#t:component/0"},{"type":"type","title":"xref.constant/0","doc":"","ref":"xref.html#t:constant/0"},{"type":"function","title":"xref.d/1","doc":"The modules found in the given directory are checked for calls to\n[deprecated functions](`m:xref#deprecated_function`), calls to\n[undefined functions](`m:xref#undefined_function`), and for unused local\nfunctions.\n\nThe code path is used as [library path](`m:xref#library_path`).\n\nIf some of the found BEAM files contain\n[debug information](`m:xref#debug_info`), then those modules are checked and a\nlist of tuples is returned. The first element of each tuple is one of:\n\n- `deprecated`, the second element is a sorted list of calls to deprecated\n  functions;\n- `undefined`, the second element is a sorted list of calls to undefined\n  functions;\n- `unused`, the second element is a sorted list of unused local functions.\n\nIf no BEAM file contains debug information, then a list of tuples is returned.\nThe first element of each tuple is one of:\n\n- `deprecated`, the second element is a sorted list of externally used\n  deprecated functions;\n- `undefined`, the second element is a sorted list of undefined functions.","ref":"xref.html#d/1"},{"type":"type","title":"xref.define_at/0","doc":"","ref":"xref.html#t:define_at/0"},{"type":"type","title":"xref.depr_flag/0","doc":"","ref":"xref.html#t:depr_flag/0"},{"type":"type","title":"xref.directory/0","doc":"","ref":"xref.html#t:directory/0"},{"type":"type","title":"xref.file/0","doc":"","ref":"xref.html#t:file/0"},{"type":"type","title":"xref.file_error/0","doc":"","ref":"xref.html#t:file_error/0"},{"type":"function","title":"xref.forget/1","doc":"Removes all [user variables](`m:xref#user_variable`) of an\n[Xref server](`m:xref#xref_server`).","ref":"xref.html#forget/1"},{"type":"function","title":"xref.forget/2","doc":"Removes the [user variables](`m:xref#user_variable`) given by `Variables` from\nan [Xref server](`m:xref#xref_server`).","ref":"xref.html#forget/2"},{"type":"function","title":"xref.format_error/1","doc":"Given the error returned by any function of this module, the function\n`format_error` returns a descriptive string of the error in English.\n\nFor file errors, the function `file:format_error/1` is called.","ref":"xref.html#format_error/1"},{"type":"type","title":"xref.func_spec/0","doc":"","ref":"xref.html#t:func_spec/0"},{"type":"type","title":"xref.funcall/0","doc":"","ref":"xref.html#t:funcall/0"},{"type":"type","title":"xref.function_name/0","doc":"","ref":"xref.html#t:function_name/0"},{"type":"function","title":"xref.get_default/1","doc":"Returns a list of all options and their default values.","ref":"xref.html#get_default/1"},{"type":"function","title":"xref.get_default/2","doc":"Returns the default value for option `Option`.","ref":"xref.html#get_default/2"},{"type":"function","title":"xref.get_library_path/1","doc":"Returns the [library path](`m:xref#library_path`).","ref":"xref.html#get_library_path/1"},{"type":"type","title":"xref.info/0","doc":"","ref":"xref.html#t:info/0"},{"type":"function","title":"xref.info/1","doc":"The `info/1` function returns information as a list of pairs `{Tag, term()` in\nsome order about the state and the [module data](`m:xref#module_data`) of an\n[Xref server](`m:xref#xref_server`).\n\n[`info/1`](`info/1`) returns information with the following tags (tags marked\nwith (\\*) are only available in `functions` mode):\n\n- `library_path`, the [library path](`m:xref#library_path`);\n- `mode`, the [mode](`m:xref#mode`);\n- `no_releases`, number of releases;\n- `no_applications`, total number of applications (of all releases);\n- `no_analyzed_modules`, total number of\n  [analyzed modules](`m:xref#analyzed_module`);\n- `no_calls` (\\*), total number of calls (in all modules), regarding instances\n  of one function call in different lines as separate calls;\n- `no_function_calls` (\\*), total number of [local calls](`m:xref#local_call`),\n  resolved [external calls](`m:xref#external_call`) and\n  [unresolved calls](`m:xref#unresolved_call`);\n- `no_functions` (\\*), total number of local and exported functions;\n- `no_inter_function_calls` (\\*), total number of calls of the\n  [Inter Call Graph](`m:xref#inter_call_graph`).","ref":"xref.html#info/1"},{"type":"function","title":"xref.info/2","doc":"Returns information about all items belonging to category `Category`.\nSee `info/3` for details.","ref":"xref.html#info/2"},{"type":"function","title":"xref.info/3","doc":"The `info` functions return information as a list of pairs `{Tag, term()}` in\nsome order about the state and the [module data](`m:xref#module_data`) of an\n[Xref server](`m:xref#xref_server`).\n\n[`info/2`](`info/2`) and [`info/3`](`info/3`) return information about all or\nsome of the analyzed modules, applications, releases, or library modules of an\nXref server. The following information is returned for every analyzed module:\n\n- `application`, an empty list if the module does not belong to any application,\n  otherwise a list of the application name;\n- `builtins`, whether calls to BIFs are included in the module's data;\n- `directory`, the directory where the module's BEAM file is located;\n- `no_calls` (\\*), number of calls, regarding instances of one function call in\n  different lines as separate calls;\n- `no_function_calls` (\\*), number of local calls, resolved external calls and\n  unresolved calls;\n- `no_functions` (\\*), number of local and exported functions;\n- `no_inter_function_calls` (\\*), number of calls of the Inter Call Graph;\n\nThe following information is returned for every application:\n\n- `directory`, the directory where the modules' BEAM files are located;\n- `no_analyzed_modules`, number of analyzed modules;\n- `no_calls` (\\*), number of calls of the application's modules, regarding\n  instances of one function call in different lines as separate calls;\n- `no_function_calls` (\\*), number of local calls, resolved external calls and\n  unresolved calls of the application's modules;\n- `no_functions` (\\*), number of local and exported functions of the\n  application's modules;\n- `no_inter_function_calls` (\\*), number of calls of the Inter Call Graph of the\n  application's modules;\n- `release`, an empty list if the application does not belong to any release,\n  otherwise a list of the release name;\n- `version`, the application's version as a list of numbers. For instance, the\n  directory \"kernel-2.6\" results in the application name `kernel` and the\n  application version \\[2,6]; \"kernel\" yields the name `kernel` and the version\n  [].\n\nThe following information is returned for every release:\n\n- `directory`, the release directory;\n- `no_analyzed_modules`, number of analyzed modules;\n- `no_applications`, number of applications;\n- `no_calls` (\\*), number of calls of the release's modules, regarding instances\n  of one function call in different lines as separate calls;\n- `no_function_calls` (\\*), number of local calls, resolved external calls and\n  unresolved calls of the release's modules;\n- `no_functions` (\\*), number of local and exported functions of the release's\n  modules;\n- `no_inter_function_calls` (\\*), number of calls of the Inter Call Graph of the\n  release's modules.\n\nThe following information is returned for every library module:\n\n- `directory`, the directory where the\n  [library module's](`m:xref#library_module`) BEAM file is located.\n\nFor every number of calls, functions, and so on returned by the `no_` tags, there is a\nquery returning the same number. Listed below are examples of such queries. Some\nof the queries return the sum of a two or more of the `no_` tags numbers. `mod`\n(`app`, `rel`) refers to any module (application, release).\n\n- `no_analyzed_modules`\n\n  - `\"# AM\"` (info/1)\n  - `\"# (Mod) app:App\"` (application)\n  - `\"# (Mod) rel:Rel\"` (release)\n\n- `no_applications`\n\n  - `\"# A\"` (info/1)\n\n- `no_calls`. The sum of the number of resolved and unresolved calls:\n\n  - `\"# (XLin) E + # (LLin) E\"` (info/1)\n  - `\"T = E | mod:Mod, # (LLin) T + # (XLin) T\"` (module)\n  - `\"T = E | app:App, # (LLin) T + # (XLin) T\"` (application)\n  - `\"T = E | rel:Rel, # (LLin) T + # (XLin) T\"` (release)\n\n- `no_functions`. Functions in library modules and the functions\n  `module_info/0,1` are not counted by `info`. Assuming that\n  `\"Extra := _:module_info/\\\"(0|1)\\\" + LM\"` has been evaluated, the sum of the\n  number of local and exported functions are:\n\n  - `\"# (F - Extra)\"` (info/1)\n  - `\"# (F * mod:Mod - Extra)\"` (module)\n  - `\"# (F * app:App - Extra)\"` (application)\n  - `\"# (F * rel:Rel - Extra)\"` (release)\n\n- `no_function_calls`. The sum of the number of local calls, resolved external\n  calls and unresolved calls:\n\n  - `\"# LC + # XC\"` (info/1)\n  - `\"# LC | mod:Mod + # XC | mod:Mod\"` (module)\n  - `\"# LC | app:App + # XC | app:App\"` (application)\n  - `\"# LC | rel:Rel + # XC | mod:Rel\"` (release)\n\n- `no_inter_function_calls`\n\n  - `\"# EE\"` (info/1)\n  - `\"# EE | mod:Mod\"` (module)\n  - `\"# EE | app:App\"` (application)\n  - `\"# EE | rel:Rel\"` (release)\n\n- `no_releases`\n\n  - `\"# R\"` (info/1)","ref":"xref.html#info/3"},{"type":"type","title":"xref.library/0","doc":"","ref":"xref.html#t:library/0"},{"type":"type","title":"xref.library_path/0","doc":"","ref":"xref.html#t:library_path/0"},{"type":"function","title":"xref.m/1","doc":"The given BEAM file (with or without the `.beam` extension) or the file found by\ncalling `code:which(Module)` is checked for calls to\n[deprecated functions](`m:xref#deprecated_function`), calls to\n[undefined functions](`m:xref#undefined_function`), and for unused local\nfunctions.\n\nThe code path is used as [library path](`m:xref#library_path`).\n\nIf the BEAM file contains [debug information](`m:xref#debug_info`), a list\nof tuples is returned. The first element of each tuple is one of:\n\n- `deprecated`, the second element is a sorted list of calls to deprecated\n  functions;\n- `undefined`, the second element is a sorted list of calls to undefined\n  functions;\n- `unused`, the second element is a sorted list of unused local functions.\n\nIf the BEAM file does not contain debug information, a list of tuples is\nreturned. The first element of each tuple is one of:\n\n- `deprecated`, the second element is a sorted list of externally used\n  deprecated functions;\n- `undefined`, the second element is a sorted list of undefined functions.","ref":"xref.html#m/1"},{"type":"type","title":"xref.mod_spec/0","doc":"","ref":"xref.html#t:mod_spec/0"},{"type":"type","title":"xref.mode/0","doc":"","ref":"xref.html#t:mode/0"},{"type":"type","title":"xref.path/0","doc":"","ref":"xref.html#t:path/0"},{"type":"function","title":"xref.q/2","doc":"Equivalent to  q(XrefServer, Query, []) .","ref":"xref.html#q/2"},{"type":"function","title":"xref.q/3","doc":"Evaluates a [query](`m:xref#query`) in the context of an\n[Xref server](`m:xref#xref_server`), and returns the value of the last\nstatement.\n\nThe syntax of the value depends on the expression:\n\n- A set of calls is represented by a sorted list without duplicates of\n  `t:call/0`.\n- A set of constants is represented by a sorted list without duplicates of\n  `t:constant/0`.\n- A set of strongly connected components is a sorted list without duplicates of\n  `Component`.\n- A set of calls between strongly connected components is a sorted list without\n  duplicates of `ComponentCall`.\n- A chain of calls is represented by a list of `t:constant/0`. The list contains\n  the From vertex of every call and the To vertex of the last call.\n- The `of` operator returns `false` if no chain of calls between the given\n  constants can be found.\n- The value of the `closure` operator (the `digraph` representation) is\n  represented by the atom `'closure()'`.\n- A set of line numbered functions is represented by a sorted list without\n  duplicates of `DefineAt`.\n- A set of line numbered function calls is represented by a sorted list without\n  duplicates of `CallAt`.\n- A set of line numbered functions and function calls is represented by a sorted\n  list without duplicates of `AllLines`.\n\nFor both `CallAt` and `AllLines` it holds that for no list element is\n`LineNumbers` an empty list; such elements have been removed. The constants of\n`component` and the integers of `LineNumbers` are sorted and without duplicates.","ref":"xref.html#q/3"},{"type":"type","title":"xref.q_rsn/0","doc":"","ref":"xref.html#t:q_rsn/0"},{"type":"type","title":"xref.rel_spec/0","doc":"","ref":"xref.html#t:rel_spec/0"},{"type":"type","title":"xref.release/0","doc":"","ref":"xref.html#t:release/0"},{"type":"function","title":"xref.remove_application/2","doc":"Removes applications and their modules and [module data](`m:xref#module_data`)\nfrom an [Xref server](`m:xref#xref_server`).","ref":"xref.html#remove_application/2"},{"type":"function","title":"xref.remove_module/2","doc":"Removes [analyzed modules](`m:xref#analyzed_module`) and\n[module data](`m:xref#module_data`) from an [Xref server](`m:xref#xref_server`).","ref":"xref.html#remove_module/2"},{"type":"function","title":"xref.remove_release/2","doc":"Removes releases and their applications, modules, and\n[module data](`m:xref#module_data`) from an [Xref server](`m:xref#xref_server`).","ref":"xref.html#remove_release/2"},{"type":"function","title":"xref.replace_application/3","doc":"Equivalent to  replace_application(XrefServer, Application, Directory, []) .","ref":"xref.html#replace_application/3"},{"type":"function","title":"xref.replace_application/4","doc":"Replaces the modules of an application with other modules read from an\napplication directory.\n\nRelease membership of the application is retained. Note that the name\nof the application is kept; the name of the given directory is not\nused.","ref":"xref.html#replace_application/4"},{"type":"function","title":"xref.replace_module/3","doc":"Equivalent to  replace_module(XrefServer, Module, File, []) .","ref":"xref.html#replace_module/3"},{"type":"function","title":"xref.replace_module/4","doc":"Replaces [module data](`m:xref#module_data`) of an\n[analyzed module](`m:xref#analyzed_module`) with data read from a BEAM file.\n\nApplication membership of the module is retained, and so is the value of the\n`builtins` option of the module. An error is returned if the name of the read\nmodule differs from the given module.\n\nThe `update` function is an alternative for updating module data of recompiled\nmodules.","ref":"xref.html#replace_module/4"},{"type":"function","title":"xref.set_default/2","doc":"Sets default values for multiple options given by `OptionValues`.\n\nSee `set_default/3` for the name of options and their allowed values.","ref":"xref.html#set_default/2"},{"type":"function","title":"xref.set_default/3","doc":"Sets the default value of one or more options.\n\nThe options that can be set this way are:\n\n- `builtins`, with initial default value `false`;\n- `recurse`, with initial default value `false`;\n- `verbose`, with initial default value `false`;\n- `warnings`, with initial default value `true`.\n\nThe initial default values are set when creating an\n[Xref server](`m:xref#xref_server`).","ref":"xref.html#set_default/3"},{"type":"function","title":"xref.set_library_path/2","doc":"Equivalent to  set_library_path(XrefServer, LibraryPath, []) .","ref":"xref.html#set_library_path/2"},{"type":"function","title":"xref.set_library_path/3","doc":"Sets the [library path](`m:xref#library_path`).\n\nIf the given path is a list of directories, the set of [library\nmodules](`m:xref#library_module`) is determined by choosing the first\nmodule encountered while traversing the directories in the given\norder, for those modules that occur in more than one directory. By\ndefault, the library path is an empty list.\n\nThe library path `code_path`{: #code_path } is used by the functions\n[`m/1`](`m/1`) and [`d/1`](`d/1`), but can also be set explicitly. However,\nnote that the code path will be traversed once for each used\n[library module](`m:xref#library_module`) while setting up module data. On the\nother hand, if there are only a few modules that are used but not analyzed,\nusing `code_path` may be faster than setting the library path to\n`code:get_path/0`.\n\nIf the library path is set to `code_path`, the set of library modules is not\ndetermined, and the `info` functions will return empty lists of library modules.","ref":"xref.html#set_library_path/3"},{"type":"function","title":"xref.start/1","doc":"Creates an [Xref server](`m:xref#xref_server`).\n\nThe process can optionally be given a name. The default\n[mode](`m:xref#mode`) is `functions`. Options that are\nnot recognized by Xref are passed on to `gen_server:start/4`.","ref":"xref.html#start/1"},{"type":"function","title":"xref.start/2","doc":"Creates an [Xref server](`m:xref#xref_server`) with a given name.\n\nThe default [mode](`m:xref#mode`) is `functions`. Options that are\nnot recognized by Xref are passed on to `gen_server:start/4`.","ref":"xref.html#start/2"},{"type":"function","title":"xref.stop/1","doc":"Stops an [Xref server](`m:xref#xref_server`).","ref":"xref.html#stop/1"},{"type":"type","title":"xref.string_position/0","doc":"","ref":"xref.html#t:string_position/0"},{"type":"function","title":"xref.update/1","doc":"Equivalent to  update(XrefServer, []) .","ref":"xref.html#update/1"},{"type":"function","title":"xref.update/2","doc":"Replaces the [module data](`m:xref#module_data`) of all\n[analyzed modules](`m:xref#analyzed_module`) the BEAM files of which have been\nmodified since last read by an `add` function or `update`.\n\nApplication membership of the modules is retained, and so is the value\nof the `builtins`option. Returns a sorted list of the names of\nthe replaced modules.","ref":"xref.html#update/2"},{"type":"type","title":"xref.variable/0","doc":"","ref":"xref.html#t:variable/0"},{"type":"function","title":"xref.variables/1","doc":"Equivalent to  variables(XrefServer, []) .","ref":"xref.html#variables/1"},{"type":"function","title":"xref.variables/2","doc":"Returns a sorted lists of the names of the variables of an\n[Xref server](`m:xref#xref_server`).\n\nThe default is to return only the\n[user variables](`m:xref#user_variable`).","ref":"xref.html#variables/2"},{"type":"type","title":"xref.xarity/0","doc":"","ref":"xref.html#t:xarity/0"},{"type":"type","title":"xref.xmfa/0","doc":"","ref":"xref.html#t:xmfa/0"},{"type":"type","title":"xref.xref/0","doc":"","ref":"xref.html#t:xref/0"},{"type":"extras","title":"Tools Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Tools Release Notes\n\nThis document describes the changes made to the Tools application.","ref":"notes.html"},{"type":"extras","title":"Tools 4.1.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-4-1-3"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Fixed some deprecations for newer emacs versions.\n\n  Own Id: OTP-19726 Aux Id: [PR-10106]\n\n[PR-10106]: https://github.com/erlang/otp/pull/10106","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Tools 4.1.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-4-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- A crash has been eliminated in `tprof:collect/0` when unloading a module while collecting traces.\n\n  Own Id: OTP-19135 Aux Id: [GH-8483], [PR-8547]\n\n- Improved the `indent-region` Emacs command, which could indent badly when inside multiline string.\n\n  Own Id: OTP-19396 Aux Id: [PR-9186]\n\n- `eprof:start_profiling/3` can now return information about which process it failed to trace.\n\n  Own Id: OTP-19419 Aux Id: [PR-9219]\n\n- Fixed a race condition when processes cause the Cover server to be started at the same time.\n\n  Own Id: OTP-19517 Aux Id: [PR-9124]\n\n- Fix bug in `m:tprof` where the session name could not be set.\n\n  Own Id: OTP-19580 Aux Id: [PR-9648]\n\n- Add `m:tprof` to the `.app` file.\n\n  Own Id: OTP-19628 Aux Id: [PR-9787]\n\n[GH-8483]: https://github.com/erlang/otp/issues/8483\n[PR-8547]: https://github.com/erlang/otp/pull/8547\n[PR-9186]: https://github.com/erlang/otp/pull/9186\n[PR-9219]: https://github.com/erlang/otp/pull/9219\n[PR-9124]: https://github.com/erlang/otp/pull/9124\n[PR-9648]: https://github.com/erlang/otp/pull/9648\n[PR-9787]: https://github.com/erlang/otp/pull/9787","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n[PR-9670]: https://github.com/erlang/otp/pull/9670","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Tools 4.1.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-4-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Fixed some deprecated errors on emacs-29.\n\n  Own Id: OTP-19273 Aux Id: [PR-8879]\n\n- The `cover` tool could sometimes wrongly report lines as uncovered.\n\n  Own Id: OTP-19289 Aux Id: [GH-8867], [PR-8919]\n\n- Fixed `tprof:format(IoDevice, ...)` to not demand unicode encoding supported by `IoDevice`.\n\n  Own Id: OTP-19299 Aux Id: [PR-8949]\n\n[PR-8879]: https://github.com/erlang/otp/pull/8879\n[GH-8867]: https://github.com/erlang/otp/issues/8867\n[PR-8919]: https://github.com/erlang/otp/pull/8919\n[PR-8949]: https://github.com/erlang/otp/pull/8949","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Tools 4.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `m:tprof` no longer crashes when using pause/restart/continue when profiling all modules.\n\n  Own Id: OTP-19136 Aux Id: [GH-8472], [PR-8472], [PR-8541]\n\n- On systems supporting native coverage, calls to `m:cover` could hang or crash if cover-compiled module had been reloaded from outside `cover`. This has been corrected so that `cover` now recovers from the error and and sends a report to the logger about the failure to retrieve coverage information.\n\n  Own Id: OTP-19203 Aux Id: [GH-8661], [PR-8742]\n\n[GH-8472]: https://github.com/erlang/otp/issues/8472\n[PR-8472]: https://github.com/erlang/otp/pull/8472\n[PR-8541]: https://github.com/erlang/otp/pull/8541\n[GH-8661]: https://github.com/erlang/otp/issues/8661\n[PR-8742]: https://github.com/erlang/otp/pull/8742","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Figures in the documentation have been improved.\n\n  Own Id: OTP-19130 Aux Id: [PR-7226]\n\n[PR-7226]: https://github.com/erlang/otp/pull/7226","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Tools 4.0 - Tools Release Notes","doc":"","ref":"notes.html#tools-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Dialyzer warnings due to type specs added in `m:dbg` have been eliminated.\n\n  Own Id: OTP-18860\n\n- In Erlang/OTP 26, doing a `m:cover` analysis on the `line` level would return multiple entries for lines on which multiple functions were defined.\n  \n  For example, consider this module:\n      \n      -module(foo).\n      -export([bar/0, baz/0]).\n  \n      bar() -> ok. baz() -> not_ok.\n  \n  In Erlang/OTP 26, analysing on the `line` level would return two entries\n  for line 4:\n  \n      1> cover:compile_module(foo).\n      {ok,foo}\n      2> foo:bar().\n      ok\n      3> cover:analyse(foo, coverage, line).\n      {ok,[{{foo,4},{1,0}},{{foo,4},{0,1}}]}\n      4> cover:analyse(foo, calls, line).\n      {ok,[{{foo,4},1},{{foo,4},0}]}\n  \n  In Erlang/OTP 27, there will only be a single entry for line 4:\n  \n      1> cover:compile_module(foo).\n      {ok,foo}\n      2> foo:bar().\n      ok\n      3> cover:analyse(foo, coverage, line).\n      {ok,[{{foo,4},{1,0}}]}\n      4> cover:analyse(foo, calls, line).\n      {ok,[{{foo,4},1}]}\n\n  Own Id: OTP-18998 Aux Id: [GH-8159], [PR-8182]\n\n- Fixed align command in emacs mode.\n\n  Own Id: OTP-19026 Aux Id: [PR-8155]\n\n[GH-8159]: https://github.com/erlang/otp/issues/8159\n[PR-8182]: https://github.com/erlang/otp/pull/8182\n[PR-8155]: https://github.com/erlang/otp/pull/8155","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Triple-Quoted Strings has been implemented as per [EEP 64](https://www.erlang.org/eeps/eep-0064). See [String](`e:system:data_types.md#string`) in the Reference Manual.\n  \n  Example:\n  \n  ```erlang\n  1> \"\"\"\n     a\n     b\n     c\n     \"\"\".\n  \"a\\nb\\nc\"\n  ```\n  \n  Adjacent string literals without intervening white space is now a syntax error, to avoid possible confusion with triple-quoted strings. For example:\n  \n  ```erlang\n  1> \"abc\"\"xyz\".\n  \"xyz\".\n  * 1:6: adjacent string literals without intervening white space\n  ```\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18750 Aux Id: OTP-18746, [PR-7313], [PR-7451]\n\n- There is a new tool `m:tprof`, which combines the functionality of `m:eprof` and `m:cprof` under one interface and adds heap profiling. It also has functionality to help with profiling process hierarchies.\n  \n  *Example*:\n  \n  ```erlang\n  1> tprof:profile(lists, seq, [1, 16], #{type => call_memory}).\n  \n  ****** Process <0.92.0>  --  100.00% of total *** \n  FUNCTION          CALLS  WORDS  PER CALL  [     %]\n  lists:seq_loop/3      5     32      6.40  [100.00]\n                              32            [ 100.0]\n  ok\n  ```\n\n  Own Id: OTP-18756 Aux Id: [PR-6639]\n\n- Native coverage support has been implemented in the JIT. It will  automatically be used by the `m:cover` tool to reduce the execution overhead when running cover-compiled code.\n  \n  There are also new APIs to support native coverage without using the `cover` tool.\n  \n  To instrument code for native coverage it must be compiled with the [`line_coverage`](`m:compile#line_coverage`) option.\n  \n  To enable native coverage in the runtime system, start it like so:\n  \n  ```text\n  $ erl +JPcover true\n  ```\n  \n  There are also the following new functions for supporting native coverage:\n  \n  * `code:coverage_support/0`\n  * `code:get_coverage/2`\n  * `code:reset_coverage/1`\n  * `code:get_coverage_mode/0`\n  * `code:get_coverage_mode/1`\n  * `code:set_coverage_mode/1`\n\n  Own Id: OTP-18856 Aux Id: [PR-7856]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- Improved the align command in emacs mode.\n\n  Own Id: OTP-19080 Aux Id: [PR-8288]\n\n[PR-7313]: https://github.com/erlang/otp/pull/7313\n[PR-7451]: https://github.com/erlang/otp/pull/7451\n[PR-6639]: https://github.com/erlang/otp/pull/6639\n[PR-7856]: https://github.com/erlang/otp/pull/7856\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8288]: https://github.com/erlang/otp/pull/8288","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Tools 3.6 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-6"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Map comprehensions as suggested in EEP 58 has now been implemented.\n\n  Own Id: OTP-18413 Aux Id: EEP-58, PR-6727\n\n- The `instrument` module has been moved from `tools` to `runtime_tools`.\n\n  Own Id: OTP-18487 Aux Id: PR-6829","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Tools 3.5.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-5-3"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Removed the previously undocumented and unsupported `emem` tool.\n\n  Own Id: OTP-17892 Aux Id: PR-5591","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Tools 3.5.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Erlang-mode fixed for newer versions of xref using CL-Lib structures instead\n  of EIEIO classes.\n\n  Own Id: OTP-17746 Aux Id: GH-5314, PR-5324","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Tools 3.5.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The `cover` tool would not work on modules compiled with the `tuple_calls`\n  option.\n\n  Own Id: OTP-17440 Aux Id: GH-4796","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Tools 3.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- For cover-compiled code, the error behaviour of list and binary comprehensions\n  that used `andalso`/`orelse` in guards could be changed so that a filter that\n  was supposed be evaluated in guard context was evaluated in body context. That\n  is, there was a possibility that comprehensions that did not raise exceptions\n  could raise exceptions when being run using `cover`.\n\n  Own Id: OTP-17221 Aux Id: PR-4547","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Support for handling abstract code created before OTP R15 has been dropped.\n\n  Own Id: OTP-16678 Aux Id: PR-2627\n\n- Add types and specifications for documentation.\n\n  Own Id: OTP-16957\n\n- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Tools 3.4.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` would crash when compiling a module having an exported function named\n  `clauses`.\n\n  Own Id: OTP-17162 Aux Id: GH-4549, PR-2997, PR-4555, elixir-lang/elixir#10666\n\n- If `beam_lib` is asked to return abstract code for a BEAM file produced by\n  Elixir and Elixir is not installed on the computer, `beam_lib` will no longer\n  crash, but will return an error tuple. The `cover:compile_beam()` and\n  `cover:compile_beam_directory()` functions have been updated to also return an\n  error tuple in that situation.\n\n  Own Id: OTP-17194 Aux Id: GH-4353\n\n- Make emacs mode work on emacs-27.\n\n  Own Id: OTP-17225 Aux Id: PR-4542, GH-4451","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Tools 3.4.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Correct the Xref analysis `undefined_functions` to not report internally\n  generated behaviour_info/1.\n\n  Own Id: OTP-17191 Aux Id: OTP-16922, ERL-1476, GH-4192","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Tools 3.4.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Correct the Xref analysis `exports_not_used` to not report internally\n  generated `behaviour_info/1`.\n\n  Own Id: OTP-16922 Aux Id: PR-2752","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Tools 3.4.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Correct the Xref analysis `locals_not_used` to find functions called\n  exclusively from `on_load` functions.\n\n  Own Id: OTP-16854 Aux Id: PR-2750","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Tools 3.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-4"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Updates for new `erlang:term_to_iovec()` BIF.\n\n  Own Id: OTP-16128 Aux Id: OTP-15618\n\n- Improved the presentation of allocations and carriers in the `instrument`\n  module.\n\n  Own Id: OTP-16327\n\n- Minor updates due to the new spawn improvements made.\n\n  Own Id: OTP-16368 Aux Id: OTP-15251","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Tools 3.3.1.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` would crash when compiling a module having an exported function named\n  `clauses`.\n\n  Own Id: OTP-17162 Aux Id: GH-4549, PR-2997, PR-4555, elixir-lang/elixir#10666","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Tools 3.3.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- An Emacs warning due to lacking type in defcustom declaration has been fixed.\n\n  Own Id: OTP-16356\n\n- Improve emacs indentation.\n\n  Own Id: OTP-16472 Aux Id: ERL-1140\n\n- The cover tool could generate instrumented code for a module that would cause\n  warnings to be issued.\n\n  Own Id: OTP-16476 Aux Id: ERL-1147\n\n- Fixed generated [fprof analysis format](`m:fprof#analysis`) to also handle\n  data in maps.\n\n  Own Id: OTP-16498 Aux Id: ERL-814","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Tools 3.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Improve `-spec` indentation in emacs mode.\n\n  Own Id: OTP-16164","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- The Emacs erlang-mode function that lets the user open the documentation for\n  an Erlang/OTP function in an Emacs buffer has been improved. Bugs in this\n  function has been fixed and and the user will now be asked if the man pages\n  should be downloaded automatically by Emacs when they can't be found on the\n  system. To test this functionality, put the cursor over the function name in a\n  call to an Erlang/OTP function (e.g., \"io:format(\"arg\")\") and type C-c C-d\n  (i.e., Ctrl-key and c-key and then Ctrl-key and d-key). There is also a new\n  menu item under the Erlang menu (labeled \"Man - Function Under Cursor\").\n\n  Own Id: OTP-16174","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Tools 3.2.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` would fail to start if two processes tried to start it at the exact\n  same time.\n\n  Own Id: OTP-15813 Aux Id: ERL-943","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Tools 3.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Add `cprof` and `tags` modules to .app file so that they are included in\n  releases.\n\n  Own Id: OTP-15534 Aux Id: PR-2078\n\n- Improved documentation parsing in emacs erldoc functionality.\n\n  Own Id: OTP-15699 Aux Id: PR-2184","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- The `cover` tool now uses the `counters` module instead of `ets` for updating\n  the counters for how many times a line has been executed. By default, Cover\n  will work with distributed nodes, but a new function `cover:local_only/0`\n  allows running the Cover in a restricted but faster local-only mode.\n\n  The increase in speed will vary depending on the type of code being\n  cover-compiled, but as an example, the compiler test suite runs more than\n  twice as fast with the new Cover.\n\n  Own Id: OTP-15575","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Tools 3.1.0.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` would fail to start if two processes tried to start it at the exact\n  same time.\n\n  Own Id: OTP-15813 Aux Id: ERL-943","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Tools 3.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Minor fixes for `make clean`.\n\n  Own Id: OTP-15657","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- In the HTML file generated by `cover:analyse_to_file/1,2`, a link is now added\n  to the line number. This makes it easier to share pointers to specific lines.\n\n  Own Id: OTP-15541\n\n- Uncovered lines are now marked with a sad face, `:-(`, in the HTML output from\n  `cover:analyse_to_file/1,2`. This is to make these lines easier to find by\n  search.\n\n  Own Id: OTP-15542","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Tools 3.0.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-0-2"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Remove emacs warnings and added more tests.\n\n  Own Id: OTP-15476","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Tools 3.0.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-0-1"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- The HTML pages generated by cover:analyse_to_file/1 and related functions is\n  improved for readability.\n\n  Own Id: OTP-15213 Aux Id: PR-1807\n\n- Add alignment functionality in emacs.\n\n  Own Id: OTP-15239 Aux Id: PR-1728","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Tools 3.0 - Tools Release Notes","doc":"","ref":"notes.html#tools-3-0"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Added `instrument:allocations` and `instrument:carriers` for retrieving\n  information about memory utilization and fragmentation.\n\n  The old `instrument` interface has been removed, as have the related options\n  `+Mim` and `+Mis`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14961","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Tools 2.11.2.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-11-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` would fail to start if two processes tried to start it at the exact\n  same time.\n\n  Own Id: OTP-15813 Aux Id: ERL-943","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Tools 2.11.2.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-11-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Minor fixes for `make clean`.\n\n  Own Id: OTP-15657","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Tools 2.11.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-11-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- A counting bug is corrected in `Cover`. The bug was introduced in Erlang/OTP\n  18.0.\n\n  Own Id: OTP-14817 Aux Id: PR 1641\n\n- The `lcnt` server will no longer crash if `lcnt:information/0` is called\n  before `lcnt:collect/0`.\n\n  Own Id: OTP-14912\n\n- `lcnt:collect` will now implicitly start the `lcnt` server, as per the\n  documentation.\n\n  Own Id: OTP-14913","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Improved indentation in emacs and various other updates.\n\n  Own Id: OTP-14944","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Tools 2.11.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Tools 2.11 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The predefined Xref analysis `locals_not_used` no longer reports unused\n  functions with the `-on_load()` attribute.\n\n  The new predefined Xref variable `OL` holds all functions with the\n  `-on_load()` attribute.\n\n  Own Id: OTP-14344\n\n- In fprof when sampling multiple processes and analyzing with totals set to\n  true, the output now sums together all caller and callee entries which\n  concerns the same function. Previous behaviour was to report each contributing\n  entry separately.\n\n  Own Id: OTP-14500","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Lock counting can now be fully toggled at runtime in the lock counting\n  emulator (`-emu_type lcnt`). Everything is enabled by default to match the old\n  behavior, but specific categories can be toggled at will with minimal runtime\n  overhead when disabled. Refer to the documentation on `lcnt:rt_mask/1` for\n  details.\n\n  Own Id: OTP-13170\n\n- `lcnt:collect` and `lcnt:clear` will no longer block all other threads in the\n  runtime system.\n\n  Own Id: OTP-14412\n\n- General Unicode improvements.\n\n  Own Id: OTP-14462\n\n- Tools are updated to show Unicode atoms correctly.\n\n  Own Id: OTP-14464\n\n- Add `erlang:iolist_to_iovec/1`, which converts an iolist() to an\n  erlang:iovec(), which suitable for use with `enif_inspect_iovec`.\n\n  Own Id: OTP-14520","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Tools 2.10.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- In OTP-20.0, the behavior of c, make, and ct_make was changed so that in some\n  cases the beam files by default would be written to the directory where the\n  source files were found. This is now changed back to the old behavior so beam\n  files are by default written to current directory.\n\n  Own Id: OTP-14489 Aux Id: ERL-438","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Tools 2.10 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- In some situations, `make:all()` and friends did not detect changes in include\n  files located in the current directory. This is now corrected.\n\n  Own Id: OTP-14339 Aux Id: ERL-395","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- The `make` module now accepts the `{emake,Emake}` option.\n\n  Own Id: OTP-14253\n\n- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Tools 2.9.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-9-1"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Improved edoc support in emacs mode.\n\n  Own Id: OTP-14217 Aux Id: PR-1282","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Tools 2.9 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Fix unhandled trace event send_to_non_existing_process in fprof.\n\n  Own Id: OTP-13998","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Improved edoc support in emacs erlang-mode.\n\n  Own Id: OTP-13945 Aux Id: PR-1157\n\n- Added erldoc to emacs mode which opens html documentation in browser from\n  emacs. For example `M-x erldoc-browse RET lists:foreach/2`.\n\n  Own Id: OTP-14018 Aux Id: PR-1197","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Tools 2.8.6 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Errors in type specification and Emacs template generation for\n  `gen_statem:code_change/4` has been fixed from bugs.erlang.org's Jira cases\n  ERL-172 and ERL-187.\n\n  Own Id: OTP-13746 Aux Id: ERL-172, ERL-187\n\n- Fix gc_start/gc_end in fprof tags when parsing old trace logs.\n\n  Own Id: OTP-13778 Aux Id: PR-1136\n\n- `make` (tools) and `ct_make` (common_test) would crash if an Erlang source\n  file contained a `-warning()` directive.\n\n  Own Id: OTP-13855","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Tools 2.8.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Correct a bug when adding multiple modules to an Xref server. The bug was\n  introduced in OTP-19.0.\n\n  Own Id: OTP-13708 Aux Id: ERL-173","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Tools 2.8.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Update fprof to use the new 'spawned' trace event to determine when a process\n  has been created.\n\n  Own Id: OTP-13499","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Optimize adding multiple modules to an Xref server.\n\n  Own Id: OTP-13593\n\n- Various emacs mode improvements, such as better tags support.\n\n  Own Id: OTP-13610","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Tools 2.8.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover:compile_beam/1` and `cover:compile_beam_directory/1,2` crashed when\n  trying to compile a beam file without a `'file'` attribute. This has been\n  corrected and an error is returned instead.\n\n  Thanks to Louis-Philippe Gauthier for reporting this bug.\n\n  Own Id: OTP-13200\n\n- Fix a bit string comprehension bug in Cover.\n\n  Own Id: OTP-13277 Aux Id: PR 856","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Tools 2.8.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The emacs mode does not add a newline after the arrow on -callback lines\n  anymore.\n\n  Own Id: OTP-13042","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Tools 2.8.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- If a module includes eunit.hrl, a parse transform adds the function test/0 on\n  line 0 in the module. A bug in OTP-18.0 caused cover:analyse_to_file/1 to fail\n  to insert cover data in the output file when line 0 existed in the cover data\n  table. This is now corrected.\n\n  Own Id: OTP-12981","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Tools 2.8 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- In order to improve performance of the cover tool, new functions are added for\n  cover compilation and analysis on multiple files. This allows for more\n  parallelisation.\n\n  Some improvements of the data base access is also done in order to improve the\n  performance when analysing and resetting cover data.\n\n  Minor incompatibility: An error reason from analyse_to_file is changed from\n  no_source_code_found to \\{no_source_code_found,Module\\}.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12330 Aux Id: seq12757\n\n- Attempting to do a `cover` analysis when neither source code nor beam file\n  could be found would hang the `cover` server. Corrected to return a proper\n  error.\n\n  Own Id: OTP-12806","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Allow maps for supervisor flags and child specs\n\n  Earlier, supervisor flags and child specs were given as tuples. While this is\n  kept for backwards compatibility, it is now also allowed to give these\n  parameters as maps, see [sup_flags](`m:supervisor#sup_flags`) and\n  [child_spec](`m:supervisor#child_spec`).\n\n  Own Id: OTP-11043\n\n- Remove Mnemosyne rules support.\n\n  Own Id: OTP-12511\n\n- Add printout of total number of calls and time in eprof\n\n  Own Id: OTP-12681","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Tools 2.7.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Fix lcnt sorting and printout of histograms.\n\n  Own Id: OTP-12364\n\n- Fix a Unicode bug in the `tags` module.\n\n  Own Id: OTP-12567\n\n- Fix tags completion in erlang.el for GNU Emacs 23+\n\n  Own Id: OTP-12583","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Tools 2.7.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Fixed a typo in erlang-mode comment.\n\n  Own Id: OTP-12214\n\n- Add a skeleton for -spec in Erlang mode for Emacs\n\n  Own Id: OTP-12283","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Cover no longer crashes when compiling `receive` and the like with just an\n  `after` clause. Thanks to José Valim for providing a fix.\n\n  Own Id: OTP-12328","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Tools 2.7 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-7"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Add log2 histogram to lcnt for lock wait time\n\n  Own Id: OTP-12059","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Tools 2.6.15 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Removed `erlang:bitstr_to_list/1` and `erlang:list_to_bitstr/1`. They were\n  added by mistake, and have always raised an `undefined` exception when called.\n\n  Own Id: OTP-11942","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Tools 2.6.14 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Removed the support for the query keyword from emacs mode (Thanks to Paul\n  Oliver)\n\n  Own Id: OTP-11568\n\n- Emacs mode improvements (Thanks to Steve Vinoski)\n\n  Own Id: OTP-11601\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- The emacs erlang mode now match erlang keywords more carefully (Thanks to\n  Steve Vinoski)\n\n  Own Id: OTP-11786\n\n- The emacs erlang-mode now auto loads for more file types (Thanks to Phil\n  Hagelberg)\n\n  Own Id: OTP-11788","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- `cover` can run on itself. Also, support for reading BEAM files produced by\n  ancient OTP versions before R9C has been removed.\n\n  Own Id: OTP-11692\n\n- Support maps in cover\n\n  Own Id: OTP-11764","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Tools 2.6.13 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Erlang-specific compilation error regexp is added in erlang-eunit.el. This\n  defvar was earlier in erlang.el, but was erroneously removed in R15B02, while\n  still used by erlang-eunit.el.\n\n  Own Id: OTP-11417 Aux Id: seq12447\n\n- Take compiler options from beam in cover:compile_beam. Thanks to Péter Gömöri.\n\n  Own Id: OTP-11439\n\n- Silence warnings (Thanks to Anthony Ramine)\n\n  Own Id: OTP-11517","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Add iodata, nonempty_string to built-in type highlighting for emacs. Thanks to\n  Paul Oliver.\n\n  Own Id: OTP-11394","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Tools 2.6.12 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-12"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Remove trailing spaces in Emacs templates. Thanks to Roberto Aloi.\n\n  Own Id: OTP-11198\n\n- Fixed the Emacs erlang-mode to accommodate the coding style where lists\n  written across several lines have each line starting with a comma. Thanks to\n  Magnus Henoch.\n\n  Own Id: OTP-11242\n\n- Make the Emacs Erlang mode TRAMP-aware when compiling. Thanks to Tomas\n  Abrahamsson.\n\n  Own Id: OTP-11270","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Tools 2.6.11 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- When cover:stop(Node) was called on a non-existing node, a process waiting for\n  cover data from the node would hang forever. This has been corrected.\n\n  Own Id: OTP-10979","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Make cover smarter about finding source from beam.\n\n  In particular, search using the source path in module_info if the current\n  heuristic fails.\n\n  Own Id: OTP-10902\n\n- Remove Flymake dependency in erlang-pkg.el. Thanks to Magnus Henoch.\n\n  Own Id: OTP-10930\n\n- Erlang-mode: Add autoload cookies for file extension associations. Thanks to\n  Magnus Henoch.\n\n  Own Id: OTP-10999\n\n- Postscript files no longer needed for the generation of PDF files have been\n  removed.\n\n  Own Id: OTP-11016\n\n- Fix a race condition when there're several applications in apps directory.\n  Thanks to Manuel Rubio.\n\n  Own Id: OTP-11028\n\n- New option for eprof, 'set_on_spawn'. This option was previously always on and\n  is also the default.\n\n  Own Id: OTP-11144","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Tools 2.6.10 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-10"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Fix a bug in cover when used with no_auto_import. Thanks to José Valim.\n\n  Own Id: OTP-10778","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Tools 2.6.9 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Add missing modules in app-file\n\n  Own Id: OTP-10439\n\n- Make erlang-mode more compatible with package.el (Thanks to Gleb Peregud)\n\n  Own Id: OTP-10465\n\n- Fix various typos (thanks to Tuncer Ayaz)\n\n  Own Id: OTP-10611\n\n- Add separate face for exported functions (Thanks to Thomas Järvstrand)\n\n  Own Id: OTP-10637\n\n- The BIF highlighting in the emacs mode has been updated to correspond with the\n  correct BIFs.\n\n  Own Id: OTP-10774","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302\n\n- A new function, cover:flush(Nodes), is added which will fetch data from remote\n  nodes without stopping cover on those nodes. This is used by test_server and\n  common_test when it is safe to assume that the node will be terminated after\n  the test anyway. The purpose is to avoid processes crashing when re-loading\n  the original beam if the processes is still running old code.\n\n  Remote nodes will now continue to count code coverage if the connection to the\n  main node is broken. Earlier, a broken connection would cause the cover_server\n  on the remote node to die and thus any still cover compiled modules would\n  cause process crash when trying to insert cover data in ets tables that used\n  to exist on the cover_server. The new functionality also involves\n  synchronization with the main node if the nodes are reconnected.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10523 Aux Id: OTP-10427\n\n- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Fix syntax highlighting of $\\\\' in Emacs mode. Thanks to Magnus Henoch.\n\n  Own Id: OTP-10766","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Tools 2.6.8 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The last tuple fun call has been removed from fprof.\n\n  Own Id: OTP-10091 Aux Id: seq12067\n\n- Fix indentation of record fields in Emacs (Thanks to Tomas Abrahamsson)\n\n  Own Id: OTP-10120\n\n- Documentation fixes (Thanks to Ricardo Catalinas Jiménez )\n\n  Own Id: OTP-10121\n\n- Remove Erlang-specific compilation error regexp in erlang.el\n\n  Own Id: OTP-10168\n\n- Fix highlighting of atoms ending with a dollar sign\n\n  Like this: 'atom$'. In that example, the last single quote should be\n  recognised as ending the atom. This needs a font-lock workaround similar to\n  the one for strings. Thanks to Magnus Henoch\n\n  Own Id: OTP-10178\n\n- Xref now accepts filenames with character codes greater than 126. (Thanks to\n  Emile Joubert for reporting the issue.)\n\n  Own Id: OTP-10192\n\n- Add test_indentation target to lib/tools/emacs/Makefile\n\n  Automatically indent test.erl.orig, save to test.erl, and compare to\n  test.erl.intended. Thanks to Magnus Henoch.\n\n  Own Id: OTP-10226","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Tools 2.6.7 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Makefiles in erts, hipe and tools have been corrected to enable parallel make,\n  i.e MAKEFLAGS=-jX where X is the parallelity number. As a result of this\n  dependencies were corrected since that is what is needed for parallel make to\n  work.\n\n  Own Id: OTP-9857 Aux Id: OTP-9451\n\n- Minor suppressions and fixes of compilation warnings\n\n  Own Id: OTP-10016","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Tools 2.6.6.6 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Update system profiling principles to reflect eprof performance improvements.\n\n  Own Id: OTP-9656\n\n- \\[cover] fix leftover \\{'DOWN', ..\\} msg in callers queue\n\n  After stopping cover with cover:stop() there could still be a \\{'DOWN',...\\}\n  leftover message in the calling process's message queue. This unexpected\n  leftover could be eliminated if erlang:demonitor/2 with option flush would be\n  used in certain points\n\n  Own Id: OTP-9694\n\n- Add deps as erlang-flymake include directory.\n\n  Update erlang-flymake to recognize the \"deps\" folder as an include directory.\n  This makes erlang-flymake compatible with the rebar dependency management\n  tool's default folder structure, which puts included dependencies in\n  \"deps\".(Thanks to Kevin Albrecht)\n\n  Own Id: OTP-9791","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Variables are now now allowed in '`fun M:F/A`' as suggested by Richard O'Keefe\n  in EEP-23.\n\n  The representation of '`fun M:F/A`' in the abstract format has been changed in\n  an incompatible way. Tools that directly read or manipulate the abstract\n  format (such as parse transforms) may need to be updated. The compiler can\n  handle both the new and the old format (i.e. extracting the abstract format\n  from a pre-R15 BEAM file and compiling it using compile:forms/1,2 will work).\n  The `syntax_tools` application can also handle both formats.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9643\n\n- Tuple funs (a two-element tuple with a module name and a function) are now\n  officially deprecated and will be removed in R16. Use '`fun M:F/A`' instead.\n  To make you aware that your system uses tuple funs, the very first time a\n  tuple fun is applied, a warning will be sent to the error logger.\n\n  Own Id: OTP-9649\n\n- Eliminate use of deprecated regexp module\n\n  Own Id: OTP-9810","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"Tools 2.6.6.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Teach the emacs mode to compile yecc and leex files\n\n  If visiting a .yrl or .xrl file in emacs with erlang-mode, then the\n  \\`erlang-compile' function (normally bound to C-c C-k), now knows how to\n  compile yecc and leex files, and then, if that compilation succeeds, also\n  compiles the resulting .erl files.\n\n  Also introduce a \\`erlang-compile-command-function-alist' to make it possible\n  to hook in other functions for computing compilation commands/expressions,\n  depending on file name. (Thanks to Tomas Abrahamsson )\n\n  Own Id: OTP-9503","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Bugs in xref(3) have been fixed. (Thanks to Matthias Lang.)\n\n  Own Id: OTP-9416","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Tools 2.6.6.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Change make:files to behave more like erlc\n\n  This change removes the unnecessary checks on the files when make:files is\n  called and allows the error checking to be done in compile:file, where the\n  error messages are produced. It does not affect the return value.\n\n  (Thanks to Sam bobroff)\n\n  Own Id: OTP-9179\n\n- add user specified compiler options on form reloading\n\n  In order to be able to test non-exported functions from another (test) module\n  it is necessary to compile the specific module (at least during the test\n  phase) with the export*all compiler option. This allows complete separation of\n  testing and productive code. At the moment it is not possible to combine this\n  with a test code coverage using the cover module. The problem is that when\n  cover compiling a module using cover:compile*\\* the code is reloaded into the\n  emulator omitting/filtering the passed user options. In my example above the\n  export_all option would be removed and the non-exported functions cannot be\n  called any more. (Thanks to Tobias Schlager)\n\n  Own Id: OTP-9204\n\n- Inhibit electric newline after \"->\" when inside a type spec\n\n  The Erlang mode for Emacs inserts a newline after every \"->\", which saves you\n  one keystroke when writing a function, but that is inappropriate when writing\n  a type spec, as you'd normally keep the spec on one line. This change inhibits\n  the automatic insertion when the current line starts with \"-spec\" or\n  \"-type\".(Thanks to Magnus Henoch)\n\n  Own Id: OTP-9255\n\n- Add a check logic to prevent file descriptor leak\n\n  cover module handle files as raw in export and import. Assert counts of ports\n  are the same at the beginning and at the end of the test case.(Thanks to\n  Shunichi Shinohara)\n\n  Own Id: OTP-9300","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Tools 2.6.6.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Declare indentation options as \"safe\" in erlang-mode for Emacs\n\n  Emacs has a facility for setting options on a per-file basis based on comments\n  in the source file. By default, all options are considered \"unsafe\", and the\n  user is queried before the variable is set. This patch declares the variables\n  erlang-indent-level, erlang-indent-guard and erlang-argument-indent to be\n  safe, if the value specified in the source file is valid.\n\n  Such declarations usually look like this:\n\n  %% -_- erlang-indent-level: 2 -_-\n\n  and appear on the first line of the file. (thanks to Magnus Henoch)\n\n  Own Id: OTP-9122","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Cover has been improved to take less memory and allow parallel analysis of\n  cover data. Data collection from nodes is now done in parallel and it is now\n  possible to issue multiple analyse and analyse_to_file requests at the same\n  time. A new function call async_analyse_to_file has also been introduced, see\n  the documentation for more details.\n\n  Own Id: OTP-9043 Aux Id: seq11771","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"Tools 2.6.6.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- eprof: API sort mismatch has now been fixed.\n\n  Own Id: OTP-8853\n\n- eprof: fix division by zero in statistics\n\n  Own Id: OTP-8963","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Tools 2.6.6.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` will now show ampersand characters in the source code correctly.\n  (Thanks to Tom Moertel.)\n\n  Own Id: OTP-8776","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Tools 2.6.6 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- A race condition affecting Cover has been removed.\n\n  Own Id: OTP-8469\n\n- Emacs improvements:\n\n  Fixed emacs-mode installation problems.\n\n  Fixed a couple of -spec and -type indentation and font-lock problems.\n\n  Fixed error messages on emacs-21.\n\n  Magnus Henoch fixed several issues.\n\n  Ralf Doering, Klas Johansson and Chris Bernard contributed various emacs-eunit\n  improvements.\n\n  Klas Johansson and Dave Peticolas added emacs-flymake support.\n\n  Own Id: OTP-8530","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Xref has been updated to use the `re` module instead of the deprecated\n  `regexp` module.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8472\n\n- When given the option `{builtins,true}` Xref now adds calls to operators.\n\n  Own Id: OTP-8647\n\n- `eprof` has been reimplemented with support in the Erlang virtual machine and\n  is now both faster (i.e. slows down the code being measured less) and scales\n  much better. In measurements we saw speed-ups compared to the old eprof\n  ranging from 6 times (for sequential code that only uses one scheduler/core)\n  up to 84 times (for parallel code that uses 8 cores).\n\n  Note: The API for the `eprof` has been cleaned up and extended. See the\n  documentation.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8706","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Tools 2.6.5.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- A bug concerning bit comprehensions has been fixed in Cover. The bug was\n  introduced in R13B03. (Thanks to Matthew Sackman.)\n\n  Own Id: OTP-8340","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Add lock profiling tool.\n\n  The Lock profiling tool, lcnt, can make use of the internal lock statistics\n  when the runtime system is built with this feature enabled.\n\n  This provides a mechanism to examine potential lock bottlenecks within the\n  runtime itself.\n\n  \\- Add erts_debug:lock_counters(\\{copy_save, bool()\\}). This option enables or\n  disables statistics saving for destroyed processes and ets-tables. Enabling\n  this might consume a lot of memory.\n\n  \\- Add id-numbering for lock classes which is otherwise undefined.\n\n  Own Id: OTP-8424\n\n- emacs: Moved code skeletons to a separate file and and added a configurable\n  variable to choose skeleton. Thanks Dave Peticolas.\n\n  Own Id: OTP-8446","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Tools 2.6.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The coverage analysis tool `cover` has been improved when it comes to handling\n  list and bit string comprehensions (a counter for each qualifier), bit syntax\n  expressions (the Value and Size expressions), and try expressions (the body\n  called `Exprs` in the Reference Manual). A few (not all) situations where\n  several expressions are put on the same line are also handled better than\n  before.\n\n  Own Id: OTP-8188 Aux Id: seq11397\n\n- When loading Cover compiled code on remote nodes running code in the loaded\n  module, a `badarg` failure was sometimes the result. This bug has been fixed.\n\n  Own Id: OTP-8270 Aux Id: seq11423\n\n- The short-circuit operators `andalso` and `orelse` are now handled correctly\n  by the coverage analysis tool `cover` (it is no longer checked that the second\n  argument returns a Boolean value.)\n\n  Own Id: OTP-8273","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Tools 2.6.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `cover` now properly escapes greater-than and less-than characters in comments\n  in HTML reports. (Thanks to Magnus Henoch.)\n\n  Own Id: OTP-7939","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Tools 2.6.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-3"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- xref:start/1 does now allow anonymous XREF processes to be started\n\n  Own Id: OTP-7831","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"Tools 2.6.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- A bug in the Xref scanner has been fixed.\n\n  Own Id: OTP-7423\n\n- A bug in Fprof where the function 'undefined' appeared to call 'undefined' has\n  been corrected.\n\n  Own Id: OTP-7509","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Tools 2.6.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6-1"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- The documentation has been updated so as to reflect the last updates of the\n  Erlang shell as well as the minor modifications of the control sequence `p` of\n  the `io_lib` module.\n\n  Superfluous empty lines have been removed from code examples and from Erlang\n  shell examples.\n\n  Own Id: OTP-6944 Aux Id: OTP-6554, OTP-6911\n\n- [`tuple_size/1`](`tuple_size/1`) and [`byte_size/1`](`byte_size/1`) have been\n  substituted for [`size/1`](`size/1`).\n\n  Own Id: OTP-7009\n\n- The coverage analysis tool `cover` now handles the short-circuit Boolean\n  expressions `andalso/2` and `orelse/2` properly.\n\n  Own Id: OTP-7095","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"Tools 2.6 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The `cover` tool could use huge amounts of memory when used in a distributed\n  system.\n\n  Own Id: OTP-6758","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Tools 2.5.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Missing buffer-local declaration in erlang.el has been added. Before this fix\n  there could arise problems in other emacs modes after visiting a buffer using\n  the erlang mode.\n\n  Own Id: OTP-6721\n\n- Key-map for 'backward-delete-char-untabif updated to work properly with\n  Xemacs.\n\n  Own Id: OTP-6723","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Minor updates of Xref.\n\n  Own Id: OTP-6586\n\n- Minor Makefile changes.\n\n  Own Id: OTP-6689 Aux Id: OTP-6742\n\n- \"C-u C-c C-k\" now does a compile with both \"debug_info\" and \"export_all\".\n\n  Own Id: OTP-6741","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Tools 2.5.4.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5-4-1"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Changes due to internal interface changes in the erts application which are\n  needed at compile-time. No functionality has been changed.\n\n  Own Id: OTP-6611 Aux Id: OTP-6580","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"Tools 2.5.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Made change to support the function erlang-find-tag for xemacs and emacs-21.\n\n  Own Id: OTP-6512","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Minor updates of xref for future compatibility.\n\n  Own Id: OTP-6513","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Tools 2.5.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- `eprof` did not work reliably in the SMP emulator, because the trace receiver\n  process could not process the trace messages fast enough. Therefore, `eprof`\n  now blocks the other schedulers while profiling.\n\n  Own Id: OTP-6373","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Tools 2.5.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Fprof traces could become truncated for the SMP emulator. This bug has now\n  been corrected.\n\n  Own Id: OTP-6246","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Tools 2.5.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- eprof now works somewhat better in the SMP emulator.\n\n  Own Id: OTP-6152","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Tools 2.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Fixed some bugs in `make`:\n\n  `make:files/1,2` can now handle a file in another directory as argument,\n  similar to `make:all/0,1`.\n\n  When specifying a file name including the `.erl` extension in `Emakefile`,\n  `make:all/0,1` looked for the object code in the wrong place.\n\n  When specifying a file name including the `.erl` extension in `Emakefile` and\n  some compile options for the file, `make:files/0,1` did not use the options as\n  it should do.\n\n  Own Id: OTP-6057 Aux Id: seq10299\n\n- `cover`: When `cover:stop()` was called, the cover compiled code was not\n  unloaded (as stated in the documentation) but simply marked as 'old'. This\n  meant that processes lingering in (or with funs referencing to) the cover\n  compiled code would survive even when the cover server and its ETS tables was\n  terminated.\n\n  Now the cover compiled code is unloaded, meaning that processes lingering\n  in/with references to it will be killed when `cover:stop` is called, instead\n  of later crashing with `badarg` when trying to bump counters in ETS tables no\n  longer existing.","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- Replaced call to deprecated function `file:file_info/1` with call to\n  `filelib:is_dir/1` and `filelib:is_regular/1` in `tags.erl`.\n\n  Own Id: OTP-6079","ref":"notes.html#improvements-and-new-features-39"},{"type":"extras","title":"Tools 2.4.7 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- A bug in `fprof` profiling causing erroneous inconsistent trace failure has\n  been corrected.\n\n  Own Id: OTP-5922 Aux Id: seq10203","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Tools 2.4.6 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- Emacs: `erlang-man-function` and `erlang-man-module` used a pattern matching\n  to find the requested module that sometimes yielded unexpected results. For\n  example, `erlang-man-module file` would display the man page for\n  `CosFileTransfer_File`.\n\n  Own Id: OTP-5746 Aux Id: seq10096\n\n- Some compiler warnings and Dialyzer warnings were eliminated in the Tools\n  application.\n\n  When tracing to a port (which `fprof` does), there could be fake schedule\n  out/schedule in messages sent for a process that had exited.\n\n  Own Id: OTP-5757","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Tools 2.4.5 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The cross reference tool `xref` did not handle the new `fun M:F/A` construct\n  properly. This problem has been fixed.\n\n  Own Id: OTP-5653","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"Tools 2.4.4 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The `cover` tool did not escape '<' and '>' not being part of HTML tags in\n  HTML log files.\n\n  Own Id: OTP-5588","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Tools 2.4.3 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-3"},{"type":"extras","title":"Improvements and New Features - Tools Release Notes","doc":"- It is now possible to encrypt the debug information in beam files, to help\n  keep the source code secret. See `m:compile` for how to provide the key for\n  encrypting, and `m:beam_lib` for how to provide the key for decryption so that\n  tools such as Debugger, `xref`, or `cover` can be used.\n\n  The `beam_lib:chunks/2` functions now accepts an additional chunk type\n  '`compile_info`' to retrieve the compilation information directly as a term.\n  (Thanks to Tobias Lindahl.)\n\n  Own Id: OTP-5460 Aux Id: seq9787","ref":"notes.html#improvements-and-new-features-40"},{"type":"extras","title":"Tools 2.4.2 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The `cover` tool could not analyze empty modules on module level.\n\n  Own Id: OTP-5418","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Tools 2.4.1 - Tools Release Notes","doc":"","ref":"notes.html#tools-2-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Tools Release Notes","doc":"- The `xref` analysis `locals_not_used` could return too many functions. This\n  problem has been fixed.\n\n  Own Id: OTP-5071\n\n- The `cover` tool could not always compile parse transformed modules. This\n  problem has been fixed.\n\n  Own Id: OTP-5305","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"cover - The Coverage Analysis Tool","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# cover - The Coverage Analysis Tool","ref":"cover_chapter.html"},{"type":"extras","title":"Introduction - cover - The Coverage Analysis Tool","doc":"The module `cover` provides a set of functions for coverage analysis of Erlang\nprograms, counting how many times each [executable line](cover_chapter.md#lines)\nis executed.\n\nCoverage analysis can be used to verify test cases, making sure all relevant\ncode is covered, and can be helpful when looking for bottlenecks in the code.","ref":"cover_chapter.html#introduction"},{"type":"extras","title":"Getting Started With Cover - cover - The Coverage Analysis Tool","doc":"","ref":"cover_chapter.html#getting-started-with-cover"},{"type":"extras","title":"Example - cover - The Coverage Analysis Tool","doc":"Assume that a test case for the following program should be verified:\n\n```erlang\n-module(channel).\n-behaviour(gen_server).\n\n-export([start_link/0,stop/0]).\n-export([alloc/0,free/1]). % client interface\n-export([init/1,handle_call/3,terminate/2]). % callback functions\n\nstart_link() ->\n    gen_server:start_link({local,channel}, channel, [], []).\n\nstop() ->\n    gen_server:call(channel, stop).\n\n%%%-Client interface functions-------------------------------------------\n\nalloc() ->\n    gen_server:call(channel, alloc).\n\nfree(Channel) ->\n    gen_server:call(channel, {free,Channel}).\n\n%%%-gen_server callback functions----------------------------------------\n\ninit(_Arg) ->\n    {ok,channels()}.\n\nhandle_call(stop, _Client, Channels) ->\n    {stop,normal,ok,Channels};\n\nhandle_call(alloc, _Client, Channels) ->\n    {Ch,Channels2} = alloc(Channels),\n    {reply,{ok,Ch},Channels2};\n\nhandle_call({free,Channel}, _Client, Channels) ->\n    Channels2 = free(Channel, Channels),\n    {reply,ok,Channels2}.\n\nterminate(_Reason, _Channels) ->\n    ok.\n\n%%%-Internal functions---------------------------------------------------\n\nchannels() ->\n    [ch1,ch2,ch3].\n\nalloc([Channel|Channels]) ->\n    {Channel,Channels};\nalloc([]) ->\n    false.\n\nfree(Channel, Channels) ->\n    [Channel|Channels].\n```\n\nThe test case is implemented as follows:\n\n```erlang\n-module(test).\n-export([s/0]).\n\ns() ->\n    {ok,Pid} = channel:start_link(),\n    {ok,Ch1} = channel:alloc(),\n    ok = channel:free(Ch1),\n    ok = channel:stop().\n```","ref":"cover_chapter.html#example"},{"type":"extras","title":"Preparation - cover - The Coverage Analysis Tool","doc":"First of all, Cover must be started. This spawns a process which owns the Cover\ndatabase where all coverage data will be stored.\n\n```erlang\n1> cover:start().\n{ok,<0.90.0>}\n```\n\nTo include other nodes in the coverage analysis, use\n`cover:start/1`. All cover-compiled modules will then be loaded on all\nnodes, and data from all nodes will be summed up when analysing. For\nsimplicity this example only involves the current node.\n\nBefore any analysis can take place, the involved modules must be\n_cover-compiled_. This means that some extra information is added to\nthe module before beging compiled into a binary and\n[loaded](cover_chapter.md#loading).  The source file of the module is\nnot affected and no `.beam` file is created.\n\n```erlang\n2> cover:compile_module(channel).\n{ok,channel}\n```\n\nEach time a function in the cover-compiled module `channel` is called,\ninformation about the call will be added to the Cover database. Run the test\ncase:\n\n```text\n3> test:s().\nok\n```\n\nCover analysis is performed by examining the contents of the Cover database. The\noutput is determined by two parameters, `Level` and `Analysis`. `Analysis` is\neither `coverage` or `calls` and determines the type of the analysis. `Level` is\neither `module`, `function`, `clause`, or `line` and determines the level of the\nanalysis.","ref":"cover_chapter.html#preparation"},{"type":"extras","title":"Coverage Analysis - cover - The Coverage Analysis Tool","doc":"Analysis of type `coverage` is used to find out how much of the code has been\nexecuted and how much has not been executed. Coverage is represented by a tuple\n`{Cov,NotCov}`, where `Cov` is the number of executable lines that have been\nexecuted at least once and `NotCov` is the number of executable lines that have\nnot been executed.\n\nIf the analysis is made on module level, the result is given for the entire\nmodule as a tuple `{Module,{Cov,NotCov}}`:\n\n```erlang\n4> cover:analyse(channel, coverage, module).\n{ok,{channel,{14,1}}}\n```\n\nFor `channel`, the result shows that 14 lines in the module are covered but one\nline is not covered.\n\nIf the analysis is made on function level, the result is given as a list of\ntuples `{Function,{Cov,NotCov}}`, one for each function in the module. A\nfunction is specified by its module name, function name and arity:\n\n```erlang\n5> cover:analyse(channel, coverage, function).\n{ok,[{{channel,start_link,0},{1,0}},\n     {{channel,stop,0},{1,0}},\n     {{channel,alloc,0},{1,0}},\n     {{channel,free,1},{1,0}},\n     {{channel,init,1},{1,0}},\n     {{channel,handle_call,3},{5,0}},\n     {{channel,terminate,2},{1,0}},\n     {{channel,channels,0},{1,0}},\n     {{channel,alloc,1},{1,1}},\n     {{channel,free,2},{1,0}}]}\n```\n\nFor `channel`, the result shows that the uncovered line is in the function\n`channel:alloc/1`.\n\nIf the analysis is made on clause level, the result is given as a list of tuples\n`{Clause,{Cov,NotCov}}`, one for each function clause in the module. A clause is\nspecified by its module name, function name, arity and position within the\nfunction definition:\n\n```erlang\n6> cover:analyse(channel, coverage, clause).\n{ok,[{{channel,start_link,0,1},{1,0}},\n     {{channel,stop,0,1},{1,0}},\n     {{channel,alloc,0,1},{1,0}},\n     {{channel,free,1,1},{1,0}},\n     {{channel,init,1,1},{1,0}},\n     {{channel,handle_call,3,1},{1,0}},\n     {{channel,handle_call,3,2},{2,0}},\n     {{channel,handle_call,3,3},{2,0}},\n     {{channel,terminate,2,1},{1,0}},\n     {{channel,channels,0,1},{1,0}},\n     {{channel,alloc,1,1},{1,0}},\n     {{channel,alloc,1,2},{0,1}},\n     {{channel,free,2,1},{1,0}}]}\n```\n\nFor `channel`, the result shows that the uncovered line is in the second clause\nof `channel:alloc/1`.\n\nFinally, if the analysis is made on line level, the result is given as a list of\ntuples `{Line,{Cov,NotCov}}`, one for each executable line in the source code. A\nline is specified by its module name and line number.\n\n```erlang\n7> cover:analyse(channel, coverage, line).\n{ok,[{{channel,9},{1,0}},\n     {{channel,12},{1,0}},\n     {{channel,17},{1,0}},\n     {{channel,20},{1,0}},\n     {{channel,25},{1,0}},\n     {{channel,28},{1,0}},\n     {{channel,31},{1,0}},\n     {{channel,32},{1,0}},\n     {{channel,35},{1,0}},\n     {{channel,36},{1,0}},\n     {{channel,39},{1,0}},\n     {{channel,44},{1,0}},\n     {{channel,47},{1,0}},\n     {{channel,49},{0,1}},\n     {{channel,52},{1,0}}]}\n```\n\nFor `channel`, the result shows that the uncovered line is line number 49.","ref":"cover_chapter.html#coverage-analysis"},{"type":"extras","title":"Call Statistics - cover - The Coverage Analysis Tool","doc":"Analysis of type `calls` is used to find out how many times something has been\ncalled and is represented by an integer `Calls`.\n\nIf the analysis is made on module level, the result is given as a tuple\n`{Module,Calls}`. Here `Calls` is the total number of calls to functions in the\nmodule:\n\n```erlang\n8> cover:analyse(channel, calls, module).\n{ok,{channel,12}}\n```\n\nFor `channel`, the result shows that a total of twelve calls have been made to\nfunctions in the module.\n\nIf the analysis is made on function level, the result is given as a list of\ntuples `{Function,Calls}`. Here `Calls` is the number of calls to each function:\n\n```erlang\n9> cover:analyse(channel, calls, function).\n{ok,[{{channel,start_link,0},1},\n     {{channel,stop,0},1},\n     {{channel,alloc,0},1},\n     {{channel,free,1},1},\n     {{channel,init,1},1},\n     {{channel,handle_call,3},3},\n     {{channel,terminate,2},1},\n     {{channel,channels,0},1},\n     {{channel,alloc,1},1},\n     {{channel,free,2},1}]}\n```\n\nFor `channel`, the result shows that `handle_call/3` is the most called function\nin the module (three calls). All other functions have been called once.\n\nIf the analysis is made on clause level, the result is given as a list of tuples\n`{Clause,Calls}`. Here `Calls` is the number of calls to each function clause:\n\n```erlang\n10> cover:analyse(channel, calls, clause).\n{ok,[{{channel,start_link,0,1},1},\n     {{channel,stop,0,1},1},\n     {{channel,alloc,0,1},1},\n     {{channel,free,1,1},1},\n     {{channel,init,1,1},1},\n     {{channel,handle_call,3,1},1},\n     {{channel,handle_call,3,2},1},\n     {{channel,handle_call,3,3},1},\n     {{channel,terminate,2,1},1},\n     {{channel,channels,0,1},1},\n     {{channel,alloc,1,1},1},\n     {{channel,alloc,1,2},0},\n     {{channel,free,2,1},1}]}\n```\n\nFor `channel`, the result shows that all clauses have been called once, except\nthe second clause of `channel:alloc/1` which has not been called at all.\n\nFinally, if the analysis is made on line level, the result is given as a list of\ntuples `{Line,Calls}`. Here `Calls` is the number of times each line has been\nexecuted:\n\n```erlang\n11> cover:analyse(channel, calls, line).\n{ok,[{{channel,9},1},\n     {{channel,12},1},\n     {{channel,17},1},\n     {{channel,20},1},\n     {{channel,25},1},\n     {{channel,28},1},\n     {{channel,31},1},\n     {{channel,32},1},\n     {{channel,35},1},\n     {{channel,36},1},\n     {{channel,39},1},\n     {{channel,44},1},\n     {{channel,47},1},\n     {{channel,49},0},\n     {{channel,52},1}]}\n```\n\nFor `channel`, the result shows that all lines have been executed once, except\nline number 49 which has not been executed at all.","ref":"cover_chapter.html#call-statistics"},{"type":"extras","title":"Analysis to File - cover - The Coverage Analysis Tool","doc":"A line level calls analysis of `channel` can be written to a file using\n`cover:analyse_to_file/1`:\n\n```erlang\n12> cover:analyse_to_file(channel).\n{ok,\"channel.COVER.out\"}\n```\n\nThe function creates a copy of `channel.erl` where it for each executable line\nis specified how many times that line has been executed. The output file is\ncalled `channel.COVER.out`.\n\n```erlang\nFile generated from /Users/bjorng/git/otp/channel.erl by COVER 2024-03-20 at 13:25:04\n\n****************************************************************************\n\n        |  -module(channel).\n        |  -behaviour(gen_server).\n        |\n        |  -export([start_link/0,stop/0]).\n        |  -export([alloc/0,free/1]). % client interface\n        |  -export([init/1,handle_call/3,terminate/2]). % callback functions\n        |\n        |  start_link() ->\n     1..|      gen_server:start_link({local,channel}, channel, [], []).\n        |\n        |  stop() ->\n     1..|      gen_server:call(channel, stop).\n        |\n        |  %%%-Client interface functions-------------------------------------------\n        |\n        |  alloc() ->\n     1..|      gen_server:call(channel, alloc).\n        |\n        |  free(Channel) ->\n     1..|      gen_server:call(channel, {free,Channel}).\n        |\n        |  %%%-gen_server callback functions----------------------------------------\n        |\n        |  init(_Arg) ->\n     1..|      {ok,channels()}.\n        |\n        |  handle_call(stop, _Client, Channels) ->\n     1..|      {stop,normal,ok,Channels};\n        |\n        |  handle_call(alloc, _Client, Channels) ->\n     1..|      {Ch,Channels2} = alloc(Channels),\n     1..|      {reply,{ok,Ch},Channels2};\n        |\n        |  handle_call({free,Channel}, _Client, Channels) ->\n     1..|      Channels2 = free(Channel, Channels),\n     1..|      {reply,ok,Channels2}.\n        |\n        |  terminate(_Reason, _Channels) ->\n     1..|      ok.\n        |\n        |  %%%-Internal functions---------------------------------------------------\n        |\n        |  channels() ->\n     1..|      [ch1,ch2,ch3].\n        |\n        |  alloc([Channel|Channels]) ->\n     1..|      {Channel,Channels};\n        |  alloc([]) ->\n     0..|      false.\n        |\n        |  free(Channel, Channels) ->\n     1..|      [Channel|Channels].\n```","ref":"cover_chapter.html#analysis-to-file"},{"type":"extras","title":"Conclusion - cover - The Coverage Analysis Tool","doc":"By looking at the results from the analyses, it can be deduced that\nthe test case does not cover the case when all channels are allocated\nand `test.erl` should be extended accordingly. Incidentally, when the\ntest case is corrected a bug in `channel` will be discovered.\n\nWhen the Cover analysis is ready, Cover is stopped and all cover-compiled\nmodules are [unloaded](cover_chapter.md#loading). The code for `channel` is now\nloaded as usual from a `.beam` file in the current path.\n\n```erlang\n13> code:which(channel).\ncover_compiled\n14> cover:stop().\nok\n15> code:which(channel).\n\"./channel.beam\"\n```","ref":"cover_chapter.html#conclusion"},{"type":"extras","title":"Miscellaneous - cover - The Coverage Analysis Tool","doc":"","ref":"cover_chapter.html#miscellaneous"},{"type":"extras","title":"Performance - cover - The Coverage Analysis Tool","doc":"Execution of code in cover-compiled modules is slower and more memory consuming\nthan for regularly compiled modules. As the Cover database contains information\nabout each executable line in each cover-compiled module, performance decreases\nproportionally to the size and number of the cover-compiled modules.\n\nTo improve performance when analysing cover results it is possible to do\nmultiple calls to [analyse](`cover:analyse/1`) and\n[analyse_to_file](`cover:analyse_to_file/1`) at once. You can also use the\n[async_analyse_to_file](`cover:async_analyse_to_file/1`) convenience function.\n\n[](){: #lines }","ref":"cover_chapter.html#performance"},{"type":"extras","title":"Executable Lines - cover - The Coverage Analysis Tool","doc":"Cover uses the concept of _executable lines_, which is code lines containing\nan executable expression such as a matching or a function call. A blank line or\na line containing a comment, function head or pattern in a `case` or `receive`\nstatement is not executable.\n\nIn the example below, lines number 2, 4, 6, 8, and 11 are executable lines:\n\n```erlang\n1: is_loaded(Module, Compiled) ->\n2:   case get_file(Module, Compiled) of\n3:     {ok,File} ->\n4:       case code:which(Module) of\n5:         ?TAG ->\n6:           {loaded,File};\n7:         _ ->\n8:           unloaded\n9:       end;\n10:    false ->\n11:      false\n12:  end.\n```\n\n[](){: #loading }","ref":"cover_chapter.html#executable-lines"},{"type":"extras","title":"Code Loading Mechanism - cover - The Coverage Analysis Tool","doc":"When a module is cover-compiled, it is also loaded using the normal code loading\nmechanism of Erlang. This means that if a cover-compiled module is re-loaded\nduring a Cover session, for example using `c(Module)`, it will no longer be\ncover-compiled.\n\nUse `cover:is_compiled/1` or `code:which/1` to see whether or not a\nmodule is cover-compiled (and still loaded).\n\nWhen Cover is stopped, all cover-compiled modules are unloaded.","ref":"cover_chapter.html#code-loading-mechanism"},{"type":"extras","title":"cprof - The Call Count Profiler","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# cprof - The Call Count Profiler\n\n`cprof` is a profiling tool that can be used to get a picture of how often\ndifferent functions in the system are called.\n\n`cprof` uses breakpoints similar to local call trace, but containing counters,\nto collect profiling data. Therefore there is no need for special compilation of\nany module to be profiled.\n\n`cprof` presents all profiled modules in descending total call count order, and\nfor each module presents all profiled functions also in descending call count\norder. A call count limit can be specified to filter out all functions below the\nlimit.\n\nProfiling is done in the following steps:\n\n- **[`cprof:start/*`](`cprof:start/3`)** - Starts profiling with\n  zeroed call counters for specified functions by setting call count\n  breakpoints on them.\n\n- **`Mod:Fun()`** - Runs the code to be profiled.\n\n- **[`cprof:pause/*`](`cprof:pause/3`)** - Pauses the call counters for\n  specified functions. This minimizes the impact of code running in\n  the background or in the shell. Call counters are automatically\n  paused when they \"hit the ceiling\" of the host machine word\n  size. For a 32 bit host the maximum counter value is 2,147,483,647.\n\n- **[`cprof:analyse/*`](`cprof:analyse/2`)** - Collects call counters\n  and computes the result.\n\n- **[`cprof:restart/*`](`cprof:restart/3`)** - Restarts the call\n  counters from zero for specified functions. Can be used to collect a\n  new set of counters without having to stop and start call count\n  profiling.\n\n- **[`cprof:stop/0..3`](`cprof:stop/3`)** - Stops profiling by\n  removing call count breakpoints from specified functions.\n\nFunctions can be specified as either all in the system, all in one module, all\narities of one function, one function, or all functions in all modules not yet\nloaded. BIFs cannot be call-count traced.\n\nThe analysis result can either be for a single module or for all modules. In either\ncase a call count limit can be given to filter out the functions with a call\ncount below the limit. The all modules analysis does _not_ contain the module\n`cprof` itself; the only way to analyze `cprof` is by specifying it as a single\nmodule to analyse.\n\nCall count tracing is very lightweight compared to other forms of tracing since\nno trace message has to be generated. Some measurements indicates performance\ndegradations in the vicinity of 10 percent.\n\nThe following sections show some examples of profiling with `m:cprof`.","ref":"cprof_chapter.html"},{"type":"extras","title":"Example: Background work - cprof - The Call Count Profiler","doc":"From the Erlang shell:\n\n```erlang\n1> cprof:start(), cprof:pause(). % Stop counters just after start\n8492\n2> cprof:analyse().\n{539,\n [{shell,155,\n         [{{shell,prep_check,1},55},\n          {{shell,used_records,4},45},\n          {{shell,used_records,1},45},\n          {{shell,used_record_defs,2},1},\n          {{shell,record_defs,2},1},\n          {{shell,record_bindings,2},1},\n          {{shell,exprs,7},1},\n          {{shell,expr,4},1},\n          {{shell,expand_records,2},1},\n          {{shell,check_command,2},1},\n          {{shell,apply_fun,3},1},\n          {{shell,'-exprs/7-lc$^0/1-0-',1},1},\n          {{shell,'-eval_loop/3-fun-0-',3},1}]},\n  %% Information about many modules omitted.\n                     .\n                     .\n                     .\n  %% Here is the last part.\n  {erts_internal,2,[{{erts_internal,trace_pattern,3},2}]},\n  {otp_internal,1,[{{otp_internal,obsolete,3},1}]},\n  {maps,1,[{{maps,from_list,1},1}]},\n  {erl_internal,1,[{{erl_internal,bif,3},1}]}]}\n3> cprof:analyse(cprof).\n{cprof,3,[{{cprof,tr,2},2},{{cprof,pause,0},1}]}\n4> cprof:stop().\n8586\n```\n\nThe example showed some of the background work that the shell performs just to\ninterpret the first command line.\n\nWhat is captured in this example is the part of the work the shell does while\ninterpreting the command line that occurs between the actual calls to\n[`cprof:start()`](`cprof:start/0`) and [`cprof:analyse()`](`cprof:analyse/1`).","ref":"cprof_chapter.html#example-background-work"},{"type":"extras","title":"Example: One module - cprof - The Call Count Profiler","doc":"From the Erlang shell:\n\n```erlang\n1> cprof:start(),R=calendar:day_of_the_week(1896,4,27),cprof:pause(),R.\n1\n2> cprof:analyse(calendar).\n{calendar,9,\n          [{{calendar,last_day_of_the_month1,2},1},\n           {{calendar,last_day_of_the_month,2},1},\n           {{calendar,is_leap_year1,1},1},\n           {{calendar,is_leap_year,1},1},\n           {{calendar,dy,1},1},\n           {{calendar,dm,1},1},\n           {{calendar,df,2},1},\n           {{calendar,day_of_the_week,3},1},\n           {{calendar,date_to_gregorian_days,3},1}]}\n3> cprof:stop().\n8648\n```\n\nThe example tells us that \"Aktiebolaget LM Ericsson & Co\" was registered on a\nMonday (since the return value of the first command is 1), and that the\n`calendar` module needed 9 function calls to calculate that.\n\nUsing `cprof:analyse()` in this example also shows approximately the same\nbackground work as in the first example.","ref":"cprof_chapter.html#example-one-module"},{"type":"extras","title":"Example: In the code - cprof - The Call Count Profiler","doc":"Write a module:\n\n```erlang\n-module(sort).\n-export([do/1]).\n\ndo(N) ->\n    cprof:stop(),\n    cprof:start(),\n    do(N, []).\n\ndo(0, L) ->\n    R = lists:sort(L),\n    cprof:pause(),\n    R;\ndo(N, L) ->\n    do(N-1, [rand:uniform(256)-1 | L]).\n```\n\nFrom the Erlang shell:\n\n```erlang\n1> c(sort).\n{ok,sort}\n2> rand:seed(default, 42), ok.\nok.\n3> sort:do(1000).\n[0,0,0,1,1,1,1,2,2,3,3,4,4,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8|...]\n4> cprof:analyse().\n{13180,\n [{lists,6173,\n         [{{lists,rmerge3_1,6},1045},\n          {{lists,rmerge3_2,6},977},\n          {{lists,split_1,5},652},\n          {{lists,merge3_1,6},579},\n          {{lists,merge3_2,6},577},\n          {{lists,rmerge3_12_3,6},511},\n          {{lists,split_1_1,6},347},\n          {{lists,merge3_12_3,6},310},\n          {{lists,rmerge3_21_3,6},282},\n          {{lists,merge3_21_3,6},221},\n          {{lists,merge2_1,4},154},\n          {{lists,merge2_2,5},138},\n          {{lists,reverse,2},106},\n          {{lists,rmerge2_2,5},87},\n          {{lists,rmergel,2},81},\n          {{lists,rmerge2_1,4},75},\n          {{lists,mergel,2},28},\n          {{lists,keyfind,3},2},\n          {{lists,sort,1},1}]},\n  {rand,5000,\n        [{{rand,uniform_s,2},1000},\n         {{rand,uniform,1},1000},\n         {{rand,seed_put,1},1000},\n         {{rand,seed_get,0},1000},\n         {{rand,exsss_uniform,2},1000}]},\n  {erlang,1004,\n          [{{erlang,put,2},1000},\n           {{erlang,trace_pattern,3},2},\n           {{erlang,ensure_tracer_module_loaded,2},2}]},\n  {sort,1001,[{{sort,do,2},1001}]},\n  {erts_internal,2,[{{erts_internal,trace_pattern,3},2}]}]}\n5> cprof:stop().\n12625\n```\n\nThe example shows some details of how `lists:sort/1` works. It used 6173\nfunction calls in module `m:lists` to complete the work.\n\nThis time, since the shell was not involved in starting and stopping `cprof`, no\nother work was done in the system during the profiling.","ref":"cprof_chapter.html#example-in-the-code"},{"type":"extras","title":"The Erlang mode for Emacs","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# The Erlang mode for Emacs","ref":"erlang_mode_chapter.html"},{"type":"extras","title":"Purpose - The Erlang mode for Emacs","doc":"The purpose of this user guide is to introduce you to the Erlang mode\nfor Emacs and gives some relevant background information of the\nfunctions and features.  See also [Erlang mode reference\nmanual](../references/erlang.el.md) The purpose of the Erlang mode\nitself is to facilitate the developing process for the Erlang\nprogrammer.","ref":"erlang_mode_chapter.html#purpose"},{"type":"extras","title":"Pre-requisites - The Erlang mode for Emacs","doc":"Basic knowledge of Emacs and Erlang/OTP.","ref":"erlang_mode_chapter.html#pre-requisites"},{"type":"extras","title":"Elisp - The Erlang mode for Emacs","doc":"Two Elisp modules are included in this tool package for\nEmacs. `erlang.el` defines the actual Erlang mode and\n`erlang-start.el` makes some nice initializations.","ref":"erlang_mode_chapter.html#elisp"},{"type":"extras","title":"Setup on UNIX - The Erlang mode for Emacs","doc":"To set up the Erlang Emacs mode on a UNIX systems, edit or create the file `.emacs`\nin the your home directory.\n\nBelow is a complete example of what should be added to a user's `.emacs`\nprovided that OTP is installed in the directory `/usr/local/otp `:\n\n```text\n(setq load-path (cons  \"/usr/local/otp/lib/tools- /emacs\"\nload-path))\n(setq erlang-root-dir \"/usr/local/otp\")\n(setq exec-path (cons \"/usr/local/otp/bin\" exec-path))\n(require 'erlang-start)\n```","ref":"erlang_mode_chapter.html#setup-on-unix"},{"type":"extras","title":"Setup on Windows - The Erlang mode for Emacs","doc":"To set up the Erlang Emacs mode on a Windows systems, edit/create the file\n`.emacs`, the location of the file depends on the configuration of the system.\nIf the _HOME_ environment variable is set, Emacs will look for the `.emacs` file\nin the directory indicated by the `HOME` variable. If `HOME` is not set, Emacs\nwill look for the `.emacs` file in `C:\\ `.\n\nBelow is a complete example of what should be added to a user's `.emacs`\nprovided that OTP is installed in the directory `C:\\Program Files\\Erlang OTP`:\n\n```lisp\n(setq load-path (cons  \"C:/Program Files/Erlang OTP/lib/tools- /emacs\"\nload-path))\n(setq erlang-root-dir \"C:/Program Files/Erlang OTP\")\n(setq exec-path (cons \"C:/Program Files/Erlang OTP/bin\" exec-path))\n(require 'erlang-start)\n```\n\n> #### Note {: .info }\n>\n> In `.emacs`, the slash character (`/`) can be used as path separator. But if you\n> decide to use the backslash character (`\\`), note that backslashes have to be\n> doubled, since they are treated as escape characters by Emacs.","ref":"erlang_mode_chapter.html#setup-on-windows"},{"type":"extras","title":"Indentation - The Erlang mode for Emacs","doc":"The \"Oxford Advanced Learners Dictionary of Current English\" says the following\nabout the word \"indent\":\n\n> \"start (a line of print or writing) farther from the margin than the others\".\n\nThe Erlang mode does, of course, provide this feature. The layout used is based\non the common use of the language.\n\nIt is strongly recommended to use this feature and avoid to indent lines in a\nnonstandard way. Some motivations are:\n\n- Code using the same layout is easy to read and maintain.\n- Since several features of Erlang mode is based on the standard layout they\n  might not work correctly if a nonstandard layout is used.\n\nThe indentation features can be used to reindent large sections of a file. If\nsome lines use nonstandard indentation they will be reindented.","ref":"erlang_mode_chapter.html#indentation"},{"type":"extras","title":"Editing - The Erlang mode for Emacs","doc":"- _`M-x erlang-mode RET`_ \\- This command activates the Erlang major mode for\n  the current buffer. When this mode is active the mode line contain the word\n  \"Erlang\".\n\nWhen the Erlang mode is correctly installed, it is automatically activated when\na file ending in `.erl` or `.hrl` is opened in Emacs.\n\nWhen a file is saved the name in the `-module().` line is checked against the\nfile name. Should they mismatch Emacs can change the module specifier so that it\nmatches the file name. By default, the user is asked before the change is\nperformed.\n\nAn \"electric\" command is a character that in addition to just inserting the\ncharacter performs some type of action. For example the `;` character is typed\nin a situation where is ends a function clause a new function header is\ngenerated. The electric commands are as follows:\n\n- `erlang-electric-comma` \\- Insert a comma character and possibly a new\n  indented line.\n- `erlang-electric-semicolon` \\- Insert a semicolon character and possibly a\n  prototype for the next line.\n- `erlang-electric-gt` \\- Insert a `>` character and possible a new indented line.\n\nTo disable all electric commands set the variable `erlang-electric-commands` to\nthe empty list. In short, place the following line in your `.emacs`\\-file:\n\n```text\n(setq erlang-electric-commands '())\n```","ref":"erlang_mode_chapter.html#editing"},{"type":"extras","title":"Syntax highlighting - The Erlang mode for Emacs","doc":"It is possible for Emacs to use colors when displaying a buffer. By \"syntax\nhighlighting\", we mean that syntactic components, for example keywords and\nfunction names, will be colored.\n\nThe basic idea of syntax highlighting is to make the structure of a program\nclearer. For example, the highlighting will make it easier to spot simple bugs.\nHave not you ever written a variable in lower-case only? With syntax\nhighlighting a variable will colored while atoms will be shown with the normal\ntext color.","ref":"erlang_mode_chapter.html#syntax-highlighting"},{"type":"extras","title":"Tags - The Erlang mode for Emacs","doc":"Tags is a standard Emacs package used to record information about source files\nin large development projects. In addition to listing the files of a project, a\ntags file normally contains information about all functions and variables that\nare defined. By far, the most useful command of the tags system is its ability\nto find the definition of functions in any file in the project. But the Tags\nsystem is not limited to this feature, for example, it is possible to do a text\nsearch in all files in a project, or to perform a project-wide search and\nreplace.\n\nIn order to use the Tags system a file named `TAGS` must be created. The file\ncan be seen as a database over all functions, records, and macros in all files\nin the project. The `TAGS` file can be created using two different methods for\nErlang. The first is the standard Emacs utility \"etags\", the second is by using\nthe Erlang module `tags`.","ref":"erlang_mode_chapter.html#tags"},{"type":"extras","title":"Etags - The Erlang mode for Emacs","doc":"`etags` is a program that is part of the Emacs distribution. It is normally\nexecuted from a command line, like a Unix shell or a DOS box.\n\nThe `etags` program of fairly modern versions of Emacs and XEmacs has native\nsupport for Erlang. To check if your version does include this support, issue\nthe command `etags --help` at a the command line prompt. At the end of the help\ntext there is a list of supported languages. Unless Erlang is a member of this\nlist I suggest that you should upgrade to a newer version of Emacs.\n\nAs seen in the help text — unless you have not upgraded your Emacs yet — `etags`\nassociate the file extensions `.erl` and `.hrl` with Erlang.\n\nBasically, the `etags` utility is run using the following form:\n\n```bash\netags file1.erl file2.erl\n```\n\nThis will create a file named `TAGS` in the current directory.\n\nThe `etags` utility can also read a list of files from its standard input by\nsupplying a single dash in place of the file names. This feature is useful when\na project consists of a large number of files. The standard UNIX command `find`\ncan be used to generate the list of files, for example:\n\n```bash\nfind . -name \"*.[he]rl\" -print | etags -\n```\n\nThe above line will create a `TAGS` file covering all the Erlang source files in\nthe current directory, and in the subdirectories below.\n\nSee the GNU Emacs Manual and the etags man page for more info.","ref":"erlang_mode_chapter.html#etags"},{"type":"extras","title":"Shell - The Erlang mode for Emacs","doc":"The look and feel on an Erlang shell inside Emacs should be the same as in a\nnormal Erlang shell. There is just one major difference, the cursor keys will\nactually move the cursor around just like in any normal Emacs buffer. The\ncommand line history can be accessed by the following commands:\n\n- *`C-up `*or _`M-p `_(`comint-previous-input`) - Move to the previous line in\n  the input history.\n- *`C-down `*or _`M-n `_(`comint-next-input`) - Move to the next line in the\n  input history.\n\nIf the Erlang shell buffer would be killed the command line history is saved to\na file. The command line history is automatically retrieved when a new Erlang\nshell is started.","ref":"erlang_mode_chapter.html#shell"},{"type":"extras","title":"Compilation - The Erlang mode for Emacs","doc":"The classic edit-compile-bugfix cycle for Erlang is to edit the source file in\nan editor, save it to a file and switch to an Erlang shell. In the shell the\ncompilation command is given. Should the compilation fail you have to bring out\nthe editor and locate the correct line.\n\nWith the Erlang editing mode the entire edit-compile-bugfix cycle can be\nperformed without leaving Emacs. Emacs can order Erlang to compile a file and it\ncan parse the error messages to automatically place the point on the erroneous\nlines.","ref":"erlang_mode_chapter.html#compilation"},{"type":"extras","title":"fprof - The File Trace Profiler","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# fprof - The File Trace Profiler\n\n`m:fprof` is a profiling tool that can be used to get a picture of how much\nprocessing time different functions consumes and in which processes.\n\n`fprof` uses tracing with timestamps to collect profiling data. Therefore there\nis no need for special compilation of any module to be profiled.\n\n`fprof` presents wall clock times from the host machine OS, with the assumption\nthat OS scheduling will randomly load the profiled functions in a fair way. Both\n_own time_, that is, the time used by a function for its own execution, and\n_accumulated time_, that is, execution time including called functions.\n\nProfiling is essentially done in 3 steps:\n\n- Tracing to a file.\n\n- Profiling: the trace file is read and raw profile data is collected\n  into an internal RAM storage on the node. During this step the trace data may\n  be dumped in text format to file or console.\n\n- Analysing: the raw profile data is sorted and dumped in text format\n  either to file or console.\n\nSince `fprof` stores trace data to a file, the runtime performance degradation is\nminimized, but still far from negligible, especially for programs that themselves\nuse the filesystem heavily. Where the trace file is placed is also important;\non Unix systems `/tmp` is usually a good choice, while any\nnetwork-mounted disk is a bad choice.\n\n`fprof` can also skip the file step and trace to a tracer process of its own that\ndoes the profiling in runtime.\n\nThe following sections show some examples of how to profile with `m:fprof`.","ref":"fprof_chapter.html"},{"type":"extras","title":"Profiling from the source code - fprof - The File Trace Profiler","doc":"If you can edit and recompile the source code, it is convenient to\ninsert [`fprof:trace(start)`](`fprof:trace/1`) and\n[`fprof:trace(stop)`](`fprof:trace/1`) before and after the code to be profiled.\nAll spawned processes are also traced. If you want some other filename than\nthe default, use [`fprof:trace(start, \"my_fprof.trace\")`](`fprof:trace/2`).\n\nWhen execution is finished, the raw profile can be processed using\n[`fprof:profile()`](`fprof:profile/0`),\nor [`fprof:profile(file, \"my_fprof.trace\")`](`fprof:profile/2`)\nfor a non-default filename.\n\nFinally create an informative table dumped on the console with\n[`fprof:analyse()`](`fprof:analyse/0`), or on file with\n[`fprof:analyse(dest, [])`](`fprof:analyse/2`), or\n[`fprof:analyse([{dest, \"my_fprof.analysis\"}, {cols, 120}])`](`fprof:analyse/1`)\nfor a wider listing of a non-default filename.","ref":"fprof_chapter.html#profiling-from-the-source-code"},{"type":"extras","title":"Profiling a function - fprof - The File Trace Profiler","doc":"If you have one function that does the task that you want to profile, and the\nfunction returns when the profiling should stop, it is convenient to use\n[`fprof:apply(Module, Function, Args)`](`fprof:apply/3`) for the tracing step.\n\nIf the tracing should continue after the function has returned, for\nexample if it is a start function that spawns processes to be\nprofiled, use\n[`fprof:apply(M, F, Args, [continue | OtherOpts])`](`fprof:apply/4`).\nThe tracing has to be stopped at a suitable later time using\n[`fprof:trace(stop)`](`fprof:trace/1`).","ref":"fprof_chapter.html#profiling-a-function"},{"type":"extras","title":"Immediate profiling - fprof - The File Trace Profiler","doc":"It is also possible to trace immediately into the profiling process that creates\nthe raw profile data, that is to short circuit the tracing and profiling steps\nso that the filesystem is not used for tracing.\n\nDo something like this:\n\n```erlang\n{ok, Tracer} = fprof:profile(start),\nfprof:trace([start, {tracer, Tracer}]),\n%% Run code to profile\nfprof:trace(stop);\n```\n\nThis puts less load on the filesystem, but much more load on the Erlang runtime\nsystem.","ref":"fprof_chapter.html#immediate-profiling"},{"type":"extras","title":"lcnt - The Lock Profiler","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# lcnt - The Lock Profiler\n\nInternally in the Erlang runtime system locks are used to protect resources from\nbeing updated from multiple threads in a fatal way. Locks are necessary to\nensure that the runtime system works properly, but it also introduces\nlimitations, namely _lock contention_ and _locking overhead_.\n\nWith lock contention we mean when one thread locks a resource, and another\nthread (or threads) tries to acquire the same resource at the same time. The\nlock will deny the other thread access to the resource and the thread will be\nblocked from continuing its execution. The second thread has to wait until the\nfirst thread has completed its access to the resource and unlocked it. The\n`lcnt` tool measures these lock conflicts.\n\nLocks have an inherent cost in execution time and memory space. It takes time to\ninitialize, destroy, acquire, or release locks. To decrease lock contention\nit is sometimes necessary to use finer-grained locking strategies. This\nusually also increases the locking overhead. Hence there is a tradeoff between\nlock contention and overhead. In general, lock contention increases with the\nnumber of threads running concurrently.\n\nThe `lcnt` tool does not measure locking overhead.","ref":"lcnt_chapter.html"},{"type":"extras","title":"Enabling lock-counting - lcnt - The Lock Profiler","doc":"For investigation of locks in the emulator we use an internal tool called `lcnt`\n(short for lock-count). The VM needs to be compiled with this option enabled. To\ncompile a lock-counting VM along with a normal VM, use:\n\n```text\ncd $ERL_TOP\n./configure --enable-lock-counter\nmake\n```\n\nStart the lock-counting VM like this:\n\n```text\n$ERL_TOP/bin/erl -emu_type lcnt\n```\n\nTo verify that lock counting is enabled check that `[lock-counting]` appears in\nthe status text when the VM is started.\n\n```text\nErlang/OTP 27 [erts-15.0] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit] [lock-counting]\n```","ref":"lcnt_chapter.html#enabling-lock-counting"},{"type":"extras","title":"Getting started - lcnt - The Lock Profiler","doc":"Once you have a lock counting enabled VM the module `lcnt` can be used. The\nmodule is intended to be used from the current running nodes shell. To access\nremote nodes use [`lcnt:clear(Node)`](`lcnt:clear/1`) and\n[`lcnt:collect(Node)`](`lcnt:collect/1`).\n\nAll locks are continuously monitored and its statistics updated. Use\n[`lcnt:clear/0`](`lcnt:clear/1`) to initially clear all counters\nbefore running any specific tests. This command will also reset the\ninternal duration timer.\n\nTo retrieve lock statistics information, use\n[`lcnt:collect/0,1`](`lcnt:collect/1`). The collect operation will\nstart a `lcnt` server if it not already started. All collected data\nwill be stored in an Erlang term and uploaded to the server along with\nthe duration time. The duration time is the time between\n[`lcnt:clear/0,1`](`lcnt:clear/1`) and\n[`lcnt:collect/0,1`](`lcnt:collect/1`).\n\nOnce the data is collected to the server it can be filtered, sorted, and printed\nin multiple ways.","ref":"lcnt_chapter.html#getting-started"},{"type":"extras","title":"Example of usage - lcnt - The Lock Profiler","doc":"Here is an example of running the [Big Bang Benchmark](#the-big-bang-benchmark):\n\n```text\nErlang/OTP 27 [erts-15.0] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit] [lock-counting]\n\nEshell V15.0 (press Ctrl+G to abort, type help(). for help)\n1> lcnt:rt_opt({copy_save, true}).\nfalse\n2> lcnt:clear(), big:bang(1000), lcnt:collect().\nok\n3> lcnt:conflicts().\n      lock   id  #tries  #collisions  collisions [%]  time [us]  duration [%]\n     -----  --- ------- ------------ --------------- ---------- -------------\n run_queue   10  590799         8875          1.5022      37906        2.2167\n proc_msgq 1048 2515180         4667          0.1856      20962        1.2258\n proc_main 1048 2195317        23775          1.0830       1664        0.0973\nok\n```\n\nAnother way to to profile a specific function is to use `lcnt:apply/3` or\n`lcnt:apply/1`, which calls `lcnt:clear/0` before calling the function and\n`lcnt:collect/0` after its invocation. This method should only be used in\nmicro-benchmarks since it sets `copy_save` to `true` for the duration of the\nfunction call, which may cause the emulator to run out of memory if attempted\nunder load.\n\n```text\n1> lcnt:apply(fun() -> big:bang(1000) end).\n1845411\n2> lcnt:conflicts().\n      lock   id  #tries  #collisions  collisions [%]  time [us]  duration [%]\n     -----  --- ------- ------------ --------------- ---------- -------------\n run_queue   10  582789         9237          1.5850      41929        2.2633\n proc_msgq 1047 2494483         4731          0.1897      11173        0.6031\n proc_main 1047 2192806        23283          1.0618       1500        0.0810\nok\n```\n\nThe process locks are sorted after its class like all other locks. It is\nconvenient to look at specific processes and ports as classes. We can do this by\nswapping class and class identifiers with `lcnt:swap_pid_keys/0`.\n\n```text\n3> lcnt:swap_pid_keys().\nok\n4> lcnt:conflicts([{print, [name, tries, ratio, time]}]).\n                   lock  #tries  collisions [%]  time [us]\n                  ----- ------- --------------- ----------\n              run_queue  582789          1.5850      41929\n      5692          0.5095        484\n       4989          0.4410        393\n       6319          2.1839        284\n       6077          1.9747        198\n       5071          1.3015        192\n       5846          1.7106        186\n       6305          1.2054        179\n       5820          1.2715        176\n       6329          1.4852        168\n       5172          0.8701        167\n       5306          0.4146        166\n       5838          1.9870        160\n       6346          1.5443        143\n       5542          0.4331        141\n       5260          0.2662        137\n       5610          0.9447        127\n       5354          0.5230        118\n       5845          0.9239        115\n       5140          0.7782        108\nok\n```","ref":"lcnt_chapter.html#example-of-usage"},{"type":"extras","title":"Example with Mnesia Transaction Benchmark - lcnt - The Lock Profiler","doc":"From the Erlang shell:\n\n```erlang\nErlang/OTP 27 [erts-15.0] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit] [lock-counting]\n\nEshell V15.0 (press Ctrl+G to abort, type help(). for help)\n1> Conf = [{db_nodes, [node()]}, {driver_nodes, [node()]}, {replica_nodes, [node()]},\n    {n_drivers_per_node, 10}, {n_branches, 1000}, {n_accounts_per_branch, 10},\n    {replica_type, ram_copies}, {stop_after, 60000}, {reuse_history_id, true}], ok.\nok\n2> mnesia_tpcb:init([{use_running_mnesia, false}|Conf]).\n    .\n    .\n    .\nignore\n```\n\nInitial configuring of the benchmark is done. It is time to profile the actual\nMnesia benchmark:\n\n```erlang\n3> lcnt:apply(fun() -> {ok,{time, Tps,_,_,_,_}} = mnesia_tpcb:run([{use_running_mnesia,\n    true}|Conf]), Tps/60 end).\n      .\n      .\n      .\n50204.666666666664\n```\n\nThe benchmark runs for 60 seconds (followed by verification and\nanalysis), and then returns the number of transactions per seconds.\n\n```text\n4> lcnt:swap_pid_keys().\nok\n5> lcnt:conflicts().\n                   lock      id    #tries  #collisions  collisions [%]  time [us]  duration [%]\n                  -----     ---   ------- ------------ --------------- ---------- -------------\n              run_queue      10  89329288      3227515          3.6131    5018119        8.3606\n          mnesia_locker       5  64793236      8231226         12.7038      98654        0.1644\n                 db_tab 3012324 416847817       140631          0.0337      75308        0.1255\n         5  14499900        36934          0.2547       4878        0.0081\n         5  14157504        35797          0.2528       4727        0.0079\n         5  14194934        34510          0.2431       4403        0.0073\n         5  14149447        35326          0.2497       4150        0.0069\n         5  14316525        35675          0.2492       4116        0.0069\n         5  14241146        35358          0.2483       4101        0.0068\n         5  14224491        35182          0.2473       4094        0.0068\n         5  14190075        35328          0.2490       4075        0.0068\n         5  14308906        35031          0.2448       3896        0.0065\n         5  14457330        36182          0.2503       3856        0.0064\n              mnesia_tm       5  28149333       179294          0.6369       1057        0.0018\n               pix_lock    1024       132            1          0.7576        549        0.0009\n           5        17            2         11.7647         87        0.0001\n         5      1335            6          0.4494          1        0.0000\nok\n```\n\nThe `id` header represents the number of unique identifiers under a\nclass when the option `{combine, true}` is used (which is enabled by\ndefault). It will otherwise show the specific identifier. The `db_tab`\nlisting shows 3,012,324 unique locks, which is one for each ETS table\ncreated. Mnesia creates one ETS table for each transaction.\n\nThe listing shows also shows that the `mnesia_locker` process has highly contended locks.\nUsing `lcnt:inspect/1` more information can be displayed for that process:\n\n```text\n6> lcnt:inspect(mnesia_locker).\n          lock          id   #tries  #collisions  collisions [%]  time [us]  duration [%] histogram [log2(us)]\n         -----         ---  ------- ------------ --------------- ---------- ------------- ---------------------\n mnesia_locker   proc_main 19853372      7591248         38.2366      80550        0.1342 |.    ...X........             |\n mnesia_locker   proc_msgq 30917225       639627          2.0688      17126        0.0285 |.    .X.........              |\n mnesia_locker proc_status  9348426          351          0.0038        978        0.0016 |        .xxX. .               |\n mnesia_locker    proc_btm        0            0          0.0000          0        0.0000 |                              |\n mnesia_locker  proc_trace  4674213            0          0.0000          0        0.0000 |                              |\nok\n```\n\nListing the conflicts without class combiner:\n\n```text\n7> lcnt:conflicts([{combine, false}, {print, [name, id, tries, ratio, time]}]).\n                   lock                        id   #tries  collisions [%]  time [us]\n                  -----                       ---  ------- --------------- ----------\n              run_queue                         2 31075249          3.5676    1728233\n              run_queue                         1 29738521          3.6348    1683219\n              run_queue                         3 27912150          3.6429    1573593\n          mnesia_locker                 proc_main 19853372         38.2366      80550\n                 db_tab mnesia_transient_decision  3012281          2.5675      55104\n              run_queue                         4   512077          3.7041      29486\n          mnesia_locker                 proc_msgq 30917225          2.0688      17126\n                 db_tab                   account  6044562          0.3599       7909\n                 db_tab                    branch  6026659          0.3132       5654\n                 db_tab                    teller  6044659          0.2684       4727\n                   proc_main  3207155          0.7178       3726\n                   proc_main  3138532          0.7485       3593\n                   proc_main  3133180          0.7156       3547\n                   proc_main  3165128          0.7609       3517\n                   proc_main  3128838          0.7525       3477\n                   proc_main  3137627          0.7559       3433\n                   proc_main  3144886          0.7509       3425\n                   proc_main  3149315          0.7487       3372\n                   proc_main  3196546          0.7591       3310\n                   proc_main  3164333          0.7483       3309\nok\n```\n\nIn this scenario the locks for the scheduler's run queues dominate the time waiting\nfor locks. The most contended lock for ETS tables is for the `mnesia_transient_decision`\nETS table.\n\nHere is how to show the information for the ETS tables.\n\n```text\n8> lcnt:inspect(db_tab, [{print, [name, id, tries, colls, ratio, duration]}]).\n   lock                        id    #tries  #collisions  collisions [%]  duration [%]\n  -----                       ---   ------- ------------ --------------- -------------\n db_tab mnesia_transient_decision   3012281        77341          2.5675        0.0918\n db_tab                   account   6044562        21753          0.3599        0.0132\n db_tab                    branch   6026659        18873          0.3132        0.0094\n db_tab                    teller   6044659        16221          0.2684        0.0079\n db_tab                   history   3012281         4005          0.1330        0.0022\n db_tab              mnesia_stats   3071064         2437          0.0794        0.0010\n db_tab        mnesia_trans_store        15            0          0.0000        0.0000\n db_tab           mnesia_decision   3012281            0          0.0000        0.0000\n db_tab                    schema         0            0          0.0000        0.0000\n db_tab                      dets         0            0          0.0000        0.0000\n db_tab               dets_owners         0            0          0.0000        0.0000\n db_tab             dets_registry         0            0          0.0000        0.0000\n db_tab         mnesia_lock_queue  36154974            0          0.0000        0.0000\n db_tab       mnesia_sticky_locks  12108098            0          0.0000        0.0000\n db_tab          mnesia_tid_locks  27176721            0          0.0000        0.0000\n db_tab         mnesia_held_locks  48321870            0          0.0000        0.0000\n db_tab             mnesia_subscr         0            0          0.0000        0.0000\n db_tab               mnesia_gvar 102680683            1          0.0000        0.0000\n db_tab            user_functions         0            0          0.0000        0.0000\n db_tab             shell_records         0            0          0.0000        0.0000\nok\n```","ref":"lcnt_chapter.html#example-with-mnesia-transaction-benchmark"},{"type":"extras","title":"Deciphering the output - lcnt - The Lock Profiler","doc":"Typically high `time` values are bad and this is often the thing to look for.\nHowever, one should also look for high lock acquisition frequencies (`#tries`)\nsince locks generate overhead and because high frequency could become\nproblematic if they begin to have conflicts even if it is not shown in a\nparticular test.","ref":"lcnt_chapter.html#deciphering-the-output"},{"type":"extras","title":"The Big Bang Benchmark - lcnt - The Lock Profiler","doc":"```erlang\n-module(big).\n-export([bang/1]).\n\npinger([], [], true) ->\n    receive\n\t{procs, Procs, ReportTo} ->\n\t    pinger(Procs, [], ReportTo)\n    end;\npinger([], [], false) ->\n    receive {ping, From} -> From ! {pong, self()} end,\n    pinger([],[],false);\npinger([], [], ReportTo) ->\n    ReportTo ! {done, self()},\n    pinger([],[],false);\npinger([], [Po|Pos] = Pongers, ReportTo) ->\n    receive\n\t{ping, From} ->\n\t    From ! {pong, self()},\n\t    pinger([], Pongers, ReportTo);\n\t{pong, Po} ->\n\t    pinger([], Pos, ReportTo)\n    end;\npinger([Pi|Pis], Pongers, ReportTo) ->\n    receive {ping, From} -> From ! {pong, self()}\n    after 0 -> ok\n    end,\n    Pi ! {ping, self()},\n    pinger(Pis, [Pi|Pongers], ReportTo).\n\nspawn_procs(N) when N =< 0 ->\n    [];\nspawn_procs(N) ->\n    [spawn_link(fun () -> pinger([],[],true) end) | spawn_procs(N-1)].\n\nsend_procs([], Msg) ->\n    Msg;\nsend_procs([P|Ps], Msg) ->\n    P ! Msg,\n    send_procs(Ps, Msg).\n\nreceive_msgs([]) ->\n    ok;\nreceive_msgs([M|Ms]) ->\n    receive\n\tM ->\n\t    receive_msgs(Ms)\n    end.\n\nbang(N) when integer(N) ->\n    Procs = spawn_procs(N),\n    RMsgs = lists:map(fun (P) -> {done, P} end, Procs),\n    Start = now(),\n    send_procs(Procs, {procs, Procs, self()}),\n    receive_msgs(RMsgs),\n    Stop = now(),\n    lists:foreach(fun (P) -> exit(P, normal) end, Procs),\n    timer:now_diff(Stop, Start).\n```","ref":"lcnt_chapter.html#the-big-bang-benchmark"},{"type":"extras","title":"See Also - lcnt - The Lock Profiler","doc":"[LCNT Reference Manual](`m:lcnt`)","ref":"lcnt_chapter.html#see-also"},{"type":"extras","title":"Xref - The Cross Reference Tool","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Xref - The Cross Reference Tool\n\nXref is a cross reference tool that can be used for finding dependencies between\nfunctions, modules, applications and releases. It does so by analyzing the\ndefined functions and the function calls.\n\nIn order to make Xref easy to use, there are predefined analyses that perform\nsome common tasks. Typically, a module or a release can be checked for calls to\nundefined functions. For the somewhat more advanced user there is a small but\nflexible language that can be used for selecting parts of the analyzed\nsystem and for doing some simple graph analyses on selected calls.\n\nThe following sections show some features of Xref, beginning with a module check\nand a predefined analysis. Then follow examples that can be skipped on the first\nreading; not all of the concepts used are explained, and it is assumed that the\n[reference manual](`m:xref`) has been at least skimmed.","ref":"xref_chapter.html"},{"type":"extras","title":"Module Check - Xref - The Cross Reference Tool","doc":"Assume we want to check the following module:\n\n```erlang\n-module(my_module).\n\n-export([t/1]).\n\nt(A) ->\n  my_module:t2(A).\n\nt2(_) ->\n  true.\n```\n\nCross reference data are read from BEAM files, so the first step when checking\nan edited module is to compile it:\n\n```erlang\n1> c(my_module, debug_info).\n./my_module.erl:10: Warning: function t2/1 is unused\n{ok, my_module}\n```\n\nThe `debug_info` option ensures that the BEAM file contains debug information,\nwhich makes it possible to find unused local functions.\n\nThe module can now be checked for calls to\n[deprecated functions](`m:xref#deprecated_function`), calls to\n[undefined functions](`m:xref#undefined_function`), and for unused local\nfunctions:\n\n```erlang\n2> xref:m(my_module)\n[{deprecated,[]},\n {undefined,[{{my_module,t,1},{my_module,t2,1}}]},\n {unused,[{my_module,t2,1}]}]\n```\n\n`m/1` is also suitable for checking that the BEAM file of a module that is about\nto be loaded into a running a system does not call any undefined functions. In\neither case, the code path of the code server (see the module `code`) is used\nfor finding modules that export externally called functions not exported by the\nchecked module itself, so called [library modules](`m:xref#library_module`).","ref":"xref_chapter.html#module-check"},{"type":"extras","title":"Predefined Analysis - Xref - The Cross Reference Tool","doc":"In the last example the module to analyze was given as an argument to `m/1`, and\nthe code path was (implicitly) used as [library path](`m:xref#library_path`). In\nthis example an [xref server](`m:xref#xref_server`) will be used, which makes it\npossible to analyze applications and releases, and also to select the library\npath explicitly.\n\nEach Xref server is referred to by a unique name. The name is given when\ncreating the server:\n\n```erlang\n1> xref:start(s).\n{ok,<0.27.0>}\n```\n\nNext the system to be analyzed is added to the Xref server. Here the system will\nbe OTP, so no library path will be needed. Otherwise, when analyzing a system\nthat uses OTP, the OTP modules are typically made library modules by setting the\nlibrary path to the default OTP code path (or to `code_path`, see the\n[reference manual](`m:xref#code_path`)). By default, the names of read BEAM\nfiles and warnings are output when adding analyzed modules, but these messages\ncan be avoided by setting default values of some options:\n\n```erlang\n2> xref:set_default(s, [{verbose,false}, {warnings,false}]).\nok\n3> xref:add_release(s, code:lib_dir(), {name, otp}).\n{ok,otp}\n```\n\n`add_release/3` assumes that all subdirectories of the library directory\nreturned by [`code:lib_dir()`](`code:lib_dir/0`) contain applications;\nthe effect is that of reading all BEAM files for the application.\n\nIt is now easy to check the release for calls to undefined functions:\n\n```erlang\n4> xref:analyze(s, undefined_function_calls).\n{ok, [...]}\n```\n\nWe can now continue with further analyses, or we can delete the Xref server:\n\n```erlang\n5> xref:stop(s).\n```\n\nThe check for calls to undefined functions is an example of a predefined\nanalysis, probably the most useful one. Other examples are the analyses that\nfind unused local functions, or functions that call some given functions. See\nthe [analyze/2,3](`xref:analyze/3`) functions for a complete list of predefined\nanalyses.\n\nEach predefined analysis is a shorthand for a [query](`m:xref#query`), a\nsentence of a tiny language providing cross reference data as values of\n[predefined variables](`m:xref#predefined_variable`). The check for calls to\nundefined functions can thus be stated as a query:\n\n```erlang\n4> xref:q(s, \"(XC - UC) || (XU - X - B)\").\n{ok,[...]}\n```\n\nThe query asks for the restriction of external calls except the unresolved calls\nto calls to functions that are externally used but neither exported nor built-in\nfunctions (the `||` operator restricts the used functions while the `|` operator\nrestricts the calling functions). The `-` operator returns the difference of two\nsets, and the `+` operator to be used below returns the union of two sets.\n\nThe relationships between the predefined variables `XU`, `X`, `B` and a few\nothers are worth elaborating upon. The reference manual mentions two ways of\nexpressing the set of all functions, one that focuses on how they are defined:\n`X + L + B + U`, and one that focuses on how they are used: `UU + LU + XU`. The\nreference also mentions some [facts](`m:xref#simple_facts`) about the variables:\n\n- `F` is equal to `L + X` (the defined functions are the local functions and the\n  external functions);\n- `U` is a subset of `XU` (the unknown functions are a subset of the externally\n  used functions since the compiler ensures that locally used functions are\n  defined);\n- `B` is a subset of `XU` (calls to built-in functions are always external by\n  definition, and unused built-in functions are ignored);\n- `LU` is a subset of `F` (the locally used functions are either local functions\n  or exported functions, again ensured by the compiler);\n- `UU` is equal to `F - (XU + LU)` (the unused functions are defined functions\n  that are neither used externally nor locally);\n- `UU` is a subset of `F` (the unused functions are defined in analyzed\n  modules).\n\nUsing these facts, the two small circles in the picture below can be combined.\n\n![Definition and use of functions](assets/venn1.gif \"Definition and use of functions\")\n\nIt is often clarifying to mark the variables of a query in such a circle. This\nis illustrated in the picture below for some of the predefined analyses. Note\nthat local functions used by local functions only are not marked in the\n`locals_not_used` circle.[](){: #venn2 }\n\n![Some predefined analyses as subsets of all functions](assets/venn2.gif \"Some predefined analyses as subsets of all functions\")","ref":"xref_chapter.html#predefined-analysis"},{"type":"extras","title":"Expressions - Xref - The Cross Reference Tool","doc":"The module check and the predefined analyses are useful, but limited. Sometimes\nmore flexibility is needed, for instance one might not need to apply a graph\nanalysis on all calls, but some subset will do equally well. That flexibility is\nprovided with a simple language. Below are some expressions of the language with\ncomments, focusing on elements of the language rather than providing useful\nexamples. The analyzed system is assumed to be OTP, so in order to run the\nqueries, first evaluate these calls:\n\n```erlang\nxref:start(s).\nxref:add_release(s, code:root_dir()).\n```\n\n- **`xref:q(s, \"(Fun) xref : Mod\").`** - All functions of the `xref` module.\n\n- **`xref:q(s, \"xref : Mod * X\").`** - All exported functions of the `xref`\n  module. The first operand of the intersection operator `*` is implicitly\n  converted to the more special type of the second operand.\n\n- **`xref:q(s, \"(Mod) tools\").`** - All modules of the Tools application.\n\n- **`xref:q(s, '\"xref_.*\" : Mod').`** - All modules with a name beginning with\n  `xref_`.\n\n- **`xref:q(s, \"# E | X \").`** - Number of calls from exported functions.\n\n- **`xref:q(s, \"XC || L \").`** - All external calls to local functions.\n\n- **`xref:q(s, \"XC * LC\").`** - All calls that have both an external and a local\n  version.\n\n- **`xref:q(s, \"(LLin) (LC * XC)\").`** - The lines where the local calls of the\n  last example are made.\n\n- **`xref:q(s, \"(XLin) (LC * XC)\").`** - The lines where the external calls of\n  the example before last are made.\n\n- **`xref:q(s, \"XC * (ME - strict ME)\").`** - External calls within some module.\n\n- **`xref:q(s, \"E ||| kernel\").`** - All calls within the Kernel application.\n\n- **`xref:q(s, \"closure E | kernel || kernel\").`** - All direct and indirect\n  calls within the Kernel application. Both the calling and the used functions\n  of indirect calls are defined in modules of the kernel application, but it is\n  possible that some functions outside the kernel application are used by\n  indirect calls.\n\n- **`xref:q(s, \"{toolbar,debugger}:Mod of ME\").`** - A chain of module calls\n  from `toolbar` to `debugger`, if there is such a chain, otherwise `false`. The\n  chain of calls is represented by a list of modules, `toolbar` being the first\n  element and `debugger`the last element.\n\n- **`xref:q(s, \"closure E | toolbar:Mod || debugger:Mod\").`** - All (in)direct\n  calls from functions in `toolbar` to functions in `debugger`.\n\n- **`xref:q(s, \"(Fun) xref -> xref_base\").`** - All function calls from `xref`\n  to `xref_base`.\n\n- **`xref:q(s, \"E * xref -> xref_base\").`** - Same interpretation as last\n  expression.\n\n- **`xref:q(s, \"E || xref_base | xref\").`** - Same interpretation as last\n  expression.\n\n- **`xref:q(s, \"E * [xref -> lists, xref_base -> digraph]\").`** - All function\n  calls from `xref` to `lists`, and all function calls from `xref_base` to\n  `digraph`.\n\n- **`xref:q(s, \"E | [xref, xref_base] || [lists, digraph]\").`** - All function\n  calls from `xref` and `xref_base` to `lists` and `digraph`.\n\n- **`xref:q(s, \"components EE\").`** - All strongly connected components of the\n  Inter Call Graph. Each component is a set of exported or unused local\n  functions that call each other (in)directly.\n\n- **`xref:q(s, \"X * digraph * range (closure (E | digraph) | (L * digraph))\").`** -\n  All exported functions of the `digraph` module used (in)directly by some\n  function in `digraph`.\n\n- **`xref:q(s, \"L * yeccparser:Mod - range (closure (E |`**\n\n- **`yeccparser:Mod) | (X * yeccparser:Mod))\").`** - The interpretation is left\n  as an exercise.","ref":"xref_chapter.html#expressions"},{"type":"extras","title":"Graph Analysis - Xref - The Cross Reference Tool","doc":"The list [representation of graphs](`m:xref#representation`) is used analyzing\ndirect calls, while the `digraph` representation is suited for analyzing\nindirect calls. The restriction operators (`|`, `||` and `|||`) are the only\noperators that accept both representations. This means that in order to analyze\nindirect calls using restriction, the `closure` operator (which creates the\n`digraph` representation of graphs) has to be explicitly applied.\n\nAs an example of analyzing indirect calls, the following Erlang function tries\nto answer the question: if we want to know which modules are used indirectly by\nsome module(s), is it worth while using the\n[function graph](`m:xref#call_graph`) rather than the module graph? Recall that\na module M1 is said to call a module M2 if there is some function in M1 that\ncalls some function in M2. It would be nice if we could use the much smaller\nmodule graph, since it is available also in the light weight\n`modules`[mode](`m:xref#mode`) of Xref servers.\n\n```erlang\nt(S) ->\n  {ok, _} = xref:q(S, \"Eplus := closure E\"),\n  {ok, Ms} = xref:q(S, \"AM\"),\n  Fun = fun(M, N) ->\n      Q = io_lib:format(\"# (Mod) (Eplus | ~p : Mod)\", [M]),\n      {ok, N0} = xref:q(S, lists:flatten(Q)),\n      N + N0\n    end,\n  Sum = lists:foldl(Fun, 0, Ms),\n  ok = xref:forget(S, 'Eplus'),\n  {ok, Tot} = xref:q(S, \"# (closure ME | AM)\"),\n  100 * ((Tot - Sum) / Tot).\n```\n\nComments on the code:\n\n- We want to find the reduction of the closure of the function graph to modules.\n  The direct expression for doing that would be `(Mod) (closure E | AM)`, but\n  then we would have to represent all of the transitive closure of E in memory.\n  Instead the number of indirectly used modules is found for each analyzed\n  module, and the sum over all modules is calculated.\n- A user variable is employed for holding the `digraph` representation of the\n  function graph for use in many queries. The reason is efficiency. As opposed\n  to the `=` operator, the `:=` operator saves a value for subsequent analyses.\n  Here might be the place to note that equal subexpressions within a query are\n  evaluated only once; `=` cannot be used for speeding things up.\n- `Eplus | ~p : Mod`. The `|` operator converts the second operand to the type\n  of the first operand. In this case the module is converted to all functions of\n  the module. It is necessary to assign a type to the module (`: Mod`),\n  otherwise modules like `kernel` would be converted to all functions of the\n  application with the same name; the most general constant is used in cases of\n  ambiguity.\n- Since we are only interested in a ratio, the unary operator `#` that counts\n  the elements of the operand is used. It cannot be applied to the `digraph`\n  representation of graphs.\n- We could find the size of the closure of the module graph with a loop similar\n  to one used for the function graph, but since the module graph is so much\n  smaller, a more direct method is feasible.\n\nWhen the Erlang function `t/1` was applied to an Xref server loaded with the\ncurrent version of OTP, the returned value was close to 84 (percent). This means\nthat the number of indirectly used modules is approximately six times greater\nwhen using the module graph. So the answer to the above stated question is that\nit is definitely worth while using the function graph for this particular\nanalysis. Finally, note that in the presence of unresolved calls, the graphs may\nbe incomplete, which means that there may be indirectly used modules that do not\nshow up.","ref":"xref_chapter.html#graph-analysis"},{"type":"extras","title":"Erlang mode for Emacs","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# Erlang mode for Emacs\n\nPossibly the most important feature of an editor designed for programmers is the\nability to indent a line of code in accordance with the structure of the\nprogramming language. The Erlang mode does, of course, provide this feature. The\nlayout used is based on the common use of the language. The mode also provides\nthings as syntax highlighting, electric commands, module name verification,\ncomment support including paragraph filling, skeletons, tags support etc.\n\nIn the following descriptions the use of the word _Point_ means: \"Point can be\nseen as the position of the cursor. More precisely, the point is the position\nbetween two characters while the cursor is drawn over the character following\nthe point\".","ref":"erlang-el.html"},{"type":"extras","title":"Indent - Erlang mode for Emacs","doc":"The following command are directly available for indentation.\n\n-   _`TAB`_ (`erlang-indent-command`) - Indents the current line of code.\n-   _`M-C-\\`_ (`indent-region`) - Indents all lines in the region.\n-   _`M-l`_ (`indent-for-comment`) - Insert a comment character to the right of\n    the code on the line (if any).\n\nLines containing comment are indented differently depending on the number of\n%-characters used:\n\n-   Lines with one %-character is indented to the right of the code. The column\n    is specified by the variable `comment-column`, by default column 48 is used.\n-   Lines with two %-characters will be indented to the same depth as code would\n    have been in the same situation.\n-   Lines with three of more %-characters are indented to the left margin.\n-   _`C-c C-q`_ (`erlang-indent-function`) - Indents the current Erlang\n    function.\n-   _`M-x erlang-indent-clause RET`_ - Indent the current Erlang clause.\n-   _`M-x erlang-indent-current-buffer RET`_ - Indent the entire buffer.","ref":"erlang-el.html#indent"},{"type":"extras","title":"Edit - Fill Comment - Erlang mode for Emacs","doc":"When editing normal text in text mode you can let Emacs reformat the text by the\n`fill-paragraph` command. This command will not work for comments since it will\ntreat the comment characters as words. The Erlang editing mode provides a\ncommand that knows about the Erlang comment structure and can be used to fill\ntext paragraphs in comments. Ex:\n\n```erlang\n%% This is   just a very simple test to show\n%% how the Erlang fill\n%% paragraph   command works.\n```\n\nClearly, the text is badly formatted. Instead of formatting this paragraph line\nby line, let's try `erlang-fill-paragraph` by pressing _`M-q`_. The result is:\n\n```erlang\n%% This is just a very simple test to show how the Erlang fill\n%% paragraph command works.\n```","ref":"erlang-el.html#edit-fill-comment"},{"type":"extras","title":"Edit - Comment/Uncomment Region - Erlang mode for Emacs","doc":"_`C-c C-c`_ will put comment characters at the beginning of all lines in a\nmarked region. If you want to have two comment characters instead of one you can\ndo _`C-u 2 C-c C-c`_\n\n_`C-c C-u`_ will undo a comment-region command.","ref":"erlang-el.html#edit-comment-uncomment-region"},{"type":"extras","title":"Edit - Moving the point - Erlang mode for Emacs","doc":"-   _`M-C-a`_ (`erlang-beginning-of-function`) - Move the point to the beginning\n    of the current or preceding Erlang function. With an numeric argument (ex\n    _`C-u 2 M-C-a`_) the function skips backwards over this many Erlang\n    functions. Should the argument be negative the point is moved to the\n    beginning of a function below the current function.\n-   _`C-c M-a`_ (`erlang-beginning-of-clause`) - As above but move point to the\n    beginning of the current or preceding Erlang clause.\n-   _`M-C-e`_ (`erlang-end-of-function`) - Move to the end of the current or\n    following Erlang function. With an numeric argument (ex _`C-u 2 M-C-e`_) the\n    function skips backwards over this many Erlang functions. Should the\n    argument be negative the point is moved to the end of a function below the\n    current function.\n-   _`C-c M-e`_ (`erlang-end-of-clause`) - As above but move point to the end of\n    the current or following Erlang clause.","ref":"erlang-el.html#edit-moving-the-point"},{"type":"extras","title":"Edit - Marking - Erlang mode for Emacs","doc":"-   _`M-C-h`_ (`erlang-mark-function`) - Put the region around the current\n    Erlang function. The point is placed in the beginning and the mark at the\n    end of the function.\n-   _`C-c M-h`_ (`erlang-mark-clause`) Put the region around the current Erlang\n    clause. The point is placed in the beginning and the mark at the end of the\n    function.","ref":"erlang-el.html#edit-marking"},{"type":"extras","title":"Edit - Function Header Commands - Erlang mode for Emacs","doc":"-   _`C-c C-j`_ (`erlang-generate-new-clause`) - Create a new clause in the\n    current Erlang function. The point is placed between the parentheses of the\n    argument list.\n-   _`C-c C-y`_ (`erlang-clone-arguments`) - Copy the function arguments of the\n    preceding Erlang clause. This command is useful when defining a new clause\n    with almost the same argument as the preceding.","ref":"erlang-el.html#edit-function-header-commands"},{"type":"extras","title":"Edit - Alignment - Erlang mode for Emacs","doc":"-   _`C-c C-a`_ (`align-current`) - aligns comments, arrows, assignments,\n    and type annotations around the cursor.\n\n```erlang\nExample:\n\nsum(L) -> sum(L, 0).\nsum([H|T], Sum) -> sum(T, Sum + H);  % recurse\nsum([], Sum) -> Sum.   % base case\n\n-record { two :: int(), % hello\n          three = hello :: string(),    % there\n          four = 42 :: int() }.\n\nbecomes:\n\nsum(L) -> sum(L, 0).\nsum([H|T], Sum) -> sum(T, Sum + H); % recurse\nsum([], Sum)    -> Sum.             % base case\n\n-record { two           :: int(),    % hello\n          three = hello :: string(), % there\n          four  = 42    :: int() }.\n```","ref":"erlang-el.html#edit-alignment"},{"type":"extras","title":"Syntax highlighting - Erlang mode for Emacs","doc":"The syntax highlighting can be activated from the Erlang menu. There are four\ndifferent alternatives:\n\n-   Off: Normal black and white display.\n-   Level 1: Function headers, reserved words, comments, strings, quoted atoms,\n    and character constants will be colored.\n-   Level 2: The above, attributes, Erlang bif:s, guards, and words in comments\n    enclosed in single quotes will be colored.\n-   Level 3: The above, variables, records, and macros will be colored. (This\n    level is also known as the Christmas tree level.)","ref":"erlang-el.html#syntax-highlighting"},{"type":"extras","title":"Tags - Erlang mode for Emacs","doc":"For the tag commands to work it requires that you have generated a tag file. See\n[Erlang mode users guide](erlang_mode_chapter.md#tags)\n\n-   _`M-.`_ (`find-tag`) - Find a function definition. The default value is the\n    function name under the point.\n-   Find Tag (`erlang-find-tag`) - Like the Elisp-function\n    `find-tag'. Capable of retrieving Erlang modules. Tags can be given of the forms `tag',\n    `module:', `module:tag'.\n-   _`M-+`_ (`erlang-find-next-tag`) - Find the next occurrence of tag.\n-   _`M-TAB`_ (`erlang-complete-tag`) - Perform completion on the tag entered in\n    a tag search. Completes to the set of names listed in the current tags\n    table.\n-   Tags aprops (`tags-apropos`) - Display list of all tags in tags table REGEXP\n    matches.\n-   _`C-x t s`_ (`tags-search`) - Search through all files listed in tags table\n    for match for REGEXP. Stops when a match is found.","ref":"erlang-el.html#tags"},{"type":"extras","title":"Skeletons - Erlang mode for Emacs","doc":"A skeleton is a piece of pre-written code that can be inserted into the buffer.\nErlang mode comes with a set of predefined skeletons. The skeletons can be\naccessed either from the Erlang menu of from commands named\n`tempo-template-erlang-*`, as the skeletons is defined using the standard Emacs\npackage \"tempo\". Here follows a brief description of the available skeletons:\n\n-   Simple skeletons: If, Case, Receive, Receive After, Receive Loop - Basic\n    code constructs.\n-   Header elements: Module, Author - These commands insert lines on the form\n    `-module('xxx').` and `-author('my@home').`. They can be used directly, but\n    are also used as part of the full headers described below.\n-   Full Headers: Small (minimum requirement), Medium (with fields for basic\n    information about the module), and Large Header (medium header with some\n    extra layout structure).\n-   Small Server - skeleton for a simple server not using OTP.\n-   Application - skeletons for the OTP application behavior\n-   Supervisor - skeleton for the OTP supervisor behavior\n-   Supervisor Bridge - skeleton for the OTP supervisor bridge behavior\n-   gen_server - skeleton for the OTP gen_server behavior\n-   gen_event - skeleton for the OTP gen_event behavior\n-   gen_fsm - skeleton for the OTP gen_fsm behavior\n-   gen_statem (StateName/3) - skeleton for the OTP gen_statem behavior using\n    state name functions\n-   gen_statem (handle_event/4) - skeleton for the OTP gen_statem behavior using\n    one state function\n-   Library module - skeleton for a module that does not implement a process.\n-   Corba callback - skeleton for a Corba callback module.\n-   Erlang test suite - skeleton for a callback module for the erlang test\n    server.","ref":"erlang-el.html#skeletons"},{"type":"extras","title":"Shell - Erlang mode for Emacs","doc":"-   New shell (`erlang-shell`) - Starts a new Erlang shell.\n-   _`C-c C-z,`_ (`erlang-shell-display `) - Displays an Erlang shell, or starts\n    a new one if there is no shell started.","ref":"erlang-el.html#shell"},{"type":"extras","title":"Compile - Erlang mode for Emacs","doc":"-   _`C-c C-k,`_ (`erlang-compile`) - Compiles the Erlang module in the current\n    buffer. You can also use _`C-u C-c C-k`_ to debug compile the module with\n    the debug options `debug_info` and `export_all`.\n-   _`C-c C-l,`_ (`erlang-compile-display`) - Display compilation output.\n-   _``C-u C-x` ``_ Start parsing the compiler output from the beginning. This\n    command will place the point on the line where the first error was found.\n-   _`` C-x` ``_ (`erlang-next-error`) - Move the point on to the next error.\n    The buffer displaying the compilation errors will be updated so that the\n    current error will be visible.","ref":"erlang-el.html#compile"},{"type":"extras","title":"Man - Erlang mode for Emacs","doc":"On unix you can view the manual pages in emacs. In order to find the manual\npages, the variable `erlang-root-dir` should be bound to the name of the\ndirectory containing the Erlang installation. The name should not include the\nfinal slash. Practically, you should add a line on the following form to your\n~/.emacs,\n\n```text\n(setq erlang-root-dir \"/the/erlang/root/dir/goes/here\")\n```","ref":"erlang-el.html#man"},{"type":"extras","title":"Starting IMenu - Erlang mode for Emacs","doc":"-   _`M-x imenu-add-to-menubar RET`_ - This command will create the IMenu menu\n    containing all the functions in the current buffer.The command will ask you\n    for a suitable name for the menu. Not supported by Xemacs.","ref":"erlang-el.html#starting-imenu"},{"type":"extras","title":"Version - Erlang mode for Emacs","doc":"-   _`M-x erlang-version RET`_ - This command displays the version number of the\n    Erlang editing mode. Remember to always supply the version number when\n    asking questions about the Erlang mode.","ref":"erlang-el.html#version"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}