;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; REQUIRES: llvm-16-plus, regkeys
; RUN: llvm-as -opaque-pointers=1 < %s -o %t.bc
; RUN: ocloc compile -llvm_input -file %t.bc -device bmg -options "-igc_opts 'VectorizerAllowWAVEALLJoint=1, PrintToConsole=1, PrintAfter=IGCVectorizer, EnableOpaquePointersBackend=1'" &> %t_output.ll
; RUN: FileCheck --input-file %t_output.ll %s

; CHECK: %vectorized_joint_waveall = call <8 x float> @llvm.genx.GenISA.WaveAll.v8f32(<8 x float>

; ModuleID = 'reduced.ll'
source_filename = "initial_waveall.ll"
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v24:32:32-v32:32:32-v48:64:64-v64:64:64-v96:128:128-v128:128:128-v192:256:256-v256:256:256-v512:512:512-v1024:1024:1024"
target triple = "spir64-unknown-unknown"

; Function Attrs: nounwind
define spir_kernel void @foo(ptr addrspace(1) %0, ptr addrspace(1) %1, ptr addrspace(1) %2, ptr addrspace(1) nocapture %3, ptr addrspace(1) nocapture readonly %4, ptr addrspace(1) nocapture readonly %5, ptr addrspace(1) nocapture readonly %6, ptr addrspace(1) nocapture readonly %7, ptr addrspace(1) %8) #0 !intel_reqd_sub_group_size !0 {
.lr.ph:
  %9 = call spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32 0) #2
  %10 = insertelement <3 x i64> undef, i64 %9, i32 0
  %11 = call spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32 1) #2
  %12 = insertelement <3 x i64> %10, i64 %11, i32 1
  %13 = call spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32 2) #2
  %14 = insertelement <3 x i64> %12, i64 %13, i32 2
  %15 = extractelement <3 x i64> %14, i32 0
  %16 = select i1 true, i64 %15, i64 0
  %17 = trunc i64 %16 to i32
  %18 = call spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32 0) #2
  %19 = insertelement <3 x i64> undef, i64 %18, i32 0
  %20 = call spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32 1) #2
  %21 = insertelement <3 x i64> %19, i64 %20, i32 1
  %22 = call spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32 2) #2
  %23 = insertelement <3 x i64> %21, i64 %22, i32 2
  %24 = extractelement <3 x i64> %23, i32 1
  %25 = select i1 true, i64 %24, i64 0
  %26 = trunc i64 %25 to i32
  %27 = sdiv i32 %26, 32
  %28 = mul i32 %27, 32
  %.decomposed = sub i32 %26, %28
  %.lhs.trunc = trunc i32 %.decomposed to i8
  %29 = sdiv i8 %.lhs.trunc, 4
  %.sext = sext i8 %29 to i32
  %30 = shl i32 %27, 22
  %31 = shl nsw i32 %.decomposed, 17
  %32 = add i32 %30, %31
  %33 = shl nsw i32 %.sext, 17
  %34 = sext i32 %32 to i64
  %35 = getelementptr half, ptr addrspace(1) %0, i64 %34
  %36 = sext i32 %33 to i64
  %37 = getelementptr half, ptr addrspace(1) %1, i64 %36
  %38 = getelementptr half, ptr addrspace(1) %2, i64 %36
  %39 = shl i32 %17, 7
  %40 = call spir_func i64 @_Z32__spirv_BuiltInLocalInvocationIdi(i32 0) #2
  %41 = insertelement <3 x i64> undef, i64 %40, i32 0
  %42 = call spir_func i64 @_Z32__spirv_BuiltInLocalInvocationIdi(i32 1) #2
  %43 = insertelement <3 x i64> %41, i64 %42, i32 1
  %44 = call spir_func i64 @_Z32__spirv_BuiltInLocalInvocationIdi(i32 2) #2
  %45 = insertelement <3 x i64> %43, i64 %44, i32 2
  %46 = extractelement <3 x i64> %45, i32 0
  %47 = select i1 true, i64 %46, i64 0
  %48 = trunc i64 %47 to i32
  %49 = lshr i32 %48, 1
  %50 = and i32 %49, 120
  %51 = or i32 %50, %39
  %52 = or i32 %51, 1
  %53 = or i32 %51, 2
  %54 = or i32 %51, 3
  %55 = or i32 %51, 4
  %56 = or i32 %51, 5
  %57 = or i32 %51, 6
  %58 = or i32 %51, 7
  %59 = shl i32 %17, 3
  %60 = call spir_func i32 null() #2
  %61 = shl i32 %60, 5
  %62 = and i32 %61, 96
  %63 = shl i32 %60, 3
  %64 = and i32 %63, 96
  %65 = or i32 %64, %39
  %66 = ptrtoint ptr addrspace(1) %35 to i64
  %67 = and i64 %66, -64
  %68 = inttoptr i64 %67 to ptr addrspace(1)
  %69 = trunc i64 %66 to i32
  %70 = and i32 %69, 63
  %71 = or i32 %70, 256
  %72 = lshr i32 %70, 1
  %73 = or i32 %72, %62
  %74 = insertelement <2 x i32> undef, i32 %73, i32 0
  %75 = insertelement <2 x i32> %74, i32 %65, i32 1
  %76 = getelementptr i8, ptr addrspace(1) %68, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %76, i32 %71, i32 1024, i32 256, <2 x i32> %75) #0
  %77 = sext i32 %59 to i64
  %78 = getelementptr i32, ptr addrspace(1) %5, i64 %77
  %79 = load i32, ptr addrspace(1) %78, align 4
  %80 = shl i32 %79, 7
  %sext = shl i64 %16, 32
  %81 = ashr i64 %sext, 30
  %82 = getelementptr i8, ptr addrspace(1) %4, i64 %81
  %83 = bitcast ptr addrspace(1) %82 to ptr addrspace(1)
  %84 = load i32, ptr addrspace(1) %83, align 4
  %85 = shl i32 %84, 1
  %86 = and i32 %48, 15
  %87 = or i32 %86, 16
  %88 = or i32 %86, 32
  %89 = or i32 %86, 48
  %90 = call spir_func i32 null() #2
  %91 = shl i32 %90, 5
  %92 = and i32 %91, 96
  %93 = or i32 %92, %80
  %94 = shl i32 %90, 2
  %95 = and i32 %94, 48
  %96 = ptrtoint ptr addrspace(1) %37 to i64
  %97 = and i64 %96, -64
  %98 = inttoptr i64 %97 to ptr addrspace(1)
  %99 = trunc i64 %96 to i32
  %100 = and i32 %99, 63
  %101 = or i32 %100, 256
  %102 = lshr i32 %100, 1
  %103 = or i32 %93, %102
  %104 = insertelement <2 x i32> undef, i32 %103, i32 0
  %105 = insertelement <2 x i32> %104, i32 %95, i32 1
  %106 = getelementptr i8, ptr addrspace(1) %98, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %106, i32 %101, i32 1024, i32 256, <2 x i32> %105) #0
  %107 = call spir_func i32 null() #2
  %108 = shl i32 %107, 5
  %109 = and i32 %108, 96
  %110 = shl i32 %107, 2
  %111 = and i32 %110, 48
  %112 = or i32 %111, %80
  %113 = ptrtoint ptr addrspace(1) %38 to i64
  %114 = and i64 %113, -64
  %115 = inttoptr i64 %114 to ptr addrspace(1)
  %116 = trunc i64 %113 to i32
  %117 = and i32 %116, 63
  %118 = or i32 %117, 256
  %119 = lshr i32 %117, 1
  %120 = or i32 %119, %109
  %121 = insertelement <2 x i32> undef, i32 %120, i32 0
  %122 = insertelement <2 x i32> %121, i32 %112, i32 1
  %123 = getelementptr i8, ptr addrspace(1) %115, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %123, i32 %118, i32 1024, i32 256, <2 x i32> %122) #0
  %124 = icmp sgt i32 %85, 0
  %125 = or i32 %80, %89
  %126 = or i32 %80, %88
  %127 = or i32 %80, %87
  %128 = or i32 %80, %86
  %129 = lshr i32 %100, 2
  %130 = insertelement <2 x i32> undef, i32 %129, i32 0
  %131 = add nuw nsw i32 %129, 8
  %132 = insertelement <2 x i32> undef, i32 %131, i32 0
  %133 = or i32 %129, 16
  %134 = insertelement <2 x i32> undef, i32 %133, i32 0
  %135 = add nuw nsw i32 %129, 24
  %136 = insertelement <2 x i32> undef, i32 %135, i32 0
  %137 = or i32 %129, 32
  %138 = insertelement <2 x i32> undef, i32 %137, i32 0
  %139 = add nuw nsw i32 %129, 40
  %140 = insertelement <2 x i32> undef, i32 %139, i32 0
  %141 = or i32 %129, 48
  %142 = insertelement <2 x i32> undef, i32 %141, i32 0
  %143 = add nuw nsw i32 %129, 56
  %144 = insertelement <2 x i32> undef, i32 %143, i32 0
  %145 = insertelement <2 x i32> undef, i32 %119, i32 0
  %146 = or i32 %119, 32
  %147 = insertelement <2 x i32> undef, i32 %146, i32 0
  %148 = or i32 %119, 64
  %149 = insertelement <2 x i32> undef, i32 %148, i32 0
  %150 = or i32 %119, 96
  %151 = insertelement <2 x i32> undef, i32 %150, i32 0
  %152 = insertelement <2 x i32> undef, i32 %72, i32 0
  %153 = or i32 %72, 32
  %154 = insertelement <2 x i32> undef, i32 %153, i32 0
  %155 = or i32 %72, 64
  %156 = insertelement <2 x i32> undef, i32 %155, i32 0
  %157 = or i32 %72, 96
  %158 = insertelement <2 x i32> undef, i32 %157, i32 0
  %159 = icmp ult i32 %85, 16
  %160 = select i1 %159, i32 %85, i32 16
  %161 = alloca [16 x i32], align 4
  %162 = alloca [16 x i32], align 4
  %163 = alloca [16 x i32], align 4
  %164 = alloca [16 x i32], align 4
  %165 = alloca [16 x i32], align 4
  %166 = alloca [16 x i32], align 4
  %167 = alloca [16 x i32], align 4
  %168 = alloca [16 x i32], align 4
  %169 = alloca [16 x i32], align 4
  %170 = alloca [16 x i32], align 4
  %171 = alloca [16 x i32], align 4
  %172 = alloca [16 x i32], align 4
  %173 = alloca [16 x i32], align 4
  %174 = alloca [16 x i32], align 4
  %175 = alloca [16 x i32], align 4
  %176 = alloca [16 x i32], align 4
  %177 = alloca [32 x i32], align 4
  %178 = alloca [32 x i32], align 4
  %179 = alloca [32 x i32], align 4
  %180 = alloca [32 x i32], align 4
  %181 = alloca [32 x i32], align 4
  %182 = alloca [32 x i32], align 4
  %183 = alloca [32 x i32], align 4
  %184 = alloca [32 x i32], align 4
  %185 = alloca [16 x i16], align 2
  %186 = alloca [16 x i16], align 2
  %187 = alloca [16 x i16], align 2
  %188 = alloca [16 x i16], align 2
  %189 = add i32 %80, 64
  %190 = call spir_func i32 null() #2
  %191 = shl i32 %190, 5
  %192 = and i32 %191, 96
  %193 = add i32 %192, %189
  %194 = shl i32 %190, 2
  %195 = and i32 %194, 48
  %196 = or i32 %193, %102
  %197 = insertelement <2 x i32> undef, i32 %196, i32 0
  %198 = insertelement <2 x i32> %197, i32 %195, i32 1
  %199 = getelementptr i8, ptr addrspace(1) %98, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %199, i32 %101, i32 1024, i32 256, <2 x i32> %198) #0
  %200 = call spir_func i32 null() #2
  %201 = shl i32 %200, 5
  %202 = and i32 %201, 96
  %203 = shl i32 %200, 2
  %204 = and i32 %203, 48
  %205 = or i32 %204, %189
  %206 = or i32 %202, %119
  %207 = insertelement <2 x i32> undef, i32 %206, i32 0
  %208 = insertelement <2 x i32> %207, i32 %205, i32 1
  %209 = getelementptr i8, ptr addrspace(1) %115, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %209, i32 %118, i32 1024, i32 256, <2 x i32> %208) #0
  %210 = call spir_func i32 null() #2
  %211 = insertelement <2 x i32> %130, i32 %80, i32 1
  %212 = bitcast ptr %161 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %211, ptr %212) #0
  %213 = bitcast ptr %161 to ptr
  %214 = load <16 x i32>, ptr %213, align 64
  %215 = shufflevector <16 x i32> %214, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %216 = shufflevector <16 x i32> %214, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %217 = insertelement <2 x i32> %132, i32 %80, i32 1
  %218 = bitcast ptr %162 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %217, ptr %218) #0
  %219 = bitcast ptr %162 to ptr
  %220 = load <16 x i32>, ptr %219, align 64
  %221 = shufflevector <16 x i32> %220, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %222 = shufflevector <16 x i32> %220, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %223 = insertelement <2 x i32> %134, i32 %80, i32 1
  %224 = bitcast ptr %163 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %223, ptr %224) #0
  %225 = bitcast ptr %163 to ptr
  %226 = load <16 x i32>, ptr %225, align 64
  %227 = shufflevector <16 x i32> %226, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %228 = shufflevector <16 x i32> %226, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %229 = insertelement <2 x i32> %136, i32 %80, i32 1
  %230 = bitcast ptr %164 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %229, ptr %230) #0
  %231 = bitcast ptr %164 to ptr
  %232 = load <16 x i32>, ptr %231, align 64
  %233 = shufflevector <16 x i32> %232, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %234 = shufflevector <16 x i32> %232, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %235 = insertelement <2 x i32> %138, i32 %80, i32 1
  %236 = bitcast ptr %165 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %235, ptr %236) #0
  %237 = bitcast ptr %165 to ptr
  %238 = load <16 x i32>, ptr %237, align 64
  %239 = shufflevector <16 x i32> %238, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %240 = shufflevector <16 x i32> %238, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %241 = insertelement <2 x i32> %140, i32 %80, i32 1
  %242 = bitcast ptr %166 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %241, ptr %242) #0
  %243 = bitcast ptr %166 to ptr
  %244 = load <16 x i32>, ptr %243, align 64
  %245 = shufflevector <16 x i32> %244, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %246 = shufflevector <16 x i32> %244, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %247 = insertelement <2 x i32> %142, i32 %80, i32 1
  %248 = bitcast ptr %167 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %247, ptr %248) #0
  %249 = bitcast ptr %167 to ptr
  %250 = load <16 x i32>, ptr %249, align 64
  %251 = shufflevector <16 x i32> %250, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %252 = shufflevector <16 x i32> %250, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %253 = insertelement <2 x i32> %144, i32 %80, i32 1
  %254 = bitcast ptr %168 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %253, ptr %254) #0
  %255 = bitcast ptr %168 to ptr
  %256 = load <16 x i32>, ptr %255, align 64
  %257 = shufflevector <16 x i32> %256, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %258 = shufflevector <16 x i32> %256, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %259 = or i32 %80, 32
  %260 = insertelement <2 x i32> %130, i32 %259, i32 1
  %261 = bitcast ptr %169 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %260, ptr %261) #0
  %262 = bitcast ptr %169 to ptr
  %263 = load <16 x i32>, ptr %262, align 64
  %264 = shufflevector <16 x i32> %263, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %265 = shufflevector <16 x i32> %263, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %266 = insertelement <2 x i32> %132, i32 %259, i32 1
  %267 = bitcast ptr %170 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %266, ptr %267) #0
  %268 = bitcast ptr %170 to ptr
  %269 = load <16 x i32>, ptr %268, align 64
  %270 = shufflevector <16 x i32> %269, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %271 = shufflevector <16 x i32> %269, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %272 = insertelement <2 x i32> %134, i32 %259, i32 1
  %273 = bitcast ptr %171 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %272, ptr %273) #0
  %274 = bitcast ptr %171 to ptr
  %275 = load <16 x i32>, ptr %274, align 64
  %276 = shufflevector <16 x i32> %275, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %277 = shufflevector <16 x i32> %275, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %278 = insertelement <2 x i32> %136, i32 %259, i32 1
  %279 = bitcast ptr %172 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %278, ptr %279) #0
  %280 = bitcast ptr %172 to ptr
  %281 = load <16 x i32>, ptr %280, align 64
  %282 = shufflevector <16 x i32> %281, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %283 = shufflevector <16 x i32> %281, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %284 = insertelement <2 x i32> %138, i32 %259, i32 1
  %285 = bitcast ptr %173 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %284, ptr %285) #0
  %286 = bitcast ptr %173 to ptr
  %287 = load <16 x i32>, ptr %286, align 64
  %288 = shufflevector <16 x i32> %287, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %289 = shufflevector <16 x i32> %287, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %290 = insertelement <2 x i32> %140, i32 %259, i32 1
  %291 = bitcast ptr %174 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %290, ptr %291) #0
  %292 = bitcast ptr %174 to ptr
  %293 = load <16 x i32>, ptr %292, align 64
  %294 = shufflevector <16 x i32> %293, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %295 = shufflevector <16 x i32> %293, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %296 = insertelement <2 x i32> %142, i32 %259, i32 1
  %297 = bitcast ptr %175 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %296, ptr %297) #0
  %298 = bitcast ptr %175 to ptr
  %299 = load <16 x i32>, ptr %298, align 64
  %300 = shufflevector <16 x i32> %299, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %301 = shufflevector <16 x i32> %299, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %302 = insertelement <2 x i32> %144, i32 %259, i32 1
  %303 = bitcast ptr %176 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %302, ptr %303) #0
  %304 = bitcast ptr %176 to ptr
  %305 = load <16 x i32>, ptr %304, align 64
  %306 = shufflevector <16 x i32> %305, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %307 = shufflevector <16 x i32> %305, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %308 = call spir_func i32 null() #2
  %309 = insertelement <2 x i32> %145, i32 %80, i32 1
  %310 = bitcast ptr %177 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %309, ptr %310) #0
  %311 = bitcast ptr %177 to ptr
  %312 = load <32 x i32>, ptr %311, align 128
  %313 = shufflevector <32 x i32> %312, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %314 = shufflevector <32 x i32> %312, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %315 = shufflevector <32 x i32> %312, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %316 = shufflevector <32 x i32> %312, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %317 = insertelement <2 x i32> %145, i32 %259, i32 1
  %318 = bitcast ptr %178 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %317, ptr %318) #0
  %319 = bitcast ptr %178 to ptr
  %320 = load <32 x i32>, ptr %319, align 128
  %321 = shufflevector <32 x i32> %320, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %322 = shufflevector <32 x i32> %320, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %323 = shufflevector <32 x i32> %320, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %324 = shufflevector <32 x i32> %320, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %325 = insertelement <2 x i32> %147, i32 %80, i32 1
  %326 = bitcast ptr %179 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %325, ptr %326) #0
  %327 = bitcast ptr %179 to ptr
  %328 = load <32 x i32>, ptr %327, align 128
  %329 = shufflevector <32 x i32> %328, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %330 = shufflevector <32 x i32> %328, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %331 = shufflevector <32 x i32> %328, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %332 = shufflevector <32 x i32> %328, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %333 = insertelement <2 x i32> %147, i32 %259, i32 1
  %334 = bitcast ptr %180 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %333, ptr %334) #0
  %335 = bitcast ptr %180 to ptr
  %336 = load <32 x i32>, ptr %335, align 128
  %337 = shufflevector <32 x i32> %336, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %338 = shufflevector <32 x i32> %336, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %339 = shufflevector <32 x i32> %336, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %340 = shufflevector <32 x i32> %336, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %341 = insertelement <2 x i32> %149, i32 %80, i32 1
  %342 = bitcast ptr %181 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %341, ptr %342) #0
  %343 = bitcast ptr %181 to ptr
  %344 = load <32 x i32>, ptr %343, align 128
  %345 = shufflevector <32 x i32> %344, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %346 = shufflevector <32 x i32> %344, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %347 = shufflevector <32 x i32> %344, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %348 = shufflevector <32 x i32> %344, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %349 = insertelement <2 x i32> %149, i32 %259, i32 1
  %350 = bitcast ptr %182 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %349, ptr %350) #0
  %351 = bitcast ptr %182 to ptr
  %352 = load <32 x i32>, ptr %351, align 128
  %353 = shufflevector <32 x i32> %352, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %354 = shufflevector <32 x i32> %352, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %355 = shufflevector <32 x i32> %352, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %356 = shufflevector <32 x i32> %352, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %357 = insertelement <2 x i32> %151, i32 %80, i32 1
  %358 = bitcast ptr %183 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %357, ptr %358) #0
  %359 = bitcast ptr %183 to ptr
  %360 = load <32 x i32>, ptr %359, align 128
  %361 = shufflevector <32 x i32> %360, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %362 = shufflevector <32 x i32> %360, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %363 = shufflevector <32 x i32> %360, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %364 = shufflevector <32 x i32> %360, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %365 = insertelement <2 x i32> %151, i32 %259, i32 1
  %366 = bitcast ptr %184 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %365, ptr %366) #0
  %367 = bitcast ptr %184 to ptr
  %368 = load <32 x i32>, ptr %367, align 128
  %369 = shufflevector <32 x i32> %368, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %370 = shufflevector <32 x i32> %368, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %371 = shufflevector <32 x i32> %368, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %372 = shufflevector <32 x i32> %368, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %373 = call spir_func i32 null() #2
  %374 = shl i32 %373, 3
  %375 = and i32 %374, 120
  %376 = or i32 %375, %39
  %377 = insertelement <2 x i32> %152, i32 %376, i32 1
  %378 = bitcast ptr %185 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %377, ptr %378) #0
  %379 = bitcast ptr %185 to ptr
  %380 = load <16 x i16>, ptr %379, align 32
  %381 = shufflevector <16 x i16> %380, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %382 = shufflevector <16 x i16> %380, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %383 = insertelement <2 x i32> %154, i32 %376, i32 1
  %384 = bitcast ptr %186 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %383, ptr %384) #0
  %385 = bitcast ptr %186 to ptr
  %386 = load <16 x i16>, ptr %385, align 32
  %387 = shufflevector <16 x i16> %386, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %388 = shufflevector <16 x i16> %386, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %389 = insertelement <2 x i32> %156, i32 %376, i32 1
  %390 = bitcast ptr %187 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %389, ptr %390) #0
  %391 = bitcast ptr %187 to ptr
  %392 = load <16 x i16>, ptr %391, align 32
  %393 = shufflevector <16 x i16> %392, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %394 = shufflevector <16 x i16> %392, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %395 = insertelement <2 x i32> %158, i32 %376, i32 1
  %396 = bitcast ptr %188 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %395, ptr %396) #0
  %397 = bitcast ptr %188 to ptr
  %398 = load <16 x i16>, ptr %397, align 32
  %399 = shufflevector <16 x i16> %398, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %400 = shufflevector <16 x i16> %398, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %401 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %381, <8 x i32> %215, <8 x float> zeroinitializer, i32 3072) #0
  %402 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %381, <8 x i32> %216, <8 x float> zeroinitializer, i32 3072) #0
  %403 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %381, <8 x i32> %264, <8 x float> zeroinitializer, i32 3072) #0
  %404 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %381, <8 x i32> %265, <8 x float> zeroinitializer, i32 3072) #0
  %405 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %382, <8 x i32> %221, <8 x float> %401, i32 3072) #0
  %406 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %382, <8 x i32> %222, <8 x float> %402, i32 3072) #0
  %407 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %382, <8 x i32> %270, <8 x float> %403, i32 3072) #0
  %408 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %382, <8 x i32> %271, <8 x float> %404, i32 3072) #0
  %409 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %387, <8 x i32> %227, <8 x float> %405, i32 3072) #0
  %410 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %387, <8 x i32> %228, <8 x float> %406, i32 3072) #0
  %411 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %387, <8 x i32> %276, <8 x float> %407, i32 3072) #0
  %412 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %387, <8 x i32> %277, <8 x float> %408, i32 3072) #0
  %413 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %388, <8 x i32> %233, <8 x float> %409, i32 3072) #0
  %414 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %388, <8 x i32> %234, <8 x float> %410, i32 3072) #0
  %415 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %388, <8 x i32> %282, <8 x float> %411, i32 3072) #0
  %416 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %388, <8 x i32> %283, <8 x float> %412, i32 3072) #0
  %417 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %393, <8 x i32> %239, <8 x float> %413, i32 3072) #0
  %418 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %393, <8 x i32> %240, <8 x float> %414, i32 3072) #0
  %419 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %393, <8 x i32> %288, <8 x float> %415, i32 3072) #0
  %420 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %393, <8 x i32> %289, <8 x float> %416, i32 3072) #0
  %421 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %394, <8 x i32> %245, <8 x float> %417, i32 3072) #0
  %422 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %394, <8 x i32> %246, <8 x float> %418, i32 3072) #0
  %423 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %394, <8 x i32> %294, <8 x float> %419, i32 3072) #0
  %424 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %394, <8 x i32> %295, <8 x float> %420, i32 3072) #0
  %425 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %399, <8 x i32> %251, <8 x float> %421, i32 3072) #0
  %426 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %399, <8 x i32> %252, <8 x float> %422, i32 3072) #0
  %427 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %399, <8 x i32> %300, <8 x float> %423, i32 3072) #0
  %428 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %399, <8 x i32> %301, <8 x float> %424, i32 3072) #0
  %429 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %400, <8 x i32> %257, <8 x float> %425, i32 3072) #0
  %430 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %400, <8 x i32> %258, <8 x float> %426, i32 3072) #0
  %431 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %400, <8 x i32> %306, <8 x float> %427, i32 3072) #0
  %432 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %400, <8 x i32> %307, <8 x float> %428, i32 3072) #0
  %433 = extractelement <8 x float> %429, i32 0
  %434 = extractelement <8 x float> %429, i32 1
  %435 = extractelement <8 x float> %429, i32 2
  %436 = extractelement <8 x float> %429, i32 3
  %437 = extractelement <8 x float> %429, i32 4
  %438 = extractelement <8 x float> %429, i32 5
  %439 = extractelement <8 x float> %429, i32 6
  %440 = extractelement <8 x float> %429, i32 7
  %441 = extractelement <8 x float> %430, i32 0
  %442 = extractelement <8 x float> %430, i32 1
  %443 = extractelement <8 x float> %430, i32 2
  %444 = extractelement <8 x float> %430, i32 3
  %445 = extractelement <8 x float> %430, i32 4
  %446 = extractelement <8 x float> %430, i32 5
  %447 = extractelement <8 x float> %430, i32 6
  %448 = extractelement <8 x float> %430, i32 7
  %449 = extractelement <8 x float> %431, i32 0
  %450 = extractelement <8 x float> %431, i32 1
  %451 = extractelement <8 x float> %431, i32 2
  %452 = extractelement <8 x float> %431, i32 3
  %453 = extractelement <8 x float> %431, i32 4
  %454 = extractelement <8 x float> %431, i32 5
  %455 = extractelement <8 x float> %431, i32 6
  %456 = extractelement <8 x float> %431, i32 7
  %457 = extractelement <8 x float> %432, i32 0
  %458 = extractelement <8 x float> %432, i32 1
  %459 = extractelement <8 x float> %432, i32 2
  %460 = extractelement <8 x float> %432, i32 3
  %461 = extractelement <8 x float> %432, i32 4
  %462 = extractelement <8 x float> %432, i32 5
  %463 = extractelement <8 x float> %432, i32 6
  %464 = extractelement <8 x float> %432, i32 7
  %465 = fmul contract float %433, 1.250000e-01
  %466 = fmul contract float %434, 1.250000e-01
  %467 = fmul contract float %435, 1.250000e-01
  %468 = fmul contract float %436, 1.250000e-01
  %469 = fmul contract float %437, 1.250000e-01
  %470 = fmul contract float %438, 1.250000e-01
  %471 = fmul contract float %439, 1.250000e-01
  %472 = fmul contract float %440, 1.250000e-01
  %473 = fmul contract float %441, 1.250000e-01
  %474 = fmul contract float %442, 1.250000e-01
  %475 = fmul contract float %443, 1.250000e-01
  %476 = fmul contract float %444, 1.250000e-01
  %477 = fmul contract float %445, 1.250000e-01
  %478 = fmul contract float %446, 1.250000e-01
  %479 = fmul contract float %447, 1.250000e-01
  %480 = fmul contract float %448, 1.250000e-01
  %481 = fmul contract float %449, 1.250000e-01
  %482 = fmul contract float %450, 1.250000e-01
  %483 = fmul contract float %451, 1.250000e-01
  %484 = fmul contract float %452, 1.250000e-01
  %485 = fmul contract float %453, 1.250000e-01
  %486 = fmul contract float %454, 1.250000e-01
  %487 = fmul contract float %455, 1.250000e-01
  %488 = fmul contract float %456, 1.250000e-01
  %489 = fmul contract float %457, 1.250000e-01
  %490 = fmul contract float %458, 1.250000e-01
  %491 = fmul contract float %459, 1.250000e-01
  %492 = fmul contract float %460, 1.250000e-01
  %493 = fmul contract float %461, 1.250000e-01
  %494 = fmul contract float %462, 1.250000e-01
  %495 = fmul contract float %463, 1.250000e-01
  %496 = fmul contract float %464, 1.250000e-01
  %.not = icmp slt i32 %51, %128
  %.not118 = icmp slt i32 %52, %128
  %.not119 = icmp slt i32 %53, %128
  %.not120 = icmp slt i32 %54, %128
  %.not121 = icmp slt i32 %55, %128
  %.not122 = icmp slt i32 %56, %128
  %.not123 = icmp slt i32 %57, %128
  %.not124 = icmp slt i32 %58, %128
  %.not125 = icmp slt i32 %51, %127
  %.not126 = icmp slt i32 %52, %127
  %.not127 = icmp slt i32 %53, %127
  %.not128 = icmp slt i32 %54, %127
  %.not129 = icmp slt i32 %55, %127
  %.not130 = icmp slt i32 %56, %127
  %.not131 = icmp slt i32 %57, %127
  %.not132 = icmp slt i32 %58, %127
  %.not133 = icmp slt i32 %51, %126
  %.not134 = icmp slt i32 %52, %126
  %.not135 = icmp slt i32 %53, %126
  %.not136 = icmp slt i32 %54, %126
  %.not137 = icmp slt i32 %55, %126
  %.not138 = icmp slt i32 %56, %126
  %.not139 = icmp slt i32 %57, %126
  %.not140 = icmp slt i32 %58, %126
  %.not141 = icmp slt i32 %51, %125
  %.not142 = icmp slt i32 %52, %125
  %.not143 = icmp slt i32 %53, %125
  %.not144 = icmp slt i32 %54, %125
  %.not145 = icmp slt i32 %55, %125
  %.not146 = icmp slt i32 %56, %125
  %.not147 = icmp slt i32 %57, %125
  %.not148 = icmp slt i32 %58, %125
  %497 = fmul contract float %465, 0x3FF7154760000000
  %498 = select i1 %.not, float 0xFFF0000000000000, float %497
  %499 = fmul contract float %466, 0x3FF7154760000000
  %500 = select i1 %.not118, float 0xFFF0000000000000, float %499
  %501 = fmul contract float %467, 0x3FF7154760000000
  %502 = select i1 %.not119, float 0xFFF0000000000000, float %501
  %503 = fmul contract float %468, 0x3FF7154760000000
  %504 = select i1 %.not120, float 0xFFF0000000000000, float %503
  %505 = fmul contract float %469, 0x3FF7154760000000
  %506 = select i1 %.not121, float 0xFFF0000000000000, float %505
  %507 = fmul contract float %470, 0x3FF7154760000000
  %508 = select i1 %.not122, float 0xFFF0000000000000, float %507
  %509 = fmul contract float %471, 0x3FF7154760000000
  %510 = select i1 %.not123, float 0xFFF0000000000000, float %509
  %511 = fmul contract float %472, 0x3FF7154760000000
  %512 = select i1 %.not124, float 0xFFF0000000000000, float %511
  %513 = fmul contract float %473, 0x3FF7154760000000
  %514 = select i1 %.not125, float 0xFFF0000000000000, float %513
  %515 = fmul contract float %474, 0x3FF7154760000000
  %516 = select i1 %.not126, float 0xFFF0000000000000, float %515
  %517 = fmul contract float %475, 0x3FF7154760000000
  %518 = select i1 %.not127, float 0xFFF0000000000000, float %517
  %519 = fmul contract float %476, 0x3FF7154760000000
  %520 = select i1 %.not128, float 0xFFF0000000000000, float %519
  %521 = fmul contract float %477, 0x3FF7154760000000
  %522 = select i1 %.not129, float 0xFFF0000000000000, float %521
  %523 = fmul contract float %478, 0x3FF7154760000000
  %524 = select i1 %.not130, float 0xFFF0000000000000, float %523
  %525 = fmul contract float %479, 0x3FF7154760000000
  %526 = select i1 %.not131, float 0xFFF0000000000000, float %525
  %527 = fmul contract float %480, 0x3FF7154760000000
  %528 = select i1 %.not132, float 0xFFF0000000000000, float %527
  %529 = fmul contract float %481, 0x3FF7154760000000
  %530 = select i1 %.not133, float 0xFFF0000000000000, float %529
  %531 = fmul contract float %482, 0x3FF7154760000000
  %532 = select i1 %.not134, float 0xFFF0000000000000, float %531
  %533 = fmul contract float %483, 0x3FF7154760000000
  %534 = select i1 %.not135, float 0xFFF0000000000000, float %533
  %535 = fmul contract float %484, 0x3FF7154760000000
  %536 = select i1 %.not136, float 0xFFF0000000000000, float %535
  %537 = fmul contract float %485, 0x3FF7154760000000
  %538 = select i1 %.not137, float 0xFFF0000000000000, float %537
  %539 = fmul contract float %486, 0x3FF7154760000000
  %540 = select i1 %.not138, float 0xFFF0000000000000, float %539
  %541 = fmul contract float %487, 0x3FF7154760000000
  %542 = select i1 %.not139, float 0xFFF0000000000000, float %541
  %543 = fmul contract float %488, 0x3FF7154760000000
  %544 = select i1 %.not140, float 0xFFF0000000000000, float %543
  %545 = fmul contract float %489, 0x3FF7154760000000
  %546 = select i1 %.not141, float 0xFFF0000000000000, float %545
  %547 = fmul contract float %490, 0x3FF7154760000000
  %548 = select i1 %.not142, float 0xFFF0000000000000, float %547
  %549 = fmul contract float %491, 0x3FF7154760000000
  %550 = select i1 %.not143, float 0xFFF0000000000000, float %549
  %551 = fmul contract float %492, 0x3FF7154760000000
  %552 = select i1 %.not144, float 0xFFF0000000000000, float %551
  %553 = fmul contract float %493, 0x3FF7154760000000
  %554 = select i1 %.not145, float 0xFFF0000000000000, float %553
  %555 = fmul contract float %494, 0x3FF7154760000000
  %556 = select i1 %.not146, float 0xFFF0000000000000, float %555
  %557 = fmul contract float %495, 0x3FF7154760000000
  %558 = select i1 %.not147, float 0xFFF0000000000000, float %557
  %559 = fmul contract float %496, 0x3FF7154760000000
  %560 = select i1 %.not148, float 0xFFF0000000000000, float %559
  %561 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %498, float %514) #0
  %562 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %500, float %516) #0
  %563 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %502, float %518) #0
  %564 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %504, float %520) #0
  %565 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %506, float %522) #0
  %566 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %508, float %524) #0
  %567 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %510, float %526) #0
  %568 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %512, float %528) #0
  %569 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %561, float %530) #0
  %570 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %562, float %532) #0
  %571 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %563, float %534) #0
  %572 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %564, float %536) #0
  %573 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %565, float %538) #0
  %574 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %566, float %540) #0
  %575 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %567, float %542) #0
  %576 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %568, float %544) #0
  %577 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %569, float %546) #0
  %578 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %570, float %548) #0
  %579 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %571, float %550) #0
  %580 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %572, float %552) #0
  %581 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %573, float %554) #0
  %582 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %574, float %556) #0
  %583 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %575, float %558) #0
  %584 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %576, float %560) #0
  %585 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %577) #0
  %586 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %578) #0
  %587 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %579) #0
  %588 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %580) #0
  %589 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %581) #0
  %590 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %582) #0
  %591 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %583) #0
  %592 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %584) #0
  %593 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %585) #0
  %594 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %586) #0
  %595 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %587) #0
  %596 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %588) #0
  %597 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %589) #0
  %598 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %590) #0
  %599 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %591) #0
  %600 = call spir_func float @_Z16__spirv_ocl_fmaxff(float 0xFFF0000000000000, float %592) #0
  %601 = fcmp oeq float %593, 0xFFF0000000000000
  %602 = fcmp oeq float %594, 0xFFF0000000000000
  %603 = fcmp oeq float %595, 0xFFF0000000000000
  %604 = fcmp oeq float %596, 0xFFF0000000000000
  %605 = fcmp oeq float %597, 0xFFF0000000000000
  %606 = fcmp oeq float %598, 0xFFF0000000000000
  %607 = fcmp oeq float %599, 0xFFF0000000000000
  %608 = fcmp oeq float %600, 0xFFF0000000000000
  %609 = select i1 %601, float 0.000000e+00, float %593
  %610 = select i1 %602, float 0.000000e+00, float %594
  %611 = select i1 %603, float 0.000000e+00, float %595
  %612 = select i1 %604, float 0.000000e+00, float %596
  %613 = select i1 %605, float 0.000000e+00, float %597
  %614 = select i1 %606, float 0.000000e+00, float %598
  %615 = select i1 %607, float 0.000000e+00, float %599
  %616 = select i1 %608, float 0.000000e+00, float %600
  %617 = fsub float 0xFFF0000000000000, %609
  %618 = fsub float 0xFFF0000000000000, %610
  %619 = fsub float 0xFFF0000000000000, %611
  %620 = fsub float 0xFFF0000000000000, %612
  %621 = fsub float 0xFFF0000000000000, %613
  %622 = fsub float 0xFFF0000000000000, %614
  %623 = fsub float 0xFFF0000000000000, %615
  %624 = fsub float 0xFFF0000000000000, %616
  %625 = call spir_func float @_Z16__spirv_ocl_exp2f(float %617) #0
  %626 = call spir_func float @_Z16__spirv_ocl_exp2f(float %618) #0
  %627 = call spir_func float @_Z16__spirv_ocl_exp2f(float %619) #0
  %628 = call spir_func float @_Z16__spirv_ocl_exp2f(float %620) #0
  %629 = call spir_func float @_Z16__spirv_ocl_exp2f(float %621) #0
  %630 = call spir_func float @_Z16__spirv_ocl_exp2f(float %622) #0
  %631 = call spir_func float @_Z16__spirv_ocl_exp2f(float %623) #0
  %632 = call spir_func float @_Z16__spirv_ocl_exp2f(float %624) #0
  %633 = fsub float %498, %609
  %634 = fsub float %500, %610
  %635 = fsub float %502, %611
  %636 = fsub float %504, %612
  %637 = fsub float %506, %613
  %638 = fsub float %508, %614
  %639 = fsub float %510, %615
  %640 = fsub float %512, %616
  %641 = fsub float %514, %609
  %642 = fsub float %516, %610
  %643 = fsub float %518, %611
  %644 = fsub float %520, %612
  %645 = fsub float %522, %613
  %646 = fsub float %524, %614
  %647 = fsub float %526, %615
  %648 = fsub float %528, %616
  %649 = fsub float %530, %609
  %650 = fsub float %532, %610
  %651 = fsub float %534, %611
  %652 = fsub float %536, %612
  %653 = fsub float %538, %613
  %654 = fsub float %540, %614
  %655 = fsub float %542, %615
  %656 = fsub float %544, %616
  %657 = fsub float %546, %609
  %658 = fsub float %548, %610
  %659 = fsub float %550, %611
  %660 = fsub float %552, %612
  %661 = fsub float %554, %613
  %662 = fsub float %556, %614
  %663 = fsub float %558, %615
  %664 = fsub float %560, %616
  %665 = call spir_func float @_Z16__spirv_ocl_exp2f(float %633) #0
  %666 = call spir_func float @_Z16__spirv_ocl_exp2f(float %634) #0
  %667 = call spir_func float @_Z16__spirv_ocl_exp2f(float %635) #0
  %668 = call spir_func float @_Z16__spirv_ocl_exp2f(float %636) #0
  %669 = call spir_func float @_Z16__spirv_ocl_exp2f(float %637) #0
  %670 = call spir_func float @_Z16__spirv_ocl_exp2f(float %638) #0
  %671 = call spir_func float @_Z16__spirv_ocl_exp2f(float %639) #0
  %672 = call spir_func float @_Z16__spirv_ocl_exp2f(float %640) #0
  %673 = call spir_func float @_Z16__spirv_ocl_exp2f(float %641) #0
  %674 = call spir_func float @_Z16__spirv_ocl_exp2f(float %642) #0
  %675 = call spir_func float @_Z16__spirv_ocl_exp2f(float %643) #0
  %676 = call spir_func float @_Z16__spirv_ocl_exp2f(float %644) #0
  %677 = call spir_func float @_Z16__spirv_ocl_exp2f(float %645) #0
  %678 = call spir_func float @_Z16__spirv_ocl_exp2f(float %646) #0
  %679 = call spir_func float @_Z16__spirv_ocl_exp2f(float %647) #0
  %680 = call spir_func float @_Z16__spirv_ocl_exp2f(float %648) #0
  %681 = call spir_func float @_Z16__spirv_ocl_exp2f(float %649) #0
  %682 = call spir_func float @_Z16__spirv_ocl_exp2f(float %650) #0
  %683 = call spir_func float @_Z16__spirv_ocl_exp2f(float %651) #0
  %684 = call spir_func float @_Z16__spirv_ocl_exp2f(float %652) #0
  %685 = call spir_func float @_Z16__spirv_ocl_exp2f(float %653) #0
  %686 = call spir_func float @_Z16__spirv_ocl_exp2f(float %654) #0
  %687 = call spir_func float @_Z16__spirv_ocl_exp2f(float %655) #0
  %688 = call spir_func float @_Z16__spirv_ocl_exp2f(float %656) #0
  %689 = call spir_func float @_Z16__spirv_ocl_exp2f(float %657) #0
  %690 = call spir_func float @_Z16__spirv_ocl_exp2f(float %658) #0
  %691 = call spir_func float @_Z16__spirv_ocl_exp2f(float %659) #0
  %692 = call spir_func float @_Z16__spirv_ocl_exp2f(float %660) #0
  %693 = call spir_func float @_Z16__spirv_ocl_exp2f(float %661) #0
  %694 = call spir_func float @_Z16__spirv_ocl_exp2f(float %662) #0
  %695 = call spir_func float @_Z16__spirv_ocl_exp2f(float %663) #0
  %696 = call spir_func float @_Z16__spirv_ocl_exp2f(float %664) #0
  %697 = fmul contract float 0.000000e+00, %625
  %698 = fmul contract float 0.000000e+00, %626
  %699 = fmul contract float 0.000000e+00, %627
  %700 = fmul contract float 0.000000e+00, %628
  %701 = fmul contract float 0.000000e+00, %629
  %702 = fmul contract float 0.000000e+00, %630
  %703 = fmul contract float 0.000000e+00, %631
  %704 = fmul contract float 0.000000e+00, %632
  %705 = fadd contract float %665, %673
  %706 = fadd contract float %666, %674
  %707 = fadd contract float %667, %675
  %708 = fadd contract float %668, %676
  %709 = fadd contract float %669, %677
  %710 = fadd contract float %670, %678
  %711 = fadd contract float %671, %679
  %712 = fadd contract float %672, %680
  %713 = fadd contract float %681, %705
  %714 = fadd contract float %682, %706
  %715 = fadd contract float %683, %707
  %716 = fadd contract float %684, %708
  %717 = fadd contract float %685, %709
  %718 = fadd contract float %686, %710
  %719 = fadd contract float %687, %711
  %720 = fadd contract float %688, %712
  %721 = fadd contract float %689, %713
  %722 = fadd contract float %690, %714
  %723 = fadd contract float %691, %715
  %724 = fadd contract float %692, %716
  %725 = fadd contract float %693, %717
  %726 = fadd contract float %694, %718
  %727 = fadd contract float %695, %719
  %728 = fadd contract float %696, %720
  %729 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %721) #0
  %730 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %722) #0
  %731 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %723) #0
  %732 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %724) #0
  %733 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %725) #0
  %734 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %726) #0
  %735 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %727) #0
  %736 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %728) #0
  %737 = fadd contract float %697, %729
  %738 = fadd contract float %698, %730
  %739 = fadd contract float %699, %731
  %740 = fadd contract float %700, %732
  %741 = fadd contract float %701, %733
  %742 = fadd contract float %702, %734
  %743 = fadd contract float %703, %735
  %744 = fadd contract float %704, %736
  %745 = fmul contract float 0.000000e+00, %625
  %746 = fmul contract float 0.000000e+00, %626
  %747 = fmul contract float 0.000000e+00, %627
  %748 = fmul contract float 0.000000e+00, %628
  %749 = fmul contract float 0.000000e+00, %629
  %750 = fmul contract float 0.000000e+00, %630
  %751 = fmul contract float 0.000000e+00, %631
  %752 = fmul contract float 0.000000e+00, %632
  %753 = fmul contract float 0.000000e+00, %625
  %754 = fmul contract float 0.000000e+00, %626
  %755 = fmul contract float 0.000000e+00, %627
  %756 = fmul contract float 0.000000e+00, %628
  %757 = fmul contract float 0.000000e+00, %629
  %758 = fmul contract float 0.000000e+00, %630
  %759 = fmul contract float 0.000000e+00, %631
  %760 = fmul contract float 0.000000e+00, %632
  %761 = fmul contract float 0.000000e+00, %625
  %762 = fmul contract float 0.000000e+00, %626
  %763 = fmul contract float 0.000000e+00, %627
  %764 = fmul contract float 0.000000e+00, %628
  %765 = fmul contract float 0.000000e+00, %629
  %766 = fmul contract float 0.000000e+00, %630
  %767 = fmul contract float 0.000000e+00, %631
  %768 = fmul contract float 0.000000e+00, %632
  %769 = fmul contract float 0.000000e+00, %625
  %770 = fmul contract float 0.000000e+00, %626
  %771 = fmul contract float 0.000000e+00, %627
  %772 = fmul contract float 0.000000e+00, %628
  %773 = fmul contract float 0.000000e+00, %629
  %774 = fmul contract float 0.000000e+00, %630
  %775 = fmul contract float 0.000000e+00, %631
  %776 = fmul contract float 0.000000e+00, %632
  %777 = fmul contract float 0.000000e+00, %625
  %778 = fmul contract float 0.000000e+00, %626
  %779 = fmul contract float 0.000000e+00, %627
  %780 = fmul contract float 0.000000e+00, %628
  %781 = fmul contract float 0.000000e+00, %629
  %782 = fmul contract float 0.000000e+00, %630
  %783 = fmul contract float 0.000000e+00, %631
  %784 = fmul contract float 0.000000e+00, %632
  %785 = fmul contract float 0.000000e+00, %625
  %786 = fmul contract float 0.000000e+00, %626
  %787 = fmul contract float 0.000000e+00, %627
  %788 = fmul contract float 0.000000e+00, %628
  %789 = fmul contract float 0.000000e+00, %629
  %790 = fmul contract float 0.000000e+00, %630
  %791 = fmul contract float 0.000000e+00, %631
  %792 = fmul contract float 0.000000e+00, %632
  %793 = fmul contract float 0.000000e+00, %625
  %794 = fmul contract float 0.000000e+00, %626
  %795 = fmul contract float 0.000000e+00, %627
  %796 = fmul contract float 0.000000e+00, %628
  %797 = fmul contract float 0.000000e+00, %629
  %798 = fmul contract float 0.000000e+00, %630
  %799 = fmul contract float 0.000000e+00, %631
  %800 = fmul contract float 0.000000e+00, %632
  %801 = fmul contract float 0.000000e+00, %625
  %802 = fmul contract float 0.000000e+00, %626
  %803 = fmul contract float 0.000000e+00, %627
  %804 = fmul contract float 0.000000e+00, %628
  %805 = fmul contract float 0.000000e+00, %629
  %806 = fmul contract float 0.000000e+00, %630
  %807 = fmul contract float 0.000000e+00, %631
  %808 = fmul contract float 0.000000e+00, %632
  %809 = fptrunc float %665 to half
  %810 = fptrunc float %666 to half
  %811 = fptrunc float %667 to half
  %812 = fptrunc float %668 to half
  %813 = fptrunc float %669 to half
  %814 = fptrunc float %670 to half
  %815 = fptrunc float %671 to half
  %816 = fptrunc float %672 to half
  %817 = fptrunc float %673 to half
  %818 = fptrunc float %674 to half
  %819 = fptrunc float %675 to half
  %820 = fptrunc float %676 to half
  %821 = fptrunc float %677 to half
  %822 = fptrunc float %678 to half
  %823 = fptrunc float %679 to half
  %824 = fptrunc float %680 to half
  %825 = fptrunc float %681 to half
  %826 = fptrunc float %682 to half
  %827 = fptrunc float %683 to half
  %828 = fptrunc float %684 to half
  %829 = fptrunc float %685 to half
  %830 = fptrunc float %686 to half
  %831 = fptrunc float %687 to half
  %832 = fptrunc float %688 to half
  %833 = fptrunc float %689 to half
  %834 = fptrunc float %690 to half
  %835 = fptrunc float %691 to half
  %836 = fptrunc float %692 to half
  %837 = fptrunc float %693 to half
  %838 = fptrunc float %694 to half
  %839 = fptrunc float %695 to half
  %840 = fptrunc float %696 to half
  %841 = insertelement <8 x half> undef, half %809, i32 0
  %842 = insertelement <8 x half> %841, half %810, i32 1
  %843 = insertelement <8 x half> %842, half %811, i32 2
  %844 = insertelement <8 x half> %843, half %812, i32 3
  %845 = insertelement <8 x half> %844, half %813, i32 4
  %846 = insertelement <8 x half> %845, half %814, i32 5
  %847 = insertelement <8 x half> %846, half %815, i32 6
  %848 = insertelement <8 x half> %847, half %816, i32 7
  %849 = insertelement <8 x half> undef, half %817, i32 0
  %850 = insertelement <8 x half> %849, half %818, i32 1
  %851 = insertelement <8 x half> %850, half %819, i32 2
  %852 = insertelement <8 x half> %851, half %820, i32 3
  %853 = insertelement <8 x half> %852, half %821, i32 4
  %854 = insertelement <8 x half> %853, half %822, i32 5
  %855 = insertelement <8 x half> %854, half %823, i32 6
  %856 = insertelement <8 x half> %855, half %824, i32 7
  %857 = insertelement <8 x half> undef, half %825, i32 0
  %858 = insertelement <8 x half> %857, half %826, i32 1
  %859 = insertelement <8 x half> %858, half %827, i32 2
  %860 = insertelement <8 x half> %859, half %828, i32 3
  %861 = insertelement <8 x half> %860, half %829, i32 4
  %862 = insertelement <8 x half> %861, half %830, i32 5
  %863 = insertelement <8 x half> %862, half %831, i32 6
  %864 = insertelement <8 x half> %863, half %832, i32 7
  %865 = insertelement <8 x half> undef, half %833, i32 0
  %866 = insertelement <8 x half> %865, half %834, i32 1
  %867 = insertelement <8 x half> %866, half %835, i32 2
  %868 = insertelement <8 x half> %867, half %836, i32 3
  %869 = insertelement <8 x half> %868, half %837, i32 4
  %870 = insertelement <8 x half> %869, half %838, i32 5
  %871 = insertelement <8 x half> %870, half %839, i32 6
  %872 = insertelement <8 x half> %871, half %840, i32 7
  %873 = insertelement <8 x float> undef, float %745, i32 0
  %874 = insertelement <8 x float> %873, float %746, i32 1
  %875 = insertelement <8 x float> %874, float %747, i32 2
  %876 = insertelement <8 x float> %875, float %748, i32 3
  %877 = insertelement <8 x float> %876, float %749, i32 4
  %878 = insertelement <8 x float> %877, float %750, i32 5
  %879 = insertelement <8 x float> %878, float %751, i32 6
  %880 = insertelement <8 x float> %879, float %752, i32 7
  %881 = insertelement <8 x float> undef, float %753, i32 0
  %882 = insertelement <8 x float> %881, float %754, i32 1
  %883 = insertelement <8 x float> %882, float %755, i32 2
  %884 = insertelement <8 x float> %883, float %756, i32 3
  %885 = insertelement <8 x float> %884, float %757, i32 4
  %886 = insertelement <8 x float> %885, float %758, i32 5
  %887 = insertelement <8 x float> %886, float %759, i32 6
  %888 = insertelement <8 x float> %887, float %760, i32 7
  %889 = insertelement <8 x float> undef, float %761, i32 0
  %890 = insertelement <8 x float> %889, float %762, i32 1
  %891 = insertelement <8 x float> %890, float %763, i32 2
  %892 = insertelement <8 x float> %891, float %764, i32 3
  %893 = insertelement <8 x float> %892, float %765, i32 4
  %894 = insertelement <8 x float> %893, float %766, i32 5
  %895 = insertelement <8 x float> %894, float %767, i32 6
  %896 = insertelement <8 x float> %895, float %768, i32 7
  %897 = insertelement <8 x float> undef, float %769, i32 0
  %898 = insertelement <8 x float> %897, float %770, i32 1
  %899 = insertelement <8 x float> %898, float %771, i32 2
  %900 = insertelement <8 x float> %899, float %772, i32 3
  %901 = insertelement <8 x float> %900, float %773, i32 4
  %902 = insertelement <8 x float> %901, float %774, i32 5
  %903 = insertelement <8 x float> %902, float %775, i32 6
  %904 = insertelement <8 x float> %903, float %776, i32 7
  %905 = insertelement <8 x float> undef, float %777, i32 0
  %906 = insertelement <8 x float> %905, float %778, i32 1
  %907 = insertelement <8 x float> %906, float %779, i32 2
  %908 = insertelement <8 x float> %907, float %780, i32 3
  %909 = insertelement <8 x float> %908, float %781, i32 4
  %910 = insertelement <8 x float> %909, float %782, i32 5
  %911 = insertelement <8 x float> %910, float %783, i32 6
  %912 = insertelement <8 x float> %911, float %784, i32 7
  %913 = insertelement <8 x float> undef, float %785, i32 0
  %914 = insertelement <8 x float> %913, float %786, i32 1
  %915 = insertelement <8 x float> %914, float %787, i32 2
  %916 = insertelement <8 x float> %915, float %788, i32 3
  %917 = insertelement <8 x float> %916, float %789, i32 4
  %918 = insertelement <8 x float> %917, float %790, i32 5
  %919 = insertelement <8 x float> %918, float %791, i32 6
  %920 = insertelement <8 x float> %919, float %792, i32 7
  %921 = insertelement <8 x float> undef, float %793, i32 0
  %922 = insertelement <8 x float> %921, float %794, i32 1
  %923 = insertelement <8 x float> %922, float %795, i32 2
  %924 = insertelement <8 x float> %923, float %796, i32 3
  %925 = insertelement <8 x float> %924, float %797, i32 4
  %926 = insertelement <8 x float> %925, float %798, i32 5
  %927 = insertelement <8 x float> %926, float %799, i32 6
  %928 = insertelement <8 x float> %927, float %800, i32 7
  %929 = insertelement <8 x float> undef, float %801, i32 0
  %930 = insertelement <8 x float> %929, float %802, i32 1
  %931 = insertelement <8 x float> %930, float %803, i32 2
  %932 = insertelement <8 x float> %931, float %804, i32 3
  %933 = insertelement <8 x float> %932, float %805, i32 4
  %934 = insertelement <8 x float> %933, float %806, i32 5
  %935 = insertelement <8 x float> %934, float %807, i32 6
  %936 = insertelement <8 x float> %935, float %808, i32 7
  %937 = bitcast <8 x half> %848 to <8 x i16>
  %938 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %313, <8 x float> %880, i32 3072) #0
  %939 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %315, <8 x float> %888, i32 3072) #0
  %940 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %329, <8 x float> %896, i32 3072) #0
  %941 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %331, <8 x float> %904, i32 3072) #0
  %942 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %345, <8 x float> %912, i32 3072) #0
  %943 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %347, <8 x float> %920, i32 3072) #0
  %944 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %361, <8 x float> %928, i32 3072) #0
  %945 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %937, <8 x i32> %363, <8 x float> %936, i32 3072) #0
  %946 = bitcast <8 x half> %856 to <8 x i16>
  %947 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %314, <8 x float> %938, i32 3072) #0
  %948 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %316, <8 x float> %939, i32 3072) #0
  %949 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %330, <8 x float> %940, i32 3072) #0
  %950 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %332, <8 x float> %941, i32 3072) #0
  %951 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %346, <8 x float> %942, i32 3072) #0
  %952 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %348, <8 x float> %943, i32 3072) #0
  %953 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %362, <8 x float> %944, i32 3072) #0
  %954 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %946, <8 x i32> %364, <8 x float> %945, i32 3072) #0
  %955 = bitcast <8 x half> %864 to <8 x i16>
  %956 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %321, <8 x float> %947, i32 3072) #0
  %957 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %323, <8 x float> %948, i32 3072) #0
  %958 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %337, <8 x float> %949, i32 3072) #0
  %959 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %339, <8 x float> %950, i32 3072) #0
  %960 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %353, <8 x float> %951, i32 3072) #0
  %961 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %355, <8 x float> %952, i32 3072) #0
  %962 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %369, <8 x float> %953, i32 3072) #0
  %963 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %955, <8 x i32> %371, <8 x float> %954, i32 3072) #0
  %964 = bitcast <8 x half> %872 to <8 x i16>
  %965 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %322, <8 x float> %956, i32 3072) #0
  %966 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %324, <8 x float> %957, i32 3072) #0
  %967 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %338, <8 x float> %958, i32 3072) #0
  %968 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %340, <8 x float> %959, i32 3072) #0
  %969 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %354, <8 x float> %960, i32 3072) #0
  %970 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %356, <8 x float> %961, i32 3072) #0
  %971 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %370, <8 x float> %962, i32 3072) #0
  %972 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %964, <8 x i32> %372, <8 x float> %963, i32 3072) #0
  %973 = extractelement <8 x float> %965, i32 0
  %974 = extractelement <8 x float> %965, i32 1
  %975 = extractelement <8 x float> %965, i32 2
  %976 = extractelement <8 x float> %965, i32 3
  %977 = extractelement <8 x float> %965, i32 4
  %978 = extractelement <8 x float> %965, i32 5
  %979 = extractelement <8 x float> %965, i32 6
  %980 = extractelement <8 x float> %965, i32 7
  %981 = extractelement <8 x float> %966, i32 0
  %982 = extractelement <8 x float> %966, i32 1
  %983 = extractelement <8 x float> %966, i32 2
  %984 = extractelement <8 x float> %966, i32 3
  %985 = extractelement <8 x float> %966, i32 4
  %986 = extractelement <8 x float> %966, i32 5
  %987 = extractelement <8 x float> %966, i32 6
  %988 = extractelement <8 x float> %966, i32 7
  %989 = extractelement <8 x float> %967, i32 0
  %990 = extractelement <8 x float> %967, i32 1
  %991 = extractelement <8 x float> %967, i32 2
  %992 = extractelement <8 x float> %967, i32 3
  %993 = extractelement <8 x float> %967, i32 4
  %994 = extractelement <8 x float> %967, i32 5
  %995 = extractelement <8 x float> %967, i32 6
  %996 = extractelement <8 x float> %967, i32 7
  %997 = extractelement <8 x float> %968, i32 0
  %998 = extractelement <8 x float> %968, i32 1
  %999 = extractelement <8 x float> %968, i32 2
  %1000 = extractelement <8 x float> %968, i32 3
  %1001 = extractelement <8 x float> %968, i32 4
  %1002 = extractelement <8 x float> %968, i32 5
  %1003 = extractelement <8 x float> %968, i32 6
  %1004 = extractelement <8 x float> %968, i32 7
  %1005 = extractelement <8 x float> %969, i32 0
  %1006 = extractelement <8 x float> %969, i32 1
  %1007 = extractelement <8 x float> %969, i32 2
  %1008 = extractelement <8 x float> %969, i32 3
  %1009 = extractelement <8 x float> %969, i32 4
  %1010 = extractelement <8 x float> %969, i32 5
  %1011 = extractelement <8 x float> %969, i32 6
  %1012 = extractelement <8 x float> %969, i32 7
  %1013 = extractelement <8 x float> %970, i32 0
  %1014 = extractelement <8 x float> %970, i32 1
  %1015 = extractelement <8 x float> %970, i32 2
  %1016 = extractelement <8 x float> %970, i32 3
  %1017 = extractelement <8 x float> %970, i32 4
  %1018 = extractelement <8 x float> %970, i32 5
  %1019 = extractelement <8 x float> %970, i32 6
  %1020 = extractelement <8 x float> %970, i32 7
  %1021 = extractelement <8 x float> %971, i32 0
  %1022 = extractelement <8 x float> %971, i32 1
  %1023 = extractelement <8 x float> %971, i32 2
  %1024 = extractelement <8 x float> %971, i32 3
  %1025 = extractelement <8 x float> %971, i32 4
  %1026 = extractelement <8 x float> %971, i32 5
  %1027 = extractelement <8 x float> %971, i32 6
  %1028 = extractelement <8 x float> %971, i32 7
  %1029 = extractelement <8 x float> %972, i32 0
  %1030 = extractelement <8 x float> %972, i32 1
  %1031 = extractelement <8 x float> %972, i32 2
  %1032 = extractelement <8 x float> %972, i32 3
  %1033 = extractelement <8 x float> %972, i32 4
  %1034 = extractelement <8 x float> %972, i32 5
  %1035 = extractelement <8 x float> %972, i32 6
  %1036 = extractelement <8 x float> %972, i32 7
  %1037 = add i32 %128, 64
  %1038 = add i32 %127, 64
  %1039 = add i32 %126, 64
  %1040 = add i32 %125, 64
  %1041 = add nuw nsw i32 0, 1
  %exitcond.not = icmp eq i32 %1041, %160
  %1042 = getelementptr i32, ptr addrspace(1) %7, i64 %77
  %1043 = load i32, ptr addrspace(1) %1042, align 4
  %1044 = shl i32 %1043, 7
  %1045 = getelementptr i8, ptr addrspace(1) %6, i64 %81
  %1046 = bitcast ptr addrspace(1) %1045 to ptr addrspace(1)
  %1047 = load i32, ptr addrspace(1) %1046, align 4
  %1048 = shl i32 %1047, 1
  %1049 = call spir_func i32 null() #2
  %1050 = shl i32 %1049, 5
  %1051 = and i32 %1050, 96
  %1052 = shl i32 %1049, 2
  %1053 = and i32 %1052, 48
  %1054 = or i32 %102, %1051
  %1055 = or i32 %1054, %1044
  %1056 = insertelement <2 x i32> undef, i32 %1055, i32 0
  %1057 = insertelement <2 x i32> %1056, i32 %1053, i32 1
  %1058 = getelementptr i8, ptr addrspace(1) %98, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %1058, i32 %101, i32 1024, i32 256, <2 x i32> %1057) #0
  %1059 = call spir_func i32 null() #2
  %1060 = shl i32 %1059, 5
  %1061 = and i32 %1060, 96
  %1062 = shl i32 %1059, 2
  %1063 = and i32 %1062, 48
  %1064 = or i32 %1063, %1044
  %1065 = or i32 %1061, %119
  %1066 = insertelement <2 x i32> undef, i32 %1065, i32 0
  %1067 = insertelement <2 x i32> %1066, i32 %1064, i32 1
  %1068 = getelementptr i8, ptr addrspace(1) %115, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %1068, i32 %118, i32 1024, i32 256, <2 x i32> %1067) #0
  %1069 = icmp sgt i32 %1048, 0
  %1070 = lshr i32 %100, 2
  %1071 = insertelement <2 x i32> undef, i32 %1070, i32 0
  %1072 = add nuw nsw i32 %1070, 8
  %1073 = insertelement <2 x i32> undef, i32 %1072, i32 0
  %1074 = or i32 %1070, 16
  %1075 = insertelement <2 x i32> undef, i32 %1074, i32 0
  %1076 = add nuw nsw i32 %1070, 24
  %1077 = insertelement <2 x i32> undef, i32 %1076, i32 0
  %1078 = or i32 %1070, 32
  %1079 = insertelement <2 x i32> undef, i32 %1078, i32 0
  %1080 = add nuw nsw i32 %1070, 40
  %1081 = insertelement <2 x i32> undef, i32 %1080, i32 0
  %1082 = or i32 %1070, 48
  %1083 = insertelement <2 x i32> undef, i32 %1082, i32 0
  %1084 = add nuw nsw i32 %1070, 56
  %1085 = insertelement <2 x i32> undef, i32 %1084, i32 0
  %1086 = insertelement <2 x i32> undef, i32 %119, i32 0
  %1087 = or i32 %119, 32
  %1088 = insertelement <2 x i32> undef, i32 %1087, i32 0
  %1089 = or i32 %119, 64
  %1090 = insertelement <2 x i32> undef, i32 %1089, i32 0
  %1091 = or i32 %119, 96
  %1092 = insertelement <2 x i32> undef, i32 %1091, i32 0
  %1093 = insertelement <2 x i32> undef, i32 %72, i32 0
  %1094 = or i32 %72, 32
  %1095 = insertelement <2 x i32> undef, i32 %1094, i32 0
  %1096 = or i32 %72, 64
  %1097 = insertelement <2 x i32> undef, i32 %1096, i32 0
  %1098 = or i32 %72, 96
  %1099 = insertelement <2 x i32> undef, i32 %1098, i32 0
  %1100 = icmp ult i32 %1048, 16
  %1101 = select i1 %1100, i32 %1048, i32 16
  %1102 = alloca [16 x i32], align 4
  %1103 = alloca [16 x i32], align 4
  %1104 = alloca [16 x i32], align 4
  %1105 = alloca [16 x i32], align 4
  %1106 = alloca [16 x i32], align 4
  %1107 = alloca [16 x i32], align 4
  %1108 = alloca [16 x i32], align 4
  %1109 = alloca [16 x i32], align 4
  %1110 = alloca [16 x i32], align 4
  %1111 = alloca [16 x i32], align 4
  %1112 = alloca [16 x i32], align 4
  %1113 = alloca [16 x i32], align 4
  %1114 = alloca [16 x i32], align 4
  %1115 = alloca [16 x i32], align 4
  %1116 = alloca [16 x i32], align 4
  %1117 = alloca [16 x i32], align 4
  %1118 = alloca [32 x i32], align 4
  %1119 = alloca [32 x i32], align 4
  %1120 = alloca [32 x i32], align 4
  %1121 = alloca [32 x i32], align 4
  %1122 = alloca [32 x i32], align 4
  %1123 = alloca [32 x i32], align 4
  %1124 = alloca [32 x i32], align 4
  %1125 = alloca [32 x i32], align 4
  %1126 = alloca [16 x i16], align 2
  %1127 = alloca [16 x i16], align 2
  %1128 = alloca [16 x i16], align 2
  %1129 = alloca [16 x i16], align 2
  %1130 = add i32 %1044, 64
  %1131 = call spir_func i32 null() #2
  %1132 = shl i32 %1131, 5
  %1133 = and i32 %1132, 96
  %1134 = add i32 %1133, %1130
  %1135 = shl i32 %1131, 2
  %1136 = and i32 %1135, 48
  %1137 = or i32 %1134, %102
  %1138 = insertelement <2 x i32> undef, i32 %1137, i32 0
  %1139 = insertelement <2 x i32> %1138, i32 %1136, i32 1
  %1140 = getelementptr i8, ptr addrspace(1) %98, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %1140, i32 %101, i32 1024, i32 256, <2 x i32> %1139) #0
  %1141 = call spir_func i32 null() #2
  %1142 = shl i32 %1141, 5
  %1143 = and i32 %1142, 96
  %1144 = shl i32 %1141, 2
  %1145 = and i32 %1144, 48
  %1146 = or i32 %1145, %1130
  %1147 = or i32 %1143, %119
  %1148 = insertelement <2 x i32> undef, i32 %1147, i32 0
  %1149 = insertelement <2 x i32> %1148, i32 %1146, i32 1
  %1150 = getelementptr i8, ptr addrspace(1) %115, i32 0
  call spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32 2, i32 16, i32 16, i32 2, ptr addrspace(1) %1150, i32 %118, i32 1024, i32 256, <2 x i32> %1149) #0
  %1151 = call spir_func i32 null() #2
  %1152 = insertelement <2 x i32> %1071, i32 %1044, i32 1
  %1153 = bitcast ptr %1102 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1152, ptr %1153) #0
  %1154 = bitcast ptr %1102 to ptr
  %1155 = load <16 x i32>, ptr %1154, align 64
  %1156 = shufflevector <16 x i32> %1155, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1157 = shufflevector <16 x i32> %1155, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1158 = insertelement <2 x i32> %1073, i32 %1044, i32 1
  %1159 = bitcast ptr %1103 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1158, ptr %1159) #0
  %1160 = bitcast ptr %1103 to ptr
  %1161 = load <16 x i32>, ptr %1160, align 64
  %1162 = shufflevector <16 x i32> %1161, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1163 = shufflevector <16 x i32> %1161, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1164 = insertelement <2 x i32> %1075, i32 %1044, i32 1
  %1165 = bitcast ptr %1104 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1164, ptr %1165) #0
  %1166 = bitcast ptr %1104 to ptr
  %1167 = load <16 x i32>, ptr %1166, align 64
  %1168 = shufflevector <16 x i32> %1167, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1169 = shufflevector <16 x i32> %1167, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1170 = insertelement <2 x i32> %1077, i32 %1044, i32 1
  %1171 = bitcast ptr %1105 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1170, ptr %1171) #0
  %1172 = bitcast ptr %1105 to ptr
  %1173 = load <16 x i32>, ptr %1172, align 64
  %1174 = shufflevector <16 x i32> %1173, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1175 = shufflevector <16 x i32> %1173, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1176 = insertelement <2 x i32> %1079, i32 %1044, i32 1
  %1177 = bitcast ptr %1106 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1176, ptr %1177) #0
  %1178 = bitcast ptr %1106 to ptr
  %1179 = load <16 x i32>, ptr %1178, align 64
  %1180 = shufflevector <16 x i32> %1179, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1181 = shufflevector <16 x i32> %1179, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1182 = insertelement <2 x i32> %1081, i32 %1044, i32 1
  %1183 = bitcast ptr %1107 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1182, ptr %1183) #0
  %1184 = bitcast ptr %1107 to ptr
  %1185 = load <16 x i32>, ptr %1184, align 64
  %1186 = shufflevector <16 x i32> %1185, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1187 = shufflevector <16 x i32> %1185, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1188 = insertelement <2 x i32> %1083, i32 %1044, i32 1
  %1189 = bitcast ptr %1108 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1188, ptr %1189) #0
  %1190 = bitcast ptr %1108 to ptr
  %1191 = load <16 x i32>, ptr %1190, align 64
  %1192 = shufflevector <16 x i32> %1191, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1193 = shufflevector <16 x i32> %1191, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1194 = insertelement <2 x i32> %1085, i32 %1044, i32 1
  %1195 = bitcast ptr %1109 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1194, ptr %1195) #0
  %1196 = bitcast ptr %1109 to ptr
  %1197 = load <16 x i32>, ptr %1196, align 64
  %1198 = shufflevector <16 x i32> %1197, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1199 = shufflevector <16 x i32> %1197, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1200 = or i32 %1044, 32
  %1201 = insertelement <2 x i32> %1071, i32 %1200, i32 1
  %1202 = bitcast ptr %1110 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1201, ptr %1202) #0
  %1203 = bitcast ptr %1110 to ptr
  %1204 = load <16 x i32>, ptr %1203, align 64
  %1205 = shufflevector <16 x i32> %1204, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1206 = shufflevector <16 x i32> %1204, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1207 = insertelement <2 x i32> %1073, i32 %1200, i32 1
  %1208 = bitcast ptr %1111 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1207, ptr %1208) #0
  %1209 = bitcast ptr %1111 to ptr
  %1210 = load <16 x i32>, ptr %1209, align 64
  %1211 = shufflevector <16 x i32> %1210, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1212 = shufflevector <16 x i32> %1210, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1213 = insertelement <2 x i32> %1075, i32 %1200, i32 1
  %1214 = bitcast ptr %1112 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1213, ptr %1214) #0
  %1215 = bitcast ptr %1112 to ptr
  %1216 = load <16 x i32>, ptr %1215, align 64
  %1217 = shufflevector <16 x i32> %1216, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1218 = shufflevector <16 x i32> %1216, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1219 = insertelement <2 x i32> %1077, i32 %1200, i32 1
  %1220 = bitcast ptr %1113 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1219, ptr %1220) #0
  %1221 = bitcast ptr %1113 to ptr
  %1222 = load <16 x i32>, ptr %1221, align 64
  %1223 = shufflevector <16 x i32> %1222, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1224 = shufflevector <16 x i32> %1222, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1225 = insertelement <2 x i32> %1079, i32 %1200, i32 1
  %1226 = bitcast ptr %1114 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1225, ptr %1226) #0
  %1227 = bitcast ptr %1114 to ptr
  %1228 = load <16 x i32>, ptr %1227, align 64
  %1229 = shufflevector <16 x i32> %1228, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1230 = shufflevector <16 x i32> %1228, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1231 = insertelement <2 x i32> %1081, i32 %1200, i32 1
  %1232 = bitcast ptr %1115 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1231, ptr %1232) #0
  %1233 = bitcast ptr %1115 to ptr
  %1234 = load <16 x i32>, ptr %1233, align 64
  %1235 = shufflevector <16 x i32> %1234, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1236 = shufflevector <16 x i32> %1234, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1237 = insertelement <2 x i32> %1083, i32 %1200, i32 1
  %1238 = bitcast ptr %1116 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1237, ptr %1238) #0
  %1239 = bitcast ptr %1116 to ptr
  %1240 = load <16 x i32>, ptr %1239, align 64
  %1241 = shufflevector <16 x i32> %1240, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1242 = shufflevector <16 x i32> %1240, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1243 = insertelement <2 x i32> %1085, i32 %1200, i32 1
  %1244 = bitcast ptr %1117 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32 4, i32 8, i32 32, i32 1, ptr addrspace(1) %98, i32 %101, i32 1024, i32 256, <2 x i32> %1243, ptr %1244) #0
  %1245 = bitcast ptr %1117 to ptr
  %1246 = load <16 x i32>, ptr %1245, align 64
  %1247 = shufflevector <16 x i32> %1246, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %1248 = shufflevector <16 x i32> %1246, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %1249 = call spir_func i32 null() #2
  %1250 = insertelement <2 x i32> %1086, i32 %1044, i32 1
  %1251 = bitcast ptr %1118 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1250, ptr %1251) #0
  %1252 = bitcast ptr %1118 to ptr
  %1253 = load <32 x i32>, ptr %1252, align 128
  %1254 = shufflevector <32 x i32> %1253, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1255 = shufflevector <32 x i32> %1253, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1256 = shufflevector <32 x i32> %1253, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1257 = shufflevector <32 x i32> %1253, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1258 = insertelement <2 x i32> %1086, i32 %1200, i32 1
  %1259 = bitcast ptr %1119 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1258, ptr %1259) #0
  %1260 = bitcast ptr %1119 to ptr
  %1261 = load <32 x i32>, ptr %1260, align 128
  %1262 = shufflevector <32 x i32> %1261, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1263 = shufflevector <32 x i32> %1261, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1264 = shufflevector <32 x i32> %1261, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1265 = shufflevector <32 x i32> %1261, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1266 = insertelement <2 x i32> %1088, i32 %1044, i32 1
  %1267 = bitcast ptr %1120 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1266, ptr %1267) #0
  %1268 = bitcast ptr %1120 to ptr
  %1269 = load <32 x i32>, ptr %1268, align 128
  %1270 = shufflevector <32 x i32> %1269, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1271 = shufflevector <32 x i32> %1269, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1272 = shufflevector <32 x i32> %1269, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1273 = shufflevector <32 x i32> %1269, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1274 = insertelement <2 x i32> %1088, i32 %1200, i32 1
  %1275 = bitcast ptr %1121 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1274, ptr %1275) #0
  %1276 = bitcast ptr %1121 to ptr
  %1277 = load <32 x i32>, ptr %1276, align 128
  %1278 = shufflevector <32 x i32> %1277, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1279 = shufflevector <32 x i32> %1277, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1280 = shufflevector <32 x i32> %1277, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1281 = shufflevector <32 x i32> %1277, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1282 = insertelement <2 x i32> %1090, i32 %1044, i32 1
  %1283 = bitcast ptr %1122 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1282, ptr %1283) #0
  %1284 = bitcast ptr %1122 to ptr
  %1285 = load <32 x i32>, ptr %1284, align 128
  %1286 = shufflevector <32 x i32> %1285, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1287 = shufflevector <32 x i32> %1285, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1288 = shufflevector <32 x i32> %1285, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1289 = shufflevector <32 x i32> %1285, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1290 = insertelement <2 x i32> %1090, i32 %1200, i32 1
  %1291 = bitcast ptr %1123 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1290, ptr %1291) #0
  %1292 = bitcast ptr %1123 to ptr
  %1293 = load <32 x i32>, ptr %1292, align 128
  %1294 = shufflevector <32 x i32> %1293, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1295 = shufflevector <32 x i32> %1293, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1296 = shufflevector <32 x i32> %1293, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1297 = shufflevector <32 x i32> %1293, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1298 = insertelement <2 x i32> %1092, i32 %1044, i32 1
  %1299 = bitcast ptr %1124 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1298, ptr %1299) #0
  %1300 = bitcast ptr %1124 to ptr
  %1301 = load <32 x i32>, ptr %1300, align 128
  %1302 = shufflevector <32 x i32> %1301, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1303 = shufflevector <32 x i32> %1301, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1304 = shufflevector <32 x i32> %1301, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1305 = shufflevector <32 x i32> %1301, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1306 = insertelement <2 x i32> %1092, i32 %1200, i32 1
  %1307 = bitcast ptr %1125 to ptr
  call spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 32, i32 2, ptr addrspace(1) %115, i32 %118, i32 1024, i32 256, <2 x i32> %1306, ptr %1307) #0
  %1308 = bitcast ptr %1125 to ptr
  %1309 = load <32 x i32>, ptr %1308, align 128
  %1310 = shufflevector <32 x i32> %1309, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1311 = shufflevector <32 x i32> %1309, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1312 = shufflevector <32 x i32> %1309, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %1313 = shufflevector <32 x i32> %1309, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %1314 = call spir_func i32 null() #2
  %1315 = shl i32 %1314, 3
  %1316 = and i32 %1315, 120
  %1317 = or i32 %1316, %39
  %1318 = insertelement <2 x i32> %1093, i32 %1317, i32 1
  %1319 = bitcast ptr %1126 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %1318, ptr %1319) #0
  %1320 = bitcast ptr %1126 to ptr
  %1321 = load <16 x i16>, ptr %1320, align 32
  %1322 = shufflevector <16 x i16> %1321, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1323 = shufflevector <16 x i16> %1321, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1324 = insertelement <2 x i32> %1095, i32 %1317, i32 1
  %1325 = bitcast ptr %1127 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %1324, ptr %1325) #0
  %1326 = bitcast ptr %1127 to ptr
  %1327 = load <16 x i16>, ptr %1326, align 32
  %1328 = shufflevector <16 x i16> %1327, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1329 = shufflevector <16 x i16> %1327, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1330 = insertelement <2 x i32> %1097, i32 %1317, i32 1
  %1331 = bitcast ptr %1128 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %1330, ptr %1331) #0
  %1332 = bitcast ptr %1128 to ptr
  %1333 = load <16 x i16>, ptr %1332, align 32
  %1334 = shufflevector <16 x i16> %1333, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1335 = shufflevector <16 x i16> %1333, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1336 = insertelement <2 x i32> %1099, i32 %1317, i32 1
  %1337 = bitcast ptr %1129 to ptr
  call spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32 2, i32 16, i32 8, i32 2, ptr addrspace(1) %68, i32 %71, i32 1024, i32 256, <2 x i32> %1336, ptr %1337) #0
  %1338 = bitcast ptr %1129 to ptr
  %1339 = load <16 x i16>, ptr %1338, align 32
  %1340 = shufflevector <16 x i16> %1339, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1341 = shufflevector <16 x i16> %1339, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1342 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1322, <8 x i32> %1156, <8 x float> zeroinitializer, i32 3072) #0
  %1343 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1322, <8 x i32> %1157, <8 x float> zeroinitializer, i32 3072) #0
  %1344 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1322, <8 x i32> %1205, <8 x float> zeroinitializer, i32 3072) #0
  %1345 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1322, <8 x i32> %1206, <8 x float> zeroinitializer, i32 3072) #0
  %1346 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1323, <8 x i32> %1162, <8 x float> %1342, i32 3072) #0
  %1347 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1323, <8 x i32> %1163, <8 x float> %1343, i32 3072) #0
  %1348 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1323, <8 x i32> %1211, <8 x float> %1344, i32 3072) #0
  %1349 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1323, <8 x i32> %1212, <8 x float> %1345, i32 3072) #0
  %1350 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1328, <8 x i32> %1168, <8 x float> %1346, i32 3072) #0
  %1351 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1328, <8 x i32> %1169, <8 x float> %1347, i32 3072) #0
  %1352 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1328, <8 x i32> %1217, <8 x float> %1348, i32 3072) #0
  %1353 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1328, <8 x i32> %1218, <8 x float> %1349, i32 3072) #0
  %1354 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1329, <8 x i32> %1174, <8 x float> %1350, i32 3072) #0
  %1355 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1329, <8 x i32> %1175, <8 x float> %1351, i32 3072) #0
  %1356 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1329, <8 x i32> %1223, <8 x float> %1352, i32 3072) #0
  %1357 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1329, <8 x i32> %1224, <8 x float> %1353, i32 3072) #0
  %1358 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1334, <8 x i32> %1180, <8 x float> %1354, i32 3072) #0
  %1359 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1334, <8 x i32> %1181, <8 x float> %1355, i32 3072) #0
  %1360 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1334, <8 x i32> %1229, <8 x float> %1356, i32 3072) #0
  %1361 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1334, <8 x i32> %1230, <8 x float> %1357, i32 3072) #0
  %1362 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1335, <8 x i32> %1186, <8 x float> %1358, i32 3072) #0
  %1363 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1335, <8 x i32> %1187, <8 x float> %1359, i32 3072) #0
  %1364 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1335, <8 x i32> %1235, <8 x float> %1360, i32 3072) #0
  %1365 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1335, <8 x i32> %1236, <8 x float> %1361, i32 3072) #0
  %1366 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1340, <8 x i32> %1192, <8 x float> %1362, i32 3072) #0
  %1367 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1340, <8 x i32> %1193, <8 x float> %1363, i32 3072) #0
  %1368 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1340, <8 x i32> %1241, <8 x float> %1364, i32 3072) #0
  %1369 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1340, <8 x i32> %1242, <8 x float> %1365, i32 3072) #0
  %1370 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1341, <8 x i32> %1198, <8 x float> %1366, i32 3072) #0
  %1371 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1341, <8 x i32> %1199, <8 x float> %1367, i32 3072) #0
  %1372 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1341, <8 x i32> %1247, <8 x float> %1368, i32 3072) #0
  %1373 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1341, <8 x i32> %1248, <8 x float> %1369, i32 3072) #0
  %1374 = extractelement <8 x float> %1370, i32 0
  %1375 = extractelement <8 x float> %1370, i32 1
  %1376 = extractelement <8 x float> %1370, i32 2
  %1377 = extractelement <8 x float> %1370, i32 3
  %1378 = extractelement <8 x float> %1370, i32 4
  %1379 = extractelement <8 x float> %1370, i32 5
  %1380 = extractelement <8 x float> %1370, i32 6
  %1381 = extractelement <8 x float> %1370, i32 7
  %1382 = extractelement <8 x float> %1371, i32 0
  %1383 = extractelement <8 x float> %1371, i32 1
  %1384 = extractelement <8 x float> %1371, i32 2
  %1385 = extractelement <8 x float> %1371, i32 3
  %1386 = extractelement <8 x float> %1371, i32 4
  %1387 = extractelement <8 x float> %1371, i32 5
  %1388 = extractelement <8 x float> %1371, i32 6
  %1389 = extractelement <8 x float> %1371, i32 7
  %1390 = extractelement <8 x float> %1372, i32 0
  %1391 = extractelement <8 x float> %1372, i32 1
  %1392 = extractelement <8 x float> %1372, i32 2
  %1393 = extractelement <8 x float> %1372, i32 3
  %1394 = extractelement <8 x float> %1372, i32 4
  %1395 = extractelement <8 x float> %1372, i32 5
  %1396 = extractelement <8 x float> %1372, i32 6
  %1397 = extractelement <8 x float> %1372, i32 7
  %1398 = extractelement <8 x float> %1373, i32 0
  %1399 = extractelement <8 x float> %1373, i32 1
  %1400 = extractelement <8 x float> %1373, i32 2
  %1401 = extractelement <8 x float> %1373, i32 3
  %1402 = extractelement <8 x float> %1373, i32 4
  %1403 = extractelement <8 x float> %1373, i32 5
  %1404 = extractelement <8 x float> %1373, i32 6
  %1405 = extractelement <8 x float> %1373, i32 7
  %1406 = fmul contract float %1374, 1.250000e-01
  %1407 = fmul contract float %1375, 1.250000e-01
  %1408 = fmul contract float %1376, 1.250000e-01
  %1409 = fmul contract float %1377, 1.250000e-01
  %1410 = fmul contract float %1378, 1.250000e-01
  %1411 = fmul contract float %1379, 1.250000e-01
  %1412 = fmul contract float %1380, 1.250000e-01
  %1413 = fmul contract float %1381, 1.250000e-01
  %1414 = fmul contract float %1382, 1.250000e-01
  %1415 = fmul contract float %1383, 1.250000e-01
  %1416 = fmul contract float %1384, 1.250000e-01
  %1417 = fmul contract float %1385, 1.250000e-01
  %1418 = fmul contract float %1386, 1.250000e-01
  %1419 = fmul contract float %1387, 1.250000e-01
  %1420 = fmul contract float %1388, 1.250000e-01
  %1421 = fmul contract float %1389, 1.250000e-01
  %1422 = fmul contract float %1390, 1.250000e-01
  %1423 = fmul contract float %1391, 1.250000e-01
  %1424 = fmul contract float %1392, 1.250000e-01
  %1425 = fmul contract float %1393, 1.250000e-01
  %1426 = fmul contract float %1394, 1.250000e-01
  %1427 = fmul contract float %1395, 1.250000e-01
  %1428 = fmul contract float %1396, 1.250000e-01
  %1429 = fmul contract float %1397, 1.250000e-01
  %1430 = fmul contract float %1398, 1.250000e-01
  %1431 = fmul contract float %1399, 1.250000e-01
  %1432 = fmul contract float %1400, 1.250000e-01
  %1433 = fmul contract float %1401, 1.250000e-01
  %1434 = fmul contract float %1402, 1.250000e-01
  %1435 = fmul contract float %1403, 1.250000e-01
  %1436 = fmul contract float %1404, 1.250000e-01
  %1437 = fmul contract float %1405, 1.250000e-01
  %1438 = fmul contract float %1406, 0x3FF7154760000000
  %1439 = fmul contract float %1407, 0x3FF7154760000000
  %1440 = fmul contract float %1408, 0x3FF7154760000000
  %1441 = fmul contract float %1409, 0x3FF7154760000000
  %1442 = fmul contract float %1410, 0x3FF7154760000000
  %1443 = fmul contract float %1411, 0x3FF7154760000000
  %1444 = fmul contract float %1412, 0x3FF7154760000000
  %1445 = fmul contract float %1413, 0x3FF7154760000000
  %1446 = fmul contract float %1414, 0x3FF7154760000000
  %1447 = fmul contract float %1415, 0x3FF7154760000000
  %1448 = fmul contract float %1416, 0x3FF7154760000000
  %1449 = fmul contract float %1417, 0x3FF7154760000000
  %1450 = fmul contract float %1418, 0x3FF7154760000000
  %1451 = fmul contract float %1419, 0x3FF7154760000000
  %1452 = fmul contract float %1420, 0x3FF7154760000000
  %1453 = fmul contract float %1421, 0x3FF7154760000000
  %1454 = fmul contract float %1422, 0x3FF7154760000000
  %1455 = fmul contract float %1423, 0x3FF7154760000000
  %1456 = fmul contract float %1424, 0x3FF7154760000000
  %1457 = fmul contract float %1425, 0x3FF7154760000000
  %1458 = fmul contract float %1426, 0x3FF7154760000000
  %1459 = fmul contract float %1427, 0x3FF7154760000000
  %1460 = fmul contract float %1428, 0x3FF7154760000000
  %1461 = fmul contract float %1429, 0x3FF7154760000000
  %1462 = fmul contract float %1430, 0x3FF7154760000000
  %1463 = fmul contract float %1431, 0x3FF7154760000000
  %1464 = fmul contract float %1432, 0x3FF7154760000000
  %1465 = fmul contract float %1433, 0x3FF7154760000000
  %1466 = fmul contract float %1434, 0x3FF7154760000000
  %1467 = fmul contract float %1435, 0x3FF7154760000000
  %1468 = fmul contract float %1436, 0x3FF7154760000000
  %1469 = fmul contract float %1437, 0x3FF7154760000000
  %1470 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1438, float %1446) #0
  %1471 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1439, float %1447) #0
  %1472 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1440, float %1448) #0
  %1473 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1441, float %1449) #0
  %1474 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1442, float %1450) #0
  %1475 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1443, float %1451) #0
  %1476 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1444, float %1452) #0
  %1477 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1445, float %1453) #0
  %1478 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1470, float %1454) #0
  %1479 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1471, float %1455) #0
  %1480 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1472, float %1456) #0
  %1481 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1473, float %1457) #0
  %1482 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1474, float %1458) #0
  %1483 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1475, float %1459) #0
  %1484 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1476, float %1460) #0
  %1485 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1477, float %1461) #0
  %1486 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1478, float %1462) #0
  %1487 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1479, float %1463) #0
  %1488 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1480, float %1464) #0
  %1489 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1481, float %1465) #0
  %1490 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1482, float %1466) #0
  %1491 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1483, float %1467) #0
  %1492 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1484, float %1468) #0
  %1493 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %1485, float %1469) #0
  %1494 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1486) #0
  %1495 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1487) #0
  %1496 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1488) #0
  %1497 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1489) #0
  %1498 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1490) #0
  %1499 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1491) #0
  %1500 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1492) #0
  %1501 = call spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32 3, i32 0, float %1493) #0
  %1502 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %593, float %1494) #0
  %1503 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %594, float %1495) #0
  %1504 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %595, float %1496) #0
  %1505 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %596, float %1497) #0
  %1506 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %597, float %1498) #0
  %1507 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %598, float %1499) #0
  %1508 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %599, float %1500) #0
  %1509 = call spir_func float @_Z16__spirv_ocl_fmaxff(float %600, float %1501) #0
  %1510 = fcmp oeq float %1502, 0xFFF0000000000000
  %1511 = fcmp oeq float %1503, 0xFFF0000000000000
  %1512 = fcmp oeq float %1504, 0xFFF0000000000000
  %1513 = fcmp oeq float %1505, 0xFFF0000000000000
  %1514 = fcmp oeq float %1506, 0xFFF0000000000000
  %1515 = fcmp oeq float %1507, 0xFFF0000000000000
  %1516 = fcmp oeq float %1508, 0xFFF0000000000000
  %1517 = fcmp oeq float %1509, 0xFFF0000000000000
  %1518 = select i1 %1510, float 0.000000e+00, float %1502
  %1519 = select i1 %1511, float 0.000000e+00, float %1503
  %1520 = select i1 %1512, float 0.000000e+00, float %1504
  %1521 = select i1 %1513, float 0.000000e+00, float %1505
  %1522 = select i1 %1514, float 0.000000e+00, float %1506
  %1523 = select i1 %1515, float 0.000000e+00, float %1507
  %1524 = select i1 %1516, float 0.000000e+00, float %1508
  %1525 = select i1 %1517, float 0.000000e+00, float %1509
  %1526 = fsub float %593, %1518
  %1527 = fsub float %594, %1519
  %1528 = fsub float %595, %1520
  %1529 = fsub float %596, %1521
  %1530 = fsub float %597, %1522
  %1531 = fsub float %598, %1523
  %1532 = fsub float %599, %1524
  %1533 = fsub float %600, %1525
  %1534 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1526) #0
  %1535 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1527) #0
  %1536 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1528) #0
  %1537 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1529) #0
  %1538 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1530) #0
  %1539 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1531) #0
  %1540 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1532) #0
  %1541 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1533) #0
  %1542 = fsub float %1438, %1518
  %1543 = fsub float %1439, %1519
  %1544 = fsub float %1440, %1520
  %1545 = fsub float %1441, %1521
  %1546 = fsub float %1442, %1522
  %1547 = fsub float %1443, %1523
  %1548 = fsub float %1444, %1524
  %1549 = fsub float %1445, %1525
  %1550 = fsub float %1446, %1518
  %1551 = fsub float %1447, %1519
  %1552 = fsub float %1448, %1520
  %1553 = fsub float %1449, %1521
  %1554 = fsub float %1450, %1522
  %1555 = fsub float %1451, %1523
  %1556 = fsub float %1452, %1524
  %1557 = fsub float %1453, %1525
  %1558 = fsub float %1454, %1518
  %1559 = fsub float %1455, %1519
  %1560 = fsub float %1456, %1520
  %1561 = fsub float %1457, %1521
  %1562 = fsub float %1458, %1522
  %1563 = fsub float %1459, %1523
  %1564 = fsub float %1460, %1524
  %1565 = fsub float %1461, %1525
  %1566 = fsub float %1462, %1518
  %1567 = fsub float %1463, %1519
  %1568 = fsub float %1464, %1520
  %1569 = fsub float %1465, %1521
  %1570 = fsub float %1466, %1522
  %1571 = fsub float %1467, %1523
  %1572 = fsub float %1468, %1524
  %1573 = fsub float %1469, %1525
  %1574 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1542) #0
  %1575 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1543) #0
  %1576 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1544) #0
  %1577 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1545) #0
  %1578 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1546) #0
  %1579 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1547) #0
  %1580 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1548) #0
  %1581 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1549) #0
  %1582 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1550) #0
  %1583 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1551) #0
  %1584 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1552) #0
  %1585 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1553) #0
  %1586 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1554) #0
  %1587 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1555) #0
  %1588 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1556) #0
  %1589 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1557) #0
  %1590 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1558) #0
  %1591 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1559) #0
  %1592 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1560) #0
  %1593 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1561) #0
  %1594 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1562) #0
  %1595 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1563) #0
  %1596 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1564) #0
  %1597 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1565) #0
  %1598 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1566) #0
  %1599 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1567) #0
  %1600 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1568) #0
  %1601 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1569) #0
  %1602 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1570) #0
  %1603 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1571) #0
  %1604 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1572) #0
  %1605 = call spir_func float @_Z16__spirv_ocl_exp2f(float %1573) #0
  %1606 = fmul contract float %737, %1534
  %1607 = fmul contract float %738, %1535
  %1608 = fmul contract float %739, %1536
  %1609 = fmul contract float %740, %1537
  %1610 = fmul contract float %741, %1538
  %1611 = fmul contract float %742, %1539
  %1612 = fmul contract float %743, %1540
  %1613 = fmul contract float %744, %1541
  %1614 = fadd contract float %1574, %1582
  %1615 = fadd contract float %1575, %1583
  %1616 = fadd contract float %1576, %1584
  %1617 = fadd contract float %1577, %1585
  %1618 = fadd contract float %1578, %1586
  %1619 = fadd contract float %1579, %1587
  %1620 = fadd contract float %1580, %1588
  %1621 = fadd contract float %1581, %1589
  %1622 = fadd contract float %1590, %1614
  %1623 = fadd contract float %1591, %1615
  %1624 = fadd contract float %1592, %1616
  %1625 = fadd contract float %1593, %1617
  %1626 = fadd contract float %1594, %1618
  %1627 = fadd contract float %1595, %1619
  %1628 = fadd contract float %1596, %1620
  %1629 = fadd contract float %1597, %1621
  %1630 = fadd contract float %1598, %1622
  %1631 = fadd contract float %1599, %1623
  %1632 = fadd contract float %1600, %1624
  %1633 = fadd contract float %1601, %1625
  %1634 = fadd contract float %1602, %1626
  %1635 = fadd contract float %1603, %1627
  %1636 = fadd contract float %1604, %1628
  %1637 = fadd contract float %1605, %1629
  %1638 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1630) #0
  %1639 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1631) #0
  %1640 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1632) #0
  %1641 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1633) #0
  %1642 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1634) #0
  %1643 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1635) #0
  %1644 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1636) #0
  %1645 = call spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32 3, i32 0, float %1637) #0
  %1646 = fadd contract float %1606, %1638
  %1647 = fadd contract float %1607, %1639
  %1648 = fadd contract float %1608, %1640
  %1649 = fadd contract float %1609, %1641
  %1650 = fadd contract float %1610, %1642
  %1651 = fadd contract float %1611, %1643
  %1652 = fadd contract float %1612, %1644
  %1653 = fadd contract float %1613, %1645
  %1654 = fmul contract float %973, %1534
  %1655 = fmul contract float %974, %1535
  %1656 = fmul contract float %975, %1536
  %1657 = fmul contract float %976, %1537
  %1658 = fmul contract float %977, %1538
  %1659 = fmul contract float %978, %1539
  %1660 = fmul contract float %979, %1540
  %1661 = fmul contract float %980, %1541
  %1662 = fmul contract float %981, %1534
  %1663 = fmul contract float %982, %1535
  %1664 = fmul contract float %983, %1536
  %1665 = fmul contract float %984, %1537
  %1666 = fmul contract float %985, %1538
  %1667 = fmul contract float %986, %1539
  %1668 = fmul contract float %987, %1540
  %1669 = fmul contract float %988, %1541
  %1670 = fmul contract float %989, %1534
  %1671 = fmul contract float %990, %1535
  %1672 = fmul contract float %991, %1536
  %1673 = fmul contract float %992, %1537
  %1674 = fmul contract float %993, %1538
  %1675 = fmul contract float %994, %1539
  %1676 = fmul contract float %995, %1540
  %1677 = fmul contract float %996, %1541
  %1678 = fmul contract float %997, %1534
  %1679 = fmul contract float %998, %1535
  %1680 = fmul contract float %999, %1536
  %1681 = fmul contract float %1000, %1537
  %1682 = fmul contract float %1001, %1538
  %1683 = fmul contract float %1002, %1539
  %1684 = fmul contract float %1003, %1540
  %1685 = fmul contract float %1004, %1541
  %1686 = fmul contract float %1005, %1534
  %1687 = fmul contract float %1006, %1535
  %1688 = fmul contract float %1007, %1536
  %1689 = fmul contract float %1008, %1537
  %1690 = fmul contract float %1009, %1538
  %1691 = fmul contract float %1010, %1539
  %1692 = fmul contract float %1011, %1540
  %1693 = fmul contract float %1012, %1541
  %1694 = fmul contract float %1013, %1534
  %1695 = fmul contract float %1014, %1535
  %1696 = fmul contract float %1015, %1536
  %1697 = fmul contract float %1016, %1537
  %1698 = fmul contract float %1017, %1538
  %1699 = fmul contract float %1018, %1539
  %1700 = fmul contract float %1019, %1540
  %1701 = fmul contract float %1020, %1541
  %1702 = fmul contract float %1021, %1534
  %1703 = fmul contract float %1022, %1535
  %1704 = fmul contract float %1023, %1536
  %1705 = fmul contract float %1024, %1537
  %1706 = fmul contract float %1025, %1538
  %1707 = fmul contract float %1026, %1539
  %1708 = fmul contract float %1027, %1540
  %1709 = fmul contract float %1028, %1541
  %1710 = fmul contract float %1029, %1534
  %1711 = fmul contract float %1030, %1535
  %1712 = fmul contract float %1031, %1536
  %1713 = fmul contract float %1032, %1537
  %1714 = fmul contract float %1033, %1538
  %1715 = fmul contract float %1034, %1539
  %1716 = fmul contract float %1035, %1540
  %1717 = fmul contract float %1036, %1541
  %1718 = fptrunc float %1574 to half
  %1719 = fptrunc float %1575 to half
  %1720 = fptrunc float %1576 to half
  %1721 = fptrunc float %1577 to half
  %1722 = fptrunc float %1578 to half
  %1723 = fptrunc float %1579 to half
  %1724 = fptrunc float %1580 to half
  %1725 = fptrunc float %1581 to half
  %1726 = fptrunc float %1582 to half
  %1727 = fptrunc float %1583 to half
  %1728 = fptrunc float %1584 to half
  %1729 = fptrunc float %1585 to half
  %1730 = fptrunc float %1586 to half
  %1731 = fptrunc float %1587 to half
  %1732 = fptrunc float %1588 to half
  %1733 = fptrunc float %1589 to half
  %1734 = fptrunc float %1590 to half
  %1735 = fptrunc float %1591 to half
  %1736 = fptrunc float %1592 to half
  %1737 = fptrunc float %1593 to half
  %1738 = fptrunc float %1594 to half
  %1739 = fptrunc float %1595 to half
  %1740 = fptrunc float %1596 to half
  %1741 = fptrunc float %1597 to half
  %1742 = fptrunc float %1598 to half
  %1743 = fptrunc float %1599 to half
  %1744 = fptrunc float %1600 to half
  %1745 = fptrunc float %1601 to half
  %1746 = fptrunc float %1602 to half
  %1747 = fptrunc float %1603 to half
  %1748 = fptrunc float %1604 to half
  %1749 = fptrunc float %1605 to half
  %1750 = insertelement <8 x half> undef, half %1718, i32 0
  %1751 = insertelement <8 x half> %1750, half %1719, i32 1
  %1752 = insertelement <8 x half> %1751, half %1720, i32 2
  %1753 = insertelement <8 x half> %1752, half %1721, i32 3
  %1754 = insertelement <8 x half> %1753, half %1722, i32 4
  %1755 = insertelement <8 x half> %1754, half %1723, i32 5
  %1756 = insertelement <8 x half> %1755, half %1724, i32 6
  %1757 = insertelement <8 x half> %1756, half %1725, i32 7
  %1758 = insertelement <8 x half> undef, half %1726, i32 0
  %1759 = insertelement <8 x half> %1758, half %1727, i32 1
  %1760 = insertelement <8 x half> %1759, half %1728, i32 2
  %1761 = insertelement <8 x half> %1760, half %1729, i32 3
  %1762 = insertelement <8 x half> %1761, half %1730, i32 4
  %1763 = insertelement <8 x half> %1762, half %1731, i32 5
  %1764 = insertelement <8 x half> %1763, half %1732, i32 6
  %1765 = insertelement <8 x half> %1764, half %1733, i32 7
  %1766 = insertelement <8 x half> undef, half %1734, i32 0
  %1767 = insertelement <8 x half> %1766, half %1735, i32 1
  %1768 = insertelement <8 x half> %1767, half %1736, i32 2
  %1769 = insertelement <8 x half> %1768, half %1737, i32 3
  %1770 = insertelement <8 x half> %1769, half %1738, i32 4
  %1771 = insertelement <8 x half> %1770, half %1739, i32 5
  %1772 = insertelement <8 x half> %1771, half %1740, i32 6
  %1773 = insertelement <8 x half> %1772, half %1741, i32 7
  %1774 = insertelement <8 x half> undef, half %1742, i32 0
  %1775 = insertelement <8 x half> %1774, half %1743, i32 1
  %1776 = insertelement <8 x half> %1775, half %1744, i32 2
  %1777 = insertelement <8 x half> %1776, half %1745, i32 3
  %1778 = insertelement <8 x half> %1777, half %1746, i32 4
  %1779 = insertelement <8 x half> %1778, half %1747, i32 5
  %1780 = insertelement <8 x half> %1779, half %1748, i32 6
  %1781 = insertelement <8 x half> %1780, half %1749, i32 7
  %1782 = insertelement <8 x float> undef, float %1654, i32 0
  %1783 = insertelement <8 x float> %1782, float %1655, i32 1
  %1784 = insertelement <8 x float> %1783, float %1656, i32 2
  %1785 = insertelement <8 x float> %1784, float %1657, i32 3
  %1786 = insertelement <8 x float> %1785, float %1658, i32 4
  %1787 = insertelement <8 x float> %1786, float %1659, i32 5
  %1788 = insertelement <8 x float> %1787, float %1660, i32 6
  %1789 = insertelement <8 x float> %1788, float %1661, i32 7
  %1790 = insertelement <8 x float> undef, float %1662, i32 0
  %1791 = insertelement <8 x float> %1790, float %1663, i32 1
  %1792 = insertelement <8 x float> %1791, float %1664, i32 2
  %1793 = insertelement <8 x float> %1792, float %1665, i32 3
  %1794 = insertelement <8 x float> %1793, float %1666, i32 4
  %1795 = insertelement <8 x float> %1794, float %1667, i32 5
  %1796 = insertelement <8 x float> %1795, float %1668, i32 6
  %1797 = insertelement <8 x float> %1796, float %1669, i32 7
  %1798 = insertelement <8 x float> undef, float %1670, i32 0
  %1799 = insertelement <8 x float> %1798, float %1671, i32 1
  %1800 = insertelement <8 x float> %1799, float %1672, i32 2
  %1801 = insertelement <8 x float> %1800, float %1673, i32 3
  %1802 = insertelement <8 x float> %1801, float %1674, i32 4
  %1803 = insertelement <8 x float> %1802, float %1675, i32 5
  %1804 = insertelement <8 x float> %1803, float %1676, i32 6
  %1805 = insertelement <8 x float> %1804, float %1677, i32 7
  %1806 = insertelement <8 x float> undef, float %1678, i32 0
  %1807 = insertelement <8 x float> %1806, float %1679, i32 1
  %1808 = insertelement <8 x float> %1807, float %1680, i32 2
  %1809 = insertelement <8 x float> %1808, float %1681, i32 3
  %1810 = insertelement <8 x float> %1809, float %1682, i32 4
  %1811 = insertelement <8 x float> %1810, float %1683, i32 5
  %1812 = insertelement <8 x float> %1811, float %1684, i32 6
  %1813 = insertelement <8 x float> %1812, float %1685, i32 7
  %1814 = insertelement <8 x float> undef, float %1686, i32 0
  %1815 = insertelement <8 x float> %1814, float %1687, i32 1
  %1816 = insertelement <8 x float> %1815, float %1688, i32 2
  %1817 = insertelement <8 x float> %1816, float %1689, i32 3
  %1818 = insertelement <8 x float> %1817, float %1690, i32 4
  %1819 = insertelement <8 x float> %1818, float %1691, i32 5
  %1820 = insertelement <8 x float> %1819, float %1692, i32 6
  %1821 = insertelement <8 x float> %1820, float %1693, i32 7
  %1822 = insertelement <8 x float> undef, float %1694, i32 0
  %1823 = insertelement <8 x float> %1822, float %1695, i32 1
  %1824 = insertelement <8 x float> %1823, float %1696, i32 2
  %1825 = insertelement <8 x float> %1824, float %1697, i32 3
  %1826 = insertelement <8 x float> %1825, float %1698, i32 4
  %1827 = insertelement <8 x float> %1826, float %1699, i32 5
  %1828 = insertelement <8 x float> %1827, float %1700, i32 6
  %1829 = insertelement <8 x float> %1828, float %1701, i32 7
  %1830 = insertelement <8 x float> undef, float %1702, i32 0
  %1831 = insertelement <8 x float> %1830, float %1703, i32 1
  %1832 = insertelement <8 x float> %1831, float %1704, i32 2
  %1833 = insertelement <8 x float> %1832, float %1705, i32 3
  %1834 = insertelement <8 x float> %1833, float %1706, i32 4
  %1835 = insertelement <8 x float> %1834, float %1707, i32 5
  %1836 = insertelement <8 x float> %1835, float %1708, i32 6
  %1837 = insertelement <8 x float> %1836, float %1709, i32 7
  %1838 = insertelement <8 x float> undef, float %1710, i32 0
  %1839 = insertelement <8 x float> %1838, float %1711, i32 1
  %1840 = insertelement <8 x float> %1839, float %1712, i32 2
  %1841 = insertelement <8 x float> %1840, float %1713, i32 3
  %1842 = insertelement <8 x float> %1841, float %1714, i32 4
  %1843 = insertelement <8 x float> %1842, float %1715, i32 5
  %1844 = insertelement <8 x float> %1843, float %1716, i32 6
  %1845 = insertelement <8 x float> %1844, float %1717, i32 7
  %1846 = bitcast <8 x half> %1757 to <8 x i16>
  %1847 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1254, <8 x float> %1789, i32 3072) #0
  %1848 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1256, <8 x float> %1797, i32 3072) #0
  %1849 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1270, <8 x float> %1805, i32 3072) #0
  %1850 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1272, <8 x float> %1813, i32 3072) #0
  %1851 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1286, <8 x float> %1821, i32 3072) #0
  %1852 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1288, <8 x float> %1829, i32 3072) #0
  %1853 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1302, <8 x float> %1837, i32 3072) #0
  %1854 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1846, <8 x i32> %1304, <8 x float> %1845, i32 3072) #0
  %1855 = bitcast <8 x half> %1765 to <8 x i16>
  %1856 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1255, <8 x float> %1847, i32 3072) #0
  %1857 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1257, <8 x float> %1848, i32 3072) #0
  %1858 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1271, <8 x float> %1849, i32 3072) #0
  %1859 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1273, <8 x float> %1850, i32 3072) #0
  %1860 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1287, <8 x float> %1851, i32 3072) #0
  %1861 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1289, <8 x float> %1852, i32 3072) #0
  %1862 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1303, <8 x float> %1853, i32 3072) #0
  %1863 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1855, <8 x i32> %1305, <8 x float> %1854, i32 3072) #0
  %1864 = bitcast <8 x half> %1773 to <8 x i16>
  %1865 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1262, <8 x float> %1856, i32 3072) #0
  %1866 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1264, <8 x float> %1857, i32 3072) #0
  %1867 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1278, <8 x float> %1858, i32 3072) #0
  %1868 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1280, <8 x float> %1859, i32 3072) #0
  %1869 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1294, <8 x float> %1860, i32 3072) #0
  %1870 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1296, <8 x float> %1861, i32 3072) #0
  %1871 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1310, <8 x float> %1862, i32 3072) #0
  %1872 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1864, <8 x i32> %1312, <8 x float> %1863, i32 3072) #0
  %1873 = bitcast <8 x half> %1781 to <8 x i16>
  %1874 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1263, <8 x float> %1865, i32 3072) #0
  %1875 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1265, <8 x float> %1866, i32 3072) #0
  %1876 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1279, <8 x float> %1867, i32 3072) #0
  %1877 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1281, <8 x float> %1868, i32 3072) #0
  %1878 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1295, <8 x float> %1869, i32 3072) #0
  %1879 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1297, <8 x float> %1870, i32 3072) #0
  %1880 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1311, <8 x float> %1871, i32 3072) #0
  %1881 = call spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32 16, <8 x i16> %1873, <8 x i32> %1313, <8 x float> %1872, i32 3072) #0
  %1882 = extractelement <8 x float> %1874, i32 0
  %1883 = extractelement <8 x float> %1874, i32 1
  %1884 = extractelement <8 x float> %1874, i32 2
  %1885 = extractelement <8 x float> %1874, i32 3
  %1886 = extractelement <8 x float> %1874, i32 4
  %1887 = extractelement <8 x float> %1874, i32 5
  %1888 = extractelement <8 x float> %1874, i32 6
  %1889 = extractelement <8 x float> %1874, i32 7
  %1890 = extractelement <8 x float> %1875, i32 0
  %1891 = extractelement <8 x float> %1875, i32 1
  %1892 = extractelement <8 x float> %1875, i32 2
  %1893 = extractelement <8 x float> %1875, i32 3
  %1894 = extractelement <8 x float> %1875, i32 4
  %1895 = extractelement <8 x float> %1875, i32 5
  %1896 = extractelement <8 x float> %1875, i32 6
  %1897 = extractelement <8 x float> %1875, i32 7
  %1898 = extractelement <8 x float> %1876, i32 0
  %1899 = extractelement <8 x float> %1876, i32 1
  %1900 = extractelement <8 x float> %1876, i32 2
  %1901 = extractelement <8 x float> %1876, i32 3
  %1902 = extractelement <8 x float> %1876, i32 4
  %1903 = extractelement <8 x float> %1876, i32 5
  %1904 = extractelement <8 x float> %1876, i32 6
  %1905 = extractelement <8 x float> %1876, i32 7
  %1906 = extractelement <8 x float> %1877, i32 0
  %1907 = extractelement <8 x float> %1877, i32 1
  %1908 = extractelement <8 x float> %1877, i32 2
  %1909 = extractelement <8 x float> %1877, i32 3
  %1910 = extractelement <8 x float> %1877, i32 4
  %1911 = extractelement <8 x float> %1877, i32 5
  %1912 = extractelement <8 x float> %1877, i32 6
  %1913 = extractelement <8 x float> %1877, i32 7
  %1914 = extractelement <8 x float> %1878, i32 0
  %1915 = extractelement <8 x float> %1878, i32 1
  %1916 = extractelement <8 x float> %1878, i32 2
  %1917 = extractelement <8 x float> %1878, i32 3
  %1918 = extractelement <8 x float> %1878, i32 4
  %1919 = extractelement <8 x float> %1878, i32 5
  %1920 = extractelement <8 x float> %1878, i32 6
  %1921 = extractelement <8 x float> %1878, i32 7
  %1922 = extractelement <8 x float> %1879, i32 0
  %1923 = extractelement <8 x float> %1879, i32 1
  %1924 = extractelement <8 x float> %1879, i32 2
  %1925 = extractelement <8 x float> %1879, i32 3
  %1926 = extractelement <8 x float> %1879, i32 4
  %1927 = extractelement <8 x float> %1879, i32 5
  %1928 = extractelement <8 x float> %1879, i32 6
  %1929 = extractelement <8 x float> %1879, i32 7
  %1930 = extractelement <8 x float> %1880, i32 0
  %1931 = extractelement <8 x float> %1880, i32 1
  %1932 = extractelement <8 x float> %1880, i32 2
  %1933 = extractelement <8 x float> %1880, i32 3
  %1934 = extractelement <8 x float> %1880, i32 4
  %1935 = extractelement <8 x float> %1880, i32 5
  %1936 = extractelement <8 x float> %1880, i32 6
  %1937 = extractelement <8 x float> %1880, i32 7
  %1938 = extractelement <8 x float> %1881, i32 0
  %1939 = extractelement <8 x float> %1881, i32 1
  %1940 = extractelement <8 x float> %1881, i32 2
  %1941 = extractelement <8 x float> %1881, i32 3
  %1942 = extractelement <8 x float> %1881, i32 4
  %1943 = extractelement <8 x float> %1881, i32 5
  %1944 = extractelement <8 x float> %1881, i32 6
  %1945 = extractelement <8 x float> %1881, i32 7
  %1946 = add nuw nsw i32 0, 1
  %exitcond177.not = icmp eq i32 %1946, %1101
  %1947 = fcmp oeq float %1646, 0.000000e+00
  %1948 = fcmp oeq float %1647, 0.000000e+00
  %1949 = fcmp oeq float %1648, 0.000000e+00
  %1950 = fcmp oeq float %1649, 0.000000e+00
  %1951 = fcmp oeq float %1650, 0.000000e+00
  %1952 = fcmp oeq float %1651, 0.000000e+00
  %1953 = fcmp oeq float %1652, 0.000000e+00
  %1954 = fcmp oeq float %1653, 0.000000e+00
  %1955 = select i1 %1947, float 1.000000e+00, float %1646
  %1956 = select i1 %1948, float 1.000000e+00, float %1647
  %1957 = select i1 %1949, float 1.000000e+00, float %1648
  %1958 = select i1 %1950, float 1.000000e+00, float %1649
  %1959 = select i1 %1951, float 1.000000e+00, float %1650
  %1960 = select i1 %1952, float 1.000000e+00, float %1651
  %1961 = select i1 %1953, float 1.000000e+00, float %1652
  %1962 = select i1 %1954, float 1.000000e+00, float %1653
  %1963 = fdiv float %1883, %1956
  %1964 = fdiv float %1884, %1957
  %1965 = fdiv float %1885, %1958
  %1966 = fdiv float %1886, %1959
  %1967 = fdiv float %1887, %1960
  %1968 = fdiv float %1888, %1961
  %1969 = fdiv float %1889, %1962
  %1970 = fdiv float %1890, %1955
  %1971 = fdiv float %1891, %1956
  %1972 = fdiv float %1892, %1957
  %1973 = fdiv float %1893, %1958
  %1974 = fdiv float %1894, %1959
  %1975 = fdiv float %1895, %1960
  %1976 = fdiv float %1896, %1961
  %1977 = fdiv float %1897, %1962
  %1978 = fdiv float %1898, %1955
  %1979 = fdiv float %1899, %1956
  %1980 = fdiv float %1900, %1957
  %1981 = fdiv float %1901, %1958
  %1982 = fdiv float %1902, %1959
  %1983 = fdiv float %1903, %1960
  %1984 = fdiv float %1904, %1961
  %1985 = fdiv float %1905, %1962
  %1986 = fdiv float %1906, %1955
  %1987 = fdiv float %1907, %1956
  %1988 = fdiv float %1908, %1957
  %1989 = fdiv float %1909, %1958
  %1990 = fdiv float %1910, %1959
  %1991 = fdiv float %1911, %1960
  %1992 = fdiv float %1912, %1961
  %1993 = fdiv float %1913, %1962
  %1994 = fdiv float %1914, %1955
  %1995 = fdiv float %1915, %1956
  %1996 = fdiv float %1916, %1957
  %1997 = fdiv float %1917, %1958
  %1998 = fdiv float %1918, %1959
  %1999 = fdiv float %1919, %1960
  %2000 = fdiv float %1920, %1961
  %2001 = fdiv float %1921, %1962
  %2002 = fdiv float %1922, %1955
  %2003 = fdiv float %1923, %1956
  %2004 = fdiv float %1924, %1957
  %2005 = fdiv float %1925, %1958
  %2006 = fdiv float %1926, %1959
  %2007 = fdiv float %1927, %1960
  %2008 = fdiv float %1928, %1961
  %2009 = fdiv float %1929, %1962
  %2010 = fdiv float %1930, %1955
  %2011 = fdiv float %1931, %1956
  %2012 = fdiv float %1932, %1957
  %2013 = fdiv float %1933, %1958
  %2014 = fdiv float %1934, %1959
  %2015 = fdiv float %1935, %1960
  %2016 = fdiv float %1936, %1961
  %2017 = fdiv float %1937, %1962
  %2018 = fdiv float %1938, %1955
  %2019 = fdiv float %1939, %1956
  %2020 = fdiv float %1940, %1957
  %2021 = fdiv float %1941, %1958
  %2022 = fdiv float %1942, %1959
  %2023 = fdiv float %1943, %1960
  %2024 = fdiv float %1944, %1961
  %2025 = fdiv float %1945, %1962
  %2026 = icmp slt i32 %51, 1024
  %2027 = icmp slt i32 %52, 1024
  %2028 = icmp slt i32 %53, 1024
  %2029 = icmp slt i32 %54, 1024
  %2030 = icmp slt i32 %55, 1024
  %2031 = icmp slt i32 %56, 1024
  %2032 = icmp slt i32 %57, 1024
  %2033 = icmp slt i32 %58, 1024
  %2034 = shl i32 %51, 7
  %2035 = shl i32 %52, 7
  %2036 = shl i32 %53, 7
  %2037 = shl i32 %54, 7
  %2038 = shl i32 %55, 7
  %2039 = shl i32 %56, 7
  %2040 = shl i32 %57, 7
  %2041 = shl i32 %58, 7
  %2042 = or i32 %31, %86
  %2043 = add i32 %2042, %2035
  %2044 = add i32 %2042, %2036
  %2045 = add i32 %2042, %2037
  %2046 = add i32 %2042, %2038
  %2047 = add i32 %2042, %2039
  %2048 = add i32 %2042, %2040
  %2049 = add i32 %2042, %2041
  %2050 = or i32 %87, %31
  %2051 = add i32 %2050, %2034
  %2052 = add i32 %2050, %2035
  %2053 = add i32 %2050, %2036
  %2054 = add i32 %2050, %2037
  %2055 = add i32 %2050, %2038
  %2056 = add i32 %2050, %2039
  %2057 = add i32 %2050, %2040
  %2058 = add i32 %2050, %2041
  %2059 = or i32 %88, %31
  %2060 = add i32 %2059, %2034
  %2061 = add i32 %2059, %2035
  %2062 = add i32 %2059, %2036
  %2063 = add i32 %2059, %2037
  %2064 = add i32 %2059, %2038
  %2065 = add i32 %2059, %2039
  %2066 = add i32 %2059, %2040
  %2067 = add i32 %2059, %2041
  %2068 = or i32 %89, %31
  %2069 = add i32 %2068, %2034
  %2070 = add i32 %2068, %2035
  %2071 = add i32 %2068, %2036
  %2072 = add i32 %2068, %2037
  %2073 = add i32 %2068, %2038
  %2074 = add i32 %2068, %2039
  %2075 = add i32 %2068, %2040
  %2076 = add i32 %2068, %2041
  %2077 = or i32 %86, %31
  %2078 = or i32 %2077, 64
  %2079 = add i32 %2078, %2034
  %2080 = add i32 %2078, %2035
  %2081 = add i32 %2078, %2036
  %2082 = add i32 %2078, %2037
  %2083 = add i32 %2078, %2038
  %2084 = add i32 %2078, %2039
  %2085 = add i32 %2078, %2040
  %2086 = add i32 %2078, %2041
  %2087 = or i32 %86, %31
  %2088 = or i32 %2087, 80
  %2089 = add i32 %2088, %2034
  %2090 = add i32 %2088, %2035
  %2091 = add i32 %2088, %2036
  %2092 = add i32 %2088, %2037
  %2093 = add i32 %2088, %2038
  %2094 = add i32 %2088, %2039
  %2095 = add i32 %2088, %2040
  %2096 = add i32 %2088, %2041
  %2097 = or i32 %86, %31
  %2098 = or i32 %2097, 96
  %2099 = add i32 %2098, %2034
  %2100 = add i32 %2098, %2035
  %2101 = add i32 %2098, %2036
  %2102 = add i32 %2098, %2037
  %2103 = add i32 %2098, %2038
  %2104 = add i32 %2098, %2039
  %2105 = add i32 %2098, %2040
  %2106 = add i32 %2098, %2041
  %2107 = or i32 %86, %31
  %2108 = or i32 %2107, 112
  %2109 = add i32 %2108, %2034
  %2110 = add i32 %2108, %2035
  %2111 = add i32 %2108, %2036
  %2112 = add i32 %2108, %2037
  %2113 = add i32 %2108, %2038
  %2114 = add i32 %2108, %2039
  %2115 = add i32 %2108, %2040
  %2116 = add i32 %2108, %2041
  %2117 = sext i32 %2043 to i64
  %2118 = getelementptr half, ptr addrspace(1) %8, i64 %2117
  %2119 = sext i32 %2044 to i64
  %2120 = getelementptr half, ptr addrspace(1) %8, i64 %2119
  %2121 = sext i32 %2045 to i64
  %2122 = getelementptr half, ptr addrspace(1) %8, i64 %2121
  %2123 = sext i32 %2046 to i64
  %2124 = getelementptr half, ptr addrspace(1) %8, i64 %2123
  %2125 = sext i32 %2047 to i64
  %2126 = getelementptr half, ptr addrspace(1) %8, i64 %2125
  %2127 = sext i32 %2048 to i64
  %2128 = getelementptr half, ptr addrspace(1) %8, i64 %2127
  %2129 = sext i32 %2049 to i64
  %2130 = getelementptr half, ptr addrspace(1) %8, i64 %2129
  %2131 = sext i32 %2051 to i64
  %2132 = getelementptr half, ptr addrspace(1) %8, i64 %2131
  %2133 = sext i32 %2052 to i64
  %2134 = getelementptr half, ptr addrspace(1) %8, i64 %2133
  %2135 = sext i32 %2053 to i64
  %2136 = getelementptr half, ptr addrspace(1) %8, i64 %2135
  %2137 = sext i32 %2054 to i64
  %2138 = getelementptr half, ptr addrspace(1) %8, i64 %2137
  %2139 = sext i32 %2055 to i64
  %2140 = getelementptr half, ptr addrspace(1) %8, i64 %2139
  %2141 = sext i32 %2056 to i64
  %2142 = getelementptr half, ptr addrspace(1) %8, i64 %2141
  %2143 = sext i32 %2057 to i64
  %2144 = getelementptr half, ptr addrspace(1) %8, i64 %2143
  %2145 = sext i32 %2058 to i64
  %2146 = getelementptr half, ptr addrspace(1) %8, i64 %2145
  %2147 = sext i32 %2060 to i64
  %2148 = getelementptr half, ptr addrspace(1) %8, i64 %2147
  %2149 = sext i32 %2061 to i64
  %2150 = getelementptr half, ptr addrspace(1) %8, i64 %2149
  %2151 = sext i32 %2062 to i64
  %2152 = getelementptr half, ptr addrspace(1) %8, i64 %2151
  %2153 = sext i32 %2063 to i64
  %2154 = getelementptr half, ptr addrspace(1) %8, i64 %2153
  %2155 = sext i32 %2064 to i64
  %2156 = getelementptr half, ptr addrspace(1) %8, i64 %2155
  %2157 = sext i32 %2065 to i64
  %2158 = getelementptr half, ptr addrspace(1) %8, i64 %2157
  %2159 = sext i32 %2066 to i64
  %2160 = getelementptr half, ptr addrspace(1) %8, i64 %2159
  %2161 = sext i32 %2067 to i64
  %2162 = getelementptr half, ptr addrspace(1) %8, i64 %2161
  %2163 = sext i32 %2069 to i64
  %2164 = getelementptr half, ptr addrspace(1) %8, i64 %2163
  %2165 = sext i32 %2070 to i64
  %2166 = getelementptr half, ptr addrspace(1) %8, i64 %2165
  %2167 = sext i32 %2071 to i64
  %2168 = getelementptr half, ptr addrspace(1) %8, i64 %2167
  %2169 = sext i32 %2072 to i64
  %2170 = getelementptr half, ptr addrspace(1) %8, i64 %2169
  %2171 = sext i32 %2073 to i64
  %2172 = getelementptr half, ptr addrspace(1) %8, i64 %2171
  %2173 = sext i32 %2074 to i64
  %2174 = getelementptr half, ptr addrspace(1) %8, i64 %2173
  %2175 = sext i32 %2075 to i64
  %2176 = getelementptr half, ptr addrspace(1) %8, i64 %2175
  %2177 = sext i32 %2076 to i64
  %2178 = getelementptr half, ptr addrspace(1) %8, i64 %2177
  %2179 = sext i32 %2079 to i64
  %2180 = getelementptr half, ptr addrspace(1) %8, i64 %2179
  %2181 = sext i32 %2080 to i64
  %2182 = getelementptr half, ptr addrspace(1) %8, i64 %2181
  %2183 = sext i32 %2081 to i64
  %2184 = getelementptr half, ptr addrspace(1) %8, i64 %2183
  %2185 = sext i32 %2082 to i64
  %2186 = getelementptr half, ptr addrspace(1) %8, i64 %2185
  %2187 = sext i32 %2083 to i64
  %2188 = getelementptr half, ptr addrspace(1) %8, i64 %2187
  %2189 = sext i32 %2084 to i64
  %2190 = getelementptr half, ptr addrspace(1) %8, i64 %2189
  %2191 = sext i32 %2085 to i64
  %2192 = getelementptr half, ptr addrspace(1) %8, i64 %2191
  %2193 = sext i32 %2086 to i64
  %2194 = getelementptr half, ptr addrspace(1) %8, i64 %2193
  %2195 = sext i32 %2089 to i64
  %2196 = getelementptr half, ptr addrspace(1) %8, i64 %2195
  %2197 = sext i32 %2090 to i64
  %2198 = getelementptr half, ptr addrspace(1) %8, i64 %2197
  %2199 = sext i32 %2091 to i64
  %2200 = getelementptr half, ptr addrspace(1) %8, i64 %2199
  %2201 = sext i32 %2092 to i64
  %2202 = getelementptr half, ptr addrspace(1) %8, i64 %2201
  %2203 = sext i32 %2093 to i64
  %2204 = getelementptr half, ptr addrspace(1) %8, i64 %2203
  %2205 = sext i32 %2094 to i64
  %2206 = getelementptr half, ptr addrspace(1) %8, i64 %2205
  %2207 = sext i32 %2095 to i64
  %2208 = getelementptr half, ptr addrspace(1) %8, i64 %2207
  %2209 = sext i32 %2096 to i64
  %2210 = getelementptr half, ptr addrspace(1) %8, i64 %2209
  %2211 = sext i32 %2099 to i64
  %2212 = getelementptr half, ptr addrspace(1) %8, i64 %2211
  %2213 = sext i32 %2100 to i64
  %2214 = getelementptr half, ptr addrspace(1) %8, i64 %2213
  %2215 = sext i32 %2101 to i64
  %2216 = getelementptr half, ptr addrspace(1) %8, i64 %2215
  %2217 = sext i32 %2102 to i64
  %2218 = getelementptr half, ptr addrspace(1) %8, i64 %2217
  %2219 = sext i32 %2103 to i64
  %2220 = getelementptr half, ptr addrspace(1) %8, i64 %2219
  %2221 = sext i32 %2104 to i64
  %2222 = getelementptr half, ptr addrspace(1) %8, i64 %2221
  %2223 = sext i32 %2105 to i64
  %2224 = getelementptr half, ptr addrspace(1) %8, i64 %2223
  %2225 = sext i32 %2106 to i64
  %2226 = getelementptr half, ptr addrspace(1) %8, i64 %2225
  %2227 = sext i32 %2109 to i64
  %2228 = getelementptr half, ptr addrspace(1) %8, i64 %2227
  %2229 = sext i32 %2110 to i64
  %2230 = getelementptr half, ptr addrspace(1) %8, i64 %2229
  %2231 = sext i32 %2111 to i64
  %2232 = getelementptr half, ptr addrspace(1) %8, i64 %2231
  %2233 = sext i32 %2112 to i64
  %2234 = getelementptr half, ptr addrspace(1) %8, i64 %2233
  %2235 = sext i32 %2113 to i64
  %2236 = getelementptr half, ptr addrspace(1) %8, i64 %2235
  %2237 = sext i32 %2114 to i64
  %2238 = getelementptr half, ptr addrspace(1) %8, i64 %2237
  %2239 = sext i32 %2115 to i64
  %2240 = getelementptr half, ptr addrspace(1) %8, i64 %2239
  %2241 = sext i32 %2116 to i64
  %2242 = getelementptr half, ptr addrspace(1) %8, i64 %2241
  %2243 = fptrunc float %1963 to half
  %2244 = fptrunc float %1964 to half
  %2245 = fptrunc float %1965 to half
  %2246 = fptrunc float %1966 to half
  %2247 = fptrunc float %1967 to half
  %2248 = fptrunc float %1968 to half
  %2249 = fptrunc float %1969 to half
  %2250 = fptrunc float %1970 to half
  %2251 = fptrunc float %1971 to half
  %2252 = fptrunc float %1972 to half
  %2253 = fptrunc float %1973 to half
  %2254 = fptrunc float %1974 to half
  %2255 = fptrunc float %1975 to half
  %2256 = fptrunc float %1976 to half
  %2257 = fptrunc float %1977 to half
  %2258 = fptrunc float %1978 to half
  %2259 = fptrunc float %1979 to half
  %2260 = fptrunc float %1980 to half
  %2261 = fptrunc float %1981 to half
  %2262 = fptrunc float %1982 to half
  %2263 = fptrunc float %1983 to half
  %2264 = fptrunc float %1984 to half
  %2265 = fptrunc float %1985 to half
  %2266 = fptrunc float %1986 to half
  %2267 = fptrunc float %1987 to half
  %2268 = fptrunc float %1988 to half
  %2269 = fptrunc float %1989 to half
  %2270 = fptrunc float %1990 to half
  %2271 = fptrunc float %1991 to half
  %2272 = fptrunc float %1992 to half
  %2273 = fptrunc float %1993 to half
  %2274 = fptrunc float %1994 to half
  %2275 = fptrunc float %1995 to half
  %2276 = fptrunc float %1996 to half
  %2277 = fptrunc float %1997 to half
  %2278 = fptrunc float %1998 to half
  %2279 = fptrunc float %1999 to half
  %2280 = fptrunc float %2000 to half
  %2281 = fptrunc float %2001 to half
  %2282 = fptrunc float %2002 to half
  %2283 = fptrunc float %2003 to half
  %2284 = fptrunc float %2004 to half
  %2285 = fptrunc float %2005 to half
  %2286 = fptrunc float %2006 to half
  %2287 = fptrunc float %2007 to half
  %2288 = fptrunc float %2008 to half
  %2289 = fptrunc float %2009 to half
  %2290 = fptrunc float %2010 to half
  %2291 = fptrunc float %2011 to half
  %2292 = fptrunc float %2012 to half
  %2293 = fptrunc float %2013 to half
  %2294 = fptrunc float %2014 to half
  %2295 = fptrunc float %2015 to half
  %2296 = fptrunc float %2016 to half
  %2297 = fptrunc float %2017 to half
  %2298 = fptrunc float %2018 to half
  %2299 = fptrunc float %2019 to half
  %2300 = fptrunc float %2020 to half
  %2301 = fptrunc float %2021 to half
  %2302 = fptrunc float %2022 to half
  %2303 = fptrunc float %2023 to half
  %2304 = fptrunc float %2024 to half
  %2305 = fptrunc float %2025 to half
  %2306 = fdiv float %1882, %1955
  %2307 = fptrunc float %2306 to half
  %2308 = add i32 %2042, %2034
  %2309 = sext i32 %2308 to i64
  %2310 = getelementptr half, ptr addrspace(1) %8, i64 %2309
  store half %2307, ptr addrspace(1) %2310, align 2
  ret void
}

; Function Attrs: nounwind
declare spir_func void @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i(i32, i32, i32, i32, ptr addrspace(1), i32, i32, i32, <2 x i32>) #0

; Function Attrs: nounwind
declare spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc(i32, i32, i32, i32, ptr addrspace(1), i32, i32, i32, <2 x i32>, ptr) #0

; Function Attrs: nounwind
declare spir_func void @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc(i32, i32, i32, i32, ptr addrspace(1), i32, i32, i32, <2 x i32>, ptr) #0

; Function Attrs: nounwind
declare spir_func void @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc(i32, i32, i32, i32, ptr addrspace(1), i32, i32, i32, <2 x i32>, ptr) #0

; Function Attrs: nounwind
declare spir_func <8 x float> @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi(i32, <8 x i16>, <8 x i32>, <8 x float>, i32) #0

; Function Attrs: nounwind memory(none)
declare spir_func float @_Z16__spirv_ocl_fmaxff(float, float) #1

; Function Attrs: nounwind
declare spir_func float @_Z27__spirv_GroupNonUniformFMaxiif(i32, i32, float) #0

; Function Attrs: nounwind memory(none)
declare spir_func float @_Z16__spirv_ocl_exp2f(float) #1

; Function Attrs: nounwind
declare spir_func float @_Z27__spirv_GroupNonUniformFAddiif(i32, i32, float) #0

; Function Attrs: nounwind willreturn memory(none)
declare spir_func i64 @_Z26__spirv_BuiltInWorkgroupIdi(i32) #2

; Function Attrs: nounwind willreturn memory(none)
declare spir_func i64 @_Z32__spirv_BuiltInLocalInvocationIdi(i32) #2

; uselistorder directives
uselistorder ptr @_Z36__spirv_Subgroup2DBlockPrefetchINTELiiiiPU3AS1ciiiDv2_i, { 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z41__spirv_Subgroup2DBlockLoadTransposeINTELiiiiPU3AS1ciiiDv2_iPc, { 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z41__spirv_Subgroup2DBlockLoadTransformINTELiiiiPU3AS1ciiiDv2_iPc, { 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z32__spirv_Subgroup2DBlockLoadINTELiiiiPU3AS1ciiiDv2_iPc, { 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z45__spirv_SubgroupMatrixMultiplyAccumulateINTELiDv8_sDv8_iDv8_fi, { 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z16__spirv_ocl_fmaxff, { 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z27__spirv_GroupNonUniformFMaxiif, { 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z16__spirv_ocl_exp2f, { 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z27__spirv_GroupNonUniformFAddiif, { 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z26__spirv_BuiltInWorkgroupIdi, { 5, 4, 3, 2, 1, 0 }
uselistorder ptr @_Z32__spirv_BuiltInLocalInvocationIdi, { 2, 1, 0 }

attributes #0 = { nounwind }
attributes #1 = { nounwind memory(none) }
attributes #2 = { nounwind willreturn memory(none) }

!0 = !{i32 16}
