/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Locale;

@StatelessCheck
public class EmptyForInitializerPadCheck
extends AbstractCheck {
    public static final String MSG_PRECEDED = "ws.preceded";
    public static final String MSG_NOT_PRECEDED = "ws.notPreceded";
    private static final String SEMICOLON = ";";
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{35};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            DetailAST semi = ast.getNextSibling();
            int semiLineIdx = semi.getLineNo() - 1;
            String line = this.getLines()[semiLineIdx];
            int before = semi.getColumnNo() - 1;
            if (!CommonUtil.hasWhitespaceBefore(before, line)) {
                if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(before))) {
                    this.log(ast, MSG_PRECEDED, SEMICOLON);
                } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(before))) {
                    this.log(ast, MSG_NOT_PRECEDED, SEMICOLON);
                }
            }
        }
    }
}

