/*	$NetBSD: fortran.c,v 1.12 2019/02/03 03:19:29 mrg Exp $	*/

/*
 * Copyright (c) 1987, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if HAVE_NBTOOL_CONFIG_H
#include "nbtool_config.h"
#endif

#include <sys/cdefs.h>
#if defined(__RCSID) && !defined(lint)
#if 0
static char sccsid[] = "@(#)fortran.c	8.3 (Berkeley) 4/2/94";
#else
__RCSID("$NetBSD: fortran.c,v 1.12 2019/02/03 03:19:29 mrg Exp $");
#endif
#endif /* not lint */

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>

#include "ctags.h"

static void takeprec(void);

char *lbp;				/* line buffer pointer */

int
PF_funcs(void)
{
	bool	pfcnt;			/* pascal/fortran functions found */
	char	*cp;
	char	tok[MAXTOKEN];

	for (pfcnt = NO;;) {
		lineftell = ftell(inf);
		if (!fgets(lbuf, sizeof(lbuf), inf))
			return (pfcnt);
		++lineno;
		lbp = lbuf;
		if (*lbp == '%')	/* Ratfor escape to fortran */
			++lbp;
		for (; isspace((unsigned char)*lbp); ++lbp)
			continue;
		if (!*lbp)
			continue;
		switch (*lbp | ' ') {	/* convert to lower-case */
		case 'c':
			if (cicmp("complex") || cicmp("character"))
				takeprec();
			break;
		case 'd':
			if (cicmp("double")) {
				for (; isspace((unsigned char)*lbp); ++lbp)
					continue;
				if (!*lbp)
					continue;
				if (cicmp("precision"))
					break;
				continue;
			}
			break;
		case 'i':
			if (cicmp("integer"))
				takeprec();
			break;
		case 'l':
			if (cicmp("logical"))
				takeprec();
			break;
		case 'r':
			if (cicmp("real"))
				takeprec();
			break;
		}
		for (; isspace((unsigned char)*lbp); ++lbp)
			continue;
		if (!*lbp)
			continue;
		switch (*lbp | ' ') {
		case 'f':
			if (cicmp("function"))
				break;
			continue;
		case 'p':
			if (cicmp("program") || cicmp("procedure"))
				break;
			continue;
		case 's':
			if (cicmp("subroutine"))
				break;
			/* FALLTHROUGH */
		default:
			continue;
		}
		for (; isspace((unsigned char)*lbp); ++lbp)
			continue;
		if (!*lbp)
			continue;
		for (cp = lbp + 1; *cp && intoken(*cp); ++cp)
			continue;
		if ((cp = lbp + 1) != NULL)
			continue;
		*cp = EOS;
		(void)strlcpy(tok, lbp, sizeof(tok));
		get_line();			/* process line for ex(1) */
		pfnote(tok, lineno);
		pfcnt = YES;
	}
	/*NOTREACHED*/
}

/*
 * cicmp --
 *	do case-independent strcmp
 */
int
cicmp(const char *cp)
{
	int	len;
	char	*bp;

	for (len = 0, bp = lbp; *cp && (*cp &~ ' ') == (*bp++ &~ ' ');
	    ++cp, ++len)
		continue;
	if (!*cp) {
		lbp += len;
		return (YES);
	}
	return (NO);
}

static void
takeprec(void)
{
	for (; isspace((unsigned char)*lbp); ++lbp)
		continue;
	if (*lbp == '*') {
		for (++lbp; isspace((unsigned char)*lbp); ++lbp)
			continue;
		if (!isdigit((unsigned char)*lbp))
			--lbp;			/* force failure */
		else
			while (isdigit((unsigned char)*++lbp))
				continue;
	}
}
