/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _RowP_H_
#define _RowP_H_

#include	<Nws/BaseConstP.h>
#include	<Nws/Row.h>


typedef struct {
	char	empty;
} RowClassPart;

typedef struct _RowClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	BaseConstClassPart	baseConst_class;
	RowClassPart	row_class;
} RowClassRec;

extern RowClassRec rowClassRec;

typedef struct {
	/* resources */
	int		spacing;
	Boolean		homogenous;
	/* private */
} RowPart;

typedef struct _RowRec {
	CorePart		core;
	CompositePart		composite;
	ConstraintPart		constraint;
	BaseConstPart		baseConst;
	RowPart		row;
} RowRec;

typedef struct _RowConstraintsPart {
	int	gravitation;
	int	left_space;
	int	right_space;
	Boolean	resizable;
} RowConstraintsPart;

typedef struct _RowConstraintsRec {
	RowConstraintsPart	row;
} RowConstraintsRec, *RowConstraints;

#endif
