/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>

#include	"ScrollListP.h"
#include	"ScrollWin.h"
#include	"Init.h"
#include	"ListP.h"
#include	"misc.h"


static void ClassInitialize();
static void Initialize ();

static void ScrollIfRequired ();
static void Select ();
static void Activate ();

static XtActionsRec action [] = {
	{"select",Select},
	{"activate",Activate},
};

static char trans_tab [] =
	"<Key>Prior: select(previous_page) \n\
	 <Key>Next: select(next_page) \n\
         <Key>Up: select(previous) \n\
         <Key>Down: select(next) \n\
         <Key>Home: select(first) \n\
         <Key>End: select(last) \n\
         <Key>Return : activate() \n\
	 ";

ScrollListClassRec scrollListClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &scrollWinClassRec,
    /* class_name            */ "ScrollList",
    /* widget_size           */ sizeof(ScrollListRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ NULL,
    /* num_resources         */ 0,
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager	     */ XtInheritGeometryManager,
    /* change_managed	     */ XtInheritChangeManaged,
    /* insert_child	     */ XtInheritInsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL
   },
/* baseComp */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse                */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* scrollWin */
   {
    /* empty		       */ 0
   },
};

WidgetClass scrollListWidgetClass = (WidgetClass) &scrollListClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ScrollListWidget nw = (ScrollListWidget) new_widget;

	nw->scrollList.list = XtVaCreateManagedWidget("__list" , listWidgetClass ,
		new_widget , NULL);

	XtAddCallback(nw->scrollList.list ,XtNselect_changed_cb ,ScrollIfRequired ,NULL);
}



Widget GetListWidget(w)
Widget w;
{
	return ((ScrollListWidget)w)->scrollList.list;
}

static void Activate (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ScrollListWidget cw = (ScrollListWidget) w;

	XtCallActionProc(cw->scrollList.list , "activate" , event , params , *num_params);
}

static void Select (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ScrollListWidget cw = (ScrollListWidget) w;
	ListWidget lw = (ListWidget) cw->scrollList.list;
	Dimension clipheight , eheight;
	int per_page;
	char *p;
	char nparams[5];

	if (*num_params != 1)
	{
		XtWarning("Action 'select' called with wrong parameters count");
		return;
	}
	if (!lw->list.num_entry) return;

	XtVaGetValues(lw->list.w_list[0] , XtNheight , &eheight , NULL);
	XtVaGetValues(cw->scrollWin.clipw , XtNheight , &clipheight , NULL);

	per_page = MAX((clipheight / eheight) - 1 , 1);
	p = nparams;
	if (! strcmp(params[0] , "next_page"))
	{
		sprintf(nparams , "%d" , per_page);
		XtCallActionProc(cw->scrollList.list , "select" , event , 
			&p , 1);
	}
	else if (! strcmp(params[0] , "previous_page"))
	{
		sprintf(nparams , "%d" , -per_page);
		XtCallActionProc(cw->scrollList.list , "select" , event , 
			&p , 1);	
	}
	else
	{
		XtCallActionProc(cw->scrollList.list , "select" , event , params ,
			*num_params);
	}
}

static void ScrollIfRequired(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ScrollListWidget cw = (ScrollListWidget) XtParent(w);
	ListWidget lw = (ListWidget) w;
	Position chy , ey , pos = 0;
	Dimension clipheight , eheight;
	int which = 0;
	Boolean scroll = False;

	if (lw->list.last_selected)
	{
		ey = lw->list.last_selected->core.y;
		eheight = lw->list.last_selected->core.height;

		clipheight = cw->scrollWin.clipw->core.height;

		chy = cw->scrollWin.schild->core.y;

		if ((ey + eheight) > (-chy + clipheight))
		{
			which = XtCbottom_border;
			pos = ey + eheight;
			scroll = True;
		}
		if (ey < (-chy))
		{
			which = XtCtop_border;
			pos = ey;
			scroll = True;
		}

		if (scroll) SetScrollWin((Widget) cw , which , pos ,  0);
	}
}
