/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _condition_h_
#define _condition_h_

#include <time.h>

#include "url.h"
#include "tools.h"
#include "robots.h"
#include "dllist.h"

typedef struct  {
	int	leave_level;	/*** how many levels leave from starting site ***/
	bool	dont_leave_site;/*** dont leave site of starting URL ***/
	bool	dont_leave_dir; /*** dont leave directory of starting URL ***/
	time_t	btime;		/*** file never than ***/
	time_t	etime;		/*** file older than ***/
	int	max_size;	/*** maximal size of document to exclude big documents ***/
	int	min_size;	/*** minimal size of document to exclude small documents ***/
	int	max_levels;	/*** obmedzenie na maximalnu hlbku vnorenia sa do stromu - 0 neobmedzene ****/
	int	max_documents;	/*** obmedzenie na maximalny pocet dokumentov - 0 neobmedzene ***/
	bool	cgi;		/*** povolenie / zakazanie prenosu dokumentov enerovanych cez CGI ***/
	char	**sites;	/*** zoznam povolenych / zakazanych serverov ***/
	bool	allow_site;	/*** indikacia ci v "sites" su povolene alebo zakazane servery ***/
	char	**sufix;	/*** zoznam povolenych / zakazanych pripon dokumentov ***/
	bool	allow_sufix;	/*** indikacia ci v zozname "sufix" su povolene alebo zakazane pripony ***/
	char	**dir_prefix;	/*** zozname povolenych / zakazanych prefixov dokumentov ***/
	bool	allow_prefix;	/*** indikacia ci v zozname "dir_prefix" su povolene alebo zakazane prefixy ***/
	char	**domains;	/*** list of domains to check in URLs ***/
	bool	allow_domain;	/*** domains in list are allowed ***/
	char	**mime;		/*** list of mime types to check ***/
	bool	allow_mime;	/*** allowed/disallowed mime types ***/ 
	bool	ftp;		/*** povolenie / zakazanie protokolu FTP ***/
	bool	ftps;		/*** povolenie / zakazanie protokolu FTPS ***/
	bool	ftpdir;		/*** povolenie / zakazanie rekurzivneho prenosu FTP adresarov ***/
	bool	http;		/*** povolenie / zakazanie protokolu HTTP ***/
	bool	https;		/*** povolenie / zakazanie protokolu HTTPS (HTTP nad SSL) ***/
	bool	gopher;		/*** povolenie / zakazanie protokolu Gopher ***/
	bool	allow_robots;	/*** povolenie / zakazanie pouzitia suborov "robots.txt" pri kontrole pristupu k dokumentu ***/
	char	**pattern;	/*** fnmatch patterns for matching document names ***/
	dllist	*rpattern;	/*** regular patterns for matching document names ***/
	char	**url_pattern;	/*** fnmatch patterns for matching url ***/
	dllist	*rurl_pattern;	/*** regular patterns for matching url ***/
	char	**skip_pattern;	/*** fnmatch patterns to exclude matching document names ***/
	dllist	*rskip_pattern;	/*** regular patterns to exclude matching document names ***/
	char	**skip_url_pattern;	/*** fnmatch patterns to exclude matching url ***/
	dllist	*rskip_url_pattern;	/*** regular patterns to exclude matching url ***/
	char	*uexit;		/*** user exit script ***/
	dllist	*aip;		/*** allowed IP addresses ***/
	dllist	*skipip;	/*** disalloved IP addreses ***/
	int	site_level;	/*** maximum site level to leave ***/
} cond;

#if NeedFunctionPrototypes
extern int url_append_condition(url * , int);
#else
extern int url_append_condition();
#endif

#endif 
