/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/


#ifdef HAVE_REGEX

#include "config.h"
#include "re.h"
#include "tools.h"

void re_free(ree)
re_entry *ree;
{
#ifdef HAVE_POSIX_REGEX
	regfree(&(ree->preg));
#endif
#ifdef HAVE_V8_REGEX
	_free(ree->preg);
#endif
#ifdef HAVE_GNU_REGEX
	regfree(&(ree->preg));
#endif
	_free(ree->pattern);
	_free(ree);
}

re_entry *re_make(str)
char *str;
{
	int ec;
	re_entry *rv;
	char pom[PATH_MAX];
	char *p;

	rv = _malloc(sizeof(re_entry));

#ifdef HAVE_POSIX_REGEX
	if ((ec = regcomp(&(rv->preg) , str , REG_EXTENDED)))
	{
		xprintf(0 , gettext("Error compiling regular expression : %s\n") , str);
		regerror(ec , &(rv->preg) , pom , sizeof(pom));
		xprintf(0 , "%s\n" , pom);
		regfree(&(rv->preg));
		_free(rv);
	}
#endif
#ifdef HAVE_V8_REGEX
	if (!(rv->preg = regcomp(str)))
	{
		xprintf(0 , gettext("Error compiling regular expression : %s\n") , str);
		_free(rv);
	}
#endif
#ifdef HAVE_BSD_REGEX
	if ((p = re_comp(str)))
	{
		xprintf(0 , gettext("Error compiling regular expression : %s\n") , str);
		xprintf(0, p);
		_free(rv);
	}
#endif
#ifdef HAVE_GNU_REGEX
	rv->preg.allocated = 0;
	rv->preg.buffer = NULL;
	rv->preg.fastmap = NULL;

	if ((p = re_compile_pattern(str, strlen(str) , &rv->preg)))
	{
		xprintf(0 , gettext("Error compiling regular expression : %s\n") , str);
		xprintf(0 , "%s\n" , p);
		regfree(&(rv->preg));
		_free(rv);
	}

#endif
	else
		rv->pattern = new_string(str);

	return rv;
}

int re_pmatch(ree , str)
re_entry *ree;
char *str;
{
#ifdef HAVE_POSIX_REGEX
	return !regexec(&(ree->preg) , str , 0 , NULL , 0);
#endif
#ifdef HAVE_V8_REGEX
	return regexec(ree->preg , str);
#endif
#ifdef HAVE_BSD_REGEX
	re_comp(ree->pattern);
	return re_exec(str);
#endif
#ifdef HAVE_GNU_REGEX
	return re_match(&(ree->preg) , str , strlen(str) , 0, NULL) >= 0;
#endif
}

#endif

