//
//  helpDialog.c  --  creates a help dialog box
//  -- created  5/23/00 updated 5/23/00
////////////////////////////////////////////

#include "helpDialog.h"

GtkWidget*
create_helpDialog (void)
{
  GtkWidget *helpDialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label8;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label7;
  GtkWidget *dialog_action_area1;
  GtkWidget *okButton;

  helpDialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (helpDialog), "helpDialog", helpDialog);
  gtk_window_set_title (GTK_WINDOW (helpDialog), "Help");
  GTK_WINDOW (helpDialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_policy (GTK_WINDOW (helpDialog), TRUE, FALSE, TRUE);

  dialog_vbox1 = GTK_DIALOG (helpDialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (helpDialog), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

  label2 = gtk_label_new ("Help documentation is located in:");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);

  char where_help_is[255];
  strcat(where_help_is,DOCDIR);
  strcat(where_help_is,"/index.html");
  label8 = gtk_label_new ( where_help_is ); // DOCDIR is defined in the Makefile and includes the necesary quotes
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (vbox1), label8, FALSE, FALSE, 0);

  label4 = gtk_label_new ("");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (vbox1), label4, FALSE, FALSE, 0);

  label5 = gtk_label_new ("  The same documentation is also available online at:   ");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (vbox1), label5, FALSE, FALSE, 0);

  label6 = gtk_label_new ("http://althea.sourceforge.net/");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (vbox1), label6, FALSE, FALSE, 0);

  label7 = gtk_label_new ("");
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (vbox1), label7, FALSE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (helpDialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (helpDialog), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  okButton = gtk_button_new_with_label ("OK");
  gtk_widget_ref (okButton);
  gtk_object_set_data_full (GTK_OBJECT (helpDialog), "okButton", okButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (okButton);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), okButton, FALSE, TRUE, 0);

  // The ok button should destroy this window
  gtk_signal_connect_object( GTK_OBJECT (okButton), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (helpDialog) );



  gtk_widget_grab_focus (okButton);
  return helpDialog;
}

