/*
 * gpal - A friendly GUI frontend for the PayPal micropayment service
 * Copyright (C) 2001 Alp Toker <alp@atoker.com>
 * Portions of this file Copyright (C) hampa@chello.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#define SYSTEM 1
#define MAXLINE 64


#include <string.h>
#include <memory.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <stdio.h>
#include <unistd.h>

#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#define PPSERVER "secure.paypal.com"

#define CHK_NULL(x) if ((x)==NULL) exit (1)
#define CHK_ERR(err,s) if ((err)==-1) { perror(s); exit(1); }
#define CHK_SSL(err) if ((err)==-1) { ERR_print_errors_fp(stderr); exit(2); }

#include <stdio.h>

int debug = 0;

char request[1024];
char response[6144];		//TODO: this is a bit silly. malloc it instead

char contentbuf[1024];
char auth[48];
char rs[48];
char balance[48];
char title[48];

#define tag_auth       "<postfield name=\"auth\" value=\""
#define header_act     "POST /cgi-bin/phscr?rs=%s HTTP/1.0\nAccept: text/vnd.wap.wml\n"
#define header_plain   "POST /cgi-bin/phscr HTTP/1.0\nAccept: text/vnd.wap.wml\n"
#define content_login  "cmd=login-submit-pass&email=%s&pass=%s\n"
#define content_pay    "cmd=beam-email-submit&email=%s&dollars=%i&cents=%i"
#define content_req    "cmd=request-email-submit&email=%s&dollars=%i&cents=%i"
#define content_hist   "cmd=translog"
#define content_logout "cmd=logout"



int sslcat(char *szResult, char *lpFileName)
{
    int err = 0;
    int sd;
    struct sockaddr_in sa;
    SSL_CTX *ctx;
    SSL *ssl;
    X509 *server_cert;
    char *str;
    char buf[2048];
    SSL_METHOD *meth;
    long ipaddr;
    struct hostent *hostinfo;
    int i=0;

    SSLeay_add_ssl_algorithms();
    meth = SSLv3_client_method();
    SSL_load_error_strings();
    ctx = SSL_CTX_new(meth);

    if (ctx == NULL) {
      return 0;
    }

    if (debug)
	fprintf(stderr, "ssl request:\n%s\n\n", lpFileName);

    sd = socket(AF_INET, SOCK_STREAM, 0);
    CHK_ERR(sd, "1: socket");

    memset(&sa, 0, sizeof(sa));
    sa.sin_family = AF_INET;
    hostinfo = gethostbyname(PPSERVER);
    ipaddr = *(long *) *hostinfo->h_addr_list;
    sa.sin_addr.s_addr = ipaddr;
    sa.sin_port = htons(443);

    err = connect(sd, (struct sockaddr *) &sa, sizeof(sa));

    CHK_ERR(err, "2: -connect");

    ssl = SSL_new(ctx);
    if (ssl == NULL) {
      return 0;
    }

    SSL_set_fd(ssl, sd);
    err = SSL_connect(ssl);

    if (err == -1) {
	fprintf(stderr, "ssl error\n");
	return 0;
    }

    server_cert = SSL_get_peer_certificate(ssl);
    if (server_cert == NULL) {
	fprintf(stderr, "cert error\n");
	return 0;
    }


    str = X509_NAME_oneline(X509_get_subject_name(server_cert), 0, 0);
    if (str == NULL) {
      return 0;
    }

    err = SSL_write(ssl, lpFileName, strlen(lpFileName));
    if (err == -1) {
	fprintf(stderr, "ssl write error\n");
	return 0;
    }

    while (1) {
	err = SSL_read(ssl, buf, sizeof(buf) - 1);
	i++;
	if (err == 0) {
	    break;
	}

	//szResult = realloc(szResult,sizeof(buf)*i); //TODO
	//fprintf(stderr, "%i,%i.\n",sizeof(szResult), errno);
	if (i==1) *szResult = 0;
	if (strlen(szResult)+sizeof(buf) > 6144) return 0; else strncat(szResult, buf, err);
    }

    SSL_shutdown(ssl);
    SSL_free(ssl);
    SSL_CTX_free(ctx);

    close(sd);

    if (debug)
	fprintf(stderr, "ssl response:\n%s\n\n", szResult);	//TODO: error/log reporting feature

    return 1;
}


char *gettag(char needle[48], char *xml, char *starttag, char *endtag)
{

    char *start;
    char *end;

    *needle = 0;

    if (!(start = strstr(xml, starttag))) {
	return "";
    }

    start = start + strlen(starttag);

    if (!(end = strstr(start, endtag))) {
	return "";
    }

    strncpy(needle, start, strlen(start) - strlen(end));

    needle[strlen(start) - strlen(end)] = 0;

    if (strlen(needle) > 48) {
	return "";
    }
    /* we do not return the needle but the everthing after needle was
       found this is so we can cal gettag several times (ie
       pp_history()) */
    return start;
}


int serv_send(char *resp, char *title, char *content)
{
    char header[1024];
    //*response = 0;
    *title = 0;

    if (strcmp(rs, "") == 0) {
	strcpy(header, header_plain);
	strcpy(contentbuf, content);
    } else {
	sprintf(header, header_act, rs);
	sprintf(contentbuf, "%s&auth=%s\n", content, auth);
    }

    sprintf(request, "%sContent-length: %i\n\n%s", header,
	    strlen(contentbuf), contentbuf);

    if (!sslcat(resp, request))
	return 0;

    gettag(title, resp, "title=\"", "\"");

    if (strcmp(title, "") == 0) {
	fprintf(stderr,
		"Error: Unable to parse response - no title tag found\n");
	return 0;
    }
    return 1;
}



void pp_debugmode(int debugmode)
{
    debug = debugmode;
}

int pp_logout()
{
    return serv_send(response, title, content_logout);
}

int pp_login(char *login, char *pass)
{

    //a new login - clear the old globals
    *rs = 0;
    *auth = 0;
    *balance = 0;

    //create xml header
    sprintf(contentbuf, content_login, login, pass);
    //sprintf(request, "%sContent-length: %i\n\n%s", header_plain, strlen(contentbuf), contentbuf);
    serv_send(response, title, contentbuf);

    gettag(title, response, "title=\"", "\"");

    if (strcmp(title, "") == 0) {
	fprintf(stderr,
		"Error: Unable to parse response - no title tag found\n");
	return 0;
    }

    if (strcmp(title, "Login Failed") == 0) {
	return 0;
    }

    gettag(auth, response, tag_auth, "\"");
    if (strcmp(auth, "") == 0) {
	fprintf(stderr, "Error: Unable to parse response - no auth tag\n");
	return 0;
    }

    gettag(balance, response, "Balance: $$", "<br");
    if (strcmp(balance, "") == 0) {
	fprintf(stderr,
		"Error: Unable to parse response - no balance tag\n");
	return 0;
    }

    gettag(rs, response, "<go href=\"/cgi-bin/phscr?rs=", "\"");
    if (strcmp(rs, "") == 0) {
	fprintf(stderr,
		"Error: Unable to parse response - no rs tag found\n");
	return 0;
    }
    //TODO: account capabilities? recieve but not send etc.
    return atoi(rs);
}

float pp_getbalance()
{
    int dollar = 0;
    int cent = 0;
    char *p;

    if (strcmp(balance, "") == 0) {
	if (debug)
	    fprintf(stderr, "balance error - not logged in\n");
	return 0;
    }

    if ((p = strstr(balance, "."))) {
	p++;
	cent = atoi(p);
	if (strlen(p) == 1) {
	    cent *= 10;
	}
	dollar = atoi(balance);
    } else {
	dollar = atoi(balance);
    }

    return (dollar + cent * 0.01);

    // TODO: If returning 0 for an account with $0.00 is valid, how do you return an error condition? - alp
}

int pp_history(char *history)
{
    char transbuf[48];
    char *trans;
    *history = 0;

    serv_send(response, title, content_hist);
    trans = gettag(title, response, "title=\"", "\"");

    while (strcmp(trans, "") != 0) {
	trans = gettag(transbuf, trans, "<anchor>$", "<");
	strcat(history, transbuf);
	strcat(history, "\n");
    }
    history[strlen(history) - 1] = 0;

    return 1;
}


int pp_send(char *recipent, int dollar, int cent)
{
    sprintf(contentbuf, content_pay, recipent, dollar, cent);
    serv_send(response, title, contentbuf);
    if (strcmp(title, "Incorrect Entry") == 0) {
	fprintf(stderr, "Not enough credit\n");
	return 0;
    }
    if (strcmp(title, "Payment Successful") == 0) {
	gettag(balance, response, "New balance: $$", "<br");
	if (strcmp(balance, "") == 0) {
	    if (debug)
		fprintf(stderr,
			"Error: Unable to parse response - no balance tag\n");
	    return 0;
	} else
	    return 1;
    } else
	return 0;
}

int pp_request(char *recipent, int dollar, int cent)
{
    sprintf(contentbuf, content_req, recipent, dollar, cent);
    serv_send(response, title, contentbuf);
    if (strcmp(title, "Payment Successful") == 0)
	return 1;
    else
	return 0;
}
