/*
 * gpal - A friendly GUI frontend for the PayPal micropayment service
 * Copyright (C) 2001 Alp Toker <alp@atoker.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#include "extra/gpal.xpm"
#include "extra/back.xpm"
#include "extra/next.xpm"
#include "extra/spark.xpm"
#include "extra/que.xpm"

#include "libgpal.h"
#include "gpal.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>


void rot13(char *s)
{
  /* If anyone gets access to your password file, you are already
    screwed. This is here only to provide protection from the most
    casual password burglars. I put this together in about 30 secs, it
    only works for upper/lower case text, not symbols or numbers. Not
    that it matters. */

    //TODO: Behaviour undefined with 'bad' input from file.

  int i;

    for (i = 0; i < strlen(s); i++) {
	if (s[i] > 96 && s[i] < 123)
	    s[i] = ((s[i] - 84) % 26) + 97;
	if (s[i] > 64 && s[i] < 91)
	    s[i] = ((s[i] - 52) % 26) + 65;
    }
}

int main(int argc, char *argv[])
{
    char buff[1024];
    int i;

    FILE *confFile;
    char confFileName[512];

    GtkWidget *window1;
    GtkWidget *login, *entry1, *entry0;
    GtkWidget *checkbox1;

    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;

#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain(PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);

    //  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
    //  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

    /*
     * The following code was added by Glade to create one of each component
     * (except popup menus), just so that you see something after building
     * the project. Delete any components that you don't want shown initially.
     */

    pp_debugmode((getopt(argc, argv, "v") == 118));

    window1 = create_window1();
    gtk_widget_realize(window1);
    entry0 = lookup_widget(GTK_WIDGET(window1), "entry0");
    entry1 = lookup_widget(GTK_WIDGET(window1), "entry1");
    login = lookup_widget(GTK_WIDGET(window1), "login");
    checkbox1 = lookup_widget(GTK_WIDGET(window1), "checkbutton1");


    style = gtk_widget_get_style(login);

    pixmap =
	gdk_pixmap_create_from_xpm_d(window1->window, &mask,
				     &style->bg[GTK_STATE_NORMAL],
				     (gchar **) que_xpm);
    gtk_pixmap_set(GTK_PIXMAP
		   (lookup_widget(GTK_WIDGET(window1), "pixmap7")), pixmap,
		   mask);

    pixmap =
	gdk_pixmap_create_from_xpm_d(window1->window, &mask,
				     &style->bg[GTK_STATE_NORMAL],
				     (gchar **) gpal_xpm);
    gtk_pixmap_set(GTK_PIXMAP
		   (lookup_widget(GTK_WIDGET(window1), "pixmap6")), pixmap,
		   mask);

    pixmap =
	gdk_pixmap_create_from_xpm_d(window1->window, &mask,
				     &style->bg[GTK_STATE_NORMAL],
				     (gchar **) spark_xpm);
    gtk_pixmap_set(GTK_PIXMAP
		   (lookup_widget(GTK_WIDGET(window1), "pixmap5")), pixmap,
		   mask);

    pixmap =
	gdk_pixmap_create_from_xpm_d(window1->window, &mask,
				     &style->bg[GTK_STATE_NORMAL],
				     (gchar **) back_xpm);
    gtk_pixmap_set(GTK_PIXMAP
		   (lookup_widget(GTK_WIDGET(window1), "pixmap4")), pixmap,
		   mask);

    pixmap =
	gdk_pixmap_create_from_xpm_d(window1->window, &mask,
				     &style->bg[GTK_STATE_NORMAL],
				     (gchar **) next_xpm);
    gtk_pixmap_set(GTK_PIXMAP
		   (lookup_widget(GTK_WIDGET(window1), "pixmap3")), pixmap,
		   mask);

    change_stat(window1, 0);	//offline

    snprintf(confFileName, sizeof(confFileName), "%s/.gpal",
	     getenv("HOME"));

    // read dotfile
    i = 0;
    if ((confFile = fopen(confFileName, "r"))) {
	while (fgets(buff, sizeof(buff), confFile)) {
	    buff[strlen(buff) - 1] = 0;	//remove newline
	    switch (i) {
	    case 0:
		gtk_entry_set_text(GTK_ENTRY(entry0), buff);
		if (strcmp(buff,"")==0) {gtk_widget_grab_focus(entry0); i=1;}
		break;

	    case 1:
		rot13(buff);
		gtk_entry_set_text(GTK_ENTRY(entry1), buff);
		if (strcmp(buff,"")==0) gtk_widget_grab_focus(entry1); else
		gtk_widget_grab_focus(login);
		break;

	    case 2:
		if (atoi(buff))
		    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
						 (checkbox1), 1);
		break;
	    }
	    i++;
	}
    }
	

    validate(window1);
    rec_event(GTK_WIDGET(window1), g_strdup_printf(_("gPal %s"), VERSION));

    gtk_widget_show(window1);
    gtk_main();

    // save dotfile
    if ((confFile = fopen(confFileName, "w"))) {
	chmod(confFileName, 0600);	//only user can read/write
	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox1)))
	    strcpy(apass, "");
	rot13(apass);
	    fprintf(confFile, "%s\n%s\n%i\n", alogin, apass,
	    	gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
	    			     (checkbox1)));
	fclose(confFile);
    }

    return 0;
}

int validate_mail(char *mailaddr)
{
    // TODO: better validity check for email addresses
    return (strlen(mailaddr) > 3 && strstr(mailaddr, "@"));
}

void validate(GtkWidget * editable)
{
    GtkWidget *login = lookup_widget(GTK_WIDGET(editable), "login");
    GtkWidget *entry0 = lookup_widget(GTK_WIDGET(editable), "entry0");
    GtkWidget *entry1 = lookup_widget(GTK_WIDGET(editable), "entry1");

    GtkWidget *entry3 = lookup_widget(GTK_WIDGET(editable), "entry3");
    GtkWidget *entry4 = lookup_widget(GTK_WIDGET(editable), "entry4");
    GtkWidget *sndreq = lookup_widget(GTK_WIDGET(editable), "hbox6");

    strncpy(alogin, gtk_entry_get_text(GTK_ENTRY(entry0)), sizeof(alogin));
    strncpy(apass, gtk_entry_get_text(GTK_ENTRY(entry1)), sizeof(apass));

    gtk_widget_set_sensitive(login,
			     (strlen(apass) > 7 && validate_mail(alogin)));
    //TODO: better amount validation
    gtk_widget_set_sensitive(sndreq,
			     (strlen(gtk_entry_get_text(GTK_ENTRY(entry4)))
			      > 0
			      &&
			      validate_mail(gtk_entry_get_text
					    (GTK_ENTRY(entry3)))));

}

void change_stat(GtkWidget * button, int status)
{
    GtkWidget *frame3 = lookup_widget(GTK_WIDGET(button), "frame3");
    GtkWidget *frame1 = lookup_widget(GTK_WIDGET(button), "frame1");
    GtkWidget *table2 = lookup_widget(GTK_WIDGET(button), "table2");
    GtkWidget *label17 = lookup_widget(GTK_WIDGET(button), "label17");
    GtkWidget *linestat = lookup_widget(GTK_WIDGET(button), "linestat");

    gtk_widget_set_sensitive(table2, status ^ 1);

    gtk_widget_set_sensitive(frame1, status);
    gtk_widget_set_sensitive(frame3, status);

    if (status == 0) {
	gtk_label_set_text(GTK_LABEL(label17), _("Log on!"));
	gtk_label_set_text(GTK_LABEL(linestat), _("offline"));
	gtk_entry_set_text(GTK_ENTRY
			   (lookup_widget(GTK_WIDGET(button), "entry2")),
			   "");
	gtk_entry_set_text(GTK_ENTRY
			   (lookup_widget(GTK_WIDGET(button), "entry3")),
			   "");
	gtk_entry_set_text(GTK_ENTRY
			   (lookup_widget(GTK_WIDGET(button), "entry4")),
			   "");
    } else {
	gtk_label_set_text(GTK_LABEL(label17), _("Log off!"));
	gtk_label_set_text(GTK_LABEL(linestat), _("online"));
    }

    line_status = status;
}

void rec_event(GtkWidget * button, char *message)
{
    GtkWidget *msgstat = lookup_widget(GTK_WIDGET(button), "msgstat");
    gtk_label_set_text(GTK_LABEL(msgstat), message);
}
