# File.pm - File handling library for Gutenbook
# http://www.gutenbook.org/
# Copyright (C) 2000  Lee "Lefty" Burgess
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# This library module contains code contributed by Chris Gray <cgray@nowonder.com>

package PGB::File;
  
use PGB;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
  
require Exporter;
require AutoLoader;
 
@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(file_get file_save);
$VERSION = '0.01';

sub file_get( $ );
sub file_save( $$ );
  
sub file_get( $ ){
  my ($file) = @_;
  my $fh;
  my $array;
  
  # if we are getting a zip file, must uncompress it into memory
  if ($file =~ /\.zip$/) {
    my $output;
    BUG_ME(0, "FILE: Got zip file, uncompressing $file...");
    
    $output = `$unzip -p $file`;
    @{$array} = split(/\n/, $output);
    
    foreach (@{$array}) {
      $_ .= "\n";
    }
  }
  else {
    BUG_ME(0, "FILE: Got txt file $file...");
    $fh = new FileHandle($file, "r") || BUG_ME(1, "Cannot read $file: $!");
    if (defined($fh)) {
      while (<$fh>) {
	push(@{$array}, $_);
      }
      $fh->close();
    }
  }    
  
  return($array);
}

sub file_save( $$ ){
  my ($path, $arrayref) = @_;
  my ($file, $dir, $tmpfile);
  my $fh;
  
  # if we are getting a zip file, we will write a txt file
  if ($path =~ /\.zip$/) {
    ($file, $dir) = fileparse($path);
    $path =~ s/zip$/txt/;
  }
  
  $fh = new FileHandle($path, "w") || BUG_ME(1, "Cannot write $file: $!");
  if (defined($fh)) {
    foreach (@{$arrayref}) {
      $fh->print($_);
    }
    $fh->close();
  }
  
  # if we are getting a zip file, now compress it 
  if (defined($file) && $file =~ /\.zip$/) {
    ($tmpfile, undef) = fileparse($path);
    system("cd $dir && $zip -q $file $tmpfile");
    unlink($path) || BUG_ME(0, "Cannot remove $tmpfile: $!");
  }
}

1;
