# Gutenbook Proposal/Specification
# http://www.gutenbook.org/
# Copyright (C) 2000  Lee "Lefty" Burgess
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Proposal and Specification for Gutenbook: Project Gutenberg Etext
Document Reader 
 
* Overview:

Project Gutenberg (http://promo.net/pg/index.html) aims to make public 
domain literature available to the world in ASCII text format.  

This project, Gutenbook, intends to produce a GPL graphical document
reader for Gutenberg Etext documents.

** Purpose:

Gutenbook aims to be a free and more intuitive, comfortable document
reader, within the scope of a computer's desktop metaphor, geared
specifically toward Project Gutenberg Etexts, but supporting any ASCII 
document.

** Explanation:

Project Gutenberg chose well in making ASCII text the format of all
its electroscribed documents.  ASCII is a standard in information
dissemination that is most practical, efficient and affordable.  ASCII
is not proprietary; therefore it requires no proprietary document
reader. All systems support ASCII.  Documents in ASCII, so long as
they are made available at all, are available to everyone.

However, documents of great length can be somewhat difficult to read
in ASCII, given the current methods for reading text.  Simple
paginated programs like more/less have the basest functionality
necessary for reading text.  Yet they are more suited to allowing the
user to efficiently extract information for smaller documents.  Text
editors, word processors and Web browsers, while better suited to
creating and displaying larger documents, still do not allow a user to 
comfortably and leisurely read a large document.

At this point in time, humans are still bound to the paradigm of the
physical book as the most enjoyable and comfortable means of reading.
Even document viewers such at Acrobat Reader (which supports a
proprietary document format) fall short of simulating a comfortable
reading experience for two important reasons.  First, sitting at a
desk reading from a computer screen, no matter how ergonomic, will
never be as comfortable holding a book and lounging in a chair or
couch.  Second, even though the display format of the viewer can be
modified to resemble physical pages, the mechanism for viewing the
pages still relies on a scrolling widget interface or keyboard bindings for
paging back and forth.  While the interface attributes are not in
themselves clumsy, the options for displaying pages does not allow
them to be used intuitively.

Even physical devices like Palm Pilots, SoftBooks or Rocket EBooks
have shortcomings.   While the size of the device allows the user to
be disassociated from the computer desk, the size or mere presence of
the screen can be a hindrance to enjoyable reading.  Also, while these 
devices may allow the user greater access to newer titles, those
titles are still proprietary (in cost and format).

Therefore, Gutenbook attempts to confront some of these issues, but
not all of them.  Gutenbook will operate on two premises.  First,
Project Gutenberg is successful at making literature freely available
in a universal format.  Second, reading literature on the computer,
while never a comfortable as reading a book in a hammock, can be more 
comfortable than many programs currently allow.

* Features:

Gutenbook will employ as many features as possible to allow a user to
read a piece of literature on their computer as comfortably and
intuitively as possible.

** Ability to select and download titles from Project Gutenberg Etext archives.

Gutenbook will have built-in functionality allowing automatic
downloading of Project Gutenberg Etext index files.  Once downloaded,
the indices will be repesented in a browsable format, or "library".
The user will be able to select a title which will downloaded.  The
document will then be presented to the reader for viewing.  Should a
document already exist in on the user's system it will not downloaded
but will be presented.  To this end, titles in the library will
indicate if they are present locally or not.  The use will also be
able to search and sort the library.

** Dual page display with book-like pagination

Gutenbook will employ a traditional book metaphor for the actual
display of a document.  Two "pages" will be presented to the reader,
side by side in a fashion resembling the pages of a book.  The pages
will be static areas with no scrolling widgets. Keybindings, buttons
or mouse events will allow the user to move forward and backward in
the document.

** Ability to bookmark content

Gutenbook will allow a reader to bookmark documents.  The user can
bookmark an area of content, adding a key to a bookmarks data
structure and file assocciated with that document.  The user will be
prompted for a name and description of the bookmark which will
accompany the document position information the bookmark will store.

Bookmarks will have a browsable interface, allowing the reader to
select a bookmark and be presented with the document at the position
the bookmark records.  Bookmarks can also be modified, moved or
removed. 

** Ability to annotate content

Gutenbook will allow the reader to annotate a document in a manner
similar to bookmarking.  Annotations will be associated with a
position in the document and stored in a data structure as well as a
text file.  Annotations will also be browsable and editable.

** Ability to print

Gutenbook will have printing features.  The user will be able to print 
a "page", a range of "pages" or the whole document in plaintext or
PostScript.

** Ability to scale the viewable size of the document

Gutenbook will have an interface for selection the resolution of the
application.  That is, Gutenbook will have a default window size of
800x600, but the user will be able to scale the window to a number of
other resolutions. 

** Support for selection of and scalability of font size

Gutenbook will have an interface for selecting the font the document
is displayed in.  This feature will be tied to the resolution feature
in that scaling with window size will also scale the font.

* Design:

Gutenbook is a project I have decided to accomplish in my spare time.
It is also a project that will allow me to enhance my programming
skills as well as learn new programming languages and techniques.  As
such, Gutenbook will have three design phases.  Besides allowing me to 
work will several languages, the phases of design will allow me to
concentrate on particular features at particular times before moving
on to other features and the next phase.  The result will be a quality 
program for the Free Software community.

Gutenbook will be written with the GTK+ graphical toolkit.  GTK+ is
free, GNU software, well supported and well documented.  It has
bindings for a number of programming languages making it more than
ideal for this free software project.

I plan on making the code for Gutenbook freely available during the
entire development process.  

** Phase 1: Prototyping, basic features

Gutenbook will be prototyped in Perl/GTK+.  I have the most experience 
with Perl.  Perl allows for rapid prototyping and accommodates object
oriented design.  The GTK+ bindings for Perl are not complete but
sufficient to create a basic application with the essential features.

** Phase 2: Enhanced Prototyping, more features

Gutenbook will then be ported for further prototyping and feature
coding to Objective C. Objective C is a fully object oriented superset 
of C.  I also have experience writing Objective C using the OpenStep
implementation (Foundation Classes, Enterprise Object Framework,
WebObjects).  Gutenbook will be written in this phase with GNU
Objective C and GNUStep (GNU's OpenStep implementation).  The
Foundation Classes in conjunction with the GTK+ Objective C bindings
provide a rich programming environment for the transitional stage for
Gutenbook and the development of the majority of the programs features.

** Phase 3: Final Port, feature freeze

Gutenbook will finally be ported to straight C, using the native calls 
to GTK+.  It will also take advantage of the libraries provided by the 
GDK and GLIB.  This phase will see a freeze in feature development in
order to concentrate on quality and debugging.

