#include "navstore.h"
#ifndef __dtutilsh__
  #include "dtutils.h"
#endif
#ifndef __errorh__
  #include "error.h"
#endif
#ifndef __htmlh__
  #include "html.h"
#endif
#ifndef __hitopcommandsh__
  #include "hitopcommands.h"
#endif

void NavStore::addtolevel(HTMLStream::iterator Cur,int level,const string& title,const string& value) {
  if (level>0) {
    if (m_children.empty()) Error(*Cur,"Invalid Nav file - no parent listed");
    m_children.back().addtolevel(Cur,level-1,title,value);
  } else {
    m_children.push_back(NavStore(title,value));
    ++m_countkids;
  }
}

bool NavStore::verify(HTMLStream::iterator Cur,const string& buildfile,OutputFormat format) {
  int max=0;
  for(list<NavStore>::iterator i=m_children.begin();i != m_children.end();++i) {
    if (i->verify(Cur,buildfile,format)) m_open=true;
    if (((format==of_open)||(i->m_open))&&(i->m_levels>=max)) {
      max=i->m_levels+1;
    }
  }
  if (!m_children.empty()) {
    if(!m_url.empty()) {
      Error(*Cur,"Menu entry can not have URLs in NAV file");
    }
    m_url=m_children.begin()->m_url;
  }
  if (m_url.empty()) {
    Error(*Cur,"Missing URL in NAV file");
  }
  m_levels=max;
  if (m_url==buildfile) m_open=true;
  if ((format==of_open)&&(!m_children.empty())) m_open=true;
  return (m_open);
}

void NavStore::DoOpen(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,TokenMap::Token preToken,TokenMap::Token entryToken,TokenMap::Token postToken,int from,int to,int highest,int level) {
  if (to==-1) to=m_levels-1;
  if (highest==0) highest=m_levels-1;
  if (highest>to) highest=to;
  if ((to<from)&&(from==0)) to=from; //must display something!
  ParamMap prePostParam(paramMap);
  ParamMap entryParam(paramMap);

  prePostParam["LEVEL"]=IToS(level);
  prePostParam["HIGHEST"]=IToS(highest);
  prePostParam["TOTAL"]=IToS(m_countkids);

  if ((level>=from)&&(level<=to)) {
    if (preToken!=-1) {
      HitopCommands::ProcCallByNum(stream,Cur,prePostParam,preToken);
    } else {
      DefaultOpenPre(stream,Cur,level);
    }
  }

  entryParam=prePostParam;

  int position=0;
  for(list<NavStore>::iterator i=m_children.begin();i!=m_children.end();++i) {
    ++position;
    if ((level>=from)&&(level<=to)) {
      entryParam["NAME"]=i->m_title;
      entryParam["HREF"]=i->m_url;
      entryParam["POSITION"]=IToS(position);
      entryParam["TYPE"]=((i->m_countkids==0)?'0':'1');
      entryParam["OPEN"]=(i->m_open?'1':'0');
      entryParam["SELECT"]=(i->m_open?(i->m_countkids==0?'1':'2'):'0');
      if (entryToken!=-1) {
        HitopCommands::ProcCallByNum(stream,Cur,entryParam,entryToken);
      } else {
        i->DefaultOpenEntry(stream,Cur,level,position==m_countkids);
      }
    }

    if (i->m_open && !(i->m_children.empty())) i->DoOpen(stream,Cur,paramMap,preToken,entryToken,postToken,from,to,highest,level+1);
  }

  if ((level>=from)&&(level<=to)) {
    if (postToken!=-1) {
      HitopCommands::ProcCallByNum(stream,Cur,prePostParam,postToken);
    } else {
      DefaultOpenPost(stream,Cur,level);
    }
  }

}

void NavStore::DoFlat(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,TokenMap::Token preToken,TokenMap::Token entryToken,TokenMap::Token postToken,int from,int to,int highest,int level) {
  if (to==-1) to=m_levels-1;
  if (highest==0) highest=m_levels-1;
  if (highest>to) highest=to;
  if ((to<from)&&(from==0)) to=from; //must display something!
  ParamMap prePostParam(paramMap);
  ParamMap entryParam(paramMap);

  prePostParam["LEVEL"]=IToS(level);
  prePostParam["HIGHEST"]=IToS(highest);
  prePostParam["TOTAL"]=IToS(m_countkids);

  if ((level>=from)&&(level<=to)) {
    if (preToken!=-1) {
      HitopCommands::ProcCallByNum(stream,Cur,prePostParam,preToken);
    } else {
      DefaultFlatPre(stream,Cur,level);
    }
  }

  entryParam=prePostParam;

  if ((level>=from)&&(level<=to)) {
    int position=0;
    for(list<NavStore>::iterator i=m_children.begin();i!=m_children.end();++i) {
      ++position;
      entryParam["NAME"]=i->m_title;
      entryParam["HREF"]=i->m_url;
      entryParam["POSITION"]=IToS(position);
      entryParam["TYPE"]=((i->m_countkids==0)?'0':'1');
      entryParam["OPEN"]=(i->m_open?'1':'0');
      entryParam["SELECT"]=(i->m_open?(i->m_countkids==0?'1':'2'):'0');
      if (entryToken!=-1) {
        HitopCommands::ProcCallByNum(stream,Cur,entryParam,entryToken);
      } else {
        i->DefaultFlatEntry(stream,Cur,level,position==m_countkids);
      }
    }
  }

  if ((level>=from)&&(level<=to)) {
    if (postToken!=-1) {
      HitopCommands::ProcCallByNum(stream,Cur,prePostParam,postToken);
    } else {
      DefaultFlatPost(stream,Cur,level);
    }
  }

  for(list<NavStore>::iterator i=m_children.begin();i!=m_children.end();++i) {
    if (i->m_open) i->DoFlat(stream,Cur,paramMap,preToken,entryToken,postToken,from,to,highest,level+1);
  }


}


void NavStore::DefaultOpenPre(HTMLStream& stream,HTMLStream::iterator Cur,int level) {};

void NavStore::DefaultOpenEntry(HTMLStream& stream,HTMLStream::iterator Cur,int level,bool last) {
  string Text;
  for(int j=0;j<level;++j){
    Text+="&nbsp;&nbsp;&nbsp;";
  }
  Text+="&middot;&nbsp;";
  stream.m_stream.insert(Cur,HTML(HTML::Text,Text));
  if (!m_open) stream.m_stream.insert(Cur,HTML(HTML::Markup,"A HREF=\""+m_url+"\""));
  stream.m_stream.insert(Cur,HTML(HTML::Text,m_title));
  if (!m_open) stream.m_stream.insert(Cur,HTML(HTML::Markup,"/A"));
  stream.m_stream.insert(Cur,HTML(HTML::Markup,"BR"));
};

void NavStore::DefaultOpenPost(HTMLStream& stream,HTMLStream::iterator Cur,int level) {};

void NavStore::DefaultFlatPre(HTMLStream& stream,HTMLStream::iterator Cur,int level) {};

void NavStore::DefaultFlatEntry(HTMLStream& stream,HTMLStream::iterator Cur,int level,bool last) {
  if (!m_open) stream.m_stream.insert(Cur,HTML(HTML::Markup,"A HREF=\""+m_url+"\""));
  stream.m_stream.insert(Cur,HTML(HTML::Text,m_title));
  if (!m_open) stream.m_stream.insert(Cur,HTML(HTML::Markup,"/A"));
  if (!last) stream.m_stream.insert(Cur,HTML(HTML::Text,"&nbsp;|&nbsp;"));
};

void NavStore::DefaultFlatPost(HTMLStream& stream,HTMLStream::iterator Cur,int level) {
  stream.m_stream.insert(Cur,HTML(HTML::Markup,"BR"));
};

