#ifndef __htmlstreamh__
  #include "../htmlstream.h"
#endif

#ifndef __htmlh__
  #include "../html.h"
#endif

#ifndef __stringproch__
  #include "../stringproc.h"
#endif

#ifndef __pluginh__
  #include "../plugin.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoItalianoMod :public Plugin{
public:
  dsoItalianoMod();
  virtual void Init();
private:
  static void DAYNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYABBREV(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHABBREV(const HTML& Cur,string& data,const vector<string>& params);
};

static dsoItalianoMod initmodule;

static const string daynames[]={"domenica","luned&iacute;","marted&iacute;",
  "mercoled&iacute;","gioved&iacute;","venerd&iacute;","sabato"};
static const string monthnames[]={"gennaio","febbraio","marzo","aprile",
  "maggio","giugno","luglio","agosto","settembre","ottobre","novembre",
  "dicembre"};
static const string dayshortnames[]={"dom","lun","mar","mer","gio","ven",
  "sab"};
static const string monthshortnames[]={"gen","feb","mar","apr","mag","giu",
  "lug","ago","set","ott","nov","dic"};
static const string dayabbrevs[]={"d","l","ma","me","g","v","s"};
static const string monthabbrevs[]={"ge","f","mr","ap","mg","gi","l","a","s",
  "o","n","d"};

dsoItalianoMod::dsoItalianoMod() {
  RegisterPlugin(string("italiano"),1);
}

void dsoItalianoMod::Init(){
  SetNamespace("ITALIANO");
  RegisterFunction("DAYNAME",&DAYNAME);
  RegisterFunction("MONTHNAME",&MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&DAYABBREV);
  RegisterFunction("MONTHABBREV",&MONTHABBREV);
}

void dsoItalianoMod::DAYNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[atoi(data.c_str())%7];
}

void dsoItalianoMod::MONTHNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(atoi(data.c_str())-1)%12];
}

void dsoItalianoMod::DAYSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[atoi(data.c_str())%7];
}

void dsoItalianoMod::MONTHSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(atoi(data.c_str())-1)%12];
}

void dsoItalianoMod::DAYABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[atoi(data.c_str())%7];
}

void dsoItalianoMod::MONTHABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(atoi(data.c_str())-1)%12];
}
