#include "png.h"

bool IsPNG(FILE *file){
  unsigned char header[10];
  if(fseek(file,0,SEEK_SET)!=0) return false;
  if(fread(header,1,8,file)!=8) return false;
  if(memcmp(header,"\211PNG\r\n\032\n",8)==0) return true; 
  return false;
}

bool PNGSize(FILE *file, int& height, int& width){
  unsigned char length[4];
  if(fseek(file,8+4+4,SEEK_SET)!=0) return false;
  if(fread(&length,4,1,file)!=1) return false;
  width = int(length[0])<<24 | int(length[1])<<16 |
      int(length[2])<<8 | int(length[3]);
  if(fread(&length,4,1,file)!=1) return false;
  height = int(length[0])<<24 | int(length[1])<<16 |
      int(length[2])<<8 | int(length[3]);
  return true;
}
