#ifndef __stringproch__
#define __stringproch__

#include <string>
#include <vector>
#include <map>

class HTML;

class StringProc {
public:
  static void ProcessString(const HTML& Cur,string& data,const string& inst);
  typedef void (*actionFunction)(const HTML&,string&,const vector<string>&);
  static void RegisterFunction(const string& name,actionFunction procedure);
  static void UnregisterFunction(const string& name,actionFunction procedure);
private:
  static map<string,actionFunction> actionMap;
  static bool actionMapInitialized;
  static void RANDOM(const HTML& Cur,string& data,const vector<string>& params);
  static void REPEAT(const HTML& Cur,string& data,const vector<string>& params);
  static void LENGTH(const HTML& Cur,string& data,const vector<string>& params);
  static void FREQ(const HTML& Cur,string& data,const vector<string>& params);
  static void REPLACE(const HTML& Cur,string& data,const vector<string>& params);
  static void UPCASE(const HTML& Cur,string& data,const vector<string>& params);
  static void DOWNCASE(const HTML& Cur,string& data,const vector<string>& params);
  static void REMOVENOTOF(const HTML& cur,string& data,const vector<string>& params);
  static void ESCAPEURL(const HTML& Cur,string& data,const vector<string>& params);
  static void UNESCAPEURL(const HTML& Cur,string& data,const vector<string>& params);
  static void ESCAPECHARS(const HTML& Cur,string& data,const vector<string>& params);
  static void UNESCAPECHARS(const HTML& Cur,string& data,const vector<string>& params);
  static void EVAL(const HTML& Cur,string& data,const vector<string>& params);
  static void MID(const HTML& Cur,string& data,const vector<string>& params);
  static void LEFT(const HTML& Cur,string& data,const vector<string>& params);
  static void RIGHT(const HTML& Cur,string& data,const vector<string>& params);
  static void PADLEFT(const HTML& Cur,string& data,const vector<string>& params);
  static void PADRIGHT(const HTML& Cur,string& data,const vector<string>& params);
  static void BEFORE(const HTML& Cur,string& data,const vector<string>& params);
  static void AFTER(const HTML& Cur,string& data,const vector<string>& params);
  static void REVERSE(const HTML& Cur,string& data,const vector<string>& params);
  static void WORDS(const HTML& Cur,string& data,const vector<string>& params);
  static void WORDSPAN(const HTML& Cur,string& data,const vector<string>& params);
  static void WORD(const HTML& Cur,string& data,const vector<string>& params);
  static void DATETODAYNUM(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYNUMTODATE(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYOFWEEK(const HTML& Cur,string& data,const vector<string>& params);
  static void C2X(const HTML& Cur,string& data,const vector<string>& params);
  static void D2X(const HTML& Cur,string& data,const vector<string>& params);
  static void ROMAN(const HTML& Cur,string& data,const vector<string>& params);
  static void InitializeActionMap();
  class notin;
};

#endif
