#include "vars.h"
#ifndef __stringproch__
  #include "stringproc.h"
#endif
#ifndef __hitopcoreh__
  #include "hitopcore.h"
#endif
#ifndef __htmlh__
  #include "html.h"
#endif
#include <fstream>

class HTML;

bool Vars::IsDefEngine(const string& name)const{
  if(m_map.find(name)!=m_map.end()) return true;
  if(m_parent!=NULL) return m_parent->IsDefEngine(name);
  return false;
}

bool Vars::IsDefName(string name)const{
  if(!g_isXML) transform(name.begin(),name.end(),name.begin(),toupper);
  return IsDefEngine(name);
}

/*bool Vars::IsEvaluatable(const string& name)const {
  string::const_iterator pos=name.begin();
  if(pos==name.end()) return false;
  char first=name[0];
  if((first=='\'')||(first=='"')){
    ++pos;
    pos=find(pos,name.end(),first);
    if(pos==name.end()) return false;
    ++pos;
    return (pos==name.end())||(*pos==':');
  }else{
    pos=find(name.begin(),name.end(),':');
    return IsDefName(string(name.begin(),pos));
  }
}*/

bool Vars::GetEngine(const string& name,string& value)const{
  map<string,string>::const_iterator pos=m_map.find(name);
  if(pos!=m_map.end()){
    value=pos->second;
    return true;
  }
  if(m_parent!=NULL) return m_parent->GetEngine(name,value);
  return false;
}

/*string Vars::GetEngine(const string& name)const{
  map<string,string>::const_iterator pos=m_map.find(name);
  if(pos!=m_map.end()) return pos->second;
  if(m_parent!=NULL) return m_parent->GetEngine(name);
  return "";
}*/

bool Vars::Get(const HTML& curHTML,string name,string& value)const{
  string::iterator pos=name.begin(),sec;
  if(pos==name.end()) return false;
  char first=name[0];
  if((first=='\'')||(first=='"')){
    ++pos;
    sec=find(pos,name.end(),first);
    value.assign(pos,sec);
    pos=sec+1;
  }else{
    sec=find(name.begin(),name.end(),':');
    string name(pos,sec);
    if(!g_isXML) transform(name.begin(),name.end(),name.begin(),toupper);
    if(!GetEngine(name,value)) return false;
    pos=sec;
  }
  if(pos==name.end()) return true;
  StringProc::ProcessString(curHTML,value,string(++pos,name.end()));
  return true;
}

/*string Vars::Get(const HTML& curHTML,string name)const{
  string content;
  char first=name[0];
  string::iterator pos=name.begin(),sec;
  if((first=='\'')||(first=='"')){
    ++pos;
    sec=find(pos,name.end(),first);
    content.assign(pos,sec);
    pos=sec+1;
  }else{
    sec=find(name.begin(),name.end(),':');
    content=GetEngine(string(pos,sec));
    pos=sec;
  }
  if(pos==name.end()) return content;
  StringProc::ProcessString(curHTML,content,string(++pos,name.end()));
  return content;
}*/

static const string g_first("ABCDEFGHIJKLMNOPQRSTUVWXYZ_");
static const string g_rest("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_");

bool Vars::IsValidVarName(const string& name){
  string::const_iterator pos=name.begin();
  if((pos==name.end())||(find(g_first.begin(),g_first.end(),*pos)==g_first.end()))  return false;
  ++pos;
  while(pos!=name.end()){
    if(find(g_rest.begin(),g_rest.end(),*pos)==g_rest.end()) return false;
    ++pos;
  }
  return true;
}

bool Vars::SetEngine(const string& name,const string& value,
  Scope scope){
  switch(scope){
  case Local:
    m_map[name]=value;
    break;
  case Parent:
    if(m_parent==NULL){
      m_map[name]=value;
    }else{
      m_map.erase(name);
      m_parent->SetEngine(name,value,Local);
    }
    break;
  case Global:
    if(m_parent==NULL){
      m_map[name]=value;
    }else{
      m_map.erase(name);
      m_parent->SetEngine(name,value,Global);
    }
    break;
  }
  return true;
}

bool Vars::Set(string name,const string& value,Scope scope){
  if(!g_isXML) transform(name.begin(),name.end(),name.begin(),toupper);
  if(!IsValidVarName(name)) return false;
  return SetEngine(name,value,scope);
}

bool Vars::UnsetEngine(const string& name,Scope scope){
  switch(scope){
  case Local:
    m_map.erase(name);
    break;
  case Parent:
    m_map.erase(name);
    if(m_parent!=NULL) m_parent->UnsetEngine(name,Local);
    break;
  case Global:
    m_map.erase(name);
    if(m_parent!=NULL) m_parent->UnsetEngine(name,Global);
    break;
  }
  return true;
}

bool Vars::Unset(string name,Scope scope){
  if(!g_isXML) transform(name.begin(),name.end(),name.begin(),toupper);
  if(!IsValidVarName(name)) return false;
  return UnsetEngine(name,scope);
}

void Vars::Dump()const{
  cout<<"VARIABLE DUMP"<<endl;
  for(map<string,string>::const_iterator i=m_map.begin();i!=m_map.end();++i){
    cout<<i->first<<"="<<i->second<<endl;
  }
}
