/***********************************************************************
 *
 * kftgtd.c -   server program for kftgt
 *
 * $Id: kftgtd.c,v 1.4 2001/03/22 19:18:43 bbense Exp $
 *
 * $Log: kftgtd.c,v $
 * Revision 1.4  2001/03/22 19:18:43  bbense
 * Minor tweaks to get rid of warnings.
 *
 * Revision 1.3  2001/03/06 15:02:11  bbense
 * Ported to Solaris 2.7 and new krb5 k4 libraries.
 *
 * Revision 1.2  1997/10/26 03:03:05  opusl
 * strncmp not strcmp on the version string
 *
 * Revision 1.1  1994/06/08  17:28:14  schemers
 * Initial revision
 *
 *
 *----------------------------------------------------------------------
 * Copyright (c) 1994 Board of Trustees, Leland Stanford Jr. University
 ***********************************************************************/
#ifndef lint
static char _rcs_id[]="$Id: kftgtd.c,v 1.4 2001/03/22 19:18:43 bbense Exp $";
#endif


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <syslog.h>
#include <pwd.h>
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include <krb.h>

#include "kftgt.h"
#include "encrypt.h"
#include "marsh.h"

void log_init();
void log_close();
void log_and_die(char *mess);
void log_message(char *mess);
void usage();

char *prog;

int l_flag =0, d_flag = 0, v_flag=0;
int t_val = 60;

RETSIGTYPE 
timeout()
{
  if (d_flag) log_message("timeout");
  exit(1);
}

int
main(argc,argv)
  int argc;
  char **argv;
{
  struct sockaddr_in caddr, saddr;
  size_t    clen, slen;
  int status;
  KRB_INT32 authopts;
  AUTH_DAT auth_data;
  KTEXT_ST clt_ticket;
  Key_schedule sched;
  char instance[INST_SZ];
  char version[9];
  char lname[KFTGT_MAX_USERNAME];
  char buffer[KFTGT_MAX_BUFFER];
  char tkfile[KFTGT_MAX_PATHNAME];
  struct passwd *pw;
  MSG_DAT m_data;
  int len;
  CREDENTIALS tgtcred;
  char *p, *d;

  int c, err_flag=0;
  extern int optind, opterr;
  extern char *optarg;

  prog = argv[0];

 
  while ((c = getopt(argc, argv, "hlvdt:")) != EOF) 
     switch (c) {
     case 'd':         d_flag=1;        break;
     case 'h':         usage();         break;
     case 't':         t_val=atoi(optarg); break;
     case 'v':         v_flag=1;        break;
     case 'l':         l_flag=1;        break;
     default:
         err_flag++;
     }

  if (t_val <0) usage();

  if (v_flag) {
    fprintf(stderr,"%s version %d.%d\n", prog, 
                        KFTGT_MAJOR_VERSION, KFTGT_MINOR_VERSION);
    exit(0);
  }

  if (err_flag) (void)usage();

  /* set alarm for timeout */
  signal(SIGALRM, timeout);
  alarm(t_val);

  /* get address of the client */
  clen = sizeof(caddr);
  if (getpeername(0, (struct sockaddr *) &caddr, &clen) < 0) {
     log_and_die("getpeername: %m");
  }

  /* get our address for mutual authentication */
  slen = sizeof(saddr);
  if (getsockname(0, (struct sockaddr *) &saddr, &slen) < 0) {
     log_and_die("getsockname: %m");
  }

  /* read the authenticator */
  strcpy(instance,"*");

  authopts = KOPT_DO_MUTUAL;

  status = krb_recvauth(authopts, 0, &clt_ticket, SERVICE_PRINCIPAL,
       instance, &caddr, &saddr, &auth_data, SRVTAB, sched, version);
  if (status != KSUCCESS) {
      sprintf(buffer,"kftgtd krb_recvauth: %s", krb_err_txt[status]);
      write(0,buffer,strlen(buffer)+1);
      log_and_die(buffer);
  }

  if (strncmp(version, KFTGT_PROTO_VERSION,1) != 0) {
      sprintf(buffer,"kftgtd: protocol version mismatch");
      write(0,buffer,strlen(buffer)+1);
      log_and_die(buffer);
  }

  if (write(0,"ok",3)!=3) log_and_die("write of krb_recvauth OK failed: %m");

  /* read remote username and ticketfile */
   len = receive_encrypted_chunk(&m_data,buffer,sizeof(buffer), 0,
         auth_data.session, sched, &caddr, &saddr);

   if (len <0) log_and_die("receive_encrypted_chunk failed");

   if (unmarshall_params(lname, sizeof(lname)-1, tkfile, sizeof(tkfile)-1,
                 m_data.app_data, m_data.app_length) < 0) {
       sprintf(buffer,"kftgtd: unable to unmarshall params");
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
          log_and_die(buffer);
   }

   if (d_flag) {
        sprintf(buffer,"lname(%s) tkfile(%s)", lname,tkfile);
        log_message(buffer);
   }

   unsetenv("KRBTKFILE"); /* don't inherit from inetd! */
   krb_set_tkt_string(tkfile);

   /* if user is "\0" then call krb_kntoln to get username */

   if (lname[0]=='\0') { 
   /*    if (krb_kntoln(&auth_data,lname) != KSUCCESS) { */
       char lrealm[REALM_SZ] = "";
       if ( (!(*lrealm) && (krb_get_lrealm(lrealm,1) == KFAILURE)) 
          ||  strcmp(auth_data.prealm,lrealm)) {
          sprintf(buffer,"kftgtd: unable to determine local username");
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
          exit(1);
        }
       (void) strcpy(lname,auth_data.pname);
   }

   /* we now have the local user in lname */

   /* first lookup password entry */

   if ( (pw =getpwnam(lname)) == NULL)  {
          sprintf(buffer,"kftgtd: no password entry for %s!",lname);
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
          log_and_die(buffer);
   }

   /* now check with kuserok */

   if (kuserok(&auth_data,lname) != 0) {
          sprintf(buffer,
                "kftgtd: you are not allowed to forward tickets to %s",lname);
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
         log_and_die(buffer);
   }

   if (    (setgid(pw->pw_gid) != 0) 
        || (setuid(pw->pw_uid) != 0)
   ) {
          sprintf(buffer,"kftgtd: process init failed");
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
          exit(1);
   }

   /* we are now running under the user's privs */
   /* send back ok to client */

   send_encrypted_chunk("ok",3,0,auth_data.session, sched, &saddr, &caddr);

   /* now read tgt */

   len = receive_encrypted_chunk(&m_data,buffer,sizeof(buffer), 0,
         auth_data.session, sched, &caddr, &saddr);

   if (len <0) log_and_die("receive_encrypted_chunk of tgt failed");
   /* null terminate */
   m_data.app_data[m_data.app_length] = '\0';

   if (unmarshall_cred(&tgtcred, m_data.app_data, m_data.app_length) < 0) {
          sprintf(buffer,"kftgtd: unmarshall of tgt failed");
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
          log_and_die(buffer);
   }

   /* we now have the tgt!!!!!!! */

  if(d_flag) {
     sprintf(buffer,"in_tkt(%s.%s)\n",tgtcred.pname,tgtcred.pinst);
     log_message(buffer);
     sprintf(buffer,"save_creds(%s.%s@%s)\n",tgtcred.service,tgtcred.instance,
                   tgtcred.realm);
     log_message(buffer);
  }

  /* initialize ticket cache  and stash tickets */
    if ( 
        ((status = in_tkt(tgtcred.pname,tgtcred.pinst)) != KSUCCESS)
      || ((status= krb_save_credentials(
                tgtcred.service, tgtcred.instance, tgtcred.realm,
                 tgtcred.session,tgtcred.lifetime,tgtcred.kvno,
                 &tgtcred.ticket_st, tgtcred.issue_date)) != KSUCCESS)
     ) {
          sprintf(buffer,"kftgtd: kerberos error: %s",krb_err_txt[status]);
          send_encrypted_chunk(buffer,strlen(buffer)+1,0,
                      auth_data.session, sched, &saddr, &caddr); 
          exit(1);
   }

   send_encrypted_chunk("ok",3,0,auth_data.session, sched, &saddr, &caddr);
   if (l_flag) {
      sprintf(buffer,"%s.%s@%s at %s forwarded to %s, %s",
               auth_data.pname,
               auth_data.pinst,
               auth_data.prealm,
	       inet_ntoa(caddr.sin_addr),
	       lname,
	       tkt_string());
      log_message(buffer);
   }
   log_close();
   exit(0);
}

static int log_init_called=0;

void log_init()
{
    if (log_init_called) return;
#ifndef LOG_DAEMON /* 4.2 syslog */
    openlog(prog, 0);
#else /* 4.3 syslog */
    openlog(prog, 0, LOG_DAEMON);
#endif /* 4.2 syslog */
    log_init_called = 1;
}

void log_close()
{
  if (log_init_called) closelog();
}


void log_and_die(char *mess)
{
  log_init();
  syslog(LOG_ERR, mess);
  closelog();
  exit(1);
}

void log_message(char *mess)
{
  log_init();
  syslog(LOG_ERR, mess);
}


void usage()
{
  fprintf(stderr,"\n");
  fprintf(stderr,"Usage: %s [options]\n",prog);
  fprintf(stderr,"   -l          log ticket forwarding requsts\n");
  fprintf(stderr,"   -t secs     timeout, default is 60 seconds\n");
  fprintf(stderr,"   -v          version\n");
  fprintf(stderr,"   -d          debug info\n");
  fprintf(stderr,"\n");
  exit(1);
}
