// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Define the non-opaque part to the LDAP-C-API
//
// - Automatic Version Information via RCS:
//   $Id: ber.h,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/include/ber.h,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef __BER_OPENH323_H
#define __BER_OPENH323_H "@(#) $Id: ber.h,v 1.1 2001/12/17 16:36:17 nilsb Exp $"

#include <stdlib.h>

typedef size_t ber_len_t;

typedef struct berval {
  ber_len_t bv_len;
  char *bv_val;
} BerValue;


typedef struct berelement {
  unsigned int number;
} BerElement;


LDAP_F(void) ber_bvfree LDAP_P((struct berval *bv));

LDAP_F(void) ber_bvecfree LDAP_P((struct berval **bv));

LDAP_F(struct berval *) ber_bvdup LDAP_P((struct berval *));

LDAP_F(void) ber_free LDAP_P((BerElement *ber, int fbuf));

     
#endif
//
// End of ber.h
//
