// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement the message handling.
//
// - Automatic Version Information via RCS:
//   $Id: messages.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/messages.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: messages.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

LDAPMessage *ldap_first_message (LDAP *ld, LDAPMessage *chain) {
  return chain;
}

LDAPMessage *ldap_next_message (LDAP *ld, LDAPMessage *msg) {
  if(msg)
    return msg->next;
  return NULL;
}

int ldap_count_messages (LDAP *ld, LDAPMessage *chain) {
  LDAPMessage *c=chain;
  int i=0;
  while(c) {
    i++;
    c=c->next;
  }
  return 1;
}

//
// End of messages.cxx
//
