/*
 * main.h
 *
 * PWLib application header file for Voxilla
 *
 * A H.323 "net telephone" application.
 *
 * Copyright (c) 1993-1998 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Portable Windows Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Portions of this code were written with the assisance of funding from
 * Vovida Networks, Inc. http://www.vovida.com.
 *
 * Portions are Copyright (C) 1993 Free Software Foundation, Inc.
 * All Rights Reserved.
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: main.h,v $
 * Revision 1.11  2001/06/20 07:36:57  robertj
 * Added dial plan parameter, thanks Chih-Wei Huang
 *
 * Revision 1.10  2001/06/19 22:48:55  robertj
 * Gatekeeper supprt, multiple aliases and prefixes, thanks Chih-Wei Huang
 *
 * Revision 1.9  2000/10/19 03:36:30  dereks
 * Added argument to set jitter buffer length in pstngw.
 * Use -j delay    (or --jitter delay) where delay is 20<= 150(def) <= 10 000 ms
 *
 * Revision 1.8  2000/03/27 18:21:04  robertj
 * Added IP access control and more improvements in calling tone translation into H.323 signals.
 *
 * Revision 1.7  2000/03/23 23:33:16  robertj
 * Added more calling tone detection functionality.
 *
 * Revision 1.6  2000/03/23 03:03:46  craigs
 * Added interface option, and improved semantics of forced dialling
 *
 * Revision 1.5  2000/03/23 02:42:33  robertj
 * Added detection of PSTN hang up when making outgoing call
 *
 * Revision 1.4  2000/01/07 08:28:09  robertj
 * Additions and changes to line interface device base class.
 *
 * Revision 1.3  2000/01/04 00:16:25  craigs
 * Changed for new AnswerCall timing
 *
 * Revision 1.2  1999/12/23 23:02:35  robertj
 * File reorganision for separating RTP from H.323 and creation of LID for VPB support.
 *
 * Revision 1.1  1999/12/22 09:49:36  craigs
 * Initial version
 *
 * Revision 1.4  1999/10/24 12:50:37  craigs
 * Fixed G723.1 capability, and added ability for discrete OGMs
 *
 * Revision 1.3  1999/10/24 03:08:49  craigs
 * Fixed problem with recording zero length messages, and added autodelete of files
 *
 * Revision 1.2  1999/10/22 09:56:41  craigs
 * Fixed compile warning
 *
 * Revision 1.1  1999/10/11 00:15:18  craigs
 * Initial version
 *
 *
 */

#ifndef _pstngw_MAIN_H
#define _pstngw_MAIN_H


#include <ptclib/ipacl.h>

#include <h323.h>


class OpalLineInterfaceDevice;
class GatewayEndPoint;


class LineMonitor : public PThread
{
  PCLASSINFO(LineMonitor, PThread);

  public:
    LineMonitor(GatewayEndPoint & endpoint,
                OpalLineInterfaceDevice & device,
                unsigned lineNumber,
                const PString & h323Address);
    ~LineMonitor();

    void Main();

    BOOL IsAvailable() const
      { return !device.IsLineTerminal(lineNumber) && !device.IsLineOffHook(lineNumber); }
    void AttachConnection(const H323Connection & connection)
      { callToken = connection.GetCallToken(); }


    OpalLineInterfaceDevice & GetDevice() const { return device; }
    unsigned GetLineNumber() const { return lineNumber; }

  protected:
    BOOL HandleCall();

    GatewayEndPoint         & endpoint;
    OpalLineInterfaceDevice & device;
    unsigned                  lineNumber;
    PString                   h323Address;
    PSyncPoint                shutdown;
    PString                   callToken;
};


class GatewayEndPoint : public H323EndPoint
{
  PCLASSINFO(GatewayEndPoint, H323EndPoint);

  public:
    GatewayEndPoint();
    ~GatewayEndPoint();

    // overrides from H323EndPoint
    H323Connection * CreateConnection(unsigned callReference);
    BOOL OnIncomingCall(H323Connection &, const H323SignalPDU &, H323SignalPDU &);
    H323Connection::AnswerCallResponse OnAnswerCall(
      H323Connection & connection,    /// Connection that was established
      const PString & callerName,       /// Name of caller
      const H323SignalPDU & setupPDU,   /// Received setup PDU
      H323SignalPDU & connectPDU        /// Connect PDU to send. 
    );
    void OnConnectionCleared(H323Connection & connection, const PString &);
    BOOL OpenAudioChannel(H323Connection &, BOOL, unsigned, H323AudioCodec &);

    // new functions
    BOOL Initialise(PArgList & args);

    virtual PString RewriteE164(const PString &dialedDigits);
    virtual PString RewriteE164(const PString &dialedDigits, const PStringToString &myplan);

  protected:

    void SetEndpointTypeInfo( H225_EndpointType & info ) const;
    PStringArray SupportedPrefix;

    PLIST(LIDList, OpalLineInterfaceDevice);
    LIDList lids;

    PLIST(MonitorList, LineMonitor);
    MonitorList lineMonitors;

    PIpAccessControlList accessControl;

    PString  autoDial;
    BOOL     forceDial;
    BOOL     convertTones;
    unsigned jitter;

    friend class GatewayConnection;
};


class GatewayConnection : public H323Connection
{
  PCLASSINFO(GatewayConnection, H323Connection);

  public:
    GatewayConnection(GatewayEndPoint &, unsigned);

    void OnUserInputString(const PString & value);
    BOOL OnStartLogicalChannel(H323Channel & channel);

    LineMonitor * line;
};


class PSTNGw : public PProcess
{
  PCLASSINFO(PSTNGw, PProcess)

  public:
    PSTNGw();

    void Main();
};


#endif  // _pstngw_MAIN_H


// End of File ///////////////////////////////////////////////////////////////
