/***************************************************************************
                          dbobj.h  -  description                              
                             -------------------                                         
    begin                : Fri Sep 3 1999                                           
    version              : $Id: dbobj.h,v 1.15 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef DBOBJ_H
#define DBOBJ_H

/**Grafical Database-Objekts
(Dialogs, Tables, etc.)
  *@author Jrg Bemm
  */

#include "sqlquerier.h"

#include <qlineedit.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qdatetime.h>

// Connect to Database, defined in sqlquerier.cpp
extern SQLQuerier sql;

class QDBTableView;
class QDBSortFilter;
class QDBDialog;

// Navigator Bar
class QDBNavigator : public QGridLayout {
  Q_OBJECT
public:
  QDBNavigator( QWidget * parent=0, int nRows=1, int nCols=10,
								int border=5, int autoBorder = -1, const char * name=0 );

	QPushButton *bFirst;
	QPushButton *bBefore;
	QPushButton *bNext;
	QPushButton *bLast;
	QPushButton *bRead;
	QPushButton *bFind;
	QPushButton *bUpdate;
	QPushButton *bUndo;
	QPushButton *bNew;
	QPushButton *bDelete;

	void setButtonsUp();

public slots:
	void sNewTuple();

signals:
	// This signal is for other modules to set
	// the mask with default values.
	void sigNewTuple();

private:
	SQLQuerier *sql;
};

// Buttons Bar
class QDBButtons : public QGridLayout {
  Q_OBJECT
public:
  QDBButtons( QWidget * parent=0, int nRows=1, int nCols=4,
								int border=5, int autoBorder = -1, const char * name=0 );

	QPushButton *b1;
	QPushButton *b2;
	QPushButton *b3;
	QPushButton *b4;

private:
	SQLQuerier *sql;
};

class QDBDate : public QDate
{
public:
	QDBDate();
	char *getDate( int format = 0 );

private:
	char d[11];
};

class QDBListViewItem : public QListViewItem
{
public:
  QDBListViewItem( QDBTableView *parent, const QString &text, int pos );

	int DBPos;
};

class QDBTableView : public QListView {
	Q_OBJECT
public:
  QDBTableView( QWidget *parent = 0, const char *name = 0,
  							SQLQuerier *sql_ptr = 0, SQLTable* table_ptr = 0 );
	QDBListViewItem * currentItem() const;
	void update( SQLTable *table = 0, bool withDelete = true );

public slots:
	void sUpdate();

protected:
	int nTuples;
//	QDBListViewItem *item[];

private:
	SQLQuerier	*sql;
	SQLTable *table;

protected:
	virtual void keyPressEvent( QKeyEvent * );
	void getColumns();

signals:
	void pressedF2();
};

class QDBCheckBox : public QCheckBox {
	Q_OBJECT
public:
  QDBCheckBox( QWidget *parent = 0, const char *name = 0 );
	int Nummer;
	bool Aktiv;
};

class QDBWidget : public QWidget {
	Q_OBJECT
public:
  QDBWidget( QWidget *parent = 0, const char *name = 0 );

protected:
	virtual void keyPressEvent( QKeyEvent * );

signals:
	void changePosUp();
	void changePosDown();
	void pressedInsert();
	void pressedF2();
	void pressedF4();
	void pressedF6();
	void pressedF7();
	void pressedF10();
	void pressedShiftPos1();
	void pressedShiftEnd();
	void pressedPos1();
	void pressedEnd();
	void pressedEsc();
	void pressedUp();
	void pressedDown();
};

class QDBSortFilter : public QGridLayout {
	Q_OBJECT
public:
  QDBSortFilter( QWidget *parent = 0, const char *name = 0,
  							SQLQuerier *sql_ptr = 0, SQLTable* table = 0);

private:
	SQLQuerier	*sql;
	SQLTable		*table;
	QGridLayout	*gScroll;
	QFrame			*frScroll;
	QDBButtons	*gButtons;
	QFrame			*frButtons;
	QScrollView	*svScroll;
	QDBCheckBox	*feld[MAXFELDER];
	QCheckBox		*SA[MAXFELDER];
	QCheckBox		*FA[MAXFELDER];
	QLineEdit		*filter[MAXFELDER];
	int					maxNr;

private slots:
	void	sAnzeige();
	void	sAnwenden();
	void	sSort_aus();
	void	sFilter_aus();
	void	sAlles_aus();

signals:
	// Wird ausgelst wenn die Anzeige aktualisiert werden mu.
	void updateView();
};

class QDBLineEdit : public QLineEdit {
  Q_OBJECT
public:
  QDBLineEdit( QWidget *parent = 0, const char *name = 0,
							SQLQuerier *sql_ptr = 0, SQLTable* table = 0,
							int DatensatzNr = -1 );

	bool	geaendert;
	int		screenNo; // jump position during pressed up and down

private slots:
	void fGeaendert();

private:
	SQLQuerier *sql;
};

#endif
