/***************************************************************************
                          printsystem.h  -  description
                             -------------------
    begin                : Sun Nov 19 2000
    version              : $Id: printsystem.h,v 1.11 2001/02/27 08:19:02 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PRINTSYSTEM_H
#define PRINTSYSTEM_H

#include <qwidget.h>
#include <qlineedit.h>
#include <qfile.h>
#include <qtextstream.h>

#include "sqlquerier.h"
#include "qdberfassung.h"

/**Printing system with report generator
and importing tex-files
  *@author Jrg Bemm
  */

class EditReport;

class PrintSystem : public QWidget  {
   Q_OBJECT
public: 
	PrintSystem(QWidget *parent=0, const char *name=0, SQLQuerier *sql_ptr=0);
	~PrintSystem();

	void importTexFile();
	// mixing layout with data and creating a ascii-file
	bool reportGenerator( const char *name=0, QStringList *selection=0,
		int type=0);
	// generating a printout with Qt from the result of the reportGenerator
	void printGenerator( const char *filename=0, const char *name=0 );
	void editReport();
	void printReport();

private slots:
	void sImportTexFile();
	void sSearchingFile();

private:
	// pos -> begin of variable
	bool	changeVariable( QString *line, int pos, int tupleNo, const char *repName );
	bool	createSelections( QStringList *list );
	bool	modifySelection( const char *repName, const char *repArt,
					int mesh, int qSelPos, int qSelPosBefore );
	bool	printElement( const char *repName, const char *repArt,
					int mesh, int qSelPos, int qSelPosBefore, QFile *text, const char *type );

	SQLQuerier	*sql;
	SQLTable		*tableRep;
	SQLTable		*qSel[10]; // max. 10 selections
	SQLTable		*tablePrinter; // for the used printer
	QDialog			*dlg;
  QLineEdit		*filename;
	QLineEdit 	*reportName;
	EditReport	*editRep;
	QTextStream	textstream;
	int pageNo;
	int lineNo;
};

class EditReport : public QDBErfassung  {
   Q_OBJECT
public:
	EditReport(QWidget *parent=0, const char *name=0,
			SQLQuerier *sql_ptr=0, SQLTable *table_ptr=0);
	~EditReport();

private slots:
	void sReportElementsClicked();
	void sReportWechselnClicked();
	void sReportKopierenClicked();
	void sLogicClicked();
	void sVariableClicked();
	void getLfdNr();

private:
	SQLQuerier	*sql;
	SQLTable		*table;
	SQLTable		*tableV;
	SQLTable		*tableE;

	QDBErfassung *printReport;
	QDBTableEdit *printVariable;
	QDBTableEdit *printElements;
};

#endif
