/***************************************************************************
                          sqlquerier.h  -  description                              
                             -------------------                                         
    begin                : Wed Oct 6 1999                                           
    version              : $Id: sqlquerier.h,v 1.13 2001/03/11 08:13:58 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SQLQUERIER_H
#define SQLQUERIER_H

/**Interface to database PostgreSQL
  *@author Jrg Bemm
  */

#include <libpq-fe.h>
#include <qstring.h>

#define MAXKEYS			10			// max. keys per table
#define KEYLENGTH		40			// max. key length
#define MAXFELDER 	999			// max. 999 fields (like Navision)

#define SUCCESS_NO_RESULTS 10
#define SUCCESS_RESULTS 11
#define ERRORS_RETURNED 1
#define NOT_CONNECTED 2

extern bool ConnectToDB( const char *fileName );
extern QCString initPath;
extern QCString Benutzer;
extern QCString Taskname;
/*
// working with a query
class SQLQuery {
public:
	SQLQuery( QCString *query );
	~SQLQuery();

	// each function modifies the query

	void			addSelect(); // select field
	void			delSelect(); // remove selected field

	void			addWhere(); // add where field
	void			setWhere(); // set where = value
	void			clearWhere(); // delete value from where

	void			addOrder(); // add sorting field
	void			delOrder(); // remove sorting field

	QCString	*tableQuery;
	char			*tableName;

	QCString	*select[MAXFELDER];
	QCString	*where[MAXFELDER];
	QCString	*whereValue[MAXFELDER];
	QCString	*order[MAXFELDER];

private:

};
*/
// Classes for database-queries and transactions.
// Versteckt die Postgres-Struktur PGresult
// unter einem anderen Namen (so ist eine
// sptere Anpassung an andere Datenbanken
// einfacher.
class SQLTable {
public:
	SQLTable( QCString Query=0, QCString PrimaryKey=0 );
	~SQLTable();

	void clear();
	int execute();
	int getnFields();
	int getnTuples();
	int fType( int field_number );
	int fNumber( const char* field_name );
	char* getValue( int tuple_number, int field_number );
	char* getValue( int tuple_number, const char *fname );
	char* fName( int field_index );
	void savePos( int tuplePos, bool newPos );
	int setPos();
	QCString *GetPrimaryKey( QCString *Key );

	PGresult	*table;
  QString		ErrorText;

	QCString sQuery;		// Die SELECT SQL-Anweisung, die bei Erzeugung
											// der Klasse mit bergeben wird (z. B. in QtTudoApp)
											// oder bei allen Vernderungen der Query verwendet
											// wird.
	QCString sNewPos[MAXKEYS];

	int	pos; // current database position
	int noOfTuples; // number of tuples (records)

	// The PrimaryKey is for the exactly identification
	// of the tuple.
	char	PrimaryKeys[MAXKEYS][KEYLENGTH];
	int		AnzKeys;
	char	name[40]; // table name

private:
	// Ein String der die Feldnamen des PrimaryKey's
	// durch Komma getrennt enthlt.
	QCString sPrimaryKey;

	// Dieses Array beinhaltet eine Kopie des aktuellen
	// Datensatz-Keys. Es wird dazu benutzt, um nach einem
	// Datensatz-Update die letzte Datenbankpositionen
	// wieder herzustellen.
	QCString sLastPos[MAXKEYS];

	// only for internal use.
	char *nothing;
};

// Class for database connection
// (once per application)
class SQLQuerier {
public: 
  SQLQuerier();

	int Connect( const char *Name, const char *Password );
	int Close();
	QString *getLfdNr( const char *tablename, QString *Field,
		const char *Fieldname, int NoOfTuples );

  PGconn* conn;

  QCString pghost, pgport, pgoptions, pgtty, dbname;
  QCString Name;
  QCString Password;
  QCString pgtz, pgdatestyle;
  QCString ErrorText;
};

#endif
