/* This file is part of the 'atomes' software

'atomes' is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with 'atomes'.
If not, see <https://www.gnu.org/licenses/>

Copyright (C) 2022-2024 by CNRS and University of Strasbourg */

/*!
* @file cp2k_basis.c
* @short CP2K basis set, as delivered with CP2K v9.1
* @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>
*/

/*
* This file: 'cp2k_basis.c'
*
* Contains:
*

  - CP2K basis set, as delivered with CP2K v9.1

  This file contains 3 tables:

  basis_elem -> the list of chemical elements
  basis_keys -> the list of keywords
  cp2k_basis -> finally the complete basis set

*/

#include "global.h"

char * basis_elem[250]={"H",
"O",
"Si",
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"Cu",
"Cu",
"Cu",
"Zn",
"Br",
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"Be",
"B",
"C",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Si",
"Si",
"P",
"S",
"Cl",
"Ar",
"H",
"H",
"He",
"He",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"H",
"H",
"O",
"F",
"H",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"H",
"H",
"H",
"H",
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"Be",
"B",
"C",
"C",
"C",
"N",
"N",
"O",
"O",
"O",
"O",
"F",
"F",
"Ne",
"Ne",
"Na",
"Na",
"Mg",
"Mg",
"Al",
"Al",
"Si",
"Si",
"Si",
"P",
"P",
"S",
"S",
"Cl",
"Ar",
"K",
"K",
"Ca",
"Sc",
"Ti",
"Ti",
"V",
"Cr",
"Mn",
"Fe",
"Co",
"Ni",
"Ni",
"Ni",
"Ni",
"Ni",
"Cu",
"Zn",
"Zn",
"Br",
"Y",
"Y",
"Y",
"Y",
"Zr",
"Zr",
"Zr",
"Zr",
"Pt",
"Pt",
"Pt",
"Pt",
"H",
"H",
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"Be",
"B",
"C",
"N",
"O",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Al",
"Si",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"K",
"Ti",
"Ba",
"H",
"H",
"C",
"N",
"O",
"Mg",
"Mg",
"Mg",
"Si",
"P",
"S",
"Ca",
"Au",
"H",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar"};

char * basis_keys[250]={"DZ-ANO",
"DZ-ANO",
"DZ-ANO",
"DZV-ALL",
"DZVP-ALL",
"DZV-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-MONTREAL-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-MONTREAL-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZVP-MONTREAL-ALL",
"DZVP-ALL",
"TZVP-ALL",
"DZVP-ALL",
"DZVP-ALL",
"DZV-ALL-PADE",
"DZVP-ALL-PADE",
"DZV-ALL-PADE",
"DZVP-ALL-PADE",
"DZV-ALL-PADE",
"DZVP-ALL-PADE",
"DZV-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZVP-ALL-PADE",
"DZV-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZV-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZV-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZV-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW-CONFINED",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW-CONFINED",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"DZVP-ALL-PADE-NEW",
"TZV-ALL-PADE",
"TZVP-ALL-PADE",
"TZV-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"TZVP-ALL-PADE",
"DZV-ALL-BLYP",
"DZVP-ALL-BLYP",
"TZVP-ALL-BLYP",
"TZVP-ALL-BLYP",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"6-31G*",
"SZV-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE-CONFINED",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE-CONFINED",
"MAO-PRIM",
"DZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE-CONFINED",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"MAO-PRIM",
"DZVP-GTH-PADE-CONFINED",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE-q2",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE-CONFINED",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE-CONFINED",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"SZV-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE",
"DZVP-GTH-PADE-CONFINED",
"DZVP-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE-CONFINED",
"DZV-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE",
"SZV-GTH-PADE",
"SZV-GTH-PADE-CONFINED",
"DZV-GTH-PADE",
"DZV-GTH-PADE-CONFINED",
"DZV-GTH-PADE-q10",
"DZV-GTH-PADE",
"DZV-GTH-PADE",
"DZV-GTH-PADE-CONFINED",
"DZVP-GTH-PADE",
"SZV-GTH-PADE",
"SZV-GTH-PADE-CONFINED",
"DZV-GTH-PADE",
"DZV-GTH-PADE-CONFINED",
"SZV-GTH-PADE",
"SZV-GTH-PADE-CONFINED",
"DZV-GTH-PADE",
"DZV-GTH-PADE-CONFINED",
"SZV-GTH-PADE",
"DZV-GTH-PADE",
"SZV-GTH-PADE-CONFINED",
"DZV-GTH-PADE-CONFINED",
"DZV-GTH-BLYP",
"DZV-GTH-BLYP-CONFINED",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP-CONFINED",
"DZV-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZV-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZV-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP-CONFINED",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP-CONFINED",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP-CONFINED",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP",
"DZVP-GTH-BLYP-CONFINED",
"DZV-GTH-BLYP",
"SZV-GTH-BLYP",
"DZV-GTH-PBE",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"DZV-GTH-PBE-q10-soft",
"DZVP-GTH-PBE-q2",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"DZVP-GTH-PBE",
"TZ-GTH",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP",
"TZVDD3DF3PD-GTH-BLYP"};

char * cp2k_basis[250]={"\n"
"H DZ-ANO\n"
"  2\n"
"  1  0  0  8  3\n"
"      188.6144500000   0.0009639000  -0.0013119000   0.0024224000\n"
"       28.2765960000   0.0074920000  -0.0103451000   0.0203382000\n"
"        6.4248300000   0.0375954000  -0.0504953000   0.0896394000\n"
"        1.8150410000   0.1433950000  -0.2073855000   0.4422907000\n"
"        0.5910630000   0.3486363000  -0.4350885000   0.5757144000\n"
"        0.2121490000   0.4382974000  -0.0247297000  -0.9802890000\n"
"        0.0798910000   0.1651066000   0.3225260000  -0.6721538000\n"
"        0.0279620000   0.0210229000   0.7072754000   1.1417685000\n"
"  2  1  1  4  2\n"
"        2.3050000000   0.1127902000  -0.2108688000\n"
"        0.8067500000   0.4185075000  -0.5943796000\n"
"        0.2823620000   0.4700077000   0.0896889000\n"
"        0.0988270000   0.1826260000   0.8611634000\n"
"#","\n"
"O DZ-ANO\n"
"  3\n"
"  1  0  0 14  4\n"
"   105374.9500000000   0.0000459000  -0.0000105000   0.0000090000  -0.0000109000\n"
"    15679.2400000000   0.0003607000  -0.0000825000   0.0000705000  -0.0000822000\n"
"     3534.5447000000   0.0019198000  -0.0004412000   0.0003757000  -0.0004675000\n"
"      987.3651600000   0.0082067000  -0.0018864000   0.0016146000  -0.0018465000\n"
"      315.9787500000   0.0297257000  -0.0069540000   0.0059340000  -0.0075585000\n"
"      111.6542800000   0.0904558000  -0.0217208000   0.0187866000  -0.0210868000\n"
"       42.6994510000   0.2174054000  -0.0568513000   0.0494683000  -0.0667511000\n"
"       17.3955960000   0.3687657000  -0.1139635000   0.1030399000  -0.1093673000\n"
"        7.4383090000   0.3372798000  -0.1620201000   0.1620586000  -0.2731431000\n"
"        3.2228620000   0.0967505000  -0.0333800000   0.0009367000   0.2097137000\n"
"        1.2538770000   0.0025674000   0.3655068000  -0.8224251000   1.2034807000\n"
"        0.4951550000   0.0013746000   0.5520031000  -0.1017902000  -0.6774694000\n"
"        0.1916650000  -0.0001410000   0.2236393000   0.4253939000  -1.4298840000\n"
"        0.0670830000   0.0000683000   0.0065745000   0.6877028000   1.4891068000\n"
"  2  1  1  9  3\n"
"      200.0000000000   0.0008933000  -0.0008384000   0.0012618000\n"
"       46.5333670000   0.0073690000  -0.0068491000   0.0111628000\n"
"       14.6218090000   0.0349392000  -0.0328505000   0.0518316000\n"
"        5.3130640000   0.1152985000  -0.1100060000   0.1978845000\n"
"        2.1025250000   0.2583231000  -0.3135263000   0.5707652000\n"
"        0.8502230000   0.3696231000  -0.3196011000  -0.1789291000\n"
"        0.3375970000   0.3238789000   0.2217243000  -0.8982077000\n"
"        0.1288920000   0.1467989000   0.5622616000   0.2666643000\n"
"        0.0451120000   0.0336127000   0.3013251000   0.6258994000\n"
"  3  2  2  4  2\n"
"        3.7500000000   0.1284934000  -0.2182055000\n"
"        1.3125000000   0.5211884000  -0.4817695000\n"
"        0.4593750000   0.4345784000   0.1357595000\n"
"        0.1607810000   0.1457409000   0.8297734000\n"
"#","\n"
"Si DZ-ANO\n"
"  4\n"
"  1  0  0 17  5\n"
"   250095.9700000000   0.0000681500  -0.0000182000   0.0000047000  -0.0000049000   0.0000068800\n"
"    35803.2000000000   0.0004801700  -0.0001278000   0.0000330500  -0.0000348000   0.0000473500\n"
"    10522.4830000000   0.0015962600  -0.0004265000   0.0001106400  -0.0001149000   0.0001652200\n"
"     3701.7745000000   0.0054750700  -0.0014618000   0.0003777800  -0.0004007000   0.0005308800\n"
"     1399.3933000000   0.0169370600  -0.0045845000   0.0011912000  -0.0012329000   0.0017985200\n"
"      548.3889500000   0.0504178400  -0.0138701000   0.0035922800  -0.0038201000   0.0050352300\n"
"      219.3626900000   0.1345026700  -0.0391782000   0.0102427300  -0.0106138000   0.0155996000\n"
"       88.8822590000   0.2947640100  -0.0963506000   0.0253036400  -0.0270878000   0.0356862000\n"
"       36.3233770000   0.4127972600  -0.1817620000   0.0493252100  -0.0512202000   0.0786378100\n"
"       14.9334630000   0.2188576000  -0.1452339000   0.0404961600  -0.0466301000   0.0494893100\n"
"        6.1663485000   0.0135263100   0.2298980700  -0.0698564000   0.0919014000  -0.1113745000\n"
"        2.5545565000   0.0047876100   0.6237984700  -0.2541120000   0.2690132700  -0.5522929000\n"
"        1.0609507000  -0.0023509000   0.3154358200  -0.2861133000   0.4607770300  -0.3884090000\n"
"        0.4415024000   0.0015770000  -0.0027626000   0.2463941500  -1.0562010000   2.9534782000\n"
"        0.1840168000  -0.0009118000   0.0090372200   0.6801918100  -0.7847112000  -2.8556020000\n"
"        0.0767962000   0.0004164400  -0.0039062000   0.2896670600   1.2042630000   0.0921528600\n"
"        0.0307185000  -0.0001140000   0.0011114400   0.0241482300   0.2967985900   1.0348260000\n"
"  2  1  1 12  4\n"
"      843.5338200000   0.0007436900  -0.0001574000   0.0001660200  -0.0001925000\n"
"      204.9072600000   0.0055201500  -0.0011656000   0.0011978900  -0.0011519000\n"
"       72.2487870000   0.0241128700  -0.0051529000   0.0054575000  -0.0064766000\n"
"       27.9613650000   0.0888357300  -0.0191723000   0.0196283200  -0.0182754000\n"
"       11.2322820000   0.2349425100  -0.0523132000   0.0558657900  -0.0680060000\n"
"        4.5969373000   0.3973225000  -0.0900087000   0.0919795600  -0.0775832000\n"
"        1.9014833000   0.3618118500  -0.0925012000   0.1150392100  -0.2143299000\n"
"        0.7917828000   0.1052477300   0.0387090900  -0.0648366000   0.2557204800\n"
"        0.3311662000   0.0025655500   0.3415276900  -0.6831822000   1.0777334000\n"
"        0.1389423000   0.0017732900   0.4611056100  -0.1636095000  -1.2446840000\n"
"        0.0584257000  -0.0004541000   0.2585592100   0.6175016400  -0.3835503000\n"
"        0.0233703000   0.0001788100   0.0756656000   0.4409777500   1.0225198000\n"
"  3  2  2  5  2\n"
"        2.0105333000   0.0222105100  -0.0019527000\n"
"        0.7910981000   0.1035698000   0.1535609200\n"
"        0.3112787000   0.5081316400   0.4895933200\n"
"        0.1224809000   0.3511753500   0.1138756000\n"
"        0.0489924000   0.2507112700  -0.9848990000\n"
"  4  3  3  2  1\n"
"        0.8000000000   0.7000000000\n"
"        0.3000000000   0.4000000000\n"
"#","\n"
"H (41) DZV-ALLELECTRON DZV-ALL\n"
"  2\n"
"  1  0  0  4  1\n"
"       50.9991800000   0.0096604760\n"
"        7.4832180000   0.0737288600\n"
"        1.7774680000   0.2958581000\n"
"        0.5193295000   0.7159053000\n"
"  2  0  0  1  1\n"
"        0.1541100000   1.0000000000\n"
"#","\n"
"H (41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  3\n"
"  1  0  0  4  1\n"
"       50.9991800000   0.0096604760\n"
"        7.4832180000   0.0737288600\n"
"        1.7774680000   0.2958581000\n"
"        0.5193295000   0.7159053000\n"
"  2  0  0  1  1\n"
"        0.1541100000   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"He (51) DZV-ALLELECTRON DZV-ALL\n"
"  2\n"
"  1  0  0  5  1\n"
"      221.3880300000   0.0027491019\n"
"       33.2619660000   0.0208657650\n"
"        7.5616549000   0.0970588380\n"
"        2.0855990000   0.2807288500\n"
"        0.6143391600   0.4742218300\n"
"  2  0  0  1  1\n"
"        0.1829212000   0.3055012900\n"
"#","\n"
"He (51/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  3\n"
"  1  0  0  5  1\n"
"      221.3880300000   0.0027491019\n"
"       33.2619660000   0.0208657650\n"
"        7.5616549000   0.0970588380\n"
"        2.0855990000   0.2807288500\n"
"        0.6143391600   0.4742218300\n"
"  2  0  0  1  1\n"
"        0.1829212000   0.3055012900\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"Li (6111/311) DZVP-ALLELECTRON DZVP-ALL\n"
"  7\n"
"  1  0  0  6  1\n"
"      605.7054000000   0.0022800000\n"
"       90.8609100000   0.0174600000\n"
"       20.6312700000   0.0834000000\n"
"        5.7384460000   0.2607400000\n"
"        1.7515260000   0.4726300000\n"
"        0.5463901000   0.3090700000\n"
"  2  0  0  1  1\n"
"        0.8427234000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.0674483300   1.0000000000\n"
"  4  0  0  1  1\n"
"        0.0253733200   1.0000000000\n"
"  2  1  1  3  1\n"
"        2.7700000000   0.0119900000\n"
"        0.6300000000   0.0543800000\n"
"        0.1850000000   0.1724600000\n"
"  3  1  1  1  1\n"
"        0.0544000000   1.0000000000\n"
"  4  1  1  1  1\n"
"        0.0160000000   1.0000000000\n"
"#","\n"
"Li (621/1/1) DZVP-MONTREAL-ALLELECTRON DZVP-MONTREAL-ALL\n"
"  5\n"
"  1  0  0  6  1\n"
"      605.7054000000  -0.0022870220\n"
"       90.8609100000  -0.0174528000\n"
"       20.6312700000  -0.0836970200\n"
"        5.7384460000  -0.2597485000\n"
"        1.7515260000  -0.4794613000\n"
"        0.5463901000  -0.3233006000\n"
"  2  0  0  2  1\n"
"        0.8427234000   0.0748609200\n"
"        0.0674483300  -0.6546490000\n"
"  3  0  0  1  1\n"
"        0.0253733200   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.0773000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1220000000   1.0000000000\n"
"#","\n"
"Be (621/1/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  5\n"
"  1  0  0  6  1\n"
"     1203.4140000000   0.0020504250\n"
"      180.2457000000   0.0157077700\n"
"       40.8000500000   0.0768315300\n"
"       11.3365400000   0.2480252000\n"
"        3.5034830000   0.4798452000\n"
"        1.1091220000   0.3371459000\n"
"  2  0  0  2  1\n"
"        1.9593420000  -0.0750455400\n"
"        0.1652013000   0.5813557000\n"
"  3  0  0  1  1\n"
"        0.0552207800   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.1500000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2500000000   1.0000000000\n"
"#","\n"
"B (621/41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  6\n"
"  1  0  0  6  1\n"
"     1915.1670000000  -0.0020395200\n"
"      287.1831000000  -0.0155965800\n"
"       65.1571700000  -0.0762442400\n"
"       18.1958300000  -0.2479244000\n"
"        5.7015380000  -0.4790823000\n"
"        1.8438370000  -0.3352953000\n"
"  2  0  0  2  1\n"
"        3.4914300000   0.0774223700\n"
"        0.3050560000  -0.5741239000\n"
"  3  0  0  1  1\n"
"        0.0964865000   1.0000000000\n"
"  2  1  1  4  1\n"
"       11.6874200000   0.0150861200\n"
"        2.6307750000   0.0888157000\n"
"        0.7442269000   0.2903682000\n"
"        0.2304761000   0.4994433000\n"
"  3  1  1  1  1\n"
"        0.0699380500   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"C (621/41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  6\n"
"  1  0  0  6  1\n"
"     2808.0640000000   0.0020178300\n"
"      421.1383000000   0.0154332000\n"
"       95.5866200000   0.0755815500\n"
"       26.7390000000   0.2478282000\n"
"        8.4328270000   0.4793725000\n"
"        2.7605820000   0.3338344000\n"
"  2  0  0  2  1\n"
"        5.4470040000  -0.0778407700\n"
"        0.4792422000   0.5689560000\n"
"  3  0  0  1  1\n"
"        0.1461565000   1.0000000000\n"
"  2  1  1  4  1\n"
"       18.1308500000   0.0158547300\n"
"        4.0998830000   0.0956827700\n"
"        1.1858370000   0.3049119000\n"
"        0.3685974000   0.4935017000\n"
"  3  1  1  1  1\n"
"        0.1097200000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"N (621/41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  6\n"
"  1  0  0  6  1\n"
"     3845.4150000000   0.0020186080\n"
"      577.5332000000   0.0154077600\n"
"      131.3198000000   0.0753714000\n"
"       36.8237800000   0.2482122000\n"
"       11.6701200000   0.4798274000\n"
"        3.8542600000   0.3318012000\n"
"  2  0  0  2  1\n"
"        7.8295610000  -0.0776668700\n"
"        0.6877351000   0.5654598000\n"
"  3  0  0  1  1\n"
"        0.2040388000   1.0000000000\n"
"  2  1  1  4  1\n"
"       26.8098400000   0.0154663100\n"
"        6.0681540000   0.0964396800\n"
"        1.7676260000   0.3083610000\n"
"        0.5466728000   0.4911597000\n"
"  3  1  1  1  1\n"
"        0.1587289000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O (621/41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  6\n"
"  1  0  0  6  1\n"
"     5222.9020000000  -0.0019363720\n"
"      782.5399000000  -0.0148506700\n"
"      177.2674000000  -0.0733187000\n"
"       49.5166900000  -0.2451162000\n"
"       15.6664400000  -0.4802847000\n"
"        5.1793600000  -0.3359427000\n"
"  2  0  0  2  1\n"
"       10.6014400000   0.0788058200\n"
"        0.9423171000  -0.5676952000\n"
"  3  0  0  1  1\n"
"        0.2774746000   1.0000000000\n"
"  2  1  1  4  1\n"
"       33.4241300000   0.0175603300\n"
"        7.6221710000   0.1076300000\n"
"        2.2382090000   0.3235255000\n"
"        0.6867300000   0.4832229000\n"
"  3  1  1  1  1\n"
"        0.1938135000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F (621/41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  6\n"
"  1  0  0  6  1\n"
"     6384.7140000000  -0.0020301590\n"
"      958.8865000000  -0.0154981000\n"
"      218.1901000000  -0.0757786900\n"
"       61.3647300000  -0.2502724000\n"
"       19.6029000000  -0.4801086000\n"
"        6.5648830000  -0.3271614000\n"
"  2  0  0  2  1\n"
"       13.8106900000   0.0790706600\n"
"        1.2298670000  -0.5681216000\n"
"  3  0  0  1  1\n"
"        0.3584713000   1.0000000000\n"
"  2  1  1  4  1\n"
"       42.4699100000   0.0183170400\n"
"        9.7138810000   0.1124513000\n"
"        2.8640390000   0.3297771000\n"
"        0.8746054000   0.4799772000\n"
"  3  1  1  1  1\n"
"        0.2425071000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"Ne (621/41/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  6\n"
"  1  0  0  6  1\n"
"     7883.8260000000   0.0020374790\n"
"     1184.4060000000   0.0155468100\n"
"      269.6731000000   0.0759637700\n"
"       75.9416500000   0.2511027000\n"
"       24.3210900000   0.4804765000\n"
"        8.1832560000   0.3251142000\n"
"  2  0  0  2  1\n"
"       17.4495200000  -0.0790099700\n"
"        1.5516320000   0.5676274000\n"
"  3  0  0  1  1\n"
"        0.4476986000   1.0000000000\n"
"  2  1  1  4  1\n"
"       52.9038100000   0.0187910600\n"
"       12.1233600000   0.1157605000\n"
"        3.5859220000   0.3342627000\n"
"        1.0921630000   0.4778038000\n"
"  3  1  1  1  1\n"
"        0.2994419000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.2000000000   1.0000000000\n"
"#","\n"
"Na (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"     9911.9960000000   0.0019500000\n"
"     1487.4550000000   0.0148800000\n"
"      337.9539000000   0.0732600000\n"
"       94.9139500000   0.2450700000\n"
"       30.3415000000   0.4787800000\n"
"       10.1908400000   0.3327300000\n"
"  2  0  0  3  1\n"
"       21.2296500000  -0.0917500000\n"
"        1.9804180000   0.5721000000\n"
"        0.6188824000   0.4550100000\n"
"  3  0  0  2  1\n"
"        0.6991738000  -0.1150200000\n"
"        0.0618270500   0.6934500000\n"
"  4  0  0  1  1\n"
"        0.0237274100   1.0000000000\n"
"  2  1  1  5  1\n"
"       73.0853100000  -0.0165900000\n"
"       16.8645600000  -0.1059900000\n"
"        5.0553910000  -0.3220200000\n"
"        1.5920210000  -0.4903600000\n"
"        0.4702690000  -0.3121800000\n"
"  3  1  1  2  1\n"
"        0.1700000000   0.0412900000\n"
"        0.0647000000   0.4041200000\n"
"  4  1  1  1  1\n"
"        0.0170000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1169000000   1.0000000000\n"
"#","\n"
"Na (6321/411/1) DZVP-MONTREAL-ALLELECTRON DZVP-MONTREAL-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"     9911.9960000000   0.0019504590\n"
"     1487.4550000000   0.0149171200\n"
"      337.9539000000   0.0734165800\n"
"       94.9139500000   0.2456910000\n"
"       30.3415000000   0.4795611000\n"
"       10.1908400000   0.3337213000\n"
"  2  0  0  3  1\n"
"       21.2296500000   0.0823028800\n"
"        1.9804180000  -0.5608480000\n"
"        0.6188824000  -0.5224378000\n"
"  3  0  0  2  1\n"
"        0.6991738000   0.0920975500\n"
"        0.0618270500  -0.6708252000\n"
"  4  0  0  1  1\n"
"        0.0237274100   1.0000000000\n"
"  2  1  1  4  1\n"
"       73.0853100000   0.0167176300\n"
"       16.8645600000   0.1065395000\n"
"        5.0553910000   0.3242217000\n"
"        1.5920210000   0.4891362000\n"
"  3  1  1  1  1\n"
"        0.4702690000   1.0000000000\n"
"  4  1  1  1  1\n"
"        0.0647000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1169000000   1.0000000000\n"
"#","\n"
"Mg (6321/411/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    12436.6700000000  -0.0018333240\n"
"     1862.2230000000  -0.0140828100\n"
"      421.3745000000  -0.0700956200\n"
"      117.6930000000  -0.2387718000\n"
"       37.4314500000  -0.4787377000\n"
"       12.5054900000  -0.3447773000\n"
"  2  0  0  3  1\n"
"       25.4514000000   0.0852139700\n"
"        2.4528770000  -0.5646916000\n"
"        0.8051333000  -0.5157275000\n"
"  3  0  0  2  1\n"
"        1.0820080000  -0.1113334000\n"
"        0.1083340000   0.6481452000\n"
"  4  0  0  1  1\n"
"        0.0399073500   1.0000000000\n"
"  2  1  1  4  1\n"
"       92.4632200000   0.0162715700\n"
"       21.5017700000   0.1045630000\n"
"        6.5374420000   0.3224328000\n"
"        2.1180810000   0.4940399000\n"
"  3  1  1  1  1\n"
"        0.6583148000   1.0000000000\n"
"  4  1  1  1  1\n"
"        0.1061000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Al (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    14724.4500000000   0.0018181970\n"
"     2205.4630000000   0.0139580500\n"
"      499.3021000000   0.0695009200\n"
"      139.5901000000   0.2371061000\n"
"       44.4922800000   0.4776104000\n"
"       14.9056900000   0.3476339000\n"
"  2  0  0  3  1\n"
"       30.0750700000  -0.0878851200\n"
"        2.9838330000   0.5677370000\n"
"        1.0209900000   0.5105008000\n"
"  3  0  0  2  1\n"
"        1.4927790000   0.1341424000\n"
"        0.1692291000  -0.6656758000\n"
"  4  0  0  1  1\n"
"        0.0617449100   1.0000000000\n"
"  2  1  1  5  1\n"
"      127.9161000000   0.0133024200\n"
"       29.7767800000   0.0896709600\n"
"        9.0917390000   0.2981308000\n"
"        3.0009870000   0.4962628000\n"
"        0.9695584000   0.3301450000\n"
"  3  1  1  2  1\n"
"        0.3756001000   0.2050982000\n"
"        0.1250989000   0.5518101000\n"
"  4  1  1  1  1\n"
"        0.0417398100   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Si (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    17268.5800000000  -0.0017973950\n"
"     2586.6510000000  -0.0137970400\n"
"      585.6364000000  -0.0687807200\n"
"      163.7736000000  -0.2352508000\n"
"       52.2670300000  -0.4766194000\n"
"       17.5416800000  -0.3507726000\n"
"  2  0  0  3  1\n"
"       35.1241400000   0.0902137000\n"
"        3.5654230000  -0.5722548000\n"
"        1.2591470000  -0.5045537000\n"
"  3  0  0  2  1\n"
"        1.9470140000  -0.1508352000\n"
"        0.2367573000   0.6745594000\n"
"  4  0  0  1  1\n"
"        0.0858966400   1.0000000000\n"
"  2  1  1  5  1\n"
"      159.6817000000  -0.0123932000\n"
"       37.2581700000  -0.0850800400\n"
"       11.4382500000  -0.2905513000\n"
"        3.8278340000  -0.4985588000\n"
"        1.2679000000  -0.3325624000\n"
"  3  1  1  2  1\n"
"        0.5344095000  -0.2264369000\n"
"        0.1829031000  -0.5553035000\n"
"  4  1  1  1  1\n"
"        0.0617872600   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    20024.9400000000  -0.0017787230\n"
"     2999.4410000000  -0.0136540700\n"
"      679.0868000000  -0.0681441600\n"
"      189.9439000000  -0.2336137000\n"
"       60.6834800000  -0.4757401000\n"
"       20.3982300000  -0.3535470000\n"
"  2  0  0  3  1\n"
"       40.5941600000  -0.0922427200\n"
"        4.1972190000   0.5774677000\n"
"        1.5192950000   0.4983773000\n"
"  3  0  0  2  1\n"
"        2.4458590000   0.1631695000\n"
"        0.3116159000  -0.6787174000\n"
"  4  0  0  1  1\n"
"        0.1120101000   1.0000000000\n"
"  2  1  1  5  1\n"
"      195.3994000000  -0.0116298200\n"
"       45.6667500000  -0.0811413200\n"
"       14.0730700000  -0.2837707000\n"
"        4.7572430000  -0.5004074000\n"
"        1.6035060000  -0.3357758000\n"
"  3  1  1  2  1\n"
"        0.7039432000  -0.2471697000\n"
"        0.2451145000  -0.5552025000\n"
"  4  1  1  1  1\n"
"        0.0831324000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    23050.0700000000  -0.0017566500\n"
"     3451.8660000000  -0.0134893800\n"
"      781.2787000000  -0.0674324900\n"
"      218.4765000000  -0.2318604000\n"
"       69.8326300000  -0.4749416000\n"
"       23.4948000000  -0.3564992000\n"
"  2  0  0  3  1\n"
"       46.4823800000  -0.0940421700\n"
"        4.8807490000   0.5828881000\n"
"        1.8014760000   0.4923262000\n"
"  3  0  0  2  1\n"
"        2.9778040000   0.1731553000\n"
"        0.3942510000  -0.6854363000\n"
"  4  0  0  1  1\n"
"        0.1417028000   1.0000000000\n"
"  2  1  1  5  1\n"
"      231.3313000000   0.0112789100\n"
"       54.1461600000   0.0794256900\n"
"       16.7576200000   0.2808799000\n"
"        5.7193200000   0.5020190000\n"
"        1.9560350000   0.3344146000\n"
"  3  1  1  2  1\n"
"        0.8955913000   0.2646811000\n"
"        0.3094227000   0.5496127000\n"
"  4  1  1  1  1\n"
"        0.1021157000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    26351.4600000000   0.0017324290\n"
"     3945.0570000000   0.0133109400\n"
"      892.4384000000   0.0666748300\n"
"      249.4174000000   0.2300506000\n"
"       79.7215700000   0.4742307000\n"
"       26.8311400000   0.3595240000\n"
"  2  0  0  3  1\n"
"       52.7853000000  -0.0956295900\n"
"        5.6156430000   0.5880840000\n"
"        2.1059080000   0.4866982000\n"
"  3  0  0  2  1\n"
"        3.5586150000   0.1806891000\n"
"        0.4847981000  -0.6884829000\n"
"  4  0  0  1  1\n"
"        0.1733310000   1.0000000000\n"
"  2  1  1  5  1\n"
"      271.0782000000  -0.0109256700\n"
"       63.5472100000  -0.0775909100\n"
"       19.7371100000  -0.2775159000\n"
"        6.7889940000  -0.5031933000\n"
"        2.3480300000  -0.3348426000\n"
"  3  1  1  2  1\n"
"        1.1066860000  -0.2765381000\n"
"        0.3829680000  -0.5466768000\n"
"  4  1  1  1  1\n"
"        0.1251133000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar (6321/521/1) DZVP-ALLELECTRON DZVP-ALL\n"
"  8\n"
"  1  0  0  6  1\n"
"    29505.7700000000  -0.0017375040\n"
"     4419.2160000000  -0.0133380900\n"
"     1000.5770000000  -0.0667249100\n"
"      280.0380000000  -0.2298887000\n"
"       89.7120800000  -0.4735744000\n"
"       30.2798800000  -0.3599160000\n"
"  2  0  0  3  1\n"
"       59.5144000000   0.0970257400\n"
"        6.3997780000  -0.5933987000\n"
"        2.4314710000  -0.4810804000\n"
"  3  0  0  2  1\n"
"        4.1875360000  -0.1864000000\n"
"        0.5832562000   0.6895689000\n"
"  4  0  0  1  1\n"
"        0.2071081000   1.0000000000\n"
"  2  1  1  5  1\n"
"      313.0218000000   0.0106753000\n"
"       73.4872300000   0.0763095300\n"
"       22.8979900000   0.2751271000\n"
"        7.9322150000   0.5040719000\n"
"        2.7702700000   0.3346271000\n"
"  3  1  1  2  1\n"
"        1.3318950000   0.2877000000\n"
"        0.4618615000   0.5447527000\n"
"  4  1  1  1  1\n"
"        0.1502194000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"K (63321/5211/1) DZVP-ALLELECTRON DZVP-ALL\n"
" 10\n"
"  1  0  0  6  1\n"
"    33078.6500000000   0.0017266760\n"
"     4954.9020000000   0.0132514200\n"
"     1122.1310000000   0.0663142300\n"
"      314.2081000000   0.2286724000\n"
"      100.7763000000   0.4726698000\n"
"       34.0613500000   0.3621416000\n"
"  2  0  0  3  1\n"
"       66.6029300000  -0.0984506600\n"
"        7.2644560000   0.5941619000\n"
"        2.8036790000   0.4799139000\n"
"  3  0  0  3  1\n"
"        4.8324390000   0.1972709000\n"
"        0.7058188000  -0.6956473000\n"
"        0.2697520000  -0.4228781000\n"
"  4  0  0  2  1\n"
"        0.3533535000  -0.1246783000\n"
"        0.0420916300   0.7383633000\n"
"  5  0  0  1  1\n"
"        0.0174484800   1.0000000000\n"
"  2  1  1  5  1\n"
"      367.5115000000  -0.0100333200\n"
"       86.2608600000  -0.0727348400\n"
"       26.8979700000  -0.2679043000\n"
"        9.3541250000  -0.5038367000\n"
"        3.2920580000  -0.3426224000\n"
"  3  1  1  2  1\n"
"        1.6209190000  -0.2952722000\n"
"        0.5872493000  -0.5563566000\n"
"  4  1  1  1  1\n"
"        0.2046941000   1.0000000000\n"
"  5  1  1  1  1\n"
"        0.0408000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0741000000   1.0000000000\n"
"#","\n"
"Cu (63321/531/41*) DZVP-MONTREAL-ALLELECTRON DZVP-MONTREAL-ALL\n"
" 10\n"
"  1  0  0  6  1\n"
"    80289.6200000000  -0.0016562160\n"
"    12027.3400000000  -0.0127092500\n"
"     2724.2580000000  -0.0638517700\n"
"      763.5617000000  -0.2221154000\n"
"      246.0646000000  -0.4686049000\n"
"       83.8683600000  -0.3733793000\n"
"  2  0  0  3  1\n"
"      161.7973000000   0.1066759000\n"
"       18.7253700000  -0.6245943000\n"
"        7.6364160000  -0.4496724000\n"
"  3  0  0  3  1\n"
"       14.1508300000  -0.2198077000\n"
"        2.2528310000   0.7108760000\n"
"        0.8644886000   0.4206572000\n"
"  4  0  0  2  1\n"
"        1.2230960000   0.1303169000\n"
"        0.1429771000  -0.5708601000\n"
"  5  0  0  1  1\n"
"        0.0504603300   1.0000000000\n"
"  2  1  1  5  1\n"
"     1002.9740000000   0.0089143100\n"
"      236.6253000000   0.0669704300\n"
"       74.8923200000   0.2584147000\n"
"       26.9312500000   0.5070620000\n"
"        9.9267760000   0.3407511000\n"
"  3  1  1  3  1\n"
"        5.3446650000   0.3313745000\n"
"        2.0247480000   0.5459871000\n"
"        0.7366331000   0.2494767000\n"
"  4  1  1  1  1\n"
"        0.1410000000   1.0000000000\n"
"  3  2  2  4  1\n"
"       31.8126700000  -0.0668891400\n"
"        8.6058710000  -0.2907401000\n"
"        2.6093410000  -0.4984195000\n"
"        0.6852135000  -0.4697251000\n"
"  4  2  2  1  1\n"
"        0.1100000000   1.0000000000\n"
"#","\n"
"Cu (63321/531/41) DZVP-ALLELECTRON DZVP-ALL\n"
" 10\n"
"  1  0  0  6  1\n"
"    80289.6200000000   0.0016500000\n"
"    12027.3400000000   0.0127400000\n"
"     2724.2580000000   0.0634300000\n"
"      763.5617000000   0.2238400000\n"
"      246.0646000000   0.4469700000\n"
"       83.8683600000   0.3432300000\n"
"  2  0  0  3  1\n"
"      161.7973000000  -0.0836100000\n"
"       18.7253700000   0.7573900000\n"
"        7.6364160000   0.5060700000\n"
"  3  0  0  3  1\n"
"       14.1508300000  -0.1441800000\n"
"        2.2528310000   0.8250000000\n"
"        0.8644886000   0.4798900000\n"
"  4  0  0  2  1\n"
"        1.2230960000  -0.0785900000\n"
"        0.1429771000   0.5949100000\n"
"  5  0  0  1  1\n"
"        0.0504603300   1.0000000000\n"
"  2  1  1  5  1\n"
"     1002.9740000000   0.0089100000\n"
"      236.6253000000   0.0666800000\n"
"       74.8923200000   0.2569800000\n"
"       26.9312500000   0.5058100000\n"
"        9.9267760000   0.3376600000\n"
"  3  1  1  3  1\n"
"        5.3446650000   0.3484300000\n"
"        2.0247480000   0.5954700000\n"
"        0.7366331000   0.2609100000\n"
"  4  1  1  1  1\n"
"        0.1410000000   1.0000000000\n"
"  3  2  2  4  1\n"
"       31.8126700000   0.0636900000\n"
"        8.6058710000   0.2755200000\n"
"        2.6093410000   0.4756400000\n"
"        0.6852135000   0.4480200000\n"
"  4  2  2  1  1\n"
"        0.1100000000   1.0000000000\n"
"#","\n"
"Cu (633111/5211/311) TZVP-ALLELECTRON TZVP-ALL\n"
" 13\n"
"  1  0  0  6  1\n"
"    80289.6200000000   0.0016500000\n"
"    12027.3400000000   0.0127400000\n"
"     2724.2580000000   0.0634300000\n"
"      763.5617000000   0.2238400000\n"
"      246.0646000000   0.4469700000\n"
"       83.8683600000   0.3432300000\n"
"  2  0  0  3  1\n"
"      161.7973000000  -0.0836100000\n"
"       18.7253700000   0.7573900000\n"
"        7.6364160000   0.5060700000\n"
"  3  0  0  3  1\n"
"       14.1508300000  -0.1441800000\n"
"        2.2528310000   0.8250000000\n"
"        0.8644886000   0.4798900000\n"
"  4  0  0  1  1\n"
"        1.2230960000   1.0000000000\n"
"  5  0  0  1  1\n"
"        0.1429771000   1.0000000000\n"
"  6  0  0  1  1\n"
"        0.0504603300   1.0000000000\n"
"  2  1  1  5  1\n"
"     1002.9740000000   0.0089100000\n"
"      236.6253000000   0.0666800000\n"
"       74.8923200000   0.2569800000\n"
"       26.9312500000   0.5058100000\n"
"        9.9267760000   0.3376600000\n"
"  3  1  1  2  1\n"
"        5.3446650000   0.3484300000\n"
"        2.0247480000   0.5954700000\n"
"  4  1  1  1  1\n"
"        0.7366331000   1.0000000000\n"
"  5  1  1  1  1\n"
"        0.1410000000   1.0000000000\n"
"  3  2  2  3  1\n"
"       31.8126700000   0.0636900000\n"
"        8.6058710000   0.2755200000\n"
"        2.6093410000   0.4756400000\n"
"  4  2  2  1  1\n"
"        0.6852135000   1.0000000000\n"
"  5  2  2  1  1\n"
"        0.1100000000   1.0000000000\n"
"#","\n"
"Zn (63321/531/41) DZVP-ALLELECTRON DZVP-ALL\n"
" 10\n"
"  1  0  0  6  1\n"
"    82904.2200000000  -0.0017313190\n"
"    12444.2300000000  -0.0132328300\n"
"     2829.8530000000  -0.0658900700\n"
"      797.8929000000  -0.2261988000\n"
"      259.0647000000  -0.4683912000\n"
"       89.0795100000  -0.3669156000\n"
"  2  0  0  3  1\n"
"      173.6817000000  -0.1071624000\n"
"       20.1665000000   0.6264982000\n"
"        8.2470820000   0.4478206000\n"
"  3  0  0  3  1\n"
"       15.3165800000  -0.2212375000\n"
"        2.4557490000   0.7091911000\n"
"        0.9548777000   0.4224147000\n"
"  4  0  0  2  1\n"
"        1.4100030000  -0.1404652000\n"
"        0.1693441000   0.6012745000\n"
"  5  0  0  1  1\n"
"        0.0592210000   1.0000000000\n"
"  2  1  1  5  1\n"
"     1085.1780000000   0.0088260260\n"
"      256.1809000000   0.0664454900\n"
"       81.1402500000   0.2574246000\n"
"       29.2225200000   0.5071455000\n"
"       10.7937000000   0.3414356000\n"
"  3  1  1  3  1\n"
"        5.8412900000   0.3312126000\n"
"        2.2263660000   0.5463760000\n"
"        0.8211640000   0.2468144000\n"
"  4  1  1  1  1\n"
"        0.1690000000   1.0000000000\n"
"  3  2  2  4  1\n"
"       38.0934700000  -0.0606966400\n"
"       10.4237600000  -0.2760500000\n"
"        3.2532520000  -0.4982638000\n"
"        0.9097528000  -0.4689898000\n"
"  4  2  2  1  1\n"
"        0.1720000000   1.0000000000\n"
"#","\n"
"Br (63321/5321/41) DZVP-ALLELECTRON DZVP-ALL\n"
" 11\n"
"  1  0  0  6  1\n"
"   115354.1000000000   0.0016893780\n"
"    17308.3900000000   0.0129218500\n"
"     3932.8540000000   0.0645566100\n"
"     1107.7720000000   0.2228721000\n"
"      359.6334000000   0.4668337000\n"
"      123.6999000000   0.3726870000\n"
"  2  0  0  3  1\n"
"      239.1218000000   0.1093640000\n"
"       28.2681300000  -0.6294377000\n"
"       11.7505700000  -0.4449871000\n"
"  3  0  0  3  1\n"
"       21.8299600000   0.2318734000\n"
"        3.6088260000  -0.7272457000\n"
"        1.5164870000  -0.4055866000\n"
"  4  0  0  2  1\n"
"        2.5209370000   0.2202626000\n"
"        0.4093415000  -0.7163121000\n"
"  5  0  0  1  1\n"
"        0.1530953000   1.0000000000\n"
"  2  1  1  5  1\n"
"     1580.3740000000   0.0081757200\n"
"      373.0976000000   0.0625525000\n"
"      118.3523000000   0.2484745000\n"
"       42.8589600000   0.5054137000\n"
"       15.9778700000   0.3523443000\n"
"  3  1  1  3  1\n"
"        8.7533270000   0.3283504000\n"
"        3.5160330000   0.5437991000\n"
"        1.4307380000   0.2357859000\n"
"  4  1  1  2  1\n"
"        0.7091507000  -0.3244162000\n"
"        0.2656835000  -0.5395416000\n"
"  5  1  1  1  1\n"
"        0.0943995000   1.0000000000\n"
"  3  2  2  4  1\n"
"       61.5144200000   0.0595776800\n"
"       17.1619800000   0.2843781000\n"
"        5.5384710000   0.5281856000\n"
"        1.6848170000   0.4047724000\n"
"  4  2  2  1  1\n"
"        0.3620000000   1.0000000000\n"
"#","\n"
"H DZV-ALL-PADE\n"
"  1\n"
"  1  0  0  5  2\n"
"       47.6766821949  -0.0039912598   0.0000000000\n"
"        7.2138252786  -0.0254871433   0.0000000000\n"
"        1.6553477814  -0.1498103667   0.0000000000\n"
"        0.4620756821  -0.2465524925   0.0000000000\n"
"        0.1633279056  -0.6895969065   1.0000000000\n"
"#","\n"
"H DZVP-ALL-PADE\n"
"  2\n"
"  1  0  0  5  2\n"
"       47.6766821949  -0.0039912598   0.0000000000\n"
"        7.2138252786  -0.0254871433   0.0000000000\n"
"        1.6553477814  -0.1498103667   0.0000000000\n"
"        0.4620756821  -0.2465524925   0.0000000000\n"
"        0.1633279056  -0.6895969065   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"He DZV-ALL-PADE\n"
"  1\n"
"  1  0  0  6  2\n"
"      204.6501154200   0.0030044482   0.0000000000\n"
"       31.4140748450   0.0221284099   0.0000000000\n"
"        7.2438462856   0.1007469582   0.0000000000\n"
"        2.0171174742   0.2853415709   0.0000000000\n"
"        0.5990792530   0.4724594508   0.0000000000\n"
"        0.1799489287   0.2977187692   1.0000000000\n"
"#","\n"
"He DZVP-ALL-PADE\n"
"  2\n"
"  1  0  0  6  2\n"
"      204.6501154200   0.0030044482   0.0000000000\n"
"       31.4140748450   0.0221284099   0.0000000000\n"
"        7.2438462856   0.1007469582   0.0000000000\n"
"        2.0171174742   0.2853415709   0.0000000000\n"
"        0.5990792530   0.4724594508   0.0000000000\n"
"        0.1799489287   0.2977187692   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"Li DZV-ALL-PADE\n"
"  1\n"
"  1  0  0  9  3\n"
"     1414.6178762780  -0.0007941411   0.0001418239   0.0000000000\n"
"      212.3358889800  -0.0061171237   0.0010947690   0.0000000000\n"
"       48.4297216336  -0.0308807676   0.0055808506   0.0000000000\n"
"       13.7257942708  -0.1130599452   0.0210246402   0.0000000000\n"
"        4.3982155076  -0.2859257427   0.0578894771   0.0000000000\n"
"        1.4963572281  -0.4501773541   0.1151205889   0.0000000000\n"
"        0.5121133007  -0.2748376742   0.1143680207   0.0000000000\n"
"        0.0746551776  -0.0131827781  -0.5475245168   0.0000000000\n"
"        0.0269341112   0.0043968126  -0.5468255164   1.0000000000\n"
"#","\n"
"Li DZVP-ALL-PADE\n"
"  1\n"
"  1  0  1  9  3  1\n"
"     1414.6178762780  -0.0007941411   0.0001418239   0.0000000000   0.0000000000\n"
"      212.3358889800  -0.0061171237   0.0010947690   0.0000000000   0.0000000000\n"
"       48.4297216336  -0.0308807676   0.0055808506   0.0000000000   0.0000000000\n"
"       13.7257942708  -0.1130599452   0.0210246402   0.0000000000   0.0000000000\n"
"        4.3982155076  -0.2859257427   0.0578894771   0.0000000000   0.0000000000\n"
"        1.4963572281  -0.4501773541   0.1151205889   0.0000000000   0.0000000000\n"
"        0.5121133007  -0.2748376742   0.1143680207   0.0000000000   0.0000000000\n"
"        0.0746551776  -0.0131827781  -0.5475245168   0.0000000000   0.0000000000\n"
"        0.0269341112   0.0043968126  -0.5468255164   1.0000000000   1.0000000000\n"
"#","\n"
"Be DZV-ALL-PADE\n"
"  1\n"
"  1  0  0  9  3\n"
"     2838.2104843030  -0.0007019523   0.0001432987   0.0000000000\n"
"      425.9069835160  -0.0054237190   0.0011215974   0.0000000000\n"
"       96.6806600316  -0.0277505669   0.0057055932   0.0000000000\n"
"       27.2706499785  -0.1041047062   0.0225470947   0.0000000000\n"
"        8.7532305131  -0.2746537186   0.0630242360   0.0000000000\n"
"        3.0282645637  -0.4478941550   0.1362247299   0.0000000000\n"
"        1.0653214420  -0.2921373841   0.1257746042   0.0000000000\n"
"        0.1837410502  -0.0161597639  -0.5389829855   0.0000000000\n"
"        0.0597629783   0.0044284677  -0.5743277205   1.0000000000\n"
"#","\n"
"Be DZVP-ALL-PADE\n"
"  1\n"
"  1  0  1  9  3  1\n"
"     2838.2104843030  -0.0007019523   0.0001432987   0.0000000000   0.0000000000\n"
"      425.9069835160  -0.0054237190   0.0011215974   0.0000000000   0.0000000000\n"
"       96.6806600316  -0.0277505669   0.0057055932   0.0000000000   0.0000000000\n"
"       27.2706499785  -0.1041047062   0.0225470947   0.0000000000   0.0000000000\n"
"        8.7532305131  -0.2746537186   0.0630242360   0.0000000000   0.0000000000\n"
"        3.0282645637  -0.4478941550   0.1362247299   0.0000000000   0.0000000000\n"
"        1.0653214420  -0.2921373841   0.1257746042   0.0000000000   0.0000000000\n"
"        0.1837410502  -0.0161597639  -0.5389829855   0.0000000000   0.0000000000\n"
"        0.0597629783   0.0044284677  -0.5743277205   1.0000000000   1.0000000000\n"
"#","\n"
"B DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  3  3\n"
"     2770.6887201190  -0.0012849920   0.0002815183   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      416.0177319883  -0.0098497439   0.0021926254   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       94.8894954229  -0.0489833356   0.0108940076   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       26.7499548442  -0.1723972150   0.0414450988   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.4264760790  -0.4017468011   0.1087223068   0.0000000000  -0.0194224027   0.0000000000   0.0000000000\n"
"        2.8185756685  -0.4396258903   0.1880725583   0.0000000000  -0.0637848437   0.0000000000   0.0000000000\n"
"        0.8858154287  -0.0939440721  -0.0102057441   0.0000000000  -0.2445403926   0.0000000000   0.0000000000\n"
"        0.2755692515   0.0087352964  -0.6622781443   0.0000000000  -0.4653071695   0.0000000000   1.0000000000\n"
"        0.0836350993  -0.0023332765  -0.4345757818   1.0000000000  -0.4454718873   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"C DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  3  3\n"
"     4266.1800613820  -0.0011943659   0.0002708392   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      642.7602862562  -0.0091221647   0.0021018981   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      146.7884267926  -0.0455862664   0.0104909359   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       41.2743794968  -0.1645442121   0.0408993451   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       12.8905294328  -0.4010362654   0.1123583959   0.0000000000  -0.0207269323   0.0000000000   0.0000000000\n"
"        4.2578431902  -0.4506526871   0.2000200876   0.0000000000  -0.0735133778   0.0000000000   0.0000000000\n"
"        1.3307568939  -0.0932928666  -0.0307479826   0.0000000000  -0.2717786632   0.0000000000   0.0000000000\n"
"        0.4108076579   0.0083827453  -0.6803273620   0.0000000000  -0.4752358588   0.0000000000   1.0000000000\n"
"        0.1203105299  -0.0021601474  -0.4075981685   1.0000000000  -0.4103141270   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"N DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  3  3\n"
"     6241.4478205000  -0.0010992714   0.0002541567   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      942.7853221624  -0.0083836502   0.0019685436   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      215.1071557533  -0.0422134003   0.0099007497   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       60.1999725160  -0.1563225099   0.0394939433   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       18.6046423067  -0.3979589501   0.1133930134   0.0000000000  -0.0210878424   0.0000000000   0.0000000000\n"
"        6.0687801071  -0.4619961627   0.2073232497   0.0000000000  -0.0789077492   0.0000000000   0.0000000000\n"
"        1.8932165206  -0.0957720636  -0.0376291073   0.0000000000  -0.2857497167   0.0000000000   0.0000000000\n"
"        0.5794472569   0.0081210319  -0.6849844121   0.0000000000  -0.4787797641   0.0000000000   1.0000000000\n"
"        0.1652321868  -0.0020517293  -0.4012545190   1.0000000000  -0.3946908536   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  3  3\n"
"     8664.6907364270  -0.0010264289   0.0002401847   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1306.3804630458  -0.0078441700   0.0018629873   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      297.9615739412  -0.0396596073   0.0094113620   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       83.0732192337  -0.1499468244   0.0382308227   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       25.4219803948  -0.3957081736   0.1138918674   0.0000000000  -0.0212313047   0.0000000000   0.0000000000\n"
"        8.2002946495  -0.4708819153   0.2122924071   0.0000000000  -0.0827974544   0.0000000000   0.0000000000\n"
"        2.5534670865  -0.0973701955  -0.0419284053   0.0000000000  -0.2949296208   0.0000000000   0.0000000000\n"
"        0.7764121612   0.0078325892  -0.6868639954   0.0000000000  -0.4802452851   0.0000000000   1.0000000000\n"
"        0.2169654766  -0.0019439564  -0.3986265721   1.0000000000  -0.3854659989   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  3  3\n"
"    11534.0506179760  -0.0009693137   0.0002286337   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1736.4519019727  -0.0074228862   0.0017758908   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      395.6947671892  -0.0376841674   0.0090123001   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      109.8950434029  -0.1450177785   0.0371743948   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       33.3170603602  -0.3943357740   0.1142516978   0.0000000000  -0.0213060126   0.0000000000   0.0000000000\n"
"       10.6395997010  -0.4778632959   0.2159190584   0.0000000000  -0.0858798131   0.0000000000   0.0000000000\n"
"        3.3072015847  -0.0980593066  -0.0454513631   0.0000000000  -0.3015970754   0.0000000000   0.0000000000\n"
"        1.0004259330   0.0075046051  -0.6878291319   0.0000000000  -0.4808474043   0.0000000000   1.0000000000\n"
"        0.2751462303  -0.0018293410  -0.3969701556   1.0000000000  -0.3792605287   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"Ne DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  3  3\n"
"    14852.7741853830  -0.0009235872   0.0002190609   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     2234.8237554633  -0.0070802740   0.0017022734   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      508.8034771653  -0.0360908407   0.0086781493   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      140.7349980722  -0.1411013040   0.0362883902   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       42.2868226841  -0.3936017844   0.1145689028   0.0000000000  -0.0213531723   0.0000000000   0.0000000000\n"
"       13.3814738310  -0.4835123748   0.2187087359   0.0000000000  -0.0884397798   0.0000000000   0.0000000000\n"
"        4.1527137274  -0.0981106306  -0.0486085731   0.0000000000  -0.3067173307   0.0000000000   0.0000000000\n"
"        1.2509672859   0.0071501025  -0.6884074486   0.0000000000  -0.4810347809   0.0000000000   1.0000000000\n"
"        0.3396248365  -0.0017103909  -0.3956395896   1.0000000000  -0.3747659865   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        1.2000000000   1.0000000000\n"
"#","\n"
"Na DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    21394.4924408352   0.0006997970  -0.0001723222   0.0000318328   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     3795.7378701065   0.0042288655  -0.0010411116   0.0001901524   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      985.8138826962   0.0187975202  -0.0046890691   0.0008718578   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      302.7884326942   0.0687646112  -0.0175180517   0.0031871723   0.0000000000  -0.0012633822   0.0000000000   0.0000000000   0.0000000000\n"
"      103.1219260258   0.1965820685  -0.0542917187   0.0102229243   0.0000000000  -0.0055996166   0.0000000000   0.0000000000   0.0000000000\n"
"       37.9946819901   0.3853147762  -0.1258294332   0.0229101289   0.0000000000  -0.0260567422   0.0000000000   0.0000000000   0.0000000000\n"
"       14.7704405101   0.3818197180  -0.1864438254   0.0376735175   0.0000000000  -0.0909943900   0.0000000000   0.0000000000   0.0000000000\n"
"        5.8005968867   0.0996875920  -0.0067937817  -0.0040418885   0.0000000000  -0.2388788121   0.0000000000   0.0000000000   0.0000000000\n"
"        2.2568321873  -0.0028473835   0.4371568026  -0.0847080121   0.0000000000  -0.3819119184   0.0000000000   0.0000000000   0.0000000000\n"
"        0.8574123124   0.0015751503   0.5578917664  -0.2235245000   0.0000000000  -0.3665265555   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3102401678  -0.0004707246   0.1358955383   0.0003703549   0.0000000000  -0.1521385722   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0425973682   0.0000637435  -0.0014197920   1.0326168980   1.0000000000  -0.0040572054   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1169000000   1.0000000000\n"
"#","\n"
"Mg DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    24563.3509341519   0.0007501763  -0.0001898742   0.0000432716   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     4098.7281652598   0.0049866285  -0.0012662269   0.0002886160   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1006.0693449047   0.0236248415  -0.0060608521   0.0013824537   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      296.0583569831   0.0889264612  -0.0236070994   0.0053960194   0.0000000000  -0.0019014218   0.0000000000   0.0000000000   0.0000000000\n"
"       97.5602425330   0.2498577261  -0.0728218452   0.0167469733   0.0000000000  -0.0091160713   0.0000000000   0.0000000000   0.0000000000\n"
"       35.0026526821   0.4370249965  -0.1609409689   0.0376024877   0.0000000000  -0.0414328941   0.0000000000   0.0000000000   0.0000000000\n"
"       13.2894359607   0.3137343310  -0.1793620369   0.0434617096   0.0000000000  -0.1416149186   0.0000000000   0.0000000000   0.0000000000\n"
"        5.0406635723   0.0348223238   0.1488145108  -0.0386567967   0.0000000000  -0.3285471023   0.0000000000   0.0000000000   0.0000000000\n"
"        1.8767656586   0.0002090057   0.6227623758  -0.2075293171   0.0000000000  -0.4342370572   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6740386983  -0.0003911930   0.3832848322  -0.2221884917   0.0000000000  -0.2719424179   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1488350316   0.0001705201   0.0091106555   0.4513483785   0.0000000000  -0.0274310878   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0515990826  -0.0000693922  -0.0006594960   0.6960710466   1.0000000000   0.0065925450   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Al DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    27551.3038803664   0.0007902356   0.0002051247  -0.0000539950   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     4682.7618227118   0.0051091411   0.0013307487  -0.0003509552   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1166.3402011445   0.0238287095   0.0062711660  -0.0016510527   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      346.0032826675   0.0891920482   0.0243060417  -0.0064361456   0.0000000000  -0.0020283510   0.0003943314   0.0000000000   0.0000000000\n"
"      114.4719182078   0.2502089639   0.0749256824  -0.0198886400   0.0000000000  -0.0096153064   0.0020649970   0.0000000000   0.0000000000\n"
"       41.1999175687   0.4367661056   0.1656890319  -0.0450859057   0.0000000000  -0.0438990222   0.0086117474   0.0000000000   0.0000000000\n"
"       15.7012333530   0.3125973574   0.1836095416  -0.0512412586   0.0000000000  -0.1486831836   0.0325680927   0.0000000000   0.0000000000\n"
"        6.0142665071   0.0345570290  -0.1524355487   0.0448540103   0.0000000000  -0.3395431168   0.0689924793   0.0000000000   0.0000000000\n"
"        2.2830453817   0.0004891428  -0.6319413645   0.2602793107   0.0000000000  -0.4356046359   0.1128895908   0.0000000000   0.0000000000\n"
"        0.8490703600  -0.0005055118  -0.3717923282   0.2367424774   0.0000000000  -0.2445346410  -0.0215336434   0.0000000000   0.0000000000\n"
"        0.1896189412   0.0001917544  -0.0078124700  -0.7037552451   0.0000000000  -0.0176080423  -0.4885175925   0.0000000000   1.0000000000\n"
"        0.0590458267  -0.0000711837   0.0005957043  -0.4830773513   1.0000000000   0.0038180642  -0.5990452444   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Si DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    34205.8807706528   0.0007327188   0.0001943796  -0.0000558389   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     5705.2071864975   0.0048710223   0.0012962263  -0.0003727797   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1400.9000355114   0.0230910203   0.0062095461  -0.0017849346   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      411.6831259844   0.0874748743   0.0243401409  -0.0070274320   0.0000000000  -0.0020435691   0.0004608501   0.0000000000   0.0000000000\n"
"      135.3586299298   0.2480782614   0.0758718633  -0.0220186781   0.0000000000  -0.0098284202   0.0024034582   0.0000000000   0.0000000000\n"
"       48.5277674751   0.4375690658   0.1694258836  -0.0503252964   0.0000000000  -0.0454264531   0.0103657478   0.0000000000   0.0000000000\n"
"       18.4574862413   0.3157185815   0.1896317701  -0.0584489572   0.0000000000  -0.1542320032   0.0386846044   0.0000000000   0.0000000000\n"
"        7.0951187369   0.0349093715  -0.1561350675   0.0519518554   0.0000000000  -0.3498959381   0.0835955571   0.0000000000   0.0000000000\n"
"        2.7255967144   0.0007868340  -0.6418259851   0.2969196408   0.0000000000  -0.4363611647   0.1290968861   0.0000000000   0.0000000000\n"
"        1.0416239959  -0.0006880967  -0.3592395770   0.2542270212   0.0000000000  -0.2203688566  -0.0396529577   0.0000000000   0.0000000000\n"
"        0.2679494348   0.0002658227  -0.0069544727  -0.7342316576   0.0000000000  -0.0131604244  -0.5256989764   0.0000000000   1.0000000000\n"
"        0.0814723628  -0.0000897664   0.0000537394  -0.4823523926   1.0000000000   0.0021025311  -0.5604030966   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    36978.0006282670  -0.0007882716  -0.0002130577   0.0000647974   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     6222.2481694120  -0.0051771150  -0.0014042239   0.0004276889   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1534.4538912185  -0.0244536132  -0.0067044703   0.0020403295   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      450.9238919748  -0.0925205949  -0.0263118610   0.0080502303   0.0000000000  -0.0023114207   0.0005787895   0.0000000000   0.0000000000\n"
"      147.9232376649  -0.2603320996  -0.0817937127   0.0251613391   0.0000000000  -0.0110744755   0.0029302708   0.0000000000   0.0000000000\n"
"       52.8962236804  -0.4459248734  -0.1800960112   0.0569273568   0.0000000000  -0.0514807115   0.0130835082   0.0000000000   0.0000000000\n"
"       20.0317880911  -0.2973279703  -0.1864541939   0.0613716013   0.0000000000  -0.1716941092   0.0469534420   0.0000000000   0.0000000000\n"
"        7.7131122202  -0.0245287918   0.2031306430  -0.0738571235   0.0000000000  -0.3732355043   0.1006399940   0.0000000000   0.0000000000\n"
"        2.9844774777  -0.0023042412   0.6642552121  -0.3477214528   0.0000000000  -0.4305581327   0.1364700825   0.0000000000   0.0000000000\n"
"        1.1549719893   0.0014070660   0.3025676551  -0.2237894266   0.0000000000  -0.1767432863  -0.0764816331   0.0000000000   0.0000000000\n"
"        0.3417880814  -0.0005342995   0.0006613566   0.7764969105   0.0000000000  -0.0060298501  -0.5504601345   0.0000000000   1.0000000000\n"
"        0.1040262651   0.0001624777   0.0012215196   0.4569656329   1.0000000000   0.0003271252  -0.5191181650   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    43116.7172343791   0.0007730597  -0.0002123479   0.0000672395   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     7082.1673578265   0.0052570195  -0.0014494275   0.0004599971   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1715.6275383850   0.0252958095  -0.0070506620   0.0022334067   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      498.2117432579   0.0966015002  -0.0279836798   0.0089283399   0.0000000000  -0.0025280039   0.0006830870   0.0000000000   0.0000000000\n"
"      162.0462756704   0.2714940023  -0.0872956329   0.0279726273   0.0000000000  -0.0122585511   0.0034185387   0.0000000000   0.0000000000\n"
"       57.5633179334   0.4540530344  -0.1903753835   0.0630562214   0.0000000000  -0.0575128029   0.0158200681   0.0000000000   0.0000000000\n"
"       21.6195597517   0.2805583500  -0.1820266755   0.0626266086   0.0000000000  -0.1899219376   0.0551163883   0.0000000000   0.0000000000\n"
"        8.2917257402   0.0157911511   0.2559566728  -0.0993256380   0.0000000000  -0.3975202657   0.1178364339   0.0000000000   0.0000000000\n"
"        3.2044042431   0.0036134328   0.6851219839  -0.4018617372   0.0000000000  -0.4219856265   0.1353291071   0.0000000000   0.0000000000\n"
"        1.2170240277  -0.0020726487   0.2416950948  -0.1592676863   0.0000000000  -0.1356765817  -0.1271234105   0.0000000000   0.0000000000\n"
"        0.4039700245   0.0008423916  -0.0069738855   0.8175488469   0.0000000000   0.0006566296  -0.5644015152   0.0000000000   1.0000000000\n"
"        0.1249906733  -0.0002378905   0.0024023008   0.4114888816   1.0000000000  -0.0009601988  -0.4712031290   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    46364.8344532030   0.0008184364  -0.0002280158   0.0000744063   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     7706.7898113396   0.0054783617  -0.0015324266   0.0005015335   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1877.5451692936   0.0262477090  -0.0074240583   0.0024230800   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      545.7287407389   0.1001230552  -0.0294838852   0.0097073844   0.0000000000  -0.0027461074   0.0007848141   0.0000000000   0.0000000000\n"
"      177.2908959787   0.2798008585  -0.0918074467   0.0303344403   0.0000000000  -0.0132763202   0.0038538083   0.0000000000   0.0000000000\n"
"       62.8967566592   0.4581526631  -0.1981397130   0.0680013180   0.0000000000  -0.0625171637   0.0182320502   0.0000000000   0.0000000000\n"
"       23.5441169015   0.2677215656  -0.1777057334   0.0631957627   0.0000000000  -0.2041393264   0.0620073474   0.0000000000   0.0000000000\n"
"        9.0326811369   0.0106407066   0.2956230199  -0.1209002135   0.0000000000  -0.4143068471   0.1319770088   0.0000000000   0.0000000000\n"
"        3.4989881952   0.0043383301   0.6939360980  -0.4432412739   0.0000000000  -0.4107049745   0.1291981811   0.0000000000   0.0000000000\n"
"        1.2944154598  -0.0024408099   0.2012193128  -0.0872175034   0.0000000000  -0.1087289175  -0.1795956787   0.0000000000   0.0000000000\n"
"        0.4597935393   0.0010574389  -0.0118044292   0.8393540477   0.0000000000   0.0044892009  -0.5671711751   0.0000000000   1.0000000000\n"
"        0.1452937050  -0.0002882406   0.0030417630   0.3658485618   1.0000000000  -0.0015760776  -0.4254457201   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar DZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  4  4\n"
"    53072.8297062878   0.0007941425  -0.0002240280   0.0000748195   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     8898.5866473512   0.0052889972  -0.0014977931   0.0005018392   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     2155.9132467432   0.0256852736  -0.0073548393   0.0024566617   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      622.2299227662   0.0989332649  -0.0294812429   0.0099393098   0.0000000000  -0.0027433029   0.0008170301   0.0000000000   0.0000000000\n"
"      201.1659177255   0.2786462711  -0.0925348417   0.0313023547   0.0000000000  -0.0134329689   0.0040333465   0.0000000000   0.0000000000\n"
"       71.1579472025   0.4592775456  -0.2010213397   0.0707758312   0.0000000000  -0.0636580890   0.0193733027   0.0000000000   0.0000000000\n"
"       26.5980018913   0.2694532726  -0.1813760699   0.0661947452   0.0000000000  -0.2085598634   0.0657449676   0.0000000000   0.0000000000\n"
"       10.2137137203   0.0105356188   0.3039220653  -0.1287172743   0.0000000000  -0.4214027465   0.1412356088   0.0000000000   0.0000000000\n"
"        3.9720621706   0.0044532395   0.7006538383  -0.4686337493   0.0000000000  -0.4060028434   0.1270698508   0.0000000000   0.0000000000\n"
"        1.4539972779  -0.0025226750   0.1895810330  -0.0487460947   0.0000000000  -0.0981265591  -0.2131809278   0.0000000000   0.0000000000\n"
"        0.5293705047   0.0011246747  -0.0136173212   0.8447511774   0.0000000000   0.0056716141  -0.5665305364   0.0000000000   1.0000000000\n"
"        0.1690528118  -0.0003035245   0.0032997478   0.3442490945   1.0000000000  -0.0017347653  -0.3971352648   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"H DZV-ALL-PADE-NEW\n"
"  1\n"
"  1  0  0  5  2\n"
"       47.6766821949  -0.0039912598   0.0000000000\n"
"        7.2138252786  -0.0254871433   0.0000000000\n"
"        1.6553477814  -0.1498103667   0.0000000000\n"
"        0.4620756821  -0.2465524925   0.0000000000\n"
"        0.1633279056  -0.6895969065   1.0000000000\n"
"#","\n"
"H DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  0  5  2\n"
"       47.6766821949  -0.0039912598   0.0000000000\n"
"        7.2138252786  -0.0254871433   0.0000000000\n"
"        1.6553477814  -0.1498103667   0.0000000000\n"
"        0.4620756821  -0.2465524925   0.0000000000\n"
"        0.1633279056  -0.6895969065   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"He DZV-ALL-PADE-NEW\n"
"  1\n"
"  1  0  0  6  2\n"
"      204.6501154200   0.0030044482   0.0000000000\n"
"       31.4140748450   0.0221284099   0.0000000000\n"
"        7.2438462856   0.1007469582   0.0000000000\n"
"        2.0171174742   0.2853415709   0.0000000000\n"
"        0.5990792530   0.4724594508   0.0000000000\n"
"        0.1799489287   0.2977187692   1.0000000000\n"
"#","\n"
"He DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  0  6  2\n"
"      204.6501154200   0.0030044482   0.0000000000\n"
"       31.4140748450   0.0221284099   0.0000000000\n"
"        7.2438462856   0.1007469582   0.0000000000\n"
"        2.0171174742   0.2853415709   0.0000000000\n"
"        0.5990792530   0.4724594508   0.0000000000\n"
"        0.1799489287   0.2977187692   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"Li DZV-ALL-PADE-NEW\n"
"  1\n"
"  1  0  0  9  3\n"
"     1414.6178762780  -0.0007941411   0.0001418239   0.0000000000\n"
"      212.3358889800  -0.0061171237   0.0010947690   0.0000000000\n"
"       48.4297216336  -0.0308807676   0.0055808506   0.0000000000\n"
"       13.7257942708  -0.1130599452   0.0210246402   0.0000000000\n"
"        4.3982155076  -0.2859257427   0.0578894771   0.0000000000\n"
"        1.4963572281  -0.4501773541   0.1151205889   0.0000000000\n"
"        0.5121133007  -0.2748376742   0.1143680207   0.0000000000\n"
"        0.0746551776  -0.0131827781  -0.5475245168   0.0000000000\n"
"        0.0269341112   0.0043968126  -0.5468255164   1.0000000000\n"
"#","\n"
"Li DZVP-ALL-PADE-NEW\n"
"  1\n"
"  1  0  1  9  3  2\n"
"     1414.6178762780  -0.0007941411   0.0001418239   0.0000000000   0.0000000000   0.0000000000\n"
"      212.3358889800  -0.0061171237   0.0010947690   0.0000000000   0.0000000000   0.0000000000\n"
"       48.4297216336  -0.0308807676   0.0055808506   0.0000000000   0.0000000000   0.0000000000\n"
"       13.7257942708  -0.1130599452   0.0210246402   0.0000000000   0.0000000000   0.0000000000\n"
"        4.3982155076  -0.2859257427   0.0578894771   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4963572281  -0.4501773541   0.1151205889   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5121133007  -0.2748376742   0.1143680207   0.0000000000   0.0000000000   0.0000000000\n"
"        0.0746551776  -0.0131827781  -0.5475245168   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0269341112   0.0043968126  -0.5468255164   1.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Be DZV-ALL-PADE-NEW\n"
"  1\n"
"  1  0  0  9  3\n"
"     2838.2104843030  -0.0007019523   0.0001432987   0.0000000000\n"
"      425.9069835160  -0.0054237190   0.0011215974   0.0000000000\n"
"       96.6806600316  -0.0277505669   0.0057055932   0.0000000000\n"
"       27.2706499785  -0.1041047062   0.0225470947   0.0000000000\n"
"        8.7532305131  -0.2746537186   0.0630242360   0.0000000000\n"
"        3.0282645637  -0.4478941550   0.1362247299   0.0000000000\n"
"        1.0653214420  -0.2921373841   0.1257746042   0.0000000000\n"
"        0.1837410502  -0.0161597639  -0.5389829855   0.0000000000\n"
"        0.0597629783   0.0044284677  -0.5743277205   1.0000000000\n"
"#","\n"
"Be DZVP-ALL-PADE-NEW\n"
"  1\n"
"  1  0  1  9  3  2\n"
"     2838.2104843030  -0.0007019523   0.0001432987   0.0000000000   0.0000000000   0.0000000000\n"
"      425.9069835160  -0.0054237190   0.0011215974   0.0000000000   0.0000000000   0.0000000000\n"
"       96.6806600316  -0.0277505669   0.0057055932   0.0000000000   0.0000000000   0.0000000000\n"
"       27.2706499785  -0.1041047062   0.0225470947   0.0000000000   0.0000000000   0.0000000000\n"
"        8.7532305131  -0.2746537186   0.0630242360   0.0000000000   0.0000000000   0.0000000000\n"
"        3.0282645637  -0.4478941550   0.1362247299   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0653214420  -0.2921373841   0.1257746042   0.0000000000   0.0000000000   0.0000000000\n"
"        0.1837410502  -0.0161597639  -0.5389829855   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0597629783   0.0044284677  -0.5743277205   1.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"B DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1  9  3  2\n"
"     2770.6887201190  -0.0012849920   0.0002815183   0.0000000000   0.0000000000   0.0000000000\n"
"      416.0177319883  -0.0098497439   0.0021926254   0.0000000000   0.0000000000   0.0000000000\n"
"       94.8894954229  -0.0489833356   0.0108940076   0.0000000000   0.0000000000   0.0000000000\n"
"       26.7499548442  -0.1723972150   0.0414450988   0.0000000000   0.0000000000   0.0000000000\n"
"        8.4264760790  -0.4017468011   0.1087223068   0.0000000000  -0.0194224027   0.0000000000\n"
"        2.8185756685  -0.4396258903   0.1880725583   0.0000000000  -0.0637848437   0.0000000000\n"
"        0.8858154287  -0.0939440721  -0.0102057441   0.0000000000  -0.2445403926   0.0000000000\n"
"        0.2755692515   0.0087352964  -0.6622781443   0.0000000000  -0.4653071695   0.0000000000\n"
"        0.0836350993  -0.0023332765  -0.4345757818   1.0000000000  -0.4454718873   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"C DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1  9  3  2\n"
"     4266.1800613820  -0.0011943659   0.0002708392   0.0000000000   0.0000000000   0.0000000000\n"
"      642.7602862562  -0.0091221647   0.0021018981   0.0000000000   0.0000000000   0.0000000000\n"
"      146.7884267926  -0.0455862664   0.0104909359   0.0000000000   0.0000000000   0.0000000000\n"
"       41.2743794968  -0.1645442121   0.0408993451   0.0000000000   0.0000000000   0.0000000000\n"
"       12.8905294328  -0.4010362654   0.1123583959   0.0000000000  -0.0207269323   0.0000000000\n"
"        4.2578431902  -0.4506526871   0.2000200876   0.0000000000  -0.0735133778   0.0000000000\n"
"        1.3307568939  -0.0932928666  -0.0307479826   0.0000000000  -0.2717786632   0.0000000000\n"
"        0.4108076579   0.0083827453  -0.6803273620   0.0000000000  -0.4752358588   0.0000000000\n"
"        0.1203105299  -0.0021601474  -0.4075981685   1.0000000000  -0.4103141270   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"C DZVP-ALL-PADE-NEW-CONFINED\n"
"  2\n"
"  1  0  1  9  3  2\n"
"     4632.6109261696  -0.0010491808   0.0002461448   0.0000000000   0.0000000000   0.0000000000\n"
"      743.7957159823  -0.0073693327   0.0017441253   0.0000000000   0.0000000000   0.0000000000\n"
"      176.9921440195  -0.0356124607   0.0084765994   0.0000000000   0.0000000000   0.0000000000\n"
"       51.1239838771  -0.1296976533   0.0325377884   0.0000000000   0.0000000000   0.0000000000\n"
"       16.3281731915  -0.3377322464   0.0944035645   0.0000000000  -0.0162087526   0.0000000000\n"
"        5.5265358443  -0.4718174357   0.1851968433   0.0000000000  -0.0517011722   0.0000000000\n"
"        1.8931812532  -0.1789961518   0.0990225545   0.0000000000  -0.2045873835   0.0000000000\n"
"        0.6098030227   0.0053187867  -0.4713283667   0.0000000000  -0.4496981983   0.0000000000\n"
"        0.2069219808  -0.0024734214  -0.6664084300   1.0000000000  -0.4809024290   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"N DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1  9  3  2\n"
"     6241.4478205000  -0.0010992714   0.0002541567   0.0000000000   0.0000000000   0.0000000000\n"
"      942.7853221624  -0.0083836502   0.0019685436   0.0000000000   0.0000000000   0.0000000000\n"
"      215.1071557533  -0.0422134003   0.0099007497   0.0000000000   0.0000000000   0.0000000000\n"
"       60.1999725160  -0.1563225099   0.0394939433   0.0000000000   0.0000000000   0.0000000000\n"
"       18.6046423067  -0.3979589501   0.1133930134   0.0000000000  -0.0210878424   0.0000000000\n"
"        6.0687801071  -0.4619961627   0.2073232497   0.0000000000  -0.0789077492   0.0000000000\n"
"        1.8932165206  -0.0957720636  -0.0376291073   0.0000000000  -0.2857497167   0.0000000000\n"
"        0.5794472569   0.0081210319  -0.6849844121   0.0000000000  -0.4787797641   0.0000000000\n"
"        0.1652321868  -0.0020517293  -0.4012545190   1.0000000000  -0.3946908536   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1  9  3  2\n"
"     8664.6907364270  -0.0010264289   0.0002401847   0.0000000000   0.0000000000   0.0000000000\n"
"     1306.3804630458  -0.0078441700   0.0018629873   0.0000000000   0.0000000000   0.0000000000\n"
"      297.9615739412  -0.0396596073   0.0094113620   0.0000000000   0.0000000000   0.0000000000\n"
"       83.0732192337  -0.1499468244   0.0382308227   0.0000000000   0.0000000000   0.0000000000\n"
"       25.4219803948  -0.3957081736   0.1138918674   0.0000000000  -0.0212313047   0.0000000000\n"
"        8.2002946495  -0.4708819153   0.2122924071   0.0000000000  -0.0827974544   0.0000000000\n"
"        2.5534670865  -0.0973701955  -0.0419284053   0.0000000000  -0.2949296208   0.0000000000\n"
"        0.7764121612   0.0078325892  -0.6868639954   0.0000000000  -0.4802452851   0.0000000000\n"
"        0.2169654766  -0.0019439564  -0.3986265721   1.0000000000  -0.3854659989   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1  9  3  2\n"
"    11534.0506179760  -0.0009693137   0.0002286337   0.0000000000   0.0000000000   0.0000000000\n"
"     1736.4519019727  -0.0074228862   0.0017758908   0.0000000000   0.0000000000   0.0000000000\n"
"      395.6947671892  -0.0376841674   0.0090123001   0.0000000000   0.0000000000   0.0000000000\n"
"      109.8950434029  -0.1450177785   0.0371743948   0.0000000000   0.0000000000   0.0000000000\n"
"       33.3170603602  -0.3943357740   0.1142516978   0.0000000000  -0.0213060126   0.0000000000\n"
"       10.6395997010  -0.4778632959   0.2159190584   0.0000000000  -0.0858798131   0.0000000000\n"
"        3.3072015847  -0.0980593066  -0.0454513631   0.0000000000  -0.3015970754   0.0000000000\n"
"        1.0004259330   0.0075046051  -0.6878291319   0.0000000000  -0.4808474043   0.0000000000\n"
"        0.2751462303  -0.0018293410  -0.3969701556   1.0000000000  -0.3792605287   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"Ne DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1  9  3  2\n"
"    14852.7741853830  -0.0009235872   0.0002190609   0.0000000000   0.0000000000   0.0000000000\n"
"     2234.8237554633  -0.0070802740   0.0017022734   0.0000000000   0.0000000000   0.0000000000\n"
"      508.8034771653  -0.0360908407   0.0086781493   0.0000000000   0.0000000000   0.0000000000\n"
"      140.7349980722  -0.1411013040   0.0362883902   0.0000000000   0.0000000000   0.0000000000\n"
"       42.2868226841  -0.3936017844   0.1145689028   0.0000000000  -0.0213531723   0.0000000000\n"
"       13.3814738310  -0.4835123748   0.2187087359   0.0000000000  -0.0884397798   0.0000000000\n"
"        4.1527137274  -0.0981106306  -0.0486085731   0.0000000000  -0.3067173307   0.0000000000\n"
"        1.2509672859   0.0071501025  -0.6884074486   0.0000000000  -0.4810347809   0.0000000000\n"
"        0.3396248365  -0.0017103909  -0.3956395896   1.0000000000  -0.3747659865   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.2000000000   1.0000000000\n"
"#","\n"
"Na DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    21394.4924408352   0.0006997970  -0.0001723222   0.0000318328   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     3795.7378701065   0.0042288655  -0.0010411116   0.0001901524   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      985.8138826962   0.0187975202  -0.0046890691   0.0008718578   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      302.7884326942   0.0687646112  -0.0175180517   0.0031871723   0.0000000000  -0.0012633822   0.0000000000   0.0000000000\n"
"      103.1219260258   0.1965820685  -0.0542917187   0.0102229243   0.0000000000  -0.0055996166   0.0000000000   0.0000000000\n"
"       37.9946819901   0.3853147762  -0.1258294332   0.0229101289   0.0000000000  -0.0260567422   0.0000000000   0.0000000000\n"
"       14.7704405101   0.3818197180  -0.1864438254   0.0376735175   0.0000000000  -0.0909943900   0.0000000000   0.0000000000\n"
"        5.8005968867   0.0996875920  -0.0067937817  -0.0040418885   0.0000000000  -0.2388788121   0.0000000000   0.0000000000\n"
"        2.2568321873  -0.0028473835   0.4371568026  -0.0847080121   0.0000000000  -0.3819119184   0.0000000000   0.0000000000\n"
"        0.8574123124   0.0015751503   0.5578917664  -0.2235245000   0.0000000000  -0.3665265555   0.0000000000   0.0000000000\n"
"        0.3102401678  -0.0004707246   0.1358955383   0.0003703549   0.0000000000  -0.1521385722   1.0000000000   0.0000000000\n"
"        0.0425973682   0.0000637435  -0.0014197920   1.0326168980   1.0000000000  -0.0040572054   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1169000000   1.0000000000\n"
"#","\n"
"Mg DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    24563.3509341519   0.0007501763  -0.0001898742   0.0000432716   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     4098.7281652598   0.0049866285  -0.0012662269   0.0002886160   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1006.0693449047   0.0236248415  -0.0060608521   0.0013824537   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      296.0583569831   0.0889264612  -0.0236070994   0.0053960194   0.0000000000  -0.0019014218   0.0000000000   0.0000000000\n"
"       97.5602425330   0.2498577261  -0.0728218452   0.0167469733   0.0000000000  -0.0091160713   0.0000000000   0.0000000000\n"
"       35.0026526821   0.4370249965  -0.1609409689   0.0376024877   0.0000000000  -0.0414328941   0.0000000000   0.0000000000\n"
"       13.2894359607   0.3137343310  -0.1793620369   0.0434617096   0.0000000000  -0.1416149186   0.0000000000   0.0000000000\n"
"        5.0406635723   0.0348223238   0.1488145108  -0.0386567967   0.0000000000  -0.3285471023   0.0000000000   0.0000000000\n"
"        1.8767656586   0.0002090057   0.6227623758  -0.2075293171   0.0000000000  -0.4342370572   0.0000000000   0.0000000000\n"
"        0.6740386983  -0.0003911930   0.3832848322  -0.2221884917   0.0000000000  -0.2719424179   0.0000000000   0.0000000000\n"
"        0.1488350316   0.0001705201   0.0091106555   0.4513483785   0.0000000000  -0.0274310878   1.0000000000   0.0000000000\n"
"        0.0515990826  -0.0000693922  -0.0006594960   0.6960710466   1.0000000000   0.0065925450   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Al DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    27551.3038803664   0.0007902356   0.0002051247  -0.0000539950   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     4682.7618227118   0.0051091411   0.0013307487  -0.0003509552   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1166.3402011445   0.0238287095   0.0062711660  -0.0016510527   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      346.0032826675   0.0891920482   0.0243060417  -0.0064361456   0.0000000000  -0.0020283510   0.0003943314   0.0000000000\n"
"      114.4719182078   0.2502089639   0.0749256824  -0.0198886400   0.0000000000  -0.0096153064   0.0020649970   0.0000000000\n"
"       41.1999175687   0.4367661056   0.1656890319  -0.0450859057   0.0000000000  -0.0438990222   0.0086117474   0.0000000000\n"
"       15.7012333530   0.3125973574   0.1836095416  -0.0512412586   0.0000000000  -0.1486831836   0.0325680927   0.0000000000\n"
"        6.0142665071   0.0345570290  -0.1524355487   0.0448540103   0.0000000000  -0.3395431168   0.0689924793   0.0000000000\n"
"        2.2830453817   0.0004891428  -0.6319413645   0.2602793107   0.0000000000  -0.4356046359   0.1128895908   0.0000000000\n"
"        0.8490703600  -0.0005055118  -0.3717923282   0.2367424774   0.0000000000  -0.2445346410  -0.0215336434   0.0000000000\n"
"        0.1896189412   0.0001917544  -0.0078124700  -0.7037552451   0.0000000000  -0.0176080423  -0.4885175925   0.0000000000\n"
"        0.0590458267  -0.0000711837   0.0005957043  -0.4830773513   1.0000000000   0.0038180642  -0.5990452444   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Si DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    34205.8807706528   0.0007327188   0.0001943796  -0.0000558389   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     5705.2071864975   0.0048710223   0.0012962263  -0.0003727797   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1400.9000355114   0.0230910203   0.0062095461  -0.0017849346   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      411.6831259844   0.0874748743   0.0243401409  -0.0070274320   0.0000000000  -0.0020435691   0.0004608501   0.0000000000\n"
"      135.3586299298   0.2480782614   0.0758718633  -0.0220186781   0.0000000000  -0.0098284202   0.0024034582   0.0000000000\n"
"       48.5277674751   0.4375690658   0.1694258836  -0.0503252964   0.0000000000  -0.0454264531   0.0103657478   0.0000000000\n"
"       18.4574862413   0.3157185815   0.1896317701  -0.0584489572   0.0000000000  -0.1542320032   0.0386846044   0.0000000000\n"
"        7.0951187369   0.0349093715  -0.1561350675   0.0519518554   0.0000000000  -0.3498959381   0.0835955571   0.0000000000\n"
"        2.7255967144   0.0007868340  -0.6418259851   0.2969196408   0.0000000000  -0.4363611647   0.1290968861   0.0000000000\n"
"        1.0416239959  -0.0006880967  -0.3592395770   0.2542270212   0.0000000000  -0.2203688566  -0.0396529577   0.0000000000\n"
"        0.2679494348   0.0002658227  -0.0069544727  -0.7342316576   0.0000000000  -0.0131604244  -0.5256989764   0.0000000000\n"
"        0.0814723628  -0.0000897664   0.0000537394  -0.4823523926   1.0000000000   0.0021025311  -0.5604030966   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"Si DZVP-ALL-PADE-NEW-CONFINED\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    34205.8807706528  -0.0007250833  -0.0001923205  -0.0000562487   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     5862.8987880849  -0.0046320509  -0.0012317373  -0.0003597167   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1469.7841832649  -0.0215037349  -0.0057791418  -0.0016933695   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      437.7710897905  -0.0808773954  -0.0224211779  -0.0065639379   0.0000000000  -0.0018310926   0.0004497923   0.0000000000\n"
"      145.2906854908  -0.2311846174  -0.0700642670  -0.0207468988   0.0000000000  -0.0086848321   0.0022634300   0.0000000000\n"
"       52.4935101069  -0.4235892976  -0.1594640775  -0.0477647759   0.0000000000  -0.0401672864   0.0099776953   0.0000000000\n"
"       20.1350286776  -0.3395538298  -0.1966123125  -0.0622802590   0.0000000000  -0.1384353363   0.0369505072   0.0000000000\n"
"        7.7970699880  -0.0514349592   0.1015781624   0.0362142447   0.0000000000  -0.3280724073   0.0855552742   0.0000000000\n"
"        3.0126365952   0.0007938866   0.6138991409   0.2684108647   0.0000000000  -0.4389286243   0.1342617724   0.0000000000\n"
"        1.1536933283   0.0000152963   0.4217267721   0.3164997698   0.0000000000  -0.2544553578  -0.0014632113   0.0000000000\n"
"        0.3215383280  -0.0000675058   0.0171213835  -0.5537569632   0.0000000000  -0.0222713737  -0.4583562382   0.0000000000\n"
"        0.1132249636   0.0000282717  -0.0013106938  -0.6608856513   1.0000000000   0.0035467037  -0.6194427763   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    36978.0006282670  -0.0007882716  -0.0002130577   0.0000647974   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     6222.2481694120  -0.0051771150  -0.0014042239   0.0004276889   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1534.4538912185  -0.0244536132  -0.0067044703   0.0020403295   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      450.9238919748  -0.0925205949  -0.0263118610   0.0080502303   0.0000000000  -0.0023114207   0.0005787895   0.0000000000\n"
"      147.9232376649  -0.2603320996  -0.0817937127   0.0251613391   0.0000000000  -0.0110744755   0.0029302708   0.0000000000\n"
"       52.8962236804  -0.4459248734  -0.1800960112   0.0569273568   0.0000000000  -0.0514807115   0.0130835082   0.0000000000\n"
"       20.0317880911  -0.2973279703  -0.1864541939   0.0613716013   0.0000000000  -0.1716941092   0.0469534420   0.0000000000\n"
"        7.7131122202  -0.0245287918   0.2031306430  -0.0738571235   0.0000000000  -0.3732355043   0.1006399940   0.0000000000\n"
"        2.9844774777  -0.0023042412   0.6642552121  -0.3477214528   0.0000000000  -0.4305581327   0.1364700825   0.0000000000\n"
"        1.1549719893   0.0014070660   0.3025676551  -0.2237894266   0.0000000000  -0.1767432863  -0.0764816331   0.0000000000\n"
"        0.3417880814  -0.0005342995   0.0006613566   0.7764969105   0.0000000000  -0.0060298501  -0.5504601345   0.0000000000\n"
"        0.1040262651   0.0001624777   0.0012215196   0.4569656329   1.0000000000   0.0003271252  -0.5191181650   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    43116.7172343791   0.0007730597  -0.0002123479   0.0000672395   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     7082.1673578265   0.0052570195  -0.0014494275   0.0004599971   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1715.6275383850   0.0252958095  -0.0070506620   0.0022334067   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      498.2117432579   0.0966015002  -0.0279836798   0.0089283399   0.0000000000  -0.0025280039   0.0006830870   0.0000000000\n"
"      162.0462756704   0.2714940023  -0.0872956329   0.0279726273   0.0000000000  -0.0122585511   0.0034185387   0.0000000000\n"
"       57.5633179334   0.4540530344  -0.1903753835   0.0630562214   0.0000000000  -0.0575128029   0.0158200681   0.0000000000\n"
"       21.6195597517   0.2805583500  -0.1820266755   0.0626266086   0.0000000000  -0.1899219376   0.0551163883   0.0000000000\n"
"        8.2917257402   0.0157911511   0.2559566728  -0.0993256380   0.0000000000  -0.3975202657   0.1178364339   0.0000000000\n"
"        3.2044042431   0.0036134328   0.6851219839  -0.4018617372   0.0000000000  -0.4219856265   0.1353291071   0.0000000000\n"
"        1.2170240277  -0.0020726487   0.2416950948  -0.1592676863   0.0000000000  -0.1356765817  -0.1271234105   0.0000000000\n"
"        0.4039700245   0.0008423916  -0.0069738855   0.8175488469   0.0000000000   0.0006566296  -0.5644015152   0.0000000000\n"
"        0.1249906733  -0.0002378905   0.0024023008   0.4114888816   1.0000000000  -0.0009601988  -0.4712031290   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    46364.8344532030   0.0008184364  -0.0002280158   0.0000744063   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     7706.7898113396   0.0054783617  -0.0015324266   0.0005015335   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1877.5451692936   0.0262477090  -0.0074240583   0.0024230800   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      545.7287407389   0.1001230552  -0.0294838852   0.0097073844   0.0000000000  -0.0027461074   0.0007848141   0.0000000000\n"
"      177.2908959787   0.2798008585  -0.0918074467   0.0303344403   0.0000000000  -0.0132763202   0.0038538083   0.0000000000\n"
"       62.8967566592   0.4581526631  -0.1981397130   0.0680013180   0.0000000000  -0.0625171637   0.0182320502   0.0000000000\n"
"       23.5441169015   0.2677215656  -0.1777057334   0.0631957627   0.0000000000  -0.2041393264   0.0620073474   0.0000000000\n"
"        9.0326811369   0.0106407066   0.2956230199  -0.1209002135   0.0000000000  -0.4143068471   0.1319770088   0.0000000000\n"
"        3.4989881952   0.0043383301   0.6939360980  -0.4432412739   0.0000000000  -0.4107049745   0.1291981811   0.0000000000\n"
"        1.2944154598  -0.0024408099   0.2012193128  -0.0872175034   0.0000000000  -0.1087289175  -0.1795956787   0.0000000000\n"
"        0.4597935393   0.0010574389  -0.0118044292   0.8393540477   0.0000000000   0.0044892009  -0.5671711751   0.0000000000\n"
"        0.1452937050  -0.0002882406   0.0030417630   0.3658485618   1.0000000000  -0.0015760776  -0.4254457201   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar DZVP-ALL-PADE-NEW\n"
"  2\n"
"  1  0  1 12  4  3\n"
"    53072.8297062878   0.0007941425  -0.0002240280   0.0000748195   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     8898.5866473512   0.0052889972  -0.0014977931   0.0005018392   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     2155.9132467432   0.0256852736  -0.0073548393   0.0024566617   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      622.2299227662   0.0989332649  -0.0294812429   0.0099393098   0.0000000000  -0.0027433029   0.0008170301   0.0000000000\n"
"      201.1659177255   0.2786462711  -0.0925348417   0.0313023547   0.0000000000  -0.0134329689   0.0040333465   0.0000000000\n"
"       71.1579472025   0.4592775456  -0.2010213397   0.0707758312   0.0000000000  -0.0636580890   0.0193733027   0.0000000000\n"
"       26.5980018913   0.2694532726  -0.1813760699   0.0661947452   0.0000000000  -0.2085598634   0.0657449676   0.0000000000\n"
"       10.2137137203   0.0105356188   0.3039220653  -0.1287172743   0.0000000000  -0.4214027465   0.1412356088   0.0000000000\n"
"        3.9720621706   0.0044532395   0.7006538383  -0.4686337493   0.0000000000  -0.4060028434   0.1270698508   0.0000000000\n"
"        1.4539972779  -0.0025226750   0.1895810330  -0.0487460947   0.0000000000  -0.0981265591  -0.2131809278   0.0000000000\n"
"        0.5293705047   0.0011246747  -0.0136173212   0.8447511774   0.0000000000   0.0056716141  -0.5665305364   0.0000000000\n"
"        0.1690528118  -0.0003035245   0.0032997478   0.3442490945   1.0000000000  -0.0017347653  -0.3971352648   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"H TZV-ALL-PADE\n"
"  1\n"
"  1  0  0  5  3\n"
"       47.6766821949  -0.0039912598   0.0000000000   0.0000000000\n"
"        7.2138252786  -0.0254871433   0.0000000000   0.0000000000\n"
"        1.6553477814  -0.1498103667   0.0000000000   0.0000000000\n"
"        0.4620756821  -0.2465524925   1.0000000000   0.0000000000\n"
"        0.1633279056  -0.6895969065   0.0000000000   1.0000000000\n"
"#","\n"
"H TZVP-ALL-PADE\n"
"  2\n"
"  1  0  0  5  3\n"
"       47.6766821949  -0.0039912598   0.0000000000   0.0000000000\n"
"        7.2138252786  -0.0254871433   0.0000000000   0.0000000000\n"
"        1.6553477814  -0.1498103667   0.0000000000   0.0000000000\n"
"        0.4620756821  -0.2465524925   1.0000000000   0.0000000000\n"
"        0.1633279056  -0.6895969065   0.0000000000   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"He TZV-ALL-PADE\n"
"  1\n"
"  1  0  0  6  3\n"
"      204.6501154200   0.0030044482   0.0000000000   0.0000000000\n"
"       31.4140748450   0.0221284099   0.0000000000   0.0000000000\n"
"        7.2438462856   0.1007469582   0.0000000000   0.0000000000\n"
"        2.0171174742   0.2853415709   0.0000000000   0.0000000000\n"
"        0.5990792530   0.4724594508   1.0000000000   0.0000000000\n"
"        0.1799489287   0.2977187692   0.0000000000   1.0000000000\n"
"#","\n"
"He TZVP-ALL-PADE\n"
"  2\n"
"  1  0  0  6  3\n"
"      204.6501154200   0.0030044482   0.0000000000   0.0000000000\n"
"       31.4140748450   0.0221284099   0.0000000000   0.0000000000\n"
"        7.2438462856   0.1007469582   0.0000000000   0.0000000000\n"
"        2.0171174742   0.2853415709   0.0000000000   0.0000000000\n"
"        0.5990792530   0.4724594508   1.0000000000   0.0000000000\n"
"        0.1799489287   0.2977187692   0.0000000000   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"B TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  4  3\n"
"     2770.6887201190  -0.0012849920   0.0002815183   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      416.0177319883  -0.0098497439   0.0021926254   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       94.8894954229  -0.0489833356   0.0108940076   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       26.7499548442  -0.1723972150   0.0414450988   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.4264760790  -0.4017468011   0.1087223068   0.0000000000   0.0000000000  -0.0194224027   0.0000000000   0.0000000000\n"
"        2.8185756685  -0.4396258903   0.1880725583   0.0000000000   0.0000000000  -0.0637848437   0.0000000000   0.0000000000\n"
"        0.8858154287  -0.0939440721  -0.0102057441   0.0000000000   0.0000000000  -0.2445403926   0.0000000000   0.0000000000\n"
"        0.2755692515   0.0087352964  -0.6622781443   1.0000000000   0.0000000000  -0.4653071695   1.0000000000   0.0000000000\n"
"        0.0836350993  -0.0023332765  -0.4345757818   0.0000000000   1.0000000000  -0.4454718873   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"C TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  4  3\n"
"     4266.1800613820  -0.0011943659   0.0002708392   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      642.7602862562  -0.0091221647   0.0021018981   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      146.7884267926  -0.0455862664   0.0104909359   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       41.2743794968  -0.1645442121   0.0408993451   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       12.8905294328  -0.4010362654   0.1123583959   0.0000000000   0.0000000000  -0.0207269323   0.0000000000   0.0000000000\n"
"        4.2578431902  -0.4506526871   0.2000200876   0.0000000000   0.0000000000  -0.0735133778   0.0000000000   0.0000000000\n"
"        1.3307568939  -0.0932928666  -0.0307479826   0.0000000000   0.0000000000  -0.2717786632   0.0000000000   0.0000000000\n"
"        0.4108076579   0.0083827453  -0.6803273620   1.0000000000   0.0000000000  -0.4752358588   1.0000000000   0.0000000000\n"
"        0.1203105299  -0.0021601474  -0.4075981685   0.0000000000   1.0000000000  -0.4103141270   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"N TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  4  3\n"
"     6241.4478205000  -0.0010992714   0.0002541567   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      942.7853221624  -0.0083836502   0.0019685436   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      215.1071557533  -0.0422134003   0.0099007497   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       60.1999725160  -0.1563225099   0.0394939433   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       18.6046423067  -0.3979589501   0.1133930134   0.0000000000   0.0000000000  -0.0210878424   0.0000000000   0.0000000000\n"
"        6.0687801071  -0.4619961627   0.2073232497   0.0000000000   0.0000000000  -0.0789077492   0.0000000000   0.0000000000\n"
"        1.8932165206  -0.0957720636  -0.0376291073   0.0000000000   0.0000000000  -0.2857497167   0.0000000000   0.0000000000\n"
"        0.5794472569   0.0081210319  -0.6849844121   1.0000000000   0.0000000000  -0.4787797641   1.0000000000   0.0000000000\n"
"        0.1652321868  -0.0020517293  -0.4012545190   0.0000000000   1.0000000000  -0.3946908536   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  4  3\n"
"     8664.6907364270  -0.0010264289   0.0002401847   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1306.3804630458  -0.0078441700   0.0018629873   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      297.9615739412  -0.0396596073   0.0094113620   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       83.0732192337  -0.1499468244   0.0382308227   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       25.4219803948  -0.3957081736   0.1138918674   0.0000000000   0.0000000000  -0.0212313047   0.0000000000   0.0000000000\n"
"        8.2002946495  -0.4708819153   0.2122924071   0.0000000000   0.0000000000  -0.0827974544   0.0000000000   0.0000000000\n"
"        2.5534670865  -0.0973701955  -0.0419284053   0.0000000000   0.0000000000  -0.2949296208   0.0000000000   0.0000000000\n"
"        0.7764121612   0.0078325892  -0.6868639954   1.0000000000   0.0000000000  -0.4802452851   1.0000000000   0.0000000000\n"
"        0.2169654766  -0.0019439564  -0.3986265721   0.0000000000   1.0000000000  -0.3854659989   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  4  3\n"
"    11534.0506179760  -0.0009693137   0.0002286337   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1736.4519019727  -0.0074228862   0.0017758908   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      395.6947671892  -0.0376841674   0.0090123001   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      109.8950434029  -0.1450177785   0.0371743948   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       33.3170603602  -0.3943357740   0.1142516978   0.0000000000   0.0000000000  -0.0213060126   0.0000000000   0.0000000000\n"
"       10.6395997010  -0.4778632959   0.2159190584   0.0000000000   0.0000000000  -0.0858798131   0.0000000000   0.0000000000\n"
"        3.3072015847  -0.0980593066  -0.0454513631   0.0000000000   0.0000000000  -0.3015970754   0.0000000000   0.0000000000\n"
"        1.0004259330   0.0075046051  -0.6878291319   1.0000000000   0.0000000000  -0.4808474043   1.0000000000   0.0000000000\n"
"        0.2751462303  -0.0018293410  -0.3969701556   0.0000000000   1.0000000000  -0.3792605287   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"Ne TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1  9  4  3\n"
"    14852.7741853830  -0.0009235872   0.0002190609   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     2234.8237554633  -0.0070802740   0.0017022734   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      508.8034771653  -0.0360908407   0.0086781493   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      140.7349980722  -0.1411013040   0.0362883902   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       42.2868226841  -0.3936017844   0.1145689028   0.0000000000   0.0000000000  -0.0213531723   0.0000000000   0.0000000000\n"
"       13.3814738310  -0.4835123748   0.2187087359   0.0000000000   0.0000000000  -0.0884397798   0.0000000000   0.0000000000\n"
"        4.1527137274  -0.0981106306  -0.0486085731   0.0000000000   0.0000000000  -0.3067173307   0.0000000000   0.0000000000\n"
"        1.2509672859   0.0071501025  -0.6884074486   1.0000000000   0.0000000000  -0.4810347809   1.0000000000   0.0000000000\n"
"        0.3396248365  -0.0017103909  -0.3956395896   0.0000000000   1.0000000000  -0.3747659865   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.2000000000   1.0000000000\n"
"#","\n"
"Al TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  5  4\n"
"    27551.3038803664   0.0007902356   0.0002051247  -0.0000539950   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     4682.7618227118   0.0051091411   0.0013307487  -0.0003509552   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1166.3402011445   0.0238287095   0.0062711660  -0.0016510527   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      346.0032826675   0.0891920482   0.0243060417  -0.0064361456   0.0000000000   0.0000000000  -0.0020283510   0.0003943314   0.0000000000   0.0000000000\n"
"      114.4719182078   0.2502089639   0.0749256824  -0.0198886400   0.0000000000   0.0000000000  -0.0096153064   0.0020649970   0.0000000000   0.0000000000\n"
"       41.1999175687   0.4367661056   0.1656890319  -0.0450859057   0.0000000000   0.0000000000  -0.0438990222   0.0086117474   0.0000000000   0.0000000000\n"
"       15.7012333530   0.3125973574   0.1836095416  -0.0512412586   0.0000000000   0.0000000000  -0.1486831836   0.0325680927   0.0000000000   0.0000000000\n"
"        6.0142665071   0.0345570290  -0.1524355487   0.0448540103   0.0000000000   0.0000000000  -0.3395431168   0.0689924793   0.0000000000   0.0000000000\n"
"        2.2830453817   0.0004891428  -0.6319413645   0.2602793107   0.0000000000   0.0000000000  -0.4356046359   0.1128895908   0.0000000000   0.0000000000\n"
"        0.8490703600  -0.0005055118  -0.3717923282   0.2367424774   0.0000000000   0.0000000000  -0.2445346410  -0.0215336434   0.0000000000   0.0000000000\n"
"        0.1896189412   0.0001917544  -0.0078124700  -0.7037552451   1.0000000000   0.0000000000  -0.0176080423  -0.4885175925   1.0000000000   0.0000000000\n"
"        0.0590458267  -0.0000711837   0.0005957043  -0.4830773513   0.0000000000   1.0000000000   0.0038180642  -0.5990452444   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Si TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  5  4\n"
"    34205.8807706528   0.0007327188   0.0001943796  -0.0000558389   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     5705.2071864975   0.0048710223   0.0012962263  -0.0003727797   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1400.9000355114   0.0230910203   0.0062095461  -0.0017849346   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      411.6831259844   0.0874748743   0.0243401409  -0.0070274320   0.0000000000   0.0000000000  -0.0020435691   0.0004608501   0.0000000000   0.0000000000\n"
"      135.3586299298   0.2480782614   0.0758718633  -0.0220186781   0.0000000000   0.0000000000  -0.0098284202   0.0024034582   0.0000000000   0.0000000000\n"
"       48.5277674751   0.4375690658   0.1694258836  -0.0503252964   0.0000000000   0.0000000000  -0.0454264531   0.0103657478   0.0000000000   0.0000000000\n"
"       18.4574862413   0.3157185815   0.1896317701  -0.0584489572   0.0000000000   0.0000000000  -0.1542320032   0.0386846044   0.0000000000   0.0000000000\n"
"        7.0951187369   0.0349093715  -0.1561350675   0.0519518554   0.0000000000   0.0000000000  -0.3498959381   0.0835955571   0.0000000000   0.0000000000\n"
"        2.7255967144   0.0007868340  -0.6418259851   0.2969196408   0.0000000000   0.0000000000  -0.4363611647   0.1290968861   0.0000000000   0.0000000000\n"
"        1.0416239959  -0.0006880967  -0.3592395770   0.2542270212   0.0000000000   0.0000000000  -0.2203688566  -0.0396529577   0.0000000000   0.0000000000\n"
"        0.2679494348   0.0002658227  -0.0069544727  -0.7342316576   1.0000000000   0.0000000000  -0.0131604244  -0.5256989764   1.0000000000   0.0000000000\n"
"        0.0814723628  -0.0000897664   0.0000537394  -0.4823523926   0.0000000000   1.0000000000   0.0021025311  -0.5604030966   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  5  4\n"
"    36978.0006282670  -0.0007882716  -0.0002130577   0.0000647974   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     6222.2481694120  -0.0051771150  -0.0014042239   0.0004276889   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1534.4538912185  -0.0244536132  -0.0067044703   0.0020403295   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      450.9238919748  -0.0925205949  -0.0263118610   0.0080502303   0.0000000000   0.0000000000  -0.0023114207   0.0005787895   0.0000000000   0.0000000000\n"
"      147.9232376649  -0.2603320996  -0.0817937127   0.0251613391   0.0000000000   0.0000000000  -0.0110744755   0.0029302708   0.0000000000   0.0000000000\n"
"       52.8962236804  -0.4459248734  -0.1800960112   0.0569273568   0.0000000000   0.0000000000  -0.0514807115   0.0130835082   0.0000000000   0.0000000000\n"
"       20.0317880911  -0.2973279703  -0.1864541939   0.0613716013   0.0000000000   0.0000000000  -0.1716941092   0.0469534420   0.0000000000   0.0000000000\n"
"        7.7131122202  -0.0245287918   0.2031306430  -0.0738571235   0.0000000000   0.0000000000  -0.3732355043   0.1006399940   0.0000000000   0.0000000000\n"
"        2.9844774777  -0.0023042412   0.6642552121  -0.3477214528   0.0000000000   0.0000000000  -0.4305581327   0.1364700825   0.0000000000   0.0000000000\n"
"        1.1549719893   0.0014070660   0.3025676551  -0.2237894266   0.0000000000   0.0000000000  -0.1767432863  -0.0764816331   0.0000000000   0.0000000000\n"
"        0.3417880814  -0.0005342995   0.0006613566   0.7764969105   1.0000000000   0.0000000000  -0.0060298501  -0.5504601345   1.0000000000   0.0000000000\n"
"        0.1040262651   0.0001624777   0.0012215196   0.4569656329   0.0000000000   1.0000000000   0.0003271252  -0.5191181650   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  5  4\n"
"    43116.7172343791   0.0007730597  -0.0002123479   0.0000672395   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     7082.1673578265   0.0052570195  -0.0014494275   0.0004599971   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1715.6275383850   0.0252958095  -0.0070506620   0.0022334067   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      498.2117432579   0.0966015002  -0.0279836798   0.0089283399   0.0000000000   0.0000000000  -0.0025280039   0.0006830870   0.0000000000   0.0000000000\n"
"      162.0462756704   0.2714940023  -0.0872956329   0.0279726273   0.0000000000   0.0000000000  -0.0122585511   0.0034185387   0.0000000000   0.0000000000\n"
"       57.5633179334   0.4540530344  -0.1903753835   0.0630562214   0.0000000000   0.0000000000  -0.0575128029   0.0158200681   0.0000000000   0.0000000000\n"
"       21.6195597517   0.2805583500  -0.1820266755   0.0626266086   0.0000000000   0.0000000000  -0.1899219376   0.0551163883   0.0000000000   0.0000000000\n"
"        8.2917257402   0.0157911511   0.2559566728  -0.0993256380   0.0000000000   0.0000000000  -0.3975202657   0.1178364339   0.0000000000   0.0000000000\n"
"        3.2044042431   0.0036134328   0.6851219839  -0.4018617372   0.0000000000   0.0000000000  -0.4219856265   0.1353291071   0.0000000000   0.0000000000\n"
"        1.2170240277  -0.0020726487   0.2416950948  -0.1592676863   0.0000000000   0.0000000000  -0.1356765817  -0.1271234105   0.0000000000   0.0000000000\n"
"        0.4039700245   0.0008423916  -0.0069738855   0.8175488469   1.0000000000   0.0000000000   0.0006566296  -0.5644015152   1.0000000000   0.0000000000\n"
"        0.1249906733  -0.0002378905   0.0024023008   0.4114888816   0.0000000000   1.0000000000  -0.0009601988  -0.4712031290   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  5  4\n"
"    46364.8344532030   0.0008184364  -0.0002280158   0.0000744063   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     7706.7898113396   0.0054783617  -0.0015324266   0.0005015335   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1877.5451692936   0.0262477090  -0.0074240583   0.0024230800   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      545.7287407389   0.1001230552  -0.0294838852   0.0097073844   0.0000000000   0.0000000000  -0.0027461074   0.0007848141   0.0000000000   0.0000000000\n"
"      177.2908959787   0.2798008585  -0.0918074467   0.0303344403   0.0000000000   0.0000000000  -0.0132763202   0.0038538083   0.0000000000   0.0000000000\n"
"       62.8967566592   0.4581526631  -0.1981397130   0.0680013180   0.0000000000   0.0000000000  -0.0625171637   0.0182320502   0.0000000000   0.0000000000\n"
"       23.5441169015   0.2677215656  -0.1777057334   0.0631957627   0.0000000000   0.0000000000  -0.2041393264   0.0620073474   0.0000000000   0.0000000000\n"
"        9.0326811369   0.0106407066   0.2956230199  -0.1209002135   0.0000000000   0.0000000000  -0.4143068471   0.1319770088   0.0000000000   0.0000000000\n"
"        3.4989881952   0.0043383301   0.6939360980  -0.4432412739   0.0000000000   0.0000000000  -0.4107049745   0.1291981811   0.0000000000   0.0000000000\n"
"        1.2944154598  -0.0024408099   0.2012193128  -0.0872175034   0.0000000000   0.0000000000  -0.1087289175  -0.1795956787   0.0000000000   0.0000000000\n"
"        0.4597935393   0.0010574389  -0.0118044292   0.8393540477   1.0000000000   0.0000000000   0.0044892009  -0.5671711751   1.0000000000   0.0000000000\n"
"        0.1452937050  -0.0002882406   0.0030417630   0.3658485618   0.0000000000   1.0000000000  -0.0015760776  -0.4254457201   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar TZVP-ALL-PADE\n"
"  2\n"
"  1  0  1 12  5  4\n"
"    53072.8297062878   0.0007941425  -0.0002240280   0.0000748195   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     8898.5866473512   0.0052889972  -0.0014977931   0.0005018392   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     2155.9132467432   0.0256852736  -0.0073548393   0.0024566617   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      622.2299227662   0.0989332649  -0.0294812429   0.0099393098   0.0000000000   0.0000000000  -0.0027433029   0.0008170301   0.0000000000   0.0000000000\n"
"      201.1659177255   0.2786462711  -0.0925348417   0.0313023547   0.0000000000   0.0000000000  -0.0134329689   0.0040333465   0.0000000000   0.0000000000\n"
"       71.1579472025   0.4592775456  -0.2010213397   0.0707758312   0.0000000000   0.0000000000  -0.0636580890   0.0193733027   0.0000000000   0.0000000000\n"
"       26.5980018913   0.2694532726  -0.1813760699   0.0661947452   0.0000000000   0.0000000000  -0.2085598634   0.0657449676   0.0000000000   0.0000000000\n"
"       10.2137137203   0.0105356188   0.3039220653  -0.1287172743   0.0000000000   0.0000000000  -0.4214027465   0.1412356088   0.0000000000   0.0000000000\n"
"        3.9720621706   0.0044532395   0.7006538383  -0.4686337493   0.0000000000   0.0000000000  -0.4060028434   0.1270698508   0.0000000000   0.0000000000\n"
"        1.4539972779  -0.0025226750   0.1895810330  -0.0487460947   0.0000000000   0.0000000000  -0.0981265591  -0.2131809278   0.0000000000   0.0000000000\n"
"        0.5293705047   0.0011246747  -0.0136173212   0.8447511774   1.0000000000   0.0000000000   0.0056716141  -0.5665305364   1.0000000000   0.0000000000\n"
"        0.1690528118  -0.0003035245   0.0032997478   0.3442490945   0.0000000000   1.0000000000  -0.0017347653  -0.3971352648   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"H DZV-ALL-BLYP\n"
"  1\n"
"  1  0  0  5  2\n"
"       47.6766821949  -0.0043584463   0.0000000000\n"
"        7.2138252786  -0.0280413054   0.0000000000\n"
"        1.6553477814  -0.1607911988   0.0000000000\n"
"        0.4620756821  -0.2616974130   0.0000000000\n"
"        0.1633279056  -0.6663250351   1.0000000000\n"
"#","\n"
"H DZVP-ALL-BLYP\n"
"  2\n"
"  1  0  0  5  2\n"
"       47.6766821949  -0.0043584463   0.0000000000\n"
"        7.2138252786  -0.0280413054   0.0000000000\n"
"        1.6553477814  -0.1607911988   0.0000000000\n"
"        0.4620756821  -0.2616974130   0.0000000000\n"
"        0.1633279056  -0.6663250351   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O TZVP-ALL-BLYP\n"
"  2\n"
"  1  0  1  9  4  3\n"
"     8664.6907364270  -0.0010398418   0.0002426467   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1304.2944310248  -0.0079828203   0.0018962898   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      295.9693605095  -0.0406371136   0.0096067682   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       82.2047238380  -0.1536198678   0.0392806838   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       25.1299697483  -0.4014912128   0.1153729549   0.0000000000   0.0000000000  -0.0218982495   0.0000000000   0.0000000000\n"
"        8.1128473457  -0.4659531883   0.2128198124   0.0000000000   0.0000000000  -0.0836678585   0.0000000000   0.0000000000\n"
"        2.5105499839  -0.0915561133  -0.0513764869   0.0000000000   0.0000000000  -0.2995070193   0.0000000000   0.0000000000\n"
"        0.7657968411   0.0075189734  -0.7008547943   1.0000000000   0.0000000000  -0.4814704278   1.0000000000   0.0000000000\n"
"        0.2109431242  -0.0018090393  -0.3792651362   0.0000000000   1.0000000000  -0.3804918653   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F TZVP-ALL-BLYP\n"
"  2\n"
"  1  0  1  9  4  3\n"
"    11534.0506179760  -0.0009798237   0.0002305539   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"     1736.4518540745  -0.0075252319   0.0018012871   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      393.7045510622  -0.0384982409   0.0091753398   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"      108.8690799446  -0.1483161618   0.0381319658   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"       32.9489612499  -0.4001274801   0.1157679180   0.0000000000   0.0000000000  -0.0219498202   0.0000000000   0.0000000000\n"
"       10.5255415538  -0.4733020735   0.2166396110   0.0000000000   0.0000000000  -0.0867958235   0.0000000000   0.0000000000\n"
"        3.2533274751  -0.0924284355  -0.0553420468   0.0000000000   0.0000000000  -0.3063025367   0.0000000000   0.0000000000\n"
"        0.9849075495   0.0071803551  -0.7013315907   1.0000000000   0.0000000000  -0.4827220806   1.0000000000   0.0000000000\n"
"        0.2674718721  -0.0017014451  -0.3775933468   0.0000000000   1.0000000000  -0.3732467322   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"H 6-31G*\n"
"  2\n"
"  1  0  0  3  1\n"
"       18.7311369600   0.0334946043\n"
"        2.8253943650   0.2347269535\n"
"        0.6401216923   0.8137573262\n"
"  2  0  0  1  1\n"
"        0.1612777588   1.0000000000\n"
"#","\n"
"He 6-31G*\n"
"  2\n"
"  1  0  0  3  1\n"
"       38.4216340000   0.0237660000\n"
"        5.7780300000   0.1546790000\n"
"        1.2417740000   0.4696300000\n"
"  2  0  0  1  1\n"
"        0.2979640000   1.0000000000\n"
"#","\n"
"Li 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"      642.4189150000   0.0021426078\n"
"       96.7985153000   0.0162088715\n"
"       22.0911212000   0.0773155725\n"
"        6.2010702500   0.2457860520\n"
"        1.9351176800   0.4701890040\n"
"        0.6367357890   0.3454708450\n"
"  2  0  1  3  1  1\n"
"        2.3249184080  -0.0350917459   0.0089415080\n"
"        0.6324303556  -0.1912328440   0.1410094640\n"
"        0.0790534347   1.0839878000   0.9453636950\n"
"  3  0  1  1  1  1\n"
"        0.0359619718   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2000000000   1.0000000000\n"
"#","\n"
"Be 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     1264.5856900000   0.0019447576\n"
"      189.9368060000   0.0148350520\n"
"       43.1590890000   0.0720905463\n"
"       12.0986627000   0.2371541500\n"
"        3.8063232200   0.4691986520\n"
"        1.2728903000   0.3565202280\n"
"  2  0  1  3  1  1\n"
"        3.1964630980  -0.1126487290   0.0559801998\n"
"        0.7478133038  -0.2295064090   0.2615506110\n"
"        0.2199663302   1.1869167700   0.7939723390\n"
"  3  0  1  1  1  1\n"
"        0.0823099007   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"B 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     2068.8822500000   0.0018662746\n"
"      310.6495700000   0.0142514817\n"
"       70.6830330000   0.0695516185\n"
"       19.8610803000   0.2325729330\n"
"        6.2993048400   0.4670787120\n"
"        2.1270269700   0.3634314400\n"
"  2  0  1  3  1  1\n"
"        4.7279710710  -0.1303937970   0.0745975799\n"
"        1.1903377360  -0.1307889510   0.3078466770\n"
"        0.3594116829   1.1309444800   0.7434568340\n"
"  3  0  1  1  1  1\n"
"        0.1267512469   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"C 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     3047.5248800000   0.0018347371\n"
"      457.3695180000   0.0140373228\n"
"      103.9486850000   0.0688426222\n"
"       29.2101553000   0.2321844430\n"
"        9.2866629600   0.4679413480\n"
"        3.1639269600   0.3623119850\n"
"  2  0  1  3  1  1\n"
"        7.8682723500  -0.1193324200   0.0689990666\n"
"        1.8812885400  -0.1608541520   0.3164239610\n"
"        0.5442492580   1.1434564400   0.7443082910\n"
"  3  0  1  1  1  1\n"
"        0.1687144782   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"N 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     4173.5114600000   0.0018347722\n"
"      627.4579110000   0.0139946270\n"
"      142.9020930000   0.0685865518\n"
"       40.2343293000   0.2322408730\n"
"       12.8202129000   0.4690699480\n"
"        4.3904370100   0.3604551990\n"
"  2  0  1  3  1  1\n"
"       11.6263618600  -0.1149611820   0.0675797439\n"
"        2.7162798070  -0.1691174790   0.3239072960\n"
"        0.7722183966   1.1458519500   0.7408951400\n"
"  3  0  1  1  1  1\n"
"        0.2120314975   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"O 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     5484.6716600000   0.0018310744\n"
"      825.2349460000   0.0139501722\n"
"      188.0469580000   0.0684450781\n"
"       52.9645000000   0.2327143360\n"
"       16.8975704000   0.4701928980\n"
"        5.7996353400   0.3585208530\n"
"  2  0  1  3  1  1\n"
"       15.5396162500  -0.1107775490   0.0708742682\n"
"        3.5999335860  -0.1480262620   0.3397528390\n"
"        1.0137617500   1.1307670100   0.7271585770\n"
"  3  0  1  1  1  1\n"
"        0.2700058226   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     7001.7130900000   0.0018196169\n"
"     1051.3660900000   0.0139160796\n"
"      239.2856900000   0.0684053245\n"
"       67.3974453000   0.2331857600\n"
"       21.5199573000   0.4712674390\n"
"        7.4031013000   0.3566185460\n"
"  2  0  1  3  1  1\n"
"       20.8479528000  -0.1085069750   0.0716287243\n"
"        4.8083083400  -0.1464516580   0.3459121030\n"
"        1.3440698600   1.1286885800   0.7224699570\n"
"  3  0  1  1  1  1\n"
"        0.3581513930   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"Ne 6-31G*\n"
"  4\n"
"  1  0  0  6  1\n"
"     8425.8515300000   0.0018843480\n"
"     1268.5194000000   0.0143368994\n"
"      289.6214140000   0.0701096233\n"
"       81.8590040000   0.2373732660\n"
"       26.2515079000   0.4730071260\n"
"        9.0947205100   0.3484012410\n"
"  2  0  1  3  1  1\n"
"       26.5321310000  -0.1071182870   0.0719095885\n"
"        6.1017550100  -0.1461638210   0.3495133720\n"
"        1.6962715300   1.1277735000   0.7199405120\n"
"  3  0  1  1  1  1\n"
"        0.4458187000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"Na 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"     9993.2000000000   0.0019376600\n"
"     1499.8900000000   0.0148070000\n"
"      341.9510000000   0.0727055000\n"
"       94.6796000000   0.2526290000\n"
"       29.7345000000   0.4932420000\n"
"       10.0063000000   0.3131690000\n"
"  2  0  1  6  1  1\n"
"      150.9630000000  -0.0035420800   0.0050016600\n"
"       35.5878000000  -0.0439588000   0.0355109000\n"
"       11.1683000000  -0.1097520000   0.1428250000\n"
"        3.9020100000   0.1873980000   0.3386200000\n"
"        1.3817700000   0.6466990000   0.4515790000\n"
"        0.4663820000   0.3060580000   0.2732710000\n"
"  3  0  1  3  1  1\n"
"        0.4979660000  -0.2485030000  -0.0230225000\n"
"        0.0843529000  -0.1317040000   0.9503590000\n"
"        0.0666350000   1.2335200000   0.0598579000\n"
"  4  0  1  1  1  1\n"
"        0.0259544000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1750000000   1.0000000000\n"
"#","\n"
"Mg 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    11722.8000000000   0.0019778300\n"
"     1759.9300000000   0.0151140000\n"
"      400.8460000000   0.0739108000\n"
"      112.8070000000   0.2491910000\n"
"       35.9997000000   0.4879280000\n"
"       12.1828000000   0.3196620000\n"
"  2  0  1  6  1  1\n"
"      189.1800000000  -0.0032371700   0.0049281300\n"
"       45.2119000000  -0.0410079000   0.0349888000\n"
"       14.3563000000  -0.1126000000   0.1407250000\n"
"        5.1388600000   0.1486330000   0.3336420000\n"
"        1.9065200000   0.6164970000   0.4449400000\n"
"        0.7058870000   0.3648290000   0.2692540000\n"
"  3  0  1  3  1  1\n"
"        0.9293400000  -0.2122900000  -0.0224192000\n"
"        0.2690350000  -0.1079850000   0.1922710000\n"
"        0.1173790000   1.1758400000   0.8461810000\n"
"  4  0  1  1  1  1\n"
"        0.0421061000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1750000000   1.0000000000\n"
"#","\n"
"Al 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    13983.1000000000   0.0019426700\n"
"     2098.7500000000   0.0148599000\n"
"      477.7050000000   0.0728494000\n"
"      134.3600000000   0.2468300000\n"
"       42.8709000000   0.4872580000\n"
"       14.5189000000   0.3234960000\n"
"  2  0  1  6  1  1\n"
"      239.6680000000  -0.0029261900   0.0046028500\n"
"       57.4419000000  -0.0374083000   0.0331990000\n"
"       18.2859000000  -0.1144870000   0.1362820000\n"
"        6.5991400000   0.1156350000   0.3304760000\n"
"        2.4904900000   0.6125950000   0.4491460000\n"
"        0.9445450000   0.3937990000   0.2657040000\n"
"  3  0  1  3  1  1\n"
"        1.2779000000  -0.2276060000  -0.0175126000\n"
"        0.3975900000   0.0014458300   0.2445330000\n"
"        0.1600950000   1.0927900000   0.8049340000\n"
"  4  0  1  1  1  1\n"
"        0.0556577000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3250000000   1.0000000000\n"
"#","\n"
"Si 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    16115.9000000000   0.0019594800\n"
"     2425.5800000000   0.0149288000\n"
"      553.8670000000   0.0728478000\n"
"      156.3400000000   0.2461300000\n"
"       50.0683000000   0.4859140000\n"
"       17.0178000000   0.3250020000\n"
"  2  0  1  6  1  1\n"
"      292.7180000000  -0.0027809400   0.0044382600\n"
"       69.8731000000  -0.0357146000   0.0326679000\n"
"       22.3363000000  -0.1149850000   0.1347210000\n"
"        8.1503900000   0.0935634000   0.3286780000\n"
"        3.1345800000   0.6030170000   0.4496400000\n"
"        1.2254300000   0.4189590000   0.2613720000\n"
"  3  0  1  3  1  1\n"
"        1.7273800000  -0.2446300000  -0.0177951000\n"
"        0.5729220000   0.0043157200   0.2535390000\n"
"        0.2221920000   1.0981800000   0.8006690000\n"
"  4  0  1  1  1  1\n"
"        0.0778369000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    19413.3000000000   0.0018516000\n"
"     2909.4200000000   0.0142062000\n"
"      661.3640000000   0.0699995000\n"
"      185.7590000000   0.2400790000\n"
"       59.1943000000   0.4847620000\n"
"       20.0310000000   0.3352000000\n"
"  2  0  1  6  1  1\n"
"      339.4780000000  -0.0027821700   0.0045646200\n"
"       81.0101000000  -0.0360499000   0.0336936000\n"
"       25.8780000000  -0.1166310000   0.1397550000\n"
"        9.4522100000   0.0968328000   0.3393620000\n"
"        3.6656600000   0.6144180000   0.4509210000\n"
"        1.4674600000   0.4037980000   0.2385860000\n"
"  3  0  1  3  1  1\n"
"        2.1562300000  -0.2529230000  -0.0177653000\n"
"        0.7489970000   0.0328517000   0.2740580000\n"
"        0.2831450000   1.0812500000   0.7854210000\n"
"  4  0  1  1  1  1\n"
"        0.0998317000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    21917.1000000000   0.0018692400\n"
"     3301.4900000000   0.0142303000\n"
"      754.1460000000   0.0696962000\n"
"      212.7110000000   0.2384870000\n"
"       67.9896000000   0.4833070000\n"
"       23.0515000000   0.3380740000\n"
"  2  0  1  6  1  1\n"
"      423.7350000000  -0.0023767700   0.0040610100\n"
"      100.7100000000  -0.0316930000   0.0306813000\n"
"       32.1599000000  -0.1133170000   0.1304520000\n"
"       11.8079000000   0.0560900000   0.3272050000\n"
"        4.6311000000   0.5922550000   0.4528510000\n"
"        1.8702500000   0.4550060000   0.2560420000\n"
"  3  0  1  3  1  1\n"
"        2.6158400000  -0.2503740000  -0.0145105000\n"
"        0.9221670000   0.0669570000   0.3102630000\n"
"        0.3412870000   1.0545100000   0.7544830000\n"
"  4  0  1  1  1  1\n"
"        0.1171670000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    25180.1000000000   0.0018329600\n"
"     3780.3500000000   0.0140342000\n"
"      860.4740000000   0.0690974000\n"
"      242.1450000000   0.2374520000\n"
"       77.3349000000   0.4830340000\n"
"       26.2470000000   0.3398560000\n"
"  2  0  1  6  1  1\n"
"      491.7650000000  -0.0022973900   0.0039894000\n"
"      116.9840000000  -0.0307137000   0.0303177000\n"
"       37.4153000000  -0.1125280000   0.1298800000\n"
"       13.7834000000   0.0450163000   0.3279510000\n"
"        5.4521500000   0.5893530000   0.4535270000\n"
"        2.2258800000   0.4652060000   0.2521540000\n"
"  3  0  1  3  1  1\n"
"        3.1864900000  -0.2518270000  -0.0142993000\n"
"        1.1442700000   0.0615890000   0.3235720000\n"
"        0.4203770000   1.0601800000   0.7435070000\n"
"  4  0  1  1  1  1\n"
"        0.1426570000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar 6-31G*\n"
"  5\n"
"  1  0  0  6  1\n"
"    28348.3000000000   0.0018252600\n"
"     4257.6200000000   0.0139686000\n"
"      969.8570000000   0.0687073000\n"
"      273.2630000000   0.2362040000\n"
"       87.3695000000   0.4822140000\n"
"       29.6867000000   0.3420430000\n"
"  2  0  1  6  1  1\n"
"      575.8910000000  -0.0021597200   0.0038066500\n"
"      136.8160000000  -0.0290775000   0.0292305000\n"
"       43.8098000000  -0.1108270000   0.1264670000\n"
"       16.2094000000   0.0276999000   0.3235100000\n"
"        6.4608400000   0.5776130000   0.4548960000\n"
"        2.6511400000   0.4886880000   0.2566300000\n"
"  3  0  1  3  1  1\n"
"        3.8602800000  -0.2555920000  -0.0159197000\n"
"        1.4137300000   0.0378066000   0.3246460000\n"
"        0.5166460000   1.0805600000   0.7439900000\n"
"  4  0  1  1  1  1\n"
"        0.1738880000   1.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"H SZV-GTH-PADE\n"
"  1\n"
"  1  0  0  4  1\n"
"        8.3744350009  -0.0238943732\n"
"        1.8058681460  -0.1397943259\n"
"        0.4852531032  -0.2530970874\n"
"        0.1658235797  -0.6955307423\n"
"#","\n"
"H DZV-GTH-PADE\n"
"  1\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0238943732   0.0000000000\n"
"        1.8058681460  -0.1397943259   0.0000000000\n"
"        0.4852531032  -0.2530970874   0.0000000000\n"
"        0.1658235797  -0.6955307423   1.0000000000\n"
"#","\n"
"H DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0283380594   0.0000000000\n"
"        1.8058681460  -0.1333808815   0.0000000000\n"
"        0.4852531032  -0.3995678166   0.0000000000\n"
"        0.1658235797  -0.5531027153   1.0000000000\n"
"#","\n"
"H DZVP-GTH-PADE\n"
"  2\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0238943732   0.0000000000\n"
"        1.8058681460  -0.1397943259   0.0000000000\n"
"        0.4852531032  -0.2530970874   0.0000000000\n"
"        0.1658235797  -0.6955307423   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"H DZVP-GTH-PADE-CONFINED\n"
"  2\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0283380594   0.0000000000\n"
"        1.8058681460  -0.1333808815   0.0000000000\n"
"        0.4852531032  -0.3995678166   0.0000000000\n"
"        0.1658235797  -0.5531027153   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"H MAO-PRIM\n"
"  2\n"
"  1  0  0  4  4\n"
"        8.3744350009   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.8058681460   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4852531032   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1658235797   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"He DZV-GTH-PADE\n"
"  1\n"
"  1  0  0  4  2\n"
"       10.9449874915  -0.0753847695   0.0000000000\n"
"        2.7220103814  -0.2478759473   0.0000000000\n"
"        0.7380855468  -0.4844314598   0.0000000000\n"
"        0.2044485380  -0.3633328585   1.0000000000\n"
"#","\n"
"He DZVP-GTH-PADE\n"
"  2\n"
"  1  0  0  4  2\n"
"       10.9449874915  -0.0753847695   0.0000000000\n"
"        2.7220103814  -0.2478759473   0.0000000000\n"
"        0.7380855468  -0.4844314598   0.0000000000\n"
"        0.2044485380  -0.3633328585   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"Li DZV-GTH-PADE\n"
"  1\n"
"  1  0  0  6  3\n"
"        9.0645724591   0.1412707699  -0.0257336579   0.0000000000\n"
"        4.3479418841   0.2767295609  -0.0520596034   0.0000000000\n"
"        1.4344377059   0.4501408198  -0.1264254986   0.0000000000\n"
"        0.4969595308   0.2616803664  -0.1023799272   0.0000000000\n"
"        0.0729934685   0.0116600998   0.5635942604   0.0000000000\n"
"        0.0264321968  -0.0038582262   0.5289910438   1.0000000000\n"
"#","\n"
"Li DZVP-GTH-PADE\n"
"  1\n"
"  1  0  1  6  3  3\n"
"        9.0645724591   0.1412707699  -0.0257336579   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        4.3479418841   0.2767295609  -0.0520596034   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4344377059   0.4501408198  -0.1264254986   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4969595308   0.2616803664  -0.1023799272   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0729934685   0.0116600998   0.5635942604   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0264321968  -0.0038582262   0.5289910438   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Be DZV-GTH-PADE\n"
"  1\n"
"  1  0  0  6  3\n"
"       16.1605993866   0.1059191045  -0.0252247893   0.0000000000\n"
"        8.2781849385   0.3141963412  -0.0592178229   0.0000000000\n"
"        2.7429504166   0.4327229195  -0.1590666667   0.0000000000\n"
"        1.0050808492   0.2646169070  -0.0970095401   0.0000000000\n"
"        0.1765058796   0.0128470696   0.5606449178   0.0000000000\n"
"        0.0580428345  -0.0034490257   0.5479193518   1.0000000000\n"
"#","\n"
"Be DZVP-GTH-PADE\n"
"  1\n"
"  1  0  1  6  3  3\n"
"       16.1605993866   0.1059191045  -0.0252247893   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.2781849385   0.3141963412  -0.0592178229   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.7429504166   0.4327229195  -0.1590666667   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0050808492   0.2646169070  -0.0970095401   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1765058796   0.0128470696   0.5606449178   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0580428345  -0.0034490257   0.5479193518   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"B DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        2.8854072190   0.1420734374   0.0000000000  -0.0759818266   0.0000000000\n"
"        0.8566811318  -0.0083272998   0.0000000000  -0.2508295957   0.0000000000\n"
"        0.2712977126  -0.6707128588   0.0000000000  -0.4610302659   0.0000000000\n"
"        0.0826097889  -0.4241240913   1.0000000000  -0.4419902640   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"C SZV-GTH-PADE\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        4.3362505404   0.1490793580  -0.0878122158\n"
"        1.2881820646  -0.0292634544  -0.2775568334\n"
"        0.4037764944  -0.6882043984  -0.4712287175\n"
"        0.1187878168  -0.3964423560  -0.4058040746\n"
"#","\n"
"C DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        4.3362505404   0.1490793580   0.0000000000  -0.0878122158   0.0000000000\n"
"        1.2881820646  -0.0292634544   0.0000000000  -0.2775568334   0.0000000000\n"
"        0.4037764944  -0.6882043984   0.0000000000  -0.4712287175   0.0000000000\n"
"        0.1187878168  -0.3964423560   1.0000000000  -0.4058040746   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"C DZVP-GTH-PADE-CONFINED\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        4.9036932712   0.1231402806   0.0000000000  -0.0710058771   0.0000000000\n"
"        1.6574324667   0.0678620439   0.0000000000  -0.2265440401   0.0000000000\n"
"        0.5592463507  -0.5108450721   0.0000000000  -0.4459711159   0.0000000000\n"
"        0.1992045030  -0.6156990839   1.0000000000  -0.4501432808   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"N SZV-GTH-PADE\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        6.1527081270   0.1506293354  -0.0950596846\n"
"        1.8236453987  -0.0360069142  -0.2918844594\n"
"        0.5676671941  -0.6942003416  -0.4739047963\n"
"        0.1628232875  -0.3878973877  -0.3893444095\n"
"#","\n"
"N DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        6.1527081270   0.1506293354   0.0000000000  -0.0950596846   0.0000000000\n"
"        1.8236453987  -0.0360069142   0.0000000000  -0.2918844594   0.0000000000\n"
"        0.5676671941  -0.6942003416   0.0000000000  -0.4739047963   0.0000000000\n"
"        0.1628232875  -0.3878973877   1.0000000000  -0.3893444095   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O SZV-GTH-PADE\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        8.3044042305   0.1510163077  -0.0995678047\n"
"        2.4579452461  -0.0393193874  -0.3011430914\n"
"        0.7597363524  -0.6971729792  -0.4750852730\n"
"        0.2136387585  -0.3841125601  -0.3798775565\n"
"#","\n"
"O DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        8.3044042305   0.1510163077   0.0000000000  -0.0995678047   0.0000000000\n"
"        2.4579452461  -0.0393193874   0.0000000000  -0.3011430914   0.0000000000\n"
"        0.7597363524  -0.6971729792   0.0000000000  -0.4750852730   0.0000000000\n"
"        0.2136387585  -0.3841125601   1.0000000000  -0.3798775565   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"O MAO-PRIM\n"
"  3\n"
"  1  0  0  4  4\n"
"        8.3044042305   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.4579452461   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.7597363524   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2136387585   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  4  4\n"
"        8.3044042305   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.4579452461   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.7597363524   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2136387585   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"O DZVP-GTH-PADE-CONFINED\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        8.8580368553   0.1363369629   0.0000000000  -0.0886958138   0.0000000000\n"
"        2.7922584694   0.0206593813   0.0000000000  -0.2694541227   0.0000000000\n"
"        0.9068691246  -0.6094274296   0.0000000000  -0.4594270880   0.0000000000\n"
"        0.2872216831  -0.5022915093   1.0000000000  -0.4103120494   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F SZV-GTH-PADE\n"
"  1\n"
"  2  0  1  4  1  1\n"
"       10.7079864789   0.1525178335  -0.1028649155\n"
"        3.1757211287  -0.0450362306  -0.3085266108\n"
"        0.9750975998  -0.6987425203  -0.4757649137\n"
"        0.2701247513  -0.3801470840  -0.3724955108\n"
"#","\n"
"F DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"       10.7079864789   0.1525178335   0.0000000000  -0.1028649155   0.0000000000\n"
"        3.1757211287  -0.0450362306   0.0000000000  -0.3085266108   0.0000000000\n"
"        0.9750975998  -0.6987425203   0.0000000000  -0.4757649137   0.0000000000\n"
"        0.2701247513  -0.3801470840   1.0000000000  -0.3724955108   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"Ne SZV-GTH-PADE\n"
"  1\n"
"  2  0  1  4  1  1\n"
"       13.7594457910   0.1483426269  -0.1044040672\n"
"        4.0425314051  -0.0356303947  -0.3108896070\n"
"        1.2355194419  -0.7010725739  -0.4760215931\n"
"        0.3367033579  -0.3841124763  -0.3721573833\n"
"#","\n"
"Ne DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"       13.7594457910   0.1483426269   0.0000000000  -0.1044040672   0.0000000000\n"
"        4.0425314051  -0.0356303947   0.0000000000  -0.3108896070   0.0000000000\n"
"        1.2355194419  -0.7010725739   0.0000000000  -0.4760215931   0.0000000000\n"
"        0.3367033579  -0.3841124763   1.0000000000  -0.3721573833   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.2000000000   1.0000000000\n"
"#","\n"
"Na SZV-GTH-PADE\n"
"  1\n"
"  2  0  1  6  2  1\n"
"       17.6699685720  -0.1362341108   0.0270952595   0.0791962955\n"
"        6.9071803380  -0.0645881804   0.0098743015   0.2184099565\n"
"        2.6099085380   0.3866064317  -0.0737148250   0.3764868181\n"
"        0.9649711690   0.5971408467  -0.2186736173   0.3922334703\n"
"        0.3400394180   0.1756759463  -0.0301109343   0.1808450956\n"
"        0.0432486776  -0.0017104609   1.0388873735   0.0057698929\n"
"#","\n"
"Na DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  6  3  3\n"
"       17.6699685720  -0.1362341108   0.0270952595   0.0000000000   0.0791962955   0.0000000000   0.0000000000\n"
"        6.9071803380  -0.0645881804   0.0098743015   0.0000000000   0.2184099565   0.0000000000   0.0000000000\n"
"        2.6099085380   0.3866064317  -0.0737148250   0.0000000000   0.3764868181   0.0000000000   0.0000000000\n"
"        0.9649711690   0.5971408467  -0.2186736173   0.0000000000   0.3922334703   0.0000000000   0.0000000000\n"
"        0.3400394180   0.1756759463  -0.0301109343   0.0000000000   0.1808450956   1.0000000000   0.0000000000\n"
"        0.0432486776  -0.0017104609   1.0388873735   1.0000000000   0.0057698929   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1169000000   1.0000000000\n"
"#","\n"
"Mg DZVP-GTH-PADE-q10 DZVP-GTH-PADE\n"
"  2\n"
"  2  0  1  6  3  3\n"
"       28.4908976858  -0.0662610173   0.0164990227   0.0000000000   0.0464488574   0.0000000000   0.0000000000\n"
"       11.7286146019  -0.1706220696   0.0374304317   0.0000000000   0.1664817432   0.0000000000   0.0000000000\n"
"        4.4446432719   0.2494471473  -0.0517267282   0.0000000000   0.3580892342   0.0000000000   0.0000000000\n"
"        1.6070987233   0.6423276770  -0.2647575784   0.0000000000   0.4356677176   0.0000000000   0.0000000000\n"
"        0.5690818481   0.2933445091  -0.0948604830   0.0000000000   0.2229690408   1.0000000000   0.0000000000\n"
"        0.0763499358  -0.0002712350   1.0630089581   1.0000000000   0.0085994850   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Mg DZVP-GTH-PADE-q2\n"
"  2\n"
"  3  0  0  4  2\n"
"        2.9198644211  -0.0025733539   0.0000000000\n"
"        0.8049484892   0.2058124895   0.0000000000\n"
"        0.1126554966  -0.6457766724   0.0000000000\n"
"        0.0413625487  -0.4747074468   1.0000000000\n"
"  3  1  1  1  1\n"
"        0.2000000000   1.0000000000\n"
"#","\n"
"Al DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        0.9504243929   0.2820110253   0.0000000000   0.0257292971   0.0000000000\n"
"        0.2947542270  -0.2787298974   0.0000000000  -0.2527939401   0.0000000000\n"
"        0.1124473777  -0.7495145975   0.0000000000  -0.5124792729   0.0000000000\n"
"        0.0396013464  -0.1646066141   1.0000000000  -0.3831309239   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Al DZVP-GTH-PADE-CONFINED\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        0.9659628623   0.2842778097   0.0000000000   0.0340618641   0.0000000000\n"
"        0.3438400556  -0.1449517389   0.0000000000  -0.2054970468   0.0000000000\n"
"        0.1485207596  -0.6897086501   0.0000000000  -0.4772801180   0.0000000000\n"
"        0.0719529320  -0.3389750810   1.0000000000  -0.4170196265   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Si SZV-GTH-PADE\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        1.2032422345   0.3290350445   0.0474539126\n"
"        0.4688409786  -0.2533118323  -0.2594473573\n"
"        0.1679863234  -0.7870946277  -0.5440929303\n"
"        0.0575619526  -0.1909898479  -0.3624010364\n"
"#","\n"
"Si DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.2032422345   0.3290350445   0.0000000000   0.0474539126   0.0000000000\n"
"        0.4688409786  -0.2533118323   0.0000000000  -0.2594473573   0.0000000000\n"
"        0.1679863234  -0.7870946277   0.0000000000  -0.5440929303   0.0000000000\n"
"        0.0575619526  -0.1909898479   1.0000000000  -0.3624010364   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"Si DZVP-GTH-PADE-CONFINED\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.2283393137   0.3224377170   0.0000000000   0.0594606114   0.0000000000\n"
"        0.5501858147  -0.1360087627   0.0000000000  -0.2102673957   0.0000000000\n"
"        0.2104840660  -0.7254143349   0.0000000000  -0.5133271944   0.0000000000\n"
"        0.0912235796  -0.3482519842   1.0000000000  -0.4108824626   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P SZV-GTH-PADE\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        1.4961048190   0.3653028603   0.0816119465\n"
"        0.7168717560  -0.2125795312  -0.2627452850\n"
"        0.2411410649  -0.8136062969  -0.5627188034\n"
"        0.0803403985  -0.2362293752  -0.3691372243\n"
"#","\n"
"P DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.4961048190   0.3653028603   0.0000000000   0.0816119465   0.0000000000\n"
"        0.7168717560  -0.2125795312   0.0000000000  -0.2627452850   0.0000000000\n"
"        0.2411410649  -0.8136062969   0.0000000000  -0.5627188034   0.0000000000\n"
"        0.0803403985  -0.2362293752   1.0000000000  -0.3691372243   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S SZV-GTH-PADE\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        1.8379557070   0.3832201009   0.1221451195\n"
"        1.0358088377  -0.1682229539  -0.2752006797\n"
"        0.3298020165  -0.8258487331  -0.5729080701\n"
"        0.1073546335  -0.2832847829  -0.3825524954\n"
"#","\n"
"S DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.8379557070   0.3832201009   0.0000000000   0.1221451195   0.0000000000\n"
"        1.0358088377  -0.1682229539   0.0000000000  -0.2752006797   0.0000000000\n"
"        0.3298020165  -0.8258487331   0.0000000000  -0.5729080701   0.0000000000\n"
"        0.1073546335  -0.2832847829   1.0000000000  -0.3825524954   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        2.2321759828   0.3787841491   0.0000000000   0.1555383208   0.0000000000\n"
"        1.3787736290  -0.1239706468   0.0000000000  -0.2931737153   0.0000000000\n"
"        0.4264909846  -0.8298219996   0.0000000000  -0.5781090940   0.0000000000\n"
"        0.1366672601  -0.3175034120   1.0000000000  -0.3901119426   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        2.6436290990   0.3737616862   0.0000000000   0.1735201807   0.0000000000\n"
"        1.6948961534  -0.0996561183   0.0000000000  -0.3100928733   0.0000000000\n"
"        0.5231108387  -0.8315195659   0.0000000000  -0.5807563784   0.0000000000\n"
"        0.1663306775  -0.3339930421   1.0000000000  -0.3879330018   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"K DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  6  3  3\n"
"        4.9094498551   0.3409782009  -0.0718544684   0.0000000000  -0.0383589744   0.0000000000   0.0000000000\n"
"        3.7798462116  -0.7275665906   0.1645679593   0.0000000000  -0.0185547112   0.0000000000   0.0000000000\n"
"        1.2616687398   0.2421667415  -0.0492186533   0.0000000000   0.3499301423   0.0000000000   0.0000000000\n"
"        0.5208676931   0.7973211939  -0.3638537086   0.0000000000   0.5271250194   0.0000000000   0.0000000000\n"
"        0.1977138661   0.2181209543  -0.0636674785   0.0000000000   0.2616666463   1.0000000000   0.0000000000\n"
"        0.0313945665  -0.0006704360   1.0746760317   1.0000000000   0.0081708337   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0741000000   1.0000000000\n"
"#","\n"
"K DZVP-GTH-PADE-CONFINED\n"
"  2\n"
"  3  0  1  6  3  3\n"
"        5.0562599816   0.2799518601  -0.0650771209   0.0000000000  -0.0324181496   0.0000000000   0.0000000000\n"
"        3.7408592301  -0.6649216195   0.1655178754   0.0000000000  -0.0267570689   0.0000000000   0.0000000000\n"
"        1.2850539206   0.2238370548  -0.0537305354   0.0000000000   0.3397270753   0.0000000000   0.0000000000\n"
"        0.5337655981   0.7974284526  -0.3684242774   0.0000000000   0.5266222265   0.0000000000   0.0000000000\n"
"        0.2033806513   0.2347131143  -0.1192800271   0.0000000000   0.2729583365   1.0000000000   0.0000000000\n"
"        0.0366378947  -0.0006397374   1.1060765731   1.0000000000   0.0099036017   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0741000000   1.0000000000\n"
"#","\n"
"# Calcium\n"
"# \n"
"# Z(nuc) = 20\n"
"# Z(eff) = 10\n"
"# E(ref) = -36.614864 a.u. (DZV)\n"
"# \n"
"Ca DZVP-GTH-PADE-q10 DZVP-GTH-PADE\n"
"  2\n"
"  3  0  1  4  3  2\n"
"        2.8976614522   0.6350314914   0.2038750228   0.0000000000   0.1518240054   0.0000000000\n"
"        1.4766172782  -0.6715522195  -0.2579542636   0.0000000000  -0.5771864343   0.0000000000\n"
"        0.4495737541  -0.8068315347  -0.4282041397   0.0000000000  -0.6174577485   0.0000000000\n"
"        0.0520990913  -0.0145128759   1.1194316117   1.0000000000  -0.0373205562   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1088000000   1.0000000000\n"
"#","\n"
"# Scandium\n"
"# \n"
"# Z(nuc) = 21\n"
"# Z(eff) = 11\n"
"# E(ref) = -46.447044 a.u.\n"
"# \n"
"Sc DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        7.6177243131  -0.0025816821   0.0020846187   0.0000000000  -0.0990370320   0.0000000000   0.0417638000  -0.0265577865\n"
"        3.5261707573  -0.4535887309   0.1333741760   0.0000000000   0.0830531204   0.0000000000   0.1794321279  -0.1237289932\n"
"        1.3475088268   0.5851881107  -0.2044293970   0.0000000000   0.5068532353   0.0000000000   0.3071566485  -0.2111871137\n"
"        0.5296968643   0.6915603927  -0.4643940847   0.0000000000   0.4818000644   0.0000000000   0.3729120547  -0.2265277705\n"
"        0.1812303900   0.0523300246   0.1894325403   0.0000000000   0.0896287007   1.0000000000   0.3594956734   0.1297694309\n"
"        0.0515699896  -0.0005424240   0.9922288961   1.0000000000  -0.0048406883   0.0000000000   0.1446776127   0.8641342523\n"
"#","\n"
"# Titanium\n"
"# \n"
"# Z(nuc) = 22\n"
"# Z(eff) = 12\n"
"# E(ref) = -57.906922 a.u.\n"
"# \n"
"Ti DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        7.8662560704  -0.0142007165   0.0051486133   0.0000000000  -0.1058111845   0.0000000000   0.0536511054  -0.0316785505\n"
"        3.8950658856  -0.4494837964   0.1327129568   0.0000000000   0.1048087858   0.0000000000   0.1933632803  -0.1267950119\n"
"        1.5117853291   0.6143981202  -0.2143014467   0.0000000000   0.5160204236   0.0000000000   0.3290345604  -0.2122564864\n"
"        0.5932516463   0.6730966953  -0.4565151952   0.0000000000   0.4704168448   0.0000000000   0.3780068197  -0.2097541935\n"
"        0.2029490001   0.0494956907   0.2060441001   0.0000000000   0.0790813703   1.0000000000   0.3303452351   0.2356257943\n"
"        0.0570083591  -0.0007722992   0.9803815034   1.0000000000  -0.0040175351   0.0000000000   0.1067632616   0.8133941640\n"
"#","\n"
"# Titanium\n"
"# \n"
"# Z(nuc) = 22\n"
"# Z(eff) = 12\n"
"# r(cov) =      2.494 a.u.\n"
"# E(ref) = -57.768017 a.u.\n"
"# \n"
"Ti DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        7.9054508950  -0.0089866342   0.0033403228   0.0000000000  -0.1044805862   0.0000000000   0.0524477349  -0.0208282688\n"
"        3.9606136239  -0.4508141066   0.1442719748   0.0000000000   0.0963354612   0.0000000000   0.1891993776  -0.0904000412\n"
"        1.5621587965   0.5637837175  -0.2125114543   0.0000000000   0.4935065359   0.0000000000   0.3209566467  -0.1191689233\n"
"        0.6278375325   0.6987976039  -0.4744456374   0.0000000000   0.4799614577   0.0000000000   0.3684022594  -0.2436747742\n"
"        0.2253690150   0.0716873095   0.0753192189   0.0000000000   0.0995748325   1.0000000000   0.3365998900   0.0009608049\n"
"        0.0725661163  -0.0018693598   1.0806476083   1.0000000000  -0.0043939777   0.0000000000   0.1049021142   0.9691386629\n"
"#","\n"
"# Vanadium\n"
"# \n"
"# Z(nuc) = 23\n"
"# Z(eff) = 13\n"
"# E(ref) = -71.188765 a.u.\n"
"# \n"
"V DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        7.8747524263  -0.0443841418   0.0126347723   0.0000000000  -0.1144265054   0.0000000000   0.0651523717  -0.0186113262\n"
"        4.0933440615  -0.4317842194   0.1208086573   0.0000000000   0.1421671368   0.0000000000   0.2101756320  -0.0735897040\n"
"        1.6384502186   0.6727841327  -0.2278558403   0.0000000000   0.5251937993   0.0000000000   0.3407334498  -0.0858251101\n"
"        0.6438497632   0.6346678975  -0.4409702916   0.0000000000   0.4484462388   0.0000000000   0.3767018108  -0.2121800208\n"
"        0.2206224245   0.0418256229   0.2306573940   0.0000000000   0.0670590120   1.0000000000   0.3023326440   0.0291442397\n"
"        0.0614716642  -0.0007065154   0.9629588869   1.0000000000  -0.0031794120   0.0000000000   0.0836085023   0.9675641584\n"
"#","\n"
"# Chromium\n"
"# \n"
"# Z(nuc) = 24\n"
"# Z(eff) = 14\n"
"# E(ref) = -86.421763 a.u.\n"
"# \n"
"Cr DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        8.4980218808  -0.0608783001   0.0160558551   0.0000000000  -0.0906220888   0.0000000000   0.0912009861  -0.0448527735\n"
"        4.3332768421  -0.4362254023   0.1136246368   0.0000000000   0.1247923043   0.0000000000   0.1856901245  -0.0956642574\n"
"        1.8357623166   0.6983227560  -0.2164316105   0.0000000000   0.5242992155   0.0000000000   0.3171108663  -0.1613201508\n"
"        0.7086266315   0.6277540640  -0.3811547378   0.0000000000   0.4531101254   0.0000000000   0.3686546467  -0.1825467055\n"
"        0.2325535793   0.0471147492   0.1539908695   0.0000000000   0.0676061963   1.0000000000   0.3250452914   0.0506894382\n"
"        0.0621290391  -0.0023417403   0.9943414586   1.0000000000  -0.0037177277   0.0000000000   0.1425114774   0.9264839944\n"
"#","\n"
"# Manganese\n"
"# \n"
"# Z(nuc) = 25\n"
"# Z(eff) = 15\n"
"# E(ref) = -103.693822 a.u.\n"
"# \n"
"Mn DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        8.2162644620  -0.1392987047   0.0379745482   0.0000000000  -0.0706781641   0.0000000000   0.1231824621  -0.0271916197\n"
"        4.3995038116  -0.3474284933   0.1026238058   0.0000000000   0.1421129189   0.0000000000   0.2003862748  -0.0616392441\n"
"        1.9735860720   0.7276920861  -0.2459044301   0.0000000000   0.5304230993   0.0000000000   0.3396356204  -0.0508758521\n"
"        0.7747355100   0.5917173669  -0.4104364589   0.0000000000   0.4289471268   0.0000000000   0.3764537252  -0.2226457142\n"
"        0.2621680644   0.0446992498   0.2379188342   0.0000000000   0.0557678273   1.0000000000   0.2677240676   0.0808460497\n"
"        0.0708470020  -0.0024642409   0.9512627458   1.0000000000  -0.0025525092   0.0000000000   0.0617409278   0.9529259336\n"
"#","\n"
"# Iron\n"
"# \n"
"# Z(nuc) = 26\n"
"# Z(eff) = 16\n"
"# E(ref) = -123.167637 a.u.\n"
"# \n"
"Fe DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        8.3176581765  -0.2221260103   0.0571340867   0.0000000000  -0.0835047401   0.0000000000   0.1328616119  -0.0265786973\n"
"        4.4422592901  -0.2065484249   0.0659015546   0.0000000000   0.2224692471   0.0000000000   0.2337033217  -0.0640748896\n"
"        1.9537149970   0.7710412303  -0.2695445185   0.0000000000   0.5334951260   0.0000000000   0.3480430202  -0.0427943670\n"
"        0.7755476397   0.5063505210  -0.3754221317   0.0000000000   0.3763681502   0.0000000000   0.3564479505  -0.2349902890\n"
"        0.2667047888   0.0299286713   0.2874114014   0.0000000000   0.0390767933   1.0000000000   0.2392969951   0.1437613614\n"
"        0.0730205366  -0.0015070313   0.9166672323   1.0000000000  -0.0012748470   0.0000000000   0.0495086684   0.9263257056\n"
"#","\n"
"# Cobalt\n"
"# \n"
"# Z(nuc) = 27\n"
"# Z(eff) = 17\n"
"# E(ref) = -145.074726 a.u.\n"
"# \n"
"Co DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        8.2259784105  -0.3348828014   0.0839161925   0.0000000000  -0.0575730412   0.0000000000   0.1703306058  -0.0329647329\n"
"        4.0899376713   0.0273051456   0.0043597020   0.0000000000   0.3114547257   0.0000000000   0.2731993143  -0.0646674934\n"
"        1.7906737831   0.8008414138  -0.3063471909   0.0000000000   0.5288889096   0.0000000000   0.3481942056  -0.0406024695\n"
"        0.7202346272   0.3743034819  -0.3094552251   0.0000000000   0.2922852722   0.0000000000   0.3268542552  -0.2546151534\n"
"        0.2531395288   0.0119133243   0.3681678234   0.0000000000   0.0193344238   1.0000000000   0.1983580019   0.2591729030\n"
"        0.0724847250  -0.0002875656   0.8518740079   1.0000000000  -0.0000074411   0.0000000000   0.0347706125   0.8655847940\n"
"#","\n"
"# Nickel\n"
"# \n"
"# Z(nuc) = 28\n"
"# Z(eff) = 18\n"
"# E(ref) = -169.014868 a.u. (DZV)\n"
"# \n"
"Ni SZV-GTH-PADE-q18 SZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  2  1  1\n"
"        9.1083628918  -0.3318472282   0.0814757465  -0.0734890997   0.1546631104\n"
"        4.7077006381   0.0215195281   0.0083255182   0.3143433748   0.2793018964\n"
"        2.0075563311   0.7820035505  -0.2919821887   0.5321470345   0.3572041353\n"
"        0.7991545346   0.3981367371  -0.3174059212   0.3004714229   0.3257021539\n"
"        0.2801233689   0.0110672576   0.3537517680   0.0204262431   0.1980609814\n"
"        0.0777183285   0.0003240675   0.8632205228   0.0000512651   0.0349659775\n"
"#","\n"
"Ni SZV-GTH-PADE-CONFINED-q18 SZV-GTH-PADE-CONFINED\n"
"  1\n"
"  3  0  2  6  2  1  1\n"
"        9.1839262940  -0.3194864695   0.0820798088  -0.0753895848   0.1482345528\n"
"        4.8715988710  -0.0166115410   0.0216589790   0.2902126119   0.2678833452\n"
"        2.1295830130   0.7470874340  -0.2893085485   0.5183042283   0.3474007726\n"
"        0.8692986192   0.4468007103  -0.3470085291   0.3282859990   0.3267208363\n"
"        0.3160013087   0.0241429107   0.2421486666   0.0331477696   0.2129571216\n"
"        0.0996764017  -0.0007297350   0.9538524021  -0.0007168330   0.0399879500\n"
"#","\n"
"Ni DZV-GTH-PADE-q18 DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        9.1083628918  -0.3318472282   0.0814757465   0.0000000000  -0.0734890997   0.0000000000   0.1546631104  -0.0270446181\n"
"        4.7077006381   0.0215195281   0.0083255182   0.0000000000   0.3143433748   0.0000000000   0.2793018964  -0.0621439339\n"
"        2.0075563311   0.7820035505  -0.2919821887   0.0000000000   0.5321470345   0.0000000000   0.3572041353  -0.0346035868\n"
"        0.7991545346   0.3981367371  -0.3174059212   0.0000000000   0.3004714229   0.0000000000   0.3257021539  -0.2542426351\n"
"        0.2801233689   0.0110672576   0.3537517680   0.0000000000   0.0204262431   1.0000000000   0.1980609814   0.2437546148\n"
"        0.0777183285   0.0003240675   0.8632205228   1.0000000000   0.0000512651   0.0000000000   0.0349659775   0.8783250274\n"
"#","\n"
"Ni DZV-GTH-PADE-CONFINED-q18 DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        9.1839262940  -0.3194864695   0.0820798088   0.0000000000  -0.0753895848   0.0000000000   0.1482345528  -0.0303971456\n"
"        4.8715988710  -0.0166115410   0.0216589790   0.0000000000   0.2902126119   0.0000000000   0.2678833452  -0.0724968085\n"
"        2.1295830130   0.7470874340  -0.2893085485   0.0000000000   0.5183042283   0.0000000000   0.3474007726  -0.0383232476\n"
"        0.8692986192   0.4468007103  -0.3470085291   0.0000000000   0.3282859990   0.0000000000   0.3267208363  -0.2746023312\n"
"        0.3160013087   0.0241429107   0.2421486666   0.0000000000   0.0331477696   1.0000000000   0.2129571216   0.2181292551\n"
"        0.0996764017  -0.0007297350   0.9538524021   1.0000000000  -0.0007168330   0.0000000000   0.0399879500   0.8850545821\n"
"#","\n"
"# Nickel\n"
"# \n"
"# Z(nuc) = 28\n"
"# Z(eff) = 10\n"
"# E(ref) = -36.954230 a.u.\n"
"# \n"
"Ni DZV-GTH-PADE-q10\n"
"  1\n"
"  3  0  2  6  2  2  2\n"
"        5.2465385132  -0.0195686939   0.0000000000   0.0016517420   0.0000000000   0.2741056767  -0.0137577062\n"
"        2.6090644689   0.0813873400   0.0000000000  -0.0052396301   0.0000000000   0.3543794794  -0.0268890369\n"
"        1.1046166843  -0.2728677440   0.0000000000   0.0619959272   0.0000000000   0.3296854386   0.0126199016\n"
"        0.4448692089  -0.0688949785   0.0000000000  -0.0614220277   0.0000000000   0.2335185166  -0.3679775516\n"
"        0.1687659415   0.6206874931   0.0000000000  -0.2903889111   1.0000000000   0.0992461972   0.4117542785\n"
"        0.0576654368   0.5625306587   1.0000000000  -0.7554832177   0.0000000000   0.0101944431   0.7852149041\n"
"#","\n"
"# Copper\n"
"# \n"
"# Z(nuc) = 29\n"
"# Z(eff) = 11\n"
"# E(ref) = -47.922396 a.u.\n"
"# \n"
"Cu DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  2  2  2\n"
"        5.7799826780  -0.0137622398   0.0000000000  -0.0019325638   0.0000000000   0.2572828355  -0.0100377492\n"
"        2.9223072565   0.0624852089   0.0000000000   0.0066529976   0.0000000000   0.3370459629  -0.0172155062\n"
"        1.2410860367  -0.2101042076   0.0000000000  -0.0486904400   0.0000000000   0.3219866164   0.0080455917\n"
"        0.4926826906  -0.1147109815   0.0000000000   0.0379720404   0.0000000000   0.2528381981  -0.2353878212\n"
"        0.1789330672   0.5404419433   0.0000000000   0.2206564191   1.0000000000   0.1448314035   0.0049310905\n"
"        0.0561739570   0.6479193925   1.0000000000   0.8303966635   0.0000000000   0.0314382917   1.0108918979\n"
"#","\n"
"# Zinc\n"
"# \n"
"# Z(nuc) = 30\n"
"# Z(eff) = 12\n"
"# E(ref) = -60.408339 a.u.\n"
"# \n"
"Zn DZV-GTH-PADE\n"
"  1\n"
"  3  0  2  6  2  2  2\n"
"        6.4206423601  -0.0159961492   0.0000000000  -0.0017007517   0.0000000000   0.2738774540  -0.0086808361\n"
"        3.2164545624   0.0700921695   0.0000000000   0.0057876549   0.0000000000   0.3543101613  -0.0259525057\n"
"        1.3637346905  -0.2332431465   0.0000000000  -0.0557262454   0.0000000000   0.3285180198   0.0317203087\n"
"        0.5481563712  -0.1137154667   0.0000000000   0.0463783393   0.0000000000   0.2334531038  -0.3651680612\n"
"        0.2053011443   0.5909100816   0.0000000000   0.2629520047   1.0000000000   0.1017295445   0.3530864382\n"
"        0.0662102782   0.6085540919   1.0000000000   0.7908150346   0.0000000000   0.0108701745   0.8289022633\n"
"#","\n"
"# Zinc\n"
"# \n"
"# r(cov) =      2.362 a.u.\n"
"# E(ref) = -60.299849 a.u.\n"
"# \n"
"Zn DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  3  0  2  6  2  2  2\n"
"        6.4635610128  -0.0174178283   0.0000000000   0.0014889091   0.0000000000   0.2661076361  -0.0172911104\n"
"        3.3087913561   0.0729496060   0.0000000000  -0.0053382185   0.0000000000   0.3453918347  -0.0353171901\n"
"        1.4436868426  -0.2102985944   0.0000000000   0.0544382687   0.0000000000   0.3206623881   0.0094335277\n"
"        0.6045470598  -0.1788671076   0.0000000000  -0.0164095173   0.0000000000   0.2357873353  -0.3686660487\n"
"        0.2390582336   0.5149852625   0.0000000000  -0.2811557323   1.0000000000   0.1164010142   0.3573346078\n"
"        0.0857774784   0.7053938257   1.0000000000  -0.7792591266   0.0000000000   0.0149561710   0.8225277665\n"
"#","\n"
"# Bromine\n"
"# \n"
"# Z(nuc) = 35\n"
"# Z(eff) = 7\n"
"# E(ref) = -13.399562 a.u.\n"
"# \n"
"Br DZVP-GTH-PADE\n"
"  2\n"
"  4  0  1  6  2  2\n"
"        3.1292582762   0.1580383222   0.0000000000  -0.0227993689   0.0000000000\n"
"        2.0410191811  -0.5451938775   0.0000000000  -0.0920733298   0.0000000000\n"
"        0.8302017350   0.1080068318   0.0000000000   0.1803022828   0.0000000000\n"
"        0.3973439755   0.6925896761   0.0000000000   0.4347908141   0.0000000000\n"
"        0.1725496378   0.4230867305   0.0000000000   0.4234285104   0.0000000000\n"
"        0.0696797072   0.0332389489   1.0000000000   0.1406796525   1.0000000000\n"
"  4  2  2  1  1\n"
"        0.3620000000   1.0000000000\n"
"#","\n"
"# Yttrium\n"
"# \n"
"# Z(nuc) = 39\n"
"# Z(eff) = 11\n"
"# E(ref) = -38.220903 a.u. (DZV)\n"
"# \n"
"Y SZV-GTH-PADE\n"
"  1\n"
"  4  0  2  6  2  1  1\n"
"        7.8428845299   0.0803324138  -0.0266188717   0.0134161241  -0.0016439813\n"
"        2.7619481977  -0.6392520852   0.2386709814  -0.1893880809  -0.0012258216\n"
"        1.1534752103   0.4260952519  -0.1749784343   0.4372433962   0.1854518520\n"
"        0.4724776609   0.8755246609  -0.5963031281   0.6173916742   0.3755995103\n"
"        0.1689866773   0.0824597184   0.1334866382   0.1503112301   0.4711505916\n"
"        0.0490946914  -0.0003667507   1.0516399914  -0.0061616659   0.2624412351\n"
"#","\n"
"Y SZV-GTH-PADE-CONFINED\n"
"  1\n"
"  4  0  2  6  2  1  1\n"
"        7.8513817096   0.0798606067  -0.0279472583   0.0137177365  -0.0014643321\n"
"        2.7616577921  -0.6382967169   0.2509901785  -0.1927451959  -0.0030943144\n"
"        1.1844670938   0.3929099619  -0.1729550553   0.4168976599   0.1811003704\n"
"        0.4898256283   0.8878410454  -0.6035125417   0.6214526828   0.3711873238\n"
"        0.1795686728   0.1040199200   0.0270233339   0.1694869546   0.4764905487\n"
"        0.0573407217  -0.0015793010   1.1284469161  -0.0059902205   0.2444820548\n"
"#","\n"
"Y DZV-GTH-PADE\n"
"  1\n"
"  4  0  2  6  3  2  2\n"
"        7.8428845299   0.0803324138  -0.0266188717   0.0000000000   0.0134161241   0.0000000000  -0.0016439813   0.0000000000\n"
"        2.7619481977  -0.6392520852   0.2386709814   0.0000000000  -0.1893880809   0.0000000000  -0.0012258216   0.0000000000\n"
"        1.1534752103   0.4260952519  -0.1749784343   0.0000000000   0.4372433962   0.0000000000   0.1854518520   0.0000000000\n"
"        0.4724776609   0.8755246609  -0.5963031281   0.0000000000   0.6173916742   0.0000000000   0.3755995103   1.0000000000\n"
"        0.1689866773   0.0824597184   0.1334866382   0.0000000000   0.1503112301   1.0000000000   0.4711505916   0.0000000000\n"
"        0.0490946914  -0.0003667507   1.0516399914   1.0000000000  -0.0061616659   0.0000000000   0.2624412351   0.0000000000\n"
"#","\n"
"Y DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  4  0  2  6  3  2  2\n"
"        7.8513817096   0.0798606067  -0.0279472583   0.0000000000   0.0137177365   0.0000000000  -0.0014643321   0.0000000000\n"
"        2.7616577921  -0.6382967169   0.2509901785   0.0000000000  -0.1927451959   0.0000000000  -0.0030943144   0.0000000000\n"
"        1.1844670938   0.3929099619  -0.1729550553   0.0000000000   0.4168976599   0.0000000000   0.1811003704   0.0000000000\n"
"        0.4898256283   0.8878410454  -0.6035125417   0.0000000000   0.6214526828   0.0000000000   0.3711873238   1.0000000000\n"
"        0.1795686728   0.1040199200   0.0270233339   0.0000000000   0.1694869546   1.0000000000   0.4764905487   0.0000000000\n"
"        0.0573407217  -0.0015793010   1.1284469161   1.0000000000  -0.0059902205   0.0000000000   0.2444820548   0.0000000000\n"
"#","\n"
"# Zirconium\n"
"# \n"
"# Z(nuc) = 40\n"
"# Z(eff) = 12\n"
"# E(ref) = -46.893180 a.u. (DZV)\n"
"# \n"
"Zr SZV-GTH-PADE\n"
"  1\n"
"  4  0  2  6  2  1  1\n"
"        7.6857477291   0.0921982715  -0.0300916002   0.0146645208  -0.0028305635\n"
"        2.8983441504  -0.7069142736   0.2663213129  -0.2102277970   0.0073835576\n"
"        1.2697609208   0.5009909419  -0.2139641740   0.4771534202   0.2198586769\n"
"        0.5172494858   0.8658642938  -0.6004758231   0.6141472939   0.4200820229\n"
"        0.1837156188   0.0697098809   0.1712660028   0.1280872093   0.4495790932\n"
"        0.0544846775  -0.0001210510   1.0314604844  -0.0061029355   0.1822139319\n"
"#","\n"
"Zr SZV-GTH-PADE-CONFINED\n"
"  1\n"
"  4  0  2  6  2  1  1\n"
"        7.6907307864   0.0918380423  -0.0320131875   0.0151438658  -0.0025460744\n"
"        2.8994679368  -0.7065066090   0.2831559477  -0.2148939669   0.0047430657\n"
"        1.3083923278   0.4616304054  -0.2132614049   0.4535119288   0.2123619968\n"
"        0.5389907155   0.8834077941  -0.6128847036   0.6213717566   0.4126795546\n"
"        0.1971440852   0.0929467894   0.0453994877   0.1490106611   0.4547421602\n"
"        0.0656808473  -0.0016305751   1.1255334296  -0.0064460597   0.1726337227\n"
"#","\n"
"Zr DZV-GTH-PADE\n"
"  1\n"
"  4  0  2  6  3  2  2\n"
"        7.6857477291   0.0921982715  -0.0300916002   0.0000000000   0.0146645208   0.0000000000  -0.0028305635   0.0000000000\n"
"        2.8983441504  -0.7069142736   0.2663213129   0.0000000000  -0.2102277970   0.0000000000   0.0073835576   0.0000000000\n"
"        1.2697609208   0.5009909419  -0.2139641740   0.0000000000   0.4771534202   0.0000000000   0.2198586769   0.0000000000\n"
"        0.5172494858   0.8658642938  -0.6004758231   0.0000000000   0.6141472939   0.0000000000   0.4200820229   1.0000000000\n"
"        0.1837156188   0.0697098809   0.1712660028   0.0000000000   0.1280872093   1.0000000000   0.4495790932   0.0000000000\n"
"        0.0544846775  -0.0001210510   1.0314604844   1.0000000000  -0.0061029355   0.0000000000   0.1822139319   0.0000000000\n"
"#","\n"
"Zr DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  4  0  2  6  3  2  2\n"
"        7.6907307864   0.0918380423  -0.0320131875   0.0000000000   0.0151438658   0.0000000000  -0.0025460744   0.0000000000\n"
"        2.8994679368  -0.7065066090   0.2831559477   0.0000000000  -0.2148939669   0.0000000000   0.0047430657   0.0000000000\n"
"        1.3083923278   0.4616304054  -0.2132614049   0.0000000000   0.4535119288   0.0000000000   0.2123619968   0.0000000000\n"
"        0.5389907155   0.8834077941  -0.6128847036   0.0000000000   0.6213717566   0.0000000000   0.4126795546   1.0000000000\n"
"        0.1971440852   0.0929467894   0.0453994877   0.0000000000   0.1490106611   1.0000000000   0.4547421602   0.0000000000\n"
"        0.0656808473  -0.0016305751   1.1255334296   1.0000000000  -0.0064460597   0.0000000000   0.1726337227   0.0000000000\n"
"#","\n"
"# Platinum\n"
"# \n"
"# Z(nuc) = 78\n"
"# Z(eff) = 18\n"
"# E(ref) = -120.876931 a.u. (DZV)\n"
"# \n"
"Pt SZV-GTH-PADE\n"
"  1\n"
"  5  0  2  5  2  1  1\n"
"        3.8539902592   0.6550845009  -0.1051705366   0.1013168098   0.0757804127\n"
"        1.7615287193  -0.8764031847   0.1401591199  -0.4564614080  -0.2980475179\n"
"        0.7984755007  -0.5895118007   0.6070281980  -0.5905298499  -0.4267024585\n"
"        0.3063995931  -0.0418859472  -0.2491931231  -0.0921404881  -0.4156575987\n"
"        0.0905510437   0.0010007235  -1.0046330563   0.0002983670  -0.1378705014\n"
"#","\n"
"Pt DZV-GTH-PADE\n"
"  1\n"
"  5  0  2  5  3  2  2\n"
"        3.8539902592   0.6550845009  -0.1051705366   0.0000000000   0.1013168098   0.0000000000   0.0757804127   0.0000000000\n"
"        1.7615287193  -0.8764031847   0.1401591199   0.0000000000  -0.4564614080   0.0000000000  -0.2980475179   0.0000000000\n"
"        0.7984755007  -0.5895118007   0.6070281980   0.0000000000  -0.5905298499   0.0000000000  -0.4267024585   1.0000000000\n"
"        0.3063995931  -0.0418859472  -0.2491931231   0.0000000000  -0.0921404881   1.0000000000  -0.4156575987   0.0000000000\n"
"        0.0905510437   0.0010007235  -1.0046330563   1.0000000000   0.0002983670   0.0000000000  -0.1378705014   0.0000000000\n"
"#","\n"
"# Platinum\n"
"# \n"
"# Z(nuc) = 78\n"
"# Z(eff) = 18\n"
"# r(cov) =       2.457 a.u.\n"
"# E(ref) = -120.704482 a.u. (DZV)\n"
"# \n"
"Pt SZV-GTH-PADE-CONFINED\n"
"  1\n"
"  5  0  2  5  2  1  1\n"
"        3.8119175158   0.6811428125  -0.1098754333   0.1070703344   0.0816913963\n"
"        1.8322303424  -0.8481780351   0.1224415322  -0.4203762499  -0.2816553083\n"
"        0.8395270960  -0.6301940141   0.6208296307  -0.6135494498  -0.4250744523\n"
"        0.3248710896  -0.0565770730  -0.1523972357  -0.1113673639  -0.4272240550\n"
"        0.1034693582   0.0020421374  -1.0726205087   0.0007567030  -0.1392021184\n"
"#","\n"
"Pt DZV-GTH-PADE-CONFINED\n"
"  1\n"
"  5  0  2  5  3  2  2\n"
"        3.8119175158   0.6811428125  -0.1098754333   0.0000000000   0.1070703344   0.0000000000   0.0816913963   0.0000000000\n"
"        1.8322303424  -0.8481780351   0.1224415322   0.0000000000  -0.4203762499   0.0000000000  -0.2816553083   0.0000000000\n"
"        0.8395270960  -0.6301940141   0.6208296307   0.0000000000  -0.6135494498   0.0000000000  -0.4250744523   1.0000000000\n"
"        0.3248710896  -0.0565770730  -0.1523972357   0.0000000000  -0.1113673639   1.0000000000  -0.4272240550   0.0000000000\n"
"        0.1034693582   0.0020421374  -1.0726205087   1.0000000000   0.0007567030   0.0000000000  -0.1392021184   0.0000000000\n"
"#","\n"
"H DZV-GTH-BLYP\n"
"  1\n"
"  1  0  0  4  2\n"
"        8.5926819670  -0.0253743372   0.0000000000\n"
"        1.8741624886  -0.1423057735   0.0000000000\n"
"        0.5105244224  -0.2688793627   0.0000000000\n"
"        0.1671584984  -0.6811381593   1.0000000000\n"
"#","\n"
"H DZV-GTH-BLYP-CONFINED\n"
"  1\n"
"  1  0  0  4  2\n"
"        8.5926819670  -0.0295744132   0.0000000000\n"
"        1.8741624886  -0.1366960483   0.0000000000\n"
"        0.5105244224  -0.3996700661   0.0000000000\n"
"        0.1671584984  -0.5535181527   1.0000000000\n"
"#","\n"
"H DZVP-GTH-BLYP\n"
"  2\n"
"  1  0  0  4  2\n"
"        8.5926819670  -0.0253743372   0.0000000000\n"
"        1.8741624886  -0.1423057735   0.0000000000\n"
"        0.5105244224  -0.2688793627   0.0000000000\n"
"        0.1671584984  -0.6811381593   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"H DZVP-GTH-BLYP-CONFINED\n"
"  2\n"
"  1  0  0  4  2\n"
"        8.5926819670  -0.0295744132   0.0000000000\n"
"        1.8741624886  -0.1366960483   0.0000000000\n"
"        0.5105244224  -0.3996700661   0.0000000000\n"
"        0.1671584984  -0.5535181527   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"He DZV-GTH-BLYP\n"
"  1\n"
"  1  0  0  4  2\n"
"       11.1193917922  -0.0770450237   0.0000000000\n"
"        2.7858130727  -0.2506337219   0.0000000000\n"
"        0.7622149528  -0.4810430873   0.0000000000\n"
"        0.2069465438  -0.3647148361   1.0000000000\n"
"#","\n"
"He DZVP-GTH-BLYP\n"
"  2\n"
"  1  0  0  4  2\n"
"       11.1193917922  -0.0770450237   0.0000000000\n"
"        2.7858130727  -0.2506337219   0.0000000000\n"
"        0.7622149528  -0.4810430873   0.0000000000\n"
"        0.2069465438  -0.3647148361   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"Li DZV-GTH-BLYP\n"
"  1\n"
"  1  0  0  6  3\n"
"        9.2302808251   0.1415242446  -0.0269136246   0.0000000000\n"
"        4.3944449344   0.2843546506  -0.0528260176   0.0000000000\n"
"        1.4510059930   0.4411787547  -0.1332651028   0.0000000000\n"
"        0.5085373954   0.2629872002  -0.0961377531   0.0000000000\n"
"        0.0767907273   0.0115877019   0.5683374551   0.0000000000\n"
"        0.0261032845  -0.0035737781   0.5290064307   1.0000000000\n"
"#","\n"
"Li DZVP-GTH-BLYP\n"
"  1\n"
"  1  0  1  6  3  3\n"
"        9.2302808251   0.1415242446  -0.0269136246   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        4.3944449344   0.2843546506  -0.0528260176   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4510059930   0.4411787547  -0.1332651028   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5085373954   0.2629872002  -0.0961377531   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0767907273   0.0115877019   0.5683374551   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0261032845  -0.0035737781   0.5290064307   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Be DZV-GTH-BLYP\n"
"  1\n"
"  1  0  0  6  3\n"
"       16.7422288908   0.0966449867  -0.0233351760   0.0000000000\n"
"        8.5397710546   0.3229144731  -0.0609785084   0.0000000000\n"
"        2.8008728446   0.4309094768  -0.1582208472   0.0000000000\n"
"        1.0279668171   0.2665960365  -0.0996495616   0.0000000000\n"
"        0.1816198908   0.0129440911   0.5661714027   0.0000000000\n"
"        0.0575318884  -0.0033470492   0.5467939201   1.0000000000\n"
"#","\n"
"Be DZVP-GTH-BLYP\n"
"  1\n"
"  1  0  1  6  3  3\n"
"       16.7422288908   0.0966449867  -0.0233351760   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.5397710546   0.3229144731  -0.0609785084   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.8008728446   0.4309094768  -0.1582208472   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0279668171   0.2665960365  -0.0996495616   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1816198908   0.0129440911   0.5661714027   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0575318884  -0.0033470492   0.5467939201   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"B DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        2.8461657736   0.1478743320   0.0000000000  -0.0780482479   0.0000000000\n"
"        0.8351785230  -0.0200254137   0.0000000000  -0.2557970914   0.0000000000\n"
"        0.2702560177  -0.6820892853   0.0000000000  -0.4542195946   0.0000000000\n"
"        0.0805636848  -0.4080927351   1.0000000000  -0.4455266641   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4000000000   1.0000000000\n"
"#","\n"
"C DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        4.3451975957   0.1511172750   0.0000000000  -0.0883417890   0.0000000000\n"
"        1.2765552224  -0.0330272512   0.0000000000  -0.2797032766   0.0000000000\n"
"        0.4047139801  -0.6994401873   0.0000000000  -0.4686400677   0.0000000000\n"
"        0.1166096360  -0.3842706677   1.0000000000  -0.4085514115   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"N DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        6.1514293421   0.1529382304   0.0000000000  -0.0952593918   0.0000000000\n"
"        1.8080207176  -0.0415737876   0.0000000000  -0.2946953365   0.0000000000\n"
"        0.5656159036  -0.7060780663   0.0000000000  -0.4740427661   0.0000000000\n"
"        0.1593207770  -0.3734107042   1.0000000000  -0.3884930037   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"O DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        8.2783332000   0.1537128043   0.0000000000  -0.1000437084   0.0000000000\n"
"        2.4319182697  -0.0468575728   0.0000000000  -0.3046718654   0.0000000000\n"
"        0.7530401707  -0.7092306221   0.0000000000  -0.4764866041   0.0000000000\n"
"        0.2084649705  -0.3678036990   1.0000000000  -0.3764915728   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"O DZVP-GTH-BLYP-CONFINED\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        8.8354826103   0.1386860737   0.0000000000  -0.0892277038   0.0000000000\n"
"        2.7621439773   0.0162775038   0.0000000000  -0.2724019359   0.0000000000\n"
"        0.8984199177  -0.6272143534   0.0000000000  -0.4630551829   0.0000000000\n"
"        0.2813539810  -0.4833352657   1.0000000000  -0.4046182936   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"F DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  4  2  2\n"
"       10.7284760684   0.1539953252   0.0000000000  -0.1034591141   0.0000000000\n"
"        3.1496622427  -0.0503062083   0.0000000000  -0.3116781877   0.0000000000\n"
"        0.9671794608  -0.7107682323   0.0000000000  -0.4776960745   0.0000000000\n"
"        0.2640315133  -0.3648266470   1.0000000000  -0.3688578623   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.0000000000   1.0000000000\n"
"#","\n"
"Ne DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  4  2  2\n"
"       13.5711021582   0.1528118547   0.0000000000  -0.1055093745   0.0000000000\n"
"        3.9754062896  -0.0499228626   0.0000000000  -0.3161557844   0.0000000000\n"
"        1.2121681091  -0.7116163527   0.0000000000  -0.4784388183   0.0000000000\n"
"        0.3268420958  -0.3647465749   1.0000000000  -0.3648062165   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.2000000000   1.0000000000\n"
"#","\n"
"Na DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  6  3  3\n"
"       24.4106415968  -0.0437913152   0.0091786765   0.0000000000   0.0412394777   0.0000000000   0.0000000000\n"
"        9.9296107008  -0.2028236387   0.0363180981   0.0000000000   0.1340487332   0.0000000000   0.0000000000\n"
"        3.6565524838   0.2429179955  -0.0394753287   0.0000000000   0.3537211057   0.0000000000   0.0000000000\n"
"        1.2695832879   0.6645538239  -0.2078727830   0.0000000000   0.4486246648   0.0000000000   0.0000000000\n"
"        0.4165172455   0.2885738064  -0.0972810085   0.0000000000   0.2617452725   1.0000000000   0.0000000000\n"
"        0.0447862002  -0.0015791358   1.0489993368   1.0000000000   0.0111532456   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1169000000   1.0000000000\n"
"#","\n"
"Mg DZVP-GTH-BLYP\n"
"  2\n"
"  2  0  1  6  3  3\n"
"       26.6684192078  -0.0843827177   0.0209137976   0.0000000000   0.0574690984   0.0000000000   0.0000000000\n"
"       10.6278914168  -0.1540012185   0.0328904567   0.0000000000   0.1834886260   0.0000000000   0.0000000000\n"
"        4.0257536169   0.3069950002  -0.0656366632   0.0000000000   0.3728084155   0.0000000000   0.0000000000\n"
"        1.4729826270   0.6341736453  -0.2789230951   0.0000000000   0.4211046995   0.0000000000   0.0000000000\n"
"        0.5301398986   0.2463411075  -0.0573174800   0.0000000000   0.1968486915   1.0000000000   0.0000000000\n"
"        0.0755213250  -0.0010479306   1.0561246927   1.0000000000   0.0067129918   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Al DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        0.9040202750   0.2819459889   0.0000000000   0.0202901873   0.0000000000\n"
"        0.2716888904  -0.3565936829   0.0000000000  -0.2865844984   0.0000000000\n"
"        0.1038208154  -0.7126726101   0.0000000000  -0.4993035494   0.0000000000\n"
"        0.0361219503  -0.1315446458   1.0000000000  -0.3664719249   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Al DZVP-GTH-BLYP-CONFINED\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        0.9188833080   0.2847922923   0.0000000000   0.0265971886   0.0000000000\n"
"        0.3059227599  -0.2166908019   0.0000000000  -0.2493477448   0.0000000000\n"
"        0.1405671989  -0.6528454698   0.0000000000  -0.4330290941   0.0000000000\n"
"        0.0701003942  -0.3130607257   1.0000000000  -0.4145972860   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3000000000   1.0000000000\n"
"#","\n"
"Si DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.1607523260   0.3347731757   0.0000000000   0.0434283150   0.0000000000\n"
"        0.4367408478  -0.3093572718   0.0000000000  -0.2863246710   0.0000000000\n"
"        0.1596639467  -0.7662114250   0.0000000000  -0.5309372647   0.0000000000\n"
"        0.0542076476  -0.1654691868   1.0000000000  -0.3502990755   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"Si DZVP-GTH-BLYP-CONFINED\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.1846613412   0.3285317082   0.0000000000   0.0525302034   0.0000000000\n"
"        0.4966320416  -0.1837395449   0.0000000000  -0.2375844983   0.0000000000\n"
"        0.2018817867  -0.7175956794   0.0000000000  -0.4934742426   0.0000000000\n"
"        0.0883185787  -0.3186166920   1.0000000000  -0.3999071137   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"P DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.4438479448   0.3786128496   0.0000000000   0.0768556482   0.0000000000\n"
"        0.6655205239  -0.2651542911   0.0000000000  -0.2851732159   0.0000000000\n"
"        0.2306279229  -0.8037940077   0.0000000000  -0.5540528446   0.0000000000\n"
"        0.0761045314  -0.2088239606   1.0000000000  -0.3549348725   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"S DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.7644177483   0.4114656852   0.0000000000   0.1207217819   0.0000000000\n"
"        0.9717752574  -0.2250656540   0.0000000000  -0.2949379210   0.0000000000\n"
"        0.3174012156  -0.8265244883   0.0000000000  -0.5702721181   0.0000000000\n"
"        0.1021260036  -0.2549919207   1.0000000000  -0.3673119254   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"Cl DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        2.1331287798   0.4248059842   0.0000000000   0.1653685236   0.0000000000\n"
"        1.3235903746  -0.1892927953   0.0000000000  -0.3177398987   0.0000000000\n"
"        0.4137876064  -0.8368579090   0.0000000000  -0.5798040681   0.0000000000\n"
"        0.1308257425  -0.2914138536   1.0000000000  -0.3759941633   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7500000000   1.0000000000\n"
"#","\n"
"Ar DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        2.5545614018   0.4141718172   0.0000000000   0.1900119384   0.0000000000\n"
"        1.6618834559  -0.1513194180   0.0000000000  -0.3348991938   0.0000000000\n"
"        0.5128881676  -0.8416116448   0.0000000000  -0.5845220689   0.0000000000\n"
"        0.1605817921  -0.3128170499   1.0000000000  -0.3771344877   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8500000000   1.0000000000\n"
"#","\n"
"K DZVP-GTH-BLYP\n"
"  2\n"
"  3  0  1  6  3  3\n"
"        4.7446150543   0.6776090858  -0.1330438947   0.0000000000   0.0442549261   0.0000000000   0.0000000000\n"
"        4.0634061217  -1.0488085165   0.2215127842   0.0000000000  -0.1105968228   0.0000000000   0.0000000000\n"
"        1.3597003283   0.1782277656  -0.0238079016   0.0000000000   0.3264615514   0.0000000000   0.0000000000\n"
"        0.5555828915   0.8152922135  -0.3671176099   0.0000000000   0.5369026258   0.0000000000   0.0000000000\n"
"        0.2069147328   0.2513051410  -0.0812211744   0.0000000000   0.2886757585   1.0000000000   0.0000000000\n"
"        0.0314551108  -0.0007525995   1.0760313569   1.0000000000   0.0096972783   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0741000000   1.0000000000\n"
"#","\n"
"K DZVP-GTH-BLYP-CONFINED\n"
"  2\n"
"  3  0  1  6  3  3\n"
"        5.0541010987   0.3579755406  -0.0764703445   0.0000000000   0.0214294191   0.0000000000   0.0000000000\n"
"        3.9172656623  -0.7279027742   0.1727468706   0.0000000000  -0.0903397463   0.0000000000   0.0000000000\n"
"        1.3875920988   0.1617562448  -0.0280980511   0.0000000000   0.3167508594   0.0000000000   0.0000000000\n"
"        0.5688300282   0.8136478071  -0.3703988041   0.0000000000   0.5367387047   0.0000000000   0.0000000000\n"
"        0.2124883615   0.2680905299  -0.1358924595   0.0000000000   0.2992577807   1.0000000000   0.0000000000\n"
"        0.0365517013  -0.0006990076   1.1057124282   1.0000000000   0.0115831023   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0741000000   1.0000000000\n"
"#","\n"
"# Titanium\n"
"# \n"
"# Z(nuc) = 22\n"
"# Z(eff) = 12\n"
"# E(ref) =  -57.936907 a.u.\n"
"# \n"
"Ti DZV-GTH-BLYP\n"
"  1\n"
"  3  0  2  6  3  2  2\n"
"        7.7577063940  -0.0020221836   0.0007040530   0.0000000000  -0.1128549787   0.0000000000   0.0514577128  -0.0296043049\n"
"        3.9130950485  -0.4886848871   0.1358104132   0.0000000000   0.1055473912   0.0000000000   0.1904588963  -0.1242820460\n"
"        1.5201082969   0.6401079822  -0.2125240090   0.0000000000   0.5200032209   0.0000000000   0.3308521630  -0.2103629080\n"
"        0.5931432380   0.6699336988  -0.4587761894   0.0000000000   0.4712945273   0.0000000000   0.3789723974  -0.2097314556\n"
"        0.2016337402   0.0458870927   0.2236504805   0.0000000000   0.0769848218   1.0000000000   0.3321693836   0.2301712912\n"
"        0.0555239732  -0.0006070586   0.9681970919   1.0000000000  -0.0038977980   0.0000000000   0.1083505565   0.8189372496\n"
"#","\n"
"# Barium\n"
"# \n"
"# Z(nuc) = 56\n"
"# Z(eff) = 10\n"
"# E(ref) =  -25.242058 a.u.\n"
"# \n"
"Ba SZV-GTH-BLYP\n"
"  1\n"
"  5  0  1  3  2  1\n"
"        1.4209812500  -0.5031736249  -0.2251634082  -0.1405229393\n"
"        0.3546440900   1.2590856152   0.8249457612   1.0335378927\n"
"        0.0425115800   0.0618835363  -1.1709205133   0.1096101386\n"
"#","\n"
"# Hydrogen\n"
"# \n"
"# Z(nuc) = 1\n"
"# Z(eff) = 1\n"
"# E(ref) = -0.387060 a.u. (DZV)\n"
"# \n"
"H DZV-GTH-PBE\n"
"  1\n"
"  1  0  0  4  2\n"
"        8.4486934208  -0.0290463773   0.0000000000\n"
"        1.8581649215  -0.1327955318   0.0000000000\n"
"        0.5076108225  -0.4061407363   0.0000000000\n"
"        0.1673904511  -0.5490803703   1.0000000000\n"
"#","\n"
"H DZVP-GTH-PBE\n"
"  2\n"
"  1  0  0  4  2\n"
"        8.4486934208  -0.0290463773   0.0000000000\n"
"        1.8581649215  -0.1327955318   0.0000000000\n"
"        0.5076108225  -0.4061407363   0.0000000000\n"
"        0.1673904511  -0.5490803703   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"# Carbon\n"
"# \n"
"# Z(nuc) = 6\n"
"# Z(eff) = 4\n"
"# E(ref) = -5.357012 a.u. (DZV)\n"
"# \n"
"C DZVP-GTH-PBE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        4.3657614966   0.1476030280   0.0000000000  -0.0864171061   0.0000000000\n"
"        1.2749626469  -0.0210014779   0.0000000000  -0.2743211800   0.0000000000\n"
"        0.4052884311  -0.7098993929   0.0000000000  -0.4772572587   0.0000000000\n"
"        0.1172717248  -0.3801259461   1.0000000000  -0.4035098365   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"# Nitrogen\n"
"# \n"
"# Z(nuc) = 7\n"
"# Z(eff) = 5\n"
"# E(ref) = -9.642007 a.u. (DZV)\n"
"# \n"
"N DZVP-GTH-PBE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        6.1646187898   0.1507499417   0.0000000000  -0.0938164220   0.0000000000\n"
"        1.8037211883  -0.0339053520   0.0000000000  -0.2912161121   0.0000000000\n"
"        0.5658506122  -0.7128963473   0.0000000000  -0.4795028541   0.0000000000\n"
"        0.1603297607  -0.3703029459   1.0000000000  -0.3849298984   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7000000000   1.0000000000\n"
"#","\n"
"# Oxygen\n"
"# \n"
"# Z(nuc) = 8\n"
"# Z(eff) = 6\n"
"# E(ref) = -15.773873 a.u. (DZV)\n"
"# \n"
"O DZVP-GTH-PBE\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        8.2968917719   0.1521363234   0.0000000000  -0.0985730287   0.0000000000\n"
"        2.4314066255  -0.0407682329   0.0000000000  -0.3018606942   0.0000000000\n"
"        0.7547606612  -0.7133526943   0.0000000000  -0.4800913367   0.0000000000\n"
"        0.2102342150  -0.3666620394   1.0000000000  -0.3745464613   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8000000000   1.0000000000\n"
"#","\n"
"# Magnesium\n"
"# \n"
"# Z(nuc) = 12\n"
"# Z(eff) = 10\n"
"# E(ref) = -63.225154 a.u. (DZV)\n"
"# \n"
"Mg DZVP-GTH-PBE-q10 DZVP-GTH-PBE\n"
"  2\n"
"  2  0  1  6  3  3\n"
"       28.2523693585  -0.0714106769   0.0169520109   0.0000000000   0.0508396337   0.0000000000   0.0000000000\n"
"       11.3902578811  -0.1643154146   0.0358612451   0.0000000000   0.1704940251   0.0000000000   0.0000000000\n"
"        4.2988917455   0.2636167334  -0.0572539076   0.0000000000   0.3626339588   0.0000000000   0.0000000000\n"
"        1.5759918035   0.6448595194  -0.2521366266   0.0000000000   0.4306062033   0.0000000000   0.0000000000\n"
"        0.5613579735   0.2752673720  -0.0973472023   0.0000000000   0.2152016385   1.0000000000   0.0000000000\n"
"        0.0754606217  -0.0003305902   1.0641066589   1.0000000000   0.0081228668   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"# Magnesium\n"
"# \n"
"# all radii fixed to 0.18\n"
"# \n"
"# Z(nuc) = 12\n"
"# Z(eff) = 10\n"
"# E(ref) = -62.588650 a.u. (DZV)\n"
"# \n"
"Mg DZV-GTH-PBE-q10-soft\n"
"  2\n"
"  2  0  1  6  3  3\n"
"       18.8104523828  -0.1661468987   0.0354167535   0.0000000000   0.0566689026   0.0000000000   0.0000000000\n"
"        8.2318014002  -0.0567549189   0.0064682696   0.0000000000   0.2254152529   0.0000000000   0.0000000000\n"
"        3.1566348611   0.4035375328  -0.0939726004   0.0000000000   0.4018442569   0.0000000000   0.0000000000\n"
"        1.2110282519   0.6033695127  -0.2761377801   0.0000000000   0.3834403179   0.0000000000   0.0000000000\n"
"        0.4518289787   0.1550065597  -0.0102084295   1.0000000000   0.1456919835   1.0000000000   0.0000000000\n"
"        0.0733999314  -0.0006466925   1.0489008353   0.0000000000   0.0034002162   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"# Magnesium\n"
"# \n"
"# Z(nuc) = 12\n"
"# Z(eff) = 2\n"
"# E(ref) = -0.826790 a.u. (DZV)\n"
"# \n"
"Mg DZVP-GTH-PBE-q2\n"
"  2\n"
"  3  0  0  4  2\n"
"        1.4682667137   0.0219081251   0.0000000000\n"
"        0.6661420794   0.1894369669   0.0000000000\n"
"        0.1116164481  -0.6758108328   0.0000000000\n"
"        0.0398960535  -0.4565650195   1.0000000000\n"
"  3  1  1  1  1\n"
"        0.2000000000   1.0000000000\n"
"#","\n"
"# Silicon\n"
"# \n"
"# Z(nuc) = 14\n"
"# Z(eff) = 4\n"
"# E(ref) = -3.739451 a.u. (DZV)\n"
"# \n"
"Si DZVP-GTH-PBE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.1815290892   0.3214648125   0.0000000000   0.0458533253   0.0000000000\n"
"        0.4454622072  -0.2454343061   0.0000000000  -0.2633419994   0.0000000000\n"
"        0.1674585747  -0.7952663455   0.0000000000  -0.5433222352   0.0000000000\n"
"        0.0564288769  -0.1828967955   1.0000000000  -0.3560783416   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4500000000   1.0000000000\n"
"#","\n"
"# Phosphorus\n"
"# \n"
"# Z(nuc) = 15\n"
"# Z(eff) = 5\n"
"# E(ref) = -6.396285 a.u. (DZV)\n"
"# \n"
"P DZVP-GTH-PBE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.4802317376   0.3584488109   0.0000000000   0.0813818902   0.0000000000\n"
"        0.6986713896  -0.1974902111   0.0000000000  -0.2594593013   0.0000000000\n"
"        0.2410963537  -0.8300256683   0.0000000000  -0.5714822479   0.0000000000\n"
"        0.0788943128  -0.2268703009   1.0000000000  -0.3611947554   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"# Sulfur\n"
"# \n"
"# Z(nuc) = 16\n"
"# Z(eff) = 6\n"
"# E(ref) = -10.064918 a.u. (DZV)\n"
"# \n"
"S DZVP-GTH-PBE\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.8210130043   0.3787811739   0.0000000000   0.1262123760   0.0000000000\n"
"        1.0326142421  -0.1527118831   0.0000000000  -0.2717532297   0.0000000000\n"
"        0.3304499316  -0.8445546077   0.0000000000  -0.5856508153   0.0000000000\n"
"        0.1058215004  -0.2742356178   1.0000000000  -0.3747165087   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6500000000   1.0000000000\n"
"#","\n"
"# Calcium\n"
"# \n"
"# Z(nuc) = 20\n"
"# Z(eff) = 10\n"
"# E(ref) = -36.615304 a.u. (DZV)\n"
"# \n"
"Ca DZVP-GTH-PBE-q10 DZVP-GTH-PBE\n"
"  2\n"
"  3  0  1  4  3  2\n"
"        2.8342212933   0.6441471192   0.2090958309   0.0000000000   0.1692254340   0.0000000000\n"
"        1.4833415585  -0.6848623428  -0.2618151665   0.0000000000  -0.5926970057   0.0000000000\n"
"        0.4519073282  -0.8089853788  -0.4137067900   0.0000000000  -0.6168657871   0.0000000000\n"
"        0.0502772140  -0.0131335018   1.1126219713   1.0000000000  -0.0361141736   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1088000000   1.0000000000\n"
"#","\n"
"Au TZ-GTH\n"
" 1\n"
" 1 0 2 6 3 3 3\n"
"   3.333 -0.2996385052 -0.0253458759 -0.0505901975 0.047560000000 0.0233626853   -0.0684498204  -0.0411742318 -0.0069631085 -0.0874460677\n"
"   1.582 -0.0735011750 0.0529347225  0.3174596863  -0.10200000000 -0.0112096790 0.3475804049 1.1908036284 0.7214138304    1.5934218487\n"
"   .7514  3.4198421760 0.0063068212  -1.0018695196  0.002000000    -0.1543550102 -0.9013800582 1.4081117116 1.000000000     1.2910850825\n"
"   .3568  1.000000000  -0.3216103136 1.00000000000  -0.3480000000  -0.1918211838 1.0 1.000000000  0.7172330126    1.000000000\n"
"   .1694 -7.5936501839 1.000000000   -0.4219772167  0.9589000000   1.000000000   -0.4056275576 0.6305837811 -0.1109815597   3.2469320583\n"
"   .0804 -1.4837051517 0.1624309950  1.6448580273  1.0000000000   -0.1069487306 0.4438513365 0.0688923738 -1.0201823698   -2.0909150178\n"
"#","\n"
"H TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  1  0  0  4  3\n"
"        8.5926819670  -0.0253743372   0.0000000000 0.0\n"
"        1.8741624886  -0.1423057735   0.0000000000 0.0\n"
"        0.5105244224  -0.2688793627   0.0000000000 1.0\n"
"        0.1671584984  -0.6811381593   1.0000000000 0.0\n"
"  2  1  1  1  1\n"
"        3.0000 1.0\n"
"  2  1  1  1  1\n"
"        0.7500 1.0\n"
"  2  1  1  1  1\n"
"        0.1875 1.0\n"
"  3  2  2  1  1\n"
"        1.0000 1.0\n"
"  1  0  0  1  1\n"
"        0.0360 1.0\n"
"#","\n"
"He TZVDD3DF3PD-GTH-BLYP\n"
"  5\n"
"  1  0  0  4  3\n"
"       11.1193917922  -0.0770450237   0.0000000000 0.0\n"
"        2.7858130727  -0.2506337219   0.0000000000 0.0\n"
"        0.7622149528  -0.4810430873   0.0000000000 1.0\n"
"        0.2069465438  -0.3647148361   1.0000000000 0.0\n"
"  2  1  1  1  1\n"
"        3.0000 1.0\n"
"  2  1  1  1  1\n"
"        0.7500 1.0\n"
"  2  1  1  1  1\n"
"        0.1875 1.0\n"
"  3  2  2  1  1\n"
"        2.0000 1.0\n"
"#","\n"
"Li TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  6  5 3\n"
"        9.2302808251   0.1415242446  -0.0269136246   0.0000000000 0.0 0.0 0.0 0.0 0.0\n"
"        4.3944449344   0.2843546506  -0.0528260176   0.0000000000 0.0 0.0 0.0 0.0 0.0\n"
"        1.4510059930   0.4411787547  -0.1332651028   0.0000000000 0.0 0.0 0.0 0.0 0.0\n"
"        0.5085373954   0.2629872002  -0.0961377531   0.0000000000 0.0 1.0 0.0 0.0 1.0\n"
"        0.0767907273   0.0115877019   0.5683374551   0.0000000000 1.0 0.0 0.0 1.0 0.0\n"
"        0.0261032845  -0.0035737781   0.5290064307   1.0000000000 0.0 0.0 1.0 0.0 0.0\n"
"  3  2  2  1  1\n"
"        0.8000 1.0\n"
"  3  2  2  1  1\n"
"        0.2000 1.0\n"
"  3  2  2  1  1\n"
"        0.0500 1.0\n"
"  4  3  3  1  1\n"
"        0.1500 1.0\n"
"  2  0  1  1  1  1\n"
"        0.0074 1.0 1.0\n"
"#","\n"
"Be TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  1  0  1  6  5  3\n"
"       16.7422288908   0.0966449867  -0.0233351760   0.0000000000 0.0 0.0 0.0 0.0 0.0\n"
"        8.5397710546   0.3229144731  -0.0609785084   0.0000000000 0.0 0.0 0.0 0.0 0.0\n"
"        2.8008728446   0.4309094768  -0.1582208472   0.0000000000 0.0 0.0 0.0 0.0 0.0\n"
"        1.0279668171   0.2665960365  -0.0996495616   0.0000000000 0.0 1.0 0.0 0.0 1.0\n"
"        0.1816198908   0.0129440911   0.5661714027   0.0000000000 1.0 0.0 0.0 1.0 0.0\n"
"        0.0575318884  -0.0033470492   0.5467939201   1.0000000000 0.0 0.0 1.0 0.0 0.0\n"
"  3  2  2  1  1\n"
"        1.02000 1.0\n"
"  3  2  2  1  1\n"
"        0.25500 1.0\n"
"  3  2  2  1  1\n"
"        0.06375 1.0\n"
"  4  3  3  1  1\n"
"        0.26000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.0207 1.0 1.0\n"
"#","\n"
"B TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  4  3  3\n"
"        2.8461657736   0.1478743320   0.0000000000 0.0  -0.0780482479   0.0000000000 0.0\n"
"        0.8351785230  -0.0200254137   0.0000000000 0.0  -0.2557970914   0.0000000000 0.0\n"
"        0.2702560177  -0.6820892853   0.0000000000 1.0  -0.4542195946   0.0000000000 1.0\n"
"        0.0805636848  -0.4080927351   1.0000000000 0.0  -0.4455266641   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        1.60400 1.0\n"
"  3  2  2  1  1\n"
"        0.40100 1.0\n"
"  3  2  2  1  1\n"
"        0.10025 1.0\n"
"  4  3  3  1  1\n"
"        0.50000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.03150 1.0 1.0\n"
"#","\n"
"C TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  4  3  3\n"
"        4.3451975957   0.1511172750   0.0000000000 0.0  -0.0883417890   0.0000000000 0.0\n"
"        1.2765552224  -0.0330272512   0.0000000000 0.0  -0.2797032766   0.0000000000 0.0\n"
"        0.4047139801  -0.6994401873   0.0000000000 1.0  -0.4686400677   0.0000000000 1.0\n"
"        0.1166096360  -0.3842706677   1.0000000000 0.0  -0.4085514115   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        2.50400 1.0\n"
"  3  2  2  1  1\n"
"        0.62600 1.0\n"
"  3  2  2  1  1\n"
"        0.15650 1.0\n"
"  4  3  3  1  1\n"
"        0.80000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.04380 1.0 1.0\n"
"#","\n"
"N TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  4  3  3\n"
"        6.1514293421   0.1529382304   0.0000000000 0.0  -0.0952593918   0.0000000000 0.0\n"
"        1.8080207176  -0.0415737876   0.0000000000 0.0  -0.2946953365   0.0000000000 0.0\n"
"        0.5656159036  -0.7060780663   0.0000000000 1.0  -0.4740427661   0.0000000000 1.0\n"
"        0.1593207770  -0.3734107042   1.0000000000 0.0  -0.3884930037   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        3.65200 1.0\n"
"  3  2  2  1  1\n"
"        0.91300 1.0\n"
"  3  2  2  1  1\n"
"        0.22825 1.0\n"
"  4  3  3  1  1\n"
"        1.00000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.06390 1.0 1.0\n"
"#","\n"
"O TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  4  3  3\n"
"        8.2783332000   0.1537128043   0.0000000000 0.0  -0.1000437084   0.0000000000 0.0\n"
"        2.4319182697  -0.0468575728   0.0000000000 0.0  -0.3046718654   0.0000000000 0.0\n"
"        0.7530401707  -0.7092306221   0.0000000000 1.0  -0.4764866041   0.0000000000 1.0\n"
"        0.2084649705  -0.3678036990   1.0000000000 0.0  -0.3764915728   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        5.16000 1.0\n"
"  3  2  2  1  1\n"
"        1.29200 1.0\n"
"  3  2  2  1  1\n"
"        0.33250 1.0\n"
"  4  3  3  1  1\n"
"        1.40000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.08450 1.0 1.0\n"
"#","\n"
"F TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  4  3  3\n"
"       10.7284760684   0.1539953252   0.0000000000 0.0  -0.1034591141   0.0000000000 0.0\n"
"        3.1496622427  -0.0503062083   0.0000000000 0.0  -0.3116781877   0.0000000000 0.0\n"
"        0.9671794608  -0.7107682323   0.0000000000 1.0  -0.4776960745   0.0000000000 1.0\n"
"        0.2640315133  -0.3648266470   1.0000000000 0.0  -0.3688578623   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        7.00000 1.0\n"
"  3  2  2  1  1\n"
"        1.75000 1.0\n"
"  3  2  2  1  1\n"
"        0.43750 1.0\n"
"  4  3  3  1  1\n"
"        1.85000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.10760 1.0 1.0\n"
"#","\n"
"Ne TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  4  3  3\n"
"       13.5711021582   0.1528118547   0.0000000000 0.0  -0.1055093745   0.0000000000 0.0\n"
"        3.9754062896  -0.0499228626   0.0000000000 0.0  -0.3161557844   0.0000000000 0.0\n"
"        1.2121681091  -0.7116163527   0.0000000000 1.0  -0.4784388183   0.0000000000 1.0\n"
"        0.3268420958  -0.3647465749   1.0000000000 0.0  -0.3648062165   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        9.21600 1.0\n"
"  3  2  2  1  1\n"
"        2.30400 1.0\n"
"  3  2  2  1  1\n"
"        0.57600 1.0\n"
"  4  3  3  1  1\n"
"        2.50000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.13000 1.0 1.0\n"
"#","\n"
"Na TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  6  5  5\n"
"       24.4106415968  -0.0437913152   0.0091786765   0.0000000000 0.0 0.0  0.0412394777   0.0000000000   0.0000000000 0.0 0.0\n"
"        9.9296107008  -0.2028236387   0.0363180981   0.0000000000 0.0 0.0  0.1340487332   0.0000000000   0.0000000000 0.0 0.0\n"
"        3.6565524838   0.2429179955  -0.0394753287   0.0000000000 0.0 0.0  0.3537211057   0.0000000000   0.0000000000 0.0 1.0\n"
"        1.2695832879   0.6645538239  -0.2078727830   0.0000000000 0.0 1.0  0.4486246648   0.0000000000   0.0000000000 1.0 0.0\n"
"        0.4165172455   0.2885738064  -0.0972810085   0.0000000000 1.0 0.0  0.2617452725   1.0000000000   0.0000000000 0.0 0.0\n"
"        0.0447862002  -0.0015791358   1.0489993368   1.0000000000 0.0 0.0  0.0111532456   0.0000000000   1.0000000000 0.0 0.0\n"
"  3  2  2  1  1\n"
"        0.70000 1.0\n"
"  3  2  2  1  1\n"
"        0.17500 1.0\n"
"  3  2  2  1  1\n"
"        0.04375 1.0\n"
"  4  3  3  1  1\n"
"        0.15000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.00760 1.0 1.0\n"
"#","\n"
"Mg TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  2  0  1  6  5  5\n"
"       26.6684192078  -0.0843827177   0.0209137976   0.0000000000 0.0 0.0   0.0574690984   0.0000000000   0.0000000000 0.0 0.0\n"
"       10.6278914168  -0.1540012185   0.0328904567   0.0000000000 0.0 0.0   0.1834886260   0.0000000000   0.0000000000 0.0 0.0\n"
"        4.0257536169   0.3069950002  -0.0656366632   0.0000000000 0.0 0.0   0.3728084155   0.0000000000   0.0000000000 1.0 0.0\n"
"        1.4729826270   0.6341736453  -0.2789230951   0.0000000000 0.0 1.0   0.4211046995   0.0000000000   0.0000000000 0.0 1.0\n"
"        0.5301398986   0.2463411075  -0.0573174800   0.0000000000 1.0 0.0   0.1968486915   1.0000000000   0.0000000000 0.0 0.0\n"
"        0.0755213250  -0.0010479306   1.0561246927   1.0000000000 0.0 0.0   0.0067129918   0.0000000000   1.0000000000 0.0 0.0\n"
"  3  2  2  1  1\n"
"        0.70000 1.0\n"
"  3  2  2  1  1\n"
"        0.17500 1.0\n"
"  3  2  2  1  1\n"
"        0.04375 1.0\n"
"  4  3  3  1  1\n"
"        0.20000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.01460 1.0 1.0\n"
"#","\n"
"Al TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  3  0  1  4  3  3\n"
"        0.9040202750   0.2819459889   0.0000000000 0.0   0.0202901873   0.0000000000 0.0\n"
"        0.2716888904  -0.3565936829   0.0000000000 0.0  -0.2865844984   0.0000000000 0.0\n"
"        0.1038208154  -0.7126726101   0.0000000000 1.0  -0.4993035494   0.0000000000 1.0\n"
"        0.0361219503  -0.1315446458   1.0000000000 0.0  -0.3664719249   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        1.30000 1.0\n"
"  3  2  2  1  1\n"
"        0.32500 1.0\n"
"  3  2  2  1  1\n"
"        0.08125 1.0\n"
"  4  3  3  1  1\n"
"        0.25000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.03180 1.0 1.0\n"
"#","\n"
"Si TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  3  0  1  4  3  3\n"
"        1.1607523260   0.3347731757   0.0000000000 0.0   0.0434283150   0.0000000000 0.0\n"
"        0.4367408478  -0.3093572718   0.0000000000 0.0  -0.2863246710   0.0000000000 0.0\n"
"        0.1596639467  -0.7662114250   0.0000000000 1.0  -0.5309372647   0.0000000000 1.0\n"
"        0.0542076476  -0.1654691868   1.0000000000 0.0  -0.3502990755   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        1.80000 1.0\n"
"  3  2  2  1  1\n"
"        0.45000 1.0\n"
"  3  2  2  1  1\n"
"        0.11250 1.0\n"
"  4  3  3  1  1\n"
"        0.32000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.03310 1.0 1.0\n"
"#","\n"
"P TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  3  0  1  4  3  3\n"
"        1.4438479448   0.3786128496   0.0000000000 0.0   0.0768556482   0.0000000000 0.0\n"
"        0.6655205239  -0.2651542911   0.0000000000 0.0  -0.2851732159   0.0000000000 0.0\n"
"        0.2306279229  -0.8037940077   0.0000000000 1.0  -0.5540528446   0.0000000000 1.0\n"
"        0.0761045314  -0.2088239606   1.0000000000 0.0  -0.3549348725   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        2.20000 1.0\n"
"  3  2  2  1  1\n"
"        0.55000 1.0\n"
"  3  2  2  1  1\n"
"        0.13750 1.0\n"
"  4  3  3  1  1\n"
"        0.45000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.03480 1.0 1.0\n"
"#","\n"
"S TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  3  0  1  4  3  3\n"
"        1.7644177483   0.4114656852   0.0000000000 0.0   0.1207217819   0.0000000000 0.0\n"
"        0.9717752574  -0.2250656540   0.0000000000 0.0  -0.2949379210   0.0000000000 0.0\n"
"        0.3174012156  -0.8265244883   0.0000000000 1.0  -0.5702721181   0.0000000000 1.0\n"
"        0.1021260036  -0.2549919207   1.0000000000 0.0  -0.3673119254   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        2.60000 1.0\n"
"  3  2  2  1  1\n"
"        0.65000 1.0\n"
"  3  2  2  1  1\n"
"        0.16250 1.0\n"
"  4  3  3  1  1\n"
"        0.55000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.04050 1.0 1.0\n"
"#","\n"
"Cl TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  3  0  1  4  3  3\n"
"        2.1331287798   0.4248059842   0.0000000000 0.0   0.1653685236   0.0000000000 0.0\n"
"        1.3235903746  -0.1892927953   0.0000000000 0.0  -0.3177398987   0.0000000000 0.0\n"
"        0.4137876064  -0.8368579090   0.0000000000 1.0  -0.5798040681   0.0000000000 1.0\n"
"        0.1308257425  -0.2914138536   1.0000000000 0.0  -0.3759941633   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        3.00000 1.0\n"
"  3  2  2  1  1\n"
"        0.75000 1.0\n"
"  3  2  2  1  1\n"
"        0.18750 1.0\n"
"  4  3  3  1  1\n"
"        0.70000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.04830 1.0 1.0\n"
"#","\n"
"Ar TZVDD3DF3PD-GTH-BLYP\n"
"  6\n"
"  3  0  1  4  3  3\n"
"        2.5545614018   0.4141718172   0.0000000000 0.0   0.1900119384   0.0000000000 0.0\n"
"        1.6618834559  -0.1513194180   0.0000000000 0.0  -0.3348991938   0.0000000000 0.0\n"
"        0.5128881676  -0.8416116448   0.0000000000 1.0  -0.5845220689   0.0000000000 1.0\n"
"        0.1605817921  -0.3128170499   1.0000000000 0.0  -0.3771344877   1.0000000000 0.0\n"
"  3  2  2  1  1\n"
"        3.40000 1.0\n"
"  3  2  2  1  1\n"
"        0.85000 1.0\n"
"  3  2  2  1  1\n"
"        0.21250 1.0\n"
"  4  3  3  1  1\n"
"        0.85000 1.0\n"
"  2  0  1  1  1  1\n"
"        0.06000 1.0 1.0\n"
"#"};
