# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
#
# Generation mode: Incremental
# --------------------------------------------------------------------------

from azure.cli.core import AzCommandsLoader
from azure.cli.command_modules.apim._help import helps  # pylint: disable=unused-import


class ApimCommandsLoader(AzCommandsLoader):

    def __init__(self, cli_ctx=None):
        from azure.cli.core.commands import CliCommandType
        from azure.cli.core.profiles import ResourceType
        from azure.cli.command_modules.apim._client_factory import cf_apim

        apim_custom = CliCommandType(operations_tmpl='azure.cli.command_modules.apim.custom#{}', client_factory=cf_apim)

        super().__init__(cli_ctx=cli_ctx, custom_command_type=apim_custom,
                         resource_type=ResourceType.MGMT_APIMANAGEMENT)

    def load_command_table(self, args):
        from azure.cli.command_modules.apim.commands import load_command_table
        load_command_table(self, args)
        try:
            from .generated.commands import load_command_table as load_command_table_generated
            load_command_table_generated(self, args)
            from .manual.commands import load_command_table as load_command_table_manual
            load_command_table_manual(self, args)
        except ImportError:
            pass
        return self.command_table

    def load_arguments(self, command):
        from azure.cli.command_modules.apim._params import load_arguments
        load_arguments(self, command)
        try:
            from .generated._params import load_arguments as load_arguments_generated
            load_arguments_generated(self, command)
            from .manual._params import load_arguments as load_arguments_manual
            load_arguments_manual(self, command)
        except ImportError:
            pass


COMMAND_LOADER_CLS = ApimCommandsLoader
