// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

package request

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/eng/tools/generator/cmd/issue/link"
	"github.com/Azure/azure-sdk-for-go/eng/tools/generator/cmd/issue/query"
)

func handleSuccess(_ context.Context, _ *query.Client, reqIssue ReleaseRequestIssue, result link.ResolveResult) (*Request, error) {
	return &Request{
		RequestLink: reqIssue.IssueLink,
		TargetDate:  reqIssue.ReleaseDate,
		ReadmePath:  string(result.GetReadme()),
		Tag:         reqIssue.Tag,
		Track:       getTrack(reqIssue),
	}, nil
}

func handleDataPlane(_ context.Context, _ *query.Client, reqIssue ReleaseRequestIssue, result link.ResolveResult) (*Request, error) {
	log.Printf("[WARNING] Release request %s is requesting a release from a data-plane readme file `%s`, treat this as a track 2 request by default", reqIssue.IssueLink, result.GetReadme())
	return &Request{
		RequestLink: reqIssue.IssueLink,
		TargetDate:  reqIssue.ReleaseDate,
		ReadmePath:  string(result.GetReadme()),
		Tag:         reqIssue.Tag,
		Track:       Track2,
	}, nil
}

func handlePRNotMerged(_ context.Context, _ *query.Client, reqIssue ReleaseRequestIssue, result link.ResolveResult) (*Request, error) {
	log.Printf("[WARNING] Release request %s is requesting a release from a non-merged PR `%s`, discard this request", reqIssue.IssueLink, reqIssue.TargetLink)
	// TODO -- add comment and close this issue
	return nil, nil
}

func getTrack(issue ReleaseRequestIssue) Track {
	for _, l := range issue.Labels {
		if l != nil && l.GetName() == "Track2" {
			return Track2
		}
	}

	return Track1
}
