package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/keyvault/v7.1/keyvault"

// Action the action that will be executed.
type Action struct {
	// ActionType - The type of the action. Possible values include: 'EmailContacts', 'AutoRenew'
	ActionType ActionType `json:"action_type,omitempty"`
}

// AdministratorDetails details of the organization administrator of the certificate issuer.
type AdministratorDetails struct {
	// FirstName - First name.
	FirstName *string `json:"first_name,omitempty"`
	// LastName - Last name.
	LastName *string `json:"last_name,omitempty"`
	// EmailAddress - Email address.
	EmailAddress *string `json:"email,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// Attributes the object attributes managed by the KeyVault service.
type Attributes struct {
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for Attributes.
func (a Attributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Enabled != nil {
		objectMap["enabled"] = a.Enabled
	}
	if a.NotBefore != nil {
		objectMap["nbf"] = a.NotBefore
	}
	if a.Expires != nil {
		objectMap["exp"] = a.Expires
	}
	return json.Marshal(objectMap)
}

// BackupCertificateResult the backup certificate result, containing the backup blob.
type BackupCertificateResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The backup blob containing the backed up certificate. (a URL-encoded base64 string)
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupCertificateResult.
func (bcr BackupCertificateResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackupKeyResult the backup key result, containing the backup blob.
type BackupKeyResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The backup blob containing the backed up key. (a URL-encoded base64 string)
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupKeyResult.
func (bkr BackupKeyResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackupSecretResult the backup secret result, containing the backup blob.
type BackupSecretResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The backup blob containing the backed up secret. (a URL-encoded base64 string)
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupSecretResult.
func (bsr BackupSecretResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackupStorageResult the backup storage result, containing the backup blob.
type BackupStorageResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The backup blob containing the backed up storage account. (a URL-encoded base64 string)
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupStorageResult.
func (bsr BackupStorageResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CertificateAttributes the certificate management attributes.
type CertificateAttributes struct {
	// RecoverableDays - READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty"`
	// RecoveryLevel - READ-ONLY; Reflects the deletion recovery level currently in effect for certificates in the current vault. If it contains 'Purgeable', the certificate can be permanently deleted by a privileged user; otherwise, only the system can purge the certificate, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription', 'CustomizedRecoverablePurgeable', 'CustomizedRecoverable', 'CustomizedRecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateAttributes.
func (ca CertificateAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ca.Enabled != nil {
		objectMap["enabled"] = ca.Enabled
	}
	if ca.NotBefore != nil {
		objectMap["nbf"] = ca.NotBefore
	}
	if ca.Expires != nil {
		objectMap["exp"] = ca.Expires
	}
	return json.Marshal(objectMap)
}

// CertificateBundle a certificate bundle consists of a certificate (X509) plus its attributes.
type CertificateBundle struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The certificate id.
	ID *string `json:"id,omitempty"`
	// Kid - READ-ONLY; The key id.
	Kid *string `json:"kid,omitempty"`
	// Sid - READ-ONLY; The secret id.
	Sid *string `json:"sid,omitempty"`
	// X509Thumbprint - READ-ONLY; Thumbprint of the certificate. (a URL-encoded base64 string)
	X509Thumbprint *string `json:"x5t,omitempty"`
	// Policy - READ-ONLY; The management policy.
	Policy *CertificatePolicy `json:"policy,omitempty"`
	// Cer - CER contents of x509 certificate.
	Cer *[]byte `json:"cer,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateBundle.
func (cb CertificateBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cb.Cer != nil {
		objectMap["cer"] = cb.Cer
	}
	if cb.ContentType != nil {
		objectMap["contentType"] = cb.ContentType
	}
	if cb.Attributes != nil {
		objectMap["attributes"] = cb.Attributes
	}
	if cb.Tags != nil {
		objectMap["tags"] = cb.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateCreateParameters the certificate create parameters.
type CertificateCreateParameters struct {
	// CertificatePolicy - The management policy for the certificate.
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateCreateParameters.
func (ccp CertificateCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.CertificatePolicy != nil {
		objectMap["policy"] = ccp.CertificatePolicy
	}
	if ccp.CertificateAttributes != nil {
		objectMap["attributes"] = ccp.CertificateAttributes
	}
	if ccp.Tags != nil {
		objectMap["tags"] = ccp.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateImportParameters the certificate import parameters.
type CertificateImportParameters struct {
	// Base64EncodedCertificate - A PEM file or a base64-encoded PFX file.  PEM files need to contain the private key.
	Base64EncodedCertificate *string `json:"value,omitempty"`
	// Password - If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
	Password *string `json:"pwd,omitempty"`
	// CertificatePolicy - The management policy for the certificate.
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateImportParameters.
func (cip CertificateImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cip.Base64EncodedCertificate != nil {
		objectMap["value"] = cip.Base64EncodedCertificate
	}
	if cip.Password != nil {
		objectMap["pwd"] = cip.Password
	}
	if cip.CertificatePolicy != nil {
		objectMap["policy"] = cip.CertificatePolicy
	}
	if cip.CertificateAttributes != nil {
		objectMap["attributes"] = cip.CertificateAttributes
	}
	if cip.Tags != nil {
		objectMap["tags"] = cip.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateIssuerItem the certificate issuer item containing certificate issuer metadata.
type CertificateIssuerItem struct {
	// ID - Certificate Identifier.
	ID *string `json:"id,omitempty"`
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
}

// CertificateIssuerListResult the certificate issuer list result.
type CertificateIssuerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of certificate issuers in the key vault along with a link to the next page of certificate issuers.
	Value *[]CertificateIssuerItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of certificate issuers.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateIssuerListResult.
func (cilr CertificateIssuerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CertificateIssuerListResultIterator provides access to a complete listing of CertificateIssuerItem
// values.
type CertificateIssuerListResultIterator struct {
	i    int
	page CertificateIssuerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateIssuerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateIssuerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateIssuerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateIssuerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateIssuerListResultIterator) Response() CertificateIssuerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateIssuerListResultIterator) Value() CertificateIssuerItem {
	if !iter.page.NotDone() {
		return CertificateIssuerItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateIssuerListResultIterator type.
func NewCertificateIssuerListResultIterator(page CertificateIssuerListResultPage) CertificateIssuerListResultIterator {
	return CertificateIssuerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cilr CertificateIssuerListResult) IsEmpty() bool {
	return cilr.Value == nil || len(*cilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cilr CertificateIssuerListResult) hasNextLink() bool {
	return cilr.NextLink != nil && len(*cilr.NextLink) != 0
}

// certificateIssuerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cilr CertificateIssuerListResult) certificateIssuerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cilr.NextLink)))
}

// CertificateIssuerListResultPage contains a page of CertificateIssuerItem values.
type CertificateIssuerListResultPage struct {
	fn   func(context.Context, CertificateIssuerListResult) (CertificateIssuerListResult, error)
	cilr CertificateIssuerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateIssuerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateIssuerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cilr)
		if err != nil {
			return err
		}
		page.cilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateIssuerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateIssuerListResultPage) NotDone() bool {
	return !page.cilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateIssuerListResultPage) Response() CertificateIssuerListResult {
	return page.cilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateIssuerListResultPage) Values() []CertificateIssuerItem {
	if page.cilr.IsEmpty() {
		return nil
	}
	return *page.cilr.Value
}

// Creates a new instance of the CertificateIssuerListResultPage type.
func NewCertificateIssuerListResultPage(cur CertificateIssuerListResult, getNextPage func(context.Context, CertificateIssuerListResult) (CertificateIssuerListResult, error)) CertificateIssuerListResultPage {
	return CertificateIssuerListResultPage{
		fn:   getNextPage,
		cilr: cur,
	}
}

// CertificateIssuerSetParameters the certificate issuer set parameters.
type CertificateIssuerSetParameters struct {
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// CertificateIssuerUpdateParameters the certificate issuer update parameters.
type CertificateIssuerUpdateParameters struct {
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// CertificateItem the certificate item containing certificate metadata.
type CertificateItem struct {
	// ID - Certificate identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The certificate management attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// X509Thumbprint - Thumbprint of the certificate. (a URL-encoded base64 string)
	X509Thumbprint *string `json:"x5t,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateItem.
func (ci CertificateItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.ID != nil {
		objectMap["id"] = ci.ID
	}
	if ci.Attributes != nil {
		objectMap["attributes"] = ci.Attributes
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	if ci.X509Thumbprint != nil {
		objectMap["x5t"] = ci.X509Thumbprint
	}
	return json.Marshal(objectMap)
}

// CertificateListResult the certificate list result.
type CertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of certificates in the key vault along with a link to the next page of certificates.
	Value *[]CertificateItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of certificates.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateListResult.
func (clr CertificateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CertificateListResultIterator provides access to a complete listing of CertificateItem values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() CertificateItem {
	if !iter.page.NotDone() {
		return CertificateItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateListResultIterator type.
func NewCertificateListResultIterator(page CertificateListResultPage) CertificateListResultIterator {
	return CertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CertificateListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CertificateListResultPage contains a page of CertificateItem values.
type CertificateListResultPage struct {
	fn  func(context.Context, CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []CertificateItem {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CertificateListResultPage type.
func NewCertificateListResultPage(cur CertificateListResult, getNextPage func(context.Context, CertificateListResult) (CertificateListResult, error)) CertificateListResultPage {
	return CertificateListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// CertificateMergeParameters the certificate merge parameters
type CertificateMergeParameters struct {
	// X509Certificates - The certificate or the certificate chain to merge.
	X509Certificates *[][]byte `json:"x5c,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateMergeParameters.
func (cmp CertificateMergeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmp.X509Certificates != nil {
		objectMap["x5c"] = cmp.X509Certificates
	}
	if cmp.CertificateAttributes != nil {
		objectMap["attributes"] = cmp.CertificateAttributes
	}
	if cmp.Tags != nil {
		objectMap["tags"] = cmp.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateOperation a certificate operation is returned in case of asynchronous requests.
type CertificateOperation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The certificate id.
	ID *string `json:"id,omitempty"`
	// IssuerParameters - Parameters for the issuer of the X509 component of a certificate.
	IssuerParameters *IssuerParameters `json:"issuer,omitempty"`
	// Csr - The certificate signing request (CSR) that is being used in the certificate operation.
	Csr *[]byte `json:"csr,omitempty"`
	// CancellationRequested - Indicates if cancellation was requested on the certificate operation.
	CancellationRequested *bool `json:"cancellation_requested,omitempty"`
	// Status - Status of the certificate operation.
	Status *string `json:"status,omitempty"`
	// StatusDetails - The status details of the certificate operation.
	StatusDetails *string `json:"status_details,omitempty"`
	// Error - Error encountered, if any, during the certificate operation.
	Error *Error `json:"error,omitempty"`
	// Target - Location which contains the result of the certificate operation.
	Target *string `json:"target,omitempty"`
	// RequestID - Identifier for the certificate operation.
	RequestID *string `json:"request_id,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateOperation.
func (co CertificateOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if co.IssuerParameters != nil {
		objectMap["issuer"] = co.IssuerParameters
	}
	if co.Csr != nil {
		objectMap["csr"] = co.Csr
	}
	if co.CancellationRequested != nil {
		objectMap["cancellation_requested"] = co.CancellationRequested
	}
	if co.Status != nil {
		objectMap["status"] = co.Status
	}
	if co.StatusDetails != nil {
		objectMap["status_details"] = co.StatusDetails
	}
	if co.Error != nil {
		objectMap["error"] = co.Error
	}
	if co.Target != nil {
		objectMap["target"] = co.Target
	}
	if co.RequestID != nil {
		objectMap["request_id"] = co.RequestID
	}
	return json.Marshal(objectMap)
}

// CertificateOperationUpdateParameter the certificate operation update parameters.
type CertificateOperationUpdateParameter struct {
	// CancellationRequested - Indicates if cancellation was requested on the certificate operation.
	CancellationRequested *bool `json:"cancellation_requested,omitempty"`
}

// CertificatePolicy management policy for a certificate.
type CertificatePolicy struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The certificate id.
	ID *string `json:"id,omitempty"`
	// KeyProperties - Properties of the key backing a certificate.
	KeyProperties *KeyProperties `json:"key_props,omitempty"`
	// SecretProperties - Properties of the secret backing a certificate.
	SecretProperties *SecretProperties `json:"secret_props,omitempty"`
	// X509CertificateProperties - Properties of the X509 component of a certificate.
	X509CertificateProperties *X509CertificateProperties `json:"x509_props,omitempty"`
	// LifetimeActions - Actions that will be performed by Key Vault over the lifetime of a certificate.
	LifetimeActions *[]LifetimeAction `json:"lifetime_actions,omitempty"`
	// IssuerParameters - Parameters for the issuer of the X509 component of a certificate.
	IssuerParameters *IssuerParameters `json:"issuer,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificatePolicy.
func (cp CertificatePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.KeyProperties != nil {
		objectMap["key_props"] = cp.KeyProperties
	}
	if cp.SecretProperties != nil {
		objectMap["secret_props"] = cp.SecretProperties
	}
	if cp.X509CertificateProperties != nil {
		objectMap["x509_props"] = cp.X509CertificateProperties
	}
	if cp.LifetimeActions != nil {
		objectMap["lifetime_actions"] = cp.LifetimeActions
	}
	if cp.IssuerParameters != nil {
		objectMap["issuer"] = cp.IssuerParameters
	}
	if cp.Attributes != nil {
		objectMap["attributes"] = cp.Attributes
	}
	return json.Marshal(objectMap)
}

// CertificateRestoreParameters the certificate restore parameters.
type CertificateRestoreParameters struct {
	// CertificateBundleBackup - The backup blob associated with a certificate bundle. (a URL-encoded base64 string)
	CertificateBundleBackup *string `json:"value,omitempty"`
}

// CertificateUpdateParameters the certificate update parameters.
type CertificateUpdateParameters struct {
	// CertificatePolicy - The management policy for the certificate.
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateUpdateParameters.
func (cup CertificateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.CertificatePolicy != nil {
		objectMap["policy"] = cup.CertificatePolicy
	}
	if cup.CertificateAttributes != nil {
		objectMap["attributes"] = cup.CertificateAttributes
	}
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	return json.Marshal(objectMap)
}

// Contact the contact information for the vault certificates.
type Contact struct {
	// EmailAddress - Email address.
	EmailAddress *string `json:"email,omitempty"`
	// Name - Name.
	Name *string `json:"name,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// Contacts the contacts for the vault certificates.
type Contacts struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Identifier for the contacts collection.
	ID *string `json:"id,omitempty"`
	// ContactList - The contact list for the vault certificates.
	ContactList *[]Contact `json:"contacts,omitempty"`
}

// MarshalJSON is the custom marshaler for Contacts.
func (c Contacts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ContactList != nil {
		objectMap["contacts"] = c.ContactList
	}
	return json.Marshal(objectMap)
}

// DeletedCertificateBundle a Deleted Certificate consisting of its previous id, attributes and its tags,
// as well as information on when it will be purged.
type DeletedCertificateBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted certificate.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the certificate is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the certificate was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - READ-ONLY; The certificate id.
	ID *string `json:"id,omitempty"`
	// Kid - READ-ONLY; The key id.
	Kid *string `json:"kid,omitempty"`
	// Sid - READ-ONLY; The secret id.
	Sid *string `json:"sid,omitempty"`
	// X509Thumbprint - READ-ONLY; Thumbprint of the certificate. (a URL-encoded base64 string)
	X509Thumbprint *string `json:"x5t,omitempty"`
	// Policy - READ-ONLY; The management policy.
	Policy *CertificatePolicy `json:"policy,omitempty"`
	// Cer - CER contents of x509 certificate.
	Cer *[]byte `json:"cer,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedCertificateBundle.
func (dcb DeletedCertificateBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcb.RecoveryID != nil {
		objectMap["recoveryId"] = dcb.RecoveryID
	}
	if dcb.Cer != nil {
		objectMap["cer"] = dcb.Cer
	}
	if dcb.ContentType != nil {
		objectMap["contentType"] = dcb.ContentType
	}
	if dcb.Attributes != nil {
		objectMap["attributes"] = dcb.Attributes
	}
	if dcb.Tags != nil {
		objectMap["tags"] = dcb.Tags
	}
	return json.Marshal(objectMap)
}

// DeletedCertificateItem the deleted certificate item containing metadata about the deleted certificate.
type DeletedCertificateItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted certificate.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the certificate is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the certificate was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - Certificate identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The certificate management attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// X509Thumbprint - Thumbprint of the certificate. (a URL-encoded base64 string)
	X509Thumbprint *string `json:"x5t,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedCertificateItem.
func (dci DeletedCertificateItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dci.RecoveryID != nil {
		objectMap["recoveryId"] = dci.RecoveryID
	}
	if dci.ID != nil {
		objectMap["id"] = dci.ID
	}
	if dci.Attributes != nil {
		objectMap["attributes"] = dci.Attributes
	}
	if dci.Tags != nil {
		objectMap["tags"] = dci.Tags
	}
	if dci.X509Thumbprint != nil {
		objectMap["x5t"] = dci.X509Thumbprint
	}
	return json.Marshal(objectMap)
}

// DeletedCertificateListResult a list of certificates that have been deleted in this vault.
type DeletedCertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of deleted certificates in the vault along with a link to the next page of deleted certificates
	Value *[]DeletedCertificateItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of deleted certificates.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedCertificateListResult.
func (dclr DeletedCertificateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedCertificateListResultIterator provides access to a complete listing of DeletedCertificateItem
// values.
type DeletedCertificateListResultIterator struct {
	i    int
	page DeletedCertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedCertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedCertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedCertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedCertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedCertificateListResultIterator) Response() DeletedCertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedCertificateListResultIterator) Value() DeletedCertificateItem {
	if !iter.page.NotDone() {
		return DeletedCertificateItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedCertificateListResultIterator type.
func NewDeletedCertificateListResultIterator(page DeletedCertificateListResultPage) DeletedCertificateListResultIterator {
	return DeletedCertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dclr DeletedCertificateListResult) IsEmpty() bool {
	return dclr.Value == nil || len(*dclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dclr DeletedCertificateListResult) hasNextLink() bool {
	return dclr.NextLink != nil && len(*dclr.NextLink) != 0
}

// deletedCertificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dclr DeletedCertificateListResult) deletedCertificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dclr.NextLink)))
}

// DeletedCertificateListResultPage contains a page of DeletedCertificateItem values.
type DeletedCertificateListResultPage struct {
	fn   func(context.Context, DeletedCertificateListResult) (DeletedCertificateListResult, error)
	dclr DeletedCertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedCertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedCertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dclr)
		if err != nil {
			return err
		}
		page.dclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedCertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedCertificateListResultPage) NotDone() bool {
	return !page.dclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedCertificateListResultPage) Response() DeletedCertificateListResult {
	return page.dclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedCertificateListResultPage) Values() []DeletedCertificateItem {
	if page.dclr.IsEmpty() {
		return nil
	}
	return *page.dclr.Value
}

// Creates a new instance of the DeletedCertificateListResultPage type.
func NewDeletedCertificateListResultPage(cur DeletedCertificateListResult, getNextPage func(context.Context, DeletedCertificateListResult) (DeletedCertificateListResult, error)) DeletedCertificateListResultPage {
	return DeletedCertificateListResultPage{
		fn:   getNextPage,
		dclr: cur,
	}
}

// DeletedKeyBundle a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info
type DeletedKeyBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the key was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// Key - The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedKeyBundle.
func (dkb DeletedKeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dkb.RecoveryID != nil {
		objectMap["recoveryId"] = dkb.RecoveryID
	}
	if dkb.Key != nil {
		objectMap["key"] = dkb.Key
	}
	if dkb.Attributes != nil {
		objectMap["attributes"] = dkb.Attributes
	}
	if dkb.Tags != nil {
		objectMap["tags"] = dkb.Tags
	}
	return json.Marshal(objectMap)
}

// DeletedKeyItem the deleted key item containing the deleted key metadata and information about deletion.
type DeletedKeyItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the key was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// Kid - Key identifier.
	Kid *string `json:"kid,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedKeyItem.
func (dki DeletedKeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dki.RecoveryID != nil {
		objectMap["recoveryId"] = dki.RecoveryID
	}
	if dki.Kid != nil {
		objectMap["kid"] = dki.Kid
	}
	if dki.Attributes != nil {
		objectMap["attributes"] = dki.Attributes
	}
	if dki.Tags != nil {
		objectMap["tags"] = dki.Tags
	}
	return json.Marshal(objectMap)
}

// DeletedKeyListResult a list of keys that have been deleted in this vault.
type DeletedKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of deleted keys in the vault along with a link to the next page of deleted keys
	Value *[]DeletedKeyItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of deleted keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedKeyListResult.
func (dklr DeletedKeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedKeyListResultIterator provides access to a complete listing of DeletedKeyItem values.
type DeletedKeyListResultIterator struct {
	i    int
	page DeletedKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedKeyListResultIterator) Response() DeletedKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedKeyListResultIterator) Value() DeletedKeyItem {
	if !iter.page.NotDone() {
		return DeletedKeyItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedKeyListResultIterator type.
func NewDeletedKeyListResultIterator(page DeletedKeyListResultPage) DeletedKeyListResultIterator {
	return DeletedKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dklr DeletedKeyListResult) IsEmpty() bool {
	return dklr.Value == nil || len(*dklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dklr DeletedKeyListResult) hasNextLink() bool {
	return dklr.NextLink != nil && len(*dklr.NextLink) != 0
}

// deletedKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dklr DeletedKeyListResult) deletedKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dklr.NextLink)))
}

// DeletedKeyListResultPage contains a page of DeletedKeyItem values.
type DeletedKeyListResultPage struct {
	fn   func(context.Context, DeletedKeyListResult) (DeletedKeyListResult, error)
	dklr DeletedKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dklr)
		if err != nil {
			return err
		}
		page.dklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedKeyListResultPage) NotDone() bool {
	return !page.dklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedKeyListResultPage) Response() DeletedKeyListResult {
	return page.dklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedKeyListResultPage) Values() []DeletedKeyItem {
	if page.dklr.IsEmpty() {
		return nil
	}
	return *page.dklr.Value
}

// Creates a new instance of the DeletedKeyListResultPage type.
func NewDeletedKeyListResultPage(cur DeletedKeyListResult, getNextPage func(context.Context, DeletedKeyListResult) (DeletedKeyListResult, error)) DeletedKeyListResultPage {
	return DeletedKeyListResultPage{
		fn:   getNextPage,
		dklr: cur,
	}
}

// DeletedSasDefinitionBundle a deleted SAS definition bundle consisting of its previous id, attributes and
// its tags, as well as information on when it will be purged.
type DeletedSasDefinitionBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted SAS definition.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the SAS definition is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the SAS definition was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - READ-ONLY; The SAS definition id.
	ID *string `json:"id,omitempty"`
	// SecretID - READ-ONLY; Storage account SAS definition secret id.
	SecretID *string `json:"sid,omitempty"`
	// TemplateURI - READ-ONLY; The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
	TemplateURI *string `json:"templateUri,omitempty"`
	// SasType - READ-ONLY; The type of SAS token the SAS definition will create. Possible values include: 'Account', 'Service'
	SasType SasTokenType `json:"sasType,omitempty"`
	// ValidityPeriod - READ-ONLY; The validity period of SAS tokens created according to the SAS definition.
	ValidityPeriod *string `json:"validityPeriod,omitempty"`
	// Attributes - READ-ONLY; The SAS definition attributes.
	Attributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedSasDefinitionBundle.
func (dsdb DeletedSasDefinitionBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsdb.RecoveryID != nil {
		objectMap["recoveryId"] = dsdb.RecoveryID
	}
	return json.Marshal(objectMap)
}

// DeletedSasDefinitionItem the deleted SAS definition item containing metadata about the deleted SAS
// definition.
type DeletedSasDefinitionItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted SAS definition.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the SAS definition is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the SAS definition was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - READ-ONLY; The storage SAS identifier.
	ID *string `json:"id,omitempty"`
	// SecretID - READ-ONLY; The storage account SAS definition secret id.
	SecretID *string `json:"sid,omitempty"`
	// Attributes - READ-ONLY; The SAS definition management attributes.
	Attributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedSasDefinitionItem.
func (dsdi DeletedSasDefinitionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsdi.RecoveryID != nil {
		objectMap["recoveryId"] = dsdi.RecoveryID
	}
	return json.Marshal(objectMap)
}

// DeletedSasDefinitionListResult the deleted SAS definition list result
type DeletedSasDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of the deleted SAS definitions in the vault along with a link to the next page of deleted sas definitions
	Value *[]DeletedSasDefinitionItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of deleted SAS definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSasDefinitionListResult.
func (dsdlr DeletedSasDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedSasDefinitionListResultIterator provides access to a complete listing of DeletedSasDefinitionItem
// values.
type DeletedSasDefinitionListResultIterator struct {
	i    int
	page DeletedSasDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedSasDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedSasDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedSasDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedSasDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedSasDefinitionListResultIterator) Response() DeletedSasDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedSasDefinitionListResultIterator) Value() DeletedSasDefinitionItem {
	if !iter.page.NotDone() {
		return DeletedSasDefinitionItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedSasDefinitionListResultIterator type.
func NewDeletedSasDefinitionListResultIterator(page DeletedSasDefinitionListResultPage) DeletedSasDefinitionListResultIterator {
	return DeletedSasDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsdlr DeletedSasDefinitionListResult) IsEmpty() bool {
	return dsdlr.Value == nil || len(*dsdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsdlr DeletedSasDefinitionListResult) hasNextLink() bool {
	return dsdlr.NextLink != nil && len(*dsdlr.NextLink) != 0
}

// deletedSasDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsdlr DeletedSasDefinitionListResult) deletedSasDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dsdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsdlr.NextLink)))
}

// DeletedSasDefinitionListResultPage contains a page of DeletedSasDefinitionItem values.
type DeletedSasDefinitionListResultPage struct {
	fn    func(context.Context, DeletedSasDefinitionListResult) (DeletedSasDefinitionListResult, error)
	dsdlr DeletedSasDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedSasDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedSasDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsdlr)
		if err != nil {
			return err
		}
		page.dsdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedSasDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedSasDefinitionListResultPage) NotDone() bool {
	return !page.dsdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedSasDefinitionListResultPage) Response() DeletedSasDefinitionListResult {
	return page.dsdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedSasDefinitionListResultPage) Values() []DeletedSasDefinitionItem {
	if page.dsdlr.IsEmpty() {
		return nil
	}
	return *page.dsdlr.Value
}

// Creates a new instance of the DeletedSasDefinitionListResultPage type.
func NewDeletedSasDefinitionListResultPage(cur DeletedSasDefinitionListResult, getNextPage func(context.Context, DeletedSasDefinitionListResult) (DeletedSasDefinitionListResult, error)) DeletedSasDefinitionListResultPage {
	return DeletedSasDefinitionListResultPage{
		fn:    getNextPage,
		dsdlr: cur,
	}
}

// DeletedSecretBundle a Deleted Secret consisting of its previous id, attributes and its tags, as well as
// information on when it will be purged.
type DeletedSecretBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the secret was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// Value - The secret value.
	Value *string `json:"value,omitempty"`
	// ID - The secret id.
	ID *string `json:"id,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Kid - READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate.
	Kid *string `json:"kid,omitempty"`
	// Managed - READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSecretBundle.
func (dsb DeletedSecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsb.RecoveryID != nil {
		objectMap["recoveryId"] = dsb.RecoveryID
	}
	if dsb.Value != nil {
		objectMap["value"] = dsb.Value
	}
	if dsb.ID != nil {
		objectMap["id"] = dsb.ID
	}
	if dsb.ContentType != nil {
		objectMap["contentType"] = dsb.ContentType
	}
	if dsb.Attributes != nil {
		objectMap["attributes"] = dsb.Attributes
	}
	if dsb.Tags != nil {
		objectMap["tags"] = dsb.Tags
	}
	return json.Marshal(objectMap)
}

// DeletedSecretItem the deleted secret item containing metadata about the deleted secret.
type DeletedSecretItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the secret was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - Secret identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// Managed - READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSecretItem.
func (dsi DeletedSecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsi.RecoveryID != nil {
		objectMap["recoveryId"] = dsi.RecoveryID
	}
	if dsi.ID != nil {
		objectMap["id"] = dsi.ID
	}
	if dsi.Attributes != nil {
		objectMap["attributes"] = dsi.Attributes
	}
	if dsi.Tags != nil {
		objectMap["tags"] = dsi.Tags
	}
	if dsi.ContentType != nil {
		objectMap["contentType"] = dsi.ContentType
	}
	return json.Marshal(objectMap)
}

// DeletedSecretListResult the deleted secret list result
type DeletedSecretListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of the deleted secrets in the vault along with a link to the next page of deleted secrets
	Value *[]DeletedSecretItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of deleted secrets.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSecretListResult.
func (dslr DeletedSecretListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedSecretListResultIterator provides access to a complete listing of DeletedSecretItem values.
type DeletedSecretListResultIterator struct {
	i    int
	page DeletedSecretListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedSecretListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedSecretListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedSecretListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedSecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedSecretListResultIterator) Response() DeletedSecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedSecretListResultIterator) Value() DeletedSecretItem {
	if !iter.page.NotDone() {
		return DeletedSecretItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedSecretListResultIterator type.
func NewDeletedSecretListResultIterator(page DeletedSecretListResultPage) DeletedSecretListResultIterator {
	return DeletedSecretListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DeletedSecretListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dslr DeletedSecretListResult) hasNextLink() bool {
	return dslr.NextLink != nil && len(*dslr.NextLink) != 0
}

// deletedSecretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DeletedSecretListResult) deletedSecretListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DeletedSecretListResultPage contains a page of DeletedSecretItem values.
type DeletedSecretListResultPage struct {
	fn   func(context.Context, DeletedSecretListResult) (DeletedSecretListResult, error)
	dslr DeletedSecretListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedSecretListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedSecretListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dslr)
		if err != nil {
			return err
		}
		page.dslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedSecretListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedSecretListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedSecretListResultPage) Response() DeletedSecretListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedSecretListResultPage) Values() []DeletedSecretItem {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Creates a new instance of the DeletedSecretListResultPage type.
func NewDeletedSecretListResultPage(cur DeletedSecretListResult, getNextPage func(context.Context, DeletedSecretListResult) (DeletedSecretListResult, error)) DeletedSecretListResultPage {
	return DeletedSecretListResultPage{
		fn:   getNextPage,
		dslr: cur,
	}
}

// DeletedStorageAccountItem the deleted storage account item containing metadata about the deleted storage
// account.
type DeletedStorageAccountItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted storage account.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the storage account is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the storage account was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - READ-ONLY; Storage identifier.
	ID *string `json:"id,omitempty"`
	// ResourceID - READ-ONLY; Storage account resource Id.
	ResourceID *string `json:"resourceId,omitempty"`
	// Attributes - READ-ONLY; The storage account management attributes.
	Attributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedStorageAccountItem.
func (dsai DeletedStorageAccountItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsai.RecoveryID != nil {
		objectMap["recoveryId"] = dsai.RecoveryID
	}
	return json.Marshal(objectMap)
}

// DeletedStorageBundle a deleted storage account bundle consisting of its previous id, attributes and its
// tags, as well as information on when it will be purged.
type DeletedStorageBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted storage account.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The time when the storage account is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - READ-ONLY; The time when the storage account was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - READ-ONLY; The storage account id.
	ID *string `json:"id,omitempty"`
	// ResourceID - READ-ONLY; The storage account resource id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ActiveKeyName - READ-ONLY; The current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - READ-ONLY; whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - READ-ONLY; The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// Attributes - READ-ONLY; The storage account attributes.
	Attributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedStorageBundle.
func (dsb DeletedStorageBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsb.RecoveryID != nil {
		objectMap["recoveryId"] = dsb.RecoveryID
	}
	return json.Marshal(objectMap)
}

// DeletedStorageListResult the deleted storage account list result
type DeletedStorageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of the deleted storage accounts in the vault along with a link to the next page of deleted storage accounts
	Value *[]DeletedStorageAccountItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of deleted storage accounts.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedStorageListResult.
func (dslr DeletedStorageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedStorageListResultIterator provides access to a complete listing of DeletedStorageAccountItem
// values.
type DeletedStorageListResultIterator struct {
	i    int
	page DeletedStorageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedStorageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedStorageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedStorageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedStorageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedStorageListResultIterator) Response() DeletedStorageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedStorageListResultIterator) Value() DeletedStorageAccountItem {
	if !iter.page.NotDone() {
		return DeletedStorageAccountItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedStorageListResultIterator type.
func NewDeletedStorageListResultIterator(page DeletedStorageListResultPage) DeletedStorageListResultIterator {
	return DeletedStorageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DeletedStorageListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dslr DeletedStorageListResult) hasNextLink() bool {
	return dslr.NextLink != nil && len(*dslr.NextLink) != 0
}

// deletedStorageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DeletedStorageListResult) deletedStorageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DeletedStorageListResultPage contains a page of DeletedStorageAccountItem values.
type DeletedStorageListResultPage struct {
	fn   func(context.Context, DeletedStorageListResult) (DeletedStorageListResult, error)
	dslr DeletedStorageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedStorageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedStorageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dslr)
		if err != nil {
			return err
		}
		page.dslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedStorageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedStorageListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedStorageListResultPage) Response() DeletedStorageListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedStorageListResultPage) Values() []DeletedStorageAccountItem {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Creates a new instance of the DeletedStorageListResultPage type.
func NewDeletedStorageListResultPage(cur DeletedStorageListResult, getNextPage func(context.Context, DeletedStorageListResult) (DeletedStorageListResult, error)) DeletedStorageListResultPage {
	return DeletedStorageListResultPage{
		fn:   getNextPage,
		dslr: cur,
	}
}

// Error the key vault server error.
type Error struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// InnerError - READ-ONLY
	InnerError *Error `json:"innererror,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorType the key vault error exception.
type ErrorType struct {
	// Error - READ-ONLY
	Error *Error `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorType.
func (et ErrorType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IssuerAttributes the attributes of an issuer managed by the Key Vault service.
type IssuerAttributes struct {
	// Enabled - Determines whether the issuer is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for IssuerAttributes.
func (ia IssuerAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ia.Enabled != nil {
		objectMap["enabled"] = ia.Enabled
	}
	return json.Marshal(objectMap)
}

// IssuerBundle the issuer for Key Vault certificate.
type IssuerBundle struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Identifier for the issuer object.
	ID *string `json:"id,omitempty"`
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// MarshalJSON is the custom marshaler for IssuerBundle.
func (ib IssuerBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ib.Provider != nil {
		objectMap["provider"] = ib.Provider
	}
	if ib.Credentials != nil {
		objectMap["credentials"] = ib.Credentials
	}
	if ib.OrganizationDetails != nil {
		objectMap["org_details"] = ib.OrganizationDetails
	}
	if ib.Attributes != nil {
		objectMap["attributes"] = ib.Attributes
	}
	return json.Marshal(objectMap)
}

// IssuerCredentials the credentials to be used for the certificate issuer.
type IssuerCredentials struct {
	// AccountID - The user name/account name/account id.
	AccountID *string `json:"account_id,omitempty"`
	// Password - The password/secret/account key.
	Password *string `json:"pwd,omitempty"`
}

// IssuerParameters parameters for the issuer of the X509 component of a certificate.
type IssuerParameters struct {
	// Name - Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'.
	Name *string `json:"name,omitempty"`
	// CertificateType - Certificate type as supported by the provider (optional); for example 'OV-SSL', 'EV-SSL'
	CertificateType *string `json:"cty,omitempty"`
	// CertificateTransparency - Indicates if the certificates generated under this policy should be published to certificate transparency logs.
	CertificateTransparency *bool `json:"cert_transparency,omitempty"`
}

// JSONWebKey as of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
type JSONWebKey struct {
	// Kid - Key identifier.
	Kid *string `json:"kid,omitempty"`
	// Kty - JsonWebKey Key Type (kty), as defined in https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40. Possible values include: 'EC', 'ECHSM', 'RSA', 'RSAHSM', 'Oct'
	Kty    JSONWebKeyType `json:"kty,omitempty"`
	KeyOps *[]string      `json:"key_ops,omitempty"`
	// N - RSA modulus. (a URL-encoded base64 string)
	N *string `json:"n,omitempty"`
	// E - RSA public exponent. (a URL-encoded base64 string)
	E *string `json:"e,omitempty"`
	// D - RSA private exponent, or the D component of an EC private key. (a URL-encoded base64 string)
	D *string `json:"d,omitempty"`
	// DP - RSA private key parameter. (a URL-encoded base64 string)
	DP *string `json:"dp,omitempty"`
	// DQ - RSA private key parameter. (a URL-encoded base64 string)
	DQ *string `json:"dq,omitempty"`
	// QI - RSA private key parameter. (a URL-encoded base64 string)
	QI *string `json:"qi,omitempty"`
	// P - RSA secret prime. (a URL-encoded base64 string)
	P *string `json:"p,omitempty"`
	// Q - RSA secret prime, with p < q. (a URL-encoded base64 string)
	Q *string `json:"q,omitempty"`
	// K - Symmetric key. (a URL-encoded base64 string)
	K *string `json:"k,omitempty"`
	// T - HSM Token, used with 'Bring Your Own Key'. (a URL-encoded base64 string)
	T *string `json:"key_hsm,omitempty"`
	// Crv - Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P256', 'P384', 'P521', 'P256K'
	Crv JSONWebKeyCurveName `json:"crv,omitempty"`
	// X - X component of an EC public key. (a URL-encoded base64 string)
	X *string `json:"x,omitempty"`
	// Y - Y component of an EC public key. (a URL-encoded base64 string)
	Y *string `json:"y,omitempty"`
}

// KeyAttributes the attributes of a key managed by the key vault service.
type KeyAttributes struct {
	// RecoverableDays - READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty"`
	// RecoveryLevel - READ-ONLY; Reflects the deletion recovery level currently in effect for keys in the current vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged user; otherwise, only the system can purge the key, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription', 'CustomizedRecoverablePurgeable', 'CustomizedRecoverable', 'CustomizedRecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyAttributes.
func (ka KeyAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ka.Enabled != nil {
		objectMap["enabled"] = ka.Enabled
	}
	if ka.NotBefore != nil {
		objectMap["nbf"] = ka.NotBefore
	}
	if ka.Expires != nil {
		objectMap["exp"] = ka.Expires
	}
	return json.Marshal(objectMap)
}

// KeyBundle a KeyBundle consisting of a WebKey plus its attributes.
type KeyBundle struct {
	autorest.Response `json:"-"`
	// Key - The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyBundle.
func (kb KeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kb.Key != nil {
		objectMap["key"] = kb.Key
	}
	if kb.Attributes != nil {
		objectMap["attributes"] = kb.Attributes
	}
	if kb.Tags != nil {
		objectMap["tags"] = kb.Tags
	}
	return json.Marshal(objectMap)
}

// KeyCreateParameters the key create parameters.
type KeyCreateParameters struct {
	// Kty - The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'ECHSM', 'RSA', 'RSAHSM', 'Oct'
	Kty JSONWebKeyType `json:"kty,omitempty"`
	// KeySize - The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize       *int32                 `json:"key_size,omitempty"`
	KeyOps        *[]JSONWebKeyOperation `json:"key_ops,omitempty"`
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Curve - Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P256', 'P384', 'P521', 'P256K'
	Curve JSONWebKeyCurveName `json:"crv,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyCreateParameters.
func (kcp KeyCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kcp.Kty != "" {
		objectMap["kty"] = kcp.Kty
	}
	if kcp.KeySize != nil {
		objectMap["key_size"] = kcp.KeySize
	}
	if kcp.KeyOps != nil {
		objectMap["key_ops"] = kcp.KeyOps
	}
	if kcp.KeyAttributes != nil {
		objectMap["attributes"] = kcp.KeyAttributes
	}
	if kcp.Tags != nil {
		objectMap["tags"] = kcp.Tags
	}
	if kcp.Curve != "" {
		objectMap["crv"] = kcp.Curve
	}
	return json.Marshal(objectMap)
}

// KeyImportParameters the key import parameters.
type KeyImportParameters struct {
	// Hsm - Whether to import as a hardware key (HSM) or software key.
	Hsm *bool `json:"Hsm,omitempty"`
	// Key - The Json web key
	Key *JSONWebKey `json:"key,omitempty"`
	// KeyAttributes - The key management attributes.
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyImportParameters.
func (kip KeyImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kip.Hsm != nil {
		objectMap["Hsm"] = kip.Hsm
	}
	if kip.Key != nil {
		objectMap["key"] = kip.Key
	}
	if kip.KeyAttributes != nil {
		objectMap["attributes"] = kip.KeyAttributes
	}
	if kip.Tags != nil {
		objectMap["tags"] = kip.Tags
	}
	return json.Marshal(objectMap)
}

// KeyItem the key item containing key metadata.
type KeyItem struct {
	// Kid - Key identifier.
	Kid *string `json:"kid,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyItem.
func (ki KeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ki.Kid != nil {
		objectMap["kid"] = ki.Kid
	}
	if ki.Attributes != nil {
		objectMap["attributes"] = ki.Attributes
	}
	if ki.Tags != nil {
		objectMap["tags"] = ki.Tags
	}
	return json.Marshal(objectMap)
}

// KeyListResult the key list result.
type KeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of keys in the key vault along with a link to the next page of keys.
	Value *[]KeyItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyListResult.
func (klr KeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// KeyListResultIterator provides access to a complete listing of KeyItem values.
type KeyListResultIterator struct {
	i    int
	page KeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *KeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *KeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter KeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter KeyListResultIterator) Response() KeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter KeyListResultIterator) Value() KeyItem {
	if !iter.page.NotDone() {
		return KeyItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the KeyListResultIterator type.
func NewKeyListResultIterator(page KeyListResultPage) KeyListResultIterator {
	return KeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (klr KeyListResult) IsEmpty() bool {
	return klr.Value == nil || len(*klr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (klr KeyListResult) hasNextLink() bool {
	return klr.NextLink != nil && len(*klr.NextLink) != 0
}

// keyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (klr KeyListResult) keyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !klr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(klr.NextLink)))
}

// KeyListResultPage contains a page of KeyItem values.
type KeyListResultPage struct {
	fn  func(context.Context, KeyListResult) (KeyListResult, error)
	klr KeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *KeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.klr)
		if err != nil {
			return err
		}
		page.klr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *KeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page KeyListResultPage) NotDone() bool {
	return !page.klr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page KeyListResultPage) Response() KeyListResult {
	return page.klr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page KeyListResultPage) Values() []KeyItem {
	if page.klr.IsEmpty() {
		return nil
	}
	return *page.klr.Value
}

// Creates a new instance of the KeyListResultPage type.
func NewKeyListResultPage(cur KeyListResult, getNextPage func(context.Context, KeyListResult) (KeyListResult, error)) KeyListResultPage {
	return KeyListResultPage{
		fn:  getNextPage,
		klr: cur,
	}
}

// KeyOperationResult the key operation result.
type KeyOperationResult struct {
	autorest.Response `json:"-"`
	// Kid - READ-ONLY; Key identifier
	Kid *string `json:"kid,omitempty"`
	// Result - READ-ONLY; a URL-encoded base64 string
	Result *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyOperationResult.
func (kor KeyOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// KeyOperationsParameters the key operations parameters.
type KeyOperationsParameters struct {
	// Algorithm - algorithm identifier. Possible values include: 'RSAOAEP', 'RSAOAEP256', 'RSA15'
	Algorithm JSONWebKeyEncryptionAlgorithm `json:"alg,omitempty"`
	// Value - a URL-encoded base64 string
	Value *string `json:"value,omitempty"`
}

// KeyProperties properties of the key pair backing a certificate.
type KeyProperties struct {
	// Exportable - Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`
	// KeyType - The type of key pair to be used for the certificate. Possible values include: 'EC', 'ECHSM', 'RSA', 'RSAHSM', 'Oct'
	KeyType JSONWebKeyType `json:"kty,omitempty"`
	// KeySize - The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"key_size,omitempty"`
	// ReuseKey - Indicates if the same key pair will be used on certificate renewal.
	ReuseKey *bool `json:"reuse_key,omitempty"`
	// Curve - Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P256', 'P384', 'P521', 'P256K'
	Curve JSONWebKeyCurveName `json:"crv,omitempty"`
}

// KeyRestoreParameters the key restore parameters.
type KeyRestoreParameters struct {
	// KeyBundleBackup - The backup blob associated with a key bundle. (a URL-encoded base64 string)
	KeyBundleBackup *string `json:"value,omitempty"`
}

// KeySignParameters the key operations parameters.
type KeySignParameters struct {
	// Algorithm - The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
	Algorithm JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`
	// Value - a URL-encoded base64 string
	Value *string `json:"value,omitempty"`
}

// KeyUpdateParameters the key update parameters.
type KeyUpdateParameters struct {
	// KeyOps - Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
	KeyOps        *[]JSONWebKeyOperation `json:"key_ops,omitempty"`
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyUpdateParameters.
func (kup KeyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kup.KeyOps != nil {
		objectMap["key_ops"] = kup.KeyOps
	}
	if kup.KeyAttributes != nil {
		objectMap["attributes"] = kup.KeyAttributes
	}
	if kup.Tags != nil {
		objectMap["tags"] = kup.Tags
	}
	return json.Marshal(objectMap)
}

// KeyVerifyParameters the key verify parameters.
type KeyVerifyParameters struct {
	// Algorithm - The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
	Algorithm JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`
	// Digest - The digest used for signing. (a URL-encoded base64 string)
	Digest *string `json:"digest,omitempty"`
	// Signature - The signature to be verified. (a URL-encoded base64 string)
	Signature *string `json:"value,omitempty"`
}

// KeyVerifyResult the key verify result.
type KeyVerifyResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; True if the signature is verified, otherwise false.
	Value *bool `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVerifyResult.
func (kvr KeyVerifyResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LifetimeAction action and its trigger that will be performed by Key Vault over the lifetime of a
// certificate.
type LifetimeAction struct {
	// Trigger - The condition that will execute the action.
	Trigger *Trigger `json:"trigger,omitempty"`
	// Action - The action that will be executed.
	Action *Action `json:"action,omitempty"`
}

// OrganizationDetails details of the organization of the certificate issuer.
type OrganizationDetails struct {
	// ID - Id of the organization.
	ID *string `json:"id,omitempty"`
	// AdminDetails - Details of the organization administrator.
	AdminDetails *[]AdministratorDetails `json:"admin_details,omitempty"`
}

// PendingCertificateSigningRequestResult the pending certificate signing request result.
type PendingCertificateSigningRequestResult struct {
	// Value - READ-ONLY; The pending certificate signing request as Base64 encoded string.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for PendingCertificateSigningRequestResult.
func (pcsrr PendingCertificateSigningRequestResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SasDefinitionAttributes the SAS definition management attributes.
type SasDefinitionAttributes struct {
	// Enabled - the enabled state of the object.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
	// RecoverableDays - READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty"`
	// RecoveryLevel - READ-ONLY; Reflects the deletion recovery level currently in effect for SAS definitions in the current vault. If it contains 'Purgeable' the SAS definition can be permanently deleted by a privileged user; otherwise, only the system can purge the SAS definition, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription', 'CustomizedRecoverablePurgeable', 'CustomizedRecoverable', 'CustomizedRecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for SasDefinitionAttributes.
func (sda SasDefinitionAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sda.Enabled != nil {
		objectMap["enabled"] = sda.Enabled
	}
	return json.Marshal(objectMap)
}

// SasDefinitionBundle a SAS definition bundle consists of key vault SAS definition details plus its
// attributes.
type SasDefinitionBundle struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The SAS definition id.
	ID *string `json:"id,omitempty"`
	// SecretID - READ-ONLY; Storage account SAS definition secret id.
	SecretID *string `json:"sid,omitempty"`
	// TemplateURI - READ-ONLY; The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
	TemplateURI *string `json:"templateUri,omitempty"`
	// SasType - READ-ONLY; The type of SAS token the SAS definition will create. Possible values include: 'Account', 'Service'
	SasType SasTokenType `json:"sasType,omitempty"`
	// ValidityPeriod - READ-ONLY; The validity period of SAS tokens created according to the SAS definition.
	ValidityPeriod *string `json:"validityPeriod,omitempty"`
	// Attributes - READ-ONLY; The SAS definition attributes.
	Attributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionBundle.
func (sdb SasDefinitionBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SasDefinitionCreateParameters the SAS definition create parameters.
type SasDefinitionCreateParameters struct {
	// TemplateURI - The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
	TemplateURI *string `json:"templateUri,omitempty"`
	// SasType - The type of SAS token the SAS definition will create. Possible values include: 'Account', 'Service'
	SasType SasTokenType `json:"sasType,omitempty"`
	// ValidityPeriod - The validity period of SAS tokens created according to the SAS definition.
	ValidityPeriod *string `json:"validityPeriod,omitempty"`
	// SasDefinitionAttributes - The attributes of the SAS definition.
	SasDefinitionAttributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionCreateParameters.
func (sdcp SasDefinitionCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcp.TemplateURI != nil {
		objectMap["templateUri"] = sdcp.TemplateURI
	}
	if sdcp.SasType != "" {
		objectMap["sasType"] = sdcp.SasType
	}
	if sdcp.ValidityPeriod != nil {
		objectMap["validityPeriod"] = sdcp.ValidityPeriod
	}
	if sdcp.SasDefinitionAttributes != nil {
		objectMap["attributes"] = sdcp.SasDefinitionAttributes
	}
	if sdcp.Tags != nil {
		objectMap["tags"] = sdcp.Tags
	}
	return json.Marshal(objectMap)
}

// SasDefinitionItem the SAS definition item containing storage SAS definition metadata.
type SasDefinitionItem struct {
	// ID - READ-ONLY; The storage SAS identifier.
	ID *string `json:"id,omitempty"`
	// SecretID - READ-ONLY; The storage account SAS definition secret id.
	SecretID *string `json:"sid,omitempty"`
	// Attributes - READ-ONLY; The SAS definition management attributes.
	Attributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionItem.
func (sdi SasDefinitionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SasDefinitionListResult the storage account SAS definition list result.
type SasDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of SAS definitions along with a link to the next page of SAS definitions.
	Value *[]SasDefinitionItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of SAS definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SasDefinitionListResult.
func (sdlr SasDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SasDefinitionListResultIterator provides access to a complete listing of SasDefinitionItem values.
type SasDefinitionListResultIterator struct {
	i    int
	page SasDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SasDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SasDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SasDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SasDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SasDefinitionListResultIterator) Response() SasDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SasDefinitionListResultIterator) Value() SasDefinitionItem {
	if !iter.page.NotDone() {
		return SasDefinitionItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SasDefinitionListResultIterator type.
func NewSasDefinitionListResultIterator(page SasDefinitionListResultPage) SasDefinitionListResultIterator {
	return SasDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdlr SasDefinitionListResult) IsEmpty() bool {
	return sdlr.Value == nil || len(*sdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdlr SasDefinitionListResult) hasNextLink() bool {
	return sdlr.NextLink != nil && len(*sdlr.NextLink) != 0
}

// sasDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdlr SasDefinitionListResult) sasDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdlr.NextLink)))
}

// SasDefinitionListResultPage contains a page of SasDefinitionItem values.
type SasDefinitionListResultPage struct {
	fn   func(context.Context, SasDefinitionListResult) (SasDefinitionListResult, error)
	sdlr SasDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SasDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SasDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdlr)
		if err != nil {
			return err
		}
		page.sdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SasDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SasDefinitionListResultPage) NotDone() bool {
	return !page.sdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SasDefinitionListResultPage) Response() SasDefinitionListResult {
	return page.sdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SasDefinitionListResultPage) Values() []SasDefinitionItem {
	if page.sdlr.IsEmpty() {
		return nil
	}
	return *page.sdlr.Value
}

// Creates a new instance of the SasDefinitionListResultPage type.
func NewSasDefinitionListResultPage(cur SasDefinitionListResult, getNextPage func(context.Context, SasDefinitionListResult) (SasDefinitionListResult, error)) SasDefinitionListResultPage {
	return SasDefinitionListResultPage{
		fn:   getNextPage,
		sdlr: cur,
	}
}

// SasDefinitionUpdateParameters the SAS definition update parameters.
type SasDefinitionUpdateParameters struct {
	// TemplateURI - The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
	TemplateURI *string `json:"templateUri,omitempty"`
	// SasType - The type of SAS token the SAS definition will create. Possible values include: 'Account', 'Service'
	SasType SasTokenType `json:"sasType,omitempty"`
	// ValidityPeriod - The validity period of SAS tokens created according to the SAS definition.
	ValidityPeriod *string `json:"validityPeriod,omitempty"`
	// SasDefinitionAttributes - The attributes of the SAS definition.
	SasDefinitionAttributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionUpdateParameters.
func (sdup SasDefinitionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdup.TemplateURI != nil {
		objectMap["templateUri"] = sdup.TemplateURI
	}
	if sdup.SasType != "" {
		objectMap["sasType"] = sdup.SasType
	}
	if sdup.ValidityPeriod != nil {
		objectMap["validityPeriod"] = sdup.ValidityPeriod
	}
	if sdup.SasDefinitionAttributes != nil {
		objectMap["attributes"] = sdup.SasDefinitionAttributes
	}
	if sdup.Tags != nil {
		objectMap["tags"] = sdup.Tags
	}
	return json.Marshal(objectMap)
}

// SecretAttributes the secret management attributes.
type SecretAttributes struct {
	// RecoverableDays - READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty"`
	// RecoveryLevel - READ-ONLY; Reflects the deletion recovery level currently in effect for secrets in the current vault. If it contains 'Purgeable', the secret can be permanently deleted by a privileged user; otherwise, only the system can purge the secret, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription', 'CustomizedRecoverablePurgeable', 'CustomizedRecoverable', 'CustomizedRecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretAttributes.
func (sa SecretAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.Enabled != nil {
		objectMap["enabled"] = sa.Enabled
	}
	if sa.NotBefore != nil {
		objectMap["nbf"] = sa.NotBefore
	}
	if sa.Expires != nil {
		objectMap["exp"] = sa.Expires
	}
	return json.Marshal(objectMap)
}

// SecretBundle a secret consisting of a value, id and its attributes.
type SecretBundle struct {
	autorest.Response `json:"-"`
	// Value - The secret value.
	Value *string `json:"value,omitempty"`
	// ID - The secret id.
	ID *string `json:"id,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Kid - READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate.
	Kid *string `json:"kid,omitempty"`
	// Managed - READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretBundle.
func (sb SecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sb.Value != nil {
		objectMap["value"] = sb.Value
	}
	if sb.ID != nil {
		objectMap["id"] = sb.ID
	}
	if sb.ContentType != nil {
		objectMap["contentType"] = sb.ContentType
	}
	if sb.Attributes != nil {
		objectMap["attributes"] = sb.Attributes
	}
	if sb.Tags != nil {
		objectMap["tags"] = sb.Tags
	}
	return json.Marshal(objectMap)
}

// SecretItem the secret item containing secret metadata.
type SecretItem struct {
	// ID - Secret identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// Managed - READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretItem.
func (si SecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.ID != nil {
		objectMap["id"] = si.ID
	}
	if si.Attributes != nil {
		objectMap["attributes"] = si.Attributes
	}
	if si.Tags != nil {
		objectMap["tags"] = si.Tags
	}
	if si.ContentType != nil {
		objectMap["contentType"] = si.ContentType
	}
	return json.Marshal(objectMap)
}

// SecretListResult the secret list result.
type SecretListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of secrets in the key vault along with a link to the next page of secrets.
	Value *[]SecretItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretListResult.
func (slr SecretListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecretListResultIterator provides access to a complete listing of SecretItem values.
type SecretListResultIterator struct {
	i    int
	page SecretListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretListResultIterator) Response() SecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretListResultIterator) Value() SecretItem {
	if !iter.page.NotDone() {
		return SecretItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretListResultIterator type.
func NewSecretListResultIterator(page SecretListResultPage) SecretListResultIterator {
	return SecretListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SecretListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SecretListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// secretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SecretListResult) secretListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SecretListResultPage contains a page of SecretItem values.
type SecretListResultPage struct {
	fn  func(context.Context, SecretListResult) (SecretListResult, error)
	slr SecretListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretListResultPage) Response() SecretListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretListResultPage) Values() []SecretItem {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SecretListResultPage type.
func NewSecretListResultPage(cur SecretListResult, getNextPage func(context.Context, SecretListResult) (SecretListResult, error)) SecretListResultPage {
	return SecretListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SecretProperties properties of the key backing a certificate.
type SecretProperties struct {
	// ContentType - The media type (MIME type).
	ContentType *string `json:"contentType,omitempty"`
}

// SecretRestoreParameters the secret restore parameters.
type SecretRestoreParameters struct {
	// SecretBundleBackup - The backup blob associated with a secret bundle. (a URL-encoded base64 string)
	SecretBundleBackup *string `json:"value,omitempty"`
}

// SecretSetParameters the secret set parameters.
type SecretSetParameters struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// SecretAttributes - The secret management attributes.
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretSetParameters.
func (ssp SecretSetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssp.Value != nil {
		objectMap["value"] = ssp.Value
	}
	if ssp.Tags != nil {
		objectMap["tags"] = ssp.Tags
	}
	if ssp.ContentType != nil {
		objectMap["contentType"] = ssp.ContentType
	}
	if ssp.SecretAttributes != nil {
		objectMap["attributes"] = ssp.SecretAttributes
	}
	return json.Marshal(objectMap)
}

// SecretUpdateParameters the secret update parameters.
type SecretUpdateParameters struct {
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// SecretAttributes - The secret management attributes.
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecretUpdateParameters.
func (sup SecretUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.ContentType != nil {
		objectMap["contentType"] = sup.ContentType
	}
	if sup.SecretAttributes != nil {
		objectMap["attributes"] = sup.SecretAttributes
	}
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	return json.Marshal(objectMap)
}

// StorageAccountAttributes the storage account management attributes.
type StorageAccountAttributes struct {
	// Enabled - the enabled state of the object.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - READ-ONLY; Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
	// RecoverableDays - READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty"`
	// RecoveryLevel - READ-ONLY; Reflects the deletion recovery level currently in effect for storage accounts in the current vault. If it contains 'Purgeable' the storage account can be permanently deleted by a privileged user; otherwise, only the system can purge the storage account, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription', 'CustomizedRecoverablePurgeable', 'CustomizedRecoverable', 'CustomizedRecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountAttributes.
func (saa StorageAccountAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saa.Enabled != nil {
		objectMap["enabled"] = saa.Enabled
	}
	return json.Marshal(objectMap)
}

// StorageAccountCreateParameters the storage account create parameters.
type StorageAccountCreateParameters struct {
	// ResourceID - Storage account resource id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ActiveKeyName - Current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// StorageAccountAttributes - The attributes of the storage account.
	StorageAccountAttributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageAccountCreateParameters.
func (sacp StorageAccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sacp.ResourceID != nil {
		objectMap["resourceId"] = sacp.ResourceID
	}
	if sacp.ActiveKeyName != nil {
		objectMap["activeKeyName"] = sacp.ActiveKeyName
	}
	if sacp.AutoRegenerateKey != nil {
		objectMap["autoRegenerateKey"] = sacp.AutoRegenerateKey
	}
	if sacp.RegenerationPeriod != nil {
		objectMap["regenerationPeriod"] = sacp.RegenerationPeriod
	}
	if sacp.StorageAccountAttributes != nil {
		objectMap["attributes"] = sacp.StorageAccountAttributes
	}
	if sacp.Tags != nil {
		objectMap["tags"] = sacp.Tags
	}
	return json.Marshal(objectMap)
}

// StorageAccountItem the storage account item containing storage account metadata.
type StorageAccountItem struct {
	// ID - READ-ONLY; Storage identifier.
	ID *string `json:"id,omitempty"`
	// ResourceID - READ-ONLY; Storage account resource Id.
	ResourceID *string `json:"resourceId,omitempty"`
	// Attributes - READ-ONLY; The storage account management attributes.
	Attributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageAccountItem.
func (sai StorageAccountItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageAccountRegenerteKeyParameters the storage account key regenerate parameters.
type StorageAccountRegenerteKeyParameters struct {
	// KeyName - The storage account key name.
	KeyName *string `json:"keyName,omitempty"`
}

// StorageAccountUpdateParameters the storage account update parameters.
type StorageAccountUpdateParameters struct {
	// ActiveKeyName - The current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// StorageAccountAttributes - The attributes of the storage account.
	StorageAccountAttributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageAccountUpdateParameters.
func (saup StorageAccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saup.ActiveKeyName != nil {
		objectMap["activeKeyName"] = saup.ActiveKeyName
	}
	if saup.AutoRegenerateKey != nil {
		objectMap["autoRegenerateKey"] = saup.AutoRegenerateKey
	}
	if saup.RegenerationPeriod != nil {
		objectMap["regenerationPeriod"] = saup.RegenerationPeriod
	}
	if saup.StorageAccountAttributes != nil {
		objectMap["attributes"] = saup.StorageAccountAttributes
	}
	if saup.Tags != nil {
		objectMap["tags"] = saup.Tags
	}
	return json.Marshal(objectMap)
}

// StorageBundle a Storage account bundle consists of key vault storage account details plus its
// attributes.
type StorageBundle struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The storage account id.
	ID *string `json:"id,omitempty"`
	// ResourceID - READ-ONLY; The storage account resource id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ActiveKeyName - READ-ONLY; The current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - READ-ONLY; whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - READ-ONLY; The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// Attributes - READ-ONLY; The storage account attributes.
	Attributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - READ-ONLY; Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageBundle.
func (sb StorageBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageListResult the storage accounts list result.
type StorageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of storage accounts in the key vault along with a link to the next page of storage accounts.
	Value *[]StorageAccountItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of storage accounts.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageListResult.
func (slr StorageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageListResultIterator provides access to a complete listing of StorageAccountItem values.
type StorageListResultIterator struct {
	i    int
	page StorageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageListResultIterator) Response() StorageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageListResultIterator) Value() StorageAccountItem {
	if !iter.page.NotDone() {
		return StorageAccountItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageListResultIterator type.
func NewStorageListResultIterator(page StorageListResultPage) StorageListResultIterator {
	return StorageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr StorageListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr StorageListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// storageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr StorageListResult) storageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// StorageListResultPage contains a page of StorageAccountItem values.
type StorageListResultPage struct {
	fn  func(context.Context, StorageListResult) (StorageListResult, error)
	slr StorageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageListResultPage) Response() StorageListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageListResultPage) Values() []StorageAccountItem {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the StorageListResultPage type.
func NewStorageListResultPage(cur StorageListResult, getNextPage func(context.Context, StorageListResult) (StorageListResult, error)) StorageListResultPage {
	return StorageListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// StorageRestoreParameters the secret restore parameters.
type StorageRestoreParameters struct {
	// StorageBundleBackup - The backup blob associated with a storage account. (a URL-encoded base64 string)
	StorageBundleBackup *string `json:"value,omitempty"`
}

// SubjectAlternativeNames the subject alternate names of a X509 object.
type SubjectAlternativeNames struct {
	// Emails - Email addresses.
	Emails *[]string `json:"emails,omitempty"`
	// DNSNames - Domain names.
	DNSNames *[]string `json:"dns_names,omitempty"`
	// Upns - User principal names.
	Upns *[]string `json:"upns,omitempty"`
}

// Trigger a condition to be satisfied for an action to be executed.
type Trigger struct {
	// LifetimePercentage - Percentage of lifetime at which to trigger. Value should be between 1 and 99.
	LifetimePercentage *int32 `json:"lifetime_percentage,omitempty"`
	// DaysBeforeExpiry - Days before expiry to attempt renewal. Value should be between 1 and validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between 1 and 972 (36 * 27).
	DaysBeforeExpiry *int32 `json:"days_before_expiry,omitempty"`
}

// X509CertificateProperties properties of the X509 component of a certificate.
type X509CertificateProperties struct {
	// Subject - The subject name. Should be a valid X509 distinguished Name.
	Subject *string `json:"subject,omitempty"`
	// Ekus - The enhanced key usage.
	Ekus *[]string `json:"ekus,omitempty"`
	// SubjectAlternativeNames - The subject alternative names.
	SubjectAlternativeNames *SubjectAlternativeNames `json:"sans,omitempty"`
	// KeyUsage - List of key usages.
	KeyUsage *[]KeyUsageType `json:"key_usage,omitempty"`
	// ValidityInMonths - The duration that the certificate is valid in months.
	ValidityInMonths *int32 `json:"validity_months,omitempty"`
}
