/*
 * Copyright (C) 2025 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2025 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 08 апр. 2016 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_ISO226_2003_H_
#define GENERATED_ISO226_ISO226_2003_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const int16_t iso226_2003_curve_0_phons[1382] =
    {
        -4212, -4215, -4222, -4228,
        -4234, -4243, -4258, -4269, -4277, -4288, -4293, -4307, -4317, -4325,
        -4338, -4353, -4362, -4370, -4382, -4388, -4396, -4409, -4422, -4429,
        -4441, -4452, -4463, -4471, -4479, -4497, -4510, -4521, -4534, -4549,
        -4557, -4572, -4588, -4593, -4599, -4613, -4620, -4627, -4633, -4644,
        -4657, -4667, -4679, -4687, -4700, -4715, -4729, -4738, -4747, -4755,
        -4762, -4765, -4774, -4787, -4796, -4802, -4813, -4835, -4839, -4848,
        -4863, -4872, -4878, -4886, -4892, -4907, -4920, -4933, -4947, -4948,
        -4948, -4960, -4977, -4986, -4987, -5003, -5008, -5018, -5030, -5039,
        -5043, -5055, -5064, -5073, -5082, -5092, -5105, -5111, -5119, -5129,
        -5138, -5143, -5149, -5159, -5162, -5169, -5180, -5187, -5191, -5202,
        -5214, -5225, -5234, -5243, -5253, -5264, -5277, -5286, -5294, -5304,
        -5316, -5327, -5337, -5349, -5357, -5363, -5374, -5382, -5391, -5397,
        -5404, -5413, -5421, -5424, -5431, -5441, -5445, -5452, -5465, -5473,
        -5479, -5489, -5497, -5510, -5516, -5520, -5525, -5535, -5540, -5546,
        -5555, -5563, -5570, -5574, -5583, -5594, -5601, -5610, -5621, -5629,
        -5635, -5645, -5654, -5662, -5668, -5675, -5686, -5694, -5699, -5705,
        -5710, -5716, -5721, -5729, -5734, -5740, -5753, -5759, -5764, -5773,
        -5784, -5792, -5804, -5808, -5820, -5826, -5833, -5839, -5848, -5856,
        -5866, -5871, -5875, -5885, -5892, -5894, -5894, -5909, -5914, -5924,
        -5935, -5941, -5950, -5961, -5968, -5973, -5977, -5982, -5990, -5998,
        -6006, -6014, -6018, -6025, -6034, -6041, -6045, -6055, -6056, -6059,
        -6067, -6081, -6084, -6094, -6100, -6104, -6106, -6112, -6115, -6118,
        -6124, -6126, -6135, -6143, -6150, -6163, -6177, -6180, -6192, -6201,
        -6206, -6210, -6215, -6219, -6223, -6226, -6230, -6233, -6242, -6248,
        -6258, -6266, -6271, -6283, -6282, -6282, -6293, -6301, -6306, -6316,
        -6325, -6329, -6337, -6342, -6343, -6346, -6349, -6354, -6360, -6363,
        -6372, -6376, -6382, -6394, -6402, -6406, -6413, -6417, -6421, -6427,
        -6429, -6432, -6442, -6446, -6448, -6452, -6455, -6460, -6467, -6480,
        -6485, -6494, -6503, -6512, -6523, -6524, -6533, -6539, -6540, -6546,
        -6547, -6551, -6556, -6562, -6567, -6574, -6584, -6588, -6595, -6598,
        -6600, -6605, -6608, -6609, -6615, -6619, -6623, -6630, -6634, -6638,
        -6647, -6652, -6659, -6670, -6675, -6681, -6686, -6691, -6696, -6702,
        -6708, -6708, -6709, -6720, -6723, -6725, -6733, -6736, -6738, -6739,
        -6747, -6753, -6751, -6760, -6767, -6766, -6770, -6777, -6777, -6785,
        -6794, -6793, -6802, -6805, -6812, -6818, -6826, -6836, -6840, -6851,
        -6854, -6856, -6860, -6864, -6862, -6862, -6864, -6868, -6869, -6880,
        -6889, -6891, -6901, -6905, -6911, -6918, -6923, -6928, -6929, -6935,
        -6942, -6940, -6936, -6943, -6943, -6947, -6950, -6955, -6961, -6966,
        -6973, -6979, -6986, -6991, -6996, -7002, -7008, -7013, -7018, -7018,
        -7026, -7030, -7032, -7040, -7043, -7046, -7051, -7054, -7053, -7061,
        -7059, -7059, -7064, -7067, -7070, -7075, -7080, -7082, -7085, -7088,
        -7091, -7093, -7097, -7102, -7107, -7112, -7119, -7126, -7124, -7130,
        -7137, -7137, -7145, -7150, -7152, -7155, -7164, -7164, -7170, -7177,
        -7176, -7184, -7190, -7194, -7198, -7201, -7207, -7209, -7217, -7218,
        -7220, -7221, -7223, -7224, -7225, -7226, -7229, -7231, -7234, -7237,
        -7242, -7248, -7254, -7261, -7261, -7268, -7273, -7274, -7282, -7285,
        -7287, -7291, -7296, -7293, -7301, -7301, -7296, -7303, -7303, -7307,
        -7312, -7320, -7326, -7327, -7332, -7339, -7343, -7350, -7350, -7354,
        -7355, -7357, -7362, -7370, -7376, -7382, -7384, -7386, -7393, -7394,
        -7395, -7397, -7399, -7400, -7403, -7407, -7407, -7415, -7422, -7420,
        -7429, -7433, -7434, -7436, -7442, -7441, -7440, -7445, -7443, -7449,
        -7454, -7459, -7461, -7466, -7470, -7473, -7479, -7481, -7491, -7493,
        -7497, -7499, -7504, -7502, -7500, -7506, -7499, -7505, -7508, -7508,
        -7513, -7517, -7519, -7521, -7522, -7529, -7535, -7543, -7551, -7558,
        -7563, -7563, -7562, -7563, -7569, -7565, -7572, -7575, -7576, -7582,
        -7581, -7585, -7582, -7585, -7591, -7601, -7610, -7617, -7623, -7627,
        -7628, -7630, -7628, -7632, -7627, -7626, -7627, -7624, -7627, -7634,
        -7644, -7652, -7660, -7667, -7659, -7665, -7666, -7659, -7666, -7663,
        -7666, -7665, -7669, -7670, -7671, -7680, -7684, -7684, -7692, -7697,
        -7704, -7706, -7708, -7705, -7706, -7710, -7705, -7713, -7716, -7723,
        -7727, -7729, -7729, -7731, -7732, -7739, -7745, -7751, -7759, -7764,
        -7766, -7767, -7768, -7767, -7773, -7765, -7771, -7773, -7767, -7773,
        -7778, -7784, -7788, -7794, -7795, -7800, -7804, -7806, -7810, -7811,
        -7808, -7806, -7815, -7816, -7819, -7826, -7827, -7829, -7827, -7828,
        -7827, -7830, -7825, -7825, -7827, -7824, -7829, -7835, -7841, -7849,
        -7853, -7846, -7854, -7850, -7848, -7855, -7857, -7865, -7867, -7875,
        -7870, -7872, -7875, -7867, -7874, -7876, -7884, -7888, -7895, -7889,
        -7890, -7895, -7888, -7889, -7894, -7898, -7904, -7910, -7914, -7919,
        -7923, -7926, -7932, -7934, -7934, -7934, -7936, -7934, -7935, -7936,
        -7936, -7936, -7937, -7939, -7932, -7935, -7938, -7940, -7942, -7949,
        -7950, -7958, -7960, -7962, -7964, -7965, -7966, -7966, -7956, -7955,
        -7954, -7955, -7956, -7964, -7965, -7974, -7974, -7984, -7984, -7988,
        -7989, -7985, -7979, -7984, -7980, -7980, -7981, -7991, -7992, -7993,
        -7994, -7989, -7990, -7991, -7996, -8003, -8009, -8009, -8011, -8011,
        -8006, -8006, -8005, -7997, -8003, -8007, -8013, -8016, -8016, -8016,
        -8016, -8016, -8017, -8011, -8017, -8012, -8016, -8016, -8016, -8022,
        -8022, -8022, -8025, -8028, -8030, -8037, -8037, -8037, -8037, -8037,
        -8037, -8038, -8038, -8039, -8039, -8039, -8032, -8029, -8030, -8028,
        -8019, -8023, -8028, -8033, -8037, -8037, -8037, -8037, -8037, -8037,
        -8039, -8044, -8045, -8045, -8046, -8046, -8051, -8057, -8058, -8058,
        -8059, -8059, -8059, -8061, -8068, -8070, -8082, -8082, -8082, -8082,
        -8082, -8072, -8072, -8072, -8072, -8071, -8059, -8057, -8057, -8049,
        -8053, -8053, -8057, -8057, -8067, -8066, -8066, -8072, -8072, -8072,
        -8069, -8068, -8066, -8063, -8063, -8062, -8061, -8061, -8061, -8062,
        -8061, -8065, -8062, -8063, -8063, -8061, -8065, -8062, -8066, -8067,
        -8072, -8076, -8084, -8086, -8088, -8089, -8084, -8087, -8084, -8089,
        -8093, -8097, -8106, -8109, -8115, -8119, -8120, -8123, -8130, -8129,
        -8134, -8146, -8149, -8154, -8159, -8165, -8169, -8168, -8173, -8176,
        -8176, -8182, -8189, -8193, -8201, -8217, -8218, -8231, -8245, -8250,
        -8255, -8259, -8263, -8267, -8278, -8284, -8285, -8302, -8304, -8310,
        -8315, -8319, -8325, -8337, -8342, -8353, -8360, -8370, -8379, -8388,
        -8397, -8406, -8415, -8415, -8424, -8424, -8426, -8433, -8439, -8451,
        -8461, -8469, -8462, -8469, -8469, -8461, -8468, -8470, -8476, -8480,
        -8487, -8494, -8503, -8512, -8518, -8524, -8527, -8527, -8527, -8527,
        -8525, -8527, -8524, -8524, -8527, -8523, -8527, -8531, -8535, -8534,
        -8535, -8530, -8525, -8525, -8529, -8527, -8533, -8536, -8534, -8535,
        -8532, -8532, -8528, -8525, -8526, -8524, -8520, -8517, -8516, -8516,
        -8509, -8507, -8508, -8507, -8503, -8500, -8505, -8505, -8504, -8506,
        -8508, -8506, -8505, -8496, -8493, -8495, -8491, -8492, -8497, -8501,
        -8499, -8506, -8497, -8491, -8488, -8488, -8486, -8485, -8489, -8488,
        -8491, -8494, -8496, -8505, -8508, -8499, -8501, -8492, -8494, -8490,
        -8493, -8498, -8495, -8503, -8504, -8503, -8505, -8503, -8509, -8500,
        -8508, -8505, -8503, -8513, -8512, -8518, -8521, -8524, -8528, -8527,
        -8528, -8527, -8527, -8528, -8523, -8525, -8525, -8527, -8529, -8531,
        -8539, -8538, -8539, -8540, -8539, -8541, -8536, -8544, -8544, -8548,
        -8553, -8555, -8559, -8558, -8559, -8560, -8565, -8571, -8575, -8581,
        -8581, -8581, -8581, -8581, -8582, -8579, -8582, -8580, -8581, -8581,
        -8581, -8581, -8581, -8582, -8582, -8588, -8592, -8597, -8599, -8599,
        -8599, -8599, -8600, -8610, -8615, -8627, -8633, -8637, -8637, -8637,
        -8637, -8636, -8636, -8636, -8636, -8636, -8644, -8646, -8646, -8656,
        -8656, -8656, -8656, -8656, -8656, -8660, -8666, -8666, -8670, -8672,
        -8670, -8666, -8662, -8655, -8659, -8663, -8668, -8673, -8676, -8676,
        -8679, -8680, -8676, -8684, -8681, -8682, -8681, -8683, -8676, -8681,
        -8676, -8674, -8674, -8679, -8678, -8684, -8688, -8695, -8694, -8695,
        -8694, -8692, -8689, -8687, -8682, -8678, -8682, -8678, -8679, -8689,
        -8696, -8690, -8690, -8689, -8684, -8680, -8681, -8675, -8673, -8673,
        -8671, -8667, -8665, -8661, -8662, -8660, -8658, -8658, -8661, -8660,
        -8654, -8649, -8647, -8645, -8643, -8633, -8628, -8628, -8622, -8616,
        -8612, -8609, -8604, -8599, -8590, -8588, -8587, -8587, -8589, -8582,
        -8583, -8583, -8578, -8574, -8568, -8565, -8556, -8548, -8546, -8545,
        -8541, -8538, -8539, -8535, -8528, -8524, -8516, -8513, -8499, -8496,
        -8491, -8486, -8478, -8477, -8472, -8467, -8462, -8458, -8456, -8448,
        -8440, -8431, -8425, -8419, -8415, -8405, -8399, -8393, -8391, -8383,
        -8381, -8373, -8368, -8367, -8361, -8355, -8355, -8352, -8352, -8349,
        -8347, -8340, -8332, -8321, -8315, -8314, -8308, -8300, -8294, -8288,
        -8280, -8273, -8273, -8268, -8266, -8265, -8261, -8262, -8253, -8255,
        -8256, -8247, -8248, -8247, -8240, -8235, -8230, -8220, -8211, -8209,
        -8203, -8189, -8185, -8184, -8178, -8174, -8174, -8174, -8174, -8175,
        -8173, -8173, -8164, -8157, -8160, -8152, -8148, -8150, -8147, -8141,
        -8142, -8138, -8131, -8132, -8128, -8126, -8131, -8131, -8131, -8136,
        -8135, -8143, -8144, -8143, -8150, -8143, -8139, -8134, -8133, -8132,
        -8132, -8126, -8119, -8112, -8106, -8098, -8092, -8094, -8100, -8105,
        -8104, -8100, -8099, -8090, -8089, -8084, -8073, -8068, -8057, -8047,
        -8040, -8039, -8037, -8037, -8041, -8031, -8032, -8026, -8022, -8021,
        -8013, -8011, -8002, -8001, -7992, -7984, -7977, -7971, -7960, -7948,
        -7939, -7931, -7928, -7915, -7913, -7900, -7892, -7880, -7873, -7856,
        -7848, -7838, -7817, -7804, -7783, -7772, -7756, -7740, -7722, -7711,
        -7702, -7686, -7663, -7640, -7621, -7602, -7586, -7574
    };

    static const int16_t iso226_2003_curve_10_phons[1382] =
    {
        -3638, -3641, -3647, -3650,
        -3656, -3663, -3675, -3684, -3689, -3699, -3702, -3713, -3719, -3724,
        -3734, -3746, -3751, -3758, -3767, -3771, -3774, -3784, -3793, -3797,
        -3808, -3816, -3824, -3828, -3833, -3846, -3855, -3862, -3873, -3884,
        -3888, -3899, -3912, -3918, -3921, -3932, -3936, -3939, -3944, -3953,
        -3962, -3969, -3978, -3984, -3993, -4006, -4017, -4025, -4031, -4035,
        -4040, -4039, -4042, -4051, -4057, -4061, -4067, -4086, -4090, -4096,
        -4111, -4119, -4124, -4129, -4138, -4149, -4157, -4164, -4175, -4174,
        -4176, -4185, -4198, -4204, -4206, -4216, -4219, -4226, -4235, -4242,
        -4245, -4254, -4261, -4268, -4272, -4279, -4287, -4291, -4297, -4304,
        -4309, -4315, -4320, -4331, -4334, -4338, -4351, -4355, -4356, -4363,
        -4371, -4377, -4383, -4390, -4398, -4403, -4415, -4421, -4428, -4436,
        -4446, -4454, -4463, -4472, -4478, -4481, -4491, -4498, -4505, -4508,
        -4512, -4520, -4525, -4526, -4532, -4541, -4544, -4550, -4561, -4566,
        -4571, -4578, -4583, -4593, -4596, -4599, -4605, -4614, -4617, -4623,
        -4631, -4636, -4644, -4646, -4654, -4661, -4667, -4672, -4682, -4688,
        -4692, -4702, -4707, -4712, -4717, -4721, -4728, -4730, -4733, -4738,
        -4741, -4746, -4750, -4758, -4762, -4765, -4777, -4783, -4786, -4796,
        -4804, -4812, -4823, -4826, -4837, -4842, -4846, -4851, -4856, -4865,
        -4871, -4876, -4880, -4888, -4893, -4894, -4895, -4909, -4914, -4921,
        -4930, -4933, -4939, -4948, -4952, -4958, -4961, -4966, -4974, -4979,
        -4986, -4992, -4992, -4998, -5008, -5011, -5016, -5028, -5028, -5029,
        -5036, -5048, -5050, -5060, -5065, -5067, -5068, -5073, -5075, -5076,
        -5085, -5083, -5091, -5098, -5102, -5113, -5125, -5127, -5138, -5147,
        -5149, -5155, -5161, -5163, -5168, -5171, -5173, -5174, -5182, -5187,
        -5197, -5205, -5211, -5221, -5221, -5221, -5233, -5242, -5246, -5252,
        -5261, -5261, -5270, -5274, -5273, -5273, -5275, -5280, -5284, -5287,
        -5295, -5299, -5305, -5313, -5320, -5324, -5331, -5335, -5338, -5345,
        -5349, -5352, -5362, -5368, -5370, -5373, -5376, -5379, -5384, -5394,
        -5397, -5404, -5412, -5420, -5430, -5431, -5440, -5447, -5448, -5453,
        -5454, -5458, -5464, -5470, -5476, -5481, -5489, -5494, -5500, -5505,
        -5506, -5513, -5513, -5515, -5523, -5527, -5530, -5537, -5539, -5543,
        -5551, -5554, -5557, -5564, -5568, -5573, -5578, -5583, -5590, -5597,
        -5603, -5604, -5602, -5611, -5615, -5617, -5626, -5629, -5633, -5636,
        -5647, -5649, -5649, -5658, -5666, -5664, -5666, -5674, -5676, -5683,
        -5689, -5689, -5698, -5702, -5706, -5711, -5717, -5728, -5731, -5741,
        -5741, -5745, -5751, -5754, -5753, -5755, -5758, -5763, -5764, -5771,
        -5780, -5783, -5792, -5797, -5805, -5813, -5820, -5827, -5828, -5833,
        -5838, -5836, -5834, -5840, -5840, -5845, -5848, -5854, -5860, -5865,
        -5871, -5876, -5882, -5888, -5893, -5899, -5904, -5909, -5915, -5917,
        -5925, -5927, -5928, -5939, -5943, -5945, -5951, -5953, -5951, -5960,
        -5959, -5957, -5961, -5967, -5971, -5978, -5986, -5988, -5993, -5997,
        -6000, -6000, -6006, -6010, -6015, -6020, -6024, -6032, -6031, -6036,
        -6042, -6043, -6052, -6057, -6060, -6064, -6072, -6073, -6080, -6084,
        -6083, -6091, -6096, -6101, -6105, -6109, -6115, -6113, -6122, -6125,
        -6128, -6131, -6135, -6140, -6140, -6143, -6147, -6149, -6149, -6153,
        -6158, -6164, -6169, -6178, -6178, -6183, -6186, -6189, -6197, -6201,
        -6203, -6209, -6214, -6213, -6221, -6224, -6219, -6227, -6230, -6232,
        -6238, -6246, -6253, -6254, -6258, -6264, -6271, -6276, -6276, -6281,
        -6282, -6285, -6293, -6302, -6310, -6316, -6320, -6322, -6330, -6330,
        -6333, -6337, -6340, -6342, -6345, -6351, -6353, -6360, -6365, -6363,
        -6371, -6374, -6373, -6375, -6380, -6379, -6383, -6387, -6387, -6395,
        -6399, -6405, -6408, -6410, -6417, -6424, -6430, -6432, -6442, -6443,
        -6445, -6448, -6452, -6452, -6453, -6460, -6458, -6464, -6467, -6467,
        -6472, -6474, -6477, -6481, -6483, -6493, -6500, -6506, -6515, -6522,
        -6528, -6530, -6530, -6533, -6538, -6534, -6542, -6541, -6541, -6549,
        -6549, -6553, -6554, -6558, -6563, -6574, -6583, -6591, -6595, -6600,
        -6600, -6601, -6603, -6603, -6602, -6604, -6606, -6603, -6606, -6612,
        -6620, -6627, -6633, -6641, -6638, -6643, -6646, -6642, -6651, -6651,
        -6655, -6656, -6659, -6659, -6659, -6664, -6666, -6668, -6675, -6682,
        -6692, -6697, -6699, -6696, -6699, -6701, -6699, -6705, -6710, -6718,
        -6723, -6726, -6728, -6729, -6732, -6738, -6740, -6748, -6753, -6758,
        -6761, -6764, -6766, -6766, -6773, -6765, -6770, -6773, -6768, -6772,
        -6778, -6786, -6791, -6796, -6802, -6807, -6811, -6817, -6820, -6822,
        -6818, -6817, -6824, -6827, -6831, -6835, -6838, -6841, -6840, -6843,
        -6845, -6848, -6845, -6848, -6847, -6846, -6850, -6856, -6863, -6870,
        -6874, -6871, -6876, -6875, -6876, -6882, -6886, -6892, -6897, -6902,
        -6900, -6901, -6903, -6898, -6904, -6908, -6917, -6924, -6930, -6928,
        -6929, -6933, -6929, -6928, -6935, -6939, -6945, -6951, -6955, -6958,
        -6963, -6966, -6969, -6974, -6970, -6973, -6973, -6973, -6975, -6978,
        -6981, -6981, -6985, -6985, -6979, -6982, -6985, -6986, -6990, -6995,
        -6998, -7004, -7008, -7011, -7012, -7015, -7018, -7021, -7012, -7014,
        -7014, -7014, -7015, -7022, -7025, -7029, -7029, -7034, -7034, -7038,
        -7043, -7042, -7038, -7046, -7044, -7047, -7052, -7059, -7060, -7066,
        -7066, -7062, -7067, -7068, -7070, -7074, -7077, -7074, -7078, -7080,
        -7074, -7078, -7078, -7070, -7075, -7078, -7081, -7085, -7087, -7088,
        -7089, -7092, -7095, -7091, -7095, -7090, -7094, -7094, -7099, -7106,
        -7106, -7111, -7113, -7117, -7118, -7124, -7124, -7124, -7124, -7126,
        -7126, -7129, -7132, -7132, -7135, -7135, -7128, -7125, -7125, -7124,
        -7115, -7119, -7122, -7126, -7129, -7131, -7133, -7133, -7133, -7133,
        -7135, -7144, -7145, -7149, -7151, -7151, -7156, -7162, -7165, -7168,
        -7168, -7173, -7175, -7176, -7180, -7181, -7189, -7189, -7189, -7189,
        -7189, -7179, -7183, -7184, -7186, -7186, -7177, -7174, -7173, -7169,
        -7169, -7169, -7174, -7171, -7181, -7181, -7181, -7186, -7186, -7186,
        -7185, -7187, -7186, -7187, -7186, -7183, -7180, -7178, -7178, -7176,
        -7179, -7185, -7185, -7184, -7186, -7184, -7187, -7185, -7189, -7191,
        -7195, -7200, -7208, -7208, -7211, -7213, -7207, -7211, -7210, -7212,
        -7214, -7215, -7221, -7226, -7229, -7236, -7234, -7237, -7243, -7239,
        -7243, -7255, -7260, -7268, -7275, -7279, -7282, -7279, -7282, -7284,
        -7281, -7284, -7290, -7291, -7295, -7308, -7305, -7315, -7326, -7328,
        -7331, -7332, -7335, -7335, -7344, -7353, -7353, -7368, -7373, -7378,
        -7381, -7382, -7385, -7392, -7397, -7404, -7411, -7418, -7424, -7431,
        -7438, -7445, -7452, -7452, -7456, -7456, -7457, -7461, -7466, -7474,
        -7483, -7488, -7485, -7489, -7488, -7483, -7487, -7488, -7491, -7493,
        -7497, -7503, -7510, -7515, -7521, -7526, -7527, -7527, -7527, -7527,
        -7525, -7527, -7524, -7525, -7527, -7523, -7525, -7528, -7531, -7530,
        -7531, -7528, -7525, -7525, -7529, -7529, -7536, -7536, -7535, -7536,
        -7533, -7532, -7529, -7524, -7526, -7525, -7522, -7523, -7523, -7525,
        -7525, -7523, -7527, -7526, -7524, -7520, -7524, -7523, -7521, -7519,
        -7520, -7517, -7516, -7511, -7508, -7512, -7512, -7512, -7518, -7522,
        -7519, -7527, -7522, -7519, -7514, -7515, -7512, -7509, -7510, -7508,
        -7512, -7516, -7517, -7524, -7527, -7520, -7521, -7512, -7513, -7508,
        -7510, -7513, -7509, -7515, -7516, -7517, -7521, -7522, -7527, -7522,
        -7527, -7523, -7524, -7529, -7528, -7532, -7533, -7535, -7537, -7537,
        -7539, -7537, -7538, -7539, -7534, -7535, -7535, -7536, -7535, -7538,
        -7542, -7541, -7542, -7542, -7542, -7542, -7540, -7544, -7547, -7551,
        -7553, -7557, -7559, -7556, -7557, -7555, -7558, -7563, -7567, -7571,
        -7572, -7574, -7574, -7574, -7575, -7572, -7573, -7569, -7568, -7568,
        -7568, -7570, -7570, -7571, -7573, -7576, -7577, -7580, -7581, -7581,
        -7581, -7583, -7584, -7593, -7597, -7606, -7611, -7613, -7612, -7612,
        -7612, -7612, -7609, -7609, -7609, -7605, -7613, -7615, -7613, -7620,
        -7621, -7621, -7621, -7621, -7623, -7626, -7632, -7632, -7634, -7637,
        -7636, -7631, -7630, -7625, -7627, -7632, -7635, -7638, -7637, -7637,
        -7640, -7639, -7635, -7641, -7640, -7640, -7642, -7643, -7637, -7643,
        -7639, -7638, -7640, -7642, -7642, -7648, -7651, -7658, -7659, -7658,
        -7657, -7656, -7652, -7651, -7646, -7642, -7646, -7640, -7643, -7653,
        -7658, -7652, -7653, -7653, -7647, -7643, -7645, -7639, -7637, -7637,
        -7638, -7634, -7633, -7632, -7632, -7632, -7630, -7631, -7632, -7633,
        -7629, -7627, -7625, -7625, -7625, -7617, -7611, -7609, -7604, -7599,
        -7597, -7595, -7593, -7590, -7583, -7582, -7579, -7578, -7581, -7576,
        -7579, -7581, -7579, -7577, -7573, -7569, -7562, -7551, -7548, -7545,
        -7544, -7544, -7542, -7540, -7532, -7530, -7526, -7527, -7515, -7514,
        -7511, -7508, -7500, -7500, -7498, -7494, -7492, -7484, -7482, -7476,
        -7473, -7464, -7457, -7455, -7452, -7443, -7437, -7434, -7430, -7425,
        -7425, -7416, -7412, -7411, -7405, -7399, -7397, -7394, -7394, -7393,
        -7392, -7388, -7380, -7371, -7366, -7363, -7356, -7349, -7346, -7341,
        -7334, -7330, -7330, -7325, -7323, -7321, -7318, -7321, -7312, -7312,
        -7313, -7304, -7305, -7304, -7297, -7292, -7288, -7278, -7271, -7265,
        -7259, -7248, -7243, -7243, -7237, -7233, -7233, -7234, -7232, -7230,
        -7226, -7226, -7216, -7208, -7209, -7200, -7195, -7194, -7189, -7182,
        -7182, -7175, -7170, -7171, -7165, -7161, -7164, -7163, -7161, -7161,
        -7156, -7164, -7160, -7154, -7160, -7154, -7149, -7144, -7138, -7133,
        -7129, -7119, -7111, -7105, -7097, -7088, -7083, -7081, -7082, -7082,
        -7077, -7070, -7067, -7058, -7055, -7047, -7037, -7031, -7021, -7011,
        -7003, -6999, -6995, -6996, -6995, -6986, -6981, -6971, -6962, -6957,
        -6948, -6947, -6938, -6936, -6928, -6919, -6908, -6901, -6887, -6873,
        -6866, -6857, -6851, -6842, -6836, -6822, -6810, -6797, -6789, -6775,
        -6769, -6758, -6741, -6729, -6710, -6698, -6684, -6666, -6651, -6643,
        -6631, -6620, -6601, -6579, -6564, -6550, -6536, -6528
    };

    static const int16_t iso226_2003_curve_20_phons[1382] =
    {
        -3064, -3066, -3073, -3073,
        -3077, -3083, -3091, -3100, -3101, -3109, -3112, -3119, -3122, -3124,
        -3130, -3139, -3141, -3145, -3152, -3153, -3153, -3158, -3163, -3165,
        -3174, -3179, -3185, -3186, -3186, -3195, -3201, -3203, -3212, -3219,
        -3219, -3226, -3236, -3242, -3243, -3252, -3252, -3252, -3255, -3261,
        -3266, -3271, -3276, -3281, -3286, -3298, -3305, -3311, -3314, -3316,
        -3317, -3312, -3310, -3315, -3318, -3320, -3321, -3337, -3342, -3344,
        -3359, -3366, -3371, -3372, -3385, -3390, -3395, -3395, -3403, -3400,
        -3404, -3411, -3418, -3422, -3425, -3429, -3430, -3434, -3440, -3444,
        -3446, -3453, -3458, -3463, -3463, -3465, -3470, -3471, -3475, -3479,
        -3480, -3488, -3491, -3503, -3507, -3508, -3522, -3522, -3522, -3523,
        -3528, -3529, -3533, -3536, -3542, -3543, -3552, -3557, -3562, -3568,
        -3577, -3581, -3588, -3595, -3600, -3600, -3608, -3614, -3618, -3619,
        -3620, -3627, -3629, -3629, -3632, -3640, -3643, -3647, -3657, -3660,
        -3662, -3667, -3668, -3676, -3676, -3679, -3684, -3694, -3695, -3700,
        -3708, -3710, -3717, -3718, -3724, -3729, -3733, -3735, -3743, -3747,
        -3750, -3758, -3760, -3762, -3765, -3767, -3770, -3767, -3767, -3772,
        -3773, -3776, -3780, -3786, -3791, -3790, -3800, -3807, -3809, -3818,
        -3824, -3831, -3843, -3844, -3854, -3857, -3858, -3862, -3865, -3874,
        -3875, -3881, -3884, -3890, -3894, -3894, -3896, -3909, -3914, -3919,
        -3925, -3926, -3929, -3934, -3937, -3943, -3945, -3950, -3957, -3959,
        -3967, -3970, -3967, -3971, -3982, -3982, -3986, -4001, -4000, -4000,
        -4006, -4016, -4016, -4025, -4031, -4031, -4030, -4035, -4034, -4034,
        -4045, -4041, -4047, -4053, -4054, -4064, -4073, -4074, -4083, -4092,
        -4093, -4101, -4106, -4107, -4113, -4115, -4116, -4116, -4121, -4125,
        -4136, -4144, -4151, -4160, -4159, -4159, -4174, -4183, -4186, -4188,
        -4196, -4194, -4202, -4206, -4203, -4200, -4201, -4207, -4208, -4211,
        -4218, -4222, -4228, -4233, -4239, -4242, -4249, -4253, -4255, -4263,
        -4269, -4272, -4282, -4289, -4291, -4294, -4297, -4298, -4302, -4308,
        -4308, -4314, -4322, -4327, -4337, -4337, -4346, -4356, -4356, -4360,
        -4361, -4364, -4372, -4379, -4384, -4389, -4395, -4400, -4405, -4412,
        -4413, -4421, -4417, -4421, -4431, -4435, -4438, -4444, -4444, -4449,
        -4454, -4457, -4455, -4458, -4460, -4466, -4469, -4475, -4484, -4492,
        -4498, -4501, -4494, -4503, -4507, -4509, -4519, -4522, -4527, -4533,
        -4546, -4545, -4547, -4557, -4565, -4562, -4562, -4570, -4574, -4582,
        -4585, -4584, -4594, -4599, -4599, -4604, -4609, -4619, -4622, -4630,
        -4628, -4633, -4643, -4645, -4643, -4647, -4651, -4657, -4659, -4662,
        -4670, -4675, -4682, -4689, -4699, -4708, -4718, -4726, -4728, -4731,
        -4733, -4733, -4733, -4736, -4736, -4742, -4747, -4752, -4758, -4763,
        -4768, -4772, -4777, -4784, -4790, -4795, -4800, -4806, -4812, -4815,
        -4825, -4825, -4825, -4838, -4843, -4845, -4850, -4852, -4850, -4859,
        -4858, -4855, -4859, -4868, -4873, -4882, -4891, -4893, -4901, -4906,
        -4909, -4907, -4914, -4919, -4923, -4928, -4928, -4937, -4938, -4941,
        -4948, -4949, -4959, -4963, -4967, -4972, -4980, -4981, -4989, -4991,
        -4989, -4998, -5003, -5007, -5012, -5017, -5023, -5017, -5027, -5032,
        -5037, -5042, -5047, -5056, -5055, -5060, -5064, -5067, -5065, -5069,
        -5074, -5079, -5085, -5094, -5095, -5098, -5100, -5104, -5113, -5117,
        -5118, -5126, -5131, -5132, -5142, -5146, -5142, -5152, -5156, -5157,
        -5164, -5172, -5180, -5180, -5185, -5190, -5198, -5201, -5203, -5209,
        -5209, -5214, -5224, -5234, -5244, -5249, -5255, -5258, -5266, -5266,
        -5272, -5276, -5281, -5285, -5288, -5295, -5298, -5306, -5308, -5306,
        -5314, -5314, -5311, -5314, -5317, -5318, -5326, -5329, -5330, -5340,
        -5344, -5350, -5355, -5355, -5365, -5374, -5381, -5383, -5393, -5392,
        -5392, -5397, -5400, -5402, -5407, -5414, -5417, -5422, -5426, -5426,
        -5431, -5431, -5436, -5441, -5445, -5457, -5465, -5470, -5479, -5487,
        -5493, -5497, -5498, -5503, -5507, -5503, -5512, -5507, -5505, -5516,
        -5516, -5521, -5526, -5531, -5536, -5546, -5556, -5564, -5567, -5573,
        -5572, -5573, -5577, -5574, -5577, -5582, -5585, -5581, -5586, -5591,
        -5596, -5602, -5607, -5616, -5617, -5621, -5626, -5626, -5636, -5639,
        -5643, -5647, -5648, -5648, -5648, -5648, -5648, -5653, -5658, -5668,
        -5680, -5687, -5689, -5687, -5692, -5692, -5692, -5697, -5703, -5712,
        -5718, -5722, -5727, -5728, -5732, -5736, -5736, -5745, -5747, -5752,
        -5756, -5760, -5763, -5765, -5773, -5765, -5768, -5773, -5769, -5771,
        -5779, -5788, -5793, -5798, -5809, -5813, -5818, -5828, -5830, -5833,
        -5828, -5828, -5833, -5837, -5843, -5845, -5849, -5854, -5854, -5858,
        -5863, -5867, -5864, -5871, -5866, -5869, -5871, -5877, -5885, -5890,
        -5894, -5895, -5897, -5900, -5904, -5909, -5915, -5920, -5926, -5930,
        -5930, -5930, -5930, -5929, -5934, -5940, -5950, -5960, -5964, -5967,
        -5968, -5972, -5970, -5966, -5976, -5980, -5986, -5992, -5996, -5996,
        -6003, -6005, -6006, -6014, -6007, -6012, -6010, -6013, -6016, -6019,
        -6026, -6027, -6032, -6032, -6027, -6028, -6032, -6032, -6038, -6041,
        -6047, -6050, -6056, -6061, -6060, -6066, -6070, -6075, -6069, -6073,
        -6073, -6073, -6074, -6081, -6084, -6084, -6084, -6084, -6084, -6089,
        -6098, -6100, -6098, -6108, -6109, -6114, -6123, -6128, -6129, -6138,
        -6139, -6134, -6144, -6144, -6144, -6144, -6144, -6139, -6144, -6148,
        -6143, -6151, -6151, -6143, -6148, -6148, -6149, -6153, -6158, -6160,
        -6163, -6167, -6172, -6171, -6172, -6167, -6172, -6172, -6181, -6191,
        -6191, -6200, -6201, -6206, -6207, -6211, -6211, -6211, -6211, -6216,
        -6216, -6221, -6225, -6226, -6231, -6231, -6224, -6221, -6221, -6220,
        -6211, -6215, -6216, -6219, -6220, -6225, -6229, -6229, -6229, -6229,
        -6231, -6245, -6246, -6253, -6256, -6256, -6261, -6267, -6272, -6277,
        -6278, -6287, -6292, -6292, -6292, -6292, -6297, -6297, -6297, -6297,
        -6297, -6286, -6295, -6296, -6300, -6300, -6295, -6290, -6290, -6289,
        -6286, -6286, -6290, -6285, -6295, -6295, -6295, -6300, -6300, -6300,
        -6300, -6305, -6305, -6310, -6309, -6304, -6299, -6295, -6294, -6290,
        -6296, -6304, -6308, -6305, -6309, -6308, -6308, -6308, -6311, -6315,
        -6317, -6324, -6331, -6330, -6334, -6338, -6330, -6335, -6335, -6334,
        -6335, -6333, -6335, -6342, -6343, -6353, -6348, -6351, -6356, -6348,
        -6352, -6365, -6372, -6382, -6391, -6392, -6396, -6391, -6391, -6392,
        -6386, -6386, -6390, -6389, -6390, -6399, -6392, -6399, -6406, -6405,
        -6408, -6405, -6407, -6403, -6411, -6421, -6422, -6435, -6441, -6446,
        -6446, -6445, -6445, -6447, -6452, -6456, -6461, -6466, -6470, -6475,
        -6479, -6484, -6488, -6488, -6488, -6488, -6488, -6488, -6492, -6497,
        -6504, -6506, -6508, -6508, -6506, -6505, -6506, -6506, -6506, -6506,
        -6507, -6512, -6517, -6518, -6523, -6527, -6527, -6527, -6527, -6527,
        -6525, -6527, -6524, -6526, -6527, -6523, -6523, -6524, -6527, -6526,
        -6526, -6525, -6525, -6525, -6530, -6531, -6540, -6536, -6536, -6537,
        -6533, -6532, -6531, -6523, -6526, -6525, -6525, -6528, -6529, -6535,
        -6540, -6539, -6545, -6546, -6546, -6541, -6542, -6541, -6537, -6532,
        -6531, -6527, -6527, -6526, -6524, -6530, -6532, -6533, -6538, -6542,
        -6539, -6548, -6547, -6546, -6539, -6542, -6537, -6532, -6532, -6527,
        -6532, -6537, -6538, -6544, -6546, -6541, -6540, -6532, -6532, -6525,
        -6527, -6527, -6522, -6528, -6528, -6532, -6537, -6541, -6546, -6544,
        -6546, -6542, -6545, -6546, -6544, -6546, -6544, -6546, -6545, -6546,
        -6550, -6546, -6550, -6550, -6545, -6546, -6545, -6546, -6542, -6544,
        -6546, -6544, -6545, -6544, -6545, -6544, -6544, -6544, -6549, -6553,
        -6553, -6559, -6559, -6554, -6554, -6550, -6550, -6555, -6559, -6562,
        -6563, -6568, -6568, -6568, -6568, -6564, -6564, -6559, -6555, -6555,
        -6555, -6559, -6559, -6559, -6563, -6563, -6563, -6563, -6563, -6563,
        -6563, -6568, -6568, -6577, -6579, -6585, -6589, -6588, -6588, -6588,
        -6588, -6587, -6582, -6582, -6582, -6575, -6582, -6584, -6580, -6584,
        -6585, -6585, -6585, -6585, -6589, -6593, -6599, -6598, -6598, -6603,
        -6602, -6597, -6597, -6596, -6596, -6600, -6601, -6602, -6598, -6599,
        -6601, -6598, -6594, -6598, -6598, -6598, -6603, -6603, -6598, -6604,
        -6602, -6601, -6607, -6606, -6605, -6612, -6614, -6622, -6625, -6622,
        -6621, -6620, -6615, -6615, -6610, -6605, -6610, -6602, -6606, -6616,
        -6621, -6615, -6616, -6616, -6611, -6606, -6609, -6602, -6600, -6601,
        -6605, -6601, -6601, -6602, -6603, -6604, -6603, -6603, -6603, -6606,
        -6604, -6604, -6604, -6605, -6607, -6601, -6594, -6589, -6585, -6582,
        -6582, -6582, -6582, -6582, -6577, -6576, -6571, -6569, -6573, -6569,
        -6574, -6579, -6579, -6579, -6578, -6574, -6568, -6555, -6551, -6546,
        -6546, -6550, -6546, -6545, -6537, -6536, -6536, -6540, -6531, -6532,
        -6532, -6530, -6522, -6522, -6523, -6520, -6523, -6510, -6509, -6504,
        -6506, -6498, -6489, -6491, -6489, -6482, -6475, -6475, -6470, -6467,
        -6469, -6460, -6455, -6455, -6450, -6443, -6440, -6436, -6436, -6436,
        -6437, -6436, -6427, -6420, -6416, -6413, -6404, -6398, -6397, -6393,
        -6387, -6386, -6387, -6383, -6380, -6377, -6375, -6379, -6370, -6369,
        -6370, -6361, -6361, -6361, -6354, -6350, -6345, -6335, -6330, -6322,
        -6315, -6306, -6302, -6302, -6297, -6292, -6293, -6293, -6290, -6284,
        -6279, -6278, -6268, -6258, -6258, -6248, -6242, -6238, -6231, -6223,
        -6222, -6213, -6208, -6210, -6202, -6196, -6197, -6195, -6191, -6186,
        -6176, -6184, -6176, -6166, -6170, -6166, -6158, -6154, -6144, -6134,
        -6127, -6112, -6102, -6098, -6088, -6078, -6074, -6069, -6064, -6060,
        -6049, -6041, -6035, -6026, -6021, -6011, -6000, -5995, -5984, -5974,
        -5967, -5960, -5954, -5954, -5950, -5940, -5930, -5916, -5902, -5893,
        -5883, -5883, -5874, -5870, -5864, -5854, -5840, -5830, -5814, -5798,
        -5792, -5782, -5774, -5768, -5758, -5744, -5728, -5715, -5705, -5695,
        -5691, -5678, -5666, -5655, -5636, -5623, -5612, -5591, -5581, -5575,
        -5560, -5553, -5539, -5518, -5507, -5498, -5487, -5482
    };

    static const int16_t iso226_2003_curve_30_phons[1382] =
    {
        -2555, -2555, -2560, -2563,
        -2566, -2569, -2575, -2581, -2580, -2586, -2587, -2592, -2595, -2598,
        -2605, -2612, -2613, -2615, -2619, -2621, -2620, -2624, -2629, -2629,
        -2637, -2639, -2644, -2644, -2643, -2652, -2657, -2657, -2664, -2671,
        -2671, -2678, -2687, -2689, -2690, -2698, -2699, -2699, -2701, -2704,
        -2709, -2712, -2717, -2719, -2726, -2734, -2741, -2746, -2748, -2751,
        -2751, -2748, -2747, -2750, -2752, -2752, -2752, -2762, -2764, -2767,
        -2779, -2784, -2788, -2789, -2800, -2805, -2808, -2810, -2816, -2815,
        -2815, -2819, -2824, -2829, -2830, -2837, -2837, -2841, -2847, -2852,
        -2853, -2859, -2864, -2869, -2868, -2869, -2873, -2871, -2872, -2873,
        -2876, -2880, -2883, -2893, -2894, -2895, -2908, -2910, -2910, -2911,
        -2916, -2918, -2922, -2923, -2928, -2929, -2935, -2938, -2943, -2947,
        -2956, -2962, -2966, -2971, -2975, -2973, -2978, -2982, -2986, -2989,
        -2990, -2997, -2999, -2999, -3002, -3010, -3011, -3013, -3021, -3025,
        -3027, -3030, -3031, -3036, -3037, -3038, -3041, -3048, -3051, -3056,
        -3060, -3063, -3069, -3067, -3073, -3078, -3078, -3079, -3087, -3089,
        -3091, -3097, -3100, -3104, -3106, -3107, -3110, -3109, -3110, -3113,
        -3113, -3116, -3120, -3124, -3129, -3128, -3135, -3139, -3142, -3150,
        -3157, -3163, -3173, -3175, -3181, -3184, -3184, -3186, -3188, -3196,
        -3195, -3200, -3203, -3209, -3211, -3212, -3212, -3223, -3227, -3232,
        -3240, -3241, -3246, -3254, -3254, -3257, -3260, -3260, -3270, -3271,
        -3277, -3280, -3279, -3281, -3286, -3285, -3288, -3296, -3295, -3297,
        -3305, -3315, -3317, -3325, -3330, -3332, -3331, -3332, -3331, -3332,
        -3339, -3335, -3340, -3346, -3346, -3356, -3365, -3366, -3373, -3382,
        -3384, -3388, -3389, -3390, -3394, -3392, -3392, -3392, -3398, -3403,
        -3412, -3418, -3422, -3432, -3431, -3431, -3441, -3449, -3453, -3458,
        -3463, -3461, -3467, -3471, -3469, -3465, -3465, -3470, -3471, -3472,
        -3479, -3481, -3486, -3494, -3499, -3501, -3509, -3513, -3514, -3519,
        -3522, -3525, -3534, -3538, -3540, -3543, -3546, -3547, -3551, -3558,
        -3559, -3567, -3574, -3579, -3588, -3588, -3597, -3604, -3602, -3607,
        -3607, -3609, -3615, -3619, -3624, -3628, -3634, -3635, -3639, -3643,
        -3643, -3647, -3646, -3649, -3659, -3662, -3662, -3668, -3668, -3670,
        -3676, -3676, -3676, -3683, -3686, -3689, -3693, -3699, -3705, -3712,
        -3718, -3716, -3713, -3722, -3724, -3723, -3731, -3734, -3739, -3741,
        -3752, -3755, -3755, -3763, -3771, -3767, -3767, -3773, -3775, -3783,
        -3791, -3792, -3802, -3804, -3807, -3809, -3812, -3819, -3818, -3827,
        -3828, -3830, -3838, -3841, -3839, -3841, -3844, -3848, -3847, -3853,
        -3862, -3864, -3873, -3879, -3889, -3896, -3903, -3910, -3909, -3912,
        -3915, -3913, -3911, -3917, -3917, -3923, -3926, -3932, -3938, -3942,
        -3945, -3948, -3953, -3958, -3962, -3967, -3972, -3977, -3984, -3987,
        -3994, -3996, -3998, -4009, -4012, -4014, -4019, -4020, -4019, -4026,
        -4022, -4018, -4021, -4025, -4030, -4037, -4044, -4046, -4052, -4056,
        -4060, -4060, -4065, -4070, -4074, -4079, -4081, -4089, -4089, -4095,
        -4099, -4102, -4112, -4116, -4119, -4122, -4131, -4130, -4134, -4138,
        -4135, -4142, -4147, -4151, -4154, -4158, -4165, -4163, -4169, -4174,
        -4181, -4185, -4190, -4197, -4197, -4200, -4204, -4203, -4202, -4206,
        -4209, -4214, -4219, -4227, -4225, -4229, -4230, -4229, -4238, -4242,
        -4243, -4250, -4255, -4255, -4265, -4272, -4266, -4275, -4281, -4284,
        -4290, -4294, -4301, -4299, -4302, -4306, -4310, -4314, -4317, -4321,
        -4321, -4326, -4333, -4342, -4351, -4354, -4361, -4363, -4371, -4372,
        -4377, -4381, -4386, -4390, -4392, -4400, -4403, -4409, -4412, -4411,
        -4417, -4417, -4415, -4417, -4420, -4418, -4424, -4425, -4425, -4435,
        -4440, -4446, -4449, -4451, -4461, -4470, -4474, -4479, -4489, -4488,
        -4488, -4491, -4492, -4495, -4498, -4503, -4506, -4511, -4512, -4513,
        -4517, -4515, -4520, -4523, -4525, -4536, -4541, -4547, -4556, -4561,
        -4570, -4574, -4575, -4579, -4585, -4580, -4587, -4585, -4582, -4590,
        -4589, -4592, -4594, -4597, -4604, -4614, -4622, -4629, -4636, -4641,
        -4640, -4641, -4644, -4642, -4646, -4650, -4650, -4650, -4653, -4659,
        -4664, -4670, -4673, -4682, -4679, -4681, -4687, -4685, -4692, -4696,
        -4701, -4704, -4707, -4706, -4707, -4708, -4706, -4710, -4715, -4723,
        -4731, -4738, -4737, -4737, -4740, -4740, -4742, -4748, -4755, -4764,
        -4770, -4775, -4777, -4778, -4779, -4784, -4786, -4792, -4796, -4800,
        -4803, -4804, -4807, -4805, -4813, -4806, -4807, -4814, -4810, -4813,
        -4822, -4832, -4838, -4845, -4852, -4854, -4860, -4867, -4869, -4872,
        -4867, -4867, -4872, -4877, -4882, -4886, -4889, -4893, -4892, -4895,
        -4895, -4901, -4895, -4900, -4898, -4897, -4902, -4911, -4919, -4925,
        -4931, -4929, -4932, -4934, -4934, -4939, -4945, -4950, -4955, -4960,
        -4959, -4957, -4962, -4957, -4962, -4967, -4975, -4985, -4989, -4988,
        -4990, -4993, -4989, -4989, -4994, -4999, -5005, -5010, -5015, -5018,
        -5023, -5024, -5028, -5033, -5028, -5031, -5030, -5032, -5035, -5041,
        -5045, -5047, -5053, -5052, -5047, -5049, -5053, -5052, -5060, -5064,
        -5067, -5071, -5074, -5076, -5074, -5079, -5082, -5086, -5080, -5084,
        -5085, -5082, -5087, -5091, -5094, -5098, -5099, -5102, -5103, -5109,
        -5114, -5115, -5114, -5119, -5120, -5125, -5132, -5137, -5142, -5147,
        -5148, -5148, -5153, -5154, -5156, -5156, -5156, -5153, -5155, -5157,
        -5156, -5160, -5160, -5154, -5157, -5157, -5159, -5163, -5165, -5170,
        -5172, -5176, -5182, -5178, -5182, -5177, -5181, -5181, -5185, -5193,
        -5193, -5198, -5201, -5203, -5206, -5211, -5211, -5211, -5211, -5213,
        -5213, -5218, -5223, -5226, -5231, -5231, -5224, -5221, -5221, -5222,
        -5213, -5215, -5218, -5223, -5225, -5227, -5229, -5229, -5229, -5229,
        -5231, -5243, -5246, -5252, -5254, -5256, -5261, -5267, -5273, -5277,
        -5278, -5287, -5289, -5289, -5289, -5289, -5295, -5295, -5295, -5295,
        -5295, -5284, -5293, -5296, -5298, -5300, -5295, -5293, -5290, -5287,
        -5286, -5286, -5290, -5287, -5295, -5295, -5295, -5300, -5295, -5293,
        -5291, -5296, -5296, -5301, -5300, -5297, -5294, -5292, -5292, -5290,
        -5294, -5302, -5305, -5303, -5309, -5305, -5304, -5302, -5303, -5306,
        -5309, -5315, -5322, -5325, -5330, -5334, -5330, -5335, -5334, -5331,
        -5328, -5327, -5328, -5333, -5336, -5342, -5339, -5342, -5345, -5339,
        -5343, -5352, -5357, -5365, -5371, -5374, -5378, -5373, -5373, -5375,
        -5370, -5370, -5374, -5372, -5373, -5379, -5371, -5378, -5383, -5380,
        -5381, -5379, -5380, -5380, -5384, -5392, -5392, -5402, -5405, -5410,
        -5410, -5407, -5409, -5410, -5415, -5419, -5424, -5429, -5433, -5436,
        -5438, -5440, -5442, -5443, -5443, -5443, -5443, -5443, -5444, -5447,
        -5451, -5451, -5450, -5453, -5451, -5449, -5452, -5453, -5456, -5458,
        -5461, -5464, -5467, -5467, -5471, -5473, -5473, -5472, -5472, -5473,
        -5472, -5473, -5470, -5472, -5472, -5468, -5468, -5468, -5472, -5470,
        -5471, -5471, -5468, -5470, -5473, -5470, -5479, -5475, -5474, -5477,
        -5475, -5475, -5472, -5469, -5472, -5471, -5470, -5472, -5474, -5480,
        -5485, -5483, -5490, -5491, -5491, -5484, -5487, -5489, -5487, -5484,
        -5483, -5482, -5479, -5475, -5474, -5476, -5477, -5478, -5484, -5487,
        -5484, -5493, -5492, -5490, -5484, -5488, -5482, -5478, -5480, -5473,
        -5477, -5480, -5480, -5488, -5488, -5484, -5484, -5477, -5479, -5474,
        -5477, -5479, -5474, -5480, -5480, -5481, -5484, -5486, -5488, -5488,
        -5489, -5487, -5491, -5491, -5489, -5491, -5489, -5493, -5491, -5491,
        -5498, -5492, -5495, -5495, -5490, -5491, -5490, -5489, -5487, -5490,
        -5491, -5490, -5488, -5485, -5486, -5483, -5483, -5485, -5487, -5492,
        -5492, -5499, -5498, -5495, -5493, -5489, -5489, -5491, -5493, -5495,
        -5495, -5498, -5498, -5498, -5501, -5498, -5498, -5495, -5491, -5491,
        -5491, -5493, -5493, -5493, -5495, -5495, -5495, -5495, -5495, -5495,
        -5495, -5498, -5498, -5507, -5509, -5515, -5519, -5518, -5517, -5517,
        -5517, -5516, -5514, -5512, -5510, -5504, -5509, -5511, -5509, -5516,
        -5517, -5517, -5517, -5517, -5519, -5522, -5528, -5528, -5530, -5535,
        -5534, -5531, -5528, -5525, -5524, -5527, -5525, -5526, -5524, -5523,
        -5526, -5525, -5523, -5530, -5530, -5529, -5535, -5532, -5530, -5533,
        -5529, -5528, -5533, -5533, -5533, -5539, -5542, -5546, -5546, -5542,
        -5541, -5538, -5535, -5534, -5532, -5529, -5535, -5528, -5533, -5543,
        -5546, -5542, -5543, -5543, -5538, -5533, -5534, -5528, -5527, -5527,
        -5529, -5525, -5527, -5528, -5528, -5529, -5530, -5530, -5530, -5532,
        -5531, -5531, -5531, -5532, -5534, -5531, -5524, -5522, -5519, -5518,
        -5518, -5518, -5518, -5518, -5512, -5509, -5506, -5505, -5509, -5505,
        -5511, -5515, -5515, -5515, -5514, -5511, -5506, -5497, -5496, -5491,
        -5490, -5493, -5493, -5493, -5485, -5484, -5483, -5485, -5476, -5477,
        -5479, -5477, -5474, -5475, -5477, -5477, -5477, -5466, -5466, -5459,
        -5459, -5453, -5444, -5447, -5445, -5440, -5436, -5434, -5432, -5429,
        -5430, -5425, -5419, -5421, -5416, -5412, -5410, -5406, -5406, -5407,
        -5407, -5406, -5399, -5391, -5387, -5383, -5377, -5373, -5370, -5365,
        -5362, -5359, -5360, -5359, -5358, -5356, -5356, -5361, -5352, -5353,
        -5354, -5343, -5343, -5340, -5334, -5330, -5325, -5314, -5307, -5303,
        -5299, -5290, -5289, -5290, -5285, -5278, -5279, -5277, -5275, -5270,
        -5265, -5267, -5257, -5247, -5246, -5239, -5233, -5228, -5224, -5214,
        -5213, -5204, -5201, -5202, -5194, -5189, -5191, -5187, -5183, -5180,
        -5172, -5175, -5166, -5161, -5163, -5158, -5152, -5146, -5138, -5131,
        -5124, -5111, -5102, -5098, -5088, -5080, -5074, -5071, -5066, -5061,
        -5050, -5043, -5040, -5030, -5028, -5020, -5009, -5004, -4993, -4983,
        -4976, -4969, -4963, -4964, -4959, -4949, -4942, -4930, -4918, -4911,
        -4906, -4901, -4893, -4893, -4882, -4874, -4863, -4856, -4842, -4830,
        -4820, -4813, -4806, -4798, -4793, -4782, -4770, -4762, -4754, -4742,
        -4738, -4728, -4716, -4703, -4687, -4676, -4665, -4648, -4639, -4638,
        -4626, -4620, -4608, -4591, -4583, -4573, -4562, -4558
    };

    static const int16_t iso226_2003_curve_40_phons[1382] =
    {
        -2046, -2044, -2048, -2053,
        -2054, -2055, -2059, -2063, -2059, -2063, -2062, -2065, -2069, -2072,
        -2079, -2084, -2084, -2084, -2085, -2089, -2086, -2090, -2094, -2094,
        -2099, -2100, -2103, -2103, -2100, -2109, -2113, -2112, -2116, -2124,
        -2124, -2129, -2138, -2136, -2137, -2144, -2145, -2146, -2147, -2148,
        -2152, -2153, -2158, -2158, -2165, -2170, -2176, -2181, -2182, -2186,
        -2185, -2183, -2184, -2186, -2186, -2184, -2184, -2187, -2185, -2190,
        -2199, -2202, -2204, -2207, -2216, -2219, -2221, -2226, -2229, -2230,
        -2226, -2226, -2231, -2235, -2235, -2244, -2245, -2249, -2255, -2259,
        -2259, -2266, -2270, -2274, -2274, -2274, -2276, -2270, -2268, -2268,
        -2272, -2272, -2275, -2282, -2282, -2283, -2294, -2298, -2298, -2299,
        -2305, -2307, -2310, -2310, -2314, -2314, -2319, -2320, -2325, -2326,
        -2335, -2342, -2344, -2348, -2350, -2347, -2349, -2350, -2354, -2358,
        -2360, -2367, -2369, -2369, -2372, -2379, -2379, -2378, -2385, -2389,
        -2392, -2393, -2393, -2397, -2397, -2397, -2398, -2403, -2408, -2412,
        -2413, -2417, -2420, -2416, -2422, -2427, -2423, -2424, -2432, -2432,
        -2432, -2436, -2441, -2445, -2448, -2448, -2449, -2452, -2452, -2455,
        -2452, -2456, -2460, -2462, -2467, -2465, -2471, -2472, -2476, -2481,
        -2490, -2496, -2503, -2506, -2508, -2510, -2510, -2510, -2511, -2518,
        -2514, -2519, -2522, -2527, -2529, -2529, -2528, -2537, -2540, -2545,
        -2555, -2557, -2563, -2573, -2571, -2571, -2575, -2571, -2584, -2584,
        -2588, -2590, -2590, -2591, -2589, -2589, -2589, -2592, -2591, -2594,
        -2604, -2614, -2619, -2626, -2629, -2633, -2632, -2628, -2628, -2629,
        -2633, -2629, -2634, -2638, -2639, -2649, -2658, -2658, -2663, -2671,
        -2675, -2675, -2673, -2672, -2675, -2669, -2668, -2668, -2675, -2680,
        -2687, -2693, -2694, -2703, -2702, -2702, -2709, -2714, -2719, -2727,
        -2729, -2727, -2732, -2736, -2734, -2730, -2730, -2732, -2733, -2733,
        -2739, -2740, -2744, -2754, -2759, -2760, -2769, -2772, -2772, -2775,
        -2776, -2779, -2785, -2787, -2789, -2792, -2794, -2795, -2800, -2808,
        -2810, -2820, -2826, -2831, -2839, -2839, -2848, -2852, -2849, -2854,
        -2853, -2854, -2858, -2859, -2864, -2868, -2872, -2870, -2874, -2874,
        -2873, -2874, -2874, -2878, -2887, -2888, -2887, -2892, -2891, -2891,
        -2897, -2895, -2898, -2908, -2912, -2913, -2918, -2922, -2927, -2931,
        -2937, -2932, -2932, -2941, -2940, -2936, -2943, -2946, -2951, -2949,
        -2958, -2965, -2963, -2968, -2976, -2972, -2972, -2976, -2976, -2984,
        -2998, -3000, -3009, -3010, -3014, -3014, -3015, -3019, -3015, -3025,
        -3028, -3026, -3034, -3038, -3035, -3035, -3038, -3040, -3036, -3045,
        -3054, -3053, -3064, -3069, -3079, -3084, -3088, -3095, -3091, -3093,
        -3098, -3093, -3089, -3098, -3098, -3103, -3106, -3111, -3117, -3122,
        -3122, -3124, -3128, -3133, -3133, -3138, -3143, -3148, -3155, -3158,
        -3163, -3167, -3172, -3180, -3181, -3183, -3188, -3187, -3188, -3192,
        -3186, -3182, -3183, -3183, -3187, -3192, -3196, -3198, -3202, -3207,
        -3211, -3212, -3216, -3220, -3225, -3230, -3234, -3240, -3240, -3249,
        -3251, -3254, -3264, -3268, -3271, -3272, -3281, -3278, -3279, -3286,
        -3281, -3286, -3290, -3295, -3296, -3300, -3306, -3309, -3311, -3316,
        -3325, -3329, -3334, -3339, -3338, -3339, -3343, -3338, -3338, -3343,
        -3343, -3349, -3353, -3359, -3355, -3360, -3360, -3355, -3363, -3367,
        -3369, -3374, -3378, -3379, -3388, -3397, -3389, -3399, -3405, -3412,
        -3417, -3417, -3422, -3419, -3419, -3423, -3422, -3428, -3431, -3433,
        -3433, -3438, -3443, -3449, -3458, -3459, -3466, -3468, -3477, -3479,
        -3482, -3486, -3491, -3495, -3496, -3505, -3508, -3513, -3516, -3516,
        -3521, -3520, -3519, -3520, -3522, -3519, -3522, -3522, -3521, -3531,
        -3536, -3541, -3542, -3547, -3556, -3565, -3566, -3575, -3584, -3584,
        -3584, -3585, -3584, -3589, -3590, -3592, -3595, -3600, -3599, -3600,
        -3603, -3600, -3605, -3605, -3605, -3614, -3617, -3625, -3634, -3636,
        -3646, -3652, -3653, -3656, -3662, -3658, -3663, -3662, -3658, -3663,
        -3662, -3663, -3663, -3663, -3673, -3682, -3687, -3694, -3704, -3709,
        -3709, -3710, -3710, -3710, -3714, -3719, -3715, -3718, -3721, -3728,
        -3731, -3738, -3739, -3747, -3741, -3740, -3748, -3744, -3748, -3752,
        -3758, -3761, -3765, -3764, -3766, -3767, -3765, -3766, -3772, -3777,
        -3782, -3788, -3785, -3787, -3788, -3787, -3792, -3798, -3808, -3816,
        -3823, -3827, -3827, -3828, -3827, -3832, -3837, -3840, -3846, -3848,
        -3850, -3848, -3850, -3846, -3853, -3848, -3846, -3855, -3851, -3856,
        -3866, -3875, -3882, -3891, -3895, -3895, -3902, -3906, -3908, -3910,
        -3906, -3906, -3911, -3916, -3921, -3927, -3929, -3931, -3929, -3931,
        -3927, -3935, -3926, -3930, -3929, -3925, -3934, -3944, -3953, -3959,
        -3967, -3964, -3967, -3969, -3963, -3969, -3974, -3979, -3984, -3989,
        -3988, -3985, -3993, -3985, -3989, -3994, -4000, -4010, -4014, -4008,
        -4013, -4013, -4007, -4012, -4013, -4018, -4024, -4029, -4033, -4039,
        -4042, -4042, -4051, -4051, -4048, -4051, -4051, -4052, -4053, -4063,
        -4063, -4068, -4073, -4073, -4067, -4069, -4074, -4073, -4082, -4086,
        -4087, -4091, -4092, -4092, -4087, -4092, -4093, -4098, -4092, -4096,
        -4096, -4092, -4100, -4101, -4105, -4111, -4114, -4120, -4121, -4129,
        -4130, -4130, -4130, -4130, -4131, -4136, -4141, -4146, -4155, -4157,
        -4158, -4161, -4163, -4163, -4167, -4167, -4167, -4166, -4166, -4167,
        -4170, -4170, -4170, -4165, -4166, -4167, -4170, -4172, -4172, -4179,
        -4181, -4186, -4191, -4185, -4192, -4187, -4190, -4190, -4190, -4195,
        -4195, -4196, -4201, -4201, -4206, -4211, -4211, -4211, -4211, -4211,
        -4211, -4216, -4221, -4226, -4231, -4231, -4224, -4221, -4221, -4224,
        -4216, -4216, -4220, -4227, -4229, -4229, -4229, -4229, -4229, -4229,
        -4231, -4240, -4246, -4251, -4252, -4256, -4261, -4267, -4275, -4277,
        -4278, -4287, -4287, -4287, -4287, -4287, -4292, -4292, -4292, -4292,
        -4292, -4282, -4291, -4295, -4295, -4300, -4295, -4295, -4290, -4285,
        -4286, -4286, -4290, -4290, -4295, -4295, -4295, -4300, -4291, -4286,
        -4282, -4287, -4287, -4291, -4291, -4290, -4289, -4289, -4289, -4290,
        -4292, -4299, -4303, -4301, -4309, -4303, -4299, -4295, -4295, -4297,
        -4301, -4306, -4313, -4320, -4325, -4330, -4330, -4335, -4334, -4328,
        -4322, -4321, -4321, -4324, -4329, -4331, -4330, -4333, -4335, -4329,
        -4334, -4339, -4341, -4347, -4352, -4356, -4360, -4356, -4355, -4358,
        -4354, -4354, -4358, -4356, -4357, -4358, -4351, -4357, -4360, -4355,
        -4355, -4354, -4354, -4357, -4357, -4362, -4362, -4370, -4370, -4374,
        -4373, -4369, -4373, -4374, -4379, -4382, -4388, -4393, -4397, -4397,
        -4397, -4397, -4397, -4397, -4397, -4397, -4397, -4397, -4396, -4396,
        -4399, -4396, -4393, -4398, -4396, -4392, -4397, -4400, -4406, -4411,
        -4415, -4416, -4416, -4417, -4418, -4418, -4418, -4418, -4418, -4418,
        -4419, -4418, -4417, -4418, -4417, -4413, -4413, -4413, -4417, -4414,
        -4416, -4416, -4411, -4415, -4415, -4409, -4417, -4413, -4411, -4418,
        -4418, -4418, -4414, -4414, -4417, -4416, -4415, -4416, -4419, -4425,
        -4431, -4426, -4435, -4436, -4436, -4428, -4433, -4436, -4437, -4437,
        -4436, -4436, -4432, -4424, -4424, -4422, -4421, -4423, -4429, -4432,
        -4429, -4438, -4437, -4433, -4429, -4433, -4427, -4423, -4427, -4418,
        -4422, -4422, -4422, -4431, -4431, -4427, -4428, -4423, -4427, -4422,
        -4426, -4431, -4426, -4431, -4431, -4431, -4432, -4432, -4431, -4432,
        -4432, -4432, -4436, -4436, -4434, -4435, -4434, -4440, -4436, -4436,
        -4445, -4437, -4441, -4441, -4436, -4436, -4435, -4431, -4432, -4435,
        -4436, -4435, -4431, -4426, -4426, -4422, -4421, -4426, -4426, -4430,
        -4430, -4440, -4437, -4436, -4432, -4427, -4427, -4427, -4427, -4427,
        -4427, -4427, -4427, -4427, -4433, -4432, -4432, -4432, -4427, -4427,
        -4427, -4427, -4427, -4427, -4427, -4427, -4427, -4427, -4427, -4427,
        -4427, -4427, -4428, -4436, -4438, -4444, -4448, -4448, -4447, -4447,
        -4447, -4446, -4446, -4442, -4437, -4434, -4436, -4438, -4438, -4448,
        -4448, -4448, -4448, -4448, -4448, -4452, -4457, -4457, -4462, -4467,
        -4466, -4465, -4460, -4454, -4453, -4454, -4448, -4451, -4450, -4448,
        -4451, -4453, -4453, -4461, -4461, -4461, -4466, -4461, -4461, -4462,
        -4456, -4455, -4458, -4460, -4460, -4466, -4470, -4471, -4468, -4463,
        -4461, -4457, -4455, -4454, -4455, -4453, -4460, -4454, -4460, -4470,
        -4472, -4469, -4470, -4470, -4464, -4459, -4458, -4453, -4454, -4454,
        -4454, -4450, -4452, -4454, -4454, -4453, -4457, -4457, -4457, -4457,
        -4458, -4458, -4457, -4459, -4461, -4460, -4455, -4455, -4453, -4454,
        -4454, -4454, -4454, -4454, -4446, -4442, -4441, -4441, -4445, -4442,
        -4447, -4451, -4451, -4451, -4449, -4447, -4444, -4439, -4441, -4436,
        -4433, -4436, -4441, -4440, -4432, -4431, -4430, -4430, -4421, -4422,
        -4427, -4425, -4425, -4427, -4431, -4433, -4432, -4422, -4422, -4414,
        -4412, -4407, -4399, -4403, -4402, -4397, -4396, -4393, -4395, -4391,
        -4392, -4389, -4383, -4386, -4382, -4381, -4379, -4375, -4375, -4377,
        -4377, -4375, -4372, -4362, -4357, -4354, -4349, -4347, -4343, -4338,
        -4336, -4331, -4332, -4336, -4337, -4336, -4337, -4342, -4333, -4338,
        -4338, -4324, -4325, -4320, -4313, -4309, -4304, -4293, -4284, -4284,
        -4283, -4274, -4276, -4279, -4274, -4265, -4265, -4261, -4261, -4256,
        -4251, -4255, -4246, -4236, -4235, -4230, -4224, -4218, -4216, -4205,
        -4203, -4195, -4195, -4195, -4186, -4181, -4185, -4180, -4175, -4173,
        -4167, -4166, -4157, -4155, -4156, -4151, -4147, -4138, -4133, -4128,
        -4121, -4111, -4102, -4098, -4088, -4083, -4075, -4073, -4069, -4063,
        -4052, -4045, -4044, -4035, -4034, -4029, -4018, -4013, -4002, -3992,
        -3985, -3978, -3973, -3973, -3968, -3958, -3954, -3944, -3934, -3929,
        -3928, -3920, -3911, -3915, -3901, -3895, -3886, -3881, -3869, -3861,
        -3848, -3843, -3837, -3827, -3827, -3819, -3812, -3809, -3803, -3788,
        -3786, -3778, -3766, -3751, -3737, -3728, -3719, -3705, -3697, -3700,
        -3693, -3686, -3676, -3664, -3658, -3649, -3637, -3633
    };

    static const int16_t iso226_2003_curve_50_phons[1382] =
    {
        -1566, -1565, -1567, -1567,
        -1568, -1569, -1571, -1573, -1571, -1575, -1572, -1576, -1579, -1580,
        -1586, -1594, -1594, -1594, -1596, -1596, -1595, -1599, -1601, -1598,
        -1604, -1604, -1605, -1603, -1602, -1611, -1613, -1614, -1618, -1625,
        -1622, -1627, -1635, -1630, -1631, -1637, -1635, -1635, -1635, -1639,
        -1643, -1643, -1649, -1647, -1653, -1658, -1663, -1666, -1668, -1670,
        -1669, -1665, -1664, -1665, -1667, -1665, -1666, -1671, -1668, -1670,
        -1679, -1682, -1685, -1687, -1693, -1696, -1698, -1700, -1702, -1701,
        -1697, -1698, -1702, -1705, -1703, -1710, -1708, -1710, -1716, -1720,
        -1720, -1727, -1731, -1733, -1732, -1730, -1735, -1732, -1729, -1731,
        -1732, -1729, -1732, -1738, -1737, -1738, -1748, -1750, -1751, -1753,
        -1759, -1763, -1764, -1764, -1766, -1767, -1771, -1772, -1776, -1780,
        -1786, -1791, -1791, -1793, -1794, -1790, -1793, -1797, -1799, -1801,
        -1803, -1810, -1812, -1809, -1812, -1820, -1819, -1816, -1823, -1825,
        -1826, -1826, -1824, -1829, -1829, -1828, -1827, -1834, -1837, -1841,
        -1844, -1846, -1850, -1845, -1850, -1854, -1852, -1849, -1857, -1857,
        -1856, -1858, -1861, -1863, -1864, -1865, -1869, -1873, -1874, -1876,
        -1874, -1877, -1878, -1881, -1884, -1880, -1886, -1887, -1889, -1892,
        -1899, -1904, -1912, -1914, -1918, -1917, -1917, -1917, -1917, -1920,
        -1919, -1921, -1921, -1925, -1926, -1926, -1924, -1935, -1938, -1945,
        -1954, -1956, -1963, -1970, -1968, -1968, -1970, -1966, -1974, -1975,
        -1976, -1978, -1977, -1979, -1978, -1977, -1977, -1983, -1979, -1980,
        -1988, -1998, -2000, -2007, -2010, -2012, -2007, -2007, -2007, -2008,
        -2010, -2006, -2012, -2015, -2015, -2025, -2030, -2031, -2035, -2040,
        -2041, -2041, -2041, -2042, -2041, -2038, -2038, -2038, -2042, -2047,
        -2053, -2059, -2061, -2070, -2065, -2065, -2072, -2076, -2077, -2083,
        -2087, -2086, -2088, -2090, -2084, -2079, -2079, -2079, -2080, -2081,
        -2088, -2089, -2090, -2099, -2104, -2105, -2109, -2111, -2111, -2117,
        -2118, -2117, -2125, -2129, -2129, -2131, -2133, -2134, -2138, -2146,
        -2148, -2156, -2159, -2161, -2168, -2166, -2172, -2177, -2173, -2178,
        -2175, -2176, -2180, -2183, -2186, -2189, -2193, -2193, -2196, -2196,
        -2195, -2196, -2196, -2195, -2202, -2203, -2200, -2203, -2202, -2203,
        -2210, -2209, -2213, -2220, -2223, -2226, -2228, -2231, -2233, -2235,
        -2240, -2237, -2234, -2242, -2242, -2240, -2245, -2248, -2253, -2254,
        -2261, -2266, -2267, -2271, -2276, -2272, -2270, -2271, -2271, -2277,
        -2285, -2285, -2295, -2295, -2298, -2298, -2298, -2304, -2298, -2308,
        -2312, -2313, -2318, -2321, -2318, -2319, -2321, -2323, -2317, -2326,
        -2330, -2328, -2338, -2340, -2348, -2353, -2355, -2361, -2357, -2358,
        -2363, -2360, -2354, -2363, -2363, -2367, -2370, -2375, -2382, -2385,
        -2388, -2386, -2387, -2391, -2391, -2394, -2398, -2404, -2408, -2412,
        -2416, -2416, -2419, -2427, -2427, -2430, -2435, -2434, -2434, -2439,
        -2433, -2429, -2429, -2432, -2433, -2439, -2443, -2444, -2447, -2449,
        -2451, -2449, -2452, -2454, -2456, -2460, -2462, -2468, -2468, -2475,
        -2478, -2481, -2492, -2495, -2499, -2500, -2509, -2506, -2506, -2512,
        -2507, -2512, -2514, -2516, -2517, -2519, -2526, -2525, -2530, -2535,
        -2539, -2541, -2546, -2549, -2546, -2549, -2548, -2544, -2546, -2548,
        -2550, -2555, -2560, -2569, -2565, -2568, -2570, -2565, -2571, -2573,
        -2572, -2575, -2579, -2579, -2587, -2593, -2590, -2597, -2601, -2605,
        -2607, -2609, -2611, -2608, -2608, -2610, -2612, -2620, -2618, -2622,
        -2625, -2627, -2633, -2640, -2648, -2649, -2655, -2653, -2658, -2661,
        -2660, -2662, -2665, -2667, -2670, -2675, -2677, -2683, -2689, -2685,
        -2692, -2694, -2690, -2692, -2696, -2690, -2696, -2695, -2693, -2703,
        -2705, -2711, -2711, -2714, -2721, -2725, -2726, -2730, -2737, -2736,
        -2735, -2738, -2738, -2740, -2743, -2745, -2745, -2753, -2752, -2750,
        -2753, -2750, -2755, -2757, -2755, -2763, -2768, -2774, -2778, -2783,
        -2789, -2791, -2790, -2792, -2797, -2792, -2798, -2795, -2792, -2798,
        -2796, -2797, -2798, -2798, -2805, -2815, -2820, -2826, -2837, -2842,
        -2839, -2842, -2843, -2844, -2844, -2847, -2845, -2844, -2846, -2851,
        -2855, -2861, -2865, -2871, -2864, -2867, -2871, -2867, -2872, -2873,
        -2876, -2876, -2880, -2878, -2878, -2881, -2878, -2879, -2885, -2890,
        -2895, -2902, -2899, -2899, -2902, -2900, -2902, -2910, -2917, -2924,
        -2930, -2933, -2935, -2935, -2932, -2935, -2937, -2939, -2941, -2943,
        -2944, -2943, -2944, -2942, -2947, -2943, -2942, -2948, -2944, -2949,
        -2957, -2964, -2970, -2975, -2982, -2982, -2986, -2993, -2993, -2995,
        -2993, -2993, -2996, -3003, -3006, -3013, -3015, -3016, -3015, -3016,
        -3014, -3017, -3008, -3010, -3007, -3002, -3010, -3017, -3024, -3030,
        -3036, -3032, -3034, -3037, -3032, -3037, -3042, -3048, -3053, -3056,
        -3057, -3053, -3060, -3054, -3055, -3061, -3068, -3075, -3078, -3072,
        -3073, -3073, -3066, -3067, -3070, -3075, -3081, -3086, -3088, -3091,
        -3092, -3092, -3097, -3099, -3096, -3099, -3101, -3102, -3103, -3112,
        -3113, -3116, -3123, -3121, -3116, -3119, -3124, -3121, -3125, -3127,
        -3128, -3130, -3135, -3136, -3131, -3138, -3139, -3141, -3133, -3134,
        -3132, -3132, -3137, -3138, -3144, -3148, -3149, -3152, -3153, -3157,
        -3159, -3160, -3157, -3160, -3160, -3165, -3171, -3176, -3183, -3186,
        -3189, -3190, -3194, -3195, -3197, -3197, -3197, -3194, -3194, -3194,
        -3193, -3193, -3193, -3189, -3191, -3194, -3198, -3199, -3199, -3203,
        -3204, -3206, -3211, -3206, -3212, -3207, -3208, -3208, -3208, -3213,
        -3213, -3216, -3222, -3222, -3227, -3229, -3229, -3229, -3229, -3229,
        -3229, -3233, -3237, -3242, -3247, -3247, -3240, -3237, -3240, -3240,
        -3232, -3232, -3234, -3237, -3238, -3238, -3238, -3238, -3238, -3238,
        -3244, -3252, -3257, -3262, -3265, -3268, -3273, -3281, -3287, -3289,
        -3292, -3296, -3296, -3296, -3296, -3296, -3301, -3301, -3301, -3301,
        -3301, -3291, -3295, -3298, -3298, -3300, -3295, -3295, -3290, -3287,
        -3290, -3290, -3292, -3290, -3298, -3295, -3295, -3300, -3295, -3293,
        -3291, -3296, -3296, -3298, -3295, -3292, -3289, -3289, -3289, -3290,
        -3291, -3297, -3298, -3296, -3304, -3296, -3297, -3295, -3295, -3299,
        -3300, -3308, -3313, -3320, -3325, -3326, -3326, -3328, -3328, -3325,
        -3319, -3316, -3319, -3320, -3322, -3326, -3323, -3323, -3328, -3323,
        -3325, -3332, -3334, -3340, -3344, -3349, -3348, -3344, -3343, -3342,
        -3338, -3338, -3339, -3338, -3339, -3342, -3337, -3342, -3348, -3345,
        -3343, -3340, -3338, -3336, -3337, -3342, -3342, -3350, -3351, -3355,
        -3355, -3353, -3355, -3355, -3360, -3360, -3365, -3369, -3369, -3371,
        -3369, -3372, -3370, -3370, -3370, -3370, -3370, -3370, -3371, -3374,
        -3378, -3378, -3373, -3376, -3374, -3368, -3370, -3371, -3374, -3376,
        -3379, -3384, -3384, -3387, -3390, -3390, -3391, -3390, -3390, -3391,
        -3391, -3390, -3388, -3390, -3390, -3386, -3385, -3386, -3388, -3383,
        -3385, -3382, -3378, -3379, -3381, -3379, -3387, -3386, -3385, -3390,
        -3390, -3390, -3386, -3385, -3387, -3381, -3378, -3381, -3383, -3388,
        -3394, -3390, -3399, -3400, -3399, -3395, -3398, -3400, -3400, -3400,
        -3399, -3399, -3397, -3393, -3390, -3392, -3392, -3395, -3401, -3403,
        -3402, -3408, -3405, -3401, -3397, -3401, -3395, -3393, -3396, -3390,
        -3393, -3393, -3393, -3397, -3399, -3394, -3397, -3392, -3395, -3390,
        -3393, -3397, -3390, -3397, -3395, -3395, -3397, -3397, -3399, -3397,
        -3397, -3399, -3400, -3401, -3400, -3401, -3400, -3402, -3401, -3400,
        -3406, -3400, -3402, -3402, -3398, -3398, -3396, -3397, -3396, -3395,
        -3399, -3397, -3394, -3392, -3392, -3390, -3387, -3389, -3389, -3391,
        -3391, -3399, -3399, -3397, -3397, -3395, -3395, -3395, -3395, -3395,
        -3395, -3395, -3395, -3395, -3398, -3397, -3398, -3398, -3395, -3395,
        -3395, -3395, -3395, -3395, -3395, -3395, -3395, -3395, -3395, -3395,
        -3395, -3395, -3395, -3404, -3406, -3412, -3416, -3413, -3410, -3410,
        -3410, -3407, -3407, -3405, -3403, -3398, -3404, -3406, -3406, -3416,
        -3416, -3416, -3416, -3416, -3416, -3419, -3421, -3421, -3421, -3425,
        -3422, -3419, -3414, -3407, -3406, -3408, -3408, -3412, -3414, -3416,
        -3416, -3418, -3416, -3423, -3425, -3424, -3425, -3423, -3420, -3419,
        -3417, -3412, -3412, -3414, -3414, -3422, -3425, -3430, -3426, -3423,
        -3420, -3418, -3414, -3413, -3411, -3408, -3414, -3407, -3414, -3424,
        -3425, -3423, -3424, -3424, -3419, -3413, -3411, -3406, -3408, -3409,
        -3408, -3407, -3410, -3414, -3416, -3415, -3419, -3421, -3421, -3420,
        -3422, -3421, -3421, -3422, -3422, -3417, -3412, -3412, -3409, -3409,
        -3409, -3408, -3409, -3408, -3400, -3403, -3402, -3402, -3409, -3405,
        -3410, -3412, -3412, -3412, -3411, -3410, -3404, -3399, -3402, -3400,
        -3399, -3400, -3402, -3402, -3398, -3396, -3394, -3396, -3387, -3392,
        -3395, -3393, -3392, -3395, -3397, -3398, -3397, -3393, -3393, -3386,
        -3383, -3378, -3371, -3375, -3375, -3370, -3369, -3368, -3368, -3366,
        -3365, -3361, -3357, -3359, -3354, -3354, -3353, -3350, -3351, -3353,
        -3355, -3353, -3351, -3342, -3337, -3335, -3331, -3329, -3324, -3322,
        -3317, -3313, -3317, -3318, -3318, -3317, -3319, -3326, -3320, -3324,
        -3326, -3317, -3318, -3315, -3309, -3305, -3300, -3291, -3284, -3284,
        -3283, -3274, -3277, -3279, -3274, -3267, -3270, -3270, -3270, -3267,
        -3265, -3267, -3257, -3246, -3246, -3239, -3233, -3229, -3225, -3218,
        -3217, -3211, -3211, -3212, -3207, -3204, -3208, -3206, -3203, -3202,
        -3194, -3194, -3189, -3183, -3186, -3184, -3181, -3177, -3172, -3166,
        -3160, -3150, -3143, -3141, -3134, -3128, -3125, -3124, -3121, -3118,
        -3110, -3104, -3104, -3094, -3094, -3088, -3078, -3072, -3062, -3052,
        -3044, -3041, -3037, -3037, -3037, -3027, -3024, -3017, -3009, -3009,
        -3004, -3000, -2996, -2999, -2987, -2982, -2975, -2972, -2963, -2957,
        -2950, -2943, -2940, -2932, -2931, -2923, -2916, -2913, -2907, -2895,
        -2894, -2888, -2878, -2867, -2856, -2849, -2842, -2830, -2826, -2826,
        -2819, -2816, -2809, -2798, -2793, -2786, -2776, -2775
    };

    static const int16_t iso226_2003_curve_60_phons[1382] =
    {
        -1087, -1085, -1085, -1082,
        -1082, -1082, -1083, -1083, -1082, -1086, -1082, -1087, -1090, -1087,
        -1094, -1103, -1103, -1103, -1106, -1103, -1103, -1108, -1108, -1103,
        -1108, -1108, -1107, -1104, -1104, -1113, -1113, -1116, -1120, -1126,
        -1121, -1125, -1131, -1124, -1124, -1129, -1124, -1124, -1124, -1130,
        -1134, -1134, -1139, -1136, -1140, -1146, -1150, -1151, -1153, -1154,
        -1153, -1148, -1145, -1145, -1148, -1147, -1148, -1155, -1150, -1150,
        -1159, -1162, -1165, -1166, -1171, -1172, -1175, -1175, -1175, -1171,
        -1167, -1169, -1172, -1175, -1171, -1176, -1172, -1171, -1177, -1182,
        -1182, -1189, -1192, -1192, -1190, -1187, -1194, -1193, -1190, -1195,
        -1192, -1187, -1190, -1194, -1192, -1193, -1202, -1203, -1203, -1207,
        -1214, -1218, -1218, -1218, -1218, -1219, -1223, -1224, -1228, -1234,
        -1237, -1239, -1239, -1239, -1237, -1233, -1237, -1244, -1244, -1245,
        -1246, -1253, -1254, -1250, -1253, -1260, -1259, -1254, -1260, -1260,
        -1260, -1260, -1256, -1260, -1260, -1259, -1256, -1264, -1266, -1271,
        -1275, -1276, -1279, -1274, -1277, -1281, -1281, -1274, -1281, -1281,
        -1281, -1279, -1281, -1281, -1281, -1281, -1289, -1294, -1297, -1297,
        -1296, -1297, -1296, -1300, -1302, -1296, -1301, -1302, -1302, -1304,
        -1308, -1313, -1320, -1323, -1329, -1323, -1323, -1323, -1323, -1322,
        -1323, -1323, -1320, -1322, -1323, -1323, -1320, -1334, -1337, -1344,
        -1353, -1355, -1362, -1367, -1365, -1365, -1365, -1361, -1364, -1365,
        -1364, -1367, -1364, -1367, -1367, -1365, -1365, -1375, -1367, -1366,
        -1372, -1381, -1381, -1388, -1391, -1391, -1382, -1386, -1386, -1387,
        -1387, -1383, -1391, -1392, -1392, -1401, -1403, -1403, -1407, -1408,
        -1408, -1408, -1410, -1412, -1408, -1407, -1407, -1407, -1408, -1413,
        -1419, -1425, -1429, -1438, -1428, -1428, -1434, -1438, -1435, -1440,
        -1446, -1444, -1444, -1444, -1434, -1428, -1429, -1426, -1428, -1428,
        -1437, -1439, -1436, -1444, -1449, -1449, -1450, -1450, -1450, -1459,
        -1460, -1455, -1465, -1470, -1469, -1470, -1471, -1474, -1475, -1484,
        -1486, -1491, -1491, -1491, -1496, -1492, -1497, -1502, -1498, -1502,
        -1497, -1498, -1502, -1507, -1509, -1509, -1514, -1515, -1519, -1519,
        -1517, -1518, -1517, -1512, -1517, -1517, -1512, -1515, -1513, -1514,
        -1522, -1523, -1528, -1533, -1533, -1539, -1539, -1539, -1539, -1539,
        -1544, -1543, -1535, -1544, -1544, -1543, -1546, -1549, -1556, -1560,
        -1565, -1568, -1570, -1575, -1575, -1571, -1569, -1565, -1565, -1570,
        -1572, -1571, -1581, -1581, -1581, -1581, -1581, -1590, -1582, -1591,
        -1596, -1600, -1602, -1605, -1602, -1602, -1604, -1606, -1598, -1607,
        -1606, -1602, -1612, -1612, -1617, -1622, -1622, -1627, -1623, -1623,
        -1628, -1627, -1619, -1628, -1628, -1631, -1633, -1640, -1647, -1649,
        -1654, -1649, -1647, -1649, -1649, -1651, -1654, -1660, -1662, -1665,
        -1670, -1665, -1667, -1675, -1674, -1676, -1681, -1680, -1681, -1685,
        -1680, -1675, -1676, -1680, -1680, -1685, -1690, -1691, -1691, -1691,
        -1691, -1686, -1689, -1688, -1688, -1691, -1691, -1695, -1696, -1701,
        -1706, -1707, -1721, -1721, -1727, -1728, -1737, -1735, -1733, -1739,
        -1733, -1737, -1738, -1738, -1738, -1738, -1745, -1740, -1749, -1754,
        -1754, -1754, -1758, -1759, -1754, -1759, -1754, -1750, -1754, -1754,
        -1756, -1762, -1768, -1779, -1775, -1775, -1780, -1775, -1780, -1779,
        -1776, -1776, -1780, -1780, -1785, -1790, -1791, -1796, -1796, -1797,
        -1798, -1801, -1801, -1796, -1797, -1797, -1801, -1811, -1806, -1812,
        -1817, -1817, -1822, -1832, -1837, -1838, -1844, -1838, -1839, -1843,
        -1838, -1838, -1838, -1838, -1843, -1844, -1846, -1854, -1862, -1854,
        -1863, -1867, -1861, -1865, -1869, -1862, -1869, -1869, -1865, -1874,
        -1874, -1880, -1880, -1881, -1885, -1885, -1885, -1886, -1890, -1887,
        -1887, -1890, -1891, -1890, -1896, -1898, -1896, -1906, -1905, -1901,
        -1902, -1901, -1906, -1909, -1906, -1911, -1919, -1922, -1922, -1929,
        -1932, -1930, -1927, -1928, -1932, -1926, -1932, -1927, -1927, -1932,
        -1931, -1932, -1932, -1932, -1938, -1948, -1953, -1959, -1969, -1974,
        -1970, -1974, -1976, -1979, -1974, -1974, -1974, -1969, -1971, -1975,
        -1980, -1985, -1990, -1995, -1987, -1995, -1995, -1990, -1995, -1994,
        -1995, -1990, -1995, -1992, -1990, -1995, -1990, -1991, -1998, -2003,
        -2008, -2016, -2013, -2011, -2016, -2012, -2012, -2022, -2026, -2032,
        -2038, -2038, -2042, -2042, -2037, -2037, -2037, -2037, -2037, -2038,
        -2037, -2038, -2037, -2038, -2041, -2039, -2037, -2042, -2038, -2043,
        -2048, -2053, -2058, -2059, -2069, -2069, -2070, -2079, -2078, -2080,
        -2079, -2079, -2082, -2090, -2090, -2099, -2101, -2101, -2101, -2100,
        -2101, -2099, -2090, -2090, -2085, -2080, -2085, -2090, -2095, -2100,
        -2104, -2101, -2101, -2105, -2100, -2106, -2111, -2116, -2121, -2123,
        -2125, -2121, -2126, -2122, -2122, -2128, -2136, -2140, -2142, -2136,
        -2132, -2132, -2125, -2121, -2127, -2132, -2137, -2142, -2142, -2142,
        -2142, -2142, -2142, -2147, -2144, -2147, -2151, -2152, -2153, -2161,
        -2163, -2164, -2173, -2169, -2165, -2170, -2173, -2169, -2169, -2169,
        -2169, -2169, -2177, -2179, -2174, -2184, -2184, -2184, -2174, -2173,
        -2169, -2172, -2174, -2174, -2184, -2184, -2184, -2184, -2184, -2184,
        -2188, -2190, -2184, -2190, -2190, -2195, -2200, -2205, -2211, -2216,
        -2221, -2218, -2226, -2226, -2226, -2226, -2226, -2221, -2221, -2221,
        -2216, -2216, -2215, -2213, -2216, -2222, -2226, -2226, -2226, -2226,
        -2226, -2226, -2232, -2227, -2232, -2226, -2226, -2226, -2226, -2232,
        -2232, -2237, -2242, -2242, -2247, -2247, -2247, -2247, -2247, -2247,
        -2247, -2251, -2253, -2257, -2263, -2263, -2256, -2253, -2258, -2256,
        -2248, -2247, -2247, -2247, -2247, -2247, -2247, -2247, -2247, -2247,
        -2258, -2263, -2268, -2274, -2279, -2279, -2284, -2295, -2300, -2300,
        -2305, -2305, -2305, -2305, -2305, -2305, -2311, -2311, -2311, -2311,
        -2311, -2300, -2300, -2300, -2300, -2300, -2295, -2295, -2290, -2289,
        -2295, -2295, -2295, -2290, -2300, -2295, -2295, -2300, -2300, -2300,
        -2300, -2305, -2305, -2305, -2300, -2295, -2289, -2289, -2289, -2290,
        -2291, -2295, -2292, -2292, -2300, -2289, -2295, -2295, -2295, -2302,
        -2300, -2311, -2313, -2320, -2325, -2321, -2321, -2321, -2321, -2321,
        -2316, -2312, -2316, -2316, -2316, -2321, -2317, -2314, -2321, -2316,
        -2316, -2324, -2327, -2332, -2336, -2342, -2337, -2331, -2332, -2326,
        -2321, -2322, -2321, -2320, -2321, -2326, -2323, -2326, -2336, -2336,
        -2331, -2327, -2322, -2316, -2316, -2321, -2321, -2329, -2332, -2337,
        -2337, -2337, -2337, -2337, -2342, -2337, -2342, -2345, -2342, -2345,
        -2342, -2347, -2343, -2342, -2342, -2342, -2342, -2342, -2346, -2351,
        -2358, -2360, -2353, -2353, -2351, -2343, -2342, -2342, -2342, -2342,
        -2343, -2352, -2353, -2358, -2363, -2363, -2364, -2363, -2363, -2363,
        -2363, -2363, -2360, -2363, -2362, -2358, -2358, -2358, -2358, -2353,
        -2353, -2347, -2346, -2342, -2347, -2348, -2357, -2359, -2358, -2363,
        -2363, -2363, -2358, -2357, -2357, -2347, -2342, -2346, -2346, -2351,
        -2357, -2353, -2362, -2363, -2363, -2362, -2364, -2364, -2364, -2364,
        -2362, -2363, -2363, -2363, -2356, -2362, -2363, -2367, -2373, -2373,
        -2374, -2379, -2374, -2368, -2365, -2369, -2363, -2363, -2366, -2363,
        -2363, -2365, -2363, -2363, -2367, -2361, -2366, -2361, -2363, -2358,
        -2359, -2363, -2353, -2362, -2359, -2358, -2363, -2363, -2367, -2363,
        -2363, -2366, -2363, -2367, -2366, -2367, -2366, -2363, -2367, -2363,
        -2366, -2364, -2363, -2363, -2360, -2360, -2358, -2363, -2359, -2356,
        -2363, -2358, -2358, -2358, -2358, -2358, -2353, -2353, -2353, -2353,
        -2353, -2358, -2362, -2358, -2363, -2363, -2363, -2363, -2363, -2363,
        -2363, -2363, -2363, -2363, -2363, -2363, -2364, -2363, -2363, -2363,
        -2363, -2363, -2363, -2363, -2363, -2363, -2363, -2363, -2363, -2363,
        -2363, -2363, -2363, -2372, -2374, -2380, -2384, -2379, -2374, -2374,
        -2373, -2368, -2368, -2368, -2368, -2363, -2372, -2374, -2374, -2383,
        -2384, -2384, -2384, -2384, -2384, -2386, -2384, -2384, -2381, -2384,
        -2379, -2373, -2368, -2360, -2358, -2363, -2368, -2373, -2379, -2384,
        -2382, -2384, -2379, -2385, -2388, -2388, -2384, -2384, -2379, -2376,
        -2377, -2368, -2365, -2368, -2369, -2379, -2380, -2389, -2383, -2384,
        -2379, -2379, -2373, -2373, -2368, -2363, -2368, -2359, -2368, -2378,
        -2379, -2377, -2379, -2379, -2373, -2367, -2364, -2359, -2362, -2363,
        -2363, -2363, -2368, -2373, -2379, -2378, -2381, -2384, -2384, -2384,
        -2385, -2384, -2384, -2385, -2382, -2374, -2368, -2368, -2366, -2363,
        -2363, -2363, -2363, -2362, -2354, -2363, -2363, -2363, -2372, -2368,
        -2374, -2373, -2374, -2374, -2374, -2374, -2364, -2359, -2363, -2363,
        -2364, -2363, -2363, -2363, -2363, -2361, -2359, -2362, -2353, -2362,
        -2363, -2361, -2360, -2363, -2363, -2363, -2363, -2363, -2363, -2358,
        -2355, -2349, -2344, -2347, -2347, -2342, -2342, -2342, -2342, -2341,
        -2338, -2333, -2332, -2332, -2327, -2326, -2326, -2325, -2327, -2329,
        -2332, -2331, -2330, -2323, -2316, -2316, -2313, -2311, -2306, -2306,
        -2299, -2295, -2302, -2300, -2300, -2299, -2301, -2311, -2306, -2310,
        -2315, -2309, -2311, -2311, -2304, -2300, -2296, -2289, -2285, -2284,
        -2283, -2274, -2278, -2279, -2274, -2270, -2275, -2280, -2279, -2279,
        -2279, -2278, -2269, -2256, -2258, -2248, -2242, -2241, -2234, -2232,
        -2231, -2226, -2227, -2230, -2227, -2226, -2232, -2231, -2231, -2232,
        -2222, -2222, -2221, -2212, -2216, -2216, -2216, -2216, -2210, -2205,
        -2200, -2190, -2184, -2184, -2179, -2174, -2174, -2174, -2174, -2174,
        -2168, -2163, -2163, -2154, -2153, -2148, -2137, -2132, -2121, -2111,
        -2104, -2105, -2100, -2102, -2105, -2095, -2095, -2090, -2085, -2089,
        -2080, -2079, -2080, -2084, -2074, -2068, -2064, -2063, -2056, -2053,
        -2052, -2043, -2043, -2037, -2036, -2027, -2020, -2016, -2011, -2002,
        -2001, -1998, -1990, -1984, -1974, -1970, -1965, -1956, -1955, -1952,
        -1946, -1946, -1941, -1931, -1928, -1922, -1916, -1916
    };

    static const int16_t iso226_2003_curve_70_phons[1382] =
    {
        -614, -613, -614, -611,
        -611, -612, -612, -612, -611, -614, -611, -614, -616, -615,
        -618, -624, -623, -623, -625, -623, -623, -626, -626, -623,
        -626, -626, -626, -624, -624, -629, -629, -631, -633, -636,
        -634, -636, -640, -635, -635, -638, -635, -635, -635, -638,
        -641, -641, -644, -642, -644, -647, -650, -651, -652, -652,
        -652, -649, -647, -647, -649, -648, -649, -653, -650, -650,
        -655, -657, -658, -659, -662, -663, -664, -664, -664, -662,
        -660, -661, -663, -664, -662, -665, -662, -662, -665, -668,
        -668, -672, -674, -674, -672, -671, -675, -674, -673, -675,
        -674, -671, -672, -675, -674, -674, -679, -680, -680, -682,
        -686, -688, -689, -689, -689, -689, -691, -692, -694, -697,
        -699, -700, -700, -700, -699, -697, -699, -703, -703, -703,
        -704, -708, -709, -706, -708, -712, -712, -709, -712, -712,
        -712, -712, -710, -712, -712, -712, -710, -715, -715, -718,
        -721, -721, -723, -720, -722, -724, -724, -720, -724, -724,
        -724, -723, -724, -724, -724, -724, -729, -732, -733, -733,
        -733, -733, -732, -735, -736, -732, -736, -736, -736, -737,
        -739, -742, -746, -748, -751, -748, -748, -748, -748, -747,
        -748, -748, -746, -747, -748, -748, -746, -754, -756, -760,
        -765, -766, -770, -772, -772, -772, -772, -769, -771, -771,
        -771, -773, -771, -773, -773, -772, -772, -777, -773, -772,
        -775, -781, -781, -785, -786, -786, -781, -784, -783, -784,
        -784, -782, -786, -787, -787, -792, -793, -793, -795, -796,
        -796, -796, -797, -798, -796, -795, -795, -795, -796, -799,
        -802, -806, -808, -813, -807, -807, -811, -813, -811, -814,
        -817, -816, -816, -816, -810, -807, -808, -806, -807, -807,
        -812, -813, -812, -816, -819, -819, -819, -819, -820, -825,
        -825, -822, -828, -831, -830, -831, -831, -833, -834, -839,
        -840, -843, -843, -843, -846, -843, -846, -849, -846, -849,
        -846, -847, -849, -852, -853, -853, -855, -857, -858, -858,
        -858, -858, -858, -855, -857, -858, -855, -856, -855, -856,
        -860, -861, -863, -867, -867, -870, -870, -870, -870, -870,
        -873, -872, -868, -873, -873, -872, -874, -876, -880, -882,
        -884, -886, -887, -890, -890, -888, -887, -885, -885, -887,
        -889, -888, -893, -893, -893, -894, -894, -899, -894, -899,
        -902, -904, -905, -907, -906, -905, -907, -908, -903, -908,
        -908, -905, -911, -911, -914, -917, -917, -919, -917, -917,
        -920, -919, -915, -920, -920, -922, -923, -927, -931, -932,
        -935, -932, -931, -932, -932, -933, -935, -938, -939, -941,
        -944, -941, -942, -947, -946, -947, -950, -950, -950, -953,
        -950, -947, -947, -950, -950, -953, -955, -956, -956, -956,
        -956, -953, -954, -954, -954, -956, -956, -958, -959, -962,
        -964, -965, -972, -973, -976, -977, -982, -981, -979, -983,
        -980, -982, -982, -982, -982, -982, -986, -984, -988, -991,
        -991, -991, -994, -994, -991, -994, -991, -989, -991, -991,
        -993, -996, -999, -1005, -1003, -1003, -1006, -1003, -1006, -1006,
        -1004, -1004, -1006, -1006, -1009, -1012, -1012, -1015, -1015, -1016,
        -1016, -1018, -1018, -1015, -1016, -1016, -1018, -1024, -1021, -1024,
        -1027, -1027, -1030, -1035, -1038, -1039, -1042, -1039, -1039, -1042,
        -1039, -1039, -1039, -1039, -1042, -1042, -1043, -1048, -1052, -1048,
        -1053, -1055, -1052, -1054, -1057, -1052, -1056, -1056, -1054, -1059,
        -1059, -1062, -1063, -1063, -1066, -1066, -1066, -1066, -1068, -1067,
        -1067, -1068, -1069, -1068, -1071, -1073, -1072, -1077, -1077, -1075,
        -1075, -1074, -1077, -1079, -1077, -1080, -1085, -1086, -1086, -1090,
        -1092, -1091, -1089, -1090, -1092, -1089, -1092, -1089, -1089, -1092,
        -1091, -1092, -1092, -1092, -1095, -1101, -1104, -1107, -1113, -1116,
        -1114, -1116, -1117, -1118, -1116, -1116, -1116, -1113, -1114, -1116,
        -1119, -1122, -1125, -1128, -1123, -1128, -1128, -1125, -1128, -1127,
        -1127, -1125, -1128, -1126, -1125, -1128, -1125, -1126, -1129, -1132,
        -1135, -1140, -1138, -1137, -1140, -1137, -1137, -1143, -1145, -1149,
        -1152, -1152, -1154, -1154, -1152, -1152, -1152, -1152, -1152, -1152,
        -1152, -1152, -1152, -1152, -1154, -1153, -1152, -1154, -1152, -1155,
        -1158, -1161, -1163, -1164, -1169, -1169, -1170, -1175, -1174, -1176,
        -1175, -1175, -1177, -1181, -1181, -1186, -1187, -1187, -1187, -1187,
        -1187, -1187, -1182, -1181, -1178, -1176, -1179, -1181, -1184, -1187,
        -1189, -1187, -1187, -1190, -1187, -1190, -1193, -1196, -1199, -1200,
        -1201, -1199, -1202, -1199, -1199, -1203, -1207, -1210, -1211, -1207,
        -1205, -1205, -1201, -1199, -1202, -1205, -1208, -1211, -1211, -1211,
        -1211, -1211, -1211, -1214, -1212, -1214, -1216, -1216, -1217, -1222,
        -1223, -1223, -1228, -1226, -1223, -1226, -1228, -1226, -1226, -1226,
        -1226, -1226, -1231, -1232, -1229, -1234, -1235, -1235, -1229, -1228,
        -1226, -1228, -1229, -1229, -1234, -1235, -1235, -1235, -1235, -1235,
        -1237, -1238, -1235, -1238, -1238, -1241, -1244, -1247, -1250, -1253,
        -1255, -1254, -1258, -1258, -1258, -1258, -1258, -1255, -1255, -1255,
        -1253, -1253, -1252, -1251, -1253, -1256, -1258, -1258, -1258, -1258,
        -1258, -1258, -1261, -1258, -1261, -1258, -1258, -1258, -1258, -1261,
        -1261, -1264, -1267, -1267, -1270, -1270, -1270, -1270, -1270, -1270,
        -1270, -1272, -1273, -1276, -1279, -1279, -1275, -1273, -1276, -1275,
        -1270, -1270, -1270, -1270, -1270, -1270, -1270, -1270, -1270, -1270,
        -1276, -1279, -1282, -1285, -1288, -1288, -1291, -1297, -1300, -1300,
        -1303, -1303, -1303, -1303, -1303, -1303, -1306, -1306, -1306, -1306,
        -1306, -1300, -1300, -1300, -1300, -1300, -1297, -1297, -1294, -1294,
        -1297, -1297, -1297, -1294, -1300, -1297, -1297, -1300, -1300, -1300,
        -1300, -1303, -1303, -1303, -1300, -1297, -1294, -1294, -1294, -1294,
        -1295, -1297, -1296, -1295, -1300, -1294, -1297, -1297, -1297, -1301,
        -1300, -1306, -1307, -1312, -1314, -1312, -1312, -1312, -1312, -1312,
        -1309, -1307, -1309, -1309, -1309, -1312, -1309, -1308, -1312, -1309,
        -1309, -1313, -1315, -1318, -1320, -1324, -1321, -1318, -1318, -1315,
        -1312, -1313, -1312, -1311, -1312, -1315, -1313, -1315, -1321, -1320,
        -1318, -1315, -1313, -1309, -1309, -1312, -1312, -1317, -1318, -1321,
        -1321, -1321, -1321, -1321, -1324, -1321, -1324, -1325, -1324, -1326,
        -1324, -1326, -1324, -1324, -1324, -1324, -1324, -1324, -1326, -1329,
        -1333, -1334, -1330, -1330, -1329, -1324, -1324, -1324, -1324, -1324,
        -1324, -1330, -1330, -1333, -1336, -1336, -1336, -1336, -1336, -1336,
        -1336, -1336, -1334, -1335, -1335, -1333, -1333, -1333, -1333, -1330,
        -1330, -1327, -1326, -1324, -1327, -1327, -1332, -1333, -1333, -1336,
        -1336, -1336, -1333, -1332, -1332, -1327, -1324, -1326, -1326, -1329,
        -1332, -1330, -1335, -1336, -1336, -1335, -1336, -1336, -1336, -1336,
        -1335, -1336, -1336, -1336, -1332, -1335, -1336, -1338, -1341, -1341,
        -1342, -1344, -1342, -1339, -1337, -1339, -1336, -1336, -1337, -1336,
        -1336, -1337, -1336, -1336, -1338, -1334, -1337, -1335, -1336, -1333,
        -1333, -1335, -1330, -1335, -1333, -1333, -1336, -1336, -1338, -1336,
        -1336, -1337, -1336, -1338, -1337, -1338, -1337, -1336, -1338, -1336,
        -1337, -1336, -1336, -1336, -1334, -1334, -1333, -1335, -1333, -1332,
        -1336, -1333, -1333, -1333, -1333, -1333, -1330, -1330, -1330, -1330,
        -1330, -1333, -1335, -1333, -1336, -1336, -1336, -1336, -1336, -1336,
        -1336, -1336, -1336, -1336, -1336, -1336, -1336, -1336, -1336, -1336,
        -1336, -1336, -1336, -1336, -1336, -1336, -1336, -1336, -1336, -1336,
        -1336, -1336, -1336, -1341, -1342, -1345, -1347, -1345, -1342, -1342,
        -1341, -1339, -1339, -1339, -1339, -1336, -1340, -1342, -1342, -1347,
        -1347, -1347, -1347, -1347, -1347, -1348, -1348, -1347, -1346, -1347,
        -1345, -1341, -1339, -1334, -1333, -1336, -1339, -1342, -1345, -1347,
        -1346, -1347, -1345, -1348, -1350, -1350, -1347, -1348, -1345, -1343,
        -1344, -1339, -1337, -1339, -1339, -1345, -1345, -1350, -1347, -1347,
        -1345, -1345, -1341, -1341, -1338, -1336, -1339, -1333, -1339, -1344,
        -1345, -1344, -1344, -1344, -1341, -1338, -1336, -1334, -1335, -1336,
        -1335, -1336, -1339, -1341, -1345, -1344, -1346, -1348, -1347, -1347,
        -1348, -1348, -1348, -1348, -1347, -1342, -1339, -1339, -1337, -1336,
        -1336, -1335, -1336, -1335, -1331, -1336, -1336, -1336, -1341, -1339,
        -1342, -1341, -1342, -1342, -1342, -1342, -1336, -1333, -1336, -1336,
        -1336, -1336, -1336, -1336, -1336, -1335, -1333, -1335, -1330, -1335,
        -1336, -1334, -1334, -1335, -1335, -1336, -1336, -1336, -1336, -1333,
        -1331, -1327, -1325, -1326, -1327, -1324, -1324, -1324, -1324, -1323,
        -1321, -1319, -1318, -1318, -1315, -1315, -1315, -1314, -1315, -1317,
        -1318, -1318, -1317, -1313, -1309, -1309, -1307, -1306, -1303, -1303,
        -1299, -1297, -1301, -1300, -1300, -1300, -1300, -1306, -1303, -1306,
        -1308, -1305, -1306, -1306, -1302, -1300, -1297, -1294, -1291, -1291,
        -1290, -1285, -1288, -1288, -1285, -1283, -1286, -1288, -1288, -1288,
        -1288, -1288, -1282, -1275, -1276, -1271, -1267, -1267, -1263, -1262,
        -1261, -1258, -1259, -1260, -1259, -1258, -1261, -1261, -1261, -1261,
        -1256, -1256, -1255, -1250, -1252, -1252, -1252, -1252, -1249, -1246,
        -1243, -1238, -1235, -1235, -1232, -1229, -1229, -1229, -1229, -1229,
        -1225, -1223, -1222, -1217, -1217, -1214, -1208, -1205, -1199, -1193,
        -1189, -1190, -1187, -1188, -1190, -1184, -1184, -1181, -1178, -1181,
        -1176, -1175, -1176, -1178, -1172, -1169, -1166, -1166, -1162, -1160,
        -1160, -1155, -1155, -1152, -1151, -1146, -1142, -1140, -1137, -1131,
        -1131, -1129, -1125, -1121, -1116, -1114, -1111, -1105, -1105, -1103,
        -1100, -1100, -1097, -1091, -1090, -1087, -1083, -1083
    };

    static const int16_t iso226_2003_curve_80_phons[1382] =
    {
        -142, -142, -142, -141,
        -141, -141, -141, -141, -141, -142, -141, -142, -142, -142,
        -143, -144, -144, -144, -144, -144, -144, -145, -144, -144,
        -145, -145, -144, -144, -144, -145, -145, -146, -146, -147,
        -146, -147, -148, -147, -147, -147, -147, -147, -147, -147,
        -148, -148, -149, -148, -149, -149, -150, -150, -150, -151,
        -150, -150, -149, -149, -150, -150, -150, -151, -150, -150,
        -151, -152, -152, -152, -153, -153, -153, -153, -153, -153,
        -152, -153, -153, -153, -153, -153, -153, -153, -154, -154,
        -154, -155, -155, -155, -155, -155, -156, -156, -155, -156,
        -155, -155, -155, -156, -155, -156, -157, -157, -157, -157,
        -158, -159, -159, -159, -159, -159, -160, -160, -160, -161,
        -161, -162, -162, -162, -161, -161, -161, -162, -162, -162,
        -163, -163, -164, -163, -163, -164, -164, -164, -164, -164,
        -164, -164, -164, -164, -164, -164, -164, -165, -165, -166,
        -166, -166, -167, -166, -167, -167, -167, -166, -167, -167,
        -167, -167, -167, -167, -167, -167, -168, -169, -169, -169,
        -169, -169, -169, -170, -170, -169, -170, -170, -170, -170,
        -171, -171, -172, -173, -173, -173, -173, -173, -173, -172,
        -173, -173, -172, -172, -173, -173, -172, -174, -174, -175,
        -176, -177, -178, -178, -178, -178, -178, -178, -178, -178,
        -178, -178, -178, -178, -178, -178, -178, -179, -178, -178,
        -179, -180, -180, -181, -181, -181, -180, -181, -181, -181,
        -181, -180, -181, -182, -182, -183, -183, -183, -184, -184,
        -184, -184, -184, -184, -184, -184, -184, -184, -184, -184,
        -185, -186, -186, -188, -186, -186, -187, -188, -187, -188,
        -189, -188, -188, -188, -187, -186, -186, -186, -186, -186,
        -187, -188, -187, -188, -189, -189, -189, -189, -189, -190,
        -190, -190, -191, -192, -192, -192, -192, -192, -192, -194,
        -194, -195, -195, -195, -195, -195, -195, -196, -195, -196,
        -195, -195, -196, -197, -197, -197, -197, -198, -198, -198,
        -198, -198, -198, -197, -198, -198, -197, -198, -197, -197,
        -199, -199, -199, -200, -200, -201, -201, -201, -201, -201,
        -201, -201, -200, -201, -201, -201, -202, -202, -203, -203,
        -204, -205, -205, -205, -205, -205, -205, -204, -204, -205,
        -205, -205, -206, -206, -206, -206, -206, -207, -206, -208,
        -208, -209, -209, -209, -209, -209, -209, -210, -208, -210,
        -209, -209, -210, -210, -211, -212, -212, -212, -212, -212,
        -212, -212, -211, -212, -212, -213, -213, -214, -215, -215,
        -216, -215, -215, -215, -215, -215, -216, -216, -217, -217,
        -218, -217, -217, -218, -218, -219, -219, -219, -219, -220,
        -219, -218, -219, -219, -219, -220, -220, -221, -221, -221,
        -221, -220, -220, -220, -220, -221, -221, -221, -221, -222,
        -223, -223, -224, -224, -225, -225, -227, -226, -226, -227,
        -226, -227, -227, -227, -227, -227, -228, -227, -228, -229,
        -229, -229, -229, -229, -229, -229, -229, -228, -229, -229,
        -229, -230, -231, -232, -232, -232, -232, -232, -232, -232,
        -232, -232, -232, -232, -233, -233, -234, -234, -234, -234,
        -235, -235, -235, -234, -234, -234, -235, -236, -236, -236,
        -237, -237, -238, -239, -240, -240, -241, -240, -240, -240,
        -240, -240, -240, -240, -240, -240, -241, -242, -243, -242,
        -243, -244, -243, -243, -244, -243, -244, -244, -243, -244,
        -244, -245, -245, -245, -246, -246, -246, -246, -247, -246,
        -246, -247, -247, -247, -247, -248, -247, -249, -248, -248,
        -248, -248, -249, -249, -249, -249, -250, -251, -251, -252,
        -252, -252, -251, -251, -252, -251, -252, -251, -251, -252,
        -252, -252, -252, -252, -253, -254, -255, -255, -257, -258,
        -257, -258, -258, -258, -258, -258, -258, -257, -257, -258,
        -258, -259, -260, -260, -259, -260, -260, -260, -260, -260,
        -260, -260, -260, -260, -260, -260, -260, -260, -261, -261,
        -262, -263, -263, -262, -263, -262, -262, -264, -264, -265,
        -266, -266, -266, -266, -266, -266, -266, -266, -266, -266,
        -266, -266, -266, -266, -266, -266, -266, -266, -266, -266,
        -267, -268, -268, -269, -270, -270, -270, -271, -271, -271,
        -271, -271, -272, -273, -273, -274, -274, -274, -274, -274,
        -274, -274, -273, -273, -272, -271, -272, -273, -273, -274,
        -274, -274, -274, -275, -274, -275, -275, -276, -277, -277,
        -277, -277, -277, -277, -277, -278, -279, -279, -279, -279,
        -278, -278, -277, -277, -277, -278, -279, -279, -279, -279,
        -279, -279, -279, -280, -280, -280, -281, -281, -281, -282,
        -282, -282, -283, -283, -282, -283, -283, -283, -283, -283,
        -283, -283, -284, -284, -284, -285, -285, -285, -284, -283,
        -283, -283, -284, -284, -285, -285, -285, -285, -285, -285,
        -285, -286, -285, -286, -286, -286, -287, -288, -288, -289,
        -290, -289, -290, -290, -290, -290, -290, -290, -290, -290,
        -289, -289, -289, -289, -289, -290, -290, -290, -290, -290,
        -290, -290, -291, -290, -291, -290, -290, -290, -290, -291,
        -291, -292, -292, -292, -293, -293, -293, -293, -293, -293,
        -293, -294, -294, -294, -295, -295, -294, -294, -295, -294,
        -293, -293, -293, -293, -293, -293, -293, -293, -293, -293,
        -295, -295, -296, -297, -297, -297, -298, -299, -300, -300,
        -301, -301, -301, -301, -301, -301, -301, -301, -301, -301,
        -301, -300, -300, -300, -300, -300, -299, -299, -299, -299,
        -299, -299, -299, -299, -300, -299, -299, -300, -300, -300,
        -300, -301, -301, -301, -300, -299, -299, -299, -299, -299,
        -299, -299, -299, -299, -300, -299, -299, -299, -299, -300,
        -300, -301, -302, -303, -303, -303, -303, -303, -303, -303,
        -302, -302, -302, -302, -302, -303, -302, -302, -303, -302,
        -302, -303, -303, -304, -305, -305, -305, -304, -304, -303,
        -303, -303, -303, -303, -303, -303, -303, -303, -305, -305,
        -304, -303, -303, -302, -302, -303, -303, -304, -304, -305,
        -305, -305, -305, -305, -305, -305, -305, -306, -305, -306,
        -306, -306, -306, -306, -306, -306, -306, -306, -306, -307,
        -308, -308, -307, -307, -307, -306, -306, -306, -306, -306,
        -306, -307, -307, -308, -308, -308, -308, -308, -308, -308,
        -308, -308, -308, -308, -308, -308, -308, -308, -308, -307,
        -307, -306, -306, -306, -306, -306, -307, -308, -308, -308,
        -308, -308, -308, -307, -307, -306, -305, -306, -306, -307,
        -307, -307, -308, -308, -308, -308, -308, -308, -308, -308,
        -308, -308, -308, -308, -307, -308, -308, -309, -310, -310,
        -310, -310, -310, -309, -308, -309, -308, -308, -309, -308,
        -308, -308, -308, -308, -309, -308, -309, -308, -308, -308,
        -308, -308, -307, -308, -308, -308, -308, -308, -309, -308,
        -308, -309, -308, -309, -309, -309, -309, -308, -309, -308,
        -309, -308, -308, -308, -308, -308, -308, -308, -308, -307,
        -308, -308, -308, -308, -308, -308, -307, -307, -307, -307,
        -307, -308, -308, -308, -308, -308, -308, -308, -308, -308,
        -308, -308, -308, -308, -308, -308, -308, -308, -308, -308,
        -308, -308, -308, -308, -308, -308, -308, -308, -308, -308,
        -308, -308, -308, -309, -310, -310, -311, -310, -310, -310,
        -310, -309, -309, -309, -309, -308, -309, -310, -310, -311,
        -311, -311, -311, -311, -311, -311, -311, -311, -311, -311,
        -310, -310, -309, -308, -308, -308, -309, -310, -310, -311,
        -311, -311, -310, -311, -311, -311, -311, -311, -310, -310,
        -310, -309, -309, -309, -309, -310, -310, -312, -311, -311,
        -310, -310, -310, -310, -309, -308, -309, -308, -309, -310,
        -310, -310, -310, -310, -310, -309, -308, -308, -308, -308,
        -308, -308, -309, -310, -310, -310, -311, -311, -311, -311,
        -311, -311, -311, -311, -311, -310, -309, -309, -309, -308,
        -308, -308, -308, -308, -307, -308, -308, -308, -309, -309,
        -310, -310, -310, -310, -310, -310, -308, -308, -308, -308,
        -308, -308, -308, -308, -308, -308, -308, -308, -307, -308,
        -308, -308, -308, -308, -308, -308, -308, -308, -308, -308,
        -307, -306, -306, -306, -306, -305, -305, -306, -305, -305,
        -305, -304, -304, -304, -304, -303, -303, -303, -303, -304,
        -304, -304, -304, -303, -302, -302, -302, -301, -301, -301,
        -300, -299, -300, -300, -300, -300, -300, -301, -301, -301,
        -302, -301, -301, -301, -301, -300, -299, -299, -298, -298,
        -298, -297, -297, -297, -297, -296, -297, -297, -297, -297,
        -297, -297, -296, -294, -294, -293, -292, -292, -291, -291,
        -291, -290, -291, -291, -291, -290, -291, -291, -291, -291,
        -290, -290, -290, -288, -289, -289, -289, -289, -288, -288,
        -287, -286, -285, -285, -284, -284, -284, -284, -284, -284,
        -283, -282, -282, -281, -281, -280, -279, -278, -277, -275,
        -274, -275, -274, -274, -275, -273, -273, -273, -272, -273,
        -271, -271, -271, -272, -271, -270, -269, -269, -268, -268,
        -268, -266, -266, -266, -266, -264, -263, -263, -262, -261,
        -261, -261, -260, -259, -258, -257, -256, -255, -255, -255,
        -254, -254, -253, -252, -251, -251, -250, -250
    };

    static const int16_t iso226_2003_curve_90_phons[1382] =
    {
        331, 330, 330, 329,
        329, 329, 330, 329, 329, 331, 329, 331, 332, 331,
        333, 336, 336, 336, 337, 336, 336, 337, 337, 336,
        337, 337, 337, 336, 336, 339, 339, 340, 341, 343,
        341, 342, 344, 342, 342, 344, 342, 342, 342, 344,
        345, 345, 347, 346, 347, 349, 350, 350, 351, 351,
        351, 349, 349, 349, 349, 349, 349, 351, 350, 350,
        353, 354, 355, 355, 356, 357, 358, 358, 358, 357,
        355, 356, 357, 358, 356, 358, 357, 356, 358, 360,
        360, 362, 363, 363, 362, 361, 363, 363, 362, 364,
        363, 361, 362, 363, 363, 363, 366, 366, 366, 367,
        370, 371, 371, 371, 371, 371, 372, 373, 374, 375,
        376, 377, 377, 377, 376, 375, 377, 379, 379, 379,
        379, 381, 382, 380, 381, 384, 383, 382, 384, 384,
        384, 384, 382, 383, 384, 383, 382, 385, 385, 387,
        388, 388, 389, 388, 389, 390, 390, 388, 390, 390,
        390, 389, 390, 390, 390, 390, 392, 394, 395, 395,
        395, 395, 394, 396, 396, 394, 396, 396, 396, 397,
        398, 400, 402, 403, 404, 403, 403, 403, 403, 402,
        403, 403, 402, 402, 403, 403, 402, 406, 407, 409,
        412, 412, 415, 416, 415, 416, 415, 414, 415, 415,
        415, 416, 415, 416, 416, 416, 416, 418, 416, 416,
        417, 420, 420, 422, 423, 423, 421, 422, 422, 422,
        422, 421, 423, 424, 424, 426, 427, 427, 428, 429,
        428, 428, 429, 430, 429, 428, 428, 428, 429, 430,
        432, 434, 435, 438, 435, 435, 437, 438, 437, 438,
        440, 439, 439, 439, 436, 435, 435, 434, 434, 435,
        437, 438, 437, 439, 441, 441, 441, 441, 441, 444,
        444, 443, 446, 448, 447, 447, 448, 448, 449, 452,
        452, 454, 454, 454, 455, 454, 455, 457, 456, 457,
        456, 456, 457, 459, 459, 459, 461, 461, 462, 462,
        462, 462, 462, 460, 462, 462, 460, 461, 460, 461,
        463, 464, 465, 467, 467, 468, 468, 469, 468, 468,
        470, 470, 467, 470, 470, 470, 471, 472, 474, 475,
        476, 477, 478, 479, 479, 478, 477, 476, 476, 478,
        479, 478, 481, 481, 481, 481, 481, 484, 481, 484,
        486, 487, 487, 488, 488, 488, 488, 489, 486, 489,
        489, 488, 491, 491, 492, 494, 494, 495, 494, 494,
        495, 495, 493, 495, 495, 497, 497, 499, 501, 502,
        503, 502, 501, 502, 502, 502, 503, 505, 506, 507,
        508, 507, 507, 510, 509, 510, 512, 511, 511, 513,
        511, 510, 510, 511, 511, 513, 514, 515, 515, 515,
        515, 513, 514, 514, 514, 515, 515, 516, 516, 518,
        519, 520, 524, 524, 526, 526, 529, 528, 527, 529,
        528, 529, 529, 529, 529, 529, 531, 530, 532, 534,
        534, 534, 535, 535, 534, 535, 534, 533, 534, 534,
        535, 536, 538, 541, 540, 540, 542, 540, 542, 541,
        540, 541, 542, 542, 543, 545, 545, 546, 547, 547,
        547, 548, 548, 547, 547, 547, 548, 551, 550, 551,
        553, 553, 555, 558, 559, 559, 561, 559, 560, 561,
        559, 559, 559, 559, 561, 561, 562, 564, 567, 564,
        567, 568, 566, 567, 569, 567, 569, 569, 568, 570,
        570, 572, 572, 572, 574, 574, 574, 574, 575, 574,
        574, 575, 575, 575, 577, 578, 577, 580, 580, 579,
        579, 579, 580, 581, 580, 582, 584, 585, 585, 587,
        588, 587, 587, 587, 588, 586, 588, 587, 587, 588,
        588, 588, 588, 588, 590, 593, 594, 596, 599, 601,
        600, 601, 601, 602, 601, 601, 601, 599, 600, 601,
        603, 604, 606, 607, 605, 607, 607, 606, 607, 607,
        607, 606, 607, 606, 606, 607, 606, 606, 608, 610,
        611, 614, 613, 612, 614, 612, 612, 615, 617, 618,
        620, 620, 621, 622, 620, 620, 620, 620, 620, 620,
        620, 620, 620, 620, 621, 621, 620, 621, 620, 622,
        623, 625, 626, 627, 630, 630, 630, 633, 632, 633,
        633, 633, 634, 636, 636, 639, 639, 639, 639, 639,
        639, 639, 636, 636, 635, 633, 635, 636, 638, 639,
        640, 639, 639, 641, 639, 641, 642, 644, 646, 646,
        647, 646, 647, 646, 646, 648, 650, 651, 652, 650,
        649, 649, 647, 646, 647, 649, 650, 652, 652, 652,
        652, 652, 652, 653, 653, 653, 655, 655, 655, 658,
        658, 659, 661, 660, 659, 660, 661, 660, 660, 660,
        660, 660, 663, 663, 662, 665, 665, 665, 662, 661,
        660, 661, 662, 662, 665, 665, 665, 665, 665, 665,
        666, 667, 665, 666, 667, 668, 670, 671, 673, 674,
        676, 675, 678, 678, 678, 678, 678, 676, 676, 676,
        674, 674, 674, 674, 675, 676, 678, 678, 678, 678,
        678, 678, 679, 678, 679, 678, 678, 678, 678, 679,
        679, 681, 682, 682, 684, 684, 684, 684, 684, 684,
        684, 685, 686, 687, 689, 689, 687, 686, 687, 687,
        684, 684, 684, 684, 684, 684, 684, 684, 684, 684,
        687, 689, 690, 692, 694, 694, 695, 698, 700, 700,
        702, 702, 702, 702, 702, 702, 703, 703, 703, 703,
        703, 700, 700, 700, 700, 700, 698, 698, 697, 697,
        698, 698, 698, 697, 700, 698, 698, 700, 700, 700,
        700, 702, 702, 702, 700, 698, 697, 697, 697, 697,
        697, 698, 698, 697, 700, 697, 698, 698, 698, 701,
        700, 703, 704, 706, 708, 706, 706, 706, 706, 706,
        705, 704, 705, 705, 705, 706, 705, 704, 706, 705,
        705, 707, 708, 710, 711, 713, 711, 710, 710, 708,
        707, 707, 706, 706, 706, 708, 707, 708, 711, 711,
        710, 708, 707, 705, 705, 706, 706, 709, 710, 711,
        711, 711, 711, 711, 713, 711, 713, 714, 713, 714,
        713, 714, 713, 713, 713, 713, 713, 713, 714, 716,
        718, 718, 716, 716, 716, 713, 713, 713, 713, 713,
        713, 716, 716, 718, 719, 719, 719, 719, 719, 719,
        719, 719, 718, 719, 719, 718, 718, 718, 718, 716,
        716, 714, 714, 713, 714, 715, 717, 718, 718, 719,
        719, 719, 718, 717, 717, 714, 713, 714, 714, 715,
        717, 716, 719, 719, 719, 719, 719, 719, 719, 719,
        719, 719, 719, 719, 717, 719, 719, 720, 722, 722,
        723, 724, 722, 721, 720, 721, 719, 719, 720, 719,
        719, 720, 719, 719, 721, 719, 720, 719, 719, 718,
        718, 719, 716, 719, 718, 718, 719, 719, 721, 719,
        719, 720, 719, 720, 720, 720, 720, 719, 720, 719,
        720, 719, 719, 719, 718, 718, 718, 719, 718, 717,
        719, 718, 718, 718, 718, 718, 716, 716, 716, 716,
        716, 718, 719, 718, 719, 719, 719, 719, 719, 719,
        719, 719, 719, 719, 719, 719, 719, 719, 719, 719,
        719, 719, 719, 719, 719, 719, 719, 719, 719, 719,
        719, 719, 719, 722, 723, 724, 726, 724, 722, 722,
        722, 721, 721, 721, 721, 719, 722, 722, 723, 725,
        726, 726, 726, 726, 726, 726, 726, 725, 725, 726,
        724, 722, 721, 718, 718, 719, 721, 722, 724, 726,
        725, 725, 724, 726, 727, 727, 726, 726, 724, 723,
        724, 721, 720, 721, 721, 724, 724, 727, 725, 726,
        724, 724, 722, 722, 721, 719, 721, 718, 721, 724,
        724, 723, 724, 724, 722, 720, 719, 718, 719, 719,
        719, 719, 721, 722, 724, 724, 725, 726, 726, 725,
        726, 726, 726, 726, 725, 723, 721, 721, 720, 719,
        719, 719, 719, 719, 717, 719, 719, 719, 722, 721,
        722, 722, 722, 722, 722, 722, 719, 718, 719, 719,
        719, 719, 719, 719, 719, 719, 718, 719, 716, 719,
        719, 718, 718, 719, 719, 719, 719, 719, 719, 718,
        717, 715, 713, 714, 714, 713, 713, 713, 713, 712,
        712, 710, 710, 710, 708, 708, 708, 708, 708, 709,
        710, 710, 709, 707, 705, 705, 704, 703, 702, 702,
        700, 698, 701, 700, 700, 700, 700, 703, 702, 703,
        705, 703, 703, 703, 701, 700, 699, 697, 695, 695,
        695, 692, 693, 694, 692, 691, 692, 694, 694, 694,
        694, 693, 690, 686, 687, 684, 682, 682, 680, 679,
        679, 678, 678, 679, 678, 678, 679, 679, 679, 679,
        676, 676, 676, 673, 674, 674, 674, 674, 673, 671,
        670, 666, 665, 665, 663, 662, 662, 662, 662, 662,
        660, 658, 658, 655, 655, 654, 650, 649, 646, 642,
        640, 641, 639, 640, 641, 638, 638, 636, 634, 636,
        633, 633, 633, 634, 631, 629, 628, 628, 626, 625,
        625, 622, 622, 620, 620, 617, 615, 614, 612, 609,
        609, 608, 606, 604, 601, 600, 598, 595, 595, 594,
        592, 592, 591, 588, 587, 585, 583, 583
    };

    static const int16_t * const iso226_2003_curves[] =
    {
        iso226_2003_curve_0_phons,
        iso226_2003_curve_10_phons,
        iso226_2003_curve_20_phons,
        iso226_2003_curve_30_phons,
        iso226_2003_curve_40_phons,
        iso226_2003_curve_50_phons,
        iso226_2003_curve_60_phons,
        iso226_2003_curve_70_phons,
        iso226_2003_curve_80_phons,
        iso226_2003_curve_90_phons
    };

    static const freq_curve_t iso226_2003_curve =
    {
        19.75, // fmin
        12719.18, // fmax
        0.00, // amin
        90.00, // amax
        1382, // hdots
        10, // curves
        iso226_2003_curves // curve data
    };
} /* namespace lsp */

#endif /* GENERATED_ISO226_ISO226_2003_H_ */
