use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name       => 'Ticket::Simple',
    license           => 'gpl2',
    dist_author       => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version      => '0.0.2',
    dist_abstract     => 'A basic ticket system',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    #    verbose            => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {

        'Test::Perl::Critic'  => 0,
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => {
        'Module::Build' => 0,

        'Test::More' => 0,
        'Test::Pod'  => '1.14',
    },

    requires => {
        'Carp'       => 0,
        'Class::Std' => '0.0.9',

        #'Contextual::Return' => 0,
        #'Date::Manip'   => 0,
        'Digest::MD5'   => 0,
        'Log::Log4perl' => 0,
        'Readonly'      => 0,
        'Time::HiRes'   => 0,
        'version'       => 0,

    },

    add_to_cleanup => ['Ticket-Simple-*'],
);

# BUILD target
#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->create_build_script();
