% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{estimate_t}
\alias{estimate_t}
\title{Find the most commonly occuring relative expression value in each cell}
\usage{
estimate_t(relative_expr_matrix, relative_expr_thresh = 0.1)
}
\arguments{
\item{relative_expr_matrix}{a matrix of relative expression values for 
values with each row and column representing genes/isoforms and cells, 
respectively. Row and column names should be included. 
Expression values should not be log-transformed.}

\item{relative_expr_thresh}{Relative expression values below this threshold 
are considered zero.}
}
\value{
an vector of most abundant relative_expr value corresponding to the 
RPC 1.
}
\description{
Converting relative expression values to mRNA copies per cell requires
knowing the most commonly occuring relative expression value in each cell
This value typically corresponds to an RPC value of 1. This function 
finds the most commonly occuring (log-transformed) relative expression value
for each column in the provided expression matrix.
}
\details{
This function estimates the most abundant relative expression value 
(t^*) using a gaussian kernel density function. It can also optionally 
output the t^* based on a two gaussian mixture model
based on the smsn.mixture from mixsmsn package
}
\examples{
\dontrun{
HSMM_fpkm_matrix <- exprs(HSMM)
t_estimate = estimate_t(HSMM_fpkm_matrix)
}
}
