% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensureVector.R
\name{ensureVector}
\alias{ensureVector}
\title{Blow up single scalars / objects to vectors /  list by replication}
\usage{
ensureVector(x, n = 1L, cl = NULL, names = NULL, ensure.list = FALSE)
}
\arguments{
\item{x}{[any]\cr
Input element.}

\item{n}{[\code{integer(1)}]\cr
Desired length.
Default is 1 (the most common case).}

\item{cl}{[\code{character}*]\cr
Only do the operation if \code{x} inherits from this one of these classes,
otherwise simply let \code{x} pass.
Default is \code{NULL} which means to always do the operation.}

\item{names}{[\code{character}*] \cr
Names for result.
Default is \code{NULL}, which means no names.}

\item{ensure.list}{[\code{logical(1)}]\cr
Should \code{x} be wrapped in a list in any case?
Default is \code{FALSE}, i.e., if \code{x} is a scalar value, a vector is
returned.}
}
\value{
Ether a vector or list of length \code{n} with replicated \code{x} or \code{x} unchanged..
}
\description{
Useful for standard argument conversion where a user can input a single
element, but this has to be replicated now n times for a resulting vector or list.
}
