% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopifnot_all_linter.R
\name{stopifnot_all_linter}
\alias{stopifnot_all_linter}
\title{Block usage of all() within stopifnot()}
\usage{
stopifnot_all_linter()
}
\description{
\code{stopifnot(A)} actually checks \code{all(A)} "under the hood" if \code{A} is a vector,
and produces a better error message than \code{stopifnot(all(A))} does.
}
\examples{
# will produce lints
lint(
  text = "stopifnot(all(x > 0))",
  linters = stopifnot_all_linter()
)

lint(
  text = "stopifnot(y > 3, all(x < 0))",
  linters = stopifnot_all_linter()
)

# okay
lint(
  text = "stopifnot(is.null(x) || all(x > 0))",
  linters = stopifnot_all_linter()
)

lint(
  text = "assert_that(all(x > 0))",
  linters = stopifnot_all_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=readability_linters]{readability}
}
