% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice}
\alias{splice}
\title{Splice objects and lists of objects into a list}
\usage{
splice(...)
}
\arguments{
\item{...}{Objects to concatenate.}
}
\value{
A list.
}
\description{
\Sexpr[results=rd, stage=render]{purrr:::lifecycle("questioning")}

This splices all arguments into a list. Non-list objects and lists
with a S3 class are encapsulated in a list before concatenation.
}
\section{Life cycle}{


\code{splice()} is in the questioning lifecycle stage as of purrr
0.3.0. We are now favouring the \verb{!!!} syntax enabled by
\code{\link[rlang:list2]{rlang::list2()}}.
}

\examples{
inputs <- list(arg1 = "a", arg2 = "b")

# splice() concatenates the elements of inputs with arg3
splice(inputs, arg3 = c("c1", "c2")) \%>\% str()
list(inputs, arg3 = c("c1", "c2")) \%>\% str()
c(inputs, arg3 = c("c1", "c2")) \%>\% str()
}
