use core:debug;

Int runFnPtr(fn(Int)->Int v) {
	v.call(10);
}

Int runFnPtr(fn->Int v) {
	v.call();
}

void consumeStr(fn(Str)->void v) {
	v.call("22");
}

Int consumeDbg(fn(Dbg)->Int v) {
	v.call(Dbg(23));
}

Int runStrFnPtr(fn(Str)->Str v) {
	Str z = v.call("22");
	z.toInt;
}

Int runFnPtr(fn(Int)->DbgVal v) {
	v.call(23).get;
}

Int runFnPtr(fn(Int)->Dbg v) {
	v.call(21).get;
}

Int addTen(Int v) {
	v + 10;
}

fn(Int)->Int createIntFn() {
	&addTen(Int);
}

DbgVal addTen(Dbg dbg) {
	DbgVal(dbg.get + 10);
}

DbgVal addDbg(Dbg a, Dbg b) {
	DbgVal(a.get + b.get);
}

fn(Dbg)->DbgVal createDbgFn(Int type) {
	if (type == 0) {
		&addTen(Dbg);
	} else if (type == 1) {
		Dbg z(20);
		&z.addDbg(Dbg);
	} else {
		&addTen(Dbg);
	}
}

DbgVal createDbgVal() {
	DbgVal(22);
}

fn->DbgVal createVoidFn(Int type) {
	if (type == 0) {
		Dbg z(20);
		&z.asDbgVal();
	} else if (type == 1) {
		DbgActor z(12);
		&z.asDbgVal();
	} else {
		&createDbgVal();
	}
}

DbgVal addDbgActor(DbgActor a, DbgActor b) {
	DbgVal(a.get + b.get);
}

DbgVal incDbgActor(DbgActor a) {
	DbgVal(a.get + 4);
}

fn(DbgActor)->DbgVal createActorFn(Int type) {
	if (type == 0) {
		DbgActor tmp(20);
		&tmp.addDbgActor(DbgActor);
	} else {
		&incDbgActor(DbgActor);
	}
}

// Counts how many copies have been made.
class CloneTrack extends Dbg {
	init(Int v) {
		init(v) {}
	}

	init(CloneTrack t) {
		init(t) {}
		set(get + 10000);
	}

	void deepCopy(CloneEnv env) {
		super:deepCopy(env);
		set(get + 100);
	}
}

// Create the tracker.
Dbg dbgTrack(Int v) {
	CloneTrack(v);
}

// Run a function pointer.
Int runPtr(fn(Dbg)->Int ptr, Dbg v) {
	ptr.call(v);
}

// Run a function pointer on another thread.
Int runPtrOther(fn(Dbg)->Int ptr, Dbg value) {
	runPtrOtherHelp(ptr, value);
}

Int runPtrOtherHelp(fn(Dbg)->Int ptr, Dbg value) on Other {
	ptr.call(value);
}

// Create various function pointers.
fn(Dbg)->Int trackParam(Int t) {
	if (t == 0) {
		// Normal function - no clones.
		&trackFree(Dbg);
	} else if (t == 1) {
		// Call to another thread - possibly clones.
		&trackOnOther(Dbg);
	} else if (t == 2) {
		// Call to another thread - possibly clones.
		&trackOnCompiler(Dbg);
	} else if (t == 3) {
		// Call to another thread - possibly clones.
		InActor actor(Other);
		&actor.trackInActor(Dbg);
	} else {
		// Call to another thread - possibly clones.
		InActor actor(Compiler);
		&actor.trackInActor(Dbg);
	}
}

// Actor.
fn(InActor, Dbg)->Int trackActor() {
	&InActor:trackInActor(InActor, Dbg);
}

InActor createInActor() {
	InActor(Other);
}

// C++ does not know of TObject, so we use TObject instead. It is ugly, but it works for testing.
Int runPtrActor(fn(TObject, Dbg)->Int fn, Dbg dbg) {
	fn.call(createInActor, dbg);
}

Int trackFree(Dbg v) {
	v.get;
}

Int trackOnOther(Dbg v) on Other {
	v.get;
}

Int trackOnCompiler(Dbg v) on Compiler {
	v.get;
}

class InActor on ? {
	init(Thread) {
		init() {}
	}

	Int trackInActor(Dbg v) {
		v.get;
	}
}

fn->Dbg dbgFnPtr() {
	&returnDbg();
}

Dbg returnDbg() on Other {
	CloneTrack(1);
}

Int callDbgFnPtr(fn->Dbg fn) {
	fn.call().get;
}

Bool returnBool1() {
	true;
}

Bool returnBool2() {
	false;
}

fn->Bool createBoolFn(Bool v) {
	if (v) {
		&returnBool1();
	} else {
		&returnBool2();
	}
}

Int runBoolFn(fn->Bool fn) {
	Bool z = false;
	z |= fn.call();
	if (z) {
		1;
	} else {
		0;
	}
}

Int autoFn() {
	runFnPtr(&addTen);
}

class PtrTest {
	Int z;

	init(Int v) {
		init() {
			z = v;
		}
	}

	Int doIt(Int v) {
		v + z;
	}
}

Int autoMemberFn() {
	PtrTest x(5);
	runFnPtr(&x.doIt);
}

Bool intPredicate(Int a, Int b) {
	a > b;
}

Int copyIntPredicate() {
	Fn<Bool, Int, Int> ptr = &intPredicate;

	Array<Int> data;
	data << 1 << 2 << 3;

	// This should always work:
	Int result = data.sorted(ptr)[0];

	Fn<Bool, Int, Int> copy(ptr);

	// This was broken previously:
	result += data.sorted(copy)[0];

	result;
}

fn()->DbgVal createCtorValuePtr() {
	return &DbgVal;
}

fn(Int)->Dbg createCtorClassPtr() {
	return &Dbg(Int);
}
fn()->Int createIntPtr() {
	return &Int;
}

void createOtherPtr() {
	var ptr = &ThreadObj();
	ptr.call();
}
void createDynActorPtr() {
	var ptr = &DynActor(Thread);
	ptr.call(Other);
}
