#pragma once
#include "Options.h"
#include "Image.h"

namespace graphics {

	/**
	 * PNG options.
	 */
	class PNGOptions : public FormatOptions {
		STORM_CLASS;
	public:
		// Create, default options.
		STORM_CTOR PNGOptions();

		// Load an image, set options.
		virtual Image *STORM_FN load(IStream *from);
		using FormatOptions::load;

		// Save an image according to options.
		virtual void STORM_FN save(Image *image, OStream *to);
		using FormatOptions::save;
	};


	// Create an ImageFormat. For internal use.
	ImageFormat *pngFormat(Engine &e);

}
