/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.MainPanel;
import WIMSchem.ds.DataWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MainWindow
extends JFrame {
    public MainPanel mainPanel = null;
    static String[] args;

    public MainWindow(String LoadFN, boolean StreamMode) {
        super("WIMSchem");
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new MainPanel(LoadFN, 0, this);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
        this.setIconImage(this.mainPanel.mainIcon.getImage());
    }

    public MainPanel mainPanel() {
        return this.mainPanel;
    }

    private static void createAndShowGUI() {
        boolean dump = false;
        boolean stream = false;
        ArrayList<String> openfiles = new ArrayList<String>();
        boolean dsmode = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                if (args[i].compareTo("-h") == 0 || args[i].compareTo("--help") == 0) {
                    dump = true;
                    break;
                }
                if (args[i].compareTo("-v") == 0 || args[i].compareTo("--version") == 0) {
                    dump = true;
                    break;
                }
                if (args[i].compareTo("-s") == 0 || args[i].compareTo("--stream") == 0) {
                    stream = true;
                    ++i;
                    continue;
                }
                if (args[i].compareTo("-m") == 0 || args[i].compareTo("--molecule") == 0) {
                    dsmode = false;
                    ++i;
                    continue;
                }
                if (args[i].compareTo("-d") == 0 || args[i].compareTo("--datasheet") == 0) {
                    dsmode = true;
                    ++i;
                    continue;
                }
                System.out.println("Error: unexpected argument:");
                System.out.println(args[i]);
                return;
            }
            File f = new File(args[i]);
            if (f.exists()) {
                openfiles.add(args[i]);
            } else {
                System.out.println("Warning: Filename [" + args[i] + "] does not exist.");
            }
            ++i;
        }
        if (stream && dsmode) {
            System.out.println("Invalid: stream mode cannot be combined with datasheet mode");
            return;
        }
        if (dump) {
            System.out.println("WIMSchem: Molecular drawing tool");
            System.out.println("          Version SketchEl 1.21 WIMSversion 0.2 SVG export \u00a9 2005-2013 Dr. Alex M. Clark");
            System.out.println("          Open source, released under the Gnu Public License (GPL),");
            System.out.println("          see www.gnu.org. For home page and documentation, see");
            System.out.println("          http://sketchel.sf.net\n");
            System.out.println("Command line parameters:");
            System.out.println(" -h|--help|-v|--version    Show parameters and summary info");
            System.out.println(" -s|--stream               Read from <stdin> at startup, write to");
            System.out.println(" -m|--molecule             Open in new Molecule mode");
            System.out.println(" -d|--datasheet            Open in new DataSheet mode");
            System.out.println("                           <stdout> on quit.");
            System.out.println(" filenames                 Open files on startup.");
        } else if (stream || openfiles.size() == 0) {
            if (!dsmode) {
                new MainWindow(null, stream).setVisible(true);
            } else {
                new DataWindow(null).setVisible(true);
            }
        } else {
            for (int n = 0; n < openfiles.size(); ++n) {
                if (!dsmode) {
                    new MainWindow((String)openfiles.get(n), false).setVisible(true);
                    continue;
                }
                new DataWindow((String)openfiles.get(n)).setVisible(true);
            }
        }
    }

    public static void main(String[] args) {
        MainWindow.args = args;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.createAndShowGUI();
            }
        });
    }
}

