/* $NetBSD: fdt_intr.h,v 1.8 2022/06/25 13:24:34 jmcneill Exp $ */

/*-
 * Copyright (c) 2017 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_FDT_INTR_H
#define _ARM_FDT_INTR_H

#define	ARM_IRQ_HANDLER		_C_LABEL(arm_fdt_irq_handler)
#define	ARM_FIQ_HANDLER		_C_LABEL(arm_fdt_fiq_handler)

#ifndef _LOCORE

#define	__HAVE_PIC_SET_PRIORITY
#define	__HAVE_PIC_PENDING_INTRS

#define	PIC_MAXSOURCES		8192
#define	PIC_MAXMAXSOURCES	(PIC_MAXSOURCES * 2 + 32)

void	arm_fdt_irq_set_handler(void (*)(void *));
void	arm_fdt_irq_handler(void *);
void	arm_fdt_fiq_set_handler(void (*)(void *));
void	arm_fdt_fiq_handler(void *);

#include <arm/pic/picvar.h>

#endif

#endif /* _ARM_FDT_INTR_H */
