/*	$NetBSD: udivsi3_i4i.S,v 1.2 2011/08/05 02:00:25 uwe Exp $	*/

/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)udivsi3.s	5.1 (Berkeley) 5/15/90
 */

#include <machine/asm.h>
#if defined(LIBC_SCCS)
	RCSID("$NetBSD: udivsi3_i4i.S,v 1.2 2011/08/05 02:00:25 uwe Exp $")
#endif

/*
 * IMPOTANT: This function is special.
 *
 * This function is an auxiliary "millicode" function that is
 * referenced by the code generated by gcc for unsigned integer
 * division.  But gcc does NOT treat a call to this function as an
 * ordinary function call - it can clobber only R1, MACL and MACH.
 *
 * See the definition of "udivsi3_i4_int" in gcc/config/sh/sh.md
 *
 * As the consequence this function cannot be called via any
 * indirection that assumes normal calling convention:
 *
 * . cannot have _PROF_PROLOGUE
 * . cannot be called via PLT (not relevant for kernel)
 *
 * XXX: uwe: Older gcc used __udivsi3; newer uses __udivsi3_i4i - a
 * heavily tuned version that is NOT compatible with __udivsi3 because
 * it clobbers different registers.  We don't want to link the kernel
 * against libgcc and we don't have resources to write heavily tuned
 * version ourselves, so clone __udivsi3 but adjust the code to
 * conform to the __udivsi3_i4i clobber spec.
 */


#ifdef __ELF__
	.hidden __udivsi3_i4i
#endif


/* r0 <= r4 / r5 */
NENTRY(__udivsi3_i4i)
	tst	r5, r5
	bt	.L_div_by_zero

	mov	r4, r1		! cannot clobber r4 in this version
	mov	#0, r0
	div0u
#define DIVSTEP	rotcl r1; div1 r5, r0
	/* repeat 32 times */
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
#undef DIVSTEP
	rotcl	r1

	rts
	 mov	r1, r0

.L_div_by_zero:
	rts
	 mov	#0, r0
