/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_REWIND},
	{623, PKT3_SET_CONFIG_REG},
	{638, PKT3_SET_CONTEXT_REG},
	{654, PKT3_SET_SH_REG},
	{665, PKT3_SET_SH_REG_OFFSET},
	{683, PKT3_SET_UCONFIG_REG},
	{699, PKT3_SET_UCONFIG_REG_INDEX},
	{721, PKT3_LOAD_CONST_RAM},
	{736, PKT3_WRITE_CONST_RAM},
	{752, PKT3_DUMP_CONST_RAM},
	{767, PKT3_INCREMENT_CE_COUNTER},
	{788, PKT3_INCREMENT_DE_COUNTER},
	{809, PKT3_WAIT_ON_CE_COUNTER},
	{828, PKT3_LOAD_CONTEXT_REG},
	{845, PKT3_IT_OPCODE_C},
	{857, PKT3_CP_DMA},
	{864, PKT3_DMA_DATA},
};

static const struct si_reg sid_reg_table[] = {
	{873, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{888, R_371_DST_ADDR_LO},
	{900, R_372_DST_ADDR_HI},
	{912, R_3F0_IB_BASE_LO},
	{923, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{934, R_410_CP_DMA_WORD0, 1, 9},
	{947, R_411_CP_DMA_WORD1, 5, 10},
	{960, R_412_CP_DMA_WORD2, 1, 15},
	{973, R_413_CP_DMA_WORD3, 1, 16},
	{986, R_414_COMMAND, 11, 17},
	{994, R_500_DMA_DATA_WORD0, 6, 28},
	{1009, R_501_SRC_ADDR_LO},
	{1021, R_502_SRC_ADDR_HI},
	{888, R_503_DST_ADDR_LO},
	{900, R_504_DST_ADDR_HI},
	{1033, R_000E4C_SRBM_STATUS2, 21, 34},
	{1046, R_000E50_SRBM_STATUS, 20, 55},
	{1058, R_000E54_SRBM_STATUS3, 16, 75},
	{1071, R_00D034_SDMA0_STATUS_REG, 29, 91},
	{1088, R_00D834_SDMA1_STATUS_REG, 29, 91},
	{1105, R_008008_GRBM_STATUS2, 18, 120},
	{1118, R_008010_GRBM_STATUS, 24, 138},
	{1130, R_00802C_GRBM_GFX_INDEX, 6, 162},
	{1145, R_0084FC_CP_STRMOUT_CNTL, 1, 168},
	{1161, R_0085F0_CP_COHER_CNTL, 19, 169},
	{1175, R_0085F4_CP_COHER_SIZE},
	{1189, R_0085F8_CP_COHER_BASE},
	{1203, R_008014_GRBM_STATUS_SE0, 11, 188},
	{1219, R_008018_GRBM_STATUS_SE1, 11, 199},
	{1235, R_008038_GRBM_STATUS_SE2, 11, 210},
	{1251, R_00803C_GRBM_STATUS_SE3, 11, 221},
	{1145, R_0300FC_CP_STRMOUT_CNTL, 1, 232},
	{1267, R_0301E4_CP_COHER_BASE_HI, 1, 233},
	{1284, R_0301EC_CP_COHER_START_DELAY, 1, 234},
	{1161, R_0301F0_CP_COHER_CNTL, 27, 235},
	{1175, R_0301F4_CP_COHER_SIZE},
	{1189, R_0301F8_CP_COHER_BASE},
	{1305, R_0301FC_CP_COHER_STATUS, 4, 262},
	{1321, R_008210_CP_CPC_STATUS, 15, 266},
	{1335, R_008214_CP_CPC_BUSY_STAT, 28, 281},
	{1352, R_008218_CP_CPC_STALLED_STAT1, 14, 309},
	{1373, R_00821C_CP_CPF_STATUS, 21, 323},
	{1387, R_008220_CP_CPF_BUSY_STAT, 31, 344},
	{1404, R_008224_CP_CPF_STALLED_STAT1, 9, 375},
	{1425, R_030230_CP_COHER_SIZE_HI, 1, 384},
	{1442, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 385},
	{1465, R_0088C4_VGT_CACHE_INVALIDATION, 3, 386},
	{1488, R_0088C8_VGT_ESGS_RING_SIZE},
	{1507, R_0088CC_VGT_GSVS_RING_SIZE},
	{1526, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 389},
	{1546, R_008958_VGT_PRIMITIVE_TYPE, 1, 390},
	{1565, R_00895C_VGT_INDEX_TYPE, 1, 391},
	{1580, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1613, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1646, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1679, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1712, R_008970_VGT_NUM_INDICES},
	{1728, R_008974_VGT_NUM_INSTANCES},
	{1746, R_008988_VGT_TF_RING_SIZE, 1, 392},
	{1763, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 393},
	{1784, R_0089B8_VGT_TF_MEMORY_BASE},
	{1803, R_008A14_PA_CL_ENHANCE, 4, 394},
	{1817, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 398},
	{1842, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 399},
	{1867, R_008670_CP_STALLED_STAT3, 19, 401},
	{1884, R_008674_CP_STALLED_STAT1, 16, 420},
	{1901, R_008678_CP_STALLED_STAT2, 29, 436},
	{1918, R_008680_CP_STAT, 23, 465},
	{1130, R_030800_GRBM_GFX_INDEX, 6, 488},
	{1488, R_030900_VGT_ESGS_RING_SIZE},
	{1507, R_030904_VGT_GSVS_RING_SIZE},
	{1546, R_030908_VGT_PRIMITIVE_TYPE, 1, 494},
	{1565, R_03090C_VGT_INDEX_TYPE, 1, 495},
	{1580, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1613, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1646, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1679, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1712, R_030930_VGT_NUM_INDICES},
	{1728, R_030934_VGT_NUM_INSTANCES},
	{1746, R_030938_VGT_TF_RING_SIZE, 1, 496},
	{1763, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 497},
	{1784, R_030940_VGT_TF_MEMORY_BASE},
	{1817, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 499},
	{1842, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 500},
	{1926, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 502},
	{1952, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 504},
	{1978, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 506},
	{2004, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 508},
	{2030, R_008BF0_PA_SC_ENHANCE, 9, 510},
	{2044, R_008C08_SQC_CACHES, 2, 519},
	{2044, R_030D20_SQC_CACHES, 3, 521},
	{2055, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 524},
	{2074, R_008DFC_SQ_EXP_0, 6, 527},
	{2083, R_030E00_TA_CS_BC_BASE_ADDR},
	{2102, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 533},
	{2124, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{2148, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 534},
	{2171, R_008F00_SQ_BUF_RSRC_WORD0},
	{2189, R_008F04_SQ_BUF_RSRC_WORD1, 4, 535},
	{2207, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{2231, R_008F08_SQ_BUF_RSRC_WORD2},
	{2249, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 539},
	{2272, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 540},
	{2290, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{2314, R_008F10_SQ_IMG_RSRC_WORD0},
	{2332, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 554},
	{2355, R_008F14_SQ_IMG_RSRC_WORD1, 5, 555},
	{2373, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{2397, R_008F18_SQ_IMG_RSRC_WORD2, 4, 560},
	{2415, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 564},
	{2438, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 565},
	{2456, R_008F20_SQ_IMG_RSRC_WORD4, 2, 576},
	{2474, R_008F24_SQ_IMG_RSRC_WORD5, 2, 578},
	{2492, R_008F28_SQ_IMG_RSRC_WORD6, 8, 580},
	{2510, R_008F2C_SQ_IMG_RSRC_WORD7},
	{2528, R_008F30_SQ_IMG_SAMP_WORD0, 14, 588},
	{2546, R_008F34_SQ_IMG_SAMP_WORD1, 4, 602},
	{2564, R_008F38_SQ_IMG_SAMP_WORD2, 10, 606},
	{2582, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 616},
	{2600, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 619},
	{2620, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 624},
	{2645, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 626},
	{2670, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 628},
	{2695, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 629},
	{2695, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 630},
	{2714, R_0090F0_SPI_ARB_PRIORITY, 3, 631},
	{2714, R_00C700_SPI_ARB_PRIORITY, 8, 634},
	{2731, R_0090F4_SPI_ARB_CYCLES_0, 2, 642},
	{2748, R_0090F8_SPI_ARB_CYCLES_1, 1, 644},
	{2765, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 645},
	{2787, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 646},
	{2809, R_030FF8_DB_ZPASS_COUNT_LOW},
	{2828, R_030FFC_DB_ZPASS_COUNT_HI, 1, 647},
	{2846, R_031074_GDS_OA_CNTL, 1, 648},
	{2858, R_031078_GDS_OA_COUNTER, 1, 649},
	{2873, R_03107C_GDS_OA_ADDRESS, 5, 650},
	{2888, R_031080_GDS_OA_INCDEC, 2, 655},
	{2902, R_031084_GDS_OA_RING_SIZE, 1, 657},
	{2919, R_009100_SPI_CONFIG_CNTL, 5, 658},
	{2935, R_00913C_SPI_CONFIG_CNTL_1, 5, 663},
	{2953, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 668},
	{2083, R_00950C_TA_CS_BC_BASE_ADDR},
	{2982, R_009858_DB_SUBTILE_CONTROL, 10, 680},
	{3001, R_0098F8_GB_ADDR_CONFIG, 9, 690},
	{3016, R_009910_GB_TILE_MODE0, 10, 699},
	{3030, R_009914_GB_TILE_MODE1, 10, 699},
	{3044, R_009918_GB_TILE_MODE2, 10, 699},
	{3058, R_00991C_GB_TILE_MODE3, 10, 699},
	{3072, R_009920_GB_TILE_MODE4, 10, 699},
	{3086, R_009924_GB_TILE_MODE5, 10, 699},
	{3100, R_009928_GB_TILE_MODE6, 10, 699},
	{3114, R_00992C_GB_TILE_MODE7, 10, 699},
	{3128, R_009930_GB_TILE_MODE8, 10, 699},
	{3142, R_009934_GB_TILE_MODE9, 10, 699},
	{3156, R_009938_GB_TILE_MODE10, 10, 699},
	{3171, R_00993C_GB_TILE_MODE11, 10, 699},
	{3186, R_009940_GB_TILE_MODE12, 10, 699},
	{3201, R_009944_GB_TILE_MODE13, 10, 699},
	{3216, R_009948_GB_TILE_MODE14, 10, 699},
	{3231, R_00994C_GB_TILE_MODE15, 10, 699},
	{3246, R_009950_GB_TILE_MODE16, 10, 699},
	{3261, R_009954_GB_TILE_MODE17, 10, 699},
	{3276, R_009958_GB_TILE_MODE18, 10, 699},
	{3291, R_00995C_GB_TILE_MODE19, 10, 699},
	{3306, R_009960_GB_TILE_MODE20, 10, 699},
	{3321, R_009964_GB_TILE_MODE21, 10, 699},
	{3336, R_009968_GB_TILE_MODE22, 10, 699},
	{3351, R_00996C_GB_TILE_MODE23, 10, 699},
	{3366, R_009970_GB_TILE_MODE24, 10, 699},
	{3381, R_009974_GB_TILE_MODE25, 10, 699},
	{3396, R_009978_GB_TILE_MODE26, 10, 699},
	{3411, R_00997C_GB_TILE_MODE27, 10, 699},
	{3426, R_009980_GB_TILE_MODE28, 10, 699},
	{3441, R_009984_GB_TILE_MODE29, 10, 699},
	{3456, R_009988_GB_TILE_MODE30, 10, 699},
	{3471, R_00998C_GB_TILE_MODE31, 10, 699},
	{3486, R_009990_GB_MACROTILE_MODE0, 4, 709},
	{3505, R_009994_GB_MACROTILE_MODE1, 4, 709},
	{3524, R_009998_GB_MACROTILE_MODE2, 4, 709},
	{3543, R_00999C_GB_MACROTILE_MODE3, 4, 709},
	{3562, R_0099A0_GB_MACROTILE_MODE4, 4, 709},
	{3581, R_0099A4_GB_MACROTILE_MODE5, 4, 709},
	{3600, R_0099A8_GB_MACROTILE_MODE6, 4, 709},
	{3619, R_0099AC_GB_MACROTILE_MODE7, 4, 709},
	{3638, R_0099B0_GB_MACROTILE_MODE8, 4, 709},
	{3657, R_0099B4_GB_MACROTILE_MODE9, 4, 709},
	{3676, R_0099B8_GB_MACROTILE_MODE10, 4, 709},
	{3696, R_0099BC_GB_MACROTILE_MODE11, 4, 709},
	{3716, R_0099C0_GB_MACROTILE_MODE12, 4, 709},
	{3736, R_0099C4_GB_MACROTILE_MODE13, 4, 709},
	{3756, R_0099C8_GB_MACROTILE_MODE14, 4, 709},
	{3776, R_0099CC_GB_MACROTILE_MODE15, 4, 709},
	{3796, R_00B000_SPI_SHADER_TBA_LO_PS},
	{3817, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 713},
	{3838, R_00B008_SPI_SHADER_TMA_LO_PS},
	{3859, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 714},
	{3880, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 715},
	{3904, R_00B020_SPI_SHADER_PGM_LO_PS},
	{3925, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 718},
	{3946, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 719},
	{3970, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 730},
	{3994, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{4020, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{4046, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{4072, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{4098, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{4124, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{4150, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{4176, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{4202, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{4228, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{4254, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{4281, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{4308, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{4335, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{4362, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{4389, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{4416, R_00B100_SPI_SHADER_TBA_LO_VS},
	{4437, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 737},
	{4458, R_00B108_SPI_SHADER_TMA_LO_VS},
	{4479, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 738},
	{4500, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 739},
	{4524, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 742},
	{4549, R_00B120_SPI_SHADER_PGM_LO_VS},
	{4570, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 743},
	{4591, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 744},
	{4615, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 756},
	{4639, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{4665, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{4691, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{4717, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{4743, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{4769, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{4795, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{4821, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{4847, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{4873, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{4899, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{4926, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{4953, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{4980, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{5007, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{5034, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{5061, R_00B200_SPI_SHADER_TBA_LO_GS},
	{5082, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 768},
	{5103, R_00B208_SPI_SHADER_TMA_LO_GS},
	{5124, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 769},
	{5145, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 770},
	{5169, R_00B220_SPI_SHADER_PGM_LO_GS},
	{5190, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 774},
	{5211, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 775},
	{5235, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 786},
	{5259, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{5285, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{5311, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{5337, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{5363, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{5389, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{5415, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{5441, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{5467, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{5493, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{5519, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{5546, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{5573, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{5600, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{5627, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{5654, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{5681, R_00B300_SPI_SHADER_TBA_LO_ES},
	{5702, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 791},
	{5723, R_00B308_SPI_SHADER_TMA_LO_ES},
	{5744, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 792},
	{5765, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 793},
	{5789, R_00B320_SPI_SHADER_PGM_LO_ES},
	{5810, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 797},
	{5831, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 798},
	{5855, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 810},
	{5879, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{5905, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{5931, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{5957, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{5983, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{6009, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{6035, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{6061, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{6087, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{6113, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{6139, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{6166, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{6193, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{6220, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{6247, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{6274, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{6301, R_00B400_SPI_SHADER_TBA_LO_HS},
	{6322, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 817},
	{6343, R_00B408_SPI_SHADER_TMA_LO_HS},
	{6364, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 818},
	{6385, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 819},
	{6409, R_00B420_SPI_SHADER_PGM_LO_HS},
	{6430, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 822},
	{6451, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 823},
	{6475, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 833},
	{6499, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{6525, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{6551, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{6577, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{6603, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{6629, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{6655, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{6681, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{6707, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{6733, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{6759, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{6786, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{6813, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{6840, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{6867, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{6894, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{6921, R_00B500_SPI_SHADER_TBA_LO_LS},
	{6942, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 840},
	{6963, R_00B508_SPI_SHADER_TMA_LO_LS},
	{6984, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 841},
	{7005, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 842},
	{7029, R_00B520_SPI_SHADER_PGM_LO_LS},
	{7050, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 846},
	{7071, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 847},
	{7095, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 858},
	{7119, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{7145, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{7171, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{7197, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{7223, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{7249, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{7275, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{7301, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{7327, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{7353, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{7379, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{7406, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{7433, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{7460, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{7487, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{7514, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{7541, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 864},
	{7568, R_00B804_COMPUTE_DIM_X},
	{7582, R_00B808_COMPUTE_DIM_Y},
	{7596, R_00B80C_COMPUTE_DIM_Z},
	{7610, R_00B810_COMPUTE_START_X},
	{7626, R_00B814_COMPUTE_START_Y},
	{7642, R_00B818_COMPUTE_START_Z},
	{7658, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 876},
	{7679, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 878},
	{7700, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 880},
	{7721, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 882},
	{7741, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 883},
	{7769, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 884},
	{7794, R_00B830_COMPUTE_PGM_LO},
	{7809, R_00B834_COMPUTE_PGM_HI, 2, 885},
	{7824, R_00B838_COMPUTE_TBA_LO},
	{7839, R_00B83C_COMPUTE_TBA_HI, 1, 887},
	{7854, R_00B840_COMPUTE_TMA_LO},
	{7869, R_00B844_COMPUTE_TMA_HI, 1, 888},
	{7884, R_00B848_COMPUTE_PGM_RSRC1, 10, 889},
	{7902, R_00B84C_COMPUTE_PGM_RSRC2, 11, 899},
	{7920, R_00B850_COMPUTE_VMID, 1, 910},
	{7933, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 911},
	{7957, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 918},
	{7988, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 920},
	{8019, R_00B860_COMPUTE_TMPRING_SIZE, 2, 922},
	{8040, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 924},
	{8071, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 926},
	{8102, R_00B86C_COMPUTE_RESTART_X},
	{8120, R_00B870_COMPUTE_RESTART_Y},
	{8138, R_00B874_COMPUTE_RESTART_Z},
	{8156, R_00B87C_COMPUTE_MISC_RESERVED, 5, 928},
	{8178, R_00B880_COMPUTE_DISPATCH_ID},
	{8198, R_00B884_COMPUTE_THREADGROUP_ID},
	{8221, R_00B888_COMPUTE_RELAUNCH, 3, 933},
	{8238, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{8267, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 936},
	{8296, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 937},
	{8325, R_00B900_COMPUTE_USER_DATA_0},
	{8345, R_00B904_COMPUTE_USER_DATA_1},
	{8365, R_00B908_COMPUTE_USER_DATA_2},
	{8385, R_00B90C_COMPUTE_USER_DATA_3},
	{8405, R_00B910_COMPUTE_USER_DATA_4},
	{8425, R_00B914_COMPUTE_USER_DATA_5},
	{8445, R_00B918_COMPUTE_USER_DATA_6},
	{8465, R_00B91C_COMPUTE_USER_DATA_7},
	{8485, R_00B920_COMPUTE_USER_DATA_8},
	{8505, R_00B924_COMPUTE_USER_DATA_9},
	{8525, R_00B928_COMPUTE_USER_DATA_10},
	{8546, R_00B92C_COMPUTE_USER_DATA_11},
	{8567, R_00B930_COMPUTE_USER_DATA_12},
	{8588, R_00B934_COMPUTE_USER_DATA_13},
	{8609, R_00B938_COMPUTE_USER_DATA_14},
	{8630, R_00B93C_COMPUTE_USER_DATA_15},
	{8651, R_00B9FC_COMPUTE_NOWHERE},
	{8667, R_034000_CPG_PERFCOUNTER1_LO},
	{8687, R_034004_CPG_PERFCOUNTER1_HI},
	{8707, R_034008_CPG_PERFCOUNTER0_LO},
	{8727, R_03400C_CPG_PERFCOUNTER0_HI},
	{8747, R_034010_CPC_PERFCOUNTER1_LO},
	{8767, R_034014_CPC_PERFCOUNTER1_HI},
	{8787, R_034018_CPC_PERFCOUNTER0_LO},
	{8807, R_03401C_CPC_PERFCOUNTER0_HI},
	{8827, R_034020_CPF_PERFCOUNTER1_LO},
	{8847, R_034024_CPF_PERFCOUNTER1_HI},
	{8867, R_034028_CPF_PERFCOUNTER0_LO},
	{8887, R_03402C_CPF_PERFCOUNTER0_HI},
	{8907, R_034100_GRBM_PERFCOUNTER0_LO},
	{8928, R_034104_GRBM_PERFCOUNTER0_HI},
	{8949, R_03410C_GRBM_PERFCOUNTER1_LO},
	{8970, R_034110_GRBM_PERFCOUNTER1_HI},
	{8991, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{9015, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{9039, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{9063, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{9087, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{9111, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{9135, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{9159, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{9183, R_034200_WD_PERFCOUNTER0_LO},
	{9202, R_034204_WD_PERFCOUNTER0_HI},
	{9221, R_034208_WD_PERFCOUNTER1_LO},
	{9240, R_03420C_WD_PERFCOUNTER1_HI},
	{9259, R_034210_WD_PERFCOUNTER2_LO},
	{9278, R_034214_WD_PERFCOUNTER2_HI},
	{9297, R_034218_WD_PERFCOUNTER3_LO},
	{9316, R_03421C_WD_PERFCOUNTER3_HI},
	{9335, R_034220_IA_PERFCOUNTER0_LO},
	{9354, R_034224_IA_PERFCOUNTER0_HI},
	{9373, R_034228_IA_PERFCOUNTER1_LO},
	{9392, R_03422C_IA_PERFCOUNTER1_HI},
	{9411, R_034230_IA_PERFCOUNTER2_LO},
	{9430, R_034234_IA_PERFCOUNTER2_HI},
	{9449, R_034238_IA_PERFCOUNTER3_LO},
	{9468, R_03423C_IA_PERFCOUNTER3_HI},
	{9487, R_034240_VGT_PERFCOUNTER0_LO},
	{9507, R_034244_VGT_PERFCOUNTER0_HI},
	{9527, R_034248_VGT_PERFCOUNTER1_LO},
	{9547, R_03424C_VGT_PERFCOUNTER1_HI},
	{9567, R_034250_VGT_PERFCOUNTER2_LO},
	{9587, R_034254_VGT_PERFCOUNTER2_HI},
	{9607, R_034258_VGT_PERFCOUNTER3_LO},
	{9627, R_03425C_VGT_PERFCOUNTER3_HI},
	{9647, R_034400_PA_SU_PERFCOUNTER0_LO},
	{9669, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 939},
	{9691, R_034408_PA_SU_PERFCOUNTER1_LO},
	{9713, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 939},
	{9735, R_034410_PA_SU_PERFCOUNTER2_LO},
	{9757, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 939},
	{9779, R_034418_PA_SU_PERFCOUNTER3_LO},
	{9801, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 939},
	{9823, R_034500_PA_SC_PERFCOUNTER0_LO},
	{9845, R_034504_PA_SC_PERFCOUNTER0_HI},
	{9867, R_034508_PA_SC_PERFCOUNTER1_LO},
	{9889, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{9911, R_034510_PA_SC_PERFCOUNTER2_LO},
	{9933, R_034514_PA_SC_PERFCOUNTER2_HI},
	{9955, R_034518_PA_SC_PERFCOUNTER3_LO},
	{9977, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{9999, R_034520_PA_SC_PERFCOUNTER4_LO},
	{10021, R_034524_PA_SC_PERFCOUNTER4_HI},
	{10043, R_034528_PA_SC_PERFCOUNTER5_LO},
	{10065, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{10087, R_034530_PA_SC_PERFCOUNTER6_LO},
	{10109, R_034534_PA_SC_PERFCOUNTER6_HI},
	{10131, R_034538_PA_SC_PERFCOUNTER7_LO},
	{10153, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{10175, R_034600_SPI_PERFCOUNTER0_HI},
	{10195, R_034604_SPI_PERFCOUNTER0_LO},
	{10215, R_034608_SPI_PERFCOUNTER1_HI},
	{10235, R_03460C_SPI_PERFCOUNTER1_LO},
	{10255, R_034610_SPI_PERFCOUNTER2_HI},
	{10275, R_034614_SPI_PERFCOUNTER2_LO},
	{10295, R_034618_SPI_PERFCOUNTER3_HI},
	{10315, R_03461C_SPI_PERFCOUNTER3_LO},
	{10335, R_034620_SPI_PERFCOUNTER4_HI},
	{10355, R_034624_SPI_PERFCOUNTER4_LO},
	{10375, R_034628_SPI_PERFCOUNTER5_HI},
	{10395, R_03462C_SPI_PERFCOUNTER5_LO},
	{10415, R_034700_SQ_PERFCOUNTER0_LO},
	{10434, R_034704_SQ_PERFCOUNTER0_HI},
	{10453, R_034708_SQ_PERFCOUNTER1_LO},
	{10472, R_03470C_SQ_PERFCOUNTER1_HI},
	{10491, R_034710_SQ_PERFCOUNTER2_LO},
	{10510, R_034714_SQ_PERFCOUNTER2_HI},
	{10529, R_034718_SQ_PERFCOUNTER3_LO},
	{10548, R_03471C_SQ_PERFCOUNTER3_HI},
	{10567, R_034720_SQ_PERFCOUNTER4_LO},
	{10586, R_034724_SQ_PERFCOUNTER4_HI},
	{10605, R_034728_SQ_PERFCOUNTER5_LO},
	{10624, R_03472C_SQ_PERFCOUNTER5_HI},
	{10643, R_034730_SQ_PERFCOUNTER6_LO},
	{10662, R_034734_SQ_PERFCOUNTER6_HI},
	{10681, R_034738_SQ_PERFCOUNTER7_LO},
	{10700, R_03473C_SQ_PERFCOUNTER7_HI},
	{10719, R_034740_SQ_PERFCOUNTER8_LO},
	{10738, R_034744_SQ_PERFCOUNTER8_HI},
	{10757, R_034748_SQ_PERFCOUNTER9_LO},
	{10776, R_03474C_SQ_PERFCOUNTER9_HI},
	{10795, R_034750_SQ_PERFCOUNTER10_LO},
	{10815, R_034754_SQ_PERFCOUNTER10_HI},
	{10835, R_034758_SQ_PERFCOUNTER11_LO},
	{10855, R_03475C_SQ_PERFCOUNTER11_HI},
	{10875, R_034760_SQ_PERFCOUNTER12_LO},
	{10895, R_034764_SQ_PERFCOUNTER12_HI},
	{10915, R_034768_SQ_PERFCOUNTER13_LO},
	{10935, R_03476C_SQ_PERFCOUNTER13_HI},
	{10955, R_034770_SQ_PERFCOUNTER14_LO},
	{10975, R_034774_SQ_PERFCOUNTER14_HI},
	{10995, R_034778_SQ_PERFCOUNTER15_LO},
	{11015, R_03477C_SQ_PERFCOUNTER15_HI},
	{11035, R_034900_SX_PERFCOUNTER0_LO},
	{11054, R_034904_SX_PERFCOUNTER0_HI},
	{11073, R_034908_SX_PERFCOUNTER1_LO},
	{11092, R_03490C_SX_PERFCOUNTER1_HI},
	{11111, R_034910_SX_PERFCOUNTER2_LO},
	{11130, R_034914_SX_PERFCOUNTER2_HI},
	{11149, R_034918_SX_PERFCOUNTER3_LO},
	{11168, R_03491C_SX_PERFCOUNTER3_HI},
	{11187, R_034A00_GDS_PERFCOUNTER0_LO},
	{11207, R_034A04_GDS_PERFCOUNTER0_HI},
	{11227, R_034A08_GDS_PERFCOUNTER1_LO},
	{11247, R_034A0C_GDS_PERFCOUNTER1_HI},
	{11267, R_034A10_GDS_PERFCOUNTER2_LO},
	{11287, R_034A14_GDS_PERFCOUNTER2_HI},
	{11307, R_034A18_GDS_PERFCOUNTER3_LO},
	{11327, R_034A1C_GDS_PERFCOUNTER3_HI},
	{11347, R_034B00_TA_PERFCOUNTER0_LO},
	{11366, R_034B04_TA_PERFCOUNTER0_HI},
	{11385, R_034B08_TA_PERFCOUNTER1_LO},
	{11404, R_034B0C_TA_PERFCOUNTER1_HI},
	{11423, R_034C00_TD_PERFCOUNTER0_LO},
	{11442, R_034C04_TD_PERFCOUNTER0_HI},
	{11461, R_034C08_TD_PERFCOUNTER1_LO},
	{11480, R_034C0C_TD_PERFCOUNTER1_HI},
	{11499, R_034D00_TCP_PERFCOUNTER0_LO},
	{11519, R_034D04_TCP_PERFCOUNTER0_HI},
	{11539, R_034D08_TCP_PERFCOUNTER1_LO},
	{11559, R_034D0C_TCP_PERFCOUNTER1_HI},
	{11579, R_034D10_TCP_PERFCOUNTER2_LO},
	{11599, R_034D14_TCP_PERFCOUNTER2_HI},
	{11619, R_034D18_TCP_PERFCOUNTER3_LO},
	{11639, R_034D1C_TCP_PERFCOUNTER3_HI},
	{11659, R_034E00_TCC_PERFCOUNTER0_LO},
	{11679, R_034E04_TCC_PERFCOUNTER0_HI},
	{11699, R_034E08_TCC_PERFCOUNTER1_LO},
	{11719, R_034E0C_TCC_PERFCOUNTER1_HI},
	{11739, R_034E10_TCC_PERFCOUNTER2_LO},
	{11759, R_034E14_TCC_PERFCOUNTER2_HI},
	{11779, R_034E18_TCC_PERFCOUNTER3_LO},
	{11799, R_034E1C_TCC_PERFCOUNTER3_HI},
	{11819, R_034E40_TCA_PERFCOUNTER0_LO},
	{11839, R_034E44_TCA_PERFCOUNTER0_HI},
	{11859, R_034E48_TCA_PERFCOUNTER1_LO},
	{11879, R_034E4C_TCA_PERFCOUNTER1_HI},
	{11899, R_034E50_TCA_PERFCOUNTER2_LO},
	{11919, R_034E54_TCA_PERFCOUNTER2_HI},
	{11939, R_034E58_TCA_PERFCOUNTER3_LO},
	{11959, R_034E5C_TCA_PERFCOUNTER3_HI},
	{11979, R_035018_CB_PERFCOUNTER0_LO},
	{11998, R_03501C_CB_PERFCOUNTER0_HI},
	{12017, R_035020_CB_PERFCOUNTER1_LO},
	{12036, R_035024_CB_PERFCOUNTER1_HI},
	{12055, R_035028_CB_PERFCOUNTER2_LO},
	{12074, R_03502C_CB_PERFCOUNTER2_HI},
	{12093, R_035030_CB_PERFCOUNTER3_LO},
	{12112, R_035034_CB_PERFCOUNTER3_HI},
	{12131, R_035100_DB_PERFCOUNTER0_LO},
	{12150, R_035104_DB_PERFCOUNTER0_HI},
	{12169, R_035108_DB_PERFCOUNTER1_LO},
	{12188, R_03510C_DB_PERFCOUNTER1_HI},
	{12207, R_035110_DB_PERFCOUNTER2_LO},
	{12226, R_035114_DB_PERFCOUNTER2_HI},
	{12245, R_035118_DB_PERFCOUNTER3_LO},
	{12264, R_03511C_DB_PERFCOUNTER3_HI},
	{12283, R_035200_RLC_PERFCOUNTER0_LO},
	{12303, R_035204_RLC_PERFCOUNTER0_HI},
	{12323, R_035208_RLC_PERFCOUNTER1_LO},
	{12343, R_03520C_RLC_PERFCOUNTER1_HI},
	{12363, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 940},
	{12387, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 943},
	{12412, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 940},
	{12436, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 945},
	{12460, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 948},
	{12485, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 950},
	{12509, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 953},
	{12534, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 950},
	{12558, R_036020_CP_PERFMON_CNTL, 4, 955},
	{12574, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 945},
	{12598, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 959},
	{12623, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 959},
	{12648, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 978},
	{12676, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 990},
	{12704, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 1002},
	{12732, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 1014},
	{12760, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1026},
	{12783, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1026},
	{12806, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1026},
	{12829, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1026},
	{12852, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1028},
	{12875, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1028},
	{12898, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1028},
	{12921, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1028},
	{12944, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1033},
	{12968, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1037},
	{12992, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1037},
	{13016, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1037},
	{13040, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1037},
	{13064, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1042},
	{13089, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{13114, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1046},
	{13140, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1047},
	{13166, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1050},
	{13193, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1047},
	{13219, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{13246, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1047},
	{13272, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1047},
	{13298, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1052},
	{13324, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1055},
	{13351, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1052},
	{13377, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1052},
	{13403, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1052},
	{13429, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1052},
	{13455, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1052},
	{13481, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1052},
	{13507, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1052},
	{13533, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1057},
	{13557, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1057},
	{13581, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1057},
	{13605, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1057},
	{13629, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1060},
	{13654, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{13679, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{13704, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{13729, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1057},
	{13753, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1057},
	{13777, R_036628_SPI_PERFCOUNTER_BINS, 8, 1062},
	{13798, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1070},
	{13821, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1070},
	{13844, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1070},
	{13867, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1070},
	{13890, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1070},
	{13913, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1070},
	{13936, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1070},
	{13959, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1070},
	{13982, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1070},
	{14005, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1070},
	{14028, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1070},
	{14052, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1070},
	{14076, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1070},
	{14100, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1070},
	{14124, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1070},
	{14148, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1070},
	{14172, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1076},
	{14192, R_036784_SQ_PERFCOUNTER_MASK, 2, 1085},
	{14212, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1087},
	{14233, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1088},
	{14256, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1088},
	{14279, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1088},
	{14302, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1088},
	{14325, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1091},
	{14349, R_036914_SX_PERFCOUNTER1_SELECT1},
	{14373, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1093},
	{14397, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1093},
	{14421, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1093},
	{14445, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1093},
	{14469, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1096},
	{14494, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1098},
	{14517, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1103},
	{14541, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1098},
	{14564, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1107},
	{14587, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1112},
	{14611, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1107},
	{14634, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1116},
	{14658, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1121},
	{14683, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1116},
	{14707, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{14732, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1116},
	{14756, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1116},
	{14780, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1125},
	{14804, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1130},
	{14829, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1125},
	{14853, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{14878, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1125},
	{14902, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1125},
	{14926, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1134},
	{14950, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1139},
	{14975, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1134},
	{14999, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{15024, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1134},
	{15048, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1134},
	{15072, R_037000_CB_PERFCOUNTER_FILTER, 12, 1143},
	{15094, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1155},
	{15117, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1160},
	{15141, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1155},
	{15164, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1155},
	{15187, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1155},
	{15210, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1164},
	{15233, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1169},
	{15257, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1164},
	{15280, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{15304, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1164},
	{15327, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1164},
	{15350, R_028000_DB_RENDER_CONTROL, 10, 1173},
	{15368, R_028004_DB_COUNT_CONTROL, 9, 1183},
	{15385, R_028008_DB_DEPTH_VIEW, 4, 1192},
	{15399, R_02800C_DB_RENDER_OVERRIDE, 23, 1196},
	{15418, R_028010_DB_RENDER_OVERRIDE2, 15, 1219},
	{15438, R_028014_DB_HTILE_DATA_BASE},
	{15457, R_028020_DB_DEPTH_BOUNDS_MIN},
	{15477, R_028024_DB_DEPTH_BOUNDS_MAX},
	{15497, R_028028_DB_STENCIL_CLEAR, 1, 1234},
	{15514, R_02802C_DB_DEPTH_CLEAR},
	{15529, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1235},
	{15553, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1237},
	{15577, R_02803C_DB_DEPTH_INFO, 7, 1239},
	{15591, R_028040_DB_Z_INFO, 10, 1246},
	{15601, R_028044_DB_STENCIL_INFO, 6, 1256},
	{15617, R_028048_DB_Z_READ_BASE},
	{15632, R_02804C_DB_STENCIL_READ_BASE},
	{15653, R_028050_DB_Z_WRITE_BASE},
	{15669, R_028054_DB_STENCIL_WRITE_BASE},
	{15691, R_028058_DB_DEPTH_SIZE, 2, 1262},
	{15705, R_02805C_DB_DEPTH_SLICE, 1, 1264},
	{15720, R_028080_TA_BC_BASE_ADDR},
	{15736, R_028084_TA_BC_BASE_ADDR_HI, 1, 1265},
	{15755, R_0281E8_COHER_DEST_BASE_HI_0},
	{15776, R_0281EC_COHER_DEST_BASE_HI_1},
	{15797, R_0281F0_COHER_DEST_BASE_HI_2},
	{15818, R_0281F4_COHER_DEST_BASE_HI_3},
	{15839, R_0281F8_COHER_DEST_BASE_2},
	{15857, R_0281FC_COHER_DEST_BASE_3},
	{15875, R_028200_PA_SC_WINDOW_OFFSET, 2, 1266},
	{15895, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1268},
	{15919, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1271},
	{15943, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1273},
	{15963, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1274},
	{15983, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1276},
	{16003, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1274},
	{16023, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1276},
	{16043, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1274},
	{16063, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1276},
	{16083, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1274},
	{16103, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1276},
	{16123, R_028230_PA_SC_EDGERULE, 7, 1278},
	{16138, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1285},
	{16167, R_028238_CB_TARGET_MASK, 8, 1287},
	{16182, R_02823C_CB_SHADER_MASK, 8, 1295},
	{16197, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1303},
	{16222, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1306},
	{16247, R_028248_COHER_DEST_BASE_0},
	{16265, R_02824C_COHER_DEST_BASE_1},
	{16283, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1308},
	{16308, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1311},
	{16333, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1308},
	{16358, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1311},
	{16383, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1308},
	{16408, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1311},
	{16433, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1308},
	{16458, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1311},
	{16483, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1308},
	{16508, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1311},
	{16533, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1308},
	{16558, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1311},
	{16583, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1308},
	{16608, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1311},
	{16633, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1308},
	{16658, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1311},
	{16683, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1308},
	{16708, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1311},
	{16733, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1308},
	{16758, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1311},
	{16783, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1308},
	{16809, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1311},
	{16835, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1308},
	{16861, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1311},
	{16887, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1308},
	{16913, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1311},
	{16939, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1308},
	{16965, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1311},
	{16991, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1308},
	{17017, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1311},
	{17043, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1308},
	{17069, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1311},
	{17095, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{17114, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{17133, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{17152, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{17171, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{17190, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{17209, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{17228, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{17247, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{17266, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{17285, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{17304, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{17323, R_028300_PA_SC_VPORT_ZMIN_6},
	{17342, R_028304_PA_SC_VPORT_ZMAX_6},
	{17361, R_028308_PA_SC_VPORT_ZMIN_7},
	{17380, R_02830C_PA_SC_VPORT_ZMAX_7},
	{17399, R_028310_PA_SC_VPORT_ZMIN_8},
	{17418, R_028314_PA_SC_VPORT_ZMAX_8},
	{17437, R_028318_PA_SC_VPORT_ZMIN_9},
	{17456, R_02831C_PA_SC_VPORT_ZMAX_9},
	{17475, R_028320_PA_SC_VPORT_ZMIN_10},
	{17495, R_028324_PA_SC_VPORT_ZMAX_10},
	{17515, R_028328_PA_SC_VPORT_ZMIN_11},
	{17535, R_02832C_PA_SC_VPORT_ZMAX_11},
	{17555, R_028330_PA_SC_VPORT_ZMIN_12},
	{17575, R_028334_PA_SC_VPORT_ZMAX_12},
	{17595, R_028338_PA_SC_VPORT_ZMIN_13},
	{17615, R_02833C_PA_SC_VPORT_ZMAX_13},
	{17635, R_028340_PA_SC_VPORT_ZMIN_14},
	{17655, R_028344_PA_SC_VPORT_ZMAX_14},
	{17675, R_028348_PA_SC_VPORT_ZMIN_15},
	{17695, R_02834C_PA_SC_VPORT_ZMAX_15},
	{17715, R_028350_PA_SC_RASTER_CONFIG, 15, 1313},
	{17735, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1328},
	{17757, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1331},
	{17785, R_028400_VGT_MAX_VTX_INDX},
	{17802, R_028404_VGT_MIN_VTX_INDX},
	{17819, R_028408_VGT_INDX_OFFSET},
	{17835, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{17864, R_028414_CB_BLEND_RED},
	{17877, R_028418_CB_BLEND_GREEN},
	{17892, R_02841C_CB_BLEND_BLUE},
	{17906, R_028420_CB_BLEND_ALPHA},
	{17921, R_028424_CB_DCC_CONTROL, 3, 1333},
	{17936, R_02842C_DB_STENCIL_CONTROL, 6, 1336},
	{17955, R_028430_DB_STENCILREFMASK, 4, 1342},
	{17973, R_028434_DB_STENCILREFMASK_BF, 4, 1346},
	{17994, R_02843C_PA_CL_VPORT_XSCALE},
	{18013, R_028440_PA_CL_VPORT_XOFFSET},
	{18033, R_028444_PA_CL_VPORT_YSCALE},
	{18052, R_028448_PA_CL_VPORT_YOFFSET},
	{18072, R_02844C_PA_CL_VPORT_ZSCALE},
	{18091, R_028450_PA_CL_VPORT_ZOFFSET},
	{18111, R_028454_PA_CL_VPORT_XSCALE_1},
	{18132, R_028458_PA_CL_VPORT_XOFFSET_1},
	{18154, R_02845C_PA_CL_VPORT_YSCALE_1},
	{18175, R_028460_PA_CL_VPORT_YOFFSET_1},
	{18197, R_028464_PA_CL_VPORT_ZSCALE_1},
	{18218, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{18240, R_02846C_PA_CL_VPORT_XSCALE_2},
	{18261, R_028470_PA_CL_VPORT_XOFFSET_2},
	{18283, R_028474_PA_CL_VPORT_YSCALE_2},
	{18304, R_028478_PA_CL_VPORT_YOFFSET_2},
	{18326, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{18347, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{18369, R_028484_PA_CL_VPORT_XSCALE_3},
	{18390, R_028488_PA_CL_VPORT_XOFFSET_3},
	{18412, R_02848C_PA_CL_VPORT_YSCALE_3},
	{18433, R_028490_PA_CL_VPORT_YOFFSET_3},
	{18455, R_028494_PA_CL_VPORT_ZSCALE_3},
	{18476, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{18498, R_02849C_PA_CL_VPORT_XSCALE_4},
	{18519, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{18541, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{18562, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{18584, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{18605, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{18627, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{18648, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{18670, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{18691, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{18713, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{18734, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{18756, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{18777, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{18799, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{18820, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{18842, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{18863, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{18885, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{18906, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{18928, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{18949, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{18971, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{18992, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{19014, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{19035, R_028500_PA_CL_VPORT_XOFFSET_8},
	{19057, R_028504_PA_CL_VPORT_YSCALE_8},
	{19078, R_028508_PA_CL_VPORT_YOFFSET_8},
	{19100, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{19121, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{19143, R_028514_PA_CL_VPORT_XSCALE_9},
	{19164, R_028518_PA_CL_VPORT_XOFFSET_9},
	{19186, R_02851C_PA_CL_VPORT_YSCALE_9},
	{19207, R_028520_PA_CL_VPORT_YOFFSET_9},
	{19229, R_028524_PA_CL_VPORT_ZSCALE_9},
	{19250, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{19272, R_02852C_PA_CL_VPORT_XSCALE_10},
	{19294, R_028530_PA_CL_VPORT_XOFFSET_10},
	{19317, R_028534_PA_CL_VPORT_YSCALE_10},
	{19339, R_028538_PA_CL_VPORT_YOFFSET_10},
	{19362, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{19384, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{19407, R_028544_PA_CL_VPORT_XSCALE_11},
	{19429, R_028548_PA_CL_VPORT_XOFFSET_11},
	{19452, R_02854C_PA_CL_VPORT_YSCALE_11},
	{19474, R_028550_PA_CL_VPORT_YOFFSET_11},
	{19497, R_028554_PA_CL_VPORT_ZSCALE_11},
	{19519, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{19542, R_02855C_PA_CL_VPORT_XSCALE_12},
	{19564, R_028560_PA_CL_VPORT_XOFFSET_12},
	{19587, R_028564_PA_CL_VPORT_YSCALE_12},
	{19609, R_028568_PA_CL_VPORT_YOFFSET_12},
	{19632, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{19654, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{19677, R_028574_PA_CL_VPORT_XSCALE_13},
	{19699, R_028578_PA_CL_VPORT_XOFFSET_13},
	{19722, R_02857C_PA_CL_VPORT_YSCALE_13},
	{19744, R_028580_PA_CL_VPORT_YOFFSET_13},
	{19767, R_028584_PA_CL_VPORT_ZSCALE_13},
	{19789, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{19812, R_02858C_PA_CL_VPORT_XSCALE_14},
	{19834, R_028590_PA_CL_VPORT_XOFFSET_14},
	{19857, R_028594_PA_CL_VPORT_YSCALE_14},
	{19879, R_028598_PA_CL_VPORT_YOFFSET_14},
	{19902, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{19924, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{19947, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{19969, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{19992, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{20014, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{20037, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{20059, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{20082, R_0285BC_PA_CL_UCP_0_X},
	{20096, R_0285C0_PA_CL_UCP_0_Y},
	{20110, R_0285C4_PA_CL_UCP_0_Z},
	{20124, R_0285C8_PA_CL_UCP_0_W},
	{20138, R_0285CC_PA_CL_UCP_1_X},
	{20152, R_0285D0_PA_CL_UCP_1_Y},
	{20166, R_0285D4_PA_CL_UCP_1_Z},
	{20180, R_0285D8_PA_CL_UCP_1_W},
	{20194, R_0285DC_PA_CL_UCP_2_X},
	{20208, R_0285E0_PA_CL_UCP_2_Y},
	{20222, R_0285E4_PA_CL_UCP_2_Z},
	{20236, R_0285E8_PA_CL_UCP_2_W},
	{20250, R_0285EC_PA_CL_UCP_3_X},
	{20264, R_0285F0_PA_CL_UCP_3_Y},
	{20278, R_0285F4_PA_CL_UCP_3_Z},
	{20292, R_0285F8_PA_CL_UCP_3_W},
	{20306, R_0285FC_PA_CL_UCP_4_X},
	{20320, R_028600_PA_CL_UCP_4_Y},
	{20334, R_028604_PA_CL_UCP_4_Z},
	{20348, R_028608_PA_CL_UCP_4_W},
	{20362, R_02860C_PA_CL_UCP_5_X},
	{20376, R_028610_PA_CL_UCP_5_Y},
	{20390, R_028614_PA_CL_UCP_5_Z},
	{20404, R_028618_PA_CL_UCP_5_W},
	{20418, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1350},
	{20438, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1350},
	{20458, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1350},
	{20478, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1350},
	{20498, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1350},
	{20518, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1350},
	{20538, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1350},
	{20558, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1350},
	{20578, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1350},
	{20598, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1350},
	{20618, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1350},
	{20639, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1350},
	{20660, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1350},
	{20681, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1350},
	{20702, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1350},
	{20723, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1350},
	{20744, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1350},
	{20765, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1350},
	{20786, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1350},
	{20807, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1350},
	{20828, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1350},
	{20849, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1350},
	{20870, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1350},
	{20891, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1350},
	{20912, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1350},
	{20933, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1350},
	{20954, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1350},
	{20975, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1350},
	{20996, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1350},
	{21017, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1350},
	{21038, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1350},
	{21059, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1350},
	{21080, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1362},
	{21098, R_0286CC_SPI_PS_INPUT_ENA, 16, 1366},
	{21115, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1382},
	{21133, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1398},
	{21154, R_0286D8_SPI_PS_IN_CONTROL, 5, 1405},
	{21172, R_0286E0_SPI_BARYC_CNTL, 7, 1410},
	{21187, R_0286E8_SPI_TMPRING_SIZE, 2, 1417},
	{21204, R_028704_SPI_WAVE_MGMT_1, 5, 1419},
	{21220, R_028708_SPI_WAVE_MGMT_2, 1, 1424},
	{21236, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1425},
	{21258, R_028710_SPI_SHADER_Z_FORMAT, 1, 1429},
	{21278, R_028714_SPI_SHADER_COL_FORMAT, 8, 1430},
	{21300, R_028754_SX_PS_DOWNCONVERT, 8, 1438},
	{21318, R_028758_SX_BLEND_OPT_EPSILON, 8, 1446},
	{21339, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1454},
	{21360, R_028760_SX_MRT0_BLEND_OPT, 6, 1471},
	{21378, R_028764_SX_MRT1_BLEND_OPT, 6, 1477},
	{21396, R_028768_SX_MRT2_BLEND_OPT, 6, 1483},
	{21414, R_02876C_SX_MRT3_BLEND_OPT, 6, 1489},
	{21432, R_028770_SX_MRT4_BLEND_OPT, 6, 1495},
	{21450, R_028774_SX_MRT5_BLEND_OPT, 6, 1501},
	{21468, R_028778_SX_MRT6_BLEND_OPT, 6, 1507},
	{21486, R_02877C_SX_MRT7_BLEND_OPT, 6, 1513},
	{21504, R_028780_CB_BLEND0_CONTROL, 9, 1519},
	{21522, R_028784_CB_BLEND1_CONTROL, 9, 1519},
	{21540, R_028788_CB_BLEND2_CONTROL, 9, 1519},
	{21558, R_02878C_CB_BLEND3_CONTROL, 9, 1519},
	{21576, R_028790_CB_BLEND4_CONTROL, 9, 1519},
	{21594, R_028794_CB_BLEND5_CONTROL, 9, 1519},
	{21612, R_028798_CB_BLEND6_CONTROL, 9, 1519},
	{21630, R_02879C_CB_BLEND7_CONTROL, 9, 1519},
	{21648, R_0287CC_CS_COPY_STATE, 1, 1528},
	{21662, R_0287D4_PA_CL_POINT_X_RAD},
	{21680, R_0287D8_PA_CL_POINT_Y_RAD},
	{21698, R_0287DC_PA_CL_POINT_SIZE},
	{21715, R_0287E0_PA_CL_POINT_CULL_RAD},
	{21736, R_0287E4_VGT_DMA_BASE_HI, 1, 1529},
	{21752, R_0287E8_VGT_DMA_BASE},
	{21765, R_0287F0_VGT_DRAW_INITIATOR, 4, 1530},
	{21784, R_0287F4_VGT_IMMED_DATA},
	{21799, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1534},
	{21821, R_028800_DB_DEPTH_CONTROL, 10, 1535},
	{21838, R_028804_DB_EQAA, 12, 1545},
	{21846, R_028808_CB_COLOR_CONTROL, 4, 1557},
	{21863, R_02880C_DB_SHADER_CONTROL, 13, 1561},
	{21881, R_028810_PA_CL_CLIP_CNTL, 19, 1574},
	{21897, R_028814_PA_SU_SC_MODE_CNTL, 13, 1593},
	{21916, R_028818_PA_CL_VTE_CNTL, 9, 1606},
	{21931, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1615},
	{21949, R_028820_PA_CL_NANINF_CNTL, 16, 1642},
	{21967, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1658},
	{21991, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{22016, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1662},
	{22039, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1673},
	{22068, R_028A00_PA_SU_POINT_SIZE, 2, 1678},
	{22085, R_028A04_PA_SU_POINT_MINMAX, 2, 1680},
	{22104, R_028A08_PA_SU_LINE_CNTL, 1, 1682},
	{22120, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1683},
	{22139, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1687},
	{22160, R_028A14_VGT_HOS_CNTL, 1, 1688},
	{22173, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{22196, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{22219, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1689},
	{22239, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1690},
	{22259, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1694},
	{22280, R_028A2C_VGT_GROUP_DECR, 1, 1695},
	{22295, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1696},
	{22317, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1702},
	{22339, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1708},
	{22365, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1716},
	{22391, R_028A40_VGT_GS_MODE, 15, 1724},
	{22403, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1739},
	{22422, R_028A48_PA_SC_MODE_CNTL_0, 4, 1741},
	{22440, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1745},
	{22458, R_028A50_VGT_ENHANCE},
	{22470, R_028A54_VGT_GS_PER_ES, 1, 1769},
	{22484, R_028A58_VGT_ES_PER_GS, 1, 1770},
	{22498, R_028A5C_VGT_GS_PER_VS, 1, 1771},
	{22512, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1772},
	{22535, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1773},
	{22558, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1774},
	{22581, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1775},
	{22602, R_028A70_IA_ENHANCE},
	{22613, R_028A74_VGT_DMA_SIZE},
	{22626, R_028A78_VGT_DMA_MAX_SIZE},
	{22643, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1780},
	{22662, R_028A80_WD_ENHANCE},
	{22673, R_028A84_VGT_PRIMITIVEID_EN, 2, 1789},
	{22692, R_028A88_VGT_DMA_NUM_INSTANCES},
	{22714, R_028A8C_VGT_PRIMITIVEID_RESET},
	{22736, R_028A90_VGT_EVENT_INITIATOR, 3, 1791},
	{22756, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1794},
	{22783, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{22808, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{22833, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1795},
	{22852, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1802},
	{22875, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1803},
	{22898, R_028AB4_VGT_REUSE_OFF, 1, 1804},
	{22912, R_028AB8_VGT_VTX_CNT_EN, 1, 1805},
	{22927, R_028ABC_DB_HTILE_SURFACE, 8, 1806},
	{22944, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1814},
	{22971, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1818},
	{22998, R_028AC8_DB_PRELOAD_CONTROL, 4, 1822},
	{23017, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{23043, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1826},
	{23068, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{23096, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{23122, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1827},
	{23147, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{23175, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{23201, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1828},
	{23226, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{23254, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{23280, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1829},
	{23305, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{23333, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{23364, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{23407, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1830},
	{23445, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1831},
	{23465, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1832},
	{23487, R_028B54_VGT_SHADER_STAGES_EN, 10, 1837},
	{23508, R_028B58_VGT_LS_HS_CONFIG, 3, 1847},
	{23525, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1850},
	{23546, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1851},
	{23569, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1852},
	{23592, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1853},
	{23615, R_028B6C_VGT_TF_PARAM, 11, 1854},
	{23628, R_028B70_DB_ALPHA_TO_MASK, 6, 1865},
	{23645, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{23669, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1871},
	{23699, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{23723, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{23753, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{23784, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{23813, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{23843, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1873},
	{23863, R_028B94_VGT_STRMOUT_CONFIG, 7, 1875},
	{23882, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1882},
	{23908, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1886},
	{23934, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1894},
	{23960, R_028BDC_PA_SC_LINE_CNTL, 4, 1902},
	{23976, R_028BE0_PA_SC_AA_CONFIG, 5, 1906},
	{23992, R_028BE4_PA_SU_VTX_CNTL, 3, 1911},
	{24007, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{24030, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{24053, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{24076, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{24099, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1914},
	{24133, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1922},
	{24167, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1930},
	{24201, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1938},
	{24235, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1946},
	{24269, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1954},
	{24303, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1962},
	{24337, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1970},
	{24371, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1978},
	{24405, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1986},
	{24439, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1994},
	{24473, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 2002},
	{24507, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 2010},
	{24541, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2018},
	{24575, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2026},
	{24609, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2034},
	{24643, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2042},
	{24667, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2044},
	{24691, R_028C40_PA_SC_SHADER_CONTROL, 1, 2046},
	{24712, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2047},
	{24740, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2048},
	{24761, R_028C60_CB_COLOR0_BASE},
	{24776, R_028C64_CB_COLOR0_PITCH, 2, 2049},
	{24792, R_028C68_CB_COLOR0_SLICE, 1, 2051},
	{24808, R_028C6C_CB_COLOR0_VIEW, 2, 2052},
	{24823, R_028C70_CB_COLOR0_INFO, 18, 2054},
	{24838, R_028C74_CB_COLOR0_ATTRIB, 6, 2072},
	{24855, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2078},
	{24877, R_028C7C_CB_COLOR0_CMASK},
	{24893, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2087},
	{24915, R_028C84_CB_COLOR0_FMASK},
	{24931, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2088},
	{24953, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{24975, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{24997, R_028C94_CB_COLOR0_DCC_BASE},
	{25016, R_028C9C_CB_COLOR1_BASE},
	{25031, R_028CA0_CB_COLOR1_PITCH, 2, 2049},
	{25047, R_028CA4_CB_COLOR1_SLICE, 1, 2051},
	{25063, R_028CA8_CB_COLOR1_VIEW, 2, 2052},
	{25078, R_028CAC_CB_COLOR1_INFO, 18, 2054},
	{25093, R_028CB0_CB_COLOR1_ATTRIB, 6, 2072},
	{25110, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2078},
	{25132, R_028CB8_CB_COLOR1_CMASK},
	{25148, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2087},
	{25170, R_028CC0_CB_COLOR1_FMASK},
	{25186, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2088},
	{25208, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{25230, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{25252, R_028CD0_CB_COLOR1_DCC_BASE},
	{25271, R_028CD8_CB_COLOR2_BASE},
	{25286, R_028CDC_CB_COLOR2_PITCH, 2, 2049},
	{25302, R_028CE0_CB_COLOR2_SLICE, 1, 2051},
	{25318, R_028CE4_CB_COLOR2_VIEW, 2, 2052},
	{25333, R_028CE8_CB_COLOR2_INFO, 18, 2054},
	{25348, R_028CEC_CB_COLOR2_ATTRIB, 6, 2072},
	{25365, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2078},
	{25387, R_028CF4_CB_COLOR2_CMASK},
	{25403, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2087},
	{25425, R_028CFC_CB_COLOR2_FMASK},
	{25441, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2088},
	{25463, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{25485, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{25507, R_028D0C_CB_COLOR2_DCC_BASE},
	{25526, R_028D14_CB_COLOR3_BASE},
	{25541, R_028D18_CB_COLOR3_PITCH, 2, 2049},
	{25557, R_028D1C_CB_COLOR3_SLICE, 1, 2051},
	{25573, R_028D20_CB_COLOR3_VIEW, 2, 2052},
	{25588, R_028D24_CB_COLOR3_INFO, 18, 2054},
	{25603, R_028D28_CB_COLOR3_ATTRIB, 6, 2072},
	{25620, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2078},
	{25642, R_028D30_CB_COLOR3_CMASK},
	{25658, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2087},
	{25680, R_028D38_CB_COLOR3_FMASK},
	{25696, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2088},
	{25718, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{25740, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{25762, R_028D48_CB_COLOR3_DCC_BASE},
	{25781, R_028D50_CB_COLOR4_BASE},
	{25796, R_028D54_CB_COLOR4_PITCH, 2, 2049},
	{25812, R_028D58_CB_COLOR4_SLICE, 1, 2051},
	{25828, R_028D5C_CB_COLOR4_VIEW, 2, 2052},
	{25843, R_028D60_CB_COLOR4_INFO, 18, 2054},
	{25858, R_028D64_CB_COLOR4_ATTRIB, 6, 2072},
	{25875, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2078},
	{25897, R_028D6C_CB_COLOR4_CMASK},
	{25913, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2087},
	{25935, R_028D74_CB_COLOR4_FMASK},
	{25951, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2088},
	{25973, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{25995, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{26017, R_028D84_CB_COLOR4_DCC_BASE},
	{26036, R_028D8C_CB_COLOR5_BASE},
	{26051, R_028D90_CB_COLOR5_PITCH, 2, 2049},
	{26067, R_028D94_CB_COLOR5_SLICE, 1, 2051},
	{26083, R_028D98_CB_COLOR5_VIEW, 2, 2052},
	{26098, R_028D9C_CB_COLOR5_INFO, 18, 2054},
	{26113, R_028DA0_CB_COLOR5_ATTRIB, 6, 2072},
	{26130, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2078},
	{26152, R_028DA8_CB_COLOR5_CMASK},
	{26168, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2087},
	{26190, R_028DB0_CB_COLOR5_FMASK},
	{26206, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2088},
	{26228, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{26250, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{26272, R_028DC0_CB_COLOR5_DCC_BASE},
	{26291, R_028DC8_CB_COLOR6_BASE},
	{26306, R_028DCC_CB_COLOR6_PITCH, 2, 2049},
	{26322, R_028DD0_CB_COLOR6_SLICE, 1, 2051},
	{26338, R_028DD4_CB_COLOR6_VIEW, 2, 2052},
	{26353, R_028DD8_CB_COLOR6_INFO, 18, 2054},
	{26368, R_028DDC_CB_COLOR6_ATTRIB, 6, 2072},
	{26385, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2078},
	{26407, R_028DE4_CB_COLOR6_CMASK},
	{26423, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2087},
	{26445, R_028DEC_CB_COLOR6_FMASK},
	{26461, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2088},
	{26483, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{26505, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{26527, R_028DFC_CB_COLOR6_DCC_BASE},
	{26546, R_028E04_CB_COLOR7_BASE},
	{26561, R_028E08_CB_COLOR7_PITCH, 2, 2049},
	{26577, R_028E0C_CB_COLOR7_SLICE, 1, 2051},
	{26593, R_028E10_CB_COLOR7_VIEW, 2, 2052},
	{26608, R_028E14_CB_COLOR7_INFO, 18, 2054},
	{26623, R_028E18_CB_COLOR7_ATTRIB, 6, 2072},
	{26640, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2078},
	{26662, R_028E20_CB_COLOR7_CMASK},
	{26678, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2087},
	{26700, R_028E28_CB_COLOR7_FMASK},
	{26716, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2088},
	{26738, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{26760, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{26782, R_028E38_CB_COLOR7_DCC_BASE},
};

static const struct si_reg gfx9d_reg_table[] = {
	{1105, R_008008_GRBM_STATUS2, 25, 2089},
	{1118, R_008010_GRBM_STATUS, 24, 2114},
	{1203, R_008014_GRBM_STATUS_SE0, 12, 2138},
	{1219, R_008018_GRBM_STATUS_SE1, 12, 2150},
	{1235, R_008038_GRBM_STATUS_SE2, 12, 2162},
	{1251, R_00803C_GRBM_STATUS_SE3, 12, 2174},
	{1161, R_0301F0_CP_COHER_CNTL, 13, 2186},
	{1305, R_0301FC_CP_COHER_STATUS, 2, 2199},
	{1321, R_008210_CP_CPC_STATUS, 16, 2201},
	{1352, R_008218_CP_CPC_STALLED_STAT1, 14, 2217},
	{1373, R_00821C_CP_CPF_STATUS, 21, 2231},
	{1404, R_008224_CP_CPF_STALLED_STAT1, 11, 2252},
	{1867, R_008670_CP_STALLED_STAT3, 19, 2263},
	{1918, R_008680_CP_STAT, 22, 2282},
	{1546, R_030908_VGT_PRIMITIVE_TYPE, 1, 2304},
	{1565, R_03090C_VGT_INDEX_TYPE, 2, 2305},
	{17785, R_030920_VGT_MAX_VTX_INDX},
	{17802, R_030924_VGT_MIN_VTX_INDX},
	{17819, R_030928_VGT_INDX_OFFSET},
	{22756, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2307},
	{1763, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 2309},
	{26801, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2311},
	{26823, R_030948_WD_POS_BUF_BASE},
	{26839, R_03094C_WD_POS_BUF_BASE_HI, 1, 2312},
	{26858, R_030950_WD_CNTL_SB_BUF_BASE},
	{26878, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2313},
	{26901, R_030958_WD_INDEX_BUF_BASE},
	{26919, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2314},
	{22833, R_030960_IA_MULTI_VGT_PARAM, 9, 2315},
	{26940, R_030968_VGT_INSTANCE_BASE_ID},
	{2044, R_030D20_SQC_CACHES, 6, 2324},
	{26961, R_030D24_SQC_WRITEBACK, 2, 2330},
	{2272, R_008F0C_SQ_BUF_RSRC_WORD3, 12, 2332},
	{2355, R_008F14_SQ_IMG_RSRC_WORD1, 9, 2344},
	{2397, R_008F18_SQ_IMG_RSRC_WORD2, 3, 560},
	{2438, R_008F1C_SQ_IMG_RSRC_WORD3, 8, 2353},
	{2456, R_008F20_SQ_IMG_RSRC_WORD4, 3, 2361},
	{2474, R_008F24_SQ_IMG_RSRC_WORD5, 7, 2364},
	{2564, R_008F38_SQ_IMG_SAMP_WORD2, 10, 2371},
	{2582, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 2381},
	{2919, R_031100_SPI_CONFIG_CNTL, 9, 2384},
	{2935, R_031104_SPI_CONFIG_CNTL_1, 11, 2393},
	{26975, R_031108_SPI_CONFIG_CNTL_2, 2, 2404},
	{3001, R_0098F8_GB_ADDR_CONFIG, 13, 2406},
	{3016, R_009910_GB_TILE_MODE0, 5, 2419},
	{3030, R_009914_GB_TILE_MODE1, 5, 2419},
	{3044, R_009918_GB_TILE_MODE2, 5, 2419},
	{3058, R_00991C_GB_TILE_MODE3, 5, 2419},
	{3072, R_009920_GB_TILE_MODE4, 5, 2419},
	{3086, R_009924_GB_TILE_MODE5, 5, 2419},
	{3100, R_009928_GB_TILE_MODE6, 5, 2419},
	{3114, R_00992C_GB_TILE_MODE7, 5, 2419},
	{3128, R_009930_GB_TILE_MODE8, 5, 2419},
	{3142, R_009934_GB_TILE_MODE9, 5, 2419},
	{3156, R_009938_GB_TILE_MODE10, 5, 2419},
	{3171, R_00993C_GB_TILE_MODE11, 5, 2419},
	{3186, R_009940_GB_TILE_MODE12, 5, 2419},
	{3201, R_009944_GB_TILE_MODE13, 5, 2419},
	{3216, R_009948_GB_TILE_MODE14, 5, 2419},
	{3231, R_00994C_GB_TILE_MODE15, 5, 2419},
	{3246, R_009950_GB_TILE_MODE16, 5, 2419},
	{3261, R_009954_GB_TILE_MODE17, 5, 2419},
	{3276, R_009958_GB_TILE_MODE18, 5, 2419},
	{3291, R_00995C_GB_TILE_MODE19, 5, 2419},
	{3306, R_009960_GB_TILE_MODE20, 5, 2419},
	{3321, R_009964_GB_TILE_MODE21, 5, 2419},
	{3336, R_009968_GB_TILE_MODE22, 5, 2419},
	{3351, R_00996C_GB_TILE_MODE23, 5, 2419},
	{3366, R_009970_GB_TILE_MODE24, 5, 2419},
	{3381, R_009974_GB_TILE_MODE25, 5, 2419},
	{3396, R_009978_GB_TILE_MODE26, 5, 2419},
	{3411, R_00997C_GB_TILE_MODE27, 5, 2419},
	{3426, R_009980_GB_TILE_MODE28, 5, 2419},
	{3441, R_009984_GB_TILE_MODE29, 5, 2419},
	{3456, R_009988_GB_TILE_MODE30, 5, 2419},
	{3471, R_00998C_GB_TILE_MODE31, 5, 2419},
	{3880, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 2424},
	{3946, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 2428},
	{3970, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 10, 2439},
	{26993, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{27020, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{27047, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{27074, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{27101, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{27128, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{27155, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{27182, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{27209, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{27236, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{27263, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{27290, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{27317, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{27344, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{27371, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{27398, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{4500, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 2449},
	{4591, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 2453},
	{4615, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 14, 2465},
	{27425, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{27452, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{27479, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{27506, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{27533, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{27560, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{27587, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{27614, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{27641, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{27668, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{27695, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{27722, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{27749, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{27776, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{27803, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{27830, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{27857, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2479},
	{27884, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2488},
	{27908, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{27940, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{5789, R_00B210_SPI_SHADER_PGM_LO_ES},
	{5810, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2490},
	{5145, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 2491},
	{5211, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 12, 2495},
	{5235, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 9, 2507},
	{27972, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{27999, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{28026, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{28053, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{28080, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{28107, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{28134, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{28161, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{28188, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{28215, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{28242, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{28269, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{28296, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{28323, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{28350, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{28377, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{28404, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2516},
	{28428, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{28460, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{7029, R_00B410_SPI_SHADER_PGM_LO_LS},
	{7050, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2517},
	{6385, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 4, 2518},
	{6451, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 11, 2522},
	{6475, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 2533},
	{7119, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{7145, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{7171, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{7197, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{7223, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{7249, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{7275, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{7301, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{7327, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{7353, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{7379, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{7406, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{7433, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{7460, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{7487, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{7514, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{28492, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{28519, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{28546, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{28573, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{28600, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{28627, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{28654, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{28681, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{28708, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{28735, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{28762, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{28789, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{28816, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{28843, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{28870, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{28897, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{28924, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{28954, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{28984, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{29014, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{29044, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{29074, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{29104, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{29134, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{29164, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{29194, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{29224, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{29255, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{29286, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{29317, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{29348, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{29379, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{29410, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{29441, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{29472, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{29503, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{29534, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{29565, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{29596, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{29627, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{29658, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{29689, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{29720, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{29751, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{29782, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{29813, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{29844, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{29875, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{7541, R_00B800_COMPUTE_DISPATCH_INITIATOR, 11, 2540},
	{7809, R_00B834_COMPUTE_PGM_HI, 1, 885},
	{29906, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{29935, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 887},
	{29964, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{29997, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 888},
	{7884, R_00B848_COMPUTE_PGM_RSRC1, 11, 2551},
	{7902, R_00B84C_COMPUTE_PGM_RSRC2, 12, 2562},
	{7933, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 2574},
	{30030, R_034030_CPF_LATENCY_STATS_DATA},
	{30053, R_034034_CPG_LATENCY_STATS_DATA},
	{30076, R_034038_CPC_LATENCY_STATS_DATA},
	{12363, R_036000_CPG_PERFCOUNTER1_SELECT, 5, 2581},
	{12387, R_036004_CPG_PERFCOUNTER0_SELECT1, 4, 2586},
	{12412, R_036008_CPG_PERFCOUNTER0_SELECT, 5, 2581},
	{12436, R_03600C_CPC_PERFCOUNTER1_SELECT, 5, 2590},
	{12460, R_036010_CPC_PERFCOUNTER0_SELECT1, 4, 2595},
	{12485, R_036014_CPF_PERFCOUNTER1_SELECT, 5, 2599},
	{12509, R_036018_CPF_PERFCOUNTER0_SELECT1, 4, 2604},
	{12534, R_03601C_CPF_PERFCOUNTER0_SELECT, 5, 2599},
	{12574, R_036024_CPC_PERFCOUNTER0_SELECT, 5, 2590},
	{30099, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2608},
	{30133, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2611},
	{30167, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2614},
	{30192, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2617},
	{30217, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2620},
	{12598, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 2623},
	{12623, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 2623},
	{12648, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 2645},
	{12676, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 2658},
	{12704, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 2671},
	{12732, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 2684},
	{13533, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 2697},
	{13557, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 2697},
	{13581, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 2697},
	{13605, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 2697},
	{13629, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 2702},
	{13729, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 2697},
	{13753, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 2697},
	{15385, R_028008_DB_DEPTH_VIEW, 5, 2706},
	{15418, R_028010_DB_RENDER_OVERRIDE2, 16, 2711},
	{30242, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2727},
	{15691, R_02801C_DB_DEPTH_SIZE, 2, 2728},
	{15591, R_028038_DB_Z_INFO, 13, 2730},
	{15601, R_02803C_DB_STENCIL_INFO, 8, 2743},
	{15617, R_028040_DB_Z_READ_BASE},
	{30264, R_028044_DB_Z_READ_BASE_HI, 1, 2751},
	{15632, R_028048_DB_STENCIL_READ_BASE},
	{30282, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2752},
	{30306, R_028054_DB_Z_WRITE_BASE_HI, 1, 2753},
	{15669, R_028058_DB_STENCIL_WRITE_BASE},
	{30325, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2754},
	{30350, R_028060_DB_DFSM_CONTROL, 3, 2755},
	{30366, R_028068_DB_Z_INFO2, 1, 2758},
	{30377, R_02806C_DB_STENCIL_INFO2, 1, 2759},
	{15755, R_0281E8_COHER_DEST_BASE_HI_0, 1, 2760},
	{15776, R_0281EC_COHER_DEST_BASE_HI_1, 1, 2761},
	{15797, R_0281F0_COHER_DEST_BASE_HI_2, 1, 2762},
	{15818, R_0281F4_COHER_DEST_BASE_HI_3, 1, 2763},
	{17715, R_028350_PA_SC_RASTER_CONFIG, 15, 2764},
	{17735, R_028354_PA_SC_RASTER_CONFIG_1, 3, 2779},
	{30394, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 3, 2782},
	{30423, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2785},
	{30444, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2786},
	{30466, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2790},
	{30487, R_0283A8_PA_SC_HORIZ_GRID, 4, 2794},
	{17921, R_028424_CB_DCC_CONTROL, 4, 2798},
	{21080, R_0286C4_SPI_VS_OUT_CONFIG, 2, 1362},
	{21154, R_0286D8_SPI_PS_IN_CONTROL, 5, 2802},
	{30504, R_0287A0_CB_MRT0_EPITCH, 1, 2807},
	{30519, R_0287A4_CB_MRT1_EPITCH, 1, 2808},
	{30534, R_0287A8_CB_MRT2_EPITCH, 1, 2809},
	{30549, R_0287AC_CB_MRT3_EPITCH, 1, 2810},
	{30564, R_0287B0_CB_MRT4_EPITCH, 1, 2811},
	{30579, R_0287B4_CB_MRT5_EPITCH, 1, 2812},
	{30594, R_0287B8_CB_MRT6_EPITCH, 1, 2813},
	{30609, R_0287BC_CB_MRT7_EPITCH, 1, 2814},
	{21736, R_0287E4_VGT_DMA_BASE_HI, 1, 2815},
	{21765, R_0287F0_VGT_DRAW_INITIATOR, 8, 2816},
	{21863, R_02880C_DB_SHADER_CONTROL, 16, 2824},
	{21897, R_028814_PA_SU_SC_MODE_CNTL, 15, 2840},
	{21916, R_028818_PA_CL_VTE_CNTL, 10, 2855},
	{21931, R_02881C_PA_CL_VS_OUT_CNTL, 28, 2865},
	{30624, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2893},
	{30646, R_028838_PA_CL_NGG_CNTL, 2, 2896},
	{30661, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2898},
	{30691, R_028840_PA_STEREO_CNTL},
	{22391, R_028A40_VGT_GS_MODE, 15, 2903},
	{22403, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 2918},
	{22422, R_028A48_PA_SC_MODE_CNTL_0, 7, 2921},
	{22643, R_028A7C_VGT_DMA_INDEX_TYPE, 7, 2928},
	{22673, R_028A84_VGT_PRIMITIVEID_EN, 3, 2935},
	{22736, R_028A90_VGT_EVENT_INITIATOR, 3, 2938},
	{30706, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2941},
	{30736, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2942},
	{22927, R_028ABC_DB_HTILE_SURFACE, 8, 2946},
	{23487, R_028B54_VGT_SHADER_STAGES_EN, 13, 2954},
	{23615, R_028B6C_VGT_TF_PARAM, 8, 2967},
	{23863, R_028B94_VGT_STRMOUT_CONFIG, 8, 2975},
	{30758, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2983},
	{23976, R_028BE0_PA_SC_AA_CONFIG, 6, 2986},
	{24691, R_028C40_PA_SC_SHADER_CONTROL, 3, 2992},
	{30782, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2995},
	{30802, R_028C48_PA_SC_BINNER_CNTL_1, 2, 3005},
	{30822, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 3007},
	{30860, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 3025},
	{30880, R_028C64_CB_COLOR0_BASE_EXT, 1, 3026},
	{30899, R_028C68_CB_COLOR0_ATTRIB2, 3, 3027},
	{24808, R_028C6C_CB_COLOR0_VIEW, 3, 3030},
	{24823, R_028C70_CB_COLOR0_INFO, 16, 3033},
	{24838, R_028C74_CB_COLOR0_ATTRIB, 10, 3049},
	{30917, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 3059},
	{30942, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 3060},
	{30967, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 3061},
	{30990, R_028CA0_CB_COLOR1_BASE_EXT, 1, 3026},
	{31009, R_028CA4_CB_COLOR1_ATTRIB2},
	{25063, R_028CA8_CB_COLOR1_VIEW, 3, 3030},
	{25078, R_028CAC_CB_COLOR1_INFO, 16, 3033},
	{25093, R_028CB0_CB_COLOR1_ATTRIB, 10, 3049},
	{31027, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 3059},
	{31052, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 3060},
	{31077, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 3061},
	{31100, R_028CDC_CB_COLOR2_BASE_EXT, 1, 3026},
	{31119, R_028CE0_CB_COLOR2_ATTRIB2},
	{25318, R_028CE4_CB_COLOR2_VIEW, 3, 3030},
	{25333, R_028CE8_CB_COLOR2_INFO, 16, 3033},
	{25348, R_028CEC_CB_COLOR2_ATTRIB, 10, 3049},
	{31137, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 3059},
	{31162, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 3060},
	{31187, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 3061},
	{31210, R_028D18_CB_COLOR3_BASE_EXT, 1, 3026},
	{31229, R_028D1C_CB_COLOR3_ATTRIB2},
	{25573, R_028D20_CB_COLOR3_VIEW, 3, 3030},
	{25588, R_028D24_CB_COLOR3_INFO, 16, 3033},
	{25603, R_028D28_CB_COLOR3_ATTRIB, 10, 3049},
	{31247, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 3059},
	{31272, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 3060},
	{31297, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 3061},
	{31320, R_028D54_CB_COLOR4_BASE_EXT, 1, 3026},
	{31339, R_028D58_CB_COLOR4_ATTRIB2},
	{25828, R_028D5C_CB_COLOR4_VIEW, 3, 3030},
	{25843, R_028D60_CB_COLOR4_INFO, 16, 3033},
	{25858, R_028D64_CB_COLOR4_ATTRIB, 10, 3049},
	{31357, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 3059},
	{31382, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 3060},
	{31407, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 3061},
	{31430, R_028D90_CB_COLOR5_BASE_EXT, 1, 3026},
	{31449, R_028D94_CB_COLOR5_ATTRIB2},
	{26083, R_028D98_CB_COLOR5_VIEW, 3, 3030},
	{26098, R_028D9C_CB_COLOR5_INFO, 16, 3033},
	{26113, R_028DA0_CB_COLOR5_ATTRIB, 10, 3049},
	{31467, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 3059},
	{31492, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 3060},
	{31517, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 3061},
	{31540, R_028DCC_CB_COLOR6_BASE_EXT, 1, 3026},
	{31559, R_028DD0_CB_COLOR6_ATTRIB2},
	{26338, R_028DD4_CB_COLOR6_VIEW, 3, 3030},
	{26353, R_028DD8_CB_COLOR6_INFO, 16, 3033},
	{26368, R_028DDC_CB_COLOR6_ATTRIB, 10, 3049},
	{31577, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 3059},
	{31602, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 3060},
	{31627, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 3061},
	{31650, R_028E08_CB_COLOR7_BASE_EXT, 1, 3026},
	{31669, R_028E0C_CB_COLOR7_ATTRIB2},
	{26593, R_028E10_CB_COLOR7_VIEW, 3, 3030},
	{26608, R_028E14_CB_COLOR7_INFO, 16, 3033},
	{26623, R_028E18_CB_COLOR7_ATTRIB, 10, 3049},
	{31687, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 3059},
	{31712, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 3060},
	{31737, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 3061},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{31760, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{31782, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{31804, S_370_ENGINE_SEL(~0u), 4, 0},
	{31815, S_370_WR_CONFIRM(~0u)},
	{31826, S_370_WR_ONE_ADDR(~0u)},
	{31877, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{31885, S_3F2_IB_SIZE(~0u)},
	{31893, S_3F2_CHAIN(~0u)},
	{31899, S_3F2_VALID(~0u)},
	/* 9 */
	{1009, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{31905, S_411_CP_SYNC(~0u)},
	{31937, S_411_SRC_SEL(~0u), 4, 10},
	{31945, S_411_ENGINE(~0u), 2, 0},
	{31877, S_411_DST_SEL(~0u), 4, 14},
	{1021, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{888, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{900, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{31976, S_414_BYTE_COUNT_GFX6(~0u)},
	{31992, S_414_BYTE_COUNT_GFX9(~0u)},
	{32008, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{32061, S_414_SRC_SWAP(~0u), 4, 18},
	{32070, S_414_DST_SWAP(~0u), 4, 18},
	{32086, S_414_SAS(~0u), 2, 22},
	{32090, S_414_DAS(~0u), 2, 22},
	{32117, S_414_SAIC(~0u), 2, 24},
	{32122, S_414_DAIC(~0u), 2, 24},
	{32127, S_414_RAW_WAIT(~0u)},
	{32136, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{31905, S_500_CP_SYNC(~0u)},
	{31937, S_500_SRC_SEL(~0u), 4, 10},
	{32160, S_500_DST_CACHE_POLICY(~0u)},
	{31877, S_500_DST_SEL(~0u), 4, 14},
	{32177, S_500_SRC_CACHE_POLICY(~0u)},
	{31945, S_500_ENGINE(~0u), 2, 0},
	/* 34 */
	{32194, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{32210, S_000E4C_TST_RQ_PENDING(~0u)},
	{32225, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{32242, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{32258, S_000E4C_VP8_BUSY(~0u)},
	{32267, S_000E4C_SDMA_BUSY(~0u)},
	{32277, S_000E4C_SDMA1_BUSY(~0u)},
	{32288, S_000E4C_VCE0_BUSY(~0u)},
	{32298, S_000E4C_XDMA_BUSY(~0u)},
	{32308, S_000E4C_CHUB_BUSY(~0u)},
	{32318, S_000E4C_SDMA2_BUSY(~0u)},
	{32329, S_000E4C_SDMA3_BUSY(~0u)},
	{32340, S_000E4C_SAMSCP_BUSY(~0u)},
	{32352, S_000E4C_ISP_BUSY(~0u)},
	{32361, S_000E4C_VCE1_BUSY(~0u)},
	{32371, S_000E4C_ODE_BUSY(~0u)},
	{32380, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{32397, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{32414, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{32432, S_000E4C_ISP_RQ_PENDING(~0u)},
	{32447, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 55 */
	{32463, S_000E50_UVD_RQ_PENDING(~0u)},
	{32478, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{32496, S_000E50_ACP_RQ_PENDING(~0u)},
	{32511, S_000E50_SMU_RQ_PENDING(~0u)},
	{32526, S_000E50_GRBM_RQ_PENDING(~0u)},
	{32542, S_000E50_HI_RQ_PENDING(~0u)},
	{32556, S_000E50_VMC_BUSY(~0u)},
	{32565, S_000E50_MCB_BUSY(~0u)},
	{32574, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{32595, S_000E50_MCC_BUSY(~0u)},
	{32604, S_000E50_MCD_BUSY(~0u)},
	{32613, S_000E50_VMC1_BUSY(~0u)},
	{32623, S_000E50_SEM_BUSY(~0u)},
	{32632, S_000E50_ACP_BUSY(~0u)},
	{32641, S_000E50_IH_BUSY(~0u)},
	{32649, S_000E50_UVD_BUSY(~0u)},
	{32658, S_000E50_SAMMSP_BUSY(~0u)},
	{32670, S_000E50_GCATCL2_BUSY(~0u)},
	{32683, S_000E50_OSATCL2_BUSY(~0u)},
	{32696, S_000E50_BIF_BUSY(~0u)},
	/* 75 */
	{32705, S_000E54_MCC0_BUSY(~0u)},
	{32715, S_000E54_MCC1_BUSY(~0u)},
	{32725, S_000E54_MCC2_BUSY(~0u)},
	{32735, S_000E54_MCC3_BUSY(~0u)},
	{32745, S_000E54_MCC4_BUSY(~0u)},
	{32755, S_000E54_MCC5_BUSY(~0u)},
	{32765, S_000E54_MCC6_BUSY(~0u)},
	{32775, S_000E54_MCC7_BUSY(~0u)},
	{32785, S_000E54_MCD0_BUSY(~0u)},
	{32795, S_000E54_MCD1_BUSY(~0u)},
	{32805, S_000E54_MCD2_BUSY(~0u)},
	{32815, S_000E54_MCD3_BUSY(~0u)},
	{32825, S_000E54_MCD4_BUSY(~0u)},
	{32835, S_000E54_MCD5_BUSY(~0u)},
	{32845, S_000E54_MCD6_BUSY(~0u)},
	{32855, S_000E54_MCD7_BUSY(~0u)},
	/* 91 */
	{32865, S_00D034_IDLE(~0u)},
	{32870, S_00D034_REG_IDLE(~0u)},
	{32879, S_00D034_RB_EMPTY(~0u)},
	{32888, S_00D034_RB_FULL(~0u)},
	{32896, S_00D034_RB_CMD_IDLE(~0u)},
	{32908, S_00D034_RB_CMD_FULL(~0u)},
	{32920, S_00D034_IB_CMD_IDLE(~0u)},
	{32932, S_00D034_IB_CMD_FULL(~0u)},
	{32944, S_00D034_BLOCK_IDLE(~0u)},
	{32955, S_00D034_INSIDE_IB(~0u)},
	{32965, S_00D034_EX_IDLE(~0u)},
	{32973, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{32999, S_00D034_PACKET_READY(~0u)},
	{33012, S_00D034_MC_WR_IDLE(~0u)},
	{33023, S_00D034_SRBM_IDLE(~0u)},
	{33033, S_00D034_CONTEXT_EMPTY(~0u)},
	{33047, S_00D034_DELTA_RPTR_FULL(~0u)},
	{33063, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{33079, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{33095, S_00D034_MC_RD_IDLE(~0u)},
	{33106, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{33123, S_00D034_MC_RD_RET_STALL(~0u)},
	{33139, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{33158, S_00D034_PREV_CMD_IDLE(~0u)},
	{33172, S_00D034_SEM_IDLE(~0u)},
	{33181, S_00D034_SEM_REQ_STALL(~0u)},
	{33195, S_00D034_SEM_RESP_STATE(~0u)},
	{33210, S_00D034_INT_IDLE(~0u)},
	{33219, S_00D034_INT_REQ_STALL(~0u)},
	/* 120 */
	{33233, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33256, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33279, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33302, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33322, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33342, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33362, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33382, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33402, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33422, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33442, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33462, S_008008_RLC_RQ_PENDING(~0u)},
	{33477, S_008008_RLC_BUSY(~0u)},
	{33486, S_008008_TC_BUSY(~0u)},
	{33494, S_008008_TCC_CC_RESIDENT(~0u)},
	{33510, S_008008_CPF_BUSY(~0u)},
	{33519, S_008008_CPC_BUSY(~0u)},
	{33528, S_008008_CPG_BUSY(~0u)},
	/* 138 */
	{33537, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{33560, S_008010_SRBM_RQ_PENDING(~0u)},
	{33576, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33599, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33622, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33641, S_008010_DB_CLEAN(~0u)},
	{33650, S_008010_CB_CLEAN(~0u)},
	{33659, S_008010_TA_BUSY(~0u)},
	{33667, S_008010_GDS_BUSY(~0u)},
	{33676, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33691, S_008010_VGT_BUSY(~0u)},
	{33700, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33715, S_008010_IA_BUSY(~0u)},
	{33723, S_008010_SX_BUSY(~0u)},
	{33731, S_008010_WD_BUSY(~0u)},
	{33739, S_008010_SPI_BUSY(~0u)},
	{33748, S_008010_BCI_BUSY(~0u)},
	{33757, S_008010_SC_BUSY(~0u)},
	{33765, S_008010_PA_BUSY(~0u)},
	{33773, S_008010_DB_BUSY(~0u)},
	{33781, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32344, S_008010_CP_BUSY(~0u)},
	{32566, S_008010_CB_BUSY(~0u)},
	{33799, S_008010_GUI_ACTIVE(~0u)},
	/* 162 */
	{33810, S_00802C_INSTANCE_INDEX(~0u)},
	{33825, S_00802C_SH_INDEX(~0u)},
	{33834, S_00802C_SE_INDEX(~0u)},
	{33843, S_00802C_SH_BROADCAST_WRITES(~0u)},
	{33863, S_00802C_INSTANCE_BROADCAST_WRITES(~0u)},
	{33889, S_00802C_SE_BROADCAST_WRITES(~0u)},
	/* 168 */
	{33909, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 169 */
	{33928, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{33944, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{33960, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{33978, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{33996, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{34014, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{34032, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{34050, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{34068, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{34086, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{34104, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{34121, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{34137, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{34153, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{34169, S_0085F0_TC_ACTION_ENA(~0u)},
	{34183, S_0085F0_CB_ACTION_ENA(~0u)},
	{34197, S_0085F0_DB_ACTION_ENA(~0u)},
	{34211, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34232, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 188 */
	{33641, S_008014_DB_CLEAN(~0u)},
	{33650, S_008014_CB_CLEAN(~0u)},
	{33748, S_008014_BCI_BUSY(~0u)},
	{33691, S_008014_VGT_BUSY(~0u)},
	{33765, S_008014_PA_BUSY(~0u)},
	{33659, S_008014_TA_BUSY(~0u)},
	{33723, S_008014_SX_BUSY(~0u)},
	{33739, S_008014_SPI_BUSY(~0u)},
	{33757, S_008014_SC_BUSY(~0u)},
	{33773, S_008014_DB_BUSY(~0u)},
	{32566, S_008014_CB_BUSY(~0u)},
	/* 199 */
	{33641, S_008018_DB_CLEAN(~0u)},
	{33650, S_008018_CB_CLEAN(~0u)},
	{33748, S_008018_BCI_BUSY(~0u)},
	{33691, S_008018_VGT_BUSY(~0u)},
	{33765, S_008018_PA_BUSY(~0u)},
	{33659, S_008018_TA_BUSY(~0u)},
	{33723, S_008018_SX_BUSY(~0u)},
	{33739, S_008018_SPI_BUSY(~0u)},
	{33757, S_008018_SC_BUSY(~0u)},
	{33773, S_008018_DB_BUSY(~0u)},
	{32566, S_008018_CB_BUSY(~0u)},
	/* 210 */
	{33641, S_008038_DB_CLEAN(~0u)},
	{33650, S_008038_CB_CLEAN(~0u)},
	{33748, S_008038_BCI_BUSY(~0u)},
	{33691, S_008038_VGT_BUSY(~0u)},
	{33765, S_008038_PA_BUSY(~0u)},
	{33659, S_008038_TA_BUSY(~0u)},
	{33723, S_008038_SX_BUSY(~0u)},
	{33739, S_008038_SPI_BUSY(~0u)},
	{33757, S_008038_SC_BUSY(~0u)},
	{33773, S_008038_DB_BUSY(~0u)},
	{32566, S_008038_CB_BUSY(~0u)},
	/* 221 */
	{33641, S_00803C_DB_CLEAN(~0u)},
	{33650, S_00803C_CB_CLEAN(~0u)},
	{33748, S_00803C_BCI_BUSY(~0u)},
	{33691, S_00803C_VGT_BUSY(~0u)},
	{33765, S_00803C_PA_BUSY(~0u)},
	{33659, S_00803C_TA_BUSY(~0u)},
	{33723, S_00803C_SX_BUSY(~0u)},
	{33739, S_00803C_SPI_BUSY(~0u)},
	{33757, S_00803C_SC_BUSY(~0u)},
	{33773, S_00803C_DB_BUSY(~0u)},
	{32566, S_00803C_CB_BUSY(~0u)},
	/* 232 */
	{33909, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 233 */
	{34253, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 234 */
	{34272, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 235 */
	{33928, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{33944, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{34290, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{34307, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{33960, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{33978, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{33996, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{34014, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{34032, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{34050, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{34068, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{34086, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{34104, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{34324, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34344, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{34362, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34121, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{34137, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{34153, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34169, S_0301F0_TC_ACTION_ENA(~0u)},
	{34183, S_0301F0_CB_ACTION_ENA(~0u)},
	{34197, S_0301F0_DB_ACTION_ENA(~0u)},
	{34211, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34379, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34232, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34404, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{34428, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 262 */
	{34445, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{34463, S_0301FC_MEID(~0u)},
	{34468, S_0301FC_PHASE1_STATUS(~0u)},
	{1051, S_0301FC_STATUS(~0u)},
	/* 266 */
	{34482, S_008210_MEC1_BUSY(~0u)},
	{34492, S_008210_MEC2_BUSY(~0u)},
	{34502, S_008210_DC0_BUSY(~0u)},
	{34511, S_008210_DC1_BUSY(~0u)},
	{34520, S_008210_RCIU1_BUSY(~0u)},
	{34531, S_008210_RCIU2_BUSY(~0u)},
	{34542, S_008210_ROQ1_BUSY(~0u)},
	{34552, S_008210_ROQ2_BUSY(~0u)},
	{34562, S_008210_TCIU_BUSY(~0u)},
	{34572, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34589, S_008210_QU_BUSY(~0u)},
	{34597, S_008210_ATCL2IU_BUSY(~0u)},
	{34610, S_008210_CPG_CPC_BUSY(~0u)},
	{34623, S_008210_CPF_CPC_BUSY(~0u)},
	{33519, S_008210_CPC_BUSY(~0u)},
	/* 281 */
	{34636, S_008214_MEC1_LOAD_BUSY(~0u)},
	{34651, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{34671, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{34687, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{34705, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{34725, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{34744, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{34763, S_008214_MEC1_TC_BUSY(~0u)},
	{34776, S_008214_MEC1_DMA_BUSY(~0u)},
	{34790, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{34814, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{34830, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{34846, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{34862, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{34878, S_008214_MEC2_LOAD_BUSY(~0u)},
	{34893, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{34913, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{34929, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{34947, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{34967, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{34986, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{35005, S_008214_MEC2_TC_BUSY(~0u)},
	{35018, S_008214_MEC2_DMA_BUSY(~0u)},
	{35032, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{35056, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{35072, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{35088, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{35104, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 309 */
	{35120, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35139, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35159, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35178, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35199, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35217, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35240, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35262, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35283, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35301, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35324, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{35346, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35370, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35394, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 323 */
	{35417, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35436, S_00821C_CSF_BUSY(~0u)},
	{35445, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35460, S_00821C_ROQ_RING_BUSY(~0u)},
	{35474, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35493, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35512, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35527, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35544, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35566, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35588, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35603, S_00821C_INTERRUPT_BUSY(~0u)},
	{34562, S_00821C_TCIU_BUSY(~0u)},
	{35618, S_00821C_HQD_BUSY(~0u)},
	{35627, S_00821C_PRT_BUSY(~0u)},
	{34597, S_00821C_ATCL2IU_BUSY(~0u)},
	{35636, S_00821C_CPF_GFX_BUSY(~0u)},
	{35649, S_00821C_CPF_CMP_BUSY(~0u)},
	{35662, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35681, S_00821C_CPC_CPF_BUSY(~0u)},
	{33510, S_00821C_CPF_BUSY(~0u)},
	/* 344 */
	{35694, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{35712, S_008220_CSF_RING_BUSY(~0u)},
	{35726, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{35745, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{35764, S_008220_CSF_STATE_BUSY(~0u)},
	{35779, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{35797, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{35815, S_008220_CSF_ARBITER_BUSY(~0u)},
	{35832, S_008220_CSF_INPUT_BUSY(~0u)},
	{35847, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{35869, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{35893, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{35911, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{35929, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{35950, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{35974, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{36000, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{36017, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{36037, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{36057, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{36077, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{36098, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{36121, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{36142, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{36161, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{36178, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{36194, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{36210, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{36226, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{36245, S_008220_HQD_PQ_BUSY(~0u)},
	{36257, S_008220_HQD_IB_BUSY(~0u)},
	/* 375 */
	{36269, S_008224_RING_FETCHING_DATA(~0u)},
	{36288, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36308, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36328, S_008224_STATE_FETCHING_DATA(~0u)},
	{36348, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36369, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{35346, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35370, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35394, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 384 */
	{36390, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 385 */
	{36409, S_0088B0_PRIM_COUNT(~0u)},
	/* 386 */
	{36420, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{36439, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{36460, S_0088C4_ES_LIMIT(~0u)},
	/* 389 */
	{36469, S_0088D4_VERT_REUSE(~0u)},
	/* 390 */
	{22249, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 391 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 392 */
	{38, S_008988_SIZE(~0u)},
	/* 393 */
	{37038, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 394 */
	{37056, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{37077, S_008A14_NUM_CLIP_SEQ(~0u)},
	{37090, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{37113, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 398 */
	{1823, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 399 */
	{37133, S_008B10_CURRENT_PTR(~0u)},
	{37145, S_008B10_CURRENT_COUNT(~0u)},
	/* 401 */
	{37159, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37184, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37222, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37263, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37286, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37309, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37333, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37363, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37392, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37418, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37447, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37472, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36348, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36369, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37507, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37535, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{35346, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35370, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35394, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 420 */
	{37565, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{37592, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{37619, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{37648, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{37677, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{37706, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37734, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{37764, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{37791, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{37819, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{37844, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{37870, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{37895, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{37919, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{37944, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{37972, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 436 */
	{38001, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{38027, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{38053, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38080, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{38106, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{38128, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{38155, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{38177, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{38201, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{38226, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38249, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{38276, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{38301, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{38329, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38354, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38379, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{38404, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{38433, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{38464, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{38492, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{38519, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{38549, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{38576, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{38603, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{38630, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{38656, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{38680, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{38712, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{38739, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 465 */
	{35460, S_008680_ROQ_RING_BUSY(~0u)},
	{35474, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35493, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35512, S_008680_ROQ_STATE_BUSY(~0u)},
	{38765, S_008680_DC_BUSY(~0u)},
	{34597, S_008680_ATCL2IU_BUSY(~0u)},
	{38773, S_008680_PFP_BUSY(~0u)},
	{38782, S_008680_MEQ_BUSY(~0u)},
	{38791, S_008680_ME_BUSY(~0u)},
	{38799, S_008680_QUERY_BUSY(~0u)},
	{35588, S_008680_SEMAPHORE_BUSY(~0u)},
	{35603, S_008680_INTERRUPT_BUSY(~0u)},
	{38810, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32268, S_008680_DMA_BUSY(~0u)},
	{38828, S_008680_RCIU_BUSY(~0u)},
	{34572, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38838, S_008680_CPC_CPG_BUSY(~0u)},
	{38851, S_008680_CE_BUSY(~0u)},
	{34562, S_008680_TCIU_BUSY(~0u)},
	{35527, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35544, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35566, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32344, S_008680_CP_BUSY(~0u)},
	/* 488 */
	{33810, S_030800_INSTANCE_INDEX(~0u)},
	{33825, S_030800_SH_INDEX(~0u)},
	{33834, S_030800_SE_INDEX(~0u)},
	{33843, S_030800_SH_BROADCAST_WRITES(~0u)},
	{33863, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{33889, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 494 */
	{22249, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 495 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 496 */
	{38, S_030938_SIZE(~0u)},
	/* 497 */
	{37038, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38907, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 499 */
	{1823, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 500 */
	{37133, S_030A04_CURRENT_PTR(~0u)},
	{37145, S_030A04_CURRENT_COUNT(~0u)},
	/* 502 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 504 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 506 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 508 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 510 */
	{38927, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{38953, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{38976, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{39001, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{39032, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{39066, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{39086, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{39113, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{39141, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 519 */
	{39176, S_008C08_INST_INVALIDATE(~0u)},
	{39192, S_008C08_DATA_INVALIDATE(~0u)},
	/* 521 */
	{39176, S_030D20_INST_INVALIDATE(~0u)},
	{39192, S_030D20_DATA_INVALIDATE(~0u)},
	{39208, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 524 */
	{39228, S_008C0C_RET(~0u)},
	{39232, S_008C0C_RUI(~0u)},
	{39236, S_008C0C_RNG(~0u)},
	/* 527 */
	{2617, S_008DFC_EN(~0u)},
	{39299, S_008DFC_TGT(~0u), 33, 90},
	{39303, S_008DFC_COMPR(~0u)},
	{33923, S_008DFC_DONE(~0u)},
	{39309, S_008DFC_VM(~0u)},
	{39329, S_008DFC_ENCODING(~0u), 63, 123},
	/* 533 */
	{2880, S_030E04_ADDRESS(~0u)},
	/* 534 */
	{2837, S_030F04_COUNT_HI(~0u)},
	/* 535 */
	{39338, S_008F04_BASE_ADDRESS_HI(~0u)},
	{23438, S_008F04_STRIDE(~0u)},
	{39354, S_008F04_CACHE_SWIZZLE(~0u)},
	{39368, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 539 */
	{2837, S_030F0C_COUNT_HI(~0u)},
	/* 540 */
	{39473, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39483, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39493, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39503, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39687, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{40079, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{40091, S_008F0C_ELEMENT_SIZE(~0u)},
	{40104, S_008F0C_INDEX_STRIDE(~0u)},
	{40117, S_008F0C_ADD_TID_ENABLE(~0u)},
	{40132, S_008F0C_ATC(~0u)},
	{40136, S_008F0C_HASH_ENABLE(~0u)},
	{40148, S_008F0C_HEAP(~0u)},
	{40153, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 554 */
	{2837, S_030F14_COUNT_HI(~0u)},
	/* 555 */
	{39338, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40228, S_008F14_MIN_LOD(~0u)},
	{41861, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{42245, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{40153, S_008F14_MTYPE(~0u)},
	/* 560 */
	{42261, S_008F18_WIDTH(~0u)},
	{42267, S_008F18_HEIGHT(~0u)},
	{42274, S_008F18_PERF_MOD(~0u)},
	{42283, S_008F18_INTERLACED(~0u)},
	/* 564 */
	{2837, S_030F1C_COUNT_HI(~0u)},
	/* 565 */
	{39473, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39483, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39493, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39503, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42294, S_008F1C_BASE_LEVEL(~0u)},
	{42305, S_008F1C_LAST_LEVEL(~0u)},
	{42316, S_008F1C_TILING_INDEX(~0u)},
	{42329, S_008F1C_POW2_PAD(~0u)},
	{40153, S_008F1C_MTYPE(~0u)},
	{40132, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 576 */
	{22233, S_008F20_DEPTH(~0u)},
	{42640, S_008F20_PITCH_GFX6(~0u)},
	/* 578 */
	{42651, S_008F24_BASE_ARRAY(~0u)},
	{42662, S_008F24_LAST_ARRAY(~0u)},
	/* 580 */
	{42673, S_008F28_MIN_LOD_WARN(~0u)},
	{42686, S_008F28_COUNTER_BANK_ID(~0u)},
	{42702, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{42717, S_008F28_COMPRESSION_EN(~0u)},
	{42732, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{42748, S_008F28_COLOR_TRANSFORM(~0u)},
	{42764, S_008F28_LOST_ALPHA_BITS(~0u)},
	{42780, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 588 */
	{42978, S_008F30_CLAMP_X(~0u), 8, 318},
	{42986, S_008F30_CLAMP_Y(~0u), 8, 318},
	{42994, S_008F30_CLAMP_Z(~0u), 8, 318},
	{43002, S_008F30_MAX_ANISO_RATIO(~0u)},
	{43250, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{43269, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{43288, S_008F30_ANISO_THRESHOLD(~0u)},
	{43304, S_008F30_MC_COORD_TRUNC(~0u)},
	{43319, S_008F30_FORCE_DEGAMMA(~0u)},
	{43333, S_008F30_ANISO_BIAS(~0u)},
	{43344, S_008F30_TRUNC_COORD(~0u)},
	{43356, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{43445, S_008F30_FILTER_MODE(~0u), 3, 334},
	{43457, S_008F30_COMPAT_MODE(~0u)},
	/* 602 */
	{40228, S_008F34_MIN_LOD(~0u)},
	{43469, S_008F34_MAX_LOD(~0u)},
	{43477, S_008F34_PERF_MIP(~0u)},
	{43486, S_008F34_PERF_Z(~0u)},
	/* 606 */
	{43493, S_008F38_LOD_BIAS(~0u)},
	{43502, S_008F38_LOD_BIAS_SEC(~0u)},
	{43564, S_008F38_XY_MAG_FILTER(~0u), 2, 337},
	{43639, S_008F38_XY_MIN_FILTER(~0u), 4, 339},
	{43719, S_008F38_Z_FILTER(~0u), 3, 343},
	{43728, S_008F38_MIP_FILTER(~0u), 3, 343},
	{43739, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{43758, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{43775, S_008F38_FILTER_PREC_FIX(~0u)},
	{43791, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 616 */
	{43806, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{43823, S_008F3C_UPGRADED_DEPTH(~0u)},
	{43965, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 346},
	/* 619 */
	{43983, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{44000, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{44017, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{44034, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{44051, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 624 */
	{44068, S_0090E0_PS_CU_EN(~0u)},
	{44077, S_0090E0_VS_CU_EN(~0u)},
	/* 626 */
	{44086, S_0090E4_GS_CU_EN(~0u)},
	{44095, S_0090E4_ES_CU_EN(~0u)},
	/* 628 */
	{44104, S_0090E8_LSHS_CU_EN(~0u)},
	/* 629 */
	{2702, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 630 */
	{2702, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 631 */
	{44120, S_0090F0_RING_ORDER_TS0(~0u), 1, 350},
	{44135, S_0090F0_RING_ORDER_TS1(~0u)},
	{44150, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 634 */
	{44165, S_00C700_PIPE_ORDER_TS0(~0u)},
	{44180, S_00C700_PIPE_ORDER_TS1(~0u)},
	{44195, S_00C700_PIPE_ORDER_TS2(~0u)},
	{44210, S_00C700_PIPE_ORDER_TS3(~0u)},
	{44225, S_00C700_TS0_DUR_MULT(~0u)},
	{44238, S_00C700_TS1_DUR_MULT(~0u)},
	{44251, S_00C700_TS2_DUR_MULT(~0u)},
	{44264, S_00C700_TS3_DUR_MULT(~0u)},
	/* 642 */
	{44277, S_0090F4_TS0_DURATION(~0u)},
	{44290, S_0090F4_TS1_DURATION(~0u)},
	/* 644 */
	{44303, S_0090F8_TS2_DURATION(~0u)},
	/* 645 */
	{38, S_008F40_SIZE(~0u)},
	/* 646 */
	{676, S_008F44_OFFSET(~0u)},
	/* 647 */
	{2837, S_030FFC_COUNT_HI(~0u)},
	/* 648 */
	{441, S_031074_INDEX(~0u)},
	/* 649 */
	{44316, S_031078_SPACE_AVAILABLE(~0u)},
	/* 650 */
	{44332, S_03107C_DS_ADDRESS(~0u)},
	{44343, S_03107C_CRAWLER(~0u)},
	{44351, S_03107C_CRAWLER_TYPE(~0u)},
	{44364, S_03107C_NO_ALLOC(~0u)},
	{7762, S_03107C_ENABLE(~0u)},
	/* 655 */
	{1836, S_031080_VALUE(~0u)},
	{2895, S_031080_INCDEC(~0u)},
	/* 657 */
	{1497, S_031084_RING_SIZE(~0u)},
	/* 658 */
	{44373, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{44392, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{44411, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44433, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44455, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 663 */
	{44724, S_00913C_VTX_DONE_DELAY(~0u), 16, 351},
	{44739, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{44763, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{44779, S_00913C_PC_LIMIT_STRICT(~0u)},
	{44795, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 668 */
	{44809, S_00936C_TYPE_A(~0u)},
	{44816, S_00936C_VGPR_A(~0u)},
	{44823, S_00936C_SGPR_A(~0u)},
	{44830, S_00936C_LDS_A(~0u)},
	{44836, S_00936C_WAVES_A(~0u)},
	{44844, S_00936C_EN_A(~0u)},
	{44849, S_00936C_TYPE_B(~0u)},
	{44856, S_00936C_VGPR_B(~0u)},
	{44863, S_00936C_SGPR_B(~0u)},
	{44870, S_00936C_LDS_B(~0u)},
	{44876, S_00936C_WAVES_B(~0u)},
	{44884, S_00936C_EN_B(~0u)},
	/* 680 */
	{44889, S_009858_MSAA1_X(~0u)},
	{44897, S_009858_MSAA1_Y(~0u)},
	{44905, S_009858_MSAA2_X(~0u)},
	{44913, S_009858_MSAA2_Y(~0u)},
	{44921, S_009858_MSAA4_X(~0u)},
	{44929, S_009858_MSAA4_Y(~0u)},
	{44937, S_009858_MSAA8_X(~0u)},
	{44945, S_009858_MSAA8_Y(~0u)},
	{44953, S_009858_MSAA16_X(~0u)},
	{44962, S_009858_MSAA16_Y(~0u)},
	/* 690 */
	{44971, S_0098F8_NUM_PIPES(~0u)},
	{44981, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{45007, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{45028, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{45052, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{45076, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{45090, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{45110, S_0098F8_ROW_SIZE(~0u)},
	{45119, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 699 */
	{45252, S_009910_MICRO_TILE_MODE(~0u), 4, 367},
	{45497, S_009910_ARRAY_MODE(~0u), 16, 371},
	{45859, S_009910_PIPE_CONFIG(~0u), 15, 387},
	{46049, S_009910_TILE_SPLIT(~0u), 7, 402},
	{46152, S_009910_BANK_WIDTH(~0u), 4, 409},
	{46259, S_009910_BANK_HEIGHT(~0u), 4, 413},
	{46371, S_009910_MACRO_TILE_ASPECT(~0u), 4, 417},
	{46458, S_009910_NUM_BANKS(~0u), 4, 421},
	{46499, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 425},
	{46519, S_009910_SAMPLE_SPLIT(~0u)},
	/* 709 */
	{46152, S_009990_BANK_WIDTH(~0u)},
	{46259, S_009990_BANK_HEIGHT(~0u)},
	{46371, S_009990_MACRO_TILE_ASPECT(~0u)},
	{46458, S_009990_NUM_BANKS(~0u)},
	/* 713 */
	{46532, S_00B004_MEM_BASE(~0u)},
	/* 714 */
	{46532, S_00B00C_MEM_BASE(~0u)},
	/* 715 */
	{44071, S_00B01C_CU_EN(~0u)},
	{46541, S_00B01C_WAVE_LIMIT(~0u)},
	{46552, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 718 */
	{46532, S_00B024_MEM_BASE(~0u)},
	/* 719 */
	{46571, S_00B028_VGPRS(~0u)},
	{46577, S_00B028_SGPRS(~0u)},
	{2722, S_00B028_PRIORITY(~0u)},
	{46626, S_00B028_FLOAT_MODE(~0u), 241, 429},
	{46637, S_00B028_PRIV(~0u)},
	{46642, S_00B028_DX10_CLAMP(~0u)},
	{46653, S_00B028_DEBUG_MODE(~0u)},
	{46664, S_00B028_IEEE_MODE(~0u)},
	{46674, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46691, S_00B028_CACHE_CTL(~0u)},
	{46701, S_00B028_CDBG_USER(~0u)},
	/* 730 */
	{46711, S_00B02C_SCRATCH_EN(~0u)},
	{46722, S_00B02C_USER_SGPR(~0u)},
	{46732, S_00B02C_TRAP_PRESENT(~0u)},
	{46745, S_00B02C_WAVE_CNT_EN(~0u)},
	{46757, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46772, S_00B02C_EXCP_EN_SI(~0u)},
	{46783, S_00B02C_EXCP_EN(~0u)},
	/* 737 */
	{46532, S_00B104_MEM_BASE(~0u)},
	/* 738 */
	{46532, S_00B10C_MEM_BASE(~0u)},
	/* 739 */
	{44071, S_00B118_CU_EN(~0u)},
	{46541, S_00B118_WAVE_LIMIT(~0u)},
	{46552, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 742 */
	{36463, S_00B11C_LIMIT(~0u)},
	/* 743 */
	{46532, S_00B124_MEM_BASE(~0u)},
	/* 744 */
	{46571, S_00B128_VGPRS(~0u)},
	{46577, S_00B128_SGPRS(~0u)},
	{2722, S_00B128_PRIORITY(~0u)},
	{46626, S_00B128_FLOAT_MODE(~0u)},
	{46637, S_00B128_PRIV(~0u)},
	{46642, S_00B128_DX10_CLAMP(~0u)},
	{46653, S_00B128_DEBUG_MODE(~0u)},
	{46664, S_00B128_IEEE_MODE(~0u)},
	{46791, S_00B128_VGPR_COMP_CNT(~0u)},
	{46805, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46691, S_00B128_CACHE_CTL(~0u)},
	{46701, S_00B128_CDBG_USER(~0u)},
	/* 756 */
	{46711, S_00B12C_SCRATCH_EN(~0u)},
	{46722, S_00B12C_USER_SGPR(~0u)},
	{46732, S_00B12C_TRAP_PRESENT(~0u)},
	{46821, S_00B12C_OC_LDS_EN(~0u)},
	{46831, S_00B12C_SO_BASE0_EN(~0u)},
	{46843, S_00B12C_SO_BASE1_EN(~0u)},
	{46855, S_00B12C_SO_BASE2_EN(~0u)},
	{46867, S_00B12C_SO_BASE3_EN(~0u)},
	{46879, S_00B12C_SO_EN(~0u)},
	{46772, S_00B12C_EXCP_EN_SI(~0u)},
	{46783, S_00B12C_EXCP_EN(~0u)},
	{46885, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 768 */
	{46532, S_00B204_MEM_BASE(~0u)},
	/* 769 */
	{46532, S_00B20C_MEM_BASE(~0u)},
	/* 770 */
	{44071, S_00B21C_CU_EN(~0u)},
	{46541, S_00B21C_WAVE_LIMIT(~0u)},
	{46552, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{46902, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 774 */
	{46532, S_00B224_MEM_BASE(~0u)},
	/* 775 */
	{46571, S_00B228_VGPRS(~0u)},
	{46577, S_00B228_SGPRS(~0u)},
	{2722, S_00B228_PRIORITY(~0u)},
	{46626, S_00B228_FLOAT_MODE(~0u)},
	{46637, S_00B228_PRIV(~0u)},
	{46642, S_00B228_DX10_CLAMP(~0u)},
	{46653, S_00B228_DEBUG_MODE(~0u)},
	{46664, S_00B228_IEEE_MODE(~0u)},
	{46805, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46691, S_00B228_CACHE_CTL(~0u)},
	{46701, S_00B228_CDBG_USER(~0u)},
	/* 786 */
	{46711, S_00B22C_SCRATCH_EN(~0u)},
	{46722, S_00B22C_USER_SGPR(~0u)},
	{46732, S_00B22C_TRAP_PRESENT(~0u)},
	{46772, S_00B22C_EXCP_EN_SI(~0u)},
	{46783, S_00B22C_EXCP_EN(~0u)},
	/* 791 */
	{46532, S_00B304_MEM_BASE(~0u)},
	/* 792 */
	{46532, S_00B30C_MEM_BASE(~0u)},
	/* 793 */
	{44071, S_00B31C_CU_EN(~0u)},
	{46541, S_00B31C_WAVE_LIMIT(~0u)},
	{46552, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{46902, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 797 */
	{46532, S_00B324_MEM_BASE(~0u)},
	/* 798 */
	{46571, S_00B328_VGPRS(~0u)},
	{46577, S_00B328_SGPRS(~0u)},
	{2722, S_00B328_PRIORITY(~0u)},
	{46626, S_00B328_FLOAT_MODE(~0u)},
	{46637, S_00B328_PRIV(~0u)},
	{46642, S_00B328_DX10_CLAMP(~0u)},
	{46653, S_00B328_DEBUG_MODE(~0u)},
	{46664, S_00B328_IEEE_MODE(~0u)},
	{46791, S_00B328_VGPR_COMP_CNT(~0u)},
	{46805, S_00B328_CU_GROUP_ENABLE(~0u)},
	{46691, S_00B328_CACHE_CTL(~0u)},
	{46701, S_00B328_CDBG_USER(~0u)},
	/* 810 */
	{46711, S_00B32C_SCRATCH_EN(~0u)},
	{46722, S_00B32C_USER_SGPR(~0u)},
	{46732, S_00B32C_TRAP_PRESENT(~0u)},
	{46821, S_00B32C_OC_LDS_EN(~0u)},
	{46772, S_00B32C_EXCP_EN_SI(~0u)},
	{46783, S_00B32C_EXCP_EN(~0u)},
	{46763, S_00B32C_LDS_SIZE(~0u)},
	/* 817 */
	{46532, S_00B404_MEM_BASE(~0u)},
	/* 818 */
	{46532, S_00B40C_MEM_BASE(~0u)},
	/* 819 */
	{46541, S_00B41C_WAVE_LIMIT(~0u)},
	{46552, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{46902, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 822 */
	{46532, S_00B424_MEM_BASE(~0u)},
	/* 823 */
	{46571, S_00B428_VGPRS(~0u)},
	{46577, S_00B428_SGPRS(~0u)},
	{2722, S_00B428_PRIORITY(~0u)},
	{46626, S_00B428_FLOAT_MODE(~0u)},
	{46637, S_00B428_PRIV(~0u)},
	{46642, S_00B428_DX10_CLAMP(~0u)},
	{46653, S_00B428_DEBUG_MODE(~0u)},
	{46664, S_00B428_IEEE_MODE(~0u)},
	{46691, S_00B428_CACHE_CTL(~0u)},
	{46701, S_00B428_CDBG_USER(~0u)},
	/* 833 */
	{46711, S_00B42C_SCRATCH_EN(~0u)},
	{46722, S_00B42C_USER_SGPR(~0u)},
	{46732, S_00B42C_TRAP_PRESENT(~0u)},
	{46821, S_00B42C_OC_LDS_EN(~0u)},
	{46919, S_00B42C_TG_SIZE_EN(~0u)},
	{46772, S_00B42C_EXCP_EN_SI(~0u)},
	{46930, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	/* 840 */
	{46532, S_00B504_MEM_BASE(~0u)},
	/* 841 */
	{46532, S_00B50C_MEM_BASE(~0u)},
	/* 842 */
	{44071, S_00B51C_CU_EN(~0u)},
	{46541, S_00B51C_WAVE_LIMIT(~0u)},
	{46552, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{46902, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 846 */
	{46532, S_00B524_MEM_BASE(~0u)},
	/* 847 */
	{46571, S_00B528_VGPRS(~0u)},
	{46577, S_00B528_SGPRS(~0u)},
	{2722, S_00B528_PRIORITY(~0u)},
	{46626, S_00B528_FLOAT_MODE(~0u)},
	{46637, S_00B528_PRIV(~0u)},
	{46642, S_00B528_DX10_CLAMP(~0u)},
	{46653, S_00B528_DEBUG_MODE(~0u)},
	{46664, S_00B528_IEEE_MODE(~0u)},
	{46791, S_00B528_VGPR_COMP_CNT(~0u)},
	{46691, S_00B528_CACHE_CTL(~0u)},
	{46701, S_00B528_CDBG_USER(~0u)},
	/* 858 */
	{46711, S_00B52C_SCRATCH_EN(~0u)},
	{46722, S_00B52C_USER_SGPR(~0u)},
	{46732, S_00B52C_TRAP_PRESENT(~0u)},
	{46763, S_00B52C_LDS_SIZE(~0u)},
	{46772, S_00B52C_EXCP_EN_SI(~0u)},
	{46783, S_00B52C_EXCP_EN(~0u)},
	/* 864 */
	{46945, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46963, S_00B800_PARTIAL_TG_EN(~0u)},
	{46977, S_00B800_FORCE_START_AT_000(~0u)},
	{46996, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{47016, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{47036, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{47058, S_00B800_ORDER_MODE(~0u)},
	{47069, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{47089, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{47107, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{47125, S_00B800_DATA_ATC(~0u)},
	{47134, S_00B800_RESTORE(~0u)},
	/* 876 */
	{47142, S_00B81C_NUM_THREAD_FULL(~0u)},
	{47158, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 878 */
	{47142, S_00B820_NUM_THREAD_FULL(~0u)},
	{47158, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 880 */
	{47142, S_00B824_NUM_THREAD_FULL(~0u)},
	{47158, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 882 */
	{2702, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 883 */
	{7749, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 884 */
	{7777, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 885 */
	{391, S_00B834_DATA(~0u)},
	{47177, S_00B834_INST_ATC(~0u)},
	/* 887 */
	{391, S_00B83C_DATA(~0u)},
	/* 888 */
	{391, S_00B844_DATA(~0u)},
	/* 889 */
	{46571, S_00B848_VGPRS(~0u)},
	{46577, S_00B848_SGPRS(~0u)},
	{2722, S_00B848_PRIORITY(~0u)},
	{46626, S_00B848_FLOAT_MODE(~0u)},
	{46637, S_00B848_PRIV(~0u)},
	{46642, S_00B848_DX10_CLAMP(~0u)},
	{46653, S_00B848_DEBUG_MODE(~0u)},
	{46664, S_00B848_IEEE_MODE(~0u)},
	{47186, S_00B848_BULKY(~0u)},
	{46701, S_00B848_CDBG_USER(~0u)},
	/* 899 */
	{46711, S_00B84C_SCRATCH_EN(~0u)},
	{46722, S_00B84C_USER_SGPR(~0u)},
	{46732, S_00B84C_TRAP_PRESENT(~0u)},
	{47192, S_00B84C_TGID_X_EN(~0u)},
	{47202, S_00B84C_TGID_Y_EN(~0u)},
	{47212, S_00B84C_TGID_Z_EN(~0u)},
	{46919, S_00B84C_TG_SIZE_EN(~0u)},
	{47222, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47237, S_00B84C_EXCP_EN_MSB(~0u)},
	{46763, S_00B84C_LDS_SIZE(~0u)},
	{46783, S_00B84C_EXCP_EN(~0u)},
	/* 910 */
	{391, S_00B850_DATA(~0u)},
	/* 911 */
	{47249, S_00B854_WAVES_PER_SH_SI(~0u)},
	{47265, S_00B854_WAVES_PER_SH(~0u)},
	{47278, S_00B854_TG_PER_CU(~0u)},
	{47288, S_00B854_LOCK_THRESHOLD(~0u)},
	{47303, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47318, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47334, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 918 */
	{47349, S_00B858_SH0_CU_EN(~0u)},
	{47359, S_00B858_SH1_CU_EN(~0u)},
	/* 920 */
	{47349, S_00B85C_SH0_CU_EN(~0u)},
	{47359, S_00B85C_SH1_CU_EN(~0u)},
	/* 922 */
	{47369, S_00B860_WAVES(~0u)},
	{47375, S_00B860_WAVESIZE(~0u)},
	/* 924 */
	{47349, S_00B864_SH0_CU_EN(~0u)},
	{47359, S_00B864_SH1_CU_EN(~0u)},
	/* 926 */
	{47349, S_00B868_SH0_CU_EN(~0u)},
	{47359, S_00B868_SH1_CU_EN(~0u)},
	/* 928 */
	{47384, S_00B87C_SEND_SEID(~0u)},
	{45580, S_00B87C_RESERVED2(~0u)},
	{47394, S_00B87C_RESERVED3(~0u)},
	{47404, S_00B87C_RESERVED4(~0u)},
	{47414, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 933 */
	{47427, S_00B888_PAYLOAD(~0u)},
	{47435, S_00B888_IS_EVENT(~0u)},
	{47444, S_00B888_IS_STATE(~0u)},
	/* 936 */
	{2097, S_00B890_ADDR(~0u)},
	/* 937 */
	{40132, S_00B894_ATC(~0u)},
	{40153, S_00B894_MTYPE(~0u)},
	/* 939 */
	{9024, S_034404_PERFCOUNTER_HI(~0u)},
	/* 940 */
	{47453, S_036008_PERF_SEL(~0u)},
	{47462, S_036008_PERF_SEL1(~0u)},
	{47472, S_036008_CNTR_MODE(~0u)},
	/* 943 */
	{47482, S_036004_PERF_SEL2(~0u)},
	{47492, S_036004_PERF_SEL3(~0u)},
	/* 945 */
	{47453, S_036024_PERF_SEL(~0u)},
	{47462, S_036024_PERF_SEL1(~0u)},
	{47472, S_036024_CNTR_MODE(~0u)},
	/* 948 */
	{47482, S_036010_PERF_SEL2(~0u)},
	{47492, S_036010_PERF_SEL3(~0u)},
	/* 950 */
	{47453, S_03601C_PERF_SEL(~0u)},
	{47462, S_03601C_PERF_SEL1(~0u)},
	{47472, S_03601C_CNTR_MODE(~0u)},
	/* 953 */
	{47482, S_036018_PERF_SEL2(~0u)},
	{47492, S_036018_PERF_SEL3(~0u)},
	/* 955 */
	{47549, S_036020_PERFMON_STATE(~0u), 3, 670},
	{47563, S_036020_SPM_PERFMON_STATE(~0u)},
	{47581, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{47601, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 959 */
	{47453, S_036100_PERF_SEL(~0u)},
	{47623, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47677, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47704, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47835, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47915, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47941, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47967, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{48021, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{48048, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{48074, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 978 */
	{47453, S_036108_PERF_SEL(~0u)},
	{47623, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 990 */
	{47453, S_03610C_PERF_SEL(~0u)},
	{47623, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1002 */
	{47453, S_036110_PERF_SEL(~0u)},
	{47623, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1014 */
	{47453, S_036114_PERF_SEL(~0u)},
	{47623, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1026 */
	{47453, S_036200_PERF_SEL(~0u)},
	{48100, S_036200_PERF_MODE(~0u)},
	/* 1028 */
	{47453, S_036210_PERF_SEL(~0u)},
	{47462, S_036210_PERF_SEL1(~0u)},
	{47472, S_036210_CNTR_MODE(~0u)},
	{48110, S_036210_PERF_MODE1(~0u)},
	{48100, S_036210_PERF_MODE(~0u)},
	/* 1033 */
	{47482, S_036220_PERF_SEL2(~0u)},
	{47492, S_036220_PERF_SEL3(~0u)},
	{48121, S_036220_PERF_MODE3(~0u)},
	{48132, S_036220_PERF_MODE2(~0u)},
	/* 1037 */
	{47453, S_036230_PERF_SEL(~0u)},
	{47462, S_036230_PERF_SEL1(~0u)},
	{47472, S_036230_CNTR_MODE(~0u)},
	{48110, S_036230_PERF_MODE1(~0u)},
	{48100, S_036230_PERF_MODE(~0u)},
	/* 1042 */
	{47482, S_036240_PERF_SEL2(~0u)},
	{47492, S_036240_PERF_SEL3(~0u)},
	{48121, S_036240_PERF_MODE3(~0u)},
	{48132, S_036240_PERF_MODE2(~0u)},
	/* 1046 */
	{48143, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1047 */
	{47453, S_036400_PERF_SEL(~0u)},
	{47462, S_036400_PERF_SEL1(~0u)},
	{47472, S_036400_CNTR_MODE(~0u)},
	/* 1050 */
	{47482, S_036404_PERF_SEL2(~0u)},
	{47492, S_036404_PERF_SEL3(~0u)},
	/* 1052 */
	{47453, S_036500_PERF_SEL(~0u)},
	{47462, S_036500_PERF_SEL1(~0u)},
	{47472, S_036500_CNTR_MODE(~0u)},
	/* 1055 */
	{47482, S_036504_PERF_SEL2(~0u)},
	{47492, S_036504_PERF_SEL3(~0u)},
	/* 1057 */
	{47453, S_036600_PERF_SEL(~0u)},
	{47462, S_036600_PERF_SEL1(~0u)},
	{47472, S_036600_CNTR_MODE(~0u)},
	/* 1060 */
	{47482, S_036610_PERF_SEL2(~0u)},
	{47492, S_036610_PERF_SEL3(~0u)},
	/* 1062 */
	{48165, S_036628_BIN0_MIN(~0u)},
	{48174, S_036628_BIN0_MAX(~0u)},
	{48183, S_036628_BIN1_MIN(~0u)},
	{48192, S_036628_BIN1_MAX(~0u)},
	{48201, S_036628_BIN2_MIN(~0u)},
	{48210, S_036628_BIN2_MAX(~0u)},
	{48219, S_036628_BIN3_MIN(~0u)},
	{48228, S_036628_BIN3_MAX(~0u)},
	/* 1070 */
	{47453, S_036700_PERF_SEL(~0u)},
	{48237, S_036700_SQC_BANK_MASK(~0u)},
	{48251, S_036700_SQC_CLIENT_MASK(~0u)},
	{48267, S_036700_SPM_MODE(~0u)},
	{48276, S_036700_SIMD_MASK(~0u)},
	{48100, S_036700_PERF_MODE(~0u)},
	/* 1076 */
	{48286, S_036780_PS_EN(~0u)},
	{48292, S_036780_VS_EN(~0u)},
	{48298, S_036780_GS_EN(~0u)},
	{23502, S_036780_ES_EN(~0u)},
	{48304, S_036780_HS_EN(~0u)},
	{48310, S_036780_LS_EN(~0u)},
	{48316, S_036780_CS_EN(~0u)},
	{48322, S_036780_CNTR_RATE(~0u)},
	{48332, S_036780_DISABLE_FLUSH(~0u)},
	/* 1085 */
	{48346, S_036784_SH0_MASK(~0u)},
	{48355, S_036784_SH1_MASK(~0u)},
	/* 1087 */
	{48364, S_036788_FORCE_EN(~0u)},
	/* 1088 */
	{12657, S_036900_PERFCOUNTER_SELECT(~0u)},
	{48373, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{47472, S_036900_CNTR_MODE(~0u)},
	/* 1091 */
	{48393, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{48413, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1093 */
	{12657, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{48373, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{47472, S_036A00_CNTR_MODE(~0u)},
	/* 1096 */
	{48393, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{48413, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1098 */
	{47453, S_036B00_PERF_SEL(~0u)},
	{47462, S_036B00_PERF_SEL1(~0u)},
	{47472, S_036B00_CNTR_MODE(~0u)},
	{48110, S_036B00_PERF_MODE1(~0u)},
	{48100, S_036B00_PERF_MODE(~0u)},
	/* 1103 */
	{47482, S_036B04_PERF_SEL2(~0u)},
	{47492, S_036B04_PERF_SEL3(~0u)},
	{48121, S_036B04_PERF_MODE3(~0u)},
	{48132, S_036B04_PERF_MODE2(~0u)},
	/* 1107 */
	{47453, S_036C00_PERF_SEL(~0u)},
	{47462, S_036C00_PERF_SEL1(~0u)},
	{47472, S_036C00_CNTR_MODE(~0u)},
	{48110, S_036C00_PERF_MODE1(~0u)},
	{48100, S_036C00_PERF_MODE(~0u)},
	/* 1112 */
	{47482, S_036C04_PERF_SEL2(~0u)},
	{47492, S_036C04_PERF_SEL3(~0u)},
	{48121, S_036C04_PERF_MODE3(~0u)},
	{48132, S_036C04_PERF_MODE2(~0u)},
	/* 1116 */
	{47453, S_036D00_PERF_SEL(~0u)},
	{47462, S_036D00_PERF_SEL1(~0u)},
	{47472, S_036D00_CNTR_MODE(~0u)},
	{48110, S_036D00_PERF_MODE1(~0u)},
	{48100, S_036D00_PERF_MODE(~0u)},
	/* 1121 */
	{47482, S_036D04_PERF_SEL2(~0u)},
	{47492, S_036D04_PERF_SEL3(~0u)},
	{48121, S_036D04_PERF_MODE3(~0u)},
	{48132, S_036D04_PERF_MODE2(~0u)},
	/* 1125 */
	{47453, S_036E00_PERF_SEL(~0u)},
	{47462, S_036E00_PERF_SEL1(~0u)},
	{47472, S_036E00_CNTR_MODE(~0u)},
	{48110, S_036E00_PERF_MODE1(~0u)},
	{48100, S_036E00_PERF_MODE(~0u)},
	/* 1130 */
	{47482, S_036E04_PERF_SEL2(~0u)},
	{47492, S_036E04_PERF_SEL3(~0u)},
	{48132, S_036E04_PERF_MODE2(~0u)},
	{48121, S_036E04_PERF_MODE3(~0u)},
	/* 1134 */
	{47453, S_036E40_PERF_SEL(~0u)},
	{47462, S_036E40_PERF_SEL1(~0u)},
	{47472, S_036E40_CNTR_MODE(~0u)},
	{48110, S_036E40_PERF_MODE1(~0u)},
	{48100, S_036E40_PERF_MODE(~0u)},
	/* 1139 */
	{47482, S_036E44_PERF_SEL2(~0u)},
	{47492, S_036E44_PERF_SEL3(~0u)},
	{48132, S_036E44_PERF_MODE2(~0u)},
	{48121, S_036E44_PERF_MODE3(~0u)},
	/* 1143 */
	{48433, S_037000_OP_FILTER_ENABLE(~0u)},
	{48450, S_037000_OP_FILTER_SEL(~0u)},
	{48464, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{48485, S_037000_FORMAT_FILTER_SEL(~0u)},
	{48503, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{48523, S_037000_CLEAR_FILTER_SEL(~0u)},
	{48540, S_037000_MRT_FILTER_ENABLE(~0u)},
	{48558, S_037000_MRT_FILTER_SEL(~0u)},
	{48573, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{48599, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{48622, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{48650, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1155 */
	{47453, S_037004_PERF_SEL(~0u)},
	{47462, S_037004_PERF_SEL1(~0u)},
	{47472, S_037004_CNTR_MODE(~0u)},
	{48110, S_037004_PERF_MODE1(~0u)},
	{48100, S_037004_PERF_MODE(~0u)},
	/* 1160 */
	{47482, S_037008_PERF_SEL2(~0u)},
	{47492, S_037008_PERF_SEL3(~0u)},
	{48121, S_037008_PERF_MODE3(~0u)},
	{48132, S_037008_PERF_MODE2(~0u)},
	/* 1164 */
	{47453, S_037100_PERF_SEL(~0u)},
	{47462, S_037100_PERF_SEL1(~0u)},
	{47472, S_037100_CNTR_MODE(~0u)},
	{48110, S_037100_PERF_MODE1(~0u)},
	{48100, S_037100_PERF_MODE(~0u)},
	/* 1169 */
	{47482, S_037104_PERF_SEL2(~0u)},
	{47492, S_037104_PERF_SEL3(~0u)},
	{48121, S_037104_PERF_MODE3(~0u)},
	{48132, S_037104_PERF_MODE2(~0u)},
	/* 1173 */
	{48675, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{48694, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{48715, S_028000_DEPTH_COPY(~0u)},
	{48726, S_028000_STENCIL_COPY(~0u)},
	{48739, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{48758, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{48783, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{48806, S_028000_COPY_CENTROID(~0u)},
	{48820, S_028000_COPY_SAMPLE(~0u)},
	{48832, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1183 */
	{48850, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{48874, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{48895, S_028004_SAMPLE_RATE(~0u)},
	{48907, S_028004_ZPASS_ENABLE(~0u)},
	{48920, S_028004_ZFAIL_ENABLE(~0u)},
	{48933, S_028004_SFAIL_ENABLE(~0u)},
	{48946, S_028004_DBFAIL_ENABLE(~0u)},
	{48960, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{48978, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1192 */
	{48995, S_028008_SLICE_START(~0u)},
	{49007, S_028008_SLICE_MAX(~0u)},
	{49017, S_028008_Z_READ_ONLY(~0u)},
	{49029, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1196 */
	{49099, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 673},
	{49116, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 673},
	{49134, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 673},
	{49152, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{49173, S_02800C_FAST_Z_DISABLE(~0u)},
	{49188, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{49209, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{49227, S_02800C_FORCE_COLOR_KILL(~0u)},
	{49244, S_02800C_FORCE_Z_READ(~0u)},
	{49257, S_02800C_FORCE_STENCIL_READ(~0u)},
	{49276, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 673},
	{49295, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{49319, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{49342, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{49359, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{49444, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 677},
	{49463, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{49480, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{49504, S_02800C_FORCE_Z_DIRTY(~0u)},
	{49518, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{49538, S_02800C_FORCE_Z_VALID(~0u)},
	{49552, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{49572, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1219 */
	{49646, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 681},
	{49675, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49706, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49742, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49777, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49805, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49827, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49845, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49877, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49903, S_028010_HIZ_ZFUNC(~0u)},
	{49913, S_028010_HIS_SFUNC_FF(~0u)},
	{49926, S_028010_HIS_SFUNC_BF(~0u)},
	{49939, S_028010_PRESERVE_ZRANGE(~0u)},
	{49955, S_028010_PRESERVE_SRESULTS(~0u)},
	{49973, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1234 */
	{15508, S_028028_CLEAR(~0u)},
	/* 1235 */
	{49991, S_028030_TL_X(~0u)},
	{49996, S_028030_TL_Y(~0u)},
	/* 1237 */
	{50001, S_028034_BR_X(~0u)},
	{50006, S_028034_BR_Y(~0u)},
	/* 1239 */
	{50011, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{45497, S_02803C_ARRAY_MODE(~0u), 7, 685},
	{45859, S_02803C_PIPE_CONFIG(~0u), 18, 692},
	{46152, S_02803C_BANK_WIDTH(~0u), 4, 409},
	{46259, S_02803C_BANK_HEIGHT(~0u), 4, 413},
	{46371, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 417},
	{46458, S_02803C_NUM_BANKS(~0u), 4, 421},
	/* 1246 */
	{21251, S_028040_FORMAT(~0u), 4, 710},
	{50163, S_028040_NUM_SAMPLES(~0u)},
	{46049, S_028040_TILE_SPLIT(~0u), 7, 402},
	{50175, S_028040_TILE_MODE_INDEX(~0u)},
	{50191, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{50215, S_028040_ALLOW_EXPCLEAR(~0u)},
	{50230, S_028040_READ_SIZE(~0u)},
	{50240, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{50260, S_028040_CLEAR_DISALLOWED(~0u)},
	{50277, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1256 */
	{21251, S_028044_FORMAT(~0u), 2, 714},
	{46049, S_028044_TILE_SPLIT(~0u), 7, 402},
	{50175, S_028044_TILE_MODE_INDEX(~0u)},
	{50215, S_028044_ALLOW_EXPCLEAR(~0u)},
	{50320, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{50260, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1262 */
	{50341, S_028058_PITCH_TILE_MAX(~0u)},
	{50356, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1264 */
	{50372, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1265 */
	{2880, S_028084_ADDRESS(~0u)},
	/* 1266 */
	{50387, S_028200_WINDOW_X_OFFSET(~0u)},
	{50403, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1268 */
	{49991, S_028204_TL_X(~0u)},
	{49996, S_028204_TL_Y(~0u)},
	{50419, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1271 */
	{50001, S_028208_BR_X(~0u)},
	{50006, S_028208_BR_Y(~0u)},
	/* 1273 */
	{50501, S_02820C_CLIP_RULE(~0u), 32769, 716},
	/* 1274 */
	{49991, S_028210_TL_X(~0u)},
	{49996, S_028210_TL_Y(~0u)},
	/* 1276 */
	{50001, S_028214_BR_X(~0u)},
	{50006, S_028214_BR_Y(~0u)},
	/* 1278 */
	{50511, S_028230_ER_TRI(~0u)},
	{43529, S_028230_ER_POINT(~0u)},
	{50518, S_028230_ER_RECT(~0u)},
	{50526, S_028230_ER_LINE_LR(~0u)},
	{50537, S_028230_ER_LINE_RL(~0u)},
	{50548, S_028230_ER_LINE_TB(~0u)},
	{50559, S_028230_ER_LINE_BT(~0u)},
	/* 1285 */
	{50570, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{50589, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1287 */
	{50608, S_028238_TARGET0_ENABLE(~0u)},
	{50623, S_028238_TARGET1_ENABLE(~0u)},
	{50638, S_028238_TARGET2_ENABLE(~0u)},
	{50653, S_028238_TARGET3_ENABLE(~0u)},
	{50668, S_028238_TARGET4_ENABLE(~0u)},
	{50683, S_028238_TARGET5_ENABLE(~0u)},
	{50698, S_028238_TARGET6_ENABLE(~0u)},
	{50713, S_028238_TARGET7_ENABLE(~0u)},
	/* 1295 */
	{50728, S_02823C_OUTPUT0_ENABLE(~0u)},
	{50743, S_02823C_OUTPUT1_ENABLE(~0u)},
	{50758, S_02823C_OUTPUT2_ENABLE(~0u)},
	{50773, S_02823C_OUTPUT3_ENABLE(~0u)},
	{50788, S_02823C_OUTPUT4_ENABLE(~0u)},
	{50803, S_02823C_OUTPUT5_ENABLE(~0u)},
	{50818, S_02823C_OUTPUT6_ENABLE(~0u)},
	{50833, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1303 */
	{49991, S_028240_TL_X(~0u)},
	{49996, S_028240_TL_Y(~0u)},
	{50419, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1306 */
	{50001, S_028244_BR_X(~0u)},
	{50006, S_028244_BR_Y(~0u)},
	/* 1308 */
	{49991, S_028250_TL_X(~0u)},
	{49996, S_028250_TL_Y(~0u)},
	{50419, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1311 */
	{50001, S_028254_BR_X(~0u)},
	{50006, S_028254_BR_Y(~0u)},
	/* 1313 */
	{50940, S_028350_RB_MAP_PKR0(~0u), 4, 33485},
	{50952, S_028350_RB_MAP_PKR1(~0u), 4, 33485},
	{51064, S_028350_RB_XSEL2(~0u), 4, 33489},
	{51073, S_028350_RB_XSEL(~0u)},
	{51081, S_028350_RB_YSEL(~0u)},
	{51185, S_028350_PKR_MAP(~0u), 4, 33493},
	{51293, S_028350_PKR_XSEL(~0u), 4, 33497},
	{51402, S_028350_PKR_YSEL(~0u), 4, 33501},
	{51515, S_028350_PKR_XSEL2(~0u), 4, 33505},
	{51617, S_028350_SC_MAP(~0u), 4, 33509},
	{51763, S_028350_SC_XSEL(~0u), 4, 33513},
	{51910, S_028350_SC_YSEL(~0u), 4, 33517},
	{52010, S_028350_SE_MAP(~0u), 4, 33521},
	{52156, S_028350_SE_XSEL_GFX6(~0u), 4, 33525},
	{52308, S_028350_SE_YSEL_GFX6(~0u), 4, 33529},
	/* 1328 */
	{52433, S_028354_SE_PAIR_MAP(~0u), 4, 33533},
	{52604, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 33537},
	{52781, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 33541},
	/* 1331 */
	{48960, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{48978, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1333 */
	{52799, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52826, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52865, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1336 */
	{53131, S_02842C_STENCILFAIL(~0u), 16, 33545},
	{53143, S_02842C_STENCILZPASS(~0u), 16, 33545},
	{53156, S_02842C_STENCILZFAIL(~0u), 16, 33545},
	{53169, S_02842C_STENCILFAIL_BF(~0u), 16, 33545},
	{53184, S_02842C_STENCILZPASS_BF(~0u), 16, 33545},
	{53200, S_02842C_STENCILZFAIL_BF(~0u), 16, 33545},
	/* 1342 */
	{53216, S_028430_STENCILTESTVAL(~0u)},
	{53231, S_028430_STENCILMASK(~0u)},
	{53243, S_028430_STENCILWRITEMASK(~0u)},
	{53260, S_028430_STENCILOPVAL(~0u)},
	/* 1346 */
	{53273, S_028434_STENCILTESTVAL_BF(~0u)},
	{53291, S_028434_STENCILMASK_BF(~0u)},
	{53306, S_028434_STENCILWRITEMASK_BF(~0u)},
	{53326, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1350 */
	{676, S_028644_OFFSET(~0u)},
	{53349, S_028644_DEFAULT_VAL(~0u), 1, 33561},
	{53361, S_028644_FLAT_SHADE(~0u)},
	{53372, S_028644_CYL_WRAP(~0u)},
	{53381, S_028644_PT_SPRITE_TEX(~0u)},
	{53395, S_028644_DUP(~0u)},
	{53399, S_028644_FP16_INTERP_MODE(~0u)},
	{53416, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{53434, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{53452, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{53472, S_028644_ATTR0_VALID(~0u)},
	{53484, S_028644_ATTR1_VALID(~0u)},
	/* 1362 */
	{53496, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{53512, S_0286C4_VS_HALF_PACK(~0u)},
	{53525, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{53540, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1366 */
	{53560, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{53577, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{53594, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{53613, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{53634, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{53652, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{53670, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{53690, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{53711, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{53727, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{53743, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{53759, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{53775, S_0286CC_FRONT_FACE_ENA(~0u)},
	{53790, S_0286CC_ANCILLARY_ENA(~0u)},
	{53804, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{53824, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1382 */
	{53560, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{53577, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{53594, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{53613, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{53634, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{53652, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{53670, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{53690, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{53711, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{53727, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{53743, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{53759, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{53775, S_0286D0_FRONT_FACE_ENA(~0u)},
	{53790, S_0286D0_ANCILLARY_ENA(~0u)},
	{53804, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{53824, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1398 */
	{53841, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{53856, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{53979, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 33562},
	{53997, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 33562},
	{54015, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 33562},
	{54033, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 33562},
	{54051, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1405 */
	{54068, S_0286D8_NUM_INTERP(~0u)},
	{54079, S_0286D8_PARAM_GEN(~0u)},
	{54089, S_0286D8_FOG_ADDR(~0u)},
	{54098, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{54118, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1410 */
	{54138, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{54156, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{54176, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{54195, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{54265, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 33567},
	{54284, S_0286E0_POS_FLOAT_ULC(~0u)},
	{54298, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1417 */
	{47369, S_0286E8_WAVES(~0u)},
	{47375, S_0286E8_WAVESIZE(~0u)},
	/* 1419 */
	{54318, S_028704_NUM_PS_WAVES(~0u)},
	{54331, S_028704_NUM_VS_WAVES(~0u)},
	{54344, S_028704_NUM_GS_WAVES(~0u)},
	{54357, S_028704_NUM_ES_WAVES(~0u)},
	{54370, S_028704_NUM_HS_WAVES(~0u)},
	/* 1424 */
	{54383, S_028708_NUM_LS_WAVES(~0u)},
	/* 1425 */
	{54484, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 33568},
	{54503, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 33568},
	{54522, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 33568},
	{54541, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 33568},
	/* 1429 */
	{54760, S_028710_Z_EXPORT_FORMAT(~0u), 10, 33573},
	/* 1430 */
	{54776, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 33573},
	{54795, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 33573},
	{54814, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 33573},
	{54833, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 33573},
	{54852, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 33573},
	{54871, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 33573},
	{54890, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 33573},
	{54909, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 33573},
	/* 1438 */
	{55163, S_028754_MRT0(~0u), 11, 33583},
	{55168, S_028754_MRT1(~0u)},
	{55173, S_028754_MRT2(~0u)},
	{55178, S_028754_MRT3(~0u)},
	{55183, S_028754_MRT4(~0u)},
	{55188, S_028754_MRT5(~0u)},
	{55193, S_028754_MRT6(~0u)},
	{55198, S_028754_MRT7(~0u)},
	/* 1446 */
	{55283, S_028758_MRT0_EPSILON(~0u), 16, 33594},
	{55296, S_028758_MRT1_EPSILON(~0u)},
	{55309, S_028758_MRT2_EPSILON(~0u)},
	{55322, S_028758_MRT3_EPSILON(~0u)},
	{55335, S_028758_MRT4_EPSILON(~0u)},
	{55348, S_028758_MRT5_EPSILON(~0u)},
	{55361, S_028758_MRT6_EPSILON(~0u)},
	{55374, S_028758_MRT7_EPSILON(~0u)},
	/* 1454 */
	{55387, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{55410, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{55433, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{55456, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{55479, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{55502, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{55525, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{55548, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{55571, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{55594, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{55617, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{55640, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{55663, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{55686, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{55709, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{55732, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{55755, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1471 */
	{56046, S_028760_COLOR_SRC_OPT(~0u), 8, 33610},
	{56060, S_028760_COLOR_DST_OPT(~0u)},
	{56208, S_028760_COLOR_COMB_FCN(~0u), 8, 33618},
	{56223, S_028760_ALPHA_SRC_OPT(~0u)},
	{56237, S_028760_ALPHA_DST_OPT(~0u)},
	{56251, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1477 */
	{56046, S_028764_COLOR_SRC_OPT(~0u)},
	{56060, S_028764_COLOR_DST_OPT(~0u)},
	{56208, S_028764_COLOR_COMB_FCN(~0u)},
	{56223, S_028764_ALPHA_SRC_OPT(~0u)},
	{56237, S_028764_ALPHA_DST_OPT(~0u)},
	{56251, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1483 */
	{56046, S_028768_COLOR_SRC_OPT(~0u)},
	{56060, S_028768_COLOR_DST_OPT(~0u)},
	{56208, S_028768_COLOR_COMB_FCN(~0u)},
	{56223, S_028768_ALPHA_SRC_OPT(~0u)},
	{56237, S_028768_ALPHA_DST_OPT(~0u)},
	{56251, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1489 */
	{56046, S_02876C_COLOR_SRC_OPT(~0u)},
	{56060, S_02876C_COLOR_DST_OPT(~0u)},
	{56208, S_02876C_COLOR_COMB_FCN(~0u)},
	{56223, S_02876C_ALPHA_SRC_OPT(~0u)},
	{56237, S_02876C_ALPHA_DST_OPT(~0u)},
	{56251, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1495 */
	{56046, S_028770_COLOR_SRC_OPT(~0u)},
	{56060, S_028770_COLOR_DST_OPT(~0u)},
	{56208, S_028770_COLOR_COMB_FCN(~0u)},
	{56223, S_028770_ALPHA_SRC_OPT(~0u)},
	{56237, S_028770_ALPHA_DST_OPT(~0u)},
	{56251, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1501 */
	{56046, S_028774_COLOR_SRC_OPT(~0u)},
	{56060, S_028774_COLOR_DST_OPT(~0u)},
	{56208, S_028774_COLOR_COMB_FCN(~0u)},
	{56223, S_028774_ALPHA_SRC_OPT(~0u)},
	{56237, S_028774_ALPHA_DST_OPT(~0u)},
	{56251, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1507 */
	{56046, S_028778_COLOR_SRC_OPT(~0u)},
	{56060, S_028778_COLOR_DST_OPT(~0u)},
	{56208, S_028778_COLOR_COMB_FCN(~0u)},
	{56223, S_028778_ALPHA_SRC_OPT(~0u)},
	{56237, S_028778_ALPHA_DST_OPT(~0u)},
	{56251, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1513 */
	{56046, S_02877C_COLOR_SRC_OPT(~0u)},
	{56060, S_02877C_COLOR_DST_OPT(~0u)},
	{56208, S_02877C_COLOR_COMB_FCN(~0u)},
	{56223, S_02877C_ALPHA_SRC_OPT(~0u)},
	{56237, S_02877C_ALPHA_DST_OPT(~0u)},
	{56251, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1519 */
	{56660, S_028780_COLOR_SRCBLEND(~0u), 21, 33626},
	{56208, S_028780_COLOR_COMB_FCN(~0u), 5, 33647},
	{56765, S_028780_COLOR_DESTBLEND(~0u), 21, 33626},
	{56781, S_028780_ALPHA_SRCBLEND(~0u), 21, 33626},
	{56251, S_028780_ALPHA_COMB_FCN(~0u), 5, 33647},
	{56796, S_028780_ALPHA_DESTBLEND(~0u), 21, 33626},
	{56812, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{7762, S_028780_ENABLE(~0u)},
	{56833, S_028780_DISABLE_ROP3(~0u)},
	/* 1528 */
	{56846, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1529 */
	{56859, S_0287E4_BASE_ADDR_GFX6(~0u)},
	/* 1530 */
	{56952, S_0287F0_SOURCE_SELECT(~0u), 4, 33652},
	{56998, S_0287F0_MAJOR_MODE(~0u), 2, 33656},
	{57009, S_0287F0_NOT_EOP(~0u)},
	{57017, S_0287F0_USE_OPAQUE(~0u)},
	/* 1534 */
	{57028, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1535 */
	{57040, S_028800_STENCIL_ENABLE(~0u)},
	{49107, S_028800_Z_ENABLE(~0u)},
	{57055, S_028800_Z_WRITE_ENABLE(~0u)},
	{57070, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{49907, S_028800_ZFUNC(~0u), 8, 33658},
	{57185, S_028800_BACKFACE_ENABLE(~0u)},
	{57288, S_028800_STENCILFUNC(~0u), 8, 33666},
	{57300, S_028800_STENCILFUNC_BF(~0u), 8, 33666},
	{57315, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{57349, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1545 */
	{57384, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{57403, S_028804_PS_ITER_SAMPLES(~0u)},
	{57419, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{57443, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{57469, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{57496, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{57518, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{57537, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{57555, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{57582, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{57609, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{57634, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1557 */
	{57665, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{57683, S_028808_DEGAMMA_ENABLE(~0u)},
	{22398, S_028808_MODE(~0u), 7, 33674},
	{56841, S_028808_ROP3(~0u), 256, 33681},
	/* 1561 */
	{57993, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{58009, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{58040, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{49165, S_02880C_Z_ORDER(~0u), 4, 33937},
	{58119, S_02880C_KILL_ENABLE(~0u)},
	{58131, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{58155, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{58174, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{58192, S_02880C_EXEC_ON_NOOP(~0u)},
	{58205, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58227, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58317, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 33941},
	{58339, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1574 */
	{58357, S_028810_UCP_ENA_0(~0u)},
	{58367, S_028810_UCP_ENA_1(~0u)},
	{58377, S_028810_UCP_ENA_2(~0u)},
	{58387, S_028810_UCP_ENA_3(~0u)},
	{58397, S_028810_UCP_ENA_4(~0u)},
	{58407, S_028810_UCP_ENA_5(~0u)},
	{58417, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{58436, S_028810_PS_UCP_MODE(~0u)},
	{58448, S_028810_CLIP_DISABLE(~0u)},
	{58461, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{58479, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{58502, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{58520, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{58540, S_028810_VTX_KILL_OR(~0u)},
	{58552, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{58574, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{58598, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{58624, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{58643, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1593 */
	{58661, S_028814_CULL_FRONT(~0u)},
	{58672, S_028814_CULL_BACK(~0u)},
	{22939, S_028814_FACE(~0u)},
	{58692, S_028814_POLY_MODE(~0u), 2, 33945},
	{58758, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 33947},
	{58779, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 33947},
	{58799, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58824, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58848, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58872, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58897, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58916, S_028814_PERSP_CORR_DIS(~0u)},
	{58931, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1606 */
	{58949, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58967, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58986, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{59004, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{59023, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{59041, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{59060, S_028818_VTX_XY_FMT(~0u)},
	{59071, S_028818_VTX_Z_FMT(~0u)},
	{59081, S_028818_VTX_W0_FMT(~0u)},
	/* 1615 */
	{59092, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{59108, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{59124, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{59140, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{59156, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{59172, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{59188, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{59204, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{59220, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59236, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59252, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59268, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59284, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59300, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59316, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59332, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59348, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59367, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59385, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59412, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59434, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59452, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59472, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59495, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59518, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59543, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59563, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1642 */
	{59582, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{59601, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{59619, S_028820_VTE_W_INF_DISCARD(~0u)},
	{59637, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{59655, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{59673, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{59690, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{59707, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{59728, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{59745, S_028820_VS_XY_INF_RETAIN(~0u)},
	{59762, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{59778, S_028820_VS_Z_INF_RETAIN(~0u)},
	{59794, S_028820_VS_W_NAN_TO_INF(~0u)},
	{59810, S_028820_VS_W_INF_RETAIN(~0u)},
	{59826, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{59851, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1658 */
	{59871, S_028824_LINE_STIPPLE_RESET(~0u)},
	{59890, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{59909, S_028824_FRACTIONAL_ACCUM(~0u)},
	{59926, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1662 */
	{59941, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{59965, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{59985, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{60006, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{60031, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{60051, S_02882C_LINE_EXPAND_ENA(~0u)},
	{60067, S_02882C_POINT_EXPAND_ENA(~0u)},
	{60084, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{60105, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{60126, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{60147, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1673 */
	{60169, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{59941, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{59965, S_028830_LINE_FILTER_DISABLE(~0u)},
	{59985, S_028830_POINT_FILTER_DISABLE(~0u)},
	{60006, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1678 */
	{42267, S_028A00_HEIGHT(~0u)},
	{42261, S_028A00_WIDTH(~0u)},
	/* 1680 */
	{60194, S_028A04_MIN_SIZE(~0u)},
	{22634, S_028A04_MAX_SIZE(~0u)},
	/* 1682 */
	{42261, S_028A08_WIDTH(~0u)},
	/* 1683 */
	{60203, S_028A0C_LINE_PATTERN(~0u)},
	{60216, S_028A0C_REPEAT_COUNT(~0u)},
	{60229, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{60247, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1687 */
	{60368, S_028A10_PATH_SELECT(~0u), 5, 33950},
	/* 1688 */
	{60380, S_028A14_TESS_MODE(~0u)},
	/* 1689 */
	{22227, S_028A20_REUSE_DEPTH(~0u)},
	/* 1690 */
	{22249, S_028A24_PRIM_TYPE(~0u), 18, 33955},
	{60745, S_028A24_RETAIN_ORDER(~0u)},
	{60758, S_028A24_RETAIN_QUADS(~0u)},
	{60839, S_028A24_PRIM_ORDER(~0u), 5, 33973},
	/* 1694 */
	{22269, S_028A28_FIRST_DECR(~0u)},
	/* 1695 */
	{22275, S_028A2C_DECR(~0u)},
	/* 1696 */
	{60850, S_028A30_COMP_X_EN(~0u)},
	{60860, S_028A30_COMP_Y_EN(~0u)},
	{60870, S_028A30_COMP_Z_EN(~0u)},
	{60880, S_028A30_COMP_W_EN(~0u)},
	{23438, S_028A30_STRIDE(~0u)},
	{60890, S_028A30_SHIFT(~0u)},
	/* 1702 */
	{60850, S_028A34_COMP_X_EN(~0u)},
	{60860, S_028A34_COMP_Y_EN(~0u)},
	{60870, S_028A34_COMP_Z_EN(~0u)},
	{60880, S_028A34_COMP_W_EN(~0u)},
	{23438, S_028A34_STRIDE(~0u)},
	{60890, S_028A34_SHIFT(~0u)},
	/* 1708 */
	{61055, S_028A38_X_CONV(~0u), 9, 33978},
	{17826, S_028A38_X_OFFSET(~0u)},
	{61062, S_028A38_Y_CONV(~0u), 9, 33978},
	{50410, S_028A38_Y_OFFSET(~0u)},
	{61069, S_028A38_Z_CONV(~0u), 9, 33978},
	{61076, S_028A38_Z_OFFSET(~0u)},
	{61085, S_028A38_W_CONV(~0u), 9, 33978},
	{15886, S_028A38_W_OFFSET(~0u)},
	/* 1716 */
	{61055, S_028A3C_X_CONV(~0u), 9, 33978},
	{17826, S_028A3C_X_OFFSET(~0u)},
	{61062, S_028A3C_Y_CONV(~0u), 9, 33978},
	{50410, S_028A3C_Y_OFFSET(~0u)},
	{61069, S_028A3C_Z_CONV(~0u), 9, 33978},
	{61076, S_028A3C_Z_OFFSET(~0u)},
	{61085, S_028A3C_W_CONV(~0u), 9, 33978},
	{15886, S_028A3C_W_OFFSET(~0u)},
	/* 1724 */
	{22398, S_028A40_MODE(~0u), 6, 33987},
	{39408, S_028A40_RESERVED_0(~0u)},
	{61210, S_028A40_CUT_MODE(~0u), 4, 33993},
	{39426, S_028A40_RESERVED_1(~0u)},
	{61219, S_028A40_GS_C_PACK_EN(~0u)},
	{61232, S_028A40_RESERVED_2(~0u)},
	{61243, S_028A40_ES_PASSTHRU(~0u)},
	{61255, S_028A40_COMPUTE_MODE(~0u)},
	{61268, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{61286, S_028A40_ELEMENT_INFO_EN(~0u)},
	{61302, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61321, S_028A40_SUPPRESS_CUTS(~0u)},
	{61335, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61353, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61404, S_028A40_ONCHIP(~0u), 4, 33997},
	/* 1739 */
	{61411, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61431, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1741 */
	{61451, S_028A48_MSAA_ENABLE(~0u)},
	{61463, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61484, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61504, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1745 */
	{61529, S_028A4C_WALK_SIZE(~0u)},
	{61539, S_028A4C_WALK_ALIGNMENT(~0u)},
	{61554, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{61579, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{61597, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{61613, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{61618, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{61641, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{61660, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{61682, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{61698, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{61714, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{61730, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{61749, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{61775, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{61790, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{61830, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{61857, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{61880, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{61896, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{61926, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{61950, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{61971, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{62001, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1769 */
	{22474, S_028A54_GS_PER_ES(~0u)},
	/* 1770 */
	{22488, S_028A58_ES_PER_GS(~0u)},
	/* 1771 */
	{22502, S_028A5C_GS_PER_VS(~0u)},
	/* 1772 */
	{676, S_028A60_OFFSET(~0u)},
	/* 1773 */
	{676, S_028A64_OFFSET(~0u)},
	/* 1774 */
	{676, S_028A68_OFFSET(~0u)},
	/* 1775 */
	{62093, S_028A6C_OUTPRIM_TYPE(~0u), 3, 34001},
	{62106, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{62121, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{62136, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{62151, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1780 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 34004},
	{62288, S_028A7C_SWAP_MODE(~0u), 4, 34007},
	{62349, S_028A7C_BUF_TYPE(~0u), 3, 34011},
	{62391, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 34014},
	{62408, S_028A7C_RDREQ_POLICY(~0u)},
	{40132, S_028A7C_ATC(~0u)},
	{57009, S_028A7C_NOT_EOP(~0u)},
	{62421, S_028A7C_REQ_PATH(~0u)},
	{40153, S_028A7C_MTYPE(~0u)},
	/* 1789 */
	{22677, S_028A84_PRIMITIVEID_EN(~0u)},
	{62430, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1791 */
	{63386, S_028A90_EVENT_TYPE(~0u), 59, 34016},
	{63397, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{63413, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1794 */
	{22774, S_028A94_RESET_EN(~0u)},
	/* 1795 */
	{63428, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{63443, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{63462, S_028AA8_SWITCH_ON_EOP(~0u)},
	{63476, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{63495, S_028AA8_SWITCH_ON_EOI(~0u)},
	{63509, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{63526, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1802 */
	{22866, S_028AAC_ITEMSIZE(~0u)},
	/* 1803 */
	{22866, S_028AB0_ITEMSIZE(~0u)},
	/* 1804 */
	{22902, S_028AB4_REUSE_OFF(~0u)},
	/* 1805 */
	{22916, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1806 */
	{43557, S_028ABC_LINEAR(~0u)},
	{63546, S_028ABC_FULL_CACHE(~0u)},
	{63557, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63580, S_028ABC_PRELOAD(~0u)},
	{63588, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63603, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63619, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{63643, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1814 */
	{63657, S_028AC0_COMPAREFUNC0(~0u), 8, 33666},
	{63670, S_028AC0_COMPAREVALUE0(~0u)},
	{63684, S_028AC0_COMPAREMASK0(~0u)},
	{49126, S_028AC0_ENABLE0(~0u)},
	/* 1818 */
	{63697, S_028AC4_COMPAREFUNC1(~0u), 8, 33666},
	{63710, S_028AC4_COMPAREVALUE1(~0u)},
	{63724, S_028AC4_COMPAREMASK1(~0u)},
	{49144, S_028AC4_ENABLE1(~0u)},
	/* 1822 */
	{7618, S_028AC8_START_X(~0u)},
	{7634, S_028AC8_START_Y(~0u)},
	{63737, S_028AC8_MAX_X(~0u)},
	{63743, S_028AC8_MAX_Y(~0u)},
	/* 1826 */
	{23438, S_028AD4_STRIDE(~0u)},
	/* 1827 */
	{23438, S_028AE4_STRIDE(~0u)},
	/* 1828 */
	{23438, S_028AF4_STRIDE(~0u)},
	/* 1829 */
	{23438, S_028B04_STRIDE(~0u)},
	/* 1830 */
	{23431, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1831 */
	{23452, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1832 */
	{63749, S_028B50_ACCUM_ISOLINE(~0u)},
	{63763, S_028B50_ACCUM_TRI(~0u)},
	{63773, S_028B50_ACCUM_QUAD(~0u)},
	{63784, S_028B50_DONUT_SPLIT(~0u)},
	{63796, S_028B50_TRAP_SPLIT(~0u)},
	/* 1837 */
	{48310, S_028B54_LS_EN(~0u), 3, 34075},
	{48304, S_028B54_HS_EN(~0u)},
	{23502, S_028B54_ES_EN(~0u), 3, 34078},
	{48298, S_028B54_GS_EN(~0u)},
	{48292, S_028B54_VS_EN(~0u), 3, 34081},
	{63930, S_028B54_DYNAMIC_HS(~0u)},
	{46885, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63941, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63961, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63981, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1847 */
	{63995, S_028B58_NUM_PATCHES(~0u)},
	{64007, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{64023, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1850 */
	{22866, S_028B5C_ITEMSIZE(~0u)},
	/* 1851 */
	{22866, S_028B60_ITEMSIZE(~0u)},
	/* 1852 */
	{22866, S_028B64_ITEMSIZE(~0u)},
	/* 1853 */
	{22866, S_028B68_ITEMSIZE(~0u)},
	/* 1854 */
	{209, S_028B6C_TYPE(~0u), 3, 34084},
	{64129, S_028B6C_PARTITIONING(~0u), 4, 34087},
	{64206, S_028B6C_TOPOLOGY(~0u), 4, 34091},
	{64215, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64235, S_028B6C_DEPRECATED(~0u)},
	{64246, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{64268, S_028B6C_DISABLE_DONUTS(~0u)},
	{62391, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 34095},
	{62408, S_028B6C_RDREQ_POLICY(~0u)},
	{64407, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 34098},
	{40153, S_028B6C_MTYPE(~0u)},
	/* 1865 */
	{64425, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{64446, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{64468, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{64490, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{64512, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{64534, S_028B70_OFFSET_ROUND(~0u)},
	/* 1871 */
	{64547, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{64575, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1873 */
	{7762, S_028B90_ENABLE(~0u)},
	{23859, S_028B90_CNT(~0u)},
	/* 1875 */
	{64603, S_028B94_STREAMOUT_0_EN(~0u)},
	{64618, S_028B94_STREAMOUT_1_EN(~0u)},
	{64633, S_028B94_STREAMOUT_2_EN(~0u)},
	{64648, S_028B94_STREAMOUT_3_EN(~0u)},
	{64663, S_028B94_RAST_STREAM(~0u)},
	{64675, S_028B94_RAST_STREAM_MASK(~0u)},
	{64692, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1882 */
	{64713, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{64732, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{64751, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{64770, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1886 */
	{64789, S_028BD4_DISTANCE_0(~0u)},
	{64800, S_028BD4_DISTANCE_1(~0u)},
	{64811, S_028BD4_DISTANCE_2(~0u)},
	{64822, S_028BD4_DISTANCE_3(~0u)},
	{64833, S_028BD4_DISTANCE_4(~0u)},
	{64844, S_028BD4_DISTANCE_5(~0u)},
	{64855, S_028BD4_DISTANCE_6(~0u)},
	{64866, S_028BD4_DISTANCE_7(~0u)},
	/* 1894 */
	{64877, S_028BD8_DISTANCE_8(~0u)},
	{64888, S_028BD8_DISTANCE_9(~0u)},
	{64899, S_028BD8_DISTANCE_10(~0u)},
	{64911, S_028BD8_DISTANCE_11(~0u)},
	{64923, S_028BD8_DISTANCE_12(~0u)},
	{64935, S_028BD8_DISTANCE_13(~0u)},
	{64947, S_028BD8_DISTANCE_14(~0u)},
	{64959, S_028BD8_DISTANCE_15(~0u)},
	/* 1902 */
	{64971, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{64989, S_028BDC_LAST_PIXEL(~0u)},
	{65000, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{65025, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1906 */
	{65047, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{65064, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{65086, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{65102, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{65123, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1911 */
	{65146, S_028BE4_PIX_CENTER(~0u)},
	{65207, S_028BE4_ROUND_MODE(~0u), 4, 34102},
	{65423, S_028BE4_QUANT_MODE(~0u), 8, 34106},
	/* 1914 */
	{65434, S_028BF8_S0_X(~0u)},
	{65439, S_028BF8_S0_Y(~0u)},
	{65444, S_028BF8_S1_X(~0u)},
	{65449, S_028BF8_S1_Y(~0u)},
	{65454, S_028BF8_S2_X(~0u)},
	{65459, S_028BF8_S2_Y(~0u)},
	{65464, S_028BF8_S3_X(~0u)},
	{65469, S_028BF8_S3_Y(~0u)},
	/* 1922 */
	{65474, S_028BFC_S4_X(~0u)},
	{65479, S_028BFC_S4_Y(~0u)},
	{65484, S_028BFC_S5_X(~0u)},
	{65489, S_028BFC_S5_Y(~0u)},
	{65494, S_028BFC_S6_X(~0u)},
	{65499, S_028BFC_S6_Y(~0u)},
	{65504, S_028BFC_S7_X(~0u)},
	{65509, S_028BFC_S7_Y(~0u)},
	/* 1930 */
	{65514, S_028C00_S8_X(~0u)},
	{65519, S_028C00_S8_Y(~0u)},
	{65524, S_028C00_S9_X(~0u)},
	{65529, S_028C00_S9_Y(~0u)},
	{65534, S_028C00_S10_X(~0u)},
	{65540, S_028C00_S10_Y(~0u)},
	{65546, S_028C00_S11_X(~0u)},
	{65552, S_028C00_S11_Y(~0u)},
	/* 1938 */
	{65558, S_028C04_S12_X(~0u)},
	{65564, S_028C04_S12_Y(~0u)},
	{65570, S_028C04_S13_X(~0u)},
	{65576, S_028C04_S13_Y(~0u)},
	{65582, S_028C04_S14_X(~0u)},
	{65588, S_028C04_S14_Y(~0u)},
	{65594, S_028C04_S15_X(~0u)},
	{65600, S_028C04_S15_Y(~0u)},
	/* 1946 */
	{65434, S_028C08_S0_X(~0u)},
	{65439, S_028C08_S0_Y(~0u)},
	{65444, S_028C08_S1_X(~0u)},
	{65449, S_028C08_S1_Y(~0u)},
	{65454, S_028C08_S2_X(~0u)},
	{65459, S_028C08_S2_Y(~0u)},
	{65464, S_028C08_S3_X(~0u)},
	{65469, S_028C08_S3_Y(~0u)},
	/* 1954 */
	{65474, S_028C0C_S4_X(~0u)},
	{65479, S_028C0C_S4_Y(~0u)},
	{65484, S_028C0C_S5_X(~0u)},
	{65489, S_028C0C_S5_Y(~0u)},
	{65494, S_028C0C_S6_X(~0u)},
	{65499, S_028C0C_S6_Y(~0u)},
	{65504, S_028C0C_S7_X(~0u)},
	{65509, S_028C0C_S7_Y(~0u)},
	/* 1962 */
	{65514, S_028C10_S8_X(~0u)},
	{65519, S_028C10_S8_Y(~0u)},
	{65524, S_028C10_S9_X(~0u)},
	{65529, S_028C10_S9_Y(~0u)},
	{65534, S_028C10_S10_X(~0u)},
	{65540, S_028C10_S10_Y(~0u)},
	{65546, S_028C10_S11_X(~0u)},
	{65552, S_028C10_S11_Y(~0u)},
	/* 1970 */
	{65558, S_028C14_S12_X(~0u)},
	{65564, S_028C14_S12_Y(~0u)},
	{65570, S_028C14_S13_X(~0u)},
	{65576, S_028C14_S13_Y(~0u)},
	{65582, S_028C14_S14_X(~0u)},
	{65588, S_028C14_S14_Y(~0u)},
	{65594, S_028C14_S15_X(~0u)},
	{65600, S_028C14_S15_Y(~0u)},
	/* 1978 */
	{65434, S_028C18_S0_X(~0u)},
	{65439, S_028C18_S0_Y(~0u)},
	{65444, S_028C18_S1_X(~0u)},
	{65449, S_028C18_S1_Y(~0u)},
	{65454, S_028C18_S2_X(~0u)},
	{65459, S_028C18_S2_Y(~0u)},
	{65464, S_028C18_S3_X(~0u)},
	{65469, S_028C18_S3_Y(~0u)},
	/* 1986 */
	{65474, S_028C1C_S4_X(~0u)},
	{65479, S_028C1C_S4_Y(~0u)},
	{65484, S_028C1C_S5_X(~0u)},
	{65489, S_028C1C_S5_Y(~0u)},
	{65494, S_028C1C_S6_X(~0u)},
	{65499, S_028C1C_S6_Y(~0u)},
	{65504, S_028C1C_S7_X(~0u)},
	{65509, S_028C1C_S7_Y(~0u)},
	/* 1994 */
	{65514, S_028C20_S8_X(~0u)},
	{65519, S_028C20_S8_Y(~0u)},
	{65524, S_028C20_S9_X(~0u)},
	{65529, S_028C20_S9_Y(~0u)},
	{65534, S_028C20_S10_X(~0u)},
	{65540, S_028C20_S10_Y(~0u)},
	{65546, S_028C20_S11_X(~0u)},
	{65552, S_028C20_S11_Y(~0u)},
	/* 2002 */
	{65558, S_028C24_S12_X(~0u)},
	{65564, S_028C24_S12_Y(~0u)},
	{65570, S_028C24_S13_X(~0u)},
	{65576, S_028C24_S13_Y(~0u)},
	{65582, S_028C24_S14_X(~0u)},
	{65588, S_028C24_S14_Y(~0u)},
	{65594, S_028C24_S15_X(~0u)},
	{65600, S_028C24_S15_Y(~0u)},
	/* 2010 */
	{65434, S_028C28_S0_X(~0u)},
	{65439, S_028C28_S0_Y(~0u)},
	{65444, S_028C28_S1_X(~0u)},
	{65449, S_028C28_S1_Y(~0u)},
	{65454, S_028C28_S2_X(~0u)},
	{65459, S_028C28_S2_Y(~0u)},
	{65464, S_028C28_S3_X(~0u)},
	{65469, S_028C28_S3_Y(~0u)},
	/* 2018 */
	{65474, S_028C2C_S4_X(~0u)},
	{65479, S_028C2C_S4_Y(~0u)},
	{65484, S_028C2C_S5_X(~0u)},
	{65489, S_028C2C_S5_Y(~0u)},
	{65494, S_028C2C_S6_X(~0u)},
	{65499, S_028C2C_S6_Y(~0u)},
	{65504, S_028C2C_S7_X(~0u)},
	{65509, S_028C2C_S7_Y(~0u)},
	/* 2026 */
	{65514, S_028C30_S8_X(~0u)},
	{65519, S_028C30_S8_Y(~0u)},
	{65524, S_028C30_S9_X(~0u)},
	{65529, S_028C30_S9_Y(~0u)},
	{65534, S_028C30_S10_X(~0u)},
	{65540, S_028C30_S10_Y(~0u)},
	{65546, S_028C30_S11_X(~0u)},
	{65552, S_028C30_S11_Y(~0u)},
	/* 2034 */
	{65558, S_028C34_S12_X(~0u)},
	{65564, S_028C34_S12_Y(~0u)},
	{65570, S_028C34_S13_X(~0u)},
	{65576, S_028C34_S13_Y(~0u)},
	{65582, S_028C34_S14_X(~0u)},
	{65588, S_028C34_S14_Y(~0u)},
	{65594, S_028C34_S15_X(~0u)},
	{65600, S_028C34_S15_Y(~0u)},
	/* 2042 */
	{65606, S_028C38_AA_MASK_X0Y0(~0u)},
	{65619, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2044 */
	{65632, S_028C3C_AA_MASK_X0Y1(~0u)},
	{65645, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2046 */
	{65658, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2047 */
	{65687, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2048 */
	{65703, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2049 */
	{50347, S_028C64_TILE_MAX(~0u)},
	{65716, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2051 */
	{50347, S_028C68_TILE_MAX(~0u)},
	/* 2052 */
	{48995, S_028C6C_SLICE_START(~0u)},
	{49007, S_028C6C_SLICE_MAX(~0u)},
	/* 2054 */
	{65782, S_028C70_ENDIAN(~0u), 4, 34114},
	{21251, S_028C70_FORMAT(~0u), 23, 34118},
	{45274, S_028C70_LINEAR_GENERAL(~0u)},
	{66149, S_028C70_NUMBER_TYPE(~0u), 8, 34141},
	{66205, S_028C70_COMP_SWAP(~0u), 4, 34149},
	{57732, S_028C70_FAST_CLEAR(~0u)},
	{49581, S_028C70_COMPRESSION(~0u)},
	{66215, S_028C70_BLEND_CLAMP(~0u)},
	{66227, S_028C70_BLEND_BYPASS(~0u)},
	{66240, S_028C70_SIMPLE_FLOAT(~0u)},
	{65207, S_028C70_ROUND_MODE(~0u)},
	{66253, S_028C70_CMASK_IS_LINEAR(~0u)},
	{66480, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 34153},
	{66502, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 34153},
	{66526, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66552, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66578, S_028C70_DCC_ENABLE(~0u)},
	{66589, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2072 */
	{50175, S_028C74_TILE_MODE_INDEX(~0u)},
	{66605, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{66627, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{50163, S_028C74_NUM_SAMPLES(~0u)},
	{66645, S_028C74_NUM_FRAGMENTS(~0u)},
	{66659, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2078 */
	{52799, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{66677, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{66753, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u), 3, 34161},
	{66819, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u), 2, 34164},
	{66845, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{42748, S_028C78_COLOR_TRANSFORM(~0u)},
	{66871, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{66894, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{66914, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2087 */
	{50347, S_028C80_TILE_MAX(~0u)},
	/* 2088 */
	{50347, S_028C88_TILE_MAX(~0u)},
	/* 2089 */
	{33233, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33256, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33279, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33302, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33322, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33342, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33362, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33382, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33402, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33422, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33442, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33462, S_008008_RLC_RQ_PENDING(~0u)},
	{66936, S_008008_UTCL2_BUSY(~0u)},
	{66947, S_008008_EA_BUSY(~0u)},
	{66955, S_008008_RMI_BUSY(~0u)},
	{66964, S_008008_UTCL2_RQ_PENDING(~0u)},
	{66981, S_008008_CPF_RQ_PENDING(~0u)},
	{66996, S_008008_EA_LINK_BUSY(~0u)},
	{33477, S_008008_RLC_BUSY(~0u)},
	{33486, S_008008_TC_BUSY(~0u)},
	{33494, S_008008_TCC_CC_RESIDENT(~0u)},
	{33510, S_008008_CPF_BUSY(~0u)},
	{33519, S_008008_CPC_BUSY(~0u)},
	{33528, S_008008_CPG_BUSY(~0u)},
	{67009, S_008008_CPAXI_BUSY(~0u)},
	/* 2114 */
	{33537, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{67020, S_008010_RSMU_RQ_PENDING(~0u)},
	{33576, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33599, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33622, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33641, S_008010_DB_CLEAN(~0u)},
	{33650, S_008010_CB_CLEAN(~0u)},
	{33659, S_008010_TA_BUSY(~0u)},
	{33667, S_008010_GDS_BUSY(~0u)},
	{33676, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33691, S_008010_VGT_BUSY(~0u)},
	{33700, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33715, S_008010_IA_BUSY(~0u)},
	{33723, S_008010_SX_BUSY(~0u)},
	{33731, S_008010_WD_BUSY(~0u)},
	{33739, S_008010_SPI_BUSY(~0u)},
	{33748, S_008010_BCI_BUSY(~0u)},
	{33757, S_008010_SC_BUSY(~0u)},
	{33765, S_008010_PA_BUSY(~0u)},
	{33773, S_008010_DB_BUSY(~0u)},
	{33781, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32344, S_008010_CP_BUSY(~0u)},
	{32566, S_008010_CB_BUSY(~0u)},
	{33799, S_008010_GUI_ACTIVE(~0u)},
	/* 2138 */
	{33641, S_008014_DB_CLEAN(~0u)},
	{33650, S_008014_CB_CLEAN(~0u)},
	{66955, S_008014_RMI_BUSY(~0u)},
	{33748, S_008014_BCI_BUSY(~0u)},
	{33691, S_008014_VGT_BUSY(~0u)},
	{33765, S_008014_PA_BUSY(~0u)},
	{33659, S_008014_TA_BUSY(~0u)},
	{33723, S_008014_SX_BUSY(~0u)},
	{33739, S_008014_SPI_BUSY(~0u)},
	{33757, S_008014_SC_BUSY(~0u)},
	{33773, S_008014_DB_BUSY(~0u)},
	{32566, S_008014_CB_BUSY(~0u)},
	/* 2150 */
	{33641, S_008018_DB_CLEAN(~0u)},
	{33650, S_008018_CB_CLEAN(~0u)},
	{66955, S_008018_RMI_BUSY(~0u)},
	{33748, S_008018_BCI_BUSY(~0u)},
	{33691, S_008018_VGT_BUSY(~0u)},
	{33765, S_008018_PA_BUSY(~0u)},
	{33659, S_008018_TA_BUSY(~0u)},
	{33723, S_008018_SX_BUSY(~0u)},
	{33739, S_008018_SPI_BUSY(~0u)},
	{33757, S_008018_SC_BUSY(~0u)},
	{33773, S_008018_DB_BUSY(~0u)},
	{32566, S_008018_CB_BUSY(~0u)},
	/* 2162 */
	{33641, S_008038_DB_CLEAN(~0u)},
	{33650, S_008038_CB_CLEAN(~0u)},
	{66955, S_008038_RMI_BUSY(~0u)},
	{33748, S_008038_BCI_BUSY(~0u)},
	{33691, S_008038_VGT_BUSY(~0u)},
	{33765, S_008038_PA_BUSY(~0u)},
	{33659, S_008038_TA_BUSY(~0u)},
	{33723, S_008038_SX_BUSY(~0u)},
	{33739, S_008038_SPI_BUSY(~0u)},
	{33757, S_008038_SC_BUSY(~0u)},
	{33773, S_008038_DB_BUSY(~0u)},
	{32566, S_008038_CB_BUSY(~0u)},
	/* 2174 */
	{33641, S_00803C_DB_CLEAN(~0u)},
	{33650, S_00803C_CB_CLEAN(~0u)},
	{66955, S_00803C_RMI_BUSY(~0u)},
	{33748, S_00803C_BCI_BUSY(~0u)},
	{33691, S_00803C_VGT_BUSY(~0u)},
	{33765, S_00803C_PA_BUSY(~0u)},
	{33659, S_00803C_TA_BUSY(~0u)},
	{33723, S_00803C_SX_BUSY(~0u)},
	{33739, S_00803C_SPI_BUSY(~0u)},
	{33757, S_00803C_SC_BUSY(~0u)},
	{33773, S_00803C_DB_BUSY(~0u)},
	{32566, S_00803C_CB_BUSY(~0u)},
	/* 2186 */
	{34307, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{67036, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{67053, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	{34324, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34362, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34153, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34169, S_0301F0_TC_ACTION_ENA(~0u)},
	{34183, S_0301F0_CB_ACTION_ENA(~0u)},
	{34197, S_0301F0_DB_ACTION_ENA(~0u)},
	{34211, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34379, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34232, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34404, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	/* 2199 */
	{34463, S_0301FC_MEID(~0u)},
	{1051, S_0301FC_STATUS(~0u)},
	/* 2201 */
	{34482, S_008210_MEC1_BUSY(~0u)},
	{34492, S_008210_MEC2_BUSY(~0u)},
	{34502, S_008210_DC0_BUSY(~0u)},
	{34511, S_008210_DC1_BUSY(~0u)},
	{34520, S_008210_RCIU1_BUSY(~0u)},
	{34531, S_008210_RCIU2_BUSY(~0u)},
	{34542, S_008210_ROQ1_BUSY(~0u)},
	{34552, S_008210_ROQ2_BUSY(~0u)},
	{34562, S_008210_TCIU_BUSY(~0u)},
	{34572, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34589, S_008210_QU_BUSY(~0u)},
	{67080, S_008210_UTCL2IU_BUSY(~0u)},
	{67093, S_008210_SAVE_RESTORE_BUSY(~0u)},
	{34610, S_008210_CPG_CPC_BUSY(~0u)},
	{34623, S_008210_CPF_CPC_BUSY(~0u)},
	{33519, S_008210_CPC_BUSY(~0u)},
	/* 2217 */
	{35120, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35139, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35159, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35178, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35199, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35217, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35240, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35262, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35283, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35301, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35324, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{67111, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{67135, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{67159, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2231 */
	{35417, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35436, S_00821C_CSF_BUSY(~0u)},
	{35445, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35460, S_00821C_ROQ_RING_BUSY(~0u)},
	{35474, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35493, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35512, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35527, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35544, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35566, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35588, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35603, S_00821C_INTERRUPT_BUSY(~0u)},
	{34562, S_00821C_TCIU_BUSY(~0u)},
	{35618, S_00821C_HQD_BUSY(~0u)},
	{35627, S_00821C_PRT_BUSY(~0u)},
	{67080, S_00821C_UTCL2IU_BUSY(~0u)},
	{35636, S_00821C_CPF_GFX_BUSY(~0u)},
	{35649, S_00821C_CPF_CMP_BUSY(~0u)},
	{35662, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35681, S_00821C_CPC_CPF_BUSY(~0u)},
	{33510, S_00821C_CPF_BUSY(~0u)},
	/* 2252 */
	{36269, S_008224_RING_FETCHING_DATA(~0u)},
	{36288, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36308, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36328, S_008224_STATE_FETCHING_DATA(~0u)},
	{36348, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36369, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{67111, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{67135, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{67182, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{67209, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{67236, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 2263 */
	{37159, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37184, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37222, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37263, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37286, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37309, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37333, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37363, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37392, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37418, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37447, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37472, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36348, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36369, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37507, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37535, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{67111, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{67135, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{67159, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2282 */
	{35460, S_008680_ROQ_RING_BUSY(~0u)},
	{35474, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35493, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35512, S_008680_ROQ_STATE_BUSY(~0u)},
	{38765, S_008680_DC_BUSY(~0u)},
	{67080, S_008680_UTCL2IU_BUSY(~0u)},
	{38773, S_008680_PFP_BUSY(~0u)},
	{38782, S_008680_MEQ_BUSY(~0u)},
	{38791, S_008680_ME_BUSY(~0u)},
	{38799, S_008680_QUERY_BUSY(~0u)},
	{35588, S_008680_SEMAPHORE_BUSY(~0u)},
	{35603, S_008680_INTERRUPT_BUSY(~0u)},
	{38810, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32268, S_008680_DMA_BUSY(~0u)},
	{38828, S_008680_RCIU_BUSY(~0u)},
	{34572, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38851, S_008680_CE_BUSY(~0u)},
	{34562, S_008680_TCIU_BUSY(~0u)},
	{35527, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35544, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35566, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32344, S_008680_CP_BUSY(~0u)},
	/* 2304 */
	{22249, S_030908_PRIM_TYPE(~0u), 29, 26},
	/* 2305 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{67257, S_03090C_PRIMGEN_EN(~0u)},
	/* 2307 */
	{22774, S_03092C_RESET_EN(~0u)},
	{67268, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2309 */
	{37038, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38907, S_03093C_OFFCHIP_GRANULARITY(~0u)},
	/* 2311 */
	{926, S_030944_BASE_HI(~0u)},
	/* 2312 */
	{926, S_03094C_BASE_HI(~0u)},
	/* 2313 */
	{926, S_030954_BASE_HI(~0u)},
	/* 2314 */
	{926, S_03095C_BASE_HI(~0u)},
	/* 2315 */
	{63428, S_030960_PRIMGROUP_SIZE(~0u)},
	{63443, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{63462, S_030960_SWITCH_ON_EOP(~0u)},
	{63476, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{63495, S_030960_SWITCH_ON_EOI(~0u)},
	{63509, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{67283, S_030960_EN_INST_OPT_BASIC(~0u)},
	{67301, S_030960_EN_INST_OPT_ADV(~0u)},
	{67317, S_030960_HW_USE_ONLY(~0u)},
	/* 2324 */
	{67329, S_030D20_TARGET_INST(~0u)},
	{67341, S_030D20_TARGET_DATA(~0u)},
	{39181, S_030D20_INVALIDATE(~0u)},
	{26965, S_030D20_WRITEBACK(~0u)},
	{47103, S_030D20_VOL(~0u)},
	{67353, S_030D20_COMPLETE(~0u)},
	/* 2330 */
	{67362, S_030D24_DWB(~0u)},
	{49512, S_030D24_DIRTY(~0u)},
	/* 2332 */
	{39473, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39483, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39493, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39503, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39687, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{40079, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{67366, S_008F0C_USER_VM_ENABLE(~0u)},
	{67381, S_008F0C_USER_VM_MODE(~0u)},
	{40104, S_008F0C_INDEX_STRIDE(~0u)},
	{40117, S_008F0C_ADD_TID_ENABLE(~0u)},
	{61059, S_008F0C_NV(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 2344 */
	{39338, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40228, S_008F14_MIN_LOD(~0u)},
	{67966, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 34166},
	{68059, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 34230},
	{68294, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 34241},
	{68544, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 34254},
	{68743, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 34268},
	{61059, S_008F14_NV(~0u)},
	{68762, S_008F14_META_DIRECT(~0u)},
	/* 2353 */
	{39473, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39483, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39493, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39503, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42294, S_008F1C_BASE_LEVEL(~0u)},
	{42305, S_008F1C_LAST_LEVEL(~0u)},
	{68774, S_008F1C_SW_MODE(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 2361 */
	{22233, S_008F20_DEPTH(~0u)},
	{68782, S_008F20_PITCH_GFX9(~0u)},
	{68889, S_008F20_BC_SWIZZLE(~0u), 6, 34278},
	/* 2364 */
	{42651, S_008F24_BASE_ARRAY(~0u)},
	{68900, S_008F24_ARRAY_PITCH(~0u)},
	{68912, S_008F24_META_DATA_ADDRESS(~0u)},
	{68930, S_008F24_META_LINEAR(~0u)},
	{68942, S_008F24_META_PIPE_ALIGNED(~0u)},
	{68960, S_008F24_META_RB_ALIGNED(~0u)},
	{68976, S_008F24_MAX_MIP(~0u)},
	/* 2371 */
	{43493, S_008F38_LOD_BIAS(~0u)},
	{43502, S_008F38_LOD_BIAS_SEC(~0u)},
	{43564, S_008F38_XY_MAG_FILTER(~0u), 2, 337},
	{43639, S_008F38_XY_MIN_FILTER(~0u), 4, 339},
	{43719, S_008F38_Z_FILTER(~0u), 3, 343},
	{43728, S_008F38_MIP_FILTER(~0u), 3, 343},
	{43739, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{68984, S_008F38_BLEND_ZERO_PRT(~0u)},
	{43775, S_008F38_FILTER_PREC_FIX(~0u)},
	{43791, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 2381 */
	{43806, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{68999, S_008F3C_SKIP_DEGAMMA(~0u)},
	{43965, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 346},
	/* 2384 */
	{44373, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{44392, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{44411, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44433, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44455, S_031100_RSRC_MGMT_RESET(~0u)},
	{69012, S_031100_TTRACE_STALL_ALL(~0u)},
	{69029, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{69047, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{69063, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2393 */
	{44724, S_031104_VTX_DONE_DELAY(~0u), 16, 351},
	{44739, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{69084, S_031104_BATON_RESET_DISABLE(~0u)},
	{44763, S_031104_PC_LIMIT_ENABLE(~0u)},
	{44779, S_031104_PC_LIMIT_STRICT(~0u)},
	{69104, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{69130, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{69147, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{69163, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{69184, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{44795, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2404 */
	{69205, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{69246, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2406 */
	{44971, S_0098F8_NUM_PIPES(~0u)},
	{69285, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{69311, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{45007, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{46458, S_0098F8_NUM_BANKS(~0u)},
	{45052, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{69332, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{69356, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{45090, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{69370, S_0098F8_NUM_RB_PER_SE(~0u)},
	{45110, S_0098F8_ROW_SIZE(~0u)},
	{45119, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{69384, S_0098F8_SE_ENABLE(~0u)},
	/* 2419 */
	{45497, S_009910_ARRAY_MODE(~0u), 16, 371},
	{45859, S_009910_PIPE_CONFIG(~0u), 15, 387},
	{46049, S_009910_TILE_SPLIT(~0u), 7, 402},
	{46499, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 425},
	{46519, S_009910_SAMPLE_SPLIT(~0u)},
	/* 2424 */
	{44071, S_00B01C_CU_EN(~0u)},
	{46541, S_00B01C_WAVE_LIMIT(~0u)},
	{46552, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{69394, S_00B01C_SIMD_DISABLE(~0u)},
	/* 2428 */
	{46571, S_00B028_VGPRS(~0u)},
	{46577, S_00B028_SGPRS(~0u)},
	{2722, S_00B028_PRIORITY(~0u)},
	{46626, S_00B028_FLOAT_MODE(~0u), 241, 429},
	{46637, S_00B028_PRIV(~0u)},
	{46642, S_00B028_DX10_CLAMP(~0u)},
	{46653, S_00B028_DEBUG_MODE(~0u)},
	{46664, S_00B028_IEEE_MODE(~0u)},
	{46674, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46701, S_00B028_CDBG_USER(~0u)},
	{69407, S_00B028_FP16_OVFL(~0u)},
	/* 2439 */
	{46711, S_00B02C_SCRATCH_EN(~0u)},
	{46722, S_00B02C_USER_SGPR(~0u)},
	{46732, S_00B02C_TRAP_PRESENT(~0u)},
	{46745, S_00B02C_WAVE_CNT_EN(~0u)},
	{46757, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46783, S_00B02C_EXCP_EN(~0u)},
	{69417, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{69439, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{69464, S_00B02C_SKIP_USGPR0(~0u)},
	{69476, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 2449 */
	{44071, S_00B118_CU_EN(~0u)},
	{46541, S_00B118_WAVE_LIMIT(~0u)},
	{46552, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{69394, S_00B118_SIMD_DISABLE(~0u)},
	/* 2453 */
	{46571, S_00B128_VGPRS(~0u)},
	{46577, S_00B128_SGPRS(~0u)},
	{2722, S_00B128_PRIORITY(~0u)},
	{46626, S_00B128_FLOAT_MODE(~0u)},
	{46637, S_00B128_PRIV(~0u)},
	{46642, S_00B128_DX10_CLAMP(~0u)},
	{46653, S_00B128_DEBUG_MODE(~0u)},
	{46664, S_00B128_IEEE_MODE(~0u)},
	{46791, S_00B128_VGPR_COMP_CNT(~0u)},
	{46805, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46701, S_00B128_CDBG_USER(~0u)},
	{69407, S_00B128_FP16_OVFL(~0u)},
	/* 2465 */
	{46711, S_00B12C_SCRATCH_EN(~0u)},
	{46722, S_00B12C_USER_SGPR(~0u)},
	{46732, S_00B12C_TRAP_PRESENT(~0u)},
	{46821, S_00B12C_OC_LDS_EN(~0u)},
	{46831, S_00B12C_SO_BASE0_EN(~0u)},
	{46843, S_00B12C_SO_BASE1_EN(~0u)},
	{46855, S_00B12C_SO_BASE2_EN(~0u)},
	{46867, S_00B12C_SO_BASE3_EN(~0u)},
	{46879, S_00B12C_SO_EN(~0u)},
	{46783, S_00B12C_EXCP_EN(~0u)},
	{69490, S_00B12C_PC_BASE_EN(~0u)},
	{46885, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{69464, S_00B12C_SKIP_USGPR0(~0u)},
	{69476, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 2479 */
	{46711, S_00B1F0_SCRATCH_EN(~0u)},
	{46722, S_00B1F0_USER_SGPR(~0u)},
	{46732, S_00B1F0_TRAP_PRESENT(~0u)},
	{46783, S_00B1F0_EXCP_EN(~0u)},
	{46791, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{46821, S_00B1F0_OC_LDS_EN(~0u)},
	{46763, S_00B1F0_LDS_SIZE(~0u)},
	{69464, S_00B1F0_SKIP_USGPR0(~0u)},
	{69476, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2488 */
	{46902, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{69501, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2490 */
	{46532, S_00B214_MEM_BASE(~0u)},
	/* 2491 */
	{44071, S_00B21C_CU_EN(~0u)},
	{46541, S_00B21C_WAVE_LIMIT(~0u)},
	{46552, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{69394, S_00B21C_SIMD_DISABLE(~0u)},
	/* 2495 */
	{46571, S_00B228_VGPRS(~0u)},
	{46577, S_00B228_SGPRS(~0u)},
	{2722, S_00B228_PRIORITY(~0u)},
	{46626, S_00B228_FLOAT_MODE(~0u)},
	{46637, S_00B228_PRIV(~0u)},
	{46642, S_00B228_DX10_CLAMP(~0u)},
	{46653, S_00B228_DEBUG_MODE(~0u)},
	{46664, S_00B228_IEEE_MODE(~0u)},
	{46805, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46701, S_00B228_CDBG_USER(~0u)},
	{69526, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{69407, S_00B228_FP16_OVFL(~0u)},
	/* 2507 */
	{46711, S_00B22C_SCRATCH_EN(~0u)},
	{46722, S_00B22C_USER_SGPR(~0u)},
	{46732, S_00B22C_TRAP_PRESENT(~0u)},
	{46783, S_00B22C_EXCP_EN(~0u)},
	{69543, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{46821, S_00B22C_OC_LDS_EN(~0u)},
	{46763, S_00B22C_LDS_SIZE(~0u)},
	{69464, S_00B22C_SKIP_USGPR0(~0u)},
	{69476, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 2516 */
	{46902, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2517 */
	{46532, S_00B414_MEM_BASE(~0u)},
	/* 2518 */
	{46541, S_00B41C_WAVE_LIMIT(~0u)},
	{46552, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{69394, S_00B41C_SIMD_DISABLE(~0u)},
	{44071, S_00B41C_CU_EN(~0u)},
	/* 2522 */
	{46571, S_00B428_VGPRS(~0u)},
	{46577, S_00B428_SGPRS(~0u)},
	{2722, S_00B428_PRIORITY(~0u)},
	{46626, S_00B428_FLOAT_MODE(~0u)},
	{46637, S_00B428_PRIV(~0u)},
	{46642, S_00B428_DX10_CLAMP(~0u)},
	{46653, S_00B428_DEBUG_MODE(~0u)},
	{46664, S_00B428_IEEE_MODE(~0u)},
	{46701, S_00B428_CDBG_USER(~0u)},
	{69560, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{69407, S_00B428_FP16_OVFL(~0u)},
	/* 2533 */
	{46711, S_00B42C_SCRATCH_EN(~0u)},
	{46722, S_00B42C_USER_SGPR(~0u)},
	{46732, S_00B42C_TRAP_PRESENT(~0u)},
	{46783, S_00B42C_EXCP_EN(~0u)},
	{46763, S_00B42C_LDS_SIZE(~0u)},
	{69464, S_00B42C_SKIP_USGPR0(~0u)},
	{69476, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 2540 */
	{46945, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46963, S_00B800_PARTIAL_TG_EN(~0u)},
	{46977, S_00B800_FORCE_START_AT_000(~0u)},
	{46996, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{47016, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{47036, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{47058, S_00B800_ORDER_MODE(~0u)},
	{47089, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{47107, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{8169, S_00B800_RESERVED(~0u)},
	{47134, S_00B800_RESTORE(~0u)},
	/* 2551 */
	{46571, S_00B848_VGPRS(~0u)},
	{46577, S_00B848_SGPRS(~0u)},
	{2722, S_00B848_PRIORITY(~0u)},
	{46626, S_00B848_FLOAT_MODE(~0u)},
	{46637, S_00B848_PRIV(~0u)},
	{46642, S_00B848_DX10_CLAMP(~0u)},
	{46653, S_00B848_DEBUG_MODE(~0u)},
	{46664, S_00B848_IEEE_MODE(~0u)},
	{47186, S_00B848_BULKY(~0u)},
	{46701, S_00B848_CDBG_USER(~0u)},
	{69407, S_00B848_FP16_OVFL(~0u)},
	/* 2562 */
	{46711, S_00B84C_SCRATCH_EN(~0u)},
	{46722, S_00B84C_USER_SGPR(~0u)},
	{46732, S_00B84C_TRAP_PRESENT(~0u)},
	{47192, S_00B84C_TGID_X_EN(~0u)},
	{47202, S_00B84C_TGID_Y_EN(~0u)},
	{47212, S_00B84C_TGID_Z_EN(~0u)},
	{46919, S_00B84C_TG_SIZE_EN(~0u)},
	{47222, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47237, S_00B84C_EXCP_EN_MSB(~0u)},
	{46763, S_00B84C_LDS_SIZE(~0u)},
	{46783, S_00B84C_EXCP_EN(~0u)},
	{69464, S_00B84C_SKIP_USGPR0(~0u)},
	/* 2574 */
	{47265, S_00B854_WAVES_PER_SH(~0u)},
	{47278, S_00B854_TG_PER_CU(~0u)},
	{47288, S_00B854_LOCK_THRESHOLD(~0u)},
	{47303, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47318, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47334, S_00B854_CU_GROUP_COUNT(~0u)},
	{69394, S_00B854_SIMD_DISABLE(~0u)},
	/* 2581 */
	{69577, S_036008_CNTR_SEL0(~0u)},
	{69587, S_036008_CNTR_SEL1(~0u)},
	{48267, S_036008_SPM_MODE(~0u)},
	{69597, S_036008_CNTR_MODE1(~0u)},
	{69608, S_036008_CNTR_MODE0(~0u)},
	/* 2586 */
	{69619, S_036004_CNTR_SEL2(~0u)},
	{69629, S_036004_CNTR_SEL3(~0u)},
	{69639, S_036004_CNTR_MODE3(~0u)},
	{69650, S_036004_CNTR_MODE2(~0u)},
	/* 2590 */
	{69577, S_036024_CNTR_SEL0(~0u)},
	{69587, S_036024_CNTR_SEL1(~0u)},
	{48267, S_036024_SPM_MODE(~0u)},
	{69597, S_036024_CNTR_MODE1(~0u)},
	{69608, S_036024_CNTR_MODE0(~0u)},
	/* 2595 */
	{69619, S_036010_CNTR_SEL2(~0u)},
	{69629, S_036010_CNTR_SEL3(~0u)},
	{69639, S_036010_CNTR_MODE3(~0u)},
	{69650, S_036010_CNTR_MODE2(~0u)},
	/* 2599 */
	{69577, S_03601C_CNTR_SEL0(~0u)},
	{69587, S_03601C_CNTR_SEL1(~0u)},
	{48267, S_03601C_SPM_MODE(~0u)},
	{69597, S_03601C_CNTR_MODE1(~0u)},
	{69608, S_03601C_CNTR_MODE0(~0u)},
	/* 2604 */
	{69619, S_036018_CNTR_SEL2(~0u)},
	{69629, S_036018_CNTR_SEL3(~0u)},
	{69639, S_036018_CNTR_MODE3(~0u)},
	{69650, S_036018_CNTR_MODE2(~0u)},
	/* 2608 */
	{441, S_036028_INDEX(~0u)},
	{43243, S_036028_ALWAYS(~0u)},
	{7762, S_036028_ENABLE(~0u)},
	/* 2611 */
	{441, S_03602C_INDEX(~0u)},
	{43243, S_03602C_ALWAYS(~0u)},
	{7762, S_03602C_ENABLE(~0u)},
	/* 2614 */
	{441, S_036030_INDEX(~0u)},
	{15508, S_036030_CLEAR(~0u)},
	{7762, S_036030_ENABLE(~0u)},
	/* 2617 */
	{441, S_036034_INDEX(~0u)},
	{15508, S_036034_CLEAR(~0u)},
	{7762, S_036034_ENABLE(~0u)},
	/* 2620 */
	{441, S_036038_INDEX(~0u)},
	{15508, S_036038_CLEAR(~0u)},
	{7762, S_036038_ENABLE(~0u)},
	/* 2623 */
	{47453, S_036100_PERF_SEL(~0u)},
	{47623, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47677, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47704, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47835, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47915, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47941, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47967, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{48021, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{48048, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{48074, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{69661, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{69690, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{69716, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2645 */
	{47453, S_036108_PERF_SEL(~0u)},
	{47623, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69716, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2658 */
	{47453, S_03610C_PERF_SEL(~0u)},
	{47623, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69716, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2671 */
	{47453, S_036110_PERF_SEL(~0u)},
	{47623, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69716, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2684 */
	{47453, S_036114_PERF_SEL(~0u)},
	{47623, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47650, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47704, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47730, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47756, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47783, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47863, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47889, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47677, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47809, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47994, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69716, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2697 */
	{47453, S_036600_PERF_SEL(~0u)},
	{47462, S_036600_PERF_SEL1(~0u)},
	{47472, S_036600_CNTR_MODE(~0u)},
	{48110, S_036600_PERF_MODE1(~0u)},
	{48100, S_036600_PERF_MODE(~0u)},
	/* 2702 */
	{47482, S_036610_PERF_SEL2(~0u)},
	{47492, S_036610_PERF_SEL3(~0u)},
	{48121, S_036610_PERF_MODE3(~0u)},
	{48132, S_036610_PERF_MODE2(~0u)},
	/* 2706 */
	{48995, S_028008_SLICE_START(~0u)},
	{49007, S_028008_SLICE_MAX(~0u)},
	{49017, S_028008_Z_READ_ONLY(~0u)},
	{49029, S_028008_STENCIL_READ_ONLY(~0u)},
	{69743, S_028008_MIPID(~0u)},
	/* 2711 */
	{49646, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 681},
	{49675, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49706, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49742, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49777, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49805, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49827, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49845, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49877, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49903, S_028010_HIZ_ZFUNC(~0u)},
	{49913, S_028010_HIS_SFUNC_FF(~0u)},
	{49926, S_028010_HIS_SFUNC_BF(~0u)},
	{49939, S_028010_PRESERVE_ZRANGE(~0u)},
	{49955, S_028010_PRESERVE_SRESULTS(~0u)},
	{49973, S_028010_DISABLE_FAST_PASS(~0u)},
	{69749, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 2727 */
	{926, S_028018_BASE_HI(~0u)},
	/* 2728 */
	{69777, S_02801C_X_MAX(~0u)},
	{69783, S_02801C_Y_MAX(~0u)},
	/* 2730 */
	{21251, S_028038_FORMAT(~0u), 4, 710},
	{50163, S_028038_NUM_SAMPLES(~0u)},
	{68774, S_028038_SW_MODE(~0u)},
	{69789, S_028038_PARTIALLY_RESIDENT(~0u)},
	{69808, S_028038_FAULT_BEHAVIOR(~0u)},
	{69823, S_028038_ITERATE_FLUSH(~0u)},
	{69837, S_028038_MAXMIP(~0u)},
	{50191, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{50215, S_028038_ALLOW_EXPCLEAR(~0u)},
	{50230, S_028038_READ_SIZE(~0u)},
	{50240, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{50260, S_028038_CLEAR_DISALLOWED(~0u)},
	{50277, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2743 */
	{21251, S_02803C_FORMAT(~0u), 2, 714},
	{68774, S_02803C_SW_MODE(~0u)},
	{69789, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{69808, S_02803C_FAULT_BEHAVIOR(~0u)},
	{69823, S_02803C_ITERATE_FLUSH(~0u)},
	{50215, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{50320, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{50260, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2751 */
	{926, S_028044_BASE_HI(~0u)},
	/* 2752 */
	{926, S_02804C_BASE_HI(~0u)},
	/* 2753 */
	{926, S_028054_BASE_HI(~0u)},
	/* 2754 */
	{926, S_02805C_BASE_HI(~0u)},
	/* 2755 */
	{69853, S_028060_PUNCHOUT_MODE(~0u), 4, 34284},
	{69867, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{69892, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2758 */
	{30512, S_028068_EPITCH(~0u)},
	/* 2759 */
	{30512, S_02806C_EPITCH(~0u)},
	/* 2760 */
	{69910, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 2761 */
	{69910, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 2762 */
	{69910, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 2763 */
	{69910, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 2764 */
	{50940, S_028350_RB_MAP_PKR0(~0u), 4, 33485},
	{50952, S_028350_RB_MAP_PKR1(~0u), 4, 33485},
	{51064, S_028350_RB_XSEL2(~0u), 4, 33489},
	{51073, S_028350_RB_XSEL(~0u)},
	{51081, S_028350_RB_YSEL(~0u)},
	{51185, S_028350_PKR_MAP(~0u), 4, 33493},
	{51293, S_028350_PKR_XSEL(~0u), 4, 33497},
	{51402, S_028350_PKR_YSEL(~0u), 4, 33501},
	{51515, S_028350_PKR_XSEL2(~0u), 4, 33505},
	{51617, S_028350_SC_MAP(~0u), 4, 33509},
	{51763, S_028350_SC_XSEL(~0u), 4, 33513},
	{51910, S_028350_SC_YSEL(~0u), 4, 33517},
	{52010, S_028350_SE_MAP(~0u), 4, 33521},
	{69928, S_028350_SE_XSEL_GFX9(~0u)},
	{69941, S_028350_SE_YSEL_GFX9(~0u)},
	/* 2779 */
	{52433, S_028354_SE_PAIR_MAP(~0u), 4, 33533},
	{69954, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{69972, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 2782 */
	{7762, S_02835C_ENABLE(~0u)},
	{69990, S_02835C_NUM_SE(~0u)},
	{69370, S_02835C_NUM_RB_PER_SE(~0u)},
	/* 2785 */
	{69997, S_028360_PERFMON_ENABLE(~0u)},
	/* 2786 */
	{70012, S_0283A0_LEFT_QTR(~0u)},
	{70021, S_0283A0_LEFT_HALF(~0u)},
	{70031, S_0283A0_RIGHT_HALF(~0u)},
	{70042, S_0283A0_RIGHT_QTR(~0u)},
	/* 2790 */
	{70012, S_0283A4_LEFT_QTR(~0u)},
	{70021, S_0283A4_LEFT_HALF(~0u)},
	{70031, S_0283A4_RIGHT_HALF(~0u)},
	{70042, S_0283A4_RIGHT_QTR(~0u)},
	/* 2794 */
	{70052, S_0283A8_TOP_QTR(~0u)},
	{70060, S_0283A8_TOP_HALF(~0u)},
	{70069, S_0283A8_BOT_HALF(~0u)},
	{70078, S_0283A8_BOT_QTR(~0u)},
	/* 2798 */
	{52799, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52826, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52865, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	{70086, S_028424_DISABLE_CONSTANT_ENCODE_REG(~0u)},
	/* 2802 */
	{54068, S_0286D8_NUM_INTERP(~0u)},
	{54079, S_0286D8_PARAM_GEN(~0u)},
	{70114, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{70131, S_0286D8_LATE_PC_DEALLOC(~0u)},
	{54098, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	/* 2807 */
	{30512, S_0287A0_EPITCH(~0u)},
	/* 2808 */
	{30512, S_0287A4_EPITCH(~0u)},
	/* 2809 */
	{30512, S_0287A8_EPITCH(~0u)},
	/* 2810 */
	{30512, S_0287AC_EPITCH(~0u)},
	/* 2811 */
	{30512, S_0287B0_EPITCH(~0u)},
	/* 2812 */
	{30512, S_0287B4_EPITCH(~0u)},
	/* 2813 */
	{30512, S_0287B8_EPITCH(~0u)},
	/* 2814 */
	{30512, S_0287BC_EPITCH(~0u)},
	/* 2815 */
	{70147, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 2816 */
	{56952, S_0287F0_SOURCE_SELECT(~0u), 4, 33652},
	{56998, S_0287F0_MAJOR_MODE(~0u), 2, 33656},
	{70162, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{57009, S_0287F0_NOT_EOP(~0u)},
	{57017, S_0287F0_USE_OPAQUE(~0u)},
	{70177, S_0287F0_UNROLLED_INST(~0u)},
	{70191, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{70208, S_0287F0_REG_RT_INDEX(~0u)},
	/* 2824 */
	{57993, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{58009, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{58040, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{49165, S_02880C_Z_ORDER(~0u), 4, 33937},
	{58119, S_02880C_KILL_ENABLE(~0u)},
	{58131, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{58155, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{58174, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{58192, S_02880C_EXEC_ON_NOOP(~0u)},
	{58205, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58227, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58317, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 33941},
	{58339, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{70221, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{70252, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{70271, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 2840 */
	{58661, S_028814_CULL_FRONT(~0u)},
	{58672, S_028814_CULL_BACK(~0u)},
	{22939, S_028814_FACE(~0u)},
	{58692, S_028814_POLY_MODE(~0u), 2, 33945},
	{58758, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 33947},
	{58779, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 33947},
	{58799, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58824, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58848, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58872, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58897, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58916, S_028814_PERSP_CORR_DIS(~0u)},
	{58931, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{70296, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{70334, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 2855 */
	{58949, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58967, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58986, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{59004, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{59023, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{59041, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{59060, S_028818_VTX_XY_FMT(~0u)},
	{59071, S_028818_VTX_Z_FMT(~0u)},
	{59081, S_028818_VTX_W0_FMT(~0u)},
	{70357, S_028818_PERFCOUNTER_REF(~0u)},
	/* 2865 */
	{59092, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{59108, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{59124, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{59140, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{59156, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{59172, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{59188, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{59204, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{59220, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59236, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59252, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59268, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59284, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59300, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59316, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59332, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59348, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59367, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59385, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59412, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59434, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59452, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59472, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59495, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59518, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59543, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59563, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{70373, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 2893 */
	{70396, S_028834_OBJ_ID_SEL(~0u)},
	{70407, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{70425, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2896 */
	{70444, S_028838_VERTEX_REUSE_OFF(~0u)},
	{70461, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2898 */
	{70485, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{70510, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{70531, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{70553, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{70579, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2903 */
	{22398, S_028A40_MODE(~0u), 6, 33987},
	{39408, S_028A40_RESERVED_0(~0u)},
	{61210, S_028A40_CUT_MODE(~0u), 4, 33993},
	{39426, S_028A40_RESERVED_1(~0u)},
	{61219, S_028A40_GS_C_PACK_EN(~0u)},
	{61232, S_028A40_RESERVED_2(~0u)},
	{61243, S_028A40_ES_PASSTHRU(~0u)},
	{70596, S_028A40_RESERVED_3(~0u)},
	{70607, S_028A40_RESERVED_4(~0u)},
	{70618, S_028A40_RESERVED_5(~0u)},
	{61302, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61321, S_028A40_SUPPRESS_CUTS(~0u)},
	{61335, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61353, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61404, S_028A40_ONCHIP(~0u), 4, 33997},
	/* 2918 */
	{61411, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61431, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{70629, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 2921 */
	{61451, S_028A48_MSAA_ENABLE(~0u)},
	{61463, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61484, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61504, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{70653, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{70674, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{70697, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 2928 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 34004},
	{62288, S_028A7C_SWAP_MODE(~0u), 4, 34007},
	{62349, S_028A7C_BUF_TYPE(~0u), 3, 34011},
	{62408, S_028A7C_RDREQ_POLICY(~0u)},
	{67257, S_028A7C_PRIMGEN_EN(~0u)},
	{57009, S_028A7C_NOT_EOP(~0u)},
	{62421, S_028A7C_REQ_PATH(~0u)},
	/* 2935 */
	{22677, S_028A84_PRIMITIVEID_EN(~0u)},
	{62430, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{70727, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 2938 */
	{63386, S_028A90_EVENT_TYPE(~0u), 63, 34288},
	{70852, S_028A90_ADDRESS_HI_GFX9(~0u)},
	{63413, S_028A90_EXTENDED_EVENT(~0u)},
	/* 2941 */
	{30713, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2942 */
	{70868, S_028A98_OBJPRIM_ID_EN(~0u)},
	{70882, S_028A98_EN_REG_RT_INDEX(~0u)},
	{70898, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{70917, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2946 */
	{63546, S_028ABC_FULL_CACHE(~0u)},
	{63557, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63580, S_028ABC_PRELOAD(~0u)},
	{63588, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63603, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63619, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{68947, S_028ABC_PIPE_ALIGNED(~0u)},
	{68965, S_028ABC_RB_ALIGNED(~0u)},
	/* 2954 */
	{48310, S_028B54_LS_EN(~0u), 3, 34075},
	{48304, S_028B54_HS_EN(~0u)},
	{23502, S_028B54_ES_EN(~0u), 3, 34078},
	{48298, S_028B54_GS_EN(~0u)},
	{48292, S_028B54_VS_EN(~0u), 3, 34081},
	{46885, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63941, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63961, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63981, S_028B54_VS_WAVE_ID_EN(~0u)},
	{67257, S_028B54_PRIMGEN_EN(~0u)},
	{70935, S_028B54_ORDERED_ID_MODE(~0u)},
	{63526, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{70951, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2967 */
	{209, S_028B6C_TYPE(~0u), 3, 34084},
	{64129, S_028B6C_PARTITIONING(~0u), 4, 34087},
	{64206, S_028B6C_TOPOLOGY(~0u), 4, 34091},
	{64215, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64235, S_028B6C_DEPRECATED(~0u)},
	{64268, S_028B6C_DISABLE_DONUTS(~0u)},
	{62408, S_028B6C_RDREQ_POLICY(~0u)},
	{64407, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 34098},
	/* 2975 */
	{64603, S_028B94_STREAMOUT_0_EN(~0u)},
	{64618, S_028B94_STREAMOUT_1_EN(~0u)},
	{64633, S_028B94_STREAMOUT_2_EN(~0u)},
	{64648, S_028B94_STREAMOUT_3_EN(~0u)},
	{64663, S_028B94_RAST_STREAM(~0u)},
	{70966, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	{64675, S_028B94_RAST_STREAM_MASK(~0u)},
	{64692, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 2983 */
	{63386, S_028B9C_EVENT_TYPE(~0u)},
	{39343, S_028B9C_ADDRESS_HI(~0u)},
	{63413, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2986 */
	{65047, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{65064, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{65086, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{65102, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{65123, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{70986, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2992 */
	{65658, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{69417, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{69439, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2995 */
	{71102, S_028C44_BINNING_MODE(~0u), 4, 34351},
	{71115, S_028C44_BIN_SIZE_X(~0u)},
	{71126, S_028C44_BIN_SIZE_Y(~0u)},
	{71137, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{71155, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{71173, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{71196, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{71222, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{71244, S_028C44_FPOVS_PER_BATCH(~0u)},
	{71260, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 3005 */
	{71282, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{71298, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 3007 */
	{71317, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{71334, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{71358, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{71376, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{71401, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{71431, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{71446, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{71461, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{71496, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{71532, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{71576, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{71600, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71636, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71672, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{71698, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{71722, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{71742, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{71763, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 3025 */
	{71788, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 3026 */
	{71809, S_028C64_BASE_256B(~0u)},
	/* 3027 */
	{71819, S_028C68_MIP0_HEIGHT(~0u)},
	{71831, S_028C68_MIP0_WIDTH(~0u)},
	{68976, S_028C68_MAX_MIP(~0u)},
	/* 3030 */
	{48995, S_028C6C_SLICE_START(~0u)},
	{49007, S_028C6C_SLICE_MAX(~0u)},
	{71842, S_028C6C_MIP_LEVEL(~0u)},
	/* 3033 */
	{65782, S_028C70_ENDIAN(~0u), 4, 34114},
	{21251, S_028C70_FORMAT(~0u), 23, 34118},
	{66149, S_028C70_NUMBER_TYPE(~0u), 8, 34141},
	{66205, S_028C70_COMP_SWAP(~0u), 4, 34149},
	{57732, S_028C70_FAST_CLEAR(~0u)},
	{49581, S_028C70_COMPRESSION(~0u)},
	{66215, S_028C70_BLEND_CLAMP(~0u)},
	{66227, S_028C70_BLEND_BYPASS(~0u)},
	{66240, S_028C70_SIMPLE_FLOAT(~0u)},
	{65207, S_028C70_ROUND_MODE(~0u)},
	{66480, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 34153},
	{66502, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 34153},
	{66526, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66552, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66578, S_028C70_DCC_ENABLE(~0u)},
	{66589, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 3049 */
	{71852, S_028C74_MIP0_DEPTH(~0u)},
	{68930, S_028C74_META_LINEAR(~0u)},
	{50163, S_028C74_NUM_SAMPLES(~0u)},
	{66645, S_028C74_NUM_FRAGMENTS(~0u)},
	{66659, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{71863, S_028C74_COLOR_SW_MODE(~0u)},
	{71877, S_028C74_FMASK_SW_MODE(~0u)},
	{71891, S_028C74_RESOURCE_TYPE(~0u), 4, 34355},
	{68965, S_028C74_RB_ALIGNED(~0u)},
	{68947, S_028C74_PIPE_ALIGNED(~0u)},
	/* 3059 */
	{71809, S_028C80_BASE_256B(~0u)},
	/* 3060 */
	{71809, S_028C88_BASE_256B(~0u)},
	/* 3061 */
	{71809, S_028C98_BASE_256B(~0u)},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 77, 91 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 203, 209 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 436, 441, 445 */
	"WAIT_REG_MEM\0" /* 447, 456 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"REWIND\0" /* 616 */
	"SET_CONFIG_REG\0" /* 623 */
	"SET_CONTEXT_REG\0" /* 638 */
	"SET_SH_REG\0" /* 654 */
	"SET_SH_REG_OFFSET\0" /* 665, 676 */
	"SET_UCONFIG_REG\0" /* 683 */
	"SET_UCONFIG_REG_INDEX\0" /* 699 */
	"LOAD_CONST_RAM\0" /* 721 */
	"WRITE_CONST_RAM\0" /* 736 */
	"DUMP_CONST_RAM\0" /* 752 */
	"INCREMENT_CE_COUNTER\0" /* 767 */
	"INCREMENT_DE_COUNTER\0" /* 788 */
	"WAIT_ON_CE_COUNTER\0" /* 809 */
	"LOAD_CONTEXT_REG\0" /* 828 */
	"IT_OPCODE_C\0" /* 845 */
	"CP_DMA\0" /* 857 */
	"DMA_DATA\0" /* 864 */
	"DRAW_INDEX_LOC\0" /* 873 */
	"DST_ADDR_LO\0" /* 888 */
	"DST_ADDR_HI\0" /* 900 */
	"IB_BASE_LO\0" /* 912 */
	"IB_BASE_HI\0" /* 923, 926 */
	"CP_DMA_WORD0\0" /* 934 */
	"CP_DMA_WORD1\0" /* 947 */
	"CP_DMA_WORD2\0" /* 960 */
	"CP_DMA_WORD3\0" /* 973 */
	"COMMAND\0" /* 986 */
	"DMA_DATA_WORD0\0" /* 994 */
	"SRC_ADDR_LO\0" /* 1009 */
	"SRC_ADDR_HI\0" /* 1021 */
	"SRBM_STATUS2\0" /* 1033 */
	"SRBM_STATUS\0" /* 1046, 1051 */
	"SRBM_STATUS3\0" /* 1058 */
	"SDMA0_STATUS_REG\0" /* 1071 */
	"SDMA1_STATUS_REG\0" /* 1088 */
	"GRBM_STATUS2\0" /* 1105 */
	"GRBM_STATUS\0" /* 1118 */
	"GRBM_GFX_INDEX\0" /* 1130 */
	"CP_STRMOUT_CNTL\0" /* 1145 */
	"CP_COHER_CNTL\0" /* 1161 */
	"CP_COHER_SIZE\0" /* 1175 */
	"CP_COHER_BASE\0" /* 1189 */
	"GRBM_STATUS_SE0\0" /* 1203 */
	"GRBM_STATUS_SE1\0" /* 1219 */
	"GRBM_STATUS_SE2\0" /* 1235 */
	"GRBM_STATUS_SE3\0" /* 1251 */
	"CP_COHER_BASE_HI\0" /* 1267 */
	"CP_COHER_START_DELAY\0" /* 1284 */
	"CP_COHER_STATUS\0" /* 1305 */
	"CP_CPC_STATUS\0" /* 1321 */
	"CP_CPC_BUSY_STAT\0" /* 1335 */
	"CP_CPC_STALLED_STAT1\0" /* 1352 */
	"CP_CPF_STATUS\0" /* 1373 */
	"CP_CPF_BUSY_STAT\0" /* 1387 */
	"CP_CPF_STALLED_STAT1\0" /* 1404 */
	"CP_COHER_SIZE_HI\0" /* 1425 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 1442 */
	"VGT_CACHE_INVALIDATION\0" /* 1465 */
	"VGT_ESGS_RING_SIZE\0" /* 1488, 1497 */
	"VGT_GSVS_RING_SIZE\0" /* 1507 */
	"VGT_GS_VERTEX_REUSE\0" /* 1526 */
	"VGT_PRIMITIVE_TYPE\0" /* 1546 */
	"VGT_INDEX_TYPE\0" /* 1565 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 1580 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 1613 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 1646 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 1679 */
	"VGT_NUM_INDICES\0" /* 1712 */
	"VGT_NUM_INSTANCES\0" /* 1728 */
	"VGT_TF_RING_SIZE\0" /* 1746 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 1763 */
	"VGT_TF_MEMORY_BASE\0" /* 1784 */
	"PA_CL_ENHANCE\0" /* 1803, 1814 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 1817, 1823, 1836 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 1842 */
	"CP_STALLED_STAT3\0" /* 1867 */
	"CP_STALLED_STAT1\0" /* 1884 */
	"CP_STALLED_STAT2\0" /* 1901 */
	"CP_STAT\0" /* 1918 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 1926, 1947 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 1952 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 1978, 1999 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 2004 */
	"PA_SC_ENHANCE\0" /* 2030 */
	"SQC_CACHES\0" /* 2044 */
	"SQ_RANDOM_WAVE_PRI\0" /* 2055 */
	"SQ_EXP_0\0" /* 2074 */
	"TA_CS_BC_BASE_ADDR\0" /* 2083, 2097 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 2102 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 2124 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 2148 */
	"SQ_BUF_RSRC_WORD0\0" /* 2171 */
	"SQ_BUF_RSRC_WORD1\0" /* 2189 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 2207 */
	"SQ_BUF_RSRC_WORD2\0" /* 2231 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 2249 */
	"SQ_BUF_RSRC_WORD3\0" /* 2272 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 2290 */
	"SQ_IMG_RSRC_WORD0\0" /* 2314 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 2332 */
	"SQ_IMG_RSRC_WORD1\0" /* 2355 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 2373 */
	"SQ_IMG_RSRC_WORD2\0" /* 2397 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 2415 */
	"SQ_IMG_RSRC_WORD3\0" /* 2438 */
	"SQ_IMG_RSRC_WORD4\0" /* 2456 */
	"SQ_IMG_RSRC_WORD5\0" /* 2474 */
	"SQ_IMG_RSRC_WORD6\0" /* 2492 */
	"SQ_IMG_RSRC_WORD7\0" /* 2510 */
	"SQ_IMG_SAMP_WORD0\0" /* 2528 */
	"SQ_IMG_SAMP_WORD1\0" /* 2546 */
	"SQ_IMG_SAMP_WORD2\0" /* 2564 */
	"SQ_IMG_SAMP_WORD3\0" /* 2582 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 2600, 2617 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 2620 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 2645 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 2670 */
	"SPI_PS_MAX_WAVE_ID\0" /* 2695, 2702 */
	"SPI_ARB_PRIORITY\0" /* 2714, 2722 */
	"SPI_ARB_CYCLES_0\0" /* 2731 */
	"SPI_ARB_CYCLES_1\0" /* 2748 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 2765 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 2787 */
	"DB_ZPASS_COUNT_LOW\0" /* 2809 */
	"DB_ZPASS_COUNT_HI\0" /* 2828, 2837 */
	"GDS_OA_CNTL\0" /* 2846 */
	"GDS_OA_COUNTER\0" /* 2858 */
	"GDS_OA_ADDRESS\0" /* 2873, 2880 */
	"GDS_OA_INCDEC\0" /* 2888, 2895 */
	"GDS_OA_RING_SIZE\0" /* 2902 */
	"SPI_CONFIG_CNTL\0" /* 2919 */
	"SPI_CONFIG_CNTL_1\0" /* 2935 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 2953 */
	"DB_SUBTILE_CONTROL\0" /* 2982 */
	"GB_ADDR_CONFIG\0" /* 3001 */
	"GB_TILE_MODE0\0" /* 3016 */
	"GB_TILE_MODE1\0" /* 3030 */
	"GB_TILE_MODE2\0" /* 3044 */
	"GB_TILE_MODE3\0" /* 3058 */
	"GB_TILE_MODE4\0" /* 3072 */
	"GB_TILE_MODE5\0" /* 3086 */
	"GB_TILE_MODE6\0" /* 3100 */
	"GB_TILE_MODE7\0" /* 3114 */
	"GB_TILE_MODE8\0" /* 3128 */
	"GB_TILE_MODE9\0" /* 3142 */
	"GB_TILE_MODE10\0" /* 3156 */
	"GB_TILE_MODE11\0" /* 3171 */
	"GB_TILE_MODE12\0" /* 3186 */
	"GB_TILE_MODE13\0" /* 3201 */
	"GB_TILE_MODE14\0" /* 3216 */
	"GB_TILE_MODE15\0" /* 3231 */
	"GB_TILE_MODE16\0" /* 3246 */
	"GB_TILE_MODE17\0" /* 3261 */
	"GB_TILE_MODE18\0" /* 3276 */
	"GB_TILE_MODE19\0" /* 3291 */
	"GB_TILE_MODE20\0" /* 3306 */
	"GB_TILE_MODE21\0" /* 3321 */
	"GB_TILE_MODE22\0" /* 3336 */
	"GB_TILE_MODE23\0" /* 3351 */
	"GB_TILE_MODE24\0" /* 3366 */
	"GB_TILE_MODE25\0" /* 3381 */
	"GB_TILE_MODE26\0" /* 3396 */
	"GB_TILE_MODE27\0" /* 3411 */
	"GB_TILE_MODE28\0" /* 3426 */
	"GB_TILE_MODE29\0" /* 3441 */
	"GB_TILE_MODE30\0" /* 3456 */
	"GB_TILE_MODE31\0" /* 3471 */
	"GB_MACROTILE_MODE0\0" /* 3486 */
	"GB_MACROTILE_MODE1\0" /* 3505 */
	"GB_MACROTILE_MODE2\0" /* 3524 */
	"GB_MACROTILE_MODE3\0" /* 3543 */
	"GB_MACROTILE_MODE4\0" /* 3562 */
	"GB_MACROTILE_MODE5\0" /* 3581 */
	"GB_MACROTILE_MODE6\0" /* 3600 */
	"GB_MACROTILE_MODE7\0" /* 3619 */
	"GB_MACROTILE_MODE8\0" /* 3638 */
	"GB_MACROTILE_MODE9\0" /* 3657 */
	"GB_MACROTILE_MODE10\0" /* 3676 */
	"GB_MACROTILE_MODE11\0" /* 3696 */
	"GB_MACROTILE_MODE12\0" /* 3716 */
	"GB_MACROTILE_MODE13\0" /* 3736 */
	"GB_MACROTILE_MODE14\0" /* 3756 */
	"GB_MACROTILE_MODE15\0" /* 3776 */
	"SPI_SHADER_TBA_LO_PS\0" /* 3796 */
	"SPI_SHADER_TBA_HI_PS\0" /* 3817 */
	"SPI_SHADER_TMA_LO_PS\0" /* 3838 */
	"SPI_SHADER_TMA_HI_PS\0" /* 3859 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 3880 */
	"SPI_SHADER_PGM_LO_PS\0" /* 3904 */
	"SPI_SHADER_PGM_HI_PS\0" /* 3925 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 3946 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 3970 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 3994 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 4020 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 4046 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 4072 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 4098 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 4124 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 4150 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 4176 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 4202 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 4228 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 4254 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 4281 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 4308 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 4335 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 4362 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 4389 */
	"SPI_SHADER_TBA_LO_VS\0" /* 4416 */
	"SPI_SHADER_TBA_HI_VS\0" /* 4437 */
	"SPI_SHADER_TMA_LO_VS\0" /* 4458 */
	"SPI_SHADER_TMA_HI_VS\0" /* 4479 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 4500 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 4524 */
	"SPI_SHADER_PGM_LO_VS\0" /* 4549 */
	"SPI_SHADER_PGM_HI_VS\0" /* 4570 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 4591 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 4615 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 4639 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 4665 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 4691 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 4717 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 4743 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 4769 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 4795 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 4821 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 4847 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 4873 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 4899 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 4926 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 4953 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 4980 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 5007 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 5034 */
	"SPI_SHADER_TBA_LO_GS\0" /* 5061 */
	"SPI_SHADER_TBA_HI_GS\0" /* 5082 */
	"SPI_SHADER_TMA_LO_GS\0" /* 5103 */
	"SPI_SHADER_TMA_HI_GS\0" /* 5124 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 5145 */
	"SPI_SHADER_PGM_LO_GS\0" /* 5169 */
	"SPI_SHADER_PGM_HI_GS\0" /* 5190 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 5211 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 5235 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 5259 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 5285 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 5311 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 5337 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 5363 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 5389 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 5415 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 5441 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 5467 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 5493 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 5519 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 5546 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 5573 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 5600 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 5627 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 5654 */
	"SPI_SHADER_TBA_LO_ES\0" /* 5681 */
	"SPI_SHADER_TBA_HI_ES\0" /* 5702 */
	"SPI_SHADER_TMA_LO_ES\0" /* 5723 */
	"SPI_SHADER_TMA_HI_ES\0" /* 5744 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 5765 */
	"SPI_SHADER_PGM_LO_ES\0" /* 5789 */
	"SPI_SHADER_PGM_HI_ES\0" /* 5810 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 5831 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 5855 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 5879 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 5905 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 5931 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 5957 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 5983 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 6009 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 6035 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 6061 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 6087 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 6113 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 6139 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 6166 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 6193 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 6220 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 6247 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 6274 */
	"SPI_SHADER_TBA_LO_HS\0" /* 6301 */
	"SPI_SHADER_TBA_HI_HS\0" /* 6322 */
	"SPI_SHADER_TMA_LO_HS\0" /* 6343 */
	"SPI_SHADER_TMA_HI_HS\0" /* 6364 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 6385 */
	"SPI_SHADER_PGM_LO_HS\0" /* 6409 */
	"SPI_SHADER_PGM_HI_HS\0" /* 6430 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 6451 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 6475 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 6499 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 6525 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 6551 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 6577 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 6603 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 6629 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 6655 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 6681 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 6707 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 6733 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 6759 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 6786 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 6813 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 6840 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 6867 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 6894 */
	"SPI_SHADER_TBA_LO_LS\0" /* 6921 */
	"SPI_SHADER_TBA_HI_LS\0" /* 6942 */
	"SPI_SHADER_TMA_LO_LS\0" /* 6963 */
	"SPI_SHADER_TMA_HI_LS\0" /* 6984 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 7005 */
	"SPI_SHADER_PGM_LO_LS\0" /* 7029 */
	"SPI_SHADER_PGM_HI_LS\0" /* 7050 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 7071 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 7095 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 7119 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 7145 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 7171 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 7197 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 7223 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 7249 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 7275 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 7301 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 7327 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 7353 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 7379 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 7406 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 7433 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 7460 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 7487 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 7514 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 7541 */
	"COMPUTE_DIM_X\0" /* 7568 */
	"COMPUTE_DIM_Y\0" /* 7582 */
	"COMPUTE_DIM_Z\0" /* 7596 */
	"COMPUTE_START_X\0" /* 7610, 7618 */
	"COMPUTE_START_Y\0" /* 7626, 7634 */
	"COMPUTE_START_Z\0" /* 7642 */
	"COMPUTE_NUM_THREAD_X\0" /* 7658 */
	"COMPUTE_NUM_THREAD_Y\0" /* 7679 */
	"COMPUTE_NUM_THREAD_Z\0" /* 7700 */
	"COMPUTE_MAX_WAVE_ID\0" /* 7721 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 7741, 7749, 7762 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 7769, 7777 */
	"COMPUTE_PGM_LO\0" /* 7794 */
	"COMPUTE_PGM_HI\0" /* 7809 */
	"COMPUTE_TBA_LO\0" /* 7824 */
	"COMPUTE_TBA_HI\0" /* 7839 */
	"COMPUTE_TMA_LO\0" /* 7854 */
	"COMPUTE_TMA_HI\0" /* 7869 */
	"COMPUTE_PGM_RSRC1\0" /* 7884 */
	"COMPUTE_PGM_RSRC2\0" /* 7902 */
	"COMPUTE_VMID\0" /* 7920 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 7933 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 7957 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 7988 */
	"COMPUTE_TMPRING_SIZE\0" /* 8019 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 8040 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 8071 */
	"COMPUTE_RESTART_X\0" /* 8102 */
	"COMPUTE_RESTART_Y\0" /* 8120 */
	"COMPUTE_RESTART_Z\0" /* 8138 */
	"COMPUTE_MISC_RESERVED\0" /* 8156, 8169 */
	"COMPUTE_DISPATCH_ID\0" /* 8178 */
	"COMPUTE_THREADGROUP_ID\0" /* 8198 */
	"COMPUTE_RELAUNCH\0" /* 8221 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 8238 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 8267 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 8296 */
	"COMPUTE_USER_DATA_0\0" /* 8325 */
	"COMPUTE_USER_DATA_1\0" /* 8345 */
	"COMPUTE_USER_DATA_2\0" /* 8365 */
	"COMPUTE_USER_DATA_3\0" /* 8385 */
	"COMPUTE_USER_DATA_4\0" /* 8405 */
	"COMPUTE_USER_DATA_5\0" /* 8425 */
	"COMPUTE_USER_DATA_6\0" /* 8445 */
	"COMPUTE_USER_DATA_7\0" /* 8465 */
	"COMPUTE_USER_DATA_8\0" /* 8485 */
	"COMPUTE_USER_DATA_9\0" /* 8505 */
	"COMPUTE_USER_DATA_10\0" /* 8525 */
	"COMPUTE_USER_DATA_11\0" /* 8546 */
	"COMPUTE_USER_DATA_12\0" /* 8567 */
	"COMPUTE_USER_DATA_13\0" /* 8588 */
	"COMPUTE_USER_DATA_14\0" /* 8609 */
	"COMPUTE_USER_DATA_15\0" /* 8630 */
	"COMPUTE_NOWHERE\0" /* 8651, 8659 */
	"CPG_PERFCOUNTER1_LO\0" /* 8667 */
	"CPG_PERFCOUNTER1_HI\0" /* 8687 */
	"CPG_PERFCOUNTER0_LO\0" /* 8707 */
	"CPG_PERFCOUNTER0_HI\0" /* 8727 */
	"CPC_PERFCOUNTER1_LO\0" /* 8747 */
	"CPC_PERFCOUNTER1_HI\0" /* 8767 */
	"CPC_PERFCOUNTER0_LO\0" /* 8787 */
	"CPC_PERFCOUNTER0_HI\0" /* 8807 */
	"CPF_PERFCOUNTER1_LO\0" /* 8827 */
	"CPF_PERFCOUNTER1_HI\0" /* 8847 */
	"CPF_PERFCOUNTER0_LO\0" /* 8867 */
	"CPF_PERFCOUNTER0_HI\0" /* 8887 */
	"GRBM_PERFCOUNTER0_LO\0" /* 8907 */
	"GRBM_PERFCOUNTER0_HI\0" /* 8928 */
	"GRBM_PERFCOUNTER1_LO\0" /* 8949 */
	"GRBM_PERFCOUNTER1_HI\0" /* 8970 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 8991 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 9015, 9024 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 9039 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 9063 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 9087 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 9111 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 9135 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 9159 */
	"WD_PERFCOUNTER0_LO\0" /* 9183 */
	"WD_PERFCOUNTER0_HI\0" /* 9202 */
	"WD_PERFCOUNTER1_LO\0" /* 9221 */
	"WD_PERFCOUNTER1_HI\0" /* 9240 */
	"WD_PERFCOUNTER2_LO\0" /* 9259 */
	"WD_PERFCOUNTER2_HI\0" /* 9278 */
	"WD_PERFCOUNTER3_LO\0" /* 9297 */
	"WD_PERFCOUNTER3_HI\0" /* 9316 */
	"IA_PERFCOUNTER0_LO\0" /* 9335 */
	"IA_PERFCOUNTER0_HI\0" /* 9354 */
	"IA_PERFCOUNTER1_LO\0" /* 9373 */
	"IA_PERFCOUNTER1_HI\0" /* 9392 */
	"IA_PERFCOUNTER2_LO\0" /* 9411 */
	"IA_PERFCOUNTER2_HI\0" /* 9430 */
	"IA_PERFCOUNTER3_LO\0" /* 9449 */
	"IA_PERFCOUNTER3_HI\0" /* 9468 */
	"VGT_PERFCOUNTER0_LO\0" /* 9487 */
	"VGT_PERFCOUNTER0_HI\0" /* 9507 */
	"VGT_PERFCOUNTER1_LO\0" /* 9527 */
	"VGT_PERFCOUNTER1_HI\0" /* 9547 */
	"VGT_PERFCOUNTER2_LO\0" /* 9567 */
	"VGT_PERFCOUNTER2_HI\0" /* 9587 */
	"VGT_PERFCOUNTER3_LO\0" /* 9607 */
	"VGT_PERFCOUNTER3_HI\0" /* 9627 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 9647 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 9669 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 9691 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 9713 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 9735 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 9757 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 9779 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 9801 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 9823 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 9845 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 9867 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 9889 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 9911 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 9933 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 9955 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 9977 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 9999 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 10021 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 10043 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 10065 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 10087 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 10109 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 10131 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 10153 */
	"SPI_PERFCOUNTER0_HI\0" /* 10175 */
	"SPI_PERFCOUNTER0_LO\0" /* 10195 */
	"SPI_PERFCOUNTER1_HI\0" /* 10215 */
	"SPI_PERFCOUNTER1_LO\0" /* 10235 */
	"SPI_PERFCOUNTER2_HI\0" /* 10255 */
	"SPI_PERFCOUNTER2_LO\0" /* 10275 */
	"SPI_PERFCOUNTER3_HI\0" /* 10295 */
	"SPI_PERFCOUNTER3_LO\0" /* 10315 */
	"SPI_PERFCOUNTER4_HI\0" /* 10335 */
	"SPI_PERFCOUNTER4_LO\0" /* 10355 */
	"SPI_PERFCOUNTER5_HI\0" /* 10375 */
	"SPI_PERFCOUNTER5_LO\0" /* 10395 */
	"SQ_PERFCOUNTER0_LO\0" /* 10415 */
	"SQ_PERFCOUNTER0_HI\0" /* 10434 */
	"SQ_PERFCOUNTER1_LO\0" /* 10453 */
	"SQ_PERFCOUNTER1_HI\0" /* 10472 */
	"SQ_PERFCOUNTER2_LO\0" /* 10491 */
	"SQ_PERFCOUNTER2_HI\0" /* 10510 */
	"SQ_PERFCOUNTER3_LO\0" /* 10529 */
	"SQ_PERFCOUNTER3_HI\0" /* 10548 */
	"SQ_PERFCOUNTER4_LO\0" /* 10567 */
	"SQ_PERFCOUNTER4_HI\0" /* 10586 */
	"SQ_PERFCOUNTER5_LO\0" /* 10605 */
	"SQ_PERFCOUNTER5_HI\0" /* 10624 */
	"SQ_PERFCOUNTER6_LO\0" /* 10643 */
	"SQ_PERFCOUNTER6_HI\0" /* 10662 */
	"SQ_PERFCOUNTER7_LO\0" /* 10681 */
	"SQ_PERFCOUNTER7_HI\0" /* 10700 */
	"SQ_PERFCOUNTER8_LO\0" /* 10719 */
	"SQ_PERFCOUNTER8_HI\0" /* 10738 */
	"SQ_PERFCOUNTER9_LO\0" /* 10757 */
	"SQ_PERFCOUNTER9_HI\0" /* 10776 */
	"SQ_PERFCOUNTER10_LO\0" /* 10795 */
	"SQ_PERFCOUNTER10_HI\0" /* 10815 */
	"SQ_PERFCOUNTER11_LO\0" /* 10835 */
	"SQ_PERFCOUNTER11_HI\0" /* 10855 */
	"SQ_PERFCOUNTER12_LO\0" /* 10875 */
	"SQ_PERFCOUNTER12_HI\0" /* 10895 */
	"SQ_PERFCOUNTER13_LO\0" /* 10915 */
	"SQ_PERFCOUNTER13_HI\0" /* 10935 */
	"SQ_PERFCOUNTER14_LO\0" /* 10955 */
	"SQ_PERFCOUNTER14_HI\0" /* 10975 */
	"SQ_PERFCOUNTER15_LO\0" /* 10995 */
	"SQ_PERFCOUNTER15_HI\0" /* 11015 */
	"SX_PERFCOUNTER0_LO\0" /* 11035 */
	"SX_PERFCOUNTER0_HI\0" /* 11054 */
	"SX_PERFCOUNTER1_LO\0" /* 11073 */
	"SX_PERFCOUNTER1_HI\0" /* 11092 */
	"SX_PERFCOUNTER2_LO\0" /* 11111 */
	"SX_PERFCOUNTER2_HI\0" /* 11130 */
	"SX_PERFCOUNTER3_LO\0" /* 11149 */
	"SX_PERFCOUNTER3_HI\0" /* 11168 */
	"GDS_PERFCOUNTER0_LO\0" /* 11187 */
	"GDS_PERFCOUNTER0_HI\0" /* 11207 */
	"GDS_PERFCOUNTER1_LO\0" /* 11227 */
	"GDS_PERFCOUNTER1_HI\0" /* 11247 */
	"GDS_PERFCOUNTER2_LO\0" /* 11267 */
	"GDS_PERFCOUNTER2_HI\0" /* 11287 */
	"GDS_PERFCOUNTER3_LO\0" /* 11307 */
	"GDS_PERFCOUNTER3_HI\0" /* 11327 */
	"TA_PERFCOUNTER0_LO\0" /* 11347 */
	"TA_PERFCOUNTER0_HI\0" /* 11366 */
	"TA_PERFCOUNTER1_LO\0" /* 11385 */
	"TA_PERFCOUNTER1_HI\0" /* 11404 */
	"TD_PERFCOUNTER0_LO\0" /* 11423 */
	"TD_PERFCOUNTER0_HI\0" /* 11442 */
	"TD_PERFCOUNTER1_LO\0" /* 11461 */
	"TD_PERFCOUNTER1_HI\0" /* 11480 */
	"TCP_PERFCOUNTER0_LO\0" /* 11499 */
	"TCP_PERFCOUNTER0_HI\0" /* 11519 */
	"TCP_PERFCOUNTER1_LO\0" /* 11539 */
	"TCP_PERFCOUNTER1_HI\0" /* 11559 */
	"TCP_PERFCOUNTER2_LO\0" /* 11579 */
	"TCP_PERFCOUNTER2_HI\0" /* 11599 */
	"TCP_PERFCOUNTER3_LO\0" /* 11619 */
	"TCP_PERFCOUNTER3_HI\0" /* 11639 */
	"TCC_PERFCOUNTER0_LO\0" /* 11659 */
	"TCC_PERFCOUNTER0_HI\0" /* 11679 */
	"TCC_PERFCOUNTER1_LO\0" /* 11699 */
	"TCC_PERFCOUNTER1_HI\0" /* 11719 */
	"TCC_PERFCOUNTER2_LO\0" /* 11739 */
	"TCC_PERFCOUNTER2_HI\0" /* 11759 */
	"TCC_PERFCOUNTER3_LO\0" /* 11779 */
	"TCC_PERFCOUNTER3_HI\0" /* 11799 */
	"TCA_PERFCOUNTER0_LO\0" /* 11819 */
	"TCA_PERFCOUNTER0_HI\0" /* 11839 */
	"TCA_PERFCOUNTER1_LO\0" /* 11859 */
	"TCA_PERFCOUNTER1_HI\0" /* 11879 */
	"TCA_PERFCOUNTER2_LO\0" /* 11899 */
	"TCA_PERFCOUNTER2_HI\0" /* 11919 */
	"TCA_PERFCOUNTER3_LO\0" /* 11939 */
	"TCA_PERFCOUNTER3_HI\0" /* 11959 */
	"CB_PERFCOUNTER0_LO\0" /* 11979 */
	"CB_PERFCOUNTER0_HI\0" /* 11998 */
	"CB_PERFCOUNTER1_LO\0" /* 12017 */
	"CB_PERFCOUNTER1_HI\0" /* 12036 */
	"CB_PERFCOUNTER2_LO\0" /* 12055 */
	"CB_PERFCOUNTER2_HI\0" /* 12074 */
	"CB_PERFCOUNTER3_LO\0" /* 12093 */
	"CB_PERFCOUNTER3_HI\0" /* 12112 */
	"DB_PERFCOUNTER0_LO\0" /* 12131 */
	"DB_PERFCOUNTER0_HI\0" /* 12150 */
	"DB_PERFCOUNTER1_LO\0" /* 12169 */
	"DB_PERFCOUNTER1_HI\0" /* 12188 */
	"DB_PERFCOUNTER2_LO\0" /* 12207 */
	"DB_PERFCOUNTER2_HI\0" /* 12226 */
	"DB_PERFCOUNTER3_LO\0" /* 12245 */
	"DB_PERFCOUNTER3_HI\0" /* 12264 */
	"RLC_PERFCOUNTER0_LO\0" /* 12283 */
	"RLC_PERFCOUNTER0_HI\0" /* 12303 */
	"RLC_PERFCOUNTER1_LO\0" /* 12323 */
	"RLC_PERFCOUNTER1_HI\0" /* 12343 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 12363 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 12387 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 12412 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 12436 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 12460 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 12485 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 12509 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 12534 */
	"CP_PERFMON_CNTL\0" /* 12558 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 12574 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 12598 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 12623 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 12648, 12657 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 12676 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 12704 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 12732 */
	"WD_PERFCOUNTER0_SELECT\0" /* 12760 */
	"WD_PERFCOUNTER1_SELECT\0" /* 12783 */
	"WD_PERFCOUNTER2_SELECT\0" /* 12806 */
	"WD_PERFCOUNTER3_SELECT\0" /* 12829 */
	"IA_PERFCOUNTER0_SELECT\0" /* 12852 */
	"IA_PERFCOUNTER1_SELECT\0" /* 12875 */
	"IA_PERFCOUNTER2_SELECT\0" /* 12898 */
	"IA_PERFCOUNTER3_SELECT\0" /* 12921 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 12944 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 12968 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 12992 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 13016 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 13040 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 13064 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 13089 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 13114 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 13140 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 13166 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 13193 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 13219 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 13246 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 13272 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 13298 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 13324 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 13351 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 13377 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 13403 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 13429 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 13455 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 13481 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 13507 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 13533 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 13557 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 13581 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 13605 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 13629 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 13654 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 13679 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 13704 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 13729 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 13753 */
	"SPI_PERFCOUNTER_BINS\0" /* 13777 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 13798 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 13821 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 13844 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 13867 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 13890 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 13913 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 13936 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 13959 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 13982 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 14005 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 14028 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 14052 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 14076 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 14100 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 14124 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 14148 */
	"SQ_PERFCOUNTER_CTRL\0" /* 14172 */
	"SQ_PERFCOUNTER_MASK\0" /* 14192 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 14212 */
	"SX_PERFCOUNTER0_SELECT\0" /* 14233 */
	"SX_PERFCOUNTER1_SELECT\0" /* 14256 */
	"SX_PERFCOUNTER2_SELECT\0" /* 14279 */
	"SX_PERFCOUNTER3_SELECT\0" /* 14302 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 14325 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 14349 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 14373 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 14397 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 14421 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 14445 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 14469 */
	"TA_PERFCOUNTER0_SELECT\0" /* 14494 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 14517 */
	"TA_PERFCOUNTER1_SELECT\0" /* 14541 */
	"TD_PERFCOUNTER0_SELECT\0" /* 14564 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 14587 */
	"TD_PERFCOUNTER1_SELECT\0" /* 14611 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 14634 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 14658 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 14683 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 14707 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 14732 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 14756 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 14780 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 14804 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 14829 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 14853 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 14878 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 14902 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 14926 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 14950 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 14975 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 14999 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 15024 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 15048 */
	"CB_PERFCOUNTER_FILTER\0" /* 15072 */
	"CB_PERFCOUNTER0_SELECT\0" /* 15094 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 15117 */
	"CB_PERFCOUNTER1_SELECT\0" /* 15141 */
	"CB_PERFCOUNTER2_SELECT\0" /* 15164 */
	"CB_PERFCOUNTER3_SELECT\0" /* 15187 */
	"DB_PERFCOUNTER0_SELECT\0" /* 15210 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 15233 */
	"DB_PERFCOUNTER1_SELECT\0" /* 15257 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 15280 */
	"DB_PERFCOUNTER2_SELECT\0" /* 15304 */
	"DB_PERFCOUNTER3_SELECT\0" /* 15327 */
	"DB_RENDER_CONTROL\0" /* 15350 */
	"DB_COUNT_CONTROL\0" /* 15368 */
	"DB_DEPTH_VIEW\0" /* 15385 */
	"DB_RENDER_OVERRIDE\0" /* 15399, 15415 */
	"DB_RENDER_OVERRIDE2\0" /* 15418 */
	"DB_HTILE_DATA_BASE\0" /* 15438 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 15457 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 15477 */
	"DB_STENCIL_CLEAR\0" /* 15497, 15508 */
	"DB_DEPTH_CLEAR\0" /* 15514 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 15529 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 15553 */
	"DB_DEPTH_INFO\0" /* 15577 */
	"DB_Z_INFO\0" /* 15591 */
	"DB_STENCIL_INFO\0" /* 15601 */
	"DB_Z_READ_BASE\0" /* 15617 */
	"DB_STENCIL_READ_BASE\0" /* 15632 */
	"DB_Z_WRITE_BASE\0" /* 15653 */
	"DB_STENCIL_WRITE_BASE\0" /* 15669 */
	"DB_DEPTH_SIZE\0" /* 15691 */
	"DB_DEPTH_SLICE\0" /* 15705 */
	"TA_BC_BASE_ADDR\0" /* 15720 */
	"TA_BC_BASE_ADDR_HI\0" /* 15736 */
	"COHER_DEST_BASE_HI_0\0" /* 15755 */
	"COHER_DEST_BASE_HI_1\0" /* 15776 */
	"COHER_DEST_BASE_HI_2\0" /* 15797 */
	"COHER_DEST_BASE_HI_3\0" /* 15818 */
	"COHER_DEST_BASE_2\0" /* 15839 */
	"COHER_DEST_BASE_3\0" /* 15857 */
	"PA_SC_WINDOW_OFFSET\0" /* 15875, 15886 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 15895 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 15919 */
	"PA_SC_CLIPRECT_RULE\0" /* 15943 */
	"PA_SC_CLIPRECT_0_TL\0" /* 15963 */
	"PA_SC_CLIPRECT_0_BR\0" /* 15983 */
	"PA_SC_CLIPRECT_1_TL\0" /* 16003 */
	"PA_SC_CLIPRECT_1_BR\0" /* 16023 */
	"PA_SC_CLIPRECT_2_TL\0" /* 16043 */
	"PA_SC_CLIPRECT_2_BR\0" /* 16063 */
	"PA_SC_CLIPRECT_3_TL\0" /* 16083 */
	"PA_SC_CLIPRECT_3_BR\0" /* 16103 */
	"PA_SC_EDGERULE\0" /* 16123 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 16138 */
	"CB_TARGET_MASK\0" /* 16167 */
	"CB_SHADER_MASK\0" /* 16182 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 16197 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 16222 */
	"COHER_DEST_BASE_0\0" /* 16247 */
	"COHER_DEST_BASE_1\0" /* 16265 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 16283 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 16308 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 16333 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 16358 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 16383 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 16408 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 16433 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 16458 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 16483 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 16508 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 16533 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 16558 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 16583 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 16608 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 16633 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 16658 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 16683 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 16708 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 16733 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 16758 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 16783 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 16809 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 16835 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 16861 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 16887 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 16913 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 16939 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 16965 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 16991 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 17017 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 17043 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 17069 */
	"PA_SC_VPORT_ZMIN_0\0" /* 17095 */
	"PA_SC_VPORT_ZMAX_0\0" /* 17114 */
	"PA_SC_VPORT_ZMIN_1\0" /* 17133 */
	"PA_SC_VPORT_ZMAX_1\0" /* 17152 */
	"PA_SC_VPORT_ZMIN_2\0" /* 17171, 17185 */
	"PA_SC_VPORT_ZMAX_2\0" /* 17190 */
	"PA_SC_VPORT_ZMIN_3\0" /* 17209, 17223 */
	"PA_SC_VPORT_ZMAX_3\0" /* 17228 */
	"PA_SC_VPORT_ZMIN_4\0" /* 17247 */
	"PA_SC_VPORT_ZMAX_4\0" /* 17266 */
	"PA_SC_VPORT_ZMIN_5\0" /* 17285 */
	"PA_SC_VPORT_ZMAX_5\0" /* 17304 */
	"PA_SC_VPORT_ZMIN_6\0" /* 17323 */
	"PA_SC_VPORT_ZMAX_6\0" /* 17342 */
	"PA_SC_VPORT_ZMIN_7\0" /* 17361 */
	"PA_SC_VPORT_ZMAX_7\0" /* 17380 */
	"PA_SC_VPORT_ZMIN_8\0" /* 17399 */
	"PA_SC_VPORT_ZMAX_8\0" /* 17418 */
	"PA_SC_VPORT_ZMIN_9\0" /* 17437 */
	"PA_SC_VPORT_ZMAX_9\0" /* 17456 */
	"PA_SC_VPORT_ZMIN_10\0" /* 17475, 17489 */
	"PA_SC_VPORT_ZMAX_10\0" /* 17495 */
	"PA_SC_VPORT_ZMIN_11\0" /* 17515 */
	"PA_SC_VPORT_ZMAX_11\0" /* 17535 */
	"PA_SC_VPORT_ZMIN_12\0" /* 17555 */
	"PA_SC_VPORT_ZMAX_12\0" /* 17575 */
	"PA_SC_VPORT_ZMIN_13\0" /* 17595 */
	"PA_SC_VPORT_ZMAX_13\0" /* 17615 */
	"PA_SC_VPORT_ZMIN_14\0" /* 17635 */
	"PA_SC_VPORT_ZMAX_14\0" /* 17655 */
	"PA_SC_VPORT_ZMIN_15\0" /* 17675 */
	"PA_SC_VPORT_ZMAX_15\0" /* 17695 */
	"PA_SC_RASTER_CONFIG\0" /* 17715 */
	"PA_SC_RASTER_CONFIG_1\0" /* 17735 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 17757 */
	"VGT_MAX_VTX_INDX\0" /* 17785 */
	"VGT_MIN_VTX_INDX\0" /* 17802 */
	"VGT_INDX_OFFSET\0" /* 17819, 17826 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 17835 */
	"CB_BLEND_RED\0" /* 17864 */
	"CB_BLEND_GREEN\0" /* 17877 */
	"CB_BLEND_BLUE\0" /* 17892 */
	"CB_BLEND_ALPHA\0" /* 17906 */
	"CB_DCC_CONTROL\0" /* 17921 */
	"DB_STENCIL_CONTROL\0" /* 17936 */
	"DB_STENCILREFMASK\0" /* 17955 */
	"DB_STENCILREFMASK_BF\0" /* 17973 */
	"PA_CL_VPORT_XSCALE\0" /* 17994 */
	"PA_CL_VPORT_XOFFSET\0" /* 18013 */
	"PA_CL_VPORT_YSCALE\0" /* 18033 */
	"PA_CL_VPORT_YOFFSET\0" /* 18052 */
	"PA_CL_VPORT_ZSCALE\0" /* 18072 */
	"PA_CL_VPORT_ZOFFSET\0" /* 18091 */
	"PA_CL_VPORT_XSCALE_1\0" /* 18111 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 18132 */
	"PA_CL_VPORT_YSCALE_1\0" /* 18154 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 18175 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 18197 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 18218 */
	"PA_CL_VPORT_XSCALE_2\0" /* 18240 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 18261 */
	"PA_CL_VPORT_YSCALE_2\0" /* 18283 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 18304 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 18326 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 18347 */
	"PA_CL_VPORT_XSCALE_3\0" /* 18369 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 18390 */
	"PA_CL_VPORT_YSCALE_3\0" /* 18412 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 18433 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 18455 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 18476 */
	"PA_CL_VPORT_XSCALE_4\0" /* 18498 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 18519 */
	"PA_CL_VPORT_YSCALE_4\0" /* 18541 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 18562 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 18584 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 18605 */
	"PA_CL_VPORT_XSCALE_5\0" /* 18627 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 18648 */
	"PA_CL_VPORT_YSCALE_5\0" /* 18670 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 18691 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 18713 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 18734 */
	"PA_CL_VPORT_XSCALE_6\0" /* 18756 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 18777 */
	"PA_CL_VPORT_YSCALE_6\0" /* 18799 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 18820 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 18842 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 18863 */
	"PA_CL_VPORT_XSCALE_7\0" /* 18885 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 18906 */
	"PA_CL_VPORT_YSCALE_7\0" /* 18928 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 18949 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 18971 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 18992 */
	"PA_CL_VPORT_XSCALE_8\0" /* 19014 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 19035 */
	"PA_CL_VPORT_YSCALE_8\0" /* 19057 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 19078 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 19100 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 19121 */
	"PA_CL_VPORT_XSCALE_9\0" /* 19143 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 19164 */
	"PA_CL_VPORT_YSCALE_9\0" /* 19186 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 19207 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 19229 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 19250 */
	"PA_CL_VPORT_XSCALE_10\0" /* 19272 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 19294 */
	"PA_CL_VPORT_YSCALE_10\0" /* 19317 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 19339 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 19362 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 19384 */
	"PA_CL_VPORT_XSCALE_11\0" /* 19407 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 19429 */
	"PA_CL_VPORT_YSCALE_11\0" /* 19452 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 19474 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 19497 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 19519 */
	"PA_CL_VPORT_XSCALE_12\0" /* 19542 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 19564 */
	"PA_CL_VPORT_YSCALE_12\0" /* 19587 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 19609 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 19632 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 19654 */
	"PA_CL_VPORT_XSCALE_13\0" /* 19677 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 19699 */
	"PA_CL_VPORT_YSCALE_13\0" /* 19722 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 19744 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 19767 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 19789 */
	"PA_CL_VPORT_XSCALE_14\0" /* 19812 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 19834 */
	"PA_CL_VPORT_YSCALE_14\0" /* 19857 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 19879 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 19902 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 19924 */
	"PA_CL_VPORT_XSCALE_15\0" /* 19947 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 19969 */
	"PA_CL_VPORT_YSCALE_15\0" /* 19992 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 20014 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 20037 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 20059 */
	"PA_CL_UCP_0_X\0" /* 20082 */
	"PA_CL_UCP_0_Y\0" /* 20096 */
	"PA_CL_UCP_0_Z\0" /* 20110 */
	"PA_CL_UCP_0_W\0" /* 20124 */
	"PA_CL_UCP_1_X\0" /* 20138 */
	"PA_CL_UCP_1_Y\0" /* 20152 */
	"PA_CL_UCP_1_Z\0" /* 20166 */
	"PA_CL_UCP_1_W\0" /* 20180 */
	"PA_CL_UCP_2_X\0" /* 20194 */
	"PA_CL_UCP_2_Y\0" /* 20208 */
	"PA_CL_UCP_2_Z\0" /* 20222 */
	"PA_CL_UCP_2_W\0" /* 20236 */
	"PA_CL_UCP_3_X\0" /* 20250 */
	"PA_CL_UCP_3_Y\0" /* 20264 */
	"PA_CL_UCP_3_Z\0" /* 20278 */
	"PA_CL_UCP_3_W\0" /* 20292 */
	"PA_CL_UCP_4_X\0" /* 20306 */
	"PA_CL_UCP_4_Y\0" /* 20320 */
	"PA_CL_UCP_4_Z\0" /* 20334 */
	"PA_CL_UCP_4_W\0" /* 20348 */
	"PA_CL_UCP_5_X\0" /* 20362 */
	"PA_CL_UCP_5_Y\0" /* 20376 */
	"PA_CL_UCP_5_Z\0" /* 20390 */
	"PA_CL_UCP_5_W\0" /* 20404 */
	"SPI_PS_INPUT_CNTL_0\0" /* 20418 */
	"SPI_PS_INPUT_CNTL_1\0" /* 20438 */
	"SPI_PS_INPUT_CNTL_2\0" /* 20458 */
	"SPI_PS_INPUT_CNTL_3\0" /* 20478 */
	"SPI_PS_INPUT_CNTL_4\0" /* 20498 */
	"SPI_PS_INPUT_CNTL_5\0" /* 20518 */
	"SPI_PS_INPUT_CNTL_6\0" /* 20538 */
	"SPI_PS_INPUT_CNTL_7\0" /* 20558 */
	"SPI_PS_INPUT_CNTL_8\0" /* 20578 */
	"SPI_PS_INPUT_CNTL_9\0" /* 20598 */
	"SPI_PS_INPUT_CNTL_10\0" /* 20618 */
	"SPI_PS_INPUT_CNTL_11\0" /* 20639 */
	"SPI_PS_INPUT_CNTL_12\0" /* 20660 */
	"SPI_PS_INPUT_CNTL_13\0" /* 20681 */
	"SPI_PS_INPUT_CNTL_14\0" /* 20702 */
	"SPI_PS_INPUT_CNTL_15\0" /* 20723 */
	"SPI_PS_INPUT_CNTL_16\0" /* 20744 */
	"SPI_PS_INPUT_CNTL_17\0" /* 20765 */
	"SPI_PS_INPUT_CNTL_18\0" /* 20786 */
	"SPI_PS_INPUT_CNTL_19\0" /* 20807 */
	"SPI_PS_INPUT_CNTL_20\0" /* 20828 */
	"SPI_PS_INPUT_CNTL_21\0" /* 20849 */
	"SPI_PS_INPUT_CNTL_22\0" /* 20870 */
	"SPI_PS_INPUT_CNTL_23\0" /* 20891 */
	"SPI_PS_INPUT_CNTL_24\0" /* 20912 */
	"SPI_PS_INPUT_CNTL_25\0" /* 20933 */
	"SPI_PS_INPUT_CNTL_26\0" /* 20954 */
	"SPI_PS_INPUT_CNTL_27\0" /* 20975 */
	"SPI_PS_INPUT_CNTL_28\0" /* 20996 */
	"SPI_PS_INPUT_CNTL_29\0" /* 21017 */
	"SPI_PS_INPUT_CNTL_30\0" /* 21038 */
	"SPI_PS_INPUT_CNTL_31\0" /* 21059 */
	"SPI_VS_OUT_CONFIG\0" /* 21080 */
	"SPI_PS_INPUT_ENA\0" /* 21098 */
	"SPI_PS_INPUT_ADDR\0" /* 21115 */
	"SPI_INTERP_CONTROL_0\0" /* 21133 */
	"SPI_PS_IN_CONTROL\0" /* 21154 */
	"SPI_BARYC_CNTL\0" /* 21172 */
	"SPI_TMPRING_SIZE\0" /* 21187 */
	"SPI_WAVE_MGMT_1\0" /* 21204 */
	"SPI_WAVE_MGMT_2\0" /* 21220 */
	"SPI_SHADER_POS_FORMAT\0" /* 21236, 21251 */
	"SPI_SHADER_Z_FORMAT\0" /* 21258 */
	"SPI_SHADER_COL_FORMAT\0" /* 21278 */
	"SX_PS_DOWNCONVERT\0" /* 21300 */
	"SX_BLEND_OPT_EPSILON\0" /* 21318 */
	"SX_BLEND_OPT_CONTROL\0" /* 21339 */
	"SX_MRT0_BLEND_OPT\0" /* 21360 */
	"SX_MRT1_BLEND_OPT\0" /* 21378 */
	"SX_MRT2_BLEND_OPT\0" /* 21396 */
	"SX_MRT3_BLEND_OPT\0" /* 21414 */
	"SX_MRT4_BLEND_OPT\0" /* 21432 */
	"SX_MRT5_BLEND_OPT\0" /* 21450 */
	"SX_MRT6_BLEND_OPT\0" /* 21468 */
	"SX_MRT7_BLEND_OPT\0" /* 21486 */
	"CB_BLEND0_CONTROL\0" /* 21504 */
	"CB_BLEND1_CONTROL\0" /* 21522 */
	"CB_BLEND2_CONTROL\0" /* 21540 */
	"CB_BLEND3_CONTROL\0" /* 21558 */
	"CB_BLEND4_CONTROL\0" /* 21576 */
	"CB_BLEND5_CONTROL\0" /* 21594 */
	"CB_BLEND6_CONTROL\0" /* 21612 */
	"CB_BLEND7_CONTROL\0" /* 21630 */
	"CS_COPY_STATE\0" /* 21648 */
	"PA_CL_POINT_X_RAD\0" /* 21662 */
	"PA_CL_POINT_Y_RAD\0" /* 21680 */
	"PA_CL_POINT_SIZE\0" /* 21698 */
	"PA_CL_POINT_CULL_RAD\0" /* 21715 */
	"VGT_DMA_BASE_HI\0" /* 21736 */
	"VGT_DMA_BASE\0" /* 21752 */
	"VGT_DRAW_INITIATOR\0" /* 21765 */
	"VGT_IMMED_DATA\0" /* 21784 */
	"VGT_EVENT_ADDRESS_REG\0" /* 21799 */
	"DB_DEPTH_CONTROL\0" /* 21821 */
	"DB_EQAA\0" /* 21838 */
	"CB_COLOR_CONTROL\0" /* 21846 */
	"DB_SHADER_CONTROL\0" /* 21863 */
	"PA_CL_CLIP_CNTL\0" /* 21881 */
	"PA_SU_SC_MODE_CNTL\0" /* 21897 */
	"PA_CL_VTE_CNTL\0" /* 21916 */
	"PA_CL_VS_OUT_CNTL\0" /* 21931 */
	"PA_CL_NANINF_CNTL\0" /* 21949 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 21967 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 21991 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 22016 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 22039 */
	"PA_SU_POINT_SIZE\0" /* 22068 */
	"PA_SU_POINT_MINMAX\0" /* 22085 */
	"PA_SU_LINE_CNTL\0" /* 22104 */
	"PA_SC_LINE_STIPPLE\0" /* 22120 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 22139 */
	"VGT_HOS_CNTL\0" /* 22160 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 22173 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 22196 */
	"VGT_HOS_REUSE_DEPTH\0" /* 22219, 22227, 22233 */
	"VGT_GROUP_PRIM_TYPE\0" /* 22239, 22249 */
	"VGT_GROUP_FIRST_DECR\0" /* 22259, 22269, 22275 */
	"VGT_GROUP_DECR\0" /* 22280 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 22295 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 22317 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 22339 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 22365 */
	"VGT_GS_MODE\0" /* 22391, 22398 */
	"VGT_GS_ONCHIP_CNTL\0" /* 22403 */
	"PA_SC_MODE_CNTL_0\0" /* 22422 */
	"PA_SC_MODE_CNTL_1\0" /* 22440 */
	"VGT_ENHANCE\0" /* 22458 */
	"VGT_GS_PER_ES\0" /* 22470, 22474 */
	"VGT_ES_PER_GS\0" /* 22484, 22488 */
	"VGT_GS_PER_VS\0" /* 22498, 22502 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 22512 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 22535 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 22558 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 22581 */
	"IA_ENHANCE\0" /* 22602 */
	"VGT_DMA_SIZE\0" /* 22613 */
	"VGT_DMA_MAX_SIZE\0" /* 22626, 22634 */
	"VGT_DMA_INDEX_TYPE\0" /* 22643 */
	"WD_ENHANCE\0" /* 22662 */
	"VGT_PRIMITIVEID_EN\0" /* 22673, 22677 */
	"VGT_DMA_NUM_INSTANCES\0" /* 22692 */
	"VGT_PRIMITIVEID_RESET\0" /* 22714 */
	"VGT_EVENT_INITIATOR\0" /* 22736 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 22756, 22774 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 22783 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 22808 */
	"IA_MULTI_VGT_PARAM\0" /* 22833 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 22852, 22866 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 22875 */
	"VGT_REUSE_OFF\0" /* 22898, 22902 */
	"VGT_VTX_CNT_EN\0" /* 22912, 22916 */
	"DB_HTILE_SURFACE\0" /* 22927, 22939 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 22944 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 22971 */
	"DB_PRELOAD_CONTROL\0" /* 22998 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 23017 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 23043 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 23068 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 23096 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 23122 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 23147 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 23175 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 23201 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 23226 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 23254 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 23280 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 23305 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 23333 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 23364 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 23407, 23431, 23438 */
	"VGT_GS_MAX_VERT_OUT\0" /* 23445, 23452, 23461 */
	"VGT_TESS_DISTRIBUTION\0" /* 23465 */
	"VGT_SHADER_STAGES_EN\0" /* 23487, 23502 */
	"VGT_LS_HS_CONFIG\0" /* 23508 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 23525 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 23546 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 23569 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 23592 */
	"VGT_TF_PARAM\0" /* 23615 */
	"DB_ALPHA_TO_MASK\0" /* 23628 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 23645 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 23669 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 23699 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 23723 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 23753 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 23784 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 23813 */
	"VGT_GS_INSTANCE_CNT\0" /* 23843, 23859 */
	"VGT_STRMOUT_CONFIG\0" /* 23863 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 23882 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 23908 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 23934 */
	"PA_SC_LINE_CNTL\0" /* 23960 */
	"PA_SC_AA_CONFIG\0" /* 23976 */
	"PA_SU_VTX_CNTL\0" /* 23992 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 24007 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 24030 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 24053 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 24076 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 24099 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 24133 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 24167 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 24201 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 24235 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 24269 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 24303 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 24337 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 24371 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 24405 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 24439 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 24473 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 24507 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 24541 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 24575 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 24609 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 24643 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 24667 */
	"PA_SC_SHADER_CONTROL\0" /* 24691 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 24712 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 24740 */
	"CB_COLOR0_BASE\0" /* 24761 */
	"CB_COLOR0_PITCH\0" /* 24776 */
	"CB_COLOR0_SLICE\0" /* 24792 */
	"CB_COLOR0_VIEW\0" /* 24808 */
	"CB_COLOR0_INFO\0" /* 24823 */
	"CB_COLOR0_ATTRIB\0" /* 24838 */
	"CB_COLOR0_DCC_CONTROL\0" /* 24855 */
	"CB_COLOR0_CMASK\0" /* 24877 */
	"CB_COLOR0_CMASK_SLICE\0" /* 24893 */
	"CB_COLOR0_FMASK\0" /* 24915 */
	"CB_COLOR0_FMASK_SLICE\0" /* 24931 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 24953 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 24975 */
	"CB_COLOR0_DCC_BASE\0" /* 24997 */
	"CB_COLOR1_BASE\0" /* 25016 */
	"CB_COLOR1_PITCH\0" /* 25031 */
	"CB_COLOR1_SLICE\0" /* 25047 */
	"CB_COLOR1_VIEW\0" /* 25063 */
	"CB_COLOR1_INFO\0" /* 25078 */
	"CB_COLOR1_ATTRIB\0" /* 25093 */
	"CB_COLOR1_DCC_CONTROL\0" /* 25110 */
	"CB_COLOR1_CMASK\0" /* 25132 */
	"CB_COLOR1_CMASK_SLICE\0" /* 25148 */
	"CB_COLOR1_FMASK\0" /* 25170 */
	"CB_COLOR1_FMASK_SLICE\0" /* 25186 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 25208 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 25230 */
	"CB_COLOR1_DCC_BASE\0" /* 25252 */
	"CB_COLOR2_BASE\0" /* 25271 */
	"CB_COLOR2_PITCH\0" /* 25286 */
	"CB_COLOR2_SLICE\0" /* 25302 */
	"CB_COLOR2_VIEW\0" /* 25318 */
	"CB_COLOR2_INFO\0" /* 25333 */
	"CB_COLOR2_ATTRIB\0" /* 25348 */
	"CB_COLOR2_DCC_CONTROL\0" /* 25365 */
	"CB_COLOR2_CMASK\0" /* 25387 */
	"CB_COLOR2_CMASK_SLICE\0" /* 25403 */
	"CB_COLOR2_FMASK\0" /* 25425 */
	"CB_COLOR2_FMASK_SLICE\0" /* 25441 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 25463 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 25485 */
	"CB_COLOR2_DCC_BASE\0" /* 25507 */
	"CB_COLOR3_BASE\0" /* 25526 */
	"CB_COLOR3_PITCH\0" /* 25541 */
	"CB_COLOR3_SLICE\0" /* 25557 */
	"CB_COLOR3_VIEW\0" /* 25573 */
	"CB_COLOR3_INFO\0" /* 25588 */
	"CB_COLOR3_ATTRIB\0" /* 25603 */
	"CB_COLOR3_DCC_CONTROL\0" /* 25620 */
	"CB_COLOR3_CMASK\0" /* 25642 */
	"CB_COLOR3_CMASK_SLICE\0" /* 25658 */
	"CB_COLOR3_FMASK\0" /* 25680 */
	"CB_COLOR3_FMASK_SLICE\0" /* 25696 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 25718 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 25740 */
	"CB_COLOR3_DCC_BASE\0" /* 25762 */
	"CB_COLOR4_BASE\0" /* 25781 */
	"CB_COLOR4_PITCH\0" /* 25796 */
	"CB_COLOR4_SLICE\0" /* 25812 */
	"CB_COLOR4_VIEW\0" /* 25828 */
	"CB_COLOR4_INFO\0" /* 25843 */
	"CB_COLOR4_ATTRIB\0" /* 25858 */
	"CB_COLOR4_DCC_CONTROL\0" /* 25875 */
	"CB_COLOR4_CMASK\0" /* 25897 */
	"CB_COLOR4_CMASK_SLICE\0" /* 25913 */
	"CB_COLOR4_FMASK\0" /* 25935 */
	"CB_COLOR4_FMASK_SLICE\0" /* 25951 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 25973 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 25995 */
	"CB_COLOR4_DCC_BASE\0" /* 26017 */
	"CB_COLOR5_BASE\0" /* 26036 */
	"CB_COLOR5_PITCH\0" /* 26051 */
	"CB_COLOR5_SLICE\0" /* 26067 */
	"CB_COLOR5_VIEW\0" /* 26083 */
	"CB_COLOR5_INFO\0" /* 26098 */
	"CB_COLOR5_ATTRIB\0" /* 26113 */
	"CB_COLOR5_DCC_CONTROL\0" /* 26130 */
	"CB_COLOR5_CMASK\0" /* 26152 */
	"CB_COLOR5_CMASK_SLICE\0" /* 26168 */
	"CB_COLOR5_FMASK\0" /* 26190 */
	"CB_COLOR5_FMASK_SLICE\0" /* 26206 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 26228 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 26250 */
	"CB_COLOR5_DCC_BASE\0" /* 26272 */
	"CB_COLOR6_BASE\0" /* 26291 */
	"CB_COLOR6_PITCH\0" /* 26306 */
	"CB_COLOR6_SLICE\0" /* 26322 */
	"CB_COLOR6_VIEW\0" /* 26338 */
	"CB_COLOR6_INFO\0" /* 26353 */
	"CB_COLOR6_ATTRIB\0" /* 26368 */
	"CB_COLOR6_DCC_CONTROL\0" /* 26385 */
	"CB_COLOR6_CMASK\0" /* 26407 */
	"CB_COLOR6_CMASK_SLICE\0" /* 26423 */
	"CB_COLOR6_FMASK\0" /* 26445 */
	"CB_COLOR6_FMASK_SLICE\0" /* 26461 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 26483 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 26505 */
	"CB_COLOR6_DCC_BASE\0" /* 26527 */
	"CB_COLOR7_BASE\0" /* 26546 */
	"CB_COLOR7_PITCH\0" /* 26561 */
	"CB_COLOR7_SLICE\0" /* 26577 */
	"CB_COLOR7_VIEW\0" /* 26593 */
	"CB_COLOR7_INFO\0" /* 26608 */
	"CB_COLOR7_ATTRIB\0" /* 26623 */
	"CB_COLOR7_DCC_CONTROL\0" /* 26640 */
	"CB_COLOR7_CMASK\0" /* 26662 */
	"CB_COLOR7_CMASK_SLICE\0" /* 26678 */
	"CB_COLOR7_FMASK\0" /* 26700 */
	"CB_COLOR7_FMASK_SLICE\0" /* 26716 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 26738 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 26760 */
	"CB_COLOR7_DCC_BASE\0" /* 26782 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 26801 */
	"WD_POS_BUF_BASE\0" /* 26823 */
	"WD_POS_BUF_BASE_HI\0" /* 26839 */
	"WD_CNTL_SB_BUF_BASE\0" /* 26858 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 26878 */
	"WD_INDEX_BUF_BASE\0" /* 26901 */
	"WD_INDEX_BUF_BASE_HI\0" /* 26919 */
	"VGT_INSTANCE_BASE_ID\0" /* 26940 */
	"SQC_WRITEBACK\0" /* 26961, 26965 */
	"SPI_CONFIG_CNTL_2\0" /* 26975 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 26993 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 27020 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 27047 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 27074 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 27101 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 27128 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 27155 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 27182 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 27209 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 27236 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 27263 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 27290 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 27317 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 27344 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 27371 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 27398 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 27425 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 27452 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 27479 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 27506 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 27533 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 27560 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 27587 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 27614 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 27641 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 27668 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 27695 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 27722 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 27749 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 27776 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 27803 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 27830 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 27857 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 27884 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 27908 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 27940 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 27972 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 27999 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 28026 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 28053 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 28080 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 28107 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 28134 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 28161 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 28188 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 28215 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 28242 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 28269 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 28296 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 28323 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 28350 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 28377 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 28404 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 28428 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 28460 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 28492 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 28519 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 28546 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 28573 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 28600 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 28627 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 28654 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 28681 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 28708 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 28735 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 28762 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 28789 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 28816 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 28843 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 28870 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 28897 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 28924 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 28954 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 28984 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 29014 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 29044 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 29074 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 29104 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 29134 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 29164 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 29194 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 29224 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 29255 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 29286 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 29317 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 29348 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 29379 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 29410 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 29441 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 29472 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 29503 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 29534 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 29565 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 29596 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 29627 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 29658 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 29689 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 29720 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 29751 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 29782 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 29813 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 29844 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 29875 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 29906 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 29935 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 29964 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 29997 */
	"CPF_LATENCY_STATS_DATA\0" /* 30030 */
	"CPG_LATENCY_STATS_DATA\0" /* 30053 */
	"CPC_LATENCY_STATS_DATA\0" /* 30076 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30099 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30133 */
	"CPF_LATENCY_STATS_SELECT\0" /* 30167 */
	"CPG_LATENCY_STATS_SELECT\0" /* 30192 */
	"CPC_LATENCY_STATS_SELECT\0" /* 30217 */
	"DB_HTILE_DATA_BASE_HI\0" /* 30242 */
	"DB_Z_READ_BASE_HI\0" /* 30264 */
	"DB_STENCIL_READ_BASE_HI\0" /* 30282 */
	"DB_Z_WRITE_BASE_HI\0" /* 30306 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 30325 */
	"DB_DFSM_CONTROL\0" /* 30350 */
	"DB_Z_INFO2\0" /* 30366 */
	"DB_STENCIL_INFO2\0" /* 30377 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 30394 */
	"CP_PERFMON_CNTX_CNTL\0" /* 30423 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 30444 */
	"PA_SC_LEFT_VERT_GRID\0" /* 30466 */
	"PA_SC_HORIZ_GRID\0" /* 30487 */
	"CB_MRT0_EPITCH\0" /* 30504, 30512 */
	"CB_MRT1_EPITCH\0" /* 30519 */
	"CB_MRT2_EPITCH\0" /* 30534 */
	"CB_MRT3_EPITCH\0" /* 30549 */
	"CB_MRT4_EPITCH\0" /* 30564 */
	"CB_MRT5_EPITCH\0" /* 30579 */
	"CB_MRT6_EPITCH\0" /* 30594 */
	"CB_MRT7_EPITCH\0" /* 30609 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 30624 */
	"PA_CL_NGG_CNTL\0" /* 30646 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 30661 */
	"PA_STEREO_CNTL\0" /* 30691 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 30706, 30713 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 30736 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 30758 */
	"PA_SC_BINNER_CNTL_0\0" /* 30782 */
	"PA_SC_BINNER_CNTL_1\0" /* 30802 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 30822 */
	"PA_SC_NGG_MODE_CNTL\0" /* 30860 */
	"CB_COLOR0_BASE_EXT\0" /* 30880 */
	"CB_COLOR0_ATTRIB2\0" /* 30899 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 30917 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 30942 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 30967 */
	"CB_COLOR1_BASE_EXT\0" /* 30990 */
	"CB_COLOR1_ATTRIB2\0" /* 31009 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 31027 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 31052 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 31077 */
	"CB_COLOR2_BASE_EXT\0" /* 31100 */
	"CB_COLOR2_ATTRIB2\0" /* 31119 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 31137 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 31162 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 31187 */
	"CB_COLOR3_BASE_EXT\0" /* 31210 */
	"CB_COLOR3_ATTRIB2\0" /* 31229 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 31247 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 31272 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 31297 */
	"CB_COLOR4_BASE_EXT\0" /* 31320 */
	"CB_COLOR4_ATTRIB2\0" /* 31339 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 31357 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 31382 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 31407 */
	"CB_COLOR5_BASE_EXT\0" /* 31430 */
	"CB_COLOR5_ATTRIB2\0" /* 31449 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 31467 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 31492 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 31517 */
	"CB_COLOR6_BASE_EXT\0" /* 31540 */
	"CB_COLOR6_ATTRIB2\0" /* 31559 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 31577 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 31602 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 31627 */
	"CB_COLOR7_BASE_EXT\0" /* 31650 */
	"CB_COLOR7_ATTRIB2\0" /* 31669 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 31687 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 31712 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 31737 */
	"COUNT_INDIRECT_ENABLE\0" /* 31760 */
	"DRAW_INDEX_ENABLE\0" /* 31782 */
	"PFP\0" /* 31800 */
	"ENGINE_SEL\0" /* 31804 */
	"WR_CONFIRM\0" /* 31815 */
	"WR_ONE_ADDR\0" /* 31826 */
	"MEM_MAPPED_REGISTER\0" /* 31838, 31849 */
	"MEM_GRBM\0" /* 31858 */
	"TC_L2\0" /* 31867 */
	"GDS\0" /* 31873 */
	"DST_SEL\0" /* 31877 */
	"IB_SIZE\0" /* 31885 */
	"CHAIN\0" /* 31893 */
	"VALID\0" /* 31899 */
	"CP_SYNC\0" /* 31905 */
	"SRC_ADDR\0" /* 31913 */
	"SRC_ADDR_TC_L2\0" /* 31922 */
	"SRC_SEL\0" /* 31937 */
	"ENGINE\0" /* 31945 */
	"DST_ADDR\0" /* 31952 */
	"DST_ADDR_TC_L2\0" /* 31961 */
	"BYTE_COUNT_GFX6\0" /* 31976 */
	"BYTE_COUNT_GFX9\0" /* 31992 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 32008 */
	"NONE\0" /* 32032 */
	"8_IN_16\0" /* 32037 */
	"8_IN_32\0" /* 32045, 32047 */
	"8_IN_64\0" /* 32053 */
	"SRC_SWAP\0" /* 32061 */
	"DST_SWAP\0" /* 32070 */
	"MEMORY\0" /* 32079 */
	"SAS\0" /* 32086 */
	"DAS\0" /* 32090 */
	"INCREMENT\0" /* 32094 */
	"NO_INCREMENT\0" /* 32104 */
	"SAIC\0" /* 32117 */
	"DAIC\0" /* 32122 */
	"RAW_WAIT\0" /* 32127 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 32136 */
	"DST_CACHE_POLICY\0" /* 32160 */
	"SRC_CACHE_POLICY\0" /* 32177 */
	"SDMA_RQ_PENDING\0" /* 32194 */
	"TST_RQ_PENDING\0" /* 32210 */
	"SDMA1_RQ_PENDING\0" /* 32225 */
	"VCE0_RQ_PENDING\0" /* 32242 */
	"VP8_BUSY\0" /* 32258 */
	"SDMA_BUSY\0" /* 32267, 32268 */
	"SDMA1_BUSY\0" /* 32277 */
	"VCE0_BUSY\0" /* 32288 */
	"XDMA_BUSY\0" /* 32298 */
	"CHUB_BUSY\0" /* 32308 */
	"SDMA2_BUSY\0" /* 32318 */
	"SDMA3_BUSY\0" /* 32329 */
	"SAMSCP_BUSY\0" /* 32340, 32344 */
	"ISP_BUSY\0" /* 32352 */
	"VCE1_BUSY\0" /* 32361 */
	"ODE_BUSY\0" /* 32371 */
	"SDMA2_RQ_PENDING\0" /* 32380 */
	"SDMA3_RQ_PENDING\0" /* 32397 */
	"SAMSCP_RQ_PENDING\0" /* 32414 */
	"ISP_RQ_PENDING\0" /* 32432 */
	"VCE1_RQ_PENDING\0" /* 32447 */
	"UVD_RQ_PENDING\0" /* 32463 */
	"SAMMSP_RQ_PENDING\0" /* 32478 */
	"ACP_RQ_PENDING\0" /* 32496 */
	"SMU_RQ_PENDING\0" /* 32511 */
	"GRBM_RQ_PENDING\0" /* 32526 */
	"HI_RQ_PENDING\0" /* 32542 */
	"VMC_BUSY\0" /* 32556 */
	"MCB_BUSY\0" /* 32565, 32566 */
	"MCB_NON_DISPLAY_BUSY\0" /* 32574 */
	"MCC_BUSY\0" /* 32595 */
	"MCD_BUSY\0" /* 32604 */
	"VMC1_BUSY\0" /* 32613 */
	"SEM_BUSY\0" /* 32623 */
	"ACP_BUSY\0" /* 32632 */
	"IH_BUSY\0" /* 32641 */
	"UVD_BUSY\0" /* 32649 */
	"SAMMSP_BUSY\0" /* 32658 */
	"GCATCL2_BUSY\0" /* 32670 */
	"OSATCL2_BUSY\0" /* 32683 */
	"BIF_BUSY\0" /* 32696 */
	"MCC0_BUSY\0" /* 32705 */
	"MCC1_BUSY\0" /* 32715 */
	"MCC2_BUSY\0" /* 32725 */
	"MCC3_BUSY\0" /* 32735 */
	"MCC4_BUSY\0" /* 32745 */
	"MCC5_BUSY\0" /* 32755 */
	"MCC6_BUSY\0" /* 32765 */
	"MCC7_BUSY\0" /* 32775 */
	"MCD0_BUSY\0" /* 32785 */
	"MCD1_BUSY\0" /* 32795 */
	"MCD2_BUSY\0" /* 32805 */
	"MCD3_BUSY\0" /* 32815 */
	"MCD4_BUSY\0" /* 32825 */
	"MCD5_BUSY\0" /* 32835 */
	"MCD6_BUSY\0" /* 32845 */
	"MCD7_BUSY\0" /* 32855 */
	"IDLE\0" /* 32865 */
	"REG_IDLE\0" /* 32870 */
	"RB_EMPTY\0" /* 32879 */
	"RB_FULL\0" /* 32888 */
	"RB_CMD_IDLE\0" /* 32896 */
	"RB_CMD_FULL\0" /* 32908 */
	"IB_CMD_IDLE\0" /* 32920 */
	"IB_CMD_FULL\0" /* 32932 */
	"BLOCK_IDLE\0" /* 32944 */
	"INSIDE_IB\0" /* 32955 */
	"EX_IDLE\0" /* 32965 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 32973 */
	"PACKET_READY\0" /* 32999 */
	"MC_WR_IDLE\0" /* 33012 */
	"SRBM_IDLE\0" /* 33023 */
	"CONTEXT_EMPTY\0" /* 33033 */
	"DELTA_RPTR_FULL\0" /* 33047 */
	"RB_MC_RREQ_IDLE\0" /* 33063 */
	"IB_MC_RREQ_IDLE\0" /* 33079 */
	"MC_RD_IDLE\0" /* 33095 */
	"DELTA_RPTR_EMPTY\0" /* 33106 */
	"MC_RD_RET_STALL\0" /* 33123 */
	"MC_RD_NO_POLL_IDLE\0" /* 33139 */
	"PREV_CMD_IDLE\0" /* 33158 */
	"SEM_IDLE\0" /* 33172 */
	"SEM_REQ_STALL\0" /* 33181 */
	"SEM_RESP_STATE\0" /* 33195 */
	"INT_IDLE\0" /* 33210 */
	"INT_REQ_STALL\0" /* 33219 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 33233 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 33256 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 33279 */
	"ME1PIPE0_RQ_PENDING\0" /* 33302 */
	"ME1PIPE1_RQ_PENDING\0" /* 33322 */
	"ME1PIPE2_RQ_PENDING\0" /* 33342 */
	"ME1PIPE3_RQ_PENDING\0" /* 33362 */
	"ME2PIPE0_RQ_PENDING\0" /* 33382 */
	"ME2PIPE1_RQ_PENDING\0" /* 33402 */
	"ME2PIPE2_RQ_PENDING\0" /* 33422 */
	"ME2PIPE3_RQ_PENDING\0" /* 33442 */
	"RLC_RQ_PENDING\0" /* 33462 */
	"RLC_BUSY\0" /* 33477 */
	"TC_BUSY\0" /* 33486 */
	"TCC_CC_RESIDENT\0" /* 33494 */
	"CPF_BUSY\0" /* 33510 */
	"CPC_BUSY\0" /* 33519 */
	"CPG_BUSY\0" /* 33528 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 33537 */
	"SRBM_RQ_PENDING\0" /* 33560 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 33576 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 33599 */
	"GDS_DMA_RQ_PENDING\0" /* 33622 */
	"DB_CLEAN\0" /* 33641 */
	"CB_CLEAN\0" /* 33650 */
	"TA_BUSY\0" /* 33659 */
	"GDS_BUSY\0" /* 33667 */
	"WD_BUSY_NO_DMA\0" /* 33676 */
	"VGT_BUSY\0" /* 33691 */
	"IA_BUSY_NO_DMA\0" /* 33700 */
	"IA_BUSY\0" /* 33715 */
	"SX_BUSY\0" /* 33723 */
	"WD_BUSY\0" /* 33731 */
	"SPI_BUSY\0" /* 33739 */
	"BCI_BUSY\0" /* 33748 */
	"SC_BUSY\0" /* 33757 */
	"PA_BUSY\0" /* 33765 */
	"DB_BUSY\0" /* 33773 */
	"CP_COHERENCY_BUSY\0" /* 33781 */
	"GUI_ACTIVE\0" /* 33799 */
	"INSTANCE_INDEX\0" /* 33810 */
	"SH_INDEX\0" /* 33825 */
	"SE_INDEX\0" /* 33834 */
	"SH_BROADCAST_WRITES\0" /* 33843 */
	"INSTANCE_BROADCAST_WRITES\0" /* 33863 */
	"SE_BROADCAST_WRITES\0" /* 33889 */
	"OFFSET_UPDATE_DONE\0" /* 33909, 33923 */
	"DEST_BASE_0_ENA\0" /* 33928 */
	"DEST_BASE_1_ENA\0" /* 33944 */
	"CB0_DEST_BASE_ENA\0" /* 33960 */
	"CB1_DEST_BASE_ENA\0" /* 33978 */
	"CB2_DEST_BASE_ENA\0" /* 33996 */
	"CB3_DEST_BASE_ENA\0" /* 34014 */
	"CB4_DEST_BASE_ENA\0" /* 34032 */
	"CB5_DEST_BASE_ENA\0" /* 34050 */
	"CB6_DEST_BASE_ENA\0" /* 34068 */
	"CB7_DEST_BASE_ENA\0" /* 34086 */
	"DB_DEST_BASE_ENA\0" /* 34104 */
	"DEST_BASE_2_ENA\0" /* 34121 */
	"DEST_BASE_3_ENA\0" /* 34137 */
	"TCL1_ACTION_ENA\0" /* 34153 */
	"TC_ACTION_ENA\0" /* 34169 */
	"CB_ACTION_ENA\0" /* 34183 */
	"DB_ACTION_ENA\0" /* 34197 */
	"SH_KCACHE_ACTION_ENA\0" /* 34211 */
	"SH_ICACHE_ACTION_ENA\0" /* 34232 */
	"COHER_BASE_HI_256B\0" /* 34253 */
	"START_DELAY_COUNT\0" /* 34272 */
	"TC_SD_ACTION_ENA\0" /* 34290 */
	"TC_NC_ACTION_ENA\0" /* 34307 */
	"TCL1_VOL_ACTION_ENA\0" /* 34324 */
	"TC_VOL_ACTION_ENA\0" /* 34344 */
	"TC_WB_ACTION_ENA\0" /* 34362 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 34379 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 34404 */
	"SH_SD_ACTION_ENA\0" /* 34428 */
	"MATCHING_GFX_CNTX\0" /* 34445 */
	"MEID\0" /* 34463 */
	"PHASE1_STATUS\0" /* 34468 */
	"MEC1_BUSY\0" /* 34482 */
	"MEC2_BUSY\0" /* 34492 */
	"DC0_BUSY\0" /* 34502 */
	"DC1_BUSY\0" /* 34511 */
	"RCIU1_BUSY\0" /* 34520 */
	"RCIU2_BUSY\0" /* 34531 */
	"ROQ1_BUSY\0" /* 34542 */
	"ROQ2_BUSY\0" /* 34552 */
	"TCIU_BUSY\0" /* 34562 */
	"SCRATCH_RAM_BUSY\0" /* 34572 */
	"QU_BUSY\0" /* 34589 */
	"ATCL2IU_BUSY\0" /* 34597 */
	"CPG_CPC_BUSY\0" /* 34610 */
	"CPF_CPC_BUSY\0" /* 34623 */
	"MEC1_LOAD_BUSY\0" /* 34636 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 34651 */
	"MEC1_MUTEX_BUSY\0" /* 34671 */
	"MEC1_MESSAGE_BUSY\0" /* 34687 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 34705 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 34725 */
	"MEC1_IB_QUEUE_BUSY\0" /* 34744 */
	"MEC1_TC_BUSY\0" /* 34763 */
	"MEC1_DMA_BUSY\0" /* 34776 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 34790 */
	"MEC1_PIPE0_BUSY\0" /* 34814 */
	"MEC1_PIPE1_BUSY\0" /* 34830 */
	"MEC1_PIPE2_BUSY\0" /* 34846 */
	"MEC1_PIPE3_BUSY\0" /* 34862 */
	"MEC2_LOAD_BUSY\0" /* 34878 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 34893 */
	"MEC2_MUTEX_BUSY\0" /* 34913 */
	"MEC2_MESSAGE_BUSY\0" /* 34929 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 34947 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 34967 */
	"MEC2_IB_QUEUE_BUSY\0" /* 34986 */
	"MEC2_TC_BUSY\0" /* 35005 */
	"MEC2_DMA_BUSY\0" /* 35018 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 35032 */
	"MEC2_PIPE0_BUSY\0" /* 35056 */
	"MEC2_PIPE1_BUSY\0" /* 35072 */
	"MEC2_PIPE2_BUSY\0" /* 35088 */
	"MEC2_PIPE3_BUSY\0" /* 35104 */
	"RCIU_TX_FREE_STALL\0" /* 35120 */
	"RCIU_PRIV_VIOLATION\0" /* 35139 */
	"TCIU_TX_FREE_STALL\0" /* 35159 */
	"MEC1_DECODING_PACKET\0" /* 35178 */
	"MEC1_WAIT_ON_RCIU\0" /* 35199 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 35217 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 35240 */
	"MEC2_DECODING_PACKET\0" /* 35262 */
	"MEC2_WAIT_ON_RCIU\0" /* 35283 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 35301 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 35324 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 35346 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 35370 */
	"ATCL1_WAITING_ON_TRANS\0" /* 35394 */
	"POST_WPTR_GFX_BUSY\0" /* 35417 */
	"CSF_BUSY\0" /* 35436 */
	"ROQ_ALIGN_BUSY\0" /* 35445 */
	"ROQ_RING_BUSY\0" /* 35460 */
	"ROQ_INDIRECT1_BUSY\0" /* 35474 */
	"ROQ_INDIRECT2_BUSY\0" /* 35493 */
	"ROQ_STATE_BUSY\0" /* 35512 */
	"ROQ_CE_RING_BUSY\0" /* 35527 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 35544 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 35566 */
	"SEMAPHORE_BUSY\0" /* 35588 */
	"INTERRUPT_BUSY\0" /* 35603 */
	"HQD_BUSY\0" /* 35618 */
	"PRT_BUSY\0" /* 35627 */
	"CPF_GFX_BUSY\0" /* 35636 */
	"CPF_CMP_BUSY\0" /* 35649 */
	"GRBM_CPF_STAT_BUSY\0" /* 35662 */
	"CPC_CPF_BUSY\0" /* 35681 */
	"REG_BUS_FIFO_BUSY\0" /* 35694 */
	"CSF_RING_BUSY\0" /* 35712 */
	"CSF_INDIRECT1_BUSY\0" /* 35726 */
	"CSF_INDIRECT2_BUSY\0" /* 35745 */
	"CSF_STATE_BUSY\0" /* 35764 */
	"CSF_CE_INDR1_BUSY\0" /* 35779 */
	"CSF_CE_INDR2_BUSY\0" /* 35797 */
	"CSF_ARBITER_BUSY\0" /* 35815 */
	"CSF_INPUT_BUSY\0" /* 35832 */
	"OUTSTANDING_READ_TAGS\0" /* 35847 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 35869 */
	"HQD_DISPATCH_BUSY\0" /* 35893 */
	"HQD_IQ_TIMER_BUSY\0" /* 35911 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 35929 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 35950 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 35974 */
	"HQD_MESSAGE_BUSY\0" /* 36000 */
	"HQD_PQ_FETCHER_BUSY\0" /* 36017 */
	"HQD_IB_FETCHER_BUSY\0" /* 36037 */
	"HQD_IQ_FETCHER_BUSY\0" /* 36057 */
	"HQD_EOP_FETCHER_BUSY\0" /* 36077 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 36098 */
	"HQD_FETCHER_ARB_BUSY\0" /* 36121 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 36142 */
	"HQD_ROQ_EOP_BUSY\0" /* 36161 */
	"HQD_ROQ_IQ_BUSY\0" /* 36178 */
	"HQD_ROQ_PQ_BUSY\0" /* 36194 */
	"HQD_ROQ_IB_BUSY\0" /* 36210 */
	"HQD_WPTR_POLL_BUSY\0" /* 36226 */
	"HQD_PQ_BUSY\0" /* 36245 */
	"HQD_IB_BUSY\0" /* 36257 */
	"RING_FETCHING_DATA\0" /* 36269 */
	"INDR1_FETCHING_DATA\0" /* 36288 */
	"INDR2_FETCHING_DATA\0" /* 36308 */
	"STATE_FETCHING_DATA\0" /* 36328 */
	"TCIU_WAITING_ON_FREE\0" /* 36348 */
	"TCIU_WAITING_ON_TAGS\0" /* 36369 */
	"COHER_SIZE_HI_256B\0" /* 36390 */
	"PRIM_COUNT\0" /* 36409 */
	"VS_NO_EXTRA_BUFFER\0" /* 36420 */
	"STREAMOUT_FULL_FLUSH\0" /* 36439 */
	"ES_LIMIT\0" /* 36460, 36463 */
	"VERT_REUSE\0" /* 36469 */
	"DI_PT_NONE\0" /* 36480 */
	"DI_PT_POINTLIST\0" /* 36491 */
	"DI_PT_LINELIST\0" /* 36507 */
	"DI_PT_LINESTRIP\0" /* 36522 */
	"DI_PT_TRILIST\0" /* 36538 */
	"DI_PT_TRIFAN\0" /* 36552 */
	"DI_PT_TRISTRIP\0" /* 36565 */
	"DI_PT_UNUSED_0\0" /* 36580 */
	"DI_PT_UNUSED_1\0" /* 36595 */
	"DI_PT_PATCH\0" /* 36610 */
	"DI_PT_LINELIST_ADJ\0" /* 36622 */
	"DI_PT_LINESTRIP_ADJ\0" /* 36641 */
	"DI_PT_TRILIST_ADJ\0" /* 36661 */
	"DI_PT_TRISTRIP_ADJ\0" /* 36679 */
	"DI_PT_UNUSED_3\0" /* 36698 */
	"DI_PT_UNUSED_4\0" /* 36713 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 36728 */
	"DI_PT_RECTLIST\0" /* 36750 */
	"DI_PT_LINELOOP\0" /* 36765 */
	"DI_PT_QUADLIST\0" /* 36780 */
	"DI_PT_QUADSTRIP\0" /* 36795 */
	"DI_PT_POLYGON\0" /* 36811 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 36825 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 36852 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 36879 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 36906 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 36933 */
	"DI_PT_2D_LINE_STRIP\0" /* 36957 */
	"DI_PT_2D_TRI_STRIP\0" /* 36977 */
	"DI_INDEX_SIZE_16_BIT\0" /* 36996 */
	"DI_INDEX_SIZE_32_BIT\0" /* 37017 */
	"OFFCHIP_BUFFERING\0" /* 37038 */
	"CLIP_VTX_REORDER_ENA\0" /* 37056 */
	"NUM_CLIP_SEQ\0" /* 37077 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 37090 */
	"VE_NAN_PROC_DISABLE\0" /* 37113 */
	"CURRENT_PTR\0" /* 37133 */
	"CURRENT_COUNT\0" /* 37145 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 37159 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 37184 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 37222 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 37263 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 37286 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 37309 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 37333 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 37363 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 37392 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 37418 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 37447 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 37472 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 37507 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37535 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 37565 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 37592 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 37619 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 37648 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 37677 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 37706 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37734 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 37764 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 37791 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 37819 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 37844 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 37870 */
	"RCIU_STALLED_ON_ME_READ\0" /* 37895 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 37919 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 37944 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 37972 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 38001 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 38027 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 38053 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 38080 */
	"PFP_RCIU_READ_PENDING\0" /* 38106 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 38128 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 38155 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 38177 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 38201 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 38226 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 38249 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 38276 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 38301 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38329 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38354 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 38379 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 38404 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 38433 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 38464 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 38492 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 38519 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 38549 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 38576, 38595 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 38603, 38622 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 38630 */
	"APPEND_ACTIVE_PARTITION\0" /* 38656 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 38680 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 38712 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 38739 */
	"DC_BUSY\0" /* 38765 */
	"PFP_BUSY\0" /* 38773 */
	"MEQ_BUSY\0" /* 38782 */
	"ME_BUSY\0" /* 38791 */
	"QUERY_BUSY\0" /* 38799 */
	"SURFACE_SYNC_BUSY\0" /* 38810 */
	"RCIU_BUSY\0" /* 38828 */
	"CPC_CPG_BUSY\0" /* 38838 */
	"CE_BUSY\0" /* 38851 */
	"X_8K_DWORDS\0" /* 38859 */
	"X_4K_DWORDS\0" /* 38871 */
	"X_2K_DWORDS\0" /* 38883 */
	"X_1K_DWORDS\0" /* 38895 */
	"OFFCHIP_GRANULARITY\0" /* 38907 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 38927 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 38953 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 38976 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 39001 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 39032 */
	"DISABLE_SCISSOR_FIX\0" /* 39066 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 39086 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 39113 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 39141 */
	"INST_INVALIDATE\0" /* 39176, 39181 */
	"DATA_INVALIDATE\0" /* 39192 */
	"INVALIDATE_VOLATILE\0" /* 39208 */
	"RET\0" /* 39228 */
	"RUI\0" /* 39232 */
	"RNG\0" /* 39236 */
	"SQ_EXP_MRT\0" /* 39240 */
	"SQ_EXP_MRTZ\0" /* 39251 */
	"SQ_EXP_NULL\0" /* 39263 */
	"SQ_EXP_POS\0" /* 39275 */
	"SQ_EXP_PARAM\0" /* 39286 */
	"TGT\0" /* 39299 */
	"COMPR\0" /* 39303 */
	"VM\0" /* 39309 */
	"SQ_ENC_EXP_FIELD\0" /* 39312 */
	"ENCODING\0" /* 39329 */
	"BASE_ADDRESS_HI\0" /* 39338, 39343 */
	"CACHE_SWIZZLE\0" /* 39354 */
	"SWIZZLE_ENABLE\0" /* 39368 */
	"SQ_SEL_0\0" /* 39383 */
	"SQ_SEL_1\0" /* 39392 */
	"SQ_SEL_RESERVED_0\0" /* 39401, 39408 */
	"SQ_SEL_RESERVED_1\0" /* 39419, 39426 */
	"SQ_SEL_X\0" /* 39437 */
	"SQ_SEL_Y\0" /* 39446 */
	"SQ_SEL_Z\0" /* 39455 */
	"SQ_SEL_W\0" /* 39464 */
	"DST_SEL_X\0" /* 39473 */
	"DST_SEL_Y\0" /* 39483 */
	"DST_SEL_Z\0" /* 39493 */
	"DST_SEL_W\0" /* 39503 */
	"BUF_NUM_FORMAT_UNORM\0" /* 39513 */
	"BUF_NUM_FORMAT_SNORM\0" /* 39534 */
	"BUF_NUM_FORMAT_USCALED\0" /* 39555 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 39578 */
	"BUF_NUM_FORMAT_UINT\0" /* 39601 */
	"BUF_NUM_FORMAT_SINT\0" /* 39621 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 39641 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 39666 */
	"NUM_FORMAT\0" /* 39687 */
	"BUF_DATA_FORMAT_INVALID\0" /* 39698 */
	"BUF_DATA_FORMAT_8\0" /* 39722 */
	"BUF_DATA_FORMAT_16\0" /* 39740 */
	"BUF_DATA_FORMAT_8_8\0" /* 39759 */
	"BUF_DATA_FORMAT_32\0" /* 39779 */
	"BUF_DATA_FORMAT_16_16\0" /* 39798 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 39820 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 39845 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 39870 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 39897 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 39924 */
	"BUF_DATA_FORMAT_32_32\0" /* 39948 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 39970 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 39998 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 40023 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 40051 */
	"DATA_FORMAT\0" /* 40079 */
	"ELEMENT_SIZE\0" /* 40091 */
	"INDEX_STRIDE\0" /* 40104 */
	"ADD_TID_ENABLE\0" /* 40117 */
	"ATC\0" /* 40132 */
	"HASH_ENABLE\0" /* 40136 */
	"HEAP\0" /* 40148 */
	"MTYPE\0" /* 40153 */
	"SQ_RSRC_BUF\0" /* 40159 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 40171 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 40190 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 40209 */
	"MIN_LOD\0" /* 40228 */
	"IMG_DATA_FORMAT_INVALID\0" /* 40236 */
	"IMG_DATA_FORMAT_8\0" /* 40260 */
	"IMG_DATA_FORMAT_16\0" /* 40278 */
	"IMG_DATA_FORMAT_8_8\0" /* 40297 */
	"IMG_DATA_FORMAT_32\0" /* 40317 */
	"IMG_DATA_FORMAT_16_16\0" /* 40336 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 40358 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 40383 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 40408 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 40435 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 40462 */
	"IMG_DATA_FORMAT_32_32\0" /* 40486 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 40508 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 40536 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 40561 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 40589 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 40617 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 40639 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 40663 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 40687 */
	"IMG_DATA_FORMAT_8_24\0" /* 40711 */
	"IMG_DATA_FORMAT_24_8\0" /* 40732 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 40753 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 40778 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 40807 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 40832 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 40858 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 40881 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 40905 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 40932 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 40960 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 40988 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 41016 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 41038 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 41060 */
	"IMG_DATA_FORMAT_BC1\0" /* 41084 */
	"IMG_DATA_FORMAT_BC2\0" /* 41104 */
	"IMG_DATA_FORMAT_BC3\0" /* 41124 */
	"IMG_DATA_FORMAT_BC4\0" /* 41144 */
	"IMG_DATA_FORMAT_BC5\0" /* 41164 */
	"IMG_DATA_FORMAT_BC6\0" /* 41184 */
	"IMG_DATA_FORMAT_BC7\0" /* 41204 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 41224 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 41263 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 41302 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 41331 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 41360 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 41389 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 41418 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 41447 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 41476 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 41507 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 41537 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 41568 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 41598 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 41628 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 41659 */
	"IMG_DATA_FORMAT_4_4\0" /* 41690 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 41710 */
	"IMG_DATA_FORMAT_1\0" /* 41732 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 41750 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 41777 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 41801 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 41827 */
	"DATA_FORMAT_GFX6\0" /* 41861 */
	"IMG_NUM_FORMAT_UNORM\0" /* 41878 */
	"IMG_NUM_FORMAT_SNORM\0" /* 41899 */
	"IMG_NUM_FORMAT_USCALED\0" /* 41920 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 41943 */
	"IMG_NUM_FORMAT_UINT\0" /* 41966 */
	"IMG_NUM_FORMAT_SINT\0" /* 41986 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 42006 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 42031 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 42052 */
	"IMG_NUM_FORMAT_SRGB\0" /* 42078 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 42098 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 42120 */
	"IMG_NUM_FORMAT_UBINT\0" /* 42146 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 42167 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 42191 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 42218 */
	"NUM_FORMAT_GFX6\0" /* 42245 */
	"WIDTH\0" /* 42261 */
	"HEIGHT\0" /* 42267 */
	"PERF_MOD\0" /* 42274 */
	"INTERLACED\0" /* 42283 */
	"BASE_LEVEL\0" /* 42294 */
	"LAST_LEVEL\0" /* 42305 */
	"TILING_INDEX\0" /* 42316 */
	"POW2_PAD\0" /* 42329 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 42338 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 42357 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 42376 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 42395 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 42414 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 42433 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 42452 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 42471 */
	"SQ_RSRC_IMG_1D\0" /* 42490, 42502 */
	"SQ_RSRC_IMG_2D\0" /* 42505, 42517 */
	"SQ_RSRC_IMG_3D\0" /* 42520, 42532 */
	"SQ_RSRC_IMG_CUBE\0" /* 42535 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 42552 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 42573 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 42594 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 42614 */
	"PITCH_GFX6\0" /* 42640 */
	"BASE_ARRAY\0" /* 42651 */
	"LAST_ARRAY\0" /* 42662 */
	"MIN_LOD_WARN\0" /* 42673 */
	"COUNTER_BANK_ID\0" /* 42686 */
	"LOD_HDW_CNT_EN\0" /* 42702 */
	"COMPRESSION_EN\0" /* 42717 */
	"ALPHA_IS_ON_MSB\0" /* 42732 */
	"COLOR_TRANSFORM\0" /* 42748 */
	"LOST_ALPHA_BITS\0" /* 42764 */
	"LOST_COLOR_BITS\0" /* 42780 */
	"SQ_TEX_WRAP\0" /* 42796 */
	"SQ_TEX_MIRROR\0" /* 42808 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 42822 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 42846 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 42876 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 42901 */
	"SQ_TEX_CLAMP_BORDER\0" /* 42932 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 42952 */
	"CLAMP_X\0" /* 42978 */
	"CLAMP_Y\0" /* 42986 */
	"CLAMP_Z\0" /* 42994 */
	"MAX_ANISO_RATIO\0" /* 43002 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 43018 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 43045 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 43071 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 43098 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 43129 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 43158 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 43188 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 43222, 43243 */
	"DEPTH_COMPARE_FUNC\0" /* 43250 */
	"FORCE_UNNORMALIZED\0" /* 43269 */
	"ANISO_THRESHOLD\0" /* 43288 */
	"MC_COORD_TRUNC\0" /* 43304 */
	"FORCE_DEGAMMA\0" /* 43319 */
	"ANISO_BIAS\0" /* 43333 */
	"TRUNC_COORD\0" /* 43344 */
	"DISABLE_CUBE_WRAP\0" /* 43356 */
	"SQ_IMG_FILTER_MODE_BLEND\0" /* 43374 */
	"SQ_IMG_FILTER_MODE_MIN\0" /* 43399 */
	"SQ_IMG_FILTER_MODE_MAX\0" /* 43422 */
	"FILTER_MODE\0" /* 43445 */
	"COMPAT_MODE\0" /* 43457 */
	"MAX_LOD\0" /* 43469 */
	"PERF_MIP\0" /* 43477 */
	"PERF_Z\0" /* 43486 */
	"LOD_BIAS\0" /* 43493 */
	"LOD_BIAS_SEC\0" /* 43502 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 43515, 43529 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 43538, 43557 */
	"XY_MAG_FILTER\0" /* 43564 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 43578 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 43607 */
	"XY_MIN_FILTER\0" /* 43639 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 43653 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 43674 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 43696 */
	"Z_FILTER\0" /* 43719 */
	"MIP_FILTER\0" /* 43728 */
	"MIP_POINT_PRECLAMP\0" /* 43739 */
	"DISABLE_LSB_CEIL\0" /* 43758 */
	"FILTER_PREC_FIX\0" /* 43775 */
	"ANISO_OVERRIDE\0" /* 43791 */
	"BORDER_COLOR_PTR\0" /* 43806 */
	"UPGRADED_DEPTH\0" /* 43823 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 43838 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 43870 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 43903 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 43936 */
	"BORDER_COLOR_TYPE\0" /* 43965 */
	"VS_LOW_THRESHOLD\0" /* 43983 */
	"GS_LOW_THRESHOLD\0" /* 44000 */
	"ES_LOW_THRESHOLD\0" /* 44017 */
	"HS_LOW_THRESHOLD\0" /* 44034 */
	"LS_LOW_THRESHOLD\0" /* 44051 */
	"PS_CU_EN\0" /* 44068, 44071 */
	"VS_CU_EN\0" /* 44077 */
	"GS_CU_EN\0" /* 44086 */
	"ES_CU_EN\0" /* 44095 */
	"LSHS_CU_EN\0" /* 44104 */
	"X_R0\0" /* 44115 */
	"RING_ORDER_TS0\0" /* 44120 */
	"RING_ORDER_TS1\0" /* 44135 */
	"RING_ORDER_TS2\0" /* 44150 */
	"PIPE_ORDER_TS0\0" /* 44165 */
	"PIPE_ORDER_TS1\0" /* 44180 */
	"PIPE_ORDER_TS2\0" /* 44195 */
	"PIPE_ORDER_TS3\0" /* 44210 */
	"TS0_DUR_MULT\0" /* 44225 */
	"TS1_DUR_MULT\0" /* 44238 */
	"TS2_DUR_MULT\0" /* 44251 */
	"TS3_DUR_MULT\0" /* 44264 */
	"TS0_DURATION\0" /* 44277 */
	"TS1_DURATION\0" /* 44290 */
	"TS2_DURATION\0" /* 44303 */
	"SPACE_AVAILABLE\0" /* 44316 */
	"DS_ADDRESS\0" /* 44332 */
	"CRAWLER\0" /* 44343 */
	"CRAWLER_TYPE\0" /* 44351 */
	"NO_ALLOC\0" /* 44364 */
	"GPR_WRITE_PRIORITY\0" /* 44373 */
	"EXP_PRIORITY_ORDER\0" /* 44392 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 44411 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 44433 */
	"RSRC_MGMT_RESET\0" /* 44455 */
	"X_DELAY_14_CLKS\0" /* 44471 */
	"X_DELAY_16_CLKS\0" /* 44487 */
	"X_DELAY_18_CLKS\0" /* 44503 */
	"X_DELAY_20_CLKS\0" /* 44519 */
	"X_DELAY_22_CLKS\0" /* 44535 */
	"X_DELAY_24_CLKS\0" /* 44551 */
	"X_DELAY_26_CLKS\0" /* 44567 */
	"X_DELAY_28_CLKS\0" /* 44583 */
	"X_DELAY_30_CLKS\0" /* 44599 */
	"X_DELAY_32_CLKS\0" /* 44615 */
	"X_DELAY_34_CLKS\0" /* 44631 */
	"X_DELAY_4_CLKS\0" /* 44647 */
	"X_DELAY_6_CLKS\0" /* 44662 */
	"X_DELAY_8_CLKS\0" /* 44677 */
	"X_DELAY_10_CLKS\0" /* 44692 */
	"X_DELAY_12_CLKS\0" /* 44708 */
	"VTX_DONE_DELAY\0" /* 44724 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 44739 */
	"PC_LIMIT_ENABLE\0" /* 44763 */
	"PC_LIMIT_STRICT\0" /* 44779 */
	"PC_LIMIT_SIZE\0" /* 44795 */
	"TYPE_A\0" /* 44809 */
	"VGPR_A\0" /* 44816 */
	"SGPR_A\0" /* 44823 */
	"LDS_A\0" /* 44830 */
	"WAVES_A\0" /* 44836 */
	"EN_A\0" /* 44844 */
	"TYPE_B\0" /* 44849 */
	"VGPR_B\0" /* 44856 */
	"SGPR_B\0" /* 44863 */
	"LDS_B\0" /* 44870 */
	"WAVES_B\0" /* 44876 */
	"EN_B\0" /* 44884 */
	"MSAA1_X\0" /* 44889 */
	"MSAA1_Y\0" /* 44897 */
	"MSAA2_X\0" /* 44905 */
	"MSAA2_Y\0" /* 44913 */
	"MSAA4_X\0" /* 44921 */
	"MSAA4_Y\0" /* 44929 */
	"MSAA8_X\0" /* 44937 */
	"MSAA8_Y\0" /* 44945 */
	"MSAA16_X\0" /* 44953 */
	"MSAA16_Y\0" /* 44962 */
	"NUM_PIPES\0" /* 44971 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 44981 */
	"BANK_INTERLEAVE_SIZE\0" /* 45007 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 45028 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 45052 */
	"NUM_GPUS_GFX6\0" /* 45076 */
	"MULTI_GPU_TILE_SIZE\0" /* 45090 */
	"ROW_SIZE\0" /* 45110 */
	"NUM_LOWER_PIPES\0" /* 45119 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 45135 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 45166 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 45194 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 45223 */
	"MICRO_TILE_MODE\0" /* 45252 */
	"ARRAY_LINEAR_GENERAL\0" /* 45268, 45274 */
	"ARRAY_LINEAR_ALIGNED\0" /* 45289 */
	"ARRAY_1D_TILED_THIN1\0" /* 45310 */
	"ARRAY_1D_TILED_THICK\0" /* 45331 */
	"ARRAY_2D_TILED_THIN1\0" /* 45352 */
	"ARRAY_2D_TILED_THICK\0" /* 45373 */
	"ARRAY_2D_TILED_XTHICK\0" /* 45394 */
	"ARRAY_3D_TILED_THIN1\0" /* 45416 */
	"ARRAY_3D_TILED_THICK\0" /* 45437 */
	"ARRAY_3D_TILED_XTHICK\0" /* 45458 */
	"ARRAY_POWER_SAVE\0" /* 45480 */
	"ARRAY_MODE\0" /* 45497 */
	"ADDR_SURF_P2\0" /* 45508 */
	"ADDR_SURF_P2_RESERVED0\0" /* 45521 */
	"ADDR_SURF_P2_RESERVED1\0" /* 45544 */
	"ADDR_SURF_P2_RESERVED2\0" /* 45567, 45580 */
	"X_ADDR_SURF_P4_8X16\0" /* 45590 */
	"X_ADDR_SURF_P4_16X16\0" /* 45610 */
	"X_ADDR_SURF_P4_16X32\0" /* 45631 */
	"X_ADDR_SURF_P4_32X32\0" /* 45652 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 45673 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 45699 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 45725 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 45751 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 45778 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 45805 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 45832 */
	"PIPE_CONFIG\0" /* 45859 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 45871 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 45896 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 45922 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 45948 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 45974 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 45999 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 46024 */
	"TILE_SPLIT\0" /* 46049 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 46060 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 46083 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 46106 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 46129 */
	"BANK_WIDTH\0" /* 46152 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 46163 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 46187 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 46211 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 46235 */
	"BANK_HEIGHT\0" /* 46259 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 46271 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 46296 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 46321 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 46346 */
	"MACRO_TILE_ASPECT\0" /* 46371 */
	"ADDR_SURF_2_BANK\0" /* 46389 */
	"ADDR_SURF_4_BANK\0" /* 46406 */
	"ADDR_SURF_8_BANK\0" /* 46423 */
	"ADDR_SURF_16_BANK\0" /* 46440 */
	"NUM_BANKS\0" /* 46458 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 46468 */
	"MICRO_TILE_MODE_NEW\0" /* 46499 */
	"SAMPLE_SPLIT\0" /* 46519 */
	"MEM_BASE\0" /* 46532 */
	"WAVE_LIMIT\0" /* 46541 */
	"LOCK_LOW_THRESHOLD\0" /* 46552 */
	"VGPRS\0" /* 46571 */
	"SGPRS\0" /* 46577 */
	"FP_32_DENORMS\0" /* 46583 */
	"FP_64_DENORMS\0" /* 46597 */
	"FP_ALL_DENORMS\0" /* 46611 */
	"FLOAT_MODE\0" /* 46626 */
	"PRIV\0" /* 46637 */
	"DX10_CLAMP\0" /* 46642 */
	"DEBUG_MODE\0" /* 46653 */
	"IEEE_MODE\0" /* 46664 */
	"CU_GROUP_DISABLE\0" /* 46674 */
	"CACHE_CTL\0" /* 46691 */
	"CDBG_USER\0" /* 46701 */
	"SCRATCH_EN\0" /* 46711 */
	"USER_SGPR\0" /* 46722 */
	"TRAP_PRESENT\0" /* 46732 */
	"WAVE_CNT_EN\0" /* 46745 */
	"EXTRA_LDS_SIZE\0" /* 46757, 46763 */
	"EXCP_EN_SI\0" /* 46772 */
	"EXCP_EN\0" /* 46783 */
	"VGPR_COMP_CNT\0" /* 46791 */
	"CU_GROUP_ENABLE\0" /* 46805 */
	"OC_LDS_EN\0" /* 46821 */
	"SO_BASE0_EN\0" /* 46831 */
	"SO_BASE1_EN\0" /* 46843 */
	"SO_BASE2_EN\0" /* 46855 */
	"SO_BASE3_EN\0" /* 46867 */
	"SO_EN\0" /* 46879 */
	"DISPATCH_DRAW_EN\0" /* 46885 */
	"GROUP_FIFO_DEPTH\0" /* 46902 */
	"TG_SIZE_EN\0" /* 46919 */
	"EXCP_EN_CIK_VI\0" /* 46930 */
	"COMPUTE_SHADER_EN\0" /* 46945 */
	"PARTIAL_TG_EN\0" /* 46963 */
	"FORCE_START_AT_000\0" /* 46977 */
	"ORDERED_APPEND_ENBL\0" /* 46996 */
	"ORDERED_APPEND_MODE\0" /* 47016 */
	"USE_THREAD_DIMENSIONS\0" /* 47036 */
	"ORDER_MODE\0" /* 47058 */
	"DISPATCH_CACHE_CNTL\0" /* 47069 */
	"SCALAR_L1_INV_VOL\0" /* 47089, 47103 */
	"VECTOR_L1_INV_VOL\0" /* 47107 */
	"DATA_ATC\0" /* 47125 */
	"RESTORE\0" /* 47134 */
	"NUM_THREAD_FULL\0" /* 47142 */
	"NUM_THREAD_PARTIAL\0" /* 47158 */
	"INST_ATC\0" /* 47177 */
	"BULKY\0" /* 47186 */
	"TGID_X_EN\0" /* 47192 */
	"TGID_Y_EN\0" /* 47202 */
	"TGID_Z_EN\0" /* 47212 */
	"TIDIG_COMP_CNT\0" /* 47222 */
	"EXCP_EN_MSB\0" /* 47237 */
	"WAVES_PER_SH_SI\0" /* 47249 */
	"WAVES_PER_SH\0" /* 47265 */
	"TG_PER_CU\0" /* 47278 */
	"LOCK_THRESHOLD\0" /* 47288 */
	"SIMD_DEST_CNTL\0" /* 47303 */
	"FORCE_SIMD_DIST\0" /* 47318 */
	"CU_GROUP_COUNT\0" /* 47334 */
	"SH0_CU_EN\0" /* 47349 */
	"SH1_CU_EN\0" /* 47359 */
	"WAVES\0" /* 47369 */
	"WAVESIZE\0" /* 47375 */
	"SEND_SEID\0" /* 47384 */
	"RESERVED3\0" /* 47394 */
	"RESERVED4\0" /* 47404 */
	"WAVE_ID_BASE\0" /* 47414 */
	"PAYLOAD\0" /* 47427 */
	"IS_EVENT\0" /* 47435 */
	"IS_STATE\0" /* 47444 */
	"PERF_SEL\0" /* 47453 */
	"PERF_SEL1\0" /* 47462 */
	"CNTR_MODE\0" /* 47472 */
	"PERF_SEL2\0" /* 47482 */
	"PERF_SEL3\0" /* 47492 */
	"DISABLE_AND_RESET\0" /* 47502 */
	"START_COUNTING\0" /* 47520 */
	"STOP_COUNTING\0" /* 47535 */
	"PERFMON_STATE\0" /* 47549 */
	"SPM_PERFMON_STATE\0" /* 47563 */
	"PERFMON_ENABLE_MODE\0" /* 47581 */
	"PERFMON_SAMPLE_ENABLE\0" /* 47601 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 47623 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 47650 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 47677 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 47704 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 47730 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 47756 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 47783 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 47809 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 47835 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 47863 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 47889 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 47915 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 47941 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 47967 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 47994 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 48021 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 48048 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 48074 */
	"PERF_MODE\0" /* 48100 */
	"PERF_MODE1\0" /* 48110 */
	"PERF_MODE3\0" /* 48121 */
	"PERF_MODE2\0" /* 48132 */
	"PERF_SEID_IGNORE_MASK\0" /* 48143 */
	"BIN0_MIN\0" /* 48165 */
	"BIN0_MAX\0" /* 48174 */
	"BIN1_MIN\0" /* 48183 */
	"BIN1_MAX\0" /* 48192 */
	"BIN2_MIN\0" /* 48201 */
	"BIN2_MAX\0" /* 48210 */
	"BIN3_MIN\0" /* 48219 */
	"BIN3_MAX\0" /* 48228 */
	"SQC_BANK_MASK\0" /* 48237 */
	"SQC_CLIENT_MASK\0" /* 48251 */
	"SPM_MODE\0" /* 48267 */
	"SIMD_MASK\0" /* 48276 */
	"PS_EN\0" /* 48286 */
	"VS_EN\0" /* 48292 */
	"GS_EN\0" /* 48298 */
	"HS_EN\0" /* 48304 */
	"LS_EN\0" /* 48310 */
	"CS_EN\0" /* 48316 */
	"CNTR_RATE\0" /* 48322 */
	"DISABLE_FLUSH\0" /* 48332 */
	"SH0_MASK\0" /* 48346 */
	"SH1_MASK\0" /* 48355 */
	"FORCE_EN\0" /* 48364 */
	"PERFCOUNTER_SELECT1\0" /* 48373 */
	"PERFCOUNTER_SELECT2\0" /* 48393 */
	"PERFCOUNTER_SELECT3\0" /* 48413 */
	"OP_FILTER_ENABLE\0" /* 48433 */
	"OP_FILTER_SEL\0" /* 48450 */
	"FORMAT_FILTER_ENABLE\0" /* 48464 */
	"FORMAT_FILTER_SEL\0" /* 48485 */
	"CLEAR_FILTER_ENABLE\0" /* 48503 */
	"CLEAR_FILTER_SEL\0" /* 48523 */
	"MRT_FILTER_ENABLE\0" /* 48540 */
	"MRT_FILTER_SEL\0" /* 48558 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 48573 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 48599 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 48622 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 48650 */
	"DEPTH_CLEAR_ENABLE\0" /* 48675 */
	"STENCIL_CLEAR_ENABLE\0" /* 48694 */
	"DEPTH_COPY\0" /* 48715 */
	"STENCIL_COPY\0" /* 48726 */
	"RESUMMARIZE_ENABLE\0" /* 48739 */
	"STENCIL_COMPRESS_DISABLE\0" /* 48758 */
	"DEPTH_COMPRESS_DISABLE\0" /* 48783 */
	"COPY_CENTROID\0" /* 48806 */
	"COPY_SAMPLE\0" /* 48820 */
	"DECOMPRESS_ENABLE\0" /* 48832 */
	"ZPASS_INCREMENT_DISABLE\0" /* 48850 */
	"PERFECT_ZPASS_COUNTS\0" /* 48874 */
	"SAMPLE_RATE\0" /* 48895 */
	"ZPASS_ENABLE\0" /* 48907 */
	"ZFAIL_ENABLE\0" /* 48920 */
	"SFAIL_ENABLE\0" /* 48933 */
	"DBFAIL_ENABLE\0" /* 48946 */
	"SLICE_EVEN_ENABLE\0" /* 48960 */
	"SLICE_ODD_ENABLE\0" /* 48978 */
	"SLICE_START\0" /* 48995 */
	"SLICE_MAX\0" /* 49007 */
	"Z_READ_ONLY\0" /* 49017 */
	"STENCIL_READ_ONLY\0" /* 49029 */
	"FORCE_OFF\0" /* 49047 */
	"FORCE_ENABLE\0" /* 49057 */
	"FORCE_DISABLE\0" /* 49070 */
	"FORCE_RESERVED\0" /* 49084 */
	"FORCE_HIZ_ENABLE\0" /* 49099, 49107 */
	"FORCE_HIS_ENABLE0\0" /* 49116, 49126 */
	"FORCE_HIS_ENABLE1\0" /* 49134, 49144 */
	"FORCE_SHADER_Z_ORDER\0" /* 49152, 49165 */
	"FAST_Z_DISABLE\0" /* 49173 */
	"FAST_STENCIL_DISABLE\0" /* 49188 */
	"NOOP_CULL_DISABLE\0" /* 49209 */
	"FORCE_COLOR_KILL\0" /* 49227 */
	"FORCE_Z_READ\0" /* 49244 */
	"FORCE_STENCIL_READ\0" /* 49257 */
	"FORCE_FULL_Z_RANGE\0" /* 49276 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 49295 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 49319 */
	"IGNORE_SC_ZRANGE\0" /* 49342 */
	"DISABLE_FULLY_COVERED\0" /* 49359 */
	"FORCE_SUMM_OFF\0" /* 49381 */
	"FORCE_SUMM_MINZ\0" /* 49396 */
	"FORCE_SUMM_MAXZ\0" /* 49412 */
	"FORCE_SUMM_BOTH\0" /* 49428 */
	"FORCE_Z_LIMIT_SUMM\0" /* 49444 */
	"MAX_TILES_IN_DTT\0" /* 49463 */
	"DISABLE_TILE_RATE_TILES\0" /* 49480 */
	"FORCE_Z_DIRTY\0" /* 49504, 49512 */
	"FORCE_STENCIL_DIRTY\0" /* 49518 */
	"FORCE_Z_VALID\0" /* 49538 */
	"FORCE_STENCIL_VALID\0" /* 49552 */
	"PRESERVE_COMPRESSION\0" /* 49572, 49581 */
	"PSLC_AUTO\0" /* 49593 */
	"PSLC_ON_HANG_ONLY\0" /* 49603 */
	"PSLC_ASAP\0" /* 49621 */
	"PSLC_COUNTDOWN\0" /* 49631 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 49646 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 49675 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 49706 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 49742 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 49777 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 49805 */
	"DISABLE_REG_SNOOP\0" /* 49827 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 49845 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 49877 */
	"HIZ_ZFUNC\0" /* 49903, 49907 */
	"HIS_SFUNC_FF\0" /* 49913 */
	"HIS_SFUNC_BF\0" /* 49926 */
	"PRESERVE_ZRANGE\0" /* 49939 */
	"PRESERVE_SRESULTS\0" /* 49955 */
	"DISABLE_FAST_PASS\0" /* 49973 */
	"TL_X\0" /* 49991 */
	"TL_Y\0" /* 49996 */
	"BR_X\0" /* 50001 */
	"BR_Y\0" /* 50006 */
	"ADDR5_SWIZZLE_MASK\0" /* 50011 */
	"ARRAY_PRT_TILED_THIN1\0" /* 50030 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 50052 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 50077 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 50104 */
	"Z_INVALID\0" /* 50132 */
	"Z_16\0" /* 50142 */
	"Z_24\0" /* 50147 */
	"Z_32_FLOAT\0" /* 50152 */
	"NUM_SAMPLES\0" /* 50163 */
	"TILE_MODE_INDEX\0" /* 50175 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 50191 */
	"ALLOW_EXPCLEAR\0" /* 50215 */
	"READ_SIZE\0" /* 50230 */
	"TILE_SURFACE_ENABLE\0" /* 50240 */
	"CLEAR_DISALLOWED\0" /* 50260 */
	"ZRANGE_PRECISION\0" /* 50277 */
	"STENCIL_INVALID\0" /* 50294 */
	"STENCIL_8\0" /* 50310 */
	"TILE_STENCIL_DISABLE\0" /* 50320 */
	"PITCH_TILE_MAX\0" /* 50341, 50347 */
	"HEIGHT_TILE_MAX\0" /* 50356 */
	"SLICE_TILE_MAX\0" /* 50372 */
	"WINDOW_X_OFFSET\0" /* 50387 */
	"WINDOW_Y_OFFSET\0" /* 50403, 50410 */
	"WINDOW_OFFSET_DISABLE\0" /* 50419 */
	"IN_20\0" /* 50441 */
	"IN_21\0" /* 50447 */
	"IN_210\0" /* 50453 */
	"IN_30\0" /* 50460 */
	"IN_31\0" /* 50466 */
	"IN_310\0" /* 50472 */
	"IN_320\0" /* 50479 */
	"IN_321\0" /* 50486 */
	"IN_3210\0" /* 50493 */
	"CLIP_RULE\0" /* 50501 */
	"ER_TRI\0" /* 50511 */
	"ER_RECT\0" /* 50518 */
	"ER_LINE_LR\0" /* 50526 */
	"ER_LINE_RL\0" /* 50537 */
	"ER_LINE_TB\0" /* 50548 */
	"ER_LINE_BT\0" /* 50559 */
	"HW_SCREEN_OFFSET_X\0" /* 50570 */
	"HW_SCREEN_OFFSET_Y\0" /* 50589 */
	"TARGET0_ENABLE\0" /* 50608 */
	"TARGET1_ENABLE\0" /* 50623 */
	"TARGET2_ENABLE\0" /* 50638 */
	"TARGET3_ENABLE\0" /* 50653 */
	"TARGET4_ENABLE\0" /* 50668 */
	"TARGET5_ENABLE\0" /* 50683 */
	"TARGET6_ENABLE\0" /* 50698 */
	"TARGET7_ENABLE\0" /* 50713 */
	"OUTPUT0_ENABLE\0" /* 50728 */
	"OUTPUT1_ENABLE\0" /* 50743 */
	"OUTPUT2_ENABLE\0" /* 50758 */
	"OUTPUT3_ENABLE\0" /* 50773 */
	"OUTPUT4_ENABLE\0" /* 50788 */
	"OUTPUT5_ENABLE\0" /* 50803 */
	"OUTPUT6_ENABLE\0" /* 50818 */
	"OUTPUT7_ENABLE\0" /* 50833 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 50848 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 50871 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 50894 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 50917 */
	"RB_MAP_PKR0\0" /* 50940 */
	"RB_MAP_PKR1\0" /* 50952 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 50964 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 50989 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 51014 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 51039 */
	"RB_XSEL2\0" /* 51064 */
	"RB_XSEL\0" /* 51073 */
	"RB_YSEL\0" /* 51081 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 51089 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 51113 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 51137 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 51161 */
	"PKR_MAP\0" /* 51185 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 51193 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 51218 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 51243 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 51268 */
	"PKR_XSEL\0" /* 51293 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 51302 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 51327 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 51352 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 51377 */
	"PKR_YSEL\0" /* 51402 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 51411 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 51437 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 51463 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 51489 */
	"PKR_XSEL2\0" /* 51515 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 51525 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 51548 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 51571 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 51594 */
	"SC_MAP\0" /* 51617 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 51624 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 51658 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 51693 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 51728 */
	"SC_XSEL\0" /* 51763 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 51771 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 51805 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 51840 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 51875 */
	"SC_YSEL\0" /* 51910 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 51918 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 51941 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 51964 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 51987 */
	"SE_MAP\0" /* 52010 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 52017 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 52051 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 52086 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 52121 */
	"SE_XSEL_GFX6\0" /* 52156 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 52169 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 52203 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 52238 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 52273 */
	"SE_YSEL_GFX6\0" /* 52308 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 52321 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 52349 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 52377 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 52405 */
	"SE_PAIR_MAP\0" /* 52433 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 52445 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 52484 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 52524 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 52564 */
	"SE_PAIR_XSEL_GFX6\0" /* 52604 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 52622 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 52661 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 52701 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 52741 */
	"SE_PAIR_YSEL_GFX6\0" /* 52781 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 52799 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 52826 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 52865 */
	"STENCIL_KEEP\0" /* 52894 */
	"STENCIL_ZERO\0" /* 52907 */
	"STENCIL_ONES\0" /* 52920 */
	"STENCIL_REPLACE_TEST\0" /* 52933 */
	"STENCIL_REPLACE_OP\0" /* 52954 */
	"STENCIL_ADD_CLAMP\0" /* 52973 */
	"STENCIL_SUB_CLAMP\0" /* 52991 */
	"STENCIL_INVERT\0" /* 53009 */
	"STENCIL_ADD_WRAP\0" /* 53024 */
	"STENCIL_SUB_WRAP\0" /* 53041 */
	"STENCIL_AND\0" /* 53058 */
	"STENCIL_OR\0" /* 53070 */
	"STENCIL_XOR\0" /* 53081 */
	"STENCIL_NAND\0" /* 53093 */
	"STENCIL_NOR\0" /* 53106 */
	"STENCIL_XNOR\0" /* 53118 */
	"STENCILFAIL\0" /* 53131 */
	"STENCILZPASS\0" /* 53143 */
	"STENCILZFAIL\0" /* 53156 */
	"STENCILFAIL_BF\0" /* 53169 */
	"STENCILZPASS_BF\0" /* 53184 */
	"STENCILZFAIL_BF\0" /* 53200 */
	"STENCILTESTVAL\0" /* 53216 */
	"STENCILMASK\0" /* 53231 */
	"STENCILWRITEMASK\0" /* 53243 */
	"STENCILOPVAL\0" /* 53260 */
	"STENCILTESTVAL_BF\0" /* 53273 */
	"STENCILMASK_BF\0" /* 53291 */
	"STENCILWRITEMASK_BF\0" /* 53306 */
	"STENCILOPVAL_BF\0" /* 53326 */
	"X_0_0F\0" /* 53342 */
	"DEFAULT_VAL\0" /* 53349 */
	"FLAT_SHADE\0" /* 53361 */
	"CYL_WRAP\0" /* 53372 */
	"PT_SPRITE_TEX\0" /* 53381 */
	"DUP\0" /* 53395 */
	"FP16_INTERP_MODE\0" /* 53399 */
	"USE_DEFAULT_ATTR1\0" /* 53416 */
	"DEFAULT_VAL_ATTR1\0" /* 53434 */
	"PT_SPRITE_TEX_ATTR1\0" /* 53452 */
	"ATTR0_VALID\0" /* 53472 */
	"ATTR1_VALID\0" /* 53484 */
	"VS_EXPORT_COUNT\0" /* 53496 */
	"VS_HALF_PACK\0" /* 53512 */
	"VS_EXPORTS_FOG\0" /* 53525 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 53540 */
	"PERSP_SAMPLE_ENA\0" /* 53560 */
	"PERSP_CENTER_ENA\0" /* 53577 */
	"PERSP_CENTROID_ENA\0" /* 53594 */
	"PERSP_PULL_MODEL_ENA\0" /* 53613 */
	"LINEAR_SAMPLE_ENA\0" /* 53634 */
	"LINEAR_CENTER_ENA\0" /* 53652 */
	"LINEAR_CENTROID_ENA\0" /* 53670 */
	"LINE_STIPPLE_TEX_ENA\0" /* 53690 */
	"POS_X_FLOAT_ENA\0" /* 53711 */
	"POS_Y_FLOAT_ENA\0" /* 53727 */
	"POS_Z_FLOAT_ENA\0" /* 53743 */
	"POS_W_FLOAT_ENA\0" /* 53759 */
	"FRONT_FACE_ENA\0" /* 53775 */
	"ANCILLARY_ENA\0" /* 53790 */
	"SAMPLE_COVERAGE_ENA\0" /* 53804 */
	"POS_FIXED_PT_ENA\0" /* 53824 */
	"FLAT_SHADE_ENA\0" /* 53841 */
	"PNT_SPRITE_ENA\0" /* 53856 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 53871 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 53892 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 53913 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 53934 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 53955 */
	"PNT_SPRITE_OVRD_X\0" /* 53979 */
	"PNT_SPRITE_OVRD_Y\0" /* 53997 */
	"PNT_SPRITE_OVRD_Z\0" /* 54015 */
	"PNT_SPRITE_OVRD_W\0" /* 54033 */
	"PNT_SPRITE_TOP_1\0" /* 54051 */
	"NUM_INTERP\0" /* 54068 */
	"PARAM_GEN\0" /* 54079 */
	"FOG_ADDR\0" /* 54089 */
	"BC_OPTIMIZE_DISABLE\0" /* 54098 */
	"PASS_FOG_THROUGH_PS\0" /* 54118 */
	"PERSP_CENTER_CNTL\0" /* 54138 */
	"PERSP_CENTROID_CNTL\0" /* 54156 */
	"LINEAR_CENTER_CNTL\0" /* 54176 */
	"LINEAR_CENTROID_CNTL\0" /* 54195 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 54216 */
	"POS_FLOAT_LOCATION\0" /* 54265 */
	"POS_FLOAT_ULC\0" /* 54284 */
	"FRONT_FACE_ALL_BITS\0" /* 54298 */
	"NUM_PS_WAVES\0" /* 54318 */
	"NUM_VS_WAVES\0" /* 54331 */
	"NUM_GS_WAVES\0" /* 54344 */
	"NUM_ES_WAVES\0" /* 54357 */
	"NUM_HS_WAVES\0" /* 54370 */
	"NUM_LS_WAVES\0" /* 54383 */
	"SPI_SHADER_NONE\0" /* 54396 */
	"SPI_SHADER_1COMP\0" /* 54412 */
	"SPI_SHADER_2COMP\0" /* 54429 */
	"SPI_SHADER_4COMPRESS\0" /* 54446 */
	"SPI_SHADER_4COMP\0" /* 54467 */
	"POS0_EXPORT_FORMAT\0" /* 54484 */
	"POS1_EXPORT_FORMAT\0" /* 54503 */
	"POS2_EXPORT_FORMAT\0" /* 54522 */
	"POS3_EXPORT_FORMAT\0" /* 54541 */
	"SPI_SHADER_ZERO\0" /* 54560 */
	"SPI_SHADER_32_R\0" /* 54576 */
	"SPI_SHADER_32_GR\0" /* 54592 */
	"SPI_SHADER_32_AR\0" /* 54609 */
	"SPI_SHADER_FP16_ABGR\0" /* 54626 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 54647 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 54671 */
	"SPI_SHADER_UINT16_ABGR\0" /* 54695 */
	"SPI_SHADER_SINT16_ABGR\0" /* 54718 */
	"SPI_SHADER_32_ABGR\0" /* 54741 */
	"Z_EXPORT_FORMAT\0" /* 54760 */
	"COL0_EXPORT_FORMAT\0" /* 54776 */
	"COL1_EXPORT_FORMAT\0" /* 54795 */
	"COL2_EXPORT_FORMAT\0" /* 54814 */
	"COL3_EXPORT_FORMAT\0" /* 54833 */
	"COL4_EXPORT_FORMAT\0" /* 54852 */
	"COL5_EXPORT_FORMAT\0" /* 54871 */
	"COL6_EXPORT_FORMAT\0" /* 54890 */
	"COL7_EXPORT_FORMAT\0" /* 54909 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 54928 */
	"SX_RT_EXPORT_32_R\0" /* 54955 */
	"SX_RT_EXPORT_32_A\0" /* 54973 */
	"SX_RT_EXPORT_10_11_11\0" /* 54991 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 55013 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 55037 */
	"SX_RT_EXPORT_5_6_5\0" /* 55058 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 55077 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 55098 */
	"SX_RT_EXPORT_16_16_GR\0" /* 55119 */
	"SX_RT_EXPORT_16_16_AR\0" /* 55141 */
	"MRT0\0" /* 55163 */
	"MRT1\0" /* 55168 */
	"MRT2\0" /* 55173 */
	"MRT3\0" /* 55178 */
	"MRT4\0" /* 55183 */
	"MRT5\0" /* 55188 */
	"MRT6\0" /* 55193 */
	"MRT7\0" /* 55198 */
	"EXACT\0" /* 55203 */
	"11BIT_FORMAT\0" /* 55209 */
	"10BIT_FORMAT\0" /* 55222 */
	"8BIT_FORMAT\0" /* 55235 */
	"6BIT_FORMAT\0" /* 55247 */
	"5BIT_FORMAT\0" /* 55259 */
	"4BIT_FORMAT\0" /* 55271 */
	"MRT0_EPSILON\0" /* 55283 */
	"MRT1_EPSILON\0" /* 55296 */
	"MRT2_EPSILON\0" /* 55309 */
	"MRT3_EPSILON\0" /* 55322 */
	"MRT4_EPSILON\0" /* 55335 */
	"MRT5_EPSILON\0" /* 55348 */
	"MRT6_EPSILON\0" /* 55361 */
	"MRT7_EPSILON\0" /* 55374 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 55387 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 55410 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 55433 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 55456 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 55479 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 55502 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 55525 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 55548 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 55571 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 55594 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 55617 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 55640 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 55663 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 55686 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 55709 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 55732 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 55755 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 55778 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 55813 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 55848 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 55880 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 55912 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 55944 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 55976 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 56010 */
	"COLOR_SRC_OPT\0" /* 56046 */
	"COLOR_DST_OPT\0" /* 56060 */
	"OPT_COMB_NONE\0" /* 56074 */
	"OPT_COMB_ADD\0" /* 56088 */
	"OPT_COMB_SUBTRACT\0" /* 56101 */
	"OPT_COMB_MIN\0" /* 56119 */
	"OPT_COMB_MAX\0" /* 56132 */
	"OPT_COMB_REVSUBTRACT\0" /* 56145 */
	"OPT_COMB_BLEND_DISABLED\0" /* 56166 */
	"OPT_COMB_SAFE_ADD\0" /* 56190 */
	"COLOR_COMB_FCN\0" /* 56208 */
	"ALPHA_SRC_OPT\0" /* 56223 */
	"ALPHA_DST_OPT\0" /* 56237 */
	"ALPHA_COMB_FCN\0" /* 56251 */
	"BLEND_ZERO\0" /* 56266 */
	"BLEND_ONE\0" /* 56277 */
	"BLEND_SRC_COLOR\0" /* 56287 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 56303 */
	"BLEND_SRC_ALPHA\0" /* 56329 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 56345 */
	"BLEND_DST_ALPHA\0" /* 56371 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 56387 */
	"BLEND_DST_COLOR\0" /* 56413 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 56429 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 56455 */
	"BLEND_CONSTANT_COLOR\0" /* 56480 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 56501 */
	"BLEND_SRC1_COLOR\0" /* 56532 */
	"BLEND_INV_SRC1_COLOR\0" /* 56549 */
	"BLEND_SRC1_ALPHA\0" /* 56570 */
	"BLEND_INV_SRC1_ALPHA\0" /* 56587 */
	"BLEND_CONSTANT_ALPHA\0" /* 56608 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 56629 */
	"COLOR_SRCBLEND\0" /* 56660 */
	"COMB_DST_PLUS_SRC\0" /* 56675 */
	"COMB_SRC_MINUS_DST\0" /* 56693 */
	"COMB_MIN_DST_SRC\0" /* 56712 */
	"COMB_MAX_DST_SRC\0" /* 56729 */
	"COMB_DST_MINUS_SRC\0" /* 56746 */
	"COLOR_DESTBLEND\0" /* 56765 */
	"ALPHA_SRCBLEND\0" /* 56781 */
	"ALPHA_DESTBLEND\0" /* 56796 */
	"SEPARATE_ALPHA_BLEND\0" /* 56812 */
	"DISABLE_ROP3\0" /* 56833, 56841 */
	"SRC_STATE_ID\0" /* 56846 */
	"BASE_ADDR_GFX6\0" /* 56859 */
	"DI_SRC_SEL_DMA\0" /* 56874 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 56889 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 56910 */
	"DI_SRC_SEL_RESERVED\0" /* 56932 */
	"SOURCE_SELECT\0" /* 56952 */
	"DI_MAJOR_MODE_0\0" /* 56966 */
	"DI_MAJOR_MODE_1\0" /* 56982 */
	"MAJOR_MODE\0" /* 56998 */
	"NOT_EOP\0" /* 57009 */
	"USE_OPAQUE\0" /* 57017 */
	"ADDRESS_LOW\0" /* 57028 */
	"STENCIL_ENABLE\0" /* 57040 */
	"Z_WRITE_ENABLE\0" /* 57055 */
	"DEPTH_BOUNDS_ENABLE\0" /* 57070 */
	"FRAG_NEVER\0" /* 57090 */
	"FRAG_LESS\0" /* 57101 */
	"FRAG_EQUAL\0" /* 57111 */
	"FRAG_LEQUAL\0" /* 57122 */
	"FRAG_GREATER\0" /* 57134 */
	"FRAG_NOTEQUAL\0" /* 57147 */
	"FRAG_GEQUAL\0" /* 57161 */
	"FRAG_ALWAYS\0" /* 57173 */
	"BACKFACE_ENABLE\0" /* 57185 */
	"REF_NEVER\0" /* 57201 */
	"REF_LESS\0" /* 57211 */
	"REF_EQUAL\0" /* 57220 */
	"REF_LEQUAL\0" /* 57230 */
	"REF_GREATER\0" /* 57241 */
	"REF_NOTEQUAL\0" /* 57253 */
	"REF_GEQUAL\0" /* 57266 */
	"REF_ALWAYS\0" /* 57277 */
	"STENCILFUNC\0" /* 57288 */
	"STENCILFUNC_BF\0" /* 57300 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 57315 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 57349 */
	"MAX_ANCHOR_SAMPLES\0" /* 57384 */
	"PS_ITER_SAMPLES\0" /* 57403 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 57419 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 57443 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 57469 */
	"INCOHERENT_EQAA_READS\0" /* 57496 */
	"INTERPOLATE_COMP_Z\0" /* 57518 */
	"INTERPOLATE_SRC_Z\0" /* 57537 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 57555 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 57582 */
	"OVERRASTERIZATION_AMOUNT\0" /* 57609 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 57634 */
	"DISABLE_DUAL_QUAD\0" /* 57665 */
	"DEGAMMA_ENABLE\0" /* 57683 */
	"CB_DISABLE\0" /* 57698 */
	"CB_NORMAL\0" /* 57709 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 57719, 57732 */
	"CB_RESOLVE\0" /* 57743 */
	"CB_FMASK_DECOMPRESS\0" /* 57754 */
	"CB_DCC_DECOMPRESS\0" /* 57774 */
	"ROP3_CLEAR\0" /* 57792 */
	"ROP3_NOR\0" /* 57803 */
	"ROP3_AND_INVERTED\0" /* 57812 */
	"ROP3_COPY_INVERTED\0" /* 57830 */
	"ROP3_AND_REVERSE\0" /* 57849 */
	"ROP3_INVERT\0" /* 57866 */
	"ROP3_XOR\0" /* 57878 */
	"ROP3_NAND\0" /* 57887 */
	"ROP3_AND\0" /* 57897 */
	"ROP3_EQUIVALENT\0" /* 57906 */
	"ROP3_NO_OP\0" /* 57922 */
	"ROP3_OR_INVERTED\0" /* 57933 */
	"ROP3_COPY\0" /* 57950 */
	"ROP3_OR_REVERSE\0" /* 57960 */
	"ROP3_OR\0" /* 57976 */
	"ROP3_SET\0" /* 57984 */
	"Z_EXPORT_ENABLE\0" /* 57993 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 58009 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 58040 */
	"LATE_Z\0" /* 58069 */
	"EARLY_Z_THEN_LATE_Z\0" /* 58076 */
	"RE_Z\0" /* 58096 */
	"EARLY_Z_THEN_RE_Z\0" /* 58101 */
	"KILL_ENABLE\0" /* 58119 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 58131 */
	"MASK_EXPORT_ENABLE\0" /* 58155 */
	"EXEC_ON_HIER_FAIL\0" /* 58174 */
	"EXEC_ON_NOOP\0" /* 58192 */
	"ALPHA_TO_MASK_DISABLE\0" /* 58205 */
	"DEPTH_BEFORE_SHADER\0" /* 58227 */
	"EXPORT_ANY_Z\0" /* 58247 */
	"EXPORT_LESS_THAN_Z\0" /* 58260 */
	"EXPORT_GREATER_THAN_Z\0" /* 58279 */
	"EXPORT_RESERVED\0" /* 58301 */
	"CONSERVATIVE_Z_EXPORT\0" /* 58317 */
	"DUAL_QUAD_DISABLE\0" /* 58339 */
	"UCP_ENA_0\0" /* 58357 */
	"UCP_ENA_1\0" /* 58367 */
	"UCP_ENA_2\0" /* 58377 */
	"UCP_ENA_3\0" /* 58387 */
	"UCP_ENA_4\0" /* 58397 */
	"UCP_ENA_5\0" /* 58407 */
	"PS_UCP_Y_SCALE_NEG\0" /* 58417 */
	"PS_UCP_MODE\0" /* 58436 */
	"CLIP_DISABLE\0" /* 58448 */
	"UCP_CULL_ONLY_ENA\0" /* 58461 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 58479 */
	"DX_CLIP_SPACE_DEF\0" /* 58502 */
	"DIS_CLIP_ERR_DETECT\0" /* 58520 */
	"VTX_KILL_OR\0" /* 58540 */
	"DX_RASTERIZATION_KILL\0" /* 58552 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 58574 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 58598 */
	"ZCLIP_NEAR_DISABLE\0" /* 58624 */
	"ZCLIP_FAR_DISABLE\0" /* 58643 */
	"CULL_FRONT\0" /* 58661 */
	"CULL_BACK\0" /* 58672 */
	"X_DISABLE_POLY_MODE\0" /* 58682, 58692 */
	"X_DUAL_MODE\0" /* 58702 */
	"X_DRAW_POINTS\0" /* 58714 */
	"X_DRAW_LINES\0" /* 58728 */
	"X_DRAW_TRIANGLES\0" /* 58741 */
	"POLYMODE_FRONT_PTYPE\0" /* 58758 */
	"POLYMODE_BACK_PTYPE\0" /* 58779 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 58799 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 58824 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 58848 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 58872 */
	"PROVOKING_VTX_LAST\0" /* 58897 */
	"PERSP_CORR_DIS\0" /* 58916 */
	"MULTI_PRIM_IB_ENA\0" /* 58931 */
	"VPORT_X_SCALE_ENA\0" /* 58949 */
	"VPORT_X_OFFSET_ENA\0" /* 58967 */
	"VPORT_Y_SCALE_ENA\0" /* 58986 */
	"VPORT_Y_OFFSET_ENA\0" /* 59004 */
	"VPORT_Z_SCALE_ENA\0" /* 59023 */
	"VPORT_Z_OFFSET_ENA\0" /* 59041 */
	"VTX_XY_FMT\0" /* 59060 */
	"VTX_Z_FMT\0" /* 59071 */
	"VTX_W0_FMT\0" /* 59081 */
	"CLIP_DIST_ENA_0\0" /* 59092 */
	"CLIP_DIST_ENA_1\0" /* 59108 */
	"CLIP_DIST_ENA_2\0" /* 59124 */
	"CLIP_DIST_ENA_3\0" /* 59140 */
	"CLIP_DIST_ENA_4\0" /* 59156 */
	"CLIP_DIST_ENA_5\0" /* 59172 */
	"CLIP_DIST_ENA_6\0" /* 59188 */
	"CLIP_DIST_ENA_7\0" /* 59204 */
	"CULL_DIST_ENA_0\0" /* 59220 */
	"CULL_DIST_ENA_1\0" /* 59236 */
	"CULL_DIST_ENA_2\0" /* 59252 */
	"CULL_DIST_ENA_3\0" /* 59268 */
	"CULL_DIST_ENA_4\0" /* 59284 */
	"CULL_DIST_ENA_5\0" /* 59300 */
	"CULL_DIST_ENA_6\0" /* 59316 */
	"CULL_DIST_ENA_7\0" /* 59332 */
	"USE_VTX_POINT_SIZE\0" /* 59348 */
	"USE_VTX_EDGE_FLAG\0" /* 59367 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 59385 */
	"USE_VTX_VIEWPORT_INDX\0" /* 59412 */
	"USE_VTX_KILL_FLAG\0" /* 59434 */
	"VS_OUT_MISC_VEC_ENA\0" /* 59452 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 59472 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 59495 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 59518 */
	"USE_VTX_GS_CUT_FLAG\0" /* 59543 */
	"USE_VTX_LINE_WIDTH\0" /* 59563 */
	"VTE_XY_INF_DISCARD\0" /* 59582 */
	"VTE_Z_INF_DISCARD\0" /* 59601 */
	"VTE_W_INF_DISCARD\0" /* 59619 */
	"VTE_0XNANINF_IS_0\0" /* 59637 */
	"VTE_XY_NAN_RETAIN\0" /* 59655 */
	"VTE_Z_NAN_RETAIN\0" /* 59673 */
	"VTE_W_NAN_RETAIN\0" /* 59690 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 59707 */
	"VS_XY_NAN_TO_INF\0" /* 59728 */
	"VS_XY_INF_RETAIN\0" /* 59745 */
	"VS_Z_NAN_TO_INF\0" /* 59762 */
	"VS_Z_INF_RETAIN\0" /* 59778 */
	"VS_W_NAN_TO_INF\0" /* 59794 */
	"VS_W_INF_RETAIN\0" /* 59810 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 59826 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 59851 */
	"LINE_STIPPLE_RESET\0" /* 59871 */
	"EXPAND_FULL_LENGTH\0" /* 59890 */
	"FRACTIONAL_ACCUM\0" /* 59909 */
	"DIAMOND_ADJUST\0" /* 59926 */
	"TRIANGLE_FILTER_DISABLE\0" /* 59941 */
	"LINE_FILTER_DISABLE\0" /* 59965 */
	"POINT_FILTER_DISABLE\0" /* 59985 */
	"RECTANGLE_FILTER_DISABLE\0" /* 60006 */
	"TRIANGLE_EXPAND_ENA\0" /* 60031 */
	"LINE_EXPAND_ENA\0" /* 60051 */
	"POINT_EXPAND_ENA\0" /* 60067 */
	"RECTANGLE_EXPAND_ENA\0" /* 60084 */
	"PRIM_EXPAND_CONSTANT\0" /* 60105 */
	"XMAX_RIGHT_EXCLUSION\0" /* 60126 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 60147 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 60169 */
	"MIN_SIZE\0" /* 60194 */
	"LINE_PATTERN\0" /* 60203 */
	"REPEAT_COUNT\0" /* 60216 */
	"PATTERN_BIT_ORDER\0" /* 60229 */
	"AUTO_RESET_CNTL\0" /* 60247 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 60263 */
	"VGT_OUTPATH_TESS_EN\0" /* 60285 */
	"VGT_OUTPATH_PASSTHRU\0" /* 60305 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 60326 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 60347 */
	"PATH_SELECT\0" /* 60368 */
	"TESS_MODE\0" /* 60380 */
	"VGT_GRP_3D_POINT\0" /* 60390 */
	"VGT_GRP_3D_LINE\0" /* 60407 */
	"VGT_GRP_3D_TRI\0" /* 60423 */
	"VGT_GRP_3D_RECT\0" /* 60438 */
	"VGT_GRP_3D_QUAD\0" /* 60454 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 60470 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 60494 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 60518 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 60542 */
	"VGT_GRP_2D_FILL_RECT\0" /* 60566 */
	"VGT_GRP_2D_LINE\0" /* 60587 */
	"VGT_GRP_2D_TRI\0" /* 60603 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 60618 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 60642 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 60665 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 60689 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 60709 */
	"VGT_GRP_3D_PATCH\0" /* 60728 */
	"RETAIN_ORDER\0" /* 60745 */
	"RETAIN_QUADS\0" /* 60758 */
	"VGT_GRP_LIST\0" /* 60771 */
	"VGT_GRP_STRIP\0" /* 60784 */
	"VGT_GRP_FAN\0" /* 60798 */
	"VGT_GRP_LOOP\0" /* 60810 */
	"VGT_GRP_POLYGON\0" /* 60823 */
	"PRIM_ORDER\0" /* 60839 */
	"COMP_X_EN\0" /* 60850 */
	"COMP_Y_EN\0" /* 60860 */
	"COMP_Z_EN\0" /* 60870 */
	"COMP_W_EN\0" /* 60880 */
	"SHIFT\0" /* 60890 */
	"VGT_GRP_INDEX_16\0" /* 60896 */
	"VGT_GRP_INDEX_32\0" /* 60913 */
	"VGT_GRP_UINT_16\0" /* 60930 */
	"VGT_GRP_UINT_32\0" /* 60946 */
	"VGT_GRP_SINT_16\0" /* 60962 */
	"VGT_GRP_SINT_32\0" /* 60978 */
	"VGT_GRP_FLOAT_32\0" /* 60994 */
	"VGT_GRP_AUTO_PRIM\0" /* 61011 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 61029 */
	"X_CONV\0" /* 61055, 61059 */
	"Y_CONV\0" /* 61062 */
	"Z_CONV\0" /* 61069 */
	"Z_OFFSET\0" /* 61076 */
	"W_CONV\0" /* 61085 */
	"GS_OFF\0" /* 61092 */
	"GS_SCENARIO_A\0" /* 61099 */
	"GS_SCENARIO_B\0" /* 61113 */
	"GS_SCENARIO_G\0" /* 61127 */
	"GS_SCENARIO_C\0" /* 61141 */
	"SPRITE_EN\0" /* 61155 */
	"GS_CUT_1024\0" /* 61165 */
	"GS_CUT_512\0" /* 61177 */
	"GS_CUT_256\0" /* 61188 */
	"GS_CUT_128\0" /* 61199 */
	"CUT_MODE\0" /* 61210 */
	"GS_C_PACK_EN\0" /* 61219 */
	"RESERVED_2\0" /* 61232 */
	"ES_PASSTHRU\0" /* 61243 */
	"COMPUTE_MODE\0" /* 61255 */
	"FAST_COMPUTE_MODE\0" /* 61268 */
	"ELEMENT_INFO_EN\0" /* 61286 */
	"PARTIAL_THD_AT_EOI\0" /* 61302 */
	"SUPPRESS_CUTS\0" /* 61321 */
	"ES_WRITE_OPTIMIZE\0" /* 61335 */
	"GS_WRITE_OPTIMIZE\0" /* 61353 */
	"X_0_OFFCHIP_GS\0" /* 61371 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 61386, 61404 */
	"ES_VERTS_PER_SUBGRP\0" /* 61411 */
	"GS_PRIMS_PER_SUBGRP\0" /* 61431 */
	"MSAA_ENABLE\0" /* 61451 */
	"VPORT_SCISSOR_ENABLE\0" /* 61463 */
	"LINE_STIPPLE_ENABLE\0" /* 61484 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 61504 */
	"WALK_SIZE\0" /* 61529 */
	"WALK_ALIGNMENT\0" /* 61539 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 61554 */
	"WALK_FENCE_ENABLE\0" /* 61579 */
	"WALK_FENCE_SIZE\0" /* 61597 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 61613, 61618 */
	"TILE_COVER_DISABLE\0" /* 61641 */
	"TILE_COVER_NO_SCISSOR\0" /* 61660 */
	"ZMM_LINE_EXTENT\0" /* 61682 */
	"ZMM_LINE_OFFSET\0" /* 61698 */
	"ZMM_RECT_EXTENT\0" /* 61714 */
	"KILL_PIX_POST_HI_Z\0" /* 61730 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 61749 */
	"PS_ITER_SAMPLE\0" /* 61775 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 61790 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 61830 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 61857 */
	"GPU_ID_OVERRIDE\0" /* 61880 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 61896 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 61926 */
	"FORCE_EOV_REZ_ENABLE\0" /* 61950 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 61971 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 62001 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 62025 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 62048 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 62071 */
	"OUTPRIM_TYPE\0" /* 62093 */
	"OUTPRIM_TYPE_1\0" /* 62106 */
	"OUTPRIM_TYPE_2\0" /* 62121 */
	"OUTPRIM_TYPE_3\0" /* 62136 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 62151 */
	"VGT_INDEX_16\0" /* 62174 */
	"VGT_INDEX_32\0" /* 62187 */
	"VGT_INDEX_8\0" /* 62200 */
	"VGT_DMA_SWAP_NONE\0" /* 62212 */
	"VGT_DMA_SWAP_16_BIT\0" /* 62230 */
	"VGT_DMA_SWAP_32_BIT\0" /* 62250 */
	"VGT_DMA_SWAP_WORD\0" /* 62270 */
	"SWAP_MODE\0" /* 62288 */
	"VGT_DMA_BUF_MEM\0" /* 62298 */
	"VGT_DMA_BUF_RING\0" /* 62314 */
	"VGT_DMA_BUF_SETUP\0" /* 62331 */
	"BUF_TYPE\0" /* 62349 */
	"VGT_POLICY_LRU\0" /* 62358 */
	"VGT_POLICY_STREAM\0" /* 62373 */
	"RDREQ_POLICY_CIK\0" /* 62391 */
	"RDREQ_POLICY\0" /* 62408 */
	"REQ_PATH\0" /* 62421 */
	"DISABLE_RESET_ON_EOI\0" /* 62430 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 62451 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 62474 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 62497 */
	"CACHE_FLUSH_TS\0" /* 62520 */
	"CONTEXT_DONE\0" /* 62535 */
	"CACHE_FLUSH\0" /* 62548 */
	"CS_PARTIAL_FLUSH\0" /* 62560 */
	"VGT_STREAMOUT_SYNC\0" /* 62577 */
	"VGT_STREAMOUT_RESET\0" /* 62596 */
	"END_OF_PIPE_INCR_DE\0" /* 62616 */
	"END_OF_PIPE_IB_END\0" /* 62636 */
	"RST_PIX_CNT\0" /* 62655 */
	"VS_PARTIAL_FLUSH\0" /* 62667 */
	"PS_PARTIAL_FLUSH\0" /* 62684 */
	"FLUSH_HS_OUTPUT\0" /* 62701 */
	"FLUSH_LS_OUTPUT\0" /* 62717 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 62733 */
	"ZPASS_DONE\0" /* 62762 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 62773 */
	"PERFCOUNTER_START\0" /* 62799 */
	"PERFCOUNTER_STOP\0" /* 62817 */
	"PIPELINESTAT_START\0" /* 62834 */
	"PIPELINESTAT_STOP\0" /* 62853 */
	"PERFCOUNTER_SAMPLE\0" /* 62871 */
	"FLUSH_ES_OUTPUT\0" /* 62890 */
	"FLUSH_GS_OUTPUT\0" /* 62906 */
	"SAMPLE_PIPELINESTAT\0" /* 62922 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 62942 */
	"SAMPLE_STREAMOUTSTATS\0" /* 62964 */
	"RESET_VTX_CNT\0" /* 62986 */
	"BLOCK_CONTEXT_DONE\0" /* 63000 */
	"CS_CONTEXT_DONE\0" /* 63019 */
	"VGT_FLUSH\0" /* 63035 */
	"SC_SEND_DB_VPZ\0" /* 63045 */
	"BOTTOM_OF_PIPE_TS\0" /* 63060 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 63078 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 63101 */
	"FLUSH_AND_INV_DB_META\0" /* 63126 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 63148 */
	"FLUSH_AND_INV_CB_META\0" /* 63173 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 63195 */
	"THREAD_TRACE_START\0" /* 63223 */
	"THREAD_TRACE_STOP\0" /* 63242 */
	"THREAD_TRACE_MARKER\0" /* 63260 */
	"THREAD_TRACE_FLUSH\0" /* 63280 */
	"THREAD_TRACE_FINISH\0" /* 63299 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 63319 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 63343 */
	"PIXEL_PIPE_STAT_RESET\0" /* 63364 */
	"EVENT_TYPE\0" /* 63386 */
	"ADDRESS_HI_GFX6\0" /* 63397 */
	"EXTENDED_EVENT\0" /* 63413 */
	"PRIMGROUP_SIZE\0" /* 63428 */
	"PARTIAL_VS_WAVE_ON\0" /* 63443 */
	"SWITCH_ON_EOP\0" /* 63462 */
	"PARTIAL_ES_WAVE_ON\0" /* 63476 */
	"SWITCH_ON_EOI\0" /* 63495 */
	"WD_SWITCH_ON_EOP\0" /* 63509 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 63526 */
	"FULL_CACHE\0" /* 63546 */
	"HTILE_USES_PRELOAD_WIN\0" /* 63557 */
	"PRELOAD\0" /* 63580 */
	"PREFETCH_WIDTH\0" /* 63588 */
	"PREFETCH_HEIGHT\0" /* 63603 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 63619 */
	"TC_COMPATIBLE\0" /* 63643 */
	"COMPAREFUNC0\0" /* 63657 */
	"COMPAREVALUE0\0" /* 63670 */
	"COMPAREMASK0\0" /* 63684 */
	"COMPAREFUNC1\0" /* 63697 */
	"COMPAREVALUE1\0" /* 63710 */
	"COMPAREMASK1\0" /* 63724 */
	"MAX_X\0" /* 63737 */
	"MAX_Y\0" /* 63743 */
	"ACCUM_ISOLINE\0" /* 63749 */
	"ACCUM_TRI\0" /* 63763 */
	"ACCUM_QUAD\0" /* 63773 */
	"DONUT_SPLIT\0" /* 63784 */
	"TRAP_SPLIT\0" /* 63796 */
	"LS_STAGE_OFF\0" /* 63807 */
	"LS_STAGE_ON\0" /* 63820 */
	"CS_STAGE_ON\0" /* 63832 */
	"ES_STAGE_OFF\0" /* 63844 */
	"ES_STAGE_DS\0" /* 63857 */
	"ES_STAGE_REAL\0" /* 63869 */
	"VS_STAGE_REAL\0" /* 63883 */
	"VS_STAGE_DS\0" /* 63897 */
	"VS_STAGE_COPY_SHADER\0" /* 63909 */
	"DYNAMIC_HS\0" /* 63930 */
	"DIS_DEALLOC_ACCUM_0\0" /* 63941 */
	"DIS_DEALLOC_ACCUM_1\0" /* 63961 */
	"VS_WAVE_ID_EN\0" /* 63981 */
	"NUM_PATCHES\0" /* 63995 */
	"HS_NUM_INPUT_CP\0" /* 64007 */
	"HS_NUM_OUTPUT_CP\0" /* 64023 */
	"TESS_ISOLINE\0" /* 64040 */
	"TESS_TRIANGLE\0" /* 64053 */
	"TESS_QUAD\0" /* 64067 */
	"PART_INTEGER\0" /* 64077 */
	"PART_POW2\0" /* 64090 */
	"PART_FRAC_ODD\0" /* 64100 */
	"PART_FRAC_EVEN\0" /* 64114 */
	"PARTITIONING\0" /* 64129 */
	"OUTPUT_POINT\0" /* 64142 */
	"OUTPUT_LINE\0" /* 64155 */
	"OUTPUT_TRIANGLE_CW\0" /* 64167 */
	"OUTPUT_TRIANGLE_CCW\0" /* 64186 */
	"TOPOLOGY\0" /* 64206 */
	"RESERVED_REDUC_AXIS\0" /* 64215 */
	"DEPRECATED\0" /* 64235 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 64246 */
	"DISABLE_DONUTS\0" /* 64268 */
	"VGT_POLICY_BYPASS\0" /* 64283 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 64301 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 64327 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 64353 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 64378 */
	"DISTRIBUTION_MODE\0" /* 64407 */
	"ALPHA_TO_MASK_ENABLE\0" /* 64425 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 64446 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 64468 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 64490 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 64512 */
	"OFFSET_ROUND\0" /* 64534 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 64547 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 64575 */
	"STREAMOUT_0_EN\0" /* 64603 */
	"STREAMOUT_1_EN\0" /* 64618 */
	"STREAMOUT_2_EN\0" /* 64633 */
	"STREAMOUT_3_EN\0" /* 64648 */
	"RAST_STREAM\0" /* 64663 */
	"RAST_STREAM_MASK\0" /* 64675 */
	"USE_RAST_STREAM_MASK\0" /* 64692 */
	"STREAM_0_BUFFER_EN\0" /* 64713 */
	"STREAM_1_BUFFER_EN\0" /* 64732 */
	"STREAM_2_BUFFER_EN\0" /* 64751 */
	"STREAM_3_BUFFER_EN\0" /* 64770 */
	"DISTANCE_0\0" /* 64789 */
	"DISTANCE_1\0" /* 64800 */
	"DISTANCE_2\0" /* 64811 */
	"DISTANCE_3\0" /* 64822 */
	"DISTANCE_4\0" /* 64833 */
	"DISTANCE_5\0" /* 64844 */
	"DISTANCE_6\0" /* 64855 */
	"DISTANCE_7\0" /* 64866 */
	"DISTANCE_8\0" /* 64877 */
	"DISTANCE_9\0" /* 64888 */
	"DISTANCE_10\0" /* 64899 */
	"DISTANCE_11\0" /* 64911 */
	"DISTANCE_12\0" /* 64923 */
	"DISTANCE_13\0" /* 64935 */
	"DISTANCE_14\0" /* 64947 */
	"DISTANCE_15\0" /* 64959 */
	"EXPAND_LINE_WIDTH\0" /* 64971 */
	"LAST_PIXEL\0" /* 64989 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 65000 */
	"DX10_DIAMOND_TEST_ENA\0" /* 65025 */
	"MSAA_NUM_SAMPLES\0" /* 65047 */
	"AA_MASK_CENTROID_DTMN\0" /* 65064 */
	"MAX_SAMPLE_DIST\0" /* 65086 */
	"MSAA_EXPOSED_SAMPLES\0" /* 65102 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 65123 */
	"PIX_CENTER\0" /* 65146 */
	"X_TRUNCATE\0" /* 65157 */
	"X_ROUND\0" /* 65168 */
	"X_ROUND_TO_EVEN\0" /* 65176 */
	"X_ROUND_TO_ODD\0" /* 65192 */
	"ROUND_MODE\0" /* 65207 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 65218 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 65244 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 65269 */
	"X_16_8_FIXED_POINT_1_2\0" /* 65294 */
	"X_16_8_FIXED_POINT_1\0" /* 65317 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 65338 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 65365 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 65394 */
	"QUANT_MODE\0" /* 65423 */
	"S0_X\0" /* 65434 */
	"S0_Y\0" /* 65439 */
	"S1_X\0" /* 65444 */
	"S1_Y\0" /* 65449 */
	"S2_X\0" /* 65454 */
	"S2_Y\0" /* 65459 */
	"S3_X\0" /* 65464 */
	"S3_Y\0" /* 65469 */
	"S4_X\0" /* 65474 */
	"S4_Y\0" /* 65479 */
	"S5_X\0" /* 65484 */
	"S5_Y\0" /* 65489 */
	"S6_X\0" /* 65494 */
	"S6_Y\0" /* 65499 */
	"S7_X\0" /* 65504 */
	"S7_Y\0" /* 65509 */
	"S8_X\0" /* 65514 */
	"S8_Y\0" /* 65519 */
	"S9_X\0" /* 65524 */
	"S9_Y\0" /* 65529 */
	"S10_X\0" /* 65534 */
	"S10_Y\0" /* 65540 */
	"S11_X\0" /* 65546 */
	"S11_Y\0" /* 65552 */
	"S12_X\0" /* 65558 */
	"S12_Y\0" /* 65564 */
	"S13_X\0" /* 65570 */
	"S13_Y\0" /* 65576 */
	"S14_X\0" /* 65582 */
	"S14_Y\0" /* 65588 */
	"S15_X\0" /* 65594 */
	"S15_Y\0" /* 65600 */
	"AA_MASK_X0Y0\0" /* 65606 */
	"AA_MASK_X1Y0\0" /* 65619 */
	"AA_MASK_X0Y1\0" /* 65632 */
	"AA_MASK_X1Y1\0" /* 65645 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 65658 */
	"VTX_REUSE_DEPTH\0" /* 65687 */
	"DEALLOC_DIST\0" /* 65703 */
	"FMASK_TILE_MAX\0" /* 65716 */
	"ENDIAN_NONE\0" /* 65731 */
	"ENDIAN_8IN16\0" /* 65743 */
	"ENDIAN_8IN32\0" /* 65756 */
	"ENDIAN_8IN64\0" /* 65769 */
	"ENDIAN\0" /* 65782 */
	"COLOR_INVALID\0" /* 65789 */
	"COLOR_8\0" /* 65803 */
	"COLOR_16\0" /* 65811 */
	"COLOR_8_8\0" /* 65820 */
	"COLOR_32\0" /* 65830 */
	"COLOR_16_16\0" /* 65839 */
	"COLOR_10_11_11\0" /* 65851 */
	"COLOR_11_11_10\0" /* 65866 */
	"COLOR_10_10_10_2\0" /* 65881 */
	"COLOR_2_10_10_10\0" /* 65898 */
	"COLOR_8_8_8_8\0" /* 65915 */
	"COLOR_32_32\0" /* 65929 */
	"COLOR_16_16_16_16\0" /* 65941 */
	"COLOR_32_32_32_32\0" /* 65959 */
	"COLOR_5_6_5\0" /* 65977 */
	"COLOR_1_5_5_5\0" /* 65989 */
	"COLOR_5_5_5_1\0" /* 66003 */
	"COLOR_4_4_4_4\0" /* 66017 */
	"COLOR_8_24\0" /* 66031 */
	"COLOR_24_8\0" /* 66042 */
	"COLOR_X24_8_32_FLOAT\0" /* 66053 */
	"NUMBER_UNORM\0" /* 66074 */
	"NUMBER_SNORM\0" /* 66087 */
	"NUMBER_UINT\0" /* 66100 */
	"NUMBER_SINT\0" /* 66112 */
	"NUMBER_SRGB\0" /* 66124 */
	"NUMBER_FLOAT\0" /* 66136 */
	"NUMBER_TYPE\0" /* 66149 */
	"SWAP_STD\0" /* 66161 */
	"SWAP_ALT\0" /* 66170 */
	"SWAP_STD_REV\0" /* 66179 */
	"SWAP_ALT_REV\0" /* 66192 */
	"COMP_SWAP\0" /* 66205 */
	"BLEND_CLAMP\0" /* 66215 */
	"BLEND_BYPASS\0" /* 66227 */
	"SIMPLE_FLOAT\0" /* 66240 */
	"CMASK_IS_LINEAR\0" /* 66253 */
	"FORCE_OPT_AUTO\0" /* 66269 */
	"FORCE_OPT_DISABLE\0" /* 66284 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 66302 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 66330 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 66360 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 66391 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 66419 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 66449 */
	"BLEND_OPT_DONT_RD_DST\0" /* 66480 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 66502 */
	"FMASK_COMPRESSION_DISABLE\0" /* 66526 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 66552 */
	"DCC_ENABLE\0" /* 66578 */
	"CMASK_ADDR_TYPE\0" /* 66589 */
	"FMASK_TILE_MODE_INDEX\0" /* 66605 */
	"FMASK_BANK_HEIGHT\0" /* 66627 */
	"NUM_FRAGMENTS\0" /* 66645 */
	"FORCE_DST_ALPHA_1\0" /* 66659 */
	"KEY_CLEAR_ENABLE\0" /* 66677 */
	"MAX_BLOCK_SIZE_64B\0" /* 66694 */
	"MAX_BLOCK_SIZE_128B\0" /* 66713 */
	"MAX_BLOCK_SIZE_256B\0" /* 66733 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 66753 */
	"MIN_BLOCK_SIZE_32B\0" /* 66781 */
	"MIN_BLOCK_SIZE_64B\0" /* 66800 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 66819 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 66845 */
	"INDEPENDENT_64B_BLOCKS\0" /* 66871 */
	"LOSSY_RGB_PRECISION\0" /* 66894 */
	"LOSSY_ALPHA_PRECISION\0" /* 66914 */
	"UTCL2_BUSY\0" /* 66936 */
	"EA_BUSY\0" /* 66947 */
	"RMI_BUSY\0" /* 66955 */
	"UTCL2_RQ_PENDING\0" /* 66964 */
	"CPF_RQ_PENDING\0" /* 66981 */
	"EA_LINK_BUSY\0" /* 66996 */
	"CPAXI_BUSY\0" /* 67009 */
	"RSMU_RQ_PENDING\0" /* 67020 */
	"TC_WC_ACTION_ENA\0" /* 67036 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 67053 */
	"UTCL2IU_BUSY\0" /* 67080 */
	"SAVE_RESTORE_BUSY\0" /* 67093 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 67111 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 67135 */
	"UTCL1_WAITING_ON_TRANS\0" /* 67159 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 67182 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 67209 */
	"RCIU_WAITING_ON_FREE\0" /* 67236 */
	"PRIMGEN_EN\0" /* 67257 */
	"MATCH_ALL_BITS\0" /* 67268 */
	"EN_INST_OPT_BASIC\0" /* 67283 */
	"EN_INST_OPT_ADV\0" /* 67301 */
	"HW_USE_ONLY\0" /* 67317 */
	"TARGET_INST\0" /* 67329 */
	"TARGET_DATA\0" /* 67341 */
	"COMPLETE\0" /* 67353 */
	"DWB\0" /* 67362 */
	"USER_VM_ENABLE\0" /* 67366 */
	"USER_VM_MODE\0" /* 67381 */
	"IMG_DATA_FORMAT_6E4\0" /* 67394 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 67414 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 67442 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 67481 */
	"IMG_DATA_FORMAT_FMASK\0" /* 67520 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 67542 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 67570 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 67598 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 67631 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 67659 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 67687 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 67720 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 67744 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 67771 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 67804 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 67843 */
	"IMG_DATA_FORMAT_S8_16\0" /* 67871 */
	"IMG_DATA_FORMAT_S8_32\0" /* 67893 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 67915 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 67939 */
	"DATA_FORMAT_GFX9\0" /* 67966 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 67983 */
	"IMG_NUM_FORMAT_METADATA\0" /* 68009 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 68033 */
	"NUM_FORMAT_GFX9\0" /* 68059 */
	"IMG_FMASK_8_2_1\0" /* 68075 */
	"IMG_FMASK_8_4_1\0" /* 68091 */
	"IMG_FMASK_8_8_1\0" /* 68107 */
	"IMG_FMASK_8_2_2\0" /* 68123 */
	"IMG_FMASK_8_4_2\0" /* 68139 */
	"IMG_FMASK_8_4_4\0" /* 68155 */
	"IMG_FMASK_16_16_1\0" /* 68171 */
	"IMG_FMASK_16_8_2\0" /* 68189 */
	"IMG_FMASK_32_16_2\0" /* 68206 */
	"IMG_FMASK_32_8_4\0" /* 68224 */
	"IMG_FMASK_32_8_8\0" /* 68241 */
	"IMG_FMASK_64_16_4\0" /* 68258 */
	"IMG_FMASK_64_16_8\0" /* 68276 */
	"NUM_FORMAT_FMASK\0" /* 68294 */
	"IMG_ASTC_2D_4x4\0" /* 68311 */
	"IMG_ASTC_2D_5x4\0" /* 68327 */
	"IMG_ASTC_2D_5x5\0" /* 68343 */
	"IMG_ASTC_2D_6x5\0" /* 68359 */
	"IMG_ASTC_2D_6x6\0" /* 68375 */
	"IMG_ASTC_2D_8x5\0" /* 68391 */
	"IMG_ASTC_2D_8x6\0" /* 68407 */
	"IMG_ASTC_2D_8x8\0" /* 68423 */
	"IMG_ASTC_2D_10x5\0" /* 68439 */
	"IMG_ASTC_2D_10x6\0" /* 68456 */
	"IMG_ASTC_2D_10x8\0" /* 68473 */
	"IMG_ASTC_2D_10x10\0" /* 68490 */
	"IMG_ASTC_2D_12x10\0" /* 68508 */
	"IMG_ASTC_2D_12x12\0" /* 68526 */
	"NUM_FORMAT_ASTC_2D\0" /* 68544 */
	"IMG_ASTC_3D_3x3x3\0" /* 68563 */
	"IMG_ASTC_3D_4x3x3\0" /* 68581 */
	"IMG_ASTC_3D_4x4x3\0" /* 68599 */
	"IMG_ASTC_3D_4x4x4\0" /* 68617 */
	"IMG_ASTC_3D_5x4x4\0" /* 68635 */
	"IMG_ASTC_3D_5x5x4\0" /* 68653 */
	"IMG_ASTC_3D_5x5x5\0" /* 68671 */
	"IMG_ASTC_3D_6x5x5\0" /* 68689 */
	"IMG_ASTC_3D_6x6x5\0" /* 68707 */
	"IMG_ASTC_3D_6x6x6\0" /* 68725 */
	"NUM_FORMAT_ASTC_3D\0" /* 68743 */
	"META_DIRECT\0" /* 68762 */
	"SW_MODE\0" /* 68774 */
	"PITCH_GFX9\0" /* 68782 */
	"BC_SWIZZLE_XYZW\0" /* 68793 */
	"BC_SWIZZLE_XWYZ\0" /* 68809 */
	"BC_SWIZZLE_WZYX\0" /* 68825 */
	"BC_SWIZZLE_WXYZ\0" /* 68841 */
	"BC_SWIZZLE_ZYXW\0" /* 68857 */
	"BC_SWIZZLE_YXWZ\0" /* 68873 */
	"BC_SWIZZLE\0" /* 68889 */
	"ARRAY_PITCH\0" /* 68900 */
	"META_DATA_ADDRESS\0" /* 68912 */
	"META_LINEAR\0" /* 68930 */
	"META_PIPE_ALIGNED\0" /* 68942, 68947 */
	"META_RB_ALIGNED\0" /* 68960, 68965 */
	"MAX_MIP\0" /* 68976 */
	"BLEND_ZERO_PRT\0" /* 68984 */
	"SKIP_DEGAMMA\0" /* 68999 */
	"TTRACE_STALL_ALL\0" /* 69012 */
	"ALLOC_ARB_LRU_ENA\0" /* 69029 */
	"EXP_ARB_LRU_ENA\0" /* 69047 */
	"PS_PKR_PRIORITY_CNTL\0" /* 69063 */
	"BATON_RESET_DISABLE\0" /* 69084 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 69104 */
	"LBPW_CU_CHK_MODE\0" /* 69130 */
	"LBPW_CU_CHK_CNT\0" /* 69147 */
	"CSC_PWR_SAVE_DISABLE\0" /* 69163 */
	"CSG_PWR_SAVE_DISABLE\0" /* 69184 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 69205 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 69246 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 69285 */
	"MAX_COMPRESSED_FRAGS\0" /* 69311 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 69332 */
	"NUM_GPUS_GFX9\0" /* 69356 */
	"NUM_RB_PER_SE\0" /* 69370 */
	"SE_ENABLE\0" /* 69384 */
	"SIMD_DISABLE\0" /* 69394 */
	"FP16_OVFL\0" /* 69407 */
	"LOAD_COLLISION_WAVEID\0" /* 69417 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 69439 */
	"SKIP_USGPR0\0" /* 69464 */
	"USER_SGPR_MSB\0" /* 69476 */
	"PC_BASE_EN\0" /* 69490 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 69501 */
	"GS_VGPR_COMP_CNT\0" /* 69526 */
	"ES_VGPR_COMP_CNT\0" /* 69543 */
	"LS_VGPR_COMP_CNT\0" /* 69560 */
	"CNTR_SEL0\0" /* 69577 */
	"CNTR_SEL1\0" /* 69587 */
	"CNTR_MODE1\0" /* 69597 */
	"CNTR_MODE0\0" /* 69608 */
	"CNTR_SEL2\0" /* 69619 */
	"CNTR_SEL3\0" /* 69629 */
	"CNTR_MODE3\0" /* 69639 */
	"CNTR_MODE2\0" /* 69650 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 69661 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 69690 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 69716 */
	"MIPID\0" /* 69743 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 69749 */
	"X_MAX\0" /* 69777 */
	"Y_MAX\0" /* 69783 */
	"PARTIALLY_RESIDENT\0" /* 69789 */
	"FAULT_BEHAVIOR\0" /* 69808 */
	"ITERATE_FLUSH\0" /* 69823 */
	"MAXMIP\0" /* 69837 */
	"FORCE_ON\0" /* 69844 */
	"PUNCHOUT_MODE\0" /* 69853 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 69867 */
	"DISALLOW_OVERFLOW\0" /* 69892 */
	"DEST_BASE_HI_256B\0" /* 69910 */
	"SE_XSEL_GFX9\0" /* 69928 */
	"SE_YSEL_GFX9\0" /* 69941 */
	"SE_PAIR_XSEL_GFX9\0" /* 69954 */
	"SE_PAIR_YSEL_GFX9\0" /* 69972 */
	"NUM_SE\0" /* 69990 */
	"PERFMON_ENABLE\0" /* 69997 */
	"LEFT_QTR\0" /* 70012 */
	"LEFT_HALF\0" /* 70021 */
	"RIGHT_HALF\0" /* 70031 */
	"RIGHT_QTR\0" /* 70042 */
	"TOP_QTR\0" /* 70052 */
	"TOP_HALF\0" /* 70060 */
	"BOT_HALF\0" /* 70069 */
	"BOT_QTR\0" /* 70078 */
	"DISABLE_CONSTANT_ENCODE_REG\0" /* 70086 */
	"OFFCHIP_PARAM_EN\0" /* 70114 */
	"LATE_PC_DEALLOC\0" /* 70131 */
	"BASE_ADDR_GFX9\0" /* 70147 */
	"SPRITE_EN_R6XX\0" /* 70162 */
	"UNROLLED_INST\0" /* 70177 */
	"GRBM_SKEW_NO_DEC\0" /* 70191 */
	"REG_RT_INDEX\0" /* 70208 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 70221 */
	"EXEC_IF_OVERLAPPED\0" /* 70252 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 70271 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 70296 */
	"NEW_QUAD_DECOMPOSITION\0" /* 70334 */
	"PERFCOUNTER_REF\0" /* 70357 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 70373 */
	"OBJ_ID_SEL\0" /* 70396 */
	"ADD_PIPED_PRIM_ID\0" /* 70407 */
	"EN_32BIT_OBJPRIMID\0" /* 70425 */
	"VERTEX_REUSE_OFF\0" /* 70444 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 70461 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 70485 */
	"DISCARD_0_AREA_LINES\0" /* 70510 */
	"DISCARD_0_AREA_POINTS\0" /* 70531 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 70553 */
	"USE_PROVOKING_ZW\0" /* 70579 */
	"RESERVED_3\0" /* 70596 */
	"RESERVED_4\0" /* 70607 */
	"RESERVED_5\0" /* 70618 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 70629 */
	"SCALE_LINE_WIDTH_PAD\0" /* 70653 */
	"ALTERNATE_RBS_PER_TILE\0" /* 70674 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 70697 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 70727 */
	"BREAK_BATCH\0" /* 70752 */
	"FLUSH_DFSM\0" /* 70764 */
	"RESET_TO_LOWEST_VGT\0" /* 70775 */
	"TGID_ROLLOVER\0" /* 70795 */
	"ENABLE_NGG_PIPELINE\0" /* 70809 */
	"ENABLE_LEGACY_PIPELINE\0" /* 70829 */
	"ADDRESS_HI_GFX9\0" /* 70852 */
	"OBJPRIM_ID_EN\0" /* 70868 */
	"EN_REG_RT_INDEX\0" /* 70882 */
	"EN_PIPELINE_PRIMID\0" /* 70898 */
	"OBJECT_ID_INST_EN\0" /* 70917 */
	"ORDERED_ID_MODE\0" /* 70935 */
	"GS_FAST_LAUNCH\0" /* 70951 */
	"EN_PRIMS_NEEDED_CNT\0" /* 70966 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 70986 */
	"BINNING_ALLOWED\0" /* 71012 */
	"FORCE_BINNING_ON\0" /* 71028 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 71045 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 71072 */
	"BINNING_MODE\0" /* 71102 */
	"BIN_SIZE_X\0" /* 71115 */
	"BIN_SIZE_Y\0" /* 71126 */
	"BIN_SIZE_X_EXTEND\0" /* 71137 */
	"BIN_SIZE_Y_EXTEND\0" /* 71155 */
	"CONTEXT_STATES_PER_BIN\0" /* 71173 */
	"PERSISTENT_STATES_PER_BIN\0" /* 71196 */
	"DISABLE_START_OF_PRIM\0" /* 71222 */
	"FPOVS_PER_BATCH\0" /* 71244 */
	"OPTIMAL_BIN_SELECTION\0" /* 71260 */
	"MAX_ALLOC_COUNT\0" /* 71282 */
	"MAX_PRIM_PER_BATCH\0" /* 71298 */
	"OVER_RAST_ENABLE\0" /* 71317 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 71334 */
	"UNDER_RAST_ENABLE\0" /* 71358 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 71376 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 71401 */
	"ZMM_TRI_EXTENT\0" /* 71431 */
	"ZMM_TRI_OFFSET\0" /* 71446 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 71461 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 71496 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 71532 */
	"UNCERTAINTY_REGION_MODE\0" /* 71576 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71600 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71636 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 71672 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 71698 */
	"PREZ_AA_MASK_ENABLE\0" /* 71722 */
	"POSTZ_AA_MASK_ENABLE\0" /* 71742 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 71763 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 71788 */
	"BASE_256B\0" /* 71809 */
	"MIP0_HEIGHT\0" /* 71819 */
	"MIP0_WIDTH\0" /* 71831 */
	"MIP_LEVEL\0" /* 71842 */
	"MIP0_DEPTH\0" /* 71852 */
	"COLOR_SW_MODE\0" /* 71863 */
	"FMASK_SW_MODE\0" /* 71877 */
	"RESOURCE_TYPE\0" /* 71891 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 31800, 1814, 15415,
	/* 4 */ 31838, 31858, 31867, 31873, 8169, 456,
	/* 10 */ 31913, 31873, 391, 31922,
	/* 14 */ 31952, 31873, 8659, 31961,
	/* 18 */ 32032, 32037, 32045, 32053,
	/* 22 */ 32079, 31849,
	/* 24 */ 32094, 32104,
	/* 26 */ 36480, 36491, 36507, 36522, 36538, 36552, 36565, 36580, 36595, 36610, 36622, 36641, 36661, 36679, 36698, 36713, 36728, 36750, 36765, 36780, 36795, 36811, 36825, 36852, 36879, 36906, 36933, 36957, 36977,
	/* 55 */ 36996, 37017,
	/* 57 */ 36480, 36491, 36507, 36522, 36538, 36552, 36565, -1, -1, 36610, 36622, 36641, 36661, 36679, -1, -1, 36728, 36750, 36765, 36780, 36795, 36811, 36825, 36852, 36879, 36906, 36933, 36957, 36977,
	/* 86 */ 38859, 38871, 38883, 38895,
	/* 90 */ 39240, -1, -1, -1, -1, -1, -1, -1, 39251, 39263, -1, -1, 39275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39286,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39312,
	/* 186 */ 39383, 39392, 39401, 39419, 39437, 39446, 39455, 39464,
	/* 194 */ 39513, 39534, 39555, 39578, 39601, 39621, 39641, 39666,
	/* 202 */ 39698, 39722, 39740, 39759, 39779, 39798, 39820, 39845, 39870, 39897, 39924, 39948, 39970, 39998, 40023, 40051,
	/* 218 */ 40159, 40171, 40190, 40209,
	/* 222 */ 40236, 40260, 40278, 40297, 40317, 40336, 40358, 40383, 40408, 40435, 40462, 40486, 40508, 40536, 40561, 40589, 40617, 40639, 40663, 40687, 40711, 40732, 40753, 40778, 40807, 40832, 40858, 40881, 40905, 40932, 40960, 40988, 41016, 41038, 41060, 41084, 41104, 41124, 41144, 41164, 41184, 41204, 41224, 41263, 41302, 41331, 41360, 41389, 41418, 41447, 41476, 41507, 41537, 41568, 41598, 41628, 41659, 41690, 41710, 41732, 41750, 41777, 41801, 41827,
	/* 286 */ 41878, 41899, 41920, 41943, 41966, 41986, 42006, 42031, 42052, 42078, 42098, 42120, 42146, 42167, 42191, 42218,
	/* 302 */ 42338, 42357, 42376, 42395, 42414, 42433, 42452, 42471, 42490, 42505, 42520, 42535, 42552, 42573, 42594, 42614,
	/* 318 */ 42796, 42808, 42822, 42846, 42876, 42901, 42932, 42952,
	/* 326 */ 43018, 43045, 43071, 43098, 43129, 43158, 43188, 43222,
	/* 334 */ 43374, 43399, 43422,
	/* 337 */ 43515, 43538,
	/* 339 */ 43515, 43538, 43578, 43607,
	/* 343 */ 43653, 43674, 43696,
	/* 346 */ 43838, 43870, 43903, 43936,
	/* 350 */ 44115,
	/* 351 */ 44471, 44487, 44503, 44519, 44535, 44551, 44567, 44583, 44599, 44615, 44631, 44647, 44662, 44677, 44692, 44708,
	/* 367 */ 45135, 45166, 45194, 45223,
	/* 371 */ 45268, 45289, 45310, 45331, 45352, -1, -1, 45373, 45394, -1, -1, -1, 45416, 45437, 45458, 45480,
	/* 387 */ 45508, 45521, 45544, 45567, 45590, 45610, 45631, 45652, 45673, 45699, 45725, 45751, 45778, 45805, 45832,
	/* 402 */ 45871, 45896, 45922, 45948, 45974, 45999, 46024,
	/* 409 */ 46060, 46083, 46106, 46129,
	/* 413 */ 46163, 46187, 46211, 46235,
	/* 417 */ 46271, 46296, 46321, 46346,
	/* 421 */ 46389, 46406, 46423, 46440,
	/* 425 */ 45135, 45166, 45194, 46468,
	/* 429 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46583, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46597, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46611,
	/* 670 */ 47502, 47520, 47535,
	/* 673 */ 49047, 49057, 49070, 49084,
	/* 677 */ 49381, 49396, 49412, 49428,
	/* 681 */ 49593, 49603, 49621, 49631,
	/* 685 */ 45268, 45289, 45310, -1, 45352, 50030, 50052,
	/* 692 */ 45508, -1, -1, -1, 45590, 45610, 45631, 45652, 45673, 45699, 45725, 45751, 45778, 45805, 45832, -1, 50077, 50104,
	/* 710 */ 50132, 50142, 50147, 50152,
	/* 714 */ 50294, 50310,
	/* 716 */ -1, 23461, 1947, -1, 1999, -1, -1, -1, 17489, -1, -1, -1, -1, -1, -1, -1, 17185, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50441, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50447, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50453, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17223, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50460, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50466, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50472, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32047, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50479, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50486, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50493,
	/* 33485 */ 50848, 50871, 50894, 50917,
	/* 33489 */ 50964, 50989, 51014, 51039,
	/* 33493 */ 51089, 51113, 51137, 51161,
	/* 33497 */ 51193, 51218, 51243, 51268,
	/* 33501 */ 51302, 51327, 51352, 51377,
	/* 33505 */ 51411, 51437, 51463, 51489,
	/* 33509 */ 51525, 51548, 51571, 51594,
	/* 33513 */ 51624, 51658, 51693, 51728,
	/* 33517 */ 51771, 51805, 51840, 51875,
	/* 33521 */ 51918, 51941, 51964, 51987,
	/* 33525 */ 52017, 52051, 52086, 52121,
	/* 33529 */ 52169, 52203, 52238, 52273,
	/* 33533 */ 52321, 52349, 52377, 52405,
	/* 33537 */ 52445, 52484, 52524, 52564,
	/* 33541 */ 52622, 52661, 52701, 52741,
	/* 33545 */ 52894, 52907, 52920, 52933, 52954, 52973, 52991, 53009, 53024, 53041, 53058, 53070, 53081, 53093, 53106, 53118,
	/* 33561 */ 53342,
	/* 33562 */ 53871, 53892, 53913, 53934, 53955,
	/* 33567 */ 54216,
	/* 33568 */ 54396, 54412, 54429, 54446, 54467,
	/* 33573 */ 54560, 54576, 54592, 54609, 54626, 54647, 54671, 54695, 54718, 54741,
	/* 33583 */ 54928, 54955, 54973, 54991, 55013, 55037, 55058, 55077, 55098, 55119, 55141,
	/* 33594 */ 55203, 55209, -1, 55222, -1, -1, -1, 55235, -1, -1, -1, 55247, -1, 55259, -1, 55271,
	/* 33610 */ 55778, 55813, 55848, 55880, 55912, 55944, 55976, 56010,
	/* 33618 */ 56074, 56088, 56101, 56119, 56132, 56145, 56166, 56190,
	/* 33626 */ 56266, 56277, 56287, 56303, 56329, 56345, 56371, 56387, 56413, 56429, 56455, -1, -1, 56480, 56501, 56532, 56549, 56570, 56587, 56608, 56629,
	/* 33647 */ 56675, 56693, 56712, 56729, 56746,
	/* 33652 */ 56874, 56889, 56910, 56932,
	/* 33656 */ 56966, 56982,
	/* 33658 */ 57090, 57101, 57111, 57122, 57134, 57147, 57161, 57173,
	/* 33666 */ 57201, 57211, 57220, 57230, 57241, 57253, 57266, 57277,
	/* 33674 */ 57698, 57709, 57719, 57743, -1, 57754, 57774,
	/* 33681 */ 57792, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57803, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57812, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57830, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57849, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57866, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57878, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57887, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57897, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57906, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57922, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57933, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57950, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57960, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57976, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57984,
	/* 33937 */ 58069, 58076, 58096, 58101,
	/* 33941 */ 58247, 58260, 58279, 58301,
	/* 33945 */ 58682, 58702,
	/* 33947 */ 58714, 58728, 58741,
	/* 33950 */ 60263, 60285, 60305, 60326, 60347,
	/* 33955 */ 60390, 60407, 60423, 60438, 60454, 60470, 60494, 60518, 60542, 60566, 60587, 60603, 60618, 60642, 60665, 60689, 60709, 60728,
	/* 33973 */ 60771, 60784, 60798, 60810, 60823,
	/* 33978 */ 60896, 60913, 60930, 60946, 60962, 60978, 60994, 61011, 61029,
	/* 33987 */ 61092, 61099, 61113, 61127, 61141, 61155,
	/* 33993 */ 61165, 61177, 61188, 61199,
	/* 33997 */ 61371, -1, -1, 61386,
	/* 34001 */ 62025, 62048, 62071,
	/* 34004 */ 62174, 62187, 62200,
	/* 34007 */ 62212, 62230, 62250, 62270,
	/* 34011 */ 62298, 62314, 62331,
	/* 34014 */ 62358, 62373,
	/* 34016 */ -1, 62451, 62474, 62497, 62520, 62535, 62548, 62560, 62577, -1, 62596, 62616, 62636, 62655, -1, 62667, 62684, 62701, 62717, -1, 62733, 62762, 62773, 62799, 62817, 62834, 62853, 62871, 62890, 62906, 62922, 62942, 62964, 62986, 63000, 63019, 63035, -1, -1, 63045, 63060, -1, 63078, 63101, 63126, 63148, 63173, 38595, 38622, 63195, -1, 63223, 63242, 63260, 63280, 63299, 63319, 63343, 63364,
	/* 34075 */ 63807, 63820, 63832,
	/* 34078 */ 63844, 63857, 63869,
	/* 34081 */ 63883, 63897, 63909,
	/* 34084 */ 64040, 64053, 64067,
	/* 34087 */ 64077, 64090, 64100, 64114,
	/* 34091 */ 64142, 64155, 64167, 64186,
	/* 34095 */ 62358, 62373, 64283,
	/* 34098 */ 64301, 64327, 64353, 64378,
	/* 34102 */ 65157, 65168, 65176, 65192,
	/* 34106 */ 65218, 65244, 65269, 65294, 65317, 65338, 65365, 65394,
	/* 34114 */ 65731, 65743, 65756, 65769,
	/* 34118 */ 65789, 65803, 65811, 65820, 65830, 65839, 65851, 65866, 65881, 65898, 65915, 65929, 65941, -1, 65959, -1, 65977, 65989, 66003, 66017, 66031, 66042, 66053,
	/* 34141 */ 66074, 66087, -1, -1, 66100, 66112, 66124, 66136,
	/* 34149 */ 66161, 66170, 66179, 66192,
	/* 34153 */ 66269, 66284, 66302, 66330, 66360, 66391, 66419, 66449,
	/* 34161 */ 66694, 66713, 66733,
	/* 34164 */ 66781, 66800,
	/* 34166 */ 40236, 40260, 40278, 40297, 40317, 40336, 40358, 40383, 40408, 40435, 40462, 40486, 40508, 40536, 40561, 40589, 40617, 40639, 40663, 40687, 40711, 40732, 40753, 40778, 40807, 40832, 40858, 40881, 40905, 40932, 40960, 67394, 41016, 41038, 41060, 41084, 41104, 41124, 41144, 41164, 41184, 41204, 67414, 67442, 67481, 67520, 67542, 67570, 67598, 67631, 67659, 67687, 67720, 67744, 67771, 67804, 67843, 41690, 41710, 67871, 67893, 67915, 67939, 41827,
	/* 34230 */ 41878, 41899, 41920, 41943, 41966, 41986, 67983, 42031, 68009, 42078, 68033,
	/* 34241 */ 68075, 68091, 68107, 68123, 68139, 68155, 68171, 68189, 68206, 68224, 68241, 68258, 68276,
	/* 34254 */ 68311, 68327, 68343, 68359, 68375, 68391, 68407, 68423, 68439, 68456, 68473, 68490, 68508, 68526,
	/* 34268 */ 68563, 68581, 68599, 68617, 68635, 68653, 68671, 68689, 68707, 68725,
	/* 34278 */ 68793, 68809, 68825, 68841, 68857, 68873,
	/* 34284 */ 245, 69844, 49047, 8169,
	/* 34288 */ -1, 62451, 62474, 62497, 62520, 62535, 62548, 62560, 62577, -1, 62596, 62616, 62636, 62655, 70752, 62667, 62684, 62701, 70764, 70775, 62733, 62762, 62773, 62799, 62817, 62834, 62853, 62871, -1, -1, 62922, 62942, 62964, 62986, 63000, 63019, 63035, 70795, -1, 63045, 63060, -1, 63078, 63101, 63126, 63148, 63173, 38595, 38622, 63195, -1, 63223, 63242, 63260, 63280, 63299, 63319, 63343, 63364, -1, -1, 70809, 70829,
	/* 34351 */ 71012, 71028, 71045, 71072,
	/* 34355 */ 42502, 42517, 42532, 8169,
};

#endif
