/*
 * generated by Xtext 2.20.0
 */
package org.neu.acl2.handproof.tests

import com.google.inject.Inject
import org.eclipse.xtext.testing.InjectWith
import org.eclipse.xtext.testing.extensions.InjectionExtension
import org.eclipse.xtext.testing.util.ParseHelper
import org.junit.jupiter.api.Assertions
import org.junit.jupiter.api.Test
import org.junit.jupiter.api.^extension.ExtendWith
import org.neu.acl2.handproof.handProof.ProofDocument
import org.eclipse.emf.ecore.EObject
import org.neu.acl2.handproof.handProof.SExpression
import org.neu.acl2.handproof.handProof.SExpList
import org.neu.acl2.handproof.handProof.Symbol
import org.neu.acl2.handproof.handProof.Const
import org.junit.jupiter.api.TestFactory
import java.util.stream.Stream
import org.junit.jupiter.api.DynamicTest
import java.util.Arrays
import java.io.File
import static org.junit.jupiter.api.DynamicTest.dynamicTest
import java.nio.file.Files
import java.nio.file.Paths
import org.neu.acl2.handproof.handProof.QuotedSExpressionExpr

@ExtendWith(InjectionExtension)
@InjectWith(HandProofInjectorProvider)
class HandProofParsingTest {
	@Inject
	ParseHelper<ProofDocument> parseHelper
	
	def static String dump(EObject mod_, String indent) {
	    var res = indent + mod_.toString.replaceFirst ('.*[.]impl[.](.*)Impl[^(]*', '$1 ')
	
	    for (a :mod_.eCrossReferences)
	        res += ' ->' + a.toString().replaceFirst ('.*[.]impl[.](.*)Impl[^(]*', '$1 ')
	    res += "\n"
	    for (f :mod_.eContents) {
	        res += f.dump (indent+"    ")
	    }
	    return res
	}
	
//	def static String dumpSexpression(QuotedSExpression sexp) {
//		
//	}
// 	
//	def static String dumpSexpression(SExpression sexp) {
//		switch(sexp) {
//			SExpListExpr: '''(«sexp.list.body.map([item | dumpSexpression(item)]).join(" ")»)'''
//			QuotedSExpressionExpr: "'" + dumpSexpression(sexp.sexp)
//			Symbol: sexp.value
//			Const: sexp.value
//		}
//	}
	
	@Test
	def void weird() {
		val result = parseHelper.parse('''
		(definec len2 (x :tl) :nat
		  (if (endp x)
		      0
		    (+ 1 (len2 (rest x)))))
		
		(definec in2 (a :all l :tl) :bool
		  (if (endp l)
		      nil
		    (or (== a (first l)) (in2 a (rest l)))))
		   
		(definec app2 (x :tl y :tl) :tl
		  (if (endp x)
		      y
		    (cons (first x) (app2 (rest x) y))))
		
		(definec rev2 (x :tl) :tl
		  (if (endp x)
		      x
		    (app2 (rev2 (cdr x)) (list (car x)))))
		
		;; Question 2e.
		
		Conjecture 2e:
		(implies (endp x)
		         (implies (in2 a (app2 x y))
		                  (implies (not (in2 a x))
		                           (in2 a y))))
		
		Exportation:
		(implies (and (endp x)
		              (in2 a (app2 x y))
		              (not (in2 a x)))
		         (in2 a y))
		
		Contract Completion:
		(implies (and (tlp x)
		              (tlp y)
		              (endp x)
		              (in2 a (app2 x y))
		              (not (in2 a x)))
		         (in2 a y))
		
		Context:
		C1. (tlp x)
		C2. (tlp y)
		C3. (endp x)
		C4. (in2 a (app2 x y))
		C5. (not (in2 a x))
		
		Derived Context:
		D1. (equal x nil) {Def tlp, C1, C3}
		D2. (in2 a y) {C4, Def app2, D1}
		
		QED
		
		;; Question 2g.
		Conjecture 2g:
		(implies (and (consp x)
		              (implies (and (tlp (rest x))
		                            (tlp y))
		                       (implies (in2 a (app2 (rest x) y))
		                                (implies (not (in2 a (rest x)))
		                                         (in2 a y)))))
		         (implies (in2 a (app2 x y))
		                  (implies (not (in2 a x))
		                           (in2 a y))))
		
		Exportation:
		(implies (and (consp x)
		     (implies (and (tlp (rest x))
		                   (tlp y)
		                   (in2 a (app2 (rest x) y))
		                   (not (in2 a (rest x))))
		              (in2 a y))
		     (in2 a (app2 x y))
		     (not (in2 a x)))
		         (in2 a y))
		
		Contract Completion:
		(implies (and (tlp x)
		              (tlp y)
		              (consp x)
		     (implies (and (tlp (rest x))
		                   (tlp y)
		                   (in2 a (app2 (rest x) y))
		                   (not (in2 a (rest x))))
		              (in2 a y))
		     (in2 a (app2 x y))
		     (not (in2 a x)))
		         (in2 a y))
		
		Context:
		C1. (tlp x)
		C2. (tlp y)
		C3. (consp x)
		C4. (implies (and (tlp (rest x))
		                  (tlp y)
		                  (in2 a (app2 (rest x) y))
		                  (not (in2 a (rest x))))
		             (in2 a y))
		C5. (in2 a (app2 x y))
		C6. (not (in2 a x))
		
		Derived Context:
		D1. (tlp (rest x)) {Def tlp, C1, C3}
		D2. (not (or (== a (first x))
		             (in2 a (rest x))))  {Def in2, C6, C3}
		D3. (and (not (== a (first x)))
		         (not (in2 a (rest x)))) {D2, PL}
		D4. (not (== a (first x))) {D3, PL}
		D5. (not (in2 a (rest x))) {D3, PL}
		D6. (in2 a (cons (first x) (app2 (rest x) y))) {C5, Def app2, C3}
		D7. (or (== a (first x))
		        (in2 a (app2 (rest x) y)))  {Def in2, D6, cons axioms}
		D8. (in2 a (app2 (rest x) y))  {D7, D4, PL}
		D9. (in a y) {C4, D1, C2, D8, D5, MP}
		
		QED
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
		print(dump(result, "   "))
	}
	
	@Test
	def void conj14pt1() {
		val result = parseHelper.parse('''
			Conjecture 14-part-1:
			(implies (tlp x)
			         (implies (endp x)
			                  (implies (myin a x) 
			                           (myin a (aapp x y)))))
			Exportation:
			(implies (and (tlp x)
			              (endp x)
			              (myin a x)) 
			         (myin a (aapp x y)))
			
			Contract Completion:
			(implies (and (tlp x)
			              (tlp y)
			              (endp x)
			              (myin a x)) 
			         (myin a (aapp x y)))
			
			Context:
			C1. (tlp x)
			C2. (tlp y)
			C3. (endp x)
			C4. (myin a x)
			
			Derived Context:
			D1. (equal x nil) { C1, C3, Def tlp } 
			D2. nil { Def myin, C4, D1 }
			
			QED
		''')
		//System.out.println(result);
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void simplestProof() {
		val result = parseHelper.parse('''
			Conjecture test:
			t
			
			QED
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void simpleCond() {
		val result = parseHelper.parse('''
			(cond ((endp X) 0)
			      ((evenp (car X)) 1)
			      ((oddp (car X)) -1))
		''')
		Assertions.assertNotNull(result)
		println(dump(result, "	"))
//		println(dumpSexpression(result.proofsAndStatements.get(0) as SExpression))
		//println(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void equalsExpression() {
		val result = parseHelper.parse('''
		(= x 0)
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void parseQuotedForms() {
		val result = parseHelper.parse('''
		      '1
		      'foo
		      '(list 'a b c)
		      ''1
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void parseBackquotedForms() {
		val result = parseHelper.parse('''
		      `1
		      `foo
		      `(list 'a ,b ,@c)
		      ``l
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void parseWeirdSymbols() {
		val result = parseHelper.parse('''
		      foo_bar
		      |a{}b|
		      |bars with a space|
		      acl2:|pkg specifier plus bars|
		      acl2::0ad
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void parseList() {
		val result = parseHelper.parse('''
		      (list 'not bex)
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void parseDefdata() {
		val result = parseHelper.parse('''
		 (defdata bex
		   (oneof boolean
		      var
		      (list 'not bex)
		      (list 'and bex bex)
		      (list 'or  bex bex)))
		''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void handleHintsWithoutSpaceAfterBracket() {
		val result = parseHelper.parse('''
		 Conjecture 4:
		 (equal a c)
		 
		 Proof by: Equational Reasoning
		 
		 Goal:
		 (equal a c)
		 
		 Proof:
		 a
		 == {def foo, car-cdr axioms}
		 b
		 == { def baz, car-cdr axioms }
		 c
		 QED
		 ''')
		 Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void symbolStartingWithNumber() {
		val result = parseHelper.parse('''
		2f
		2f1
		''')
		Assertions.assertNotNull(result)
		println(dump(result, "	"))
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void proofNameContainingNumber() {
		val result = parseHelper.parse('''
		Lemma 2f:
		t
		QED
		
		Lemma 2f1:
		t
		QED
		
		Lemma f1:
		t
		QED
		
		Lemma 1:
		t
		QED
		''')
		Assertions.assertNotNull(result)
		println(dump(result, "	"))
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@Test
	def void foo() {
		val result = parseHelper.parse('''
		Lemma 2f1:
		 (implies (and (consp x)
		               (tlp x)
		               (tlp y)
		               (implies (and (tlp (rest x))
		                             (tlp y)
		                             (in2 a (app2 (rest x) y)))
		                        (or (in2 a (rest x)) (in2 a y)))
		               (in2 a (app2 x y))
		               (equal a (first x)))
		          (or (in2 a x) (in2 a y)))
		 
		 Context:
		 C1. (consp x)
		 C2. (tlp x)
		 C3. (tlp y)
		 C4. (implies (and (tlp (rest x))
		                   (tlp y)
		                   (in2 a (app2 (rest x) y)))
		              (or (in2 a (rest x)) (in2 a y)))
		 C5. (in2 a (app2 x y))
		 C6. (equal a (first x))
		 
		 Goal: (or (in2 a x) (in2 a y))
		 
		 Proof:
		 (or (in2 a x) (in2 a y))
		 == {Def in2}
		 (or (if (endp x) nil (or (equal a (first x)) (in2 a (rest x))))
		     (in2 a y))
		 == {C1}
		 (or (or (equal a (first x)) (in2 a (rest x)))
		     (in2 a y))
		 == {C6}
		 (or (or t (in2 a (rest x))) (in2 a y))
		 == {PL}
		 t
		 
		 QED
		 ''')
		Assertions.assertNotNull(result)
		val errors = result.eResource.errors
		Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	}
	
	@TestFactory
	def Stream<DynamicTest> testFiles() {
		Files.walk(Paths.get("../../tests/pass/"))
				.filter([file | Files.isRegularFile(file) && file.toString.endsWith(".lisp")])
	            .map([file | dynamicTest(
	                    "Test for file: " + file,
	                    [|  val contents = new String(Files.readAllBytes(file))
	                    	val result = parseHelper.parse(contents)
	                    	Assertions.assertNotNull(result)
							//println(dump(result, "	"))
							val errors = result.eResource.errors
							Assertions.assertTrue(errors.isEmpty, '''Unexpected errors: «errors.join(", ")»''')
	                    ])
	               ])
	}
	
}
